.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoFileRaster 3D "Dore"
.SH NAME
DoFileRaster \- Create a raster object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoFileRaster(filename, specialstring)
DtPtr filename;
DtPtr specialstring;
.sp
.in  -.5i
FORTRAN:
.in  +.5i
INTEGER*4 DOFRS(FNAME, FLEN, SPCSTR, SLEN)
INTEGER*4 FLEN
CHARACTER*FLEN FNAME
INTEGER*4 SLEN
CHARACTER*SLEN SPCSTR
.in  -.5i
.fi 
.IX "DoFileRaster"
.IX "DOFRS"
.SH DESCRIPTION
.LP
\f2DoFileRaster\fP creates a raster object.
Raster objects can, for example, be used as texture maps or as 
backgrounds for views.
.LP
The parameter \f2filename\fP is the name of a file containing raster data.
If the file is a standard Dore raster file then \f2specialstring\fP should
be set to \f2DcNullPtr\fP <\f2DCNULL\fP>.
Some renderers may require special file formats for raster data,
and the character string \f2specialstring\fP is used to specify the
format of the file.
.SH FORTRAN SPECIFIC
The parameter \f2FNAME\fP is the name of a file \f2FLEN\fP characters
long containing raster data.
The parameter \f2SPCSTR\fP is an optional format specification
which is \f2SLEN\fP characters in length.
.SH SEE ALSO
.na
.nh
DoRaster(3D), DsFileRasterRead(3D), DsInqRaster(3D), 
DsRasterUpdate(3D), 
DsRasterWrite(3D),
DvInqBackgroundRaster(3D), 
DvSetBackgroundRaster(3D)
.ad
.hy
\&
