.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DdInqShadeRanges 3D  "Dore"
.SH NAME
DdInqShadeRanges \- Return the shade range table entries of a device
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
void DdInqShadeRanges(device, start, count, entries)
DtObject device;
DtInt start;
DtInt count;
DtInt entries[\|];
.sp
.in -.5i
FORTRAN:
.in +.5i
CALL DDQSR(DEVICE, START, COUNT, ENTRYS)
INTEGER*4 DEVICE
INTEGER*4 START
INTEGER*4 COUNT
INTEGER*4 ENTRYS(COUNT*2)
.in -.5i
.fi
.SH DESCRIPTION
.IX DDQSR
.IX DdInqShadeRanges
.I DdInqShadeRanges
is used to query one or more shade range table entries from a
device, \f2device\fP.
.PP
Each entry in the shade range table consists of a pair of values defining a
shade range.  These values represent the color table index of the
beginning and end of the range.
One value represents the minimum shade value in a range,
and the other represents the maximum shade value in a range.
Intensities between 0.0 and 1.0 are used to linearly interpolate
between these two specified limits in the color lookup table.  This
interpolated color table index is then sent to the device's frame
buffer.
.PP
For a given shade range \f2i\fP, \f2entries[2*i]\fP is the start,
or minimum value of the range, and \f2entries[2*i+1]\fP is the end,
or maximum value of the range.
.PP
The parameter \f2start\fP specifies the first entry to be queried.
\f2count\fP specifies the number of entries to be read.
\f2entries\fP is an array containing the queried entries.
.PP
.SH ERRORS
.I DdInqShadeRanges
will fail if the device handle is invalid.
.TP 15
[WARNING - invalid device handle]
.PP
\f2DdInqShadeRanges\fP will also fail if the \f2start\fP or
\f2count\fP parameters
refer to entries outside the shade range table boundaries.
.TP 15
[WARNING - bad start and/or count values]
.SH "SEE ALSO"
.na
.nh
DdInqColorEntries(3D), DdInqColorTableSize(3D), DdInqShadeMode(3D),
DdInqVisualType(3D), DdSetColorEntries(3D), DdSetShadeMode(3D),
DdSetShadeRanges(3D), DoShadeIndex(3D)
.ad
.hy

