#include <sys/types.h>
#include <sys/syscall.h>

#include <stdio.h>

struct syscall {
  char *name;
  int   vec;
} syscalls[] = {
#define SYSTEM_CALL(func,vec) #func, vec,
#include <sys/syscall.def>
#undef SYSTEM_CALL
};
int nsyscall = sizeof(syscalls) / sizeof (syscalls[0]);

main()
{
  FILE *fp1, *fp2;
  struct syscall *sc;
  int i, v;

  for (i = 0, sc = syscalls; i < nsyscall; i++, sc++)
    {
      char name1[strlen (sc->name) + 3];
      char name2[sizeof (name1) + 1];
    
      v = -(sc->vec + 4)*6;
      
      sprintf (name1, "%s.s", sc->name);
      sprintf (name2, "%s.bs", sc->name);

      fp1 = fopen (name1, "w");
      fp2 = fopen (name2, "w");
      
      if (!fp1 || !fp2)
        {
          perror (sc->name);
          exit (20);
        }

      if (v > -128)
	{
	  fprintf (fp1, ".globl _%s; _%s: movel _ixemulbase, a0; lea a0@(%d),a0; jmp a0@\n", sc->name, sc->name, v);
	  fprintf (fp2, ".globl _%s; _%s: movel a4@(_ixemulbase:W), a0; lea a0@(%d),a0; jmp a0@\n", sc->name, sc->name, v);
	}
      else
	{
	  fprintf (fp1, ".globl _%s; _%s: movel _ixemulbase, a0; addw #%d,a0;  jmp a0@\n", sc->name, sc->name, v);
	  if (sc->vec == SYS_ix_geta4)
	    fprintf (fp2, ".globl _%s; _%s: movel _ixemulbase, a0; addw #%d,a0;  jmp a0@\n", sc->name, sc->name, v);
	  else
	    fprintf (fp2, ".globl _%s; _%s: movel a4@(_ixemulbase:W), a0; addw #%d,a0;  jmp a0@\n", sc->name, sc->name, v);
	}

      fclose (fp1);
      fclose (fp2);
    }
}

