/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.command;

import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.ListeningConnector;
import java.io.IOException;
import java.util.Map;
import jde.debugger.Application;
import jde.debugger.Debug;
import jde.debugger.JDEException;
import jde.debugger.Jdebug;
import jde.debugger.command.DebugSessionCommand;

public class ListenSocket
extends DebugSessionCommand {
    protected void doCommand() throws JDEException {
        if (this.args.size() < 1) {
            throw new JDEException("Missing name");
        }
        final String address = this.args.remove(0).toString();
        String connectSpec = "com.sun.jdi.SocketListen";
        final ListeningConnector connector = (ListeningConnector)this.getConnector(connectSpec);
        if (connector == null) {
            throw new JDEException("No such connector is available: " + connectSpec);
        }
        Thread thread = new Thread("Listen on socket."){

            public void run() {
                try {
                    Map<String, Connector.Argument> argumentMap = connector.defaultArguments();
                    Connector.Argument portArg = argumentMap.get("port");
                    portArg.setValue(address);
                    Jdebug.theDebugger.signalCommandResult(ListenSocket.this.appID, ListenSocket.this.cmdID);
                    Jdebug.theDebugger.signal(ListenSocket.this.appID, "message", "Listening at socket address: " + address);
                    connector.startListening(argumentMap);
                    VirtualMachine vm = connector.accept(argumentMap);
                    connector.stopListening(argumentMap);
                    Application app = new Application(Jdebug.theDebugger, ListenSocket.this.appID, vm);
                    if (Jdebug.theDebugger.appExists(ListenSocket.this.appID)) {
                        app.shutdown();
                        app.signal("message", "Error: An application with the same ID exists.");
                    }
                    Jdebug.theDebugger.addApplication(ListenSocket.this.appID, app);
                    app.signal("message", "Attached VM (socket) " + vm.description());
                }
                catch (IOException ex) {
                    Debug.printIf(ex);
                    Jdebug.theDebugger.signal(ListenSocket.this.appID, "message", "Error occured listening on socket.");
                }
                catch (IllegalConnectorArgumentsException ex) {
                    Jdebug.theDebugger.signal(ListenSocket.this.appID, "message", "Illegal connector arguments for connector '" + connector);
                }
            }
        };
        thread.start();
    }

    public Object clone() {
        return new ListenSocket();
    }
}

