/*
   This file is part of GNU Taler
   (C) 2021-2025 Taler Systems S.A.

   GNU Taler is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
   */

/**
 *
 * @author Martin Schanzenbach
 */

import {
    StatisticBucketRange,
  StatisticsAmount,
  StatisticsCounter,
} from "@gnu-taler/taler-util";

export function addTestValues(
  ordersStats: Map<string, StatisticsCounter>,
  revenueStats: Map<string, StatisticsAmount>,
) {
  // FIXME only for testing;
  const ordersCreated = {
    "intervals": [
     {
      "start_time": {
       "t_s": 1763155101
      },
      "cumulative_counter": 0
     },
     {
      "start_time": {
       "t_s": 1763155041
      },
      "cumulative_counter": 19
     },
     {
      "start_time": {
       "t_s": 1763154901
      },
      "cumulative_counter": 2
     },
     {
      "start_time": {
       "t_s": 1760153641
      },
      "cumulative_counter": 9
     }
    ],
    "buckets": [],
    "intervals_description": "number of orders created (but not necessarily claimed by wallets)"
  };
  const ordersClaimed = {
    "intervals": [
     {
      "start_time": {
       "t_s": 1763155101
      },
      "cumulative_counter": 5
     },
     {
      "start_time": {
       "t_s": 1763155041
      },
      "cumulative_counter": 19
     },
     {
      "start_time": {
       "t_s": 1763154901
      },
      "cumulative_counter": 2
     },
     {
      "start_time": {
       "t_s": 1763154641
      },
      "cumulative_counter": 9
     },
     {
      "start_time": {
       "t_s": 1760153641
      },
      "cumulative_counter": 3
     }
    ],
    "buckets": [],
    "intervals_description": "number of orders claimed"
  };
  const ordersPaid = {
    "intervals": [
     {
      "start_time": {
       "t_s": 1763155101
      },
      "cumulative_counter": 5
     },
     {
      "start_time": {
       "t_s": 1763155041
      },
      "cumulative_counter": 19
     },
     {
      "start_time": {
       "t_s": 1763154901
      },
      "cumulative_counter": 2
     },
     {
      "start_time": {
       "t_s": 1763154641
      },
      "cumulative_counter": 9
     },
     {
      "start_time": {
       "t_s": 1760153641
      },
      "cumulative_counter": 3
     }
     ],
    "buckets": [],
    "intervals_description": "number of orders paid"
  };
  const ordersSettled = {
    "intervals": [
     {
      "start_time": {
       "t_s": 1763155101
      },
      "cumulative_counter": 4
     },
     {
      "start_time": {
       "t_s": 1763155041
      },
      "cumulative_counter": 19
     },
     {
      "start_time": {
       "t_s": 1763154901
      },
      "cumulative_counter": 2
     },
     {
      "start_time": {
       "t_s": 1763154641
      },
      "cumulative_counter": 9
     },
     {
      "start_time": {
       "t_s": 1760153641
      },
      "cumulative_counter": 3
     }
     ],
    "buckets": [],
    "intervals_description": "number of orders settled"
  }
  const depositFees: StatisticsAmount = {
    "intervals": [],
    "buckets": [
     {
      "start_time": {
       "t_s": 1763157600
      },
      "end_time": {
       "t_s": 1763078400
      },
      "range": StatisticBucketRange.Hour,
      "cumulative_amounts": [
       "EUR:0.11"
      ]
     },
     {
      "start_time": {
       "t_s": 1763078400
      },
      "end_time": {
       "t_s": 1763164800
      },
      "range": StatisticBucketRange.Day,
      "cumulative_amounts": [
       "EUR:0.21"
      ]
     },
     {
      "start_time": {
       "t_s": 1762732800
      },
      "end_time": {
       "t_s": 1763337600
      },
      "range": StatisticBucketRange.Week,
      "cumulative_amounts": [
       "EUR:0.31"
      ]
     },
     {
      "start_time": {
       "t_s": 1761955200
      },
      "end_time": {
       "t_s": 1764547200
      },
      "range": StatisticBucketRange.Month,
      "cumulative_amounts": [
       "EUR:0.51"
      ]
     },
     {
        "start_time": {
          "t_s": 1751328000
        },
        "end_time": {
          "t_s": 1759276800
        },
        "range": StatisticBucketRange.Quarter,
        "cumulative_amounts": [
          "EUR:3.10"
        ]
      },
      {
      "start_time": {
       "t_s": 1759276800
      },
      "end_time": {
       "t_s": 1767225600
      },
      "range": StatisticBucketRange.Quarter,
      "cumulative_amounts": [
       "EUR:1.11"
      ]
     },
     {
      "start_time": {
       "t_s": 1735689600
      },
      "end_time": {
       "t_s": 1767225600
      },
      "range": StatisticBucketRange.Year,
      "cumulative_amounts": [
       "EUR:2.11"
      ]
     }
    ],
    "buckets_description": "deposit fees we or our customers paid to the exchange (includes those waived on refunds)"
  }
  const paymentsReceived: StatisticsAmount = {
    "intervals": [],
    "buckets": [
      {
        "start_time": {
          "t_s": 1763146800
        },
        "end_time": {
          "t_s": 1763078400
        },
        "range": StatisticBucketRange.Hour,
        "cumulative_amounts": [
          "EUR:4.89"
        ]
      },
      {
        "start_time": {
          "t_s": 1763078400
        },
        "end_time": {
          "t_s": 1763164800
        },
        "range": StatisticBucketRange.Day,
        "cumulative_amounts": [
          "EUR:14.89"
        ]
      },
      {
        "start_time": {
          "t_s": 1762732800
        },
        "end_time": {
          "t_s": 1763337600
        },
        "range": StatisticBucketRange.Week,
        "cumulative_amounts": [
          "EUR:27.89"
        ]
      },
      {
        "start_time": {
          "t_s": 1761955200
        },
        "end_time": {
          "t_s": 1764547200
        },
        "range": StatisticBucketRange.Month,
        "cumulative_amounts": [
          "EUR:34.89"
        ]
      },
      {
        "start_time": {
          "t_s": 1751328000
        },
        "end_time": {
          "t_s": 1759276800
        },
        "range": StatisticBucketRange.Quarter,
        "cumulative_amounts": [
          "EUR:18.99"
        ]
      },
      {
        "start_time": {
          "t_s": 1759276800
        },
        "end_time": {
          "t_s": 1767225600
        },
        "range": StatisticBucketRange.Quarter,
        "cumulative_amounts": [
          "EUR:34.89"
        ]
      },
      {
        "start_time": {
          "t_s": 1735689600
        },
        "end_time": {
          "t_s": 1767225600
        },
        "range": StatisticBucketRange.Year,
        "cumulative_amounts": [
          "EUR:54.89"
        ]
      }
    ],
    "buckets_description": "amount customers paid to us (excluded deposit fees paid by us or customers, wire fees are still deducted by the exchange)"
  }
  const testRefundsBuckets: StatisticsAmount = {
    intervals:  [],
    buckets: [
      {
        "start_time": {
          "t_s": 1763146800
        },
        "end_time": {
          "t_s": 1763078400
        },
        "range": StatisticBucketRange.Hour,
        "cumulative_amounts": [
          "EUR:0"
        ]
      },
      {
        "start_time": {
          "t_s": 1763078400
        },
        "end_time": {
          "t_s": 1763164800
        },
        "range": StatisticBucketRange.Day,
        "cumulative_amounts": [
          "EUR:2"
        ]
      },
      {
        "start_time": {
          "t_s": 1762732800
        },
        "end_time": {
          "t_s": 1763337600
        },
        "range": StatisticBucketRange.Week,
        "cumulative_amounts": [
          "EUR:3"
        ]
      },
      {
        "start_time": {
          "t_s": 1761955200
        },
        "end_time": {
          "t_s": 1764547200
        },
        "range": StatisticBucketRange.Month,
        "cumulative_amounts": [
          "EUR:4"
        ]
      },
      {
        "start_time": {
          "t_s": 1751328000
        },
        "end_time": {
          "t_s": 1759276800
        },
        "range": StatisticBucketRange.Quarter,
        "cumulative_amounts": [
          "EUR:8"
        ]
      },
      {
        "start_time": {
          "t_s": 1759276800
        },
        "end_time": {
          "t_s": 1767225600
        },
        "range": StatisticBucketRange.Quarter,
        "cumulative_amounts": [
          "EUR:6"
        ]
      },
      {
        "start_time": {
          "t_s": 1735689600
        },
        "end_time": {
          "t_s": 1767225600
        },
        "range": StatisticBucketRange.Year,
        "cumulative_amounts": [
          "EUR:7",
          "KUDOS:23"
        ]
      }
    ],
    "buckets_description": "refunds granted by us to our customers"
  }
  ordersStats.set("orders-created", ordersCreated);
  ordersStats.set("orders-claimed", ordersClaimed);
  ordersStats.set("orders-paid", ordersPaid);
  ordersStats.set("orders-settled", ordersSettled);
  revenueStats.set("payments-received-after-deposit-fee", paymentsReceived);
  revenueStats.set("total-deposit-fees-paid", depositFees);
  revenueStats.set("refunds-granted", testRefundsBuckets);
}
