/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 *
 * @author Sebastian Javier Marchano (sebasjm)
 */

import { AmountString, Amounts, ScopeType, parsePayUri, parsePaytoUri } from "@gnu-taler/taler-util";
import { expect } from "chai";
import { createWalletApiMock } from "../../test-utils.js";
import { useComponentState } from "./state.js";
import * as tests from "@gnu-taler/web-util/testing";
import { Props } from "./index.js";
import { WalletApiOperation } from "@gnu-taler/taler-wallet-core";

describe("Deposit CTA states", () => {

  it("should be ready after loading", async () => {
    const { handler, TestingContext } = createWalletApiMock();

    handler.addWalletCallResponse(
      WalletApiOperation.CheckDeposit,
      undefined,
      {
        effectiveDepositAmount: "EUR:0" as AmountString,
        totalDepositCost: "EUR:0" as AmountString,
        fees: {
          coin: "EUR:0" as AmountString,
          refresh: "EUR:0" as AmountString,
          wire: "EUR:0" as AmountString,
        },
      },
    );

    const props = {
      account: parsePaytoUri("payto://refund/asdasdas")!,
      scope: {
        type: ScopeType.Global as const,
        currency: "EUR",
      },
      cancel: async () => {
        null;
      },
      onSuccess: async () => {
        null;
      },
    };

    const hookBehavior = await tests.hookBehaveLikeThis(
      useComponentState,
      props,
      [
        // ({ status }) => {
        //   expect(status).equals("loading");
        // },
        (state) => {
          if (state.status !== "ready") expect.fail();
          if (state.error) expect.fail();
          expect(state.confirm.onClick).to.be.undefined;
          expect(state.amount.value).deep.eq(Amounts.parseOrThrow("EUR:0"));
          expect(state.cost).deep.eq(Amounts.parseOrThrow("EUR:0"));
          expect(state.fee).deep.eq(Amounts.parseOrThrow("EUR:0"));
          expect(state.effective).deep.eq(Amounts.parseOrThrow("EUR:0"));
        },
        (state) => {
          if (state.status !== "ready") expect.fail();
          if (state.error) expect.fail();
          expect(state.confirm.onClick).to.be.undefined;
          expect(state.amount.value).deep.eq(Amounts.parseOrThrow("EUR:0"));
          expect(state.cost).deep.eq(Amounts.parseOrThrow("EUR:0"));
          expect(state.fee).deep.eq(Amounts.parseOrThrow("EUR:0"));
          expect(state.effective).deep.eq(Amounts.parseOrThrow("EUR:0"));
        },
      ],
      TestingContext,
    );

    expect(hookBehavior).deep.equal({ result: "ok" });
    expect(handler.getCallingQueueState()).eq("empty");
  });
});
