BEGIN;
SELECT _v.register_patch('donau-0002', NULL, NULL);
SET search_path TO donau;
CREATE DOMAIN gnunet_hashcode
  AS BYTEA
  CHECK(LENGTH(VALUE) = 32);
CREATE TYPE taler_amount
  AS
  (val INT8
  ,frac INT4
  );
COMMENT ON TYPE taler_amount
  IS 'Stores an amount, fraction is in units of 1/100000000 of the base value';
CREATE TABLE donation_units
  (donation_unit_serial BIGINT GENERATED BY DEFAULT AS IDENTITY UNIQUE
  ,h_donation_unit_pub BYTEA PRIMARY KEY CHECK (LENGTH(h_donation_unit_pub)=64)
  ,donation_unit_pub BYTEA UNIQUE NOT NULL
  ,validity_year INT8 NOT NULL
  ,value taler_amount NOT NULL
  );
COMMENT ON TABLE donation_units
  IS 'Main donation_unit table. All the valid donation units the Donau knows about.';
COMMENT ON COLUMN donation_units.h_donation_unit_pub
  IS 'Hash value of the donation unit public key.';
COMMENT ON COLUMN donation_units.validity_year
  IS 'The year, for which the donation unit is valid.';
COMMENT ON COLUMN donation_units.value
  IS 'The amount and currency that this donation unit represents.';
CREATE TABLE charities
  (charity_id BIGINT GENERATED BY DEFAULT AS IDENTITY UNIQUE
  ,charity_pub BYTEA PRIMARY KEY CHECK (LENGTH(charity_pub)=32)
  ,charity_name TEXT NOT NULL
  ,charity_url TEXT NOT NULL
  ,max_per_year taler_amount NOT NULL
  ,receipts_to_date taler_amount NOT NULL DEFAULT (0,0)
  ,current_year INT4 NOT NULL
  );
COMMENT ON TABLE charities
  IS 'Table with public keys of all recognized charities.';
COMMENT ON COLUMN charities.charity_pub
  IS 'Charity EdDSA public key.';
COMMENT ON COLUMN charities.max_per_year
  IS 'The annual donation limit according to local law.';
COMMENT ON COLUMN charities.receipts_to_date
  IS 'The current amount of donations in the current year. Reset to 0 when incrementing the current_year (but remember historic values in history table when doing so).';
CREATE TABLE history
  (charity_id BIGINT PRIMARY KEY REFERENCES charities (charity_id) ON DELETE CASCADE
  ,final_amount taler_amount NOT NULL
  ,donation_year INT8 NOT NULL
  );
COMMENT ON TABLE history
  IS 'Table containing the yearly donation amount for each charity.';
COMMENT ON COLUMN history.final_amount
  IS 'Final donation amount that the charity received.';
CREATE TABLE receipts_issued
  (receipt_id BIGINT GENERATED BY DEFAULT AS IDENTITY UNIQUE
  ,blinded_sig BYTEA[] NOT NULL
  ,charity_id BIGINT NOT NULL REFERENCES charities (charity_id) ON DELETE CASCADE
  ,receipt_hash BYTEA PRIMARY KEY CHECK (LENGTH(receipt_hash)=64)
  ,amount taler_amount NOT NULL
  );
COMMENT ON TABLE receipts_issued
  IS 'Table containing the issued blinded donation receipts.';
COMMENT ON COLUMN receipts_issued.blinded_sig
  IS 'Array of blinded signatures. Blind signed BKPs by the Donau';
COMMENT ON COLUMN receipts_issued.receipt_hash
  IS 'Hash value over all the blinded donation receipt received plus the hash of the donation units public key.';
CREATE TABLE receipts_submitted
  (receipt_id BIGINT GENERATED BY DEFAULT AS IDENTITY UNIQUE
  ,h_tax_number BYTEA NOT NULL
  ,nonce BYTEA NOT NULL UNIQUE CHECK (LENGTH(nonce)=32)
  ,h_donation_unit_pub BYTEA NOT NULL REFERENCES donation_units (h_donation_unit_pub)
  ,donation_unit_sig BYTEA NOT NULL UNIQUE
  ,donation_year INT8 NOT NULL
  );
COMMENT ON TABLE receipts_submitted
  IS 'Table containing the donation receips submitted from the donor.';
COMMENT ON COLUMN receipts_submitted.h_tax_number
  IS 'The hash of the tax number and salt.';
COMMENT ON COLUMN receipts_submitted.nonce
  IS 'The nonce used in the Unique Donor Identifier.';
COMMENT ON COLUMN receipts_submitted.h_donation_unit_pub
  IS 'Reference to public key used to sign.';
COMMENT ON COLUMN receipts_submitted.donation_unit_sig
  IS 'The unblided signature the Donau made.';
CREATE TABLE donau_sign_keys
  (dsk_serial BIGINT GENERATED BY DEFAULT AS IDENTITY UNIQUE
  ,donau_pub BYTEA PRIMARY KEY CHECK (LENGTH(donau_pub)=32)
  ,valid_from INT8 NOT NULL
  ,expire_sign INT8 NOT NULL
  ,expire_legal INT8 NOT NULL
  );
COMMENT ON TABLE donau_sign_keys
  IS 'Table with all Donau EdDSA signing keys.';
COMMENT ON COLUMN donau_sign_keys.donau_pub
  IS 'Donau EdDSA public key.';
COMMENT ON COLUMN donau_sign_keys.valid_from
  IS 'Time when this signing key will first be used to sign messages.';
COMMENT ON COLUMN donau_sign_keys.expire_sign
  IS 'Time when this signing key will no longer be used to sign.';
COMMENT ON COLUMN donau_sign_keys.expire_legal
  IS 'Time when this signing key legally expires.';
COMMIT;
