/* mod.c

   written by Don Maszle
   15 September 1991
   
   Copyright (c) 1993.  Don Maszle, Frederic Bois.  All rights reserved.

   -- Revisions -----
     Logfile:  SCCS/s.mod.c
    Revision:  1.1
        Date:  7/14/93
     Modtime:  19:11:14
      Author:  @a
   -- SCCS  ---------

   Entry point for model code generator.

   Calls ReadModel() to define the model and WriteModel() to create
   the output file.
   
   The INPUTINFO struct is defined as follows:
     
     wContext	:	A flag for the current context of the input. 

     pvmGloVars :       Vars of type ID_LOCAL* are accessible
                        only within the respective section.  If
		        states are given a value outside of the
			Dynamics section, it is used as an INITIAL
			value, otherwise they are initialized to 0.0. 

     pvmDynEqns:	List of equations to go into the CalcDeriv(),
     pvmJacobEqns:	Jacobian(), and ScaleModel() routines, respectively.
     pvmScaleEqns:	The LHS of equations of state variables in Dynamics
			are actually dt().  The hType field gives the type of
			the LHS and also a flag for space in the uppermost
			bit.
     pvmCalcOutEqns:    List of equations to into CalcOutputs().  These
                        can be used to scale output variables *only*.
                        The routinine is called just be outputting
                        values specified in Print().
*/

#ifdef __LOCAL_HDR__
#include "stdlib.h"
#include "stdio.h"
#include "string.h"

#else
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#endif

#include "mod.h"


/***********************************************************************
   main -- Entry point for the PBPK simulation model preprocessor
   
*/

int main (int nArg, PSTR rgszArg[])
{
  INPUTINFO info;

  fprintf (stderr, "\nModel Generator Program %s\n", VSZ_VERSION);
  fprintf (stderr, "All rights reserved.\n\n");
/*.   fprintf (stderr, "          School of Public Health.\n\n"); */

#ifdef ndef
  {
    int i;
    for (i = 0; i < nArg; i++)
      printf ("%s%s", rgszArg[i], (i < nArg -1) ? " " : "");
    printf ("\n");
  }  /* block */
#endif

  if (nArg == 2 || nArg == 3 ) {
    ReadModel (&info, rgszArg[1]);
    WriteModel (&info, nArg, rgszArg);
    
  }  /* if */
  
  else {
    printf ("Usage: %s  [input-file  [output-file]]\n", rgszArg[0]);
    printf ("  Creates file 'model.c' according to input-file specs\n");
  }  /* else */

  return 0;
}  /* main */
