/* $XConsortium: cfbbres.c,v 1.2 94/04/17 20:32:15 dpw Exp $ */
/***********************************************************

Copyright (c) 1987  X Consortium

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from the X Consortium.


Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Digital not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/
/* $XConsortium: cfbbres.c,v 1.2 94/04/17 20:32:15 dpw Exp $ */
#include "X.h"
#include "misc.h"
#include "cfb.h"
#include "miline.h"
#include "cfbmskbits.h"
#include "servermd.h"
#include "fastblt.h"
#include "vgaBank.h"

/* Solid bresenham line */
/* NOTES
   e2 is used less often than e1, so it's not in a register
*/

void
cfbBresS(rop, and, xor, addrl, nlwidth, signdx, signdy, axis, x1, y1,
            e, e1, e2, len)
int		rop;
unsigned long	and, xor;
unsigned long	*addrl;		/* pointer to base of bitmap */
int		nlwidth;	/* width in longwords of bitmap */
register int	signdx;
int		signdy;		/* signs of directions */
int		axis;		/* major axis (Y_AXIS or X_AXIS) */
int		x1, y1;		/* initial point */
register int	e;		/* error accumulator */
register int	e1;		/* bresenham increments */
int		e2;
int		len;		/* length of line */
{
  register unsigned char *addrb;		/* bitmask long pointer 
					     	 * cast to char pointer */
  register unsigned char Oflag, Uflag;
  register int e3 = e2-e1;
  int gendir = signdx + signdy;
  
  
  if (len == 0)
    return;
  
  BANK_FLAG(addrl)
  Oflag = (vgaWriteFlag && ((gendir == 2) || (gendir == 0)));
  Uflag = (vgaWriteFlag && ((gendir == -2) || (gendir == 0)));

  /* point to first point */
  nlwidth <<= 2;
  addrb = (unsigned char *)(addrl) + (y1 * nlwidth) + x1;
  if (signdy < 0)
    nlwidth = -nlwidth;
  e = e-e1;			/* to make looping easier */
  
  if (axis == Y_AXIS)
    {
      int	t;
      
      t = nlwidth;
      nlwidth = signdx;
      signdx = t;
    }
  
  SETRW(addrb);

#ifdef SPEEDUP
if (rop == GXcopy)
  while(len--)
    { 
      *addrb = xor; 
      e += e1;
      if (e >= 0)
	{
	  addrb += nlwidth;
	  e += e3;
	}
      addrb += signdx;
      CHECKRWO(addrb);
      CHECKRWU(addrb);
    }
else
#endif

  DuffL (len, label1,
	 *addrb = DoRRop (*addrb, and, xor);
	 e += e1;
	 if (e >= 0)
	 {
	   addrb += nlwidth;
	   e += e3;
	 }
	 addrb += signdx;
	 CHECKRWOF(Oflag, addrb);
	 CHECKRWUF(Uflag, addrb);)
}

