/* util.c by Rob McCool, some modifications by Reinier Post */
/* and one routine from the radio distribution */

/*
 * $Log: util.c,v $
 * Revision 0.15  1994/05/18  08:00:59  reinpost
 * *** empty log message ***
 *
 * Revision 0.13  1994/05/03  19:32:59  reinpost
 * *** empty log message ***
 *
 * Revision 0.13  1994/05/03  19:32:59  reinpost
 * *** empty log message ***
 *
 * Revision 0.11  1994/03/25  20:48:07  reinpost
 * system stuff taken to system.c
 *
 * Revision 0.11  1994/03/25  20:48:07  reinpost
 * system stuff taken to system.c
 *
 * Revision 0.10  1994/03/11  13:41:55  reinpost
 * trivial changes
 *
 * Revision 0.9  1994/03/02  21:26:08  reinpost
 * string conversion routines and simple pattern matching routine added
 *
 * Revision 0.6  1994/02/17  21:26:31  reinpost
 * *** empty log message ***
 *
 * Revision 0.6  1994/02/17  21:26:31  reinpost
 * *** empty log message ***
 *
 * Revision 0.5  1994/02/17  10:27:37  reinpost
 * some modifications - partly by merging in NCSA httpd 1.1 code
 *
 * Revision 0.4  1994/02/10  12:53:49  reinpost
 * added the routine strsubfirst from NCSA httpd 1.0 code
 * removed the untested and unfinished routines from CERN's libwww
 *
 * Revision 0.3  1994/02/01  19:59:58  reinpost
 * incorporated the util_needs header file which was silly
 * incorporated the skip_whitespace routine from html.c
 * and another whitespace related routine
 * the routines at the bottom are a load of crap - should be taken out
 *
 * Revision 0.2  1994/01/25  15:02:10  reinpost
 * logging is now in log.c
 *
 * Revision 0.1  1994/01/20  12:21:35  reinpost
 * this is originally from NCSA httpd 1.0a4, partly updated to the 1.0a5
 * versions, and I'd rather call the NCSA 1.0 routines directly because
 * the code is not exactly stable
 *
 */

static char rcsid[] =
  "$Id: util.c,v 0.15 1994/05/18 08:00:59 reinpost Exp reinpost $";

#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <sys/socket.h>
#include <ctype.h>
#include <sys/errno.h>
#include <errno.h>
#include <time.h>  /* for ctime */
#include <sys/time.h>  /* for timeval in read_one_line */
#include <netinet/in.h>
#include <netdb.h>
#include <sys/ioctl.h>
#include <arpa/inet.h>  /* for inet_ntoa */
#include <sys/wait.h>
#include <pwd.h>
#include <grp.h>
/* it doesn't really need all of these ... */

#include "system.h"

#include "constants.h"
#include "log.h"        /* there's one log_error() call */
#include "error.h"	/* necessary in getline_timed_out */
#include "unistd.h"	/* for alarm() */

/* pattern matching, very simple: only a wildcard is recognized */
/* '*' stands for 1 or more arbitrary characters */

/* forward */ int match (char *pattern, char *s);

static int amatch (char *pattern, char *s)
/* anchored match: match pattern in s starting at the first character */
{
  if (!*pattern) return(1);
  if (!*s) return(0);
  if (*pattern == '*') return(match(&pattern[1],&s[1]));
  return(*pattern == *s && amatch(&pattern[1],&s[1]));
}

int match (char *pattern, char *s)
/* match pattern anywhere in s */
{
  /* the naive method - very inefficient */
  return(amatch(pattern,s) || (*s && match(pattern,&s[1])));
}

/* some auxiliary conversion routines: string to xxx */

int stringtobool(char *value)
{
  int result;

  if (value && !strcmp(value,"1"))
    result = 1;
  else if (value && !strcmp(value,"0"))
    result = 0;
  else
    result = -1;
  return(result);
}

int stringtoint(char *value)
{
  int result;

  if (!value || !(result = atoi(value)))
  /* the number 0 is always an incorrect result ... */
  {
    result = -1;
  }
  return(result);
}

#define is_a_digit(c) (c >= '0' && c <= '9')

static int time_str(char **s, char unit)
/* scans the string starting from the left */
/* requiring the pattern ^[0-9]+c where c is the character given in unit */
/* returns -1 if the pattern didn't match, or the number scanned if it did */
/* in the latter case, moves *s past the scanned input */
{
  char *number;
  int numlen;
  int result;
  char *s2 = *s;

  if (!is_a_digit(*s2)) return(-1);
  while (is_a_digit(*s2)) ++s2;
  if (*s2 != unit) return(-1);
  numlen = s2-*s;
  number = (char *)malloc(numlen+1);
  strncpy(number,*s,numlen);
  number[numlen] = '\0';
  *s = &s2[1];
  result = atoi(number);
  free(number);
  return(result);
}

int stringtotime(char *value)
{
  int weeks = 0, days = 0, hours = 0, minutes = 0, seconds = 0;
  char *s = value;

  if (!s || !*s) return(-1);

  weeks = time_str(&s,'w');
  days = time_str(&s,'d');
  hours = time_str(&s,'h');
  minutes = time_str(&s,'m');
  seconds = time_str(&s,'s');

  if (seconds < 0 && is_a_digit(*s))
  /* maybe the 's' was missing, for example, it was a plain number */
  {
    char *s2 = s;
    if (is_a_digit(*s2))
    {
      while (is_a_digit(*s2)) ++s2;
      if (!*s2)
      {
	/* remainder consisted of a number */
	seconds = atoi(s);
        s = s2;
      }
      else
      {
	return(-1);
      }
    }
    else
    {
      return(-1);
    }
  }

  if (*s)  /* some input is left */
  {
    return(-1);
  }
 
  if (weeks < 0) weeks = 0;
  if (days < 0) days = 0;
  if (hours < 0) hours = 0;
  if (minutes < 0) minutes = 0;
  if (seconds < 0) seconds = 0;

  return(weeks*WEEK + days*DAY + hours*HOUR + minutes*MINUTE + seconds);
}

/* from radio */

/*
 * Read "n" bytes from a descriptor.
 * Use in place of read() when fd is a stream socket
 *
 * Returns the number of total bytes read.
 */

int
readn(fd, ptr, nbytes)
int fd;
char *ptr;
int nbytes;
{
	int nleft, nread;

	nleft = nbytes;
	while (nleft > 0) {
	        nread = read(fd, ptr, nleft);
	        if (nread < 0)
	                return(nread);  /* error, return <0 */
	        else if (nread == 0)    /* EOF */
	                break;
	
	        nleft   -= nread;
	        ptr     += nread;
	}
	return(nbytes - nleft); /* return >= 0) */
}

/* Rob McCool's httpd_util.c stuff, adapted */

void strsubfirst(int start,char *dest, char *src)
{
    char tmp[MAX_STRING_LEN];

    strcpy(tmp,&dest[start]);
    strcpy(dest,src);
    strcpy(&dest[strlen(src)],tmp);
}

void getline_timed_out() {
    char errstr[MAX_STRING_LEN];

    sprintf(errstr,"timed out waiting for %s","the remote host");
    /* not the env_remote_name which gives the client's (local) host */
    log_error(errstr);
    die(DIE_TIME,errstr);
}

int getline(char *s, int n, int f, unsigned int timeout) {
    register int i=0;
    signal(SIGALRM,getline_timed_out);
    alarm(timeout);
    while(1) {
        if(read(f,&s[i],1) <= 0) {
            s[i] = '\0';
            return 1;
        }
        if(s[i] == CR)
            read(f,&s[i],1);

        if((s[i] == LF) || (i == (n-1))) {
            alarm(0);
            signal(SIGALRM,SIG_IGN);
            s[i] = '\0';
            return 0;
        }
        ++i;
    }
}

void getword(char *word, char *line, char stop) {
    int x = 0,y;

    for(x=0;((line[x]) && (line[x] != stop));x++)
	word[x] = line[x];

    word[x] = '\0';
    if(line[x]) ++x;
    y=0;

    while((line[y++] = line[x++]));
}

void getword2(char *word, char *line, char stop)
/* like getword, but leaves l untouched in case stop isn't found */
{
  char *l = strdup(line);
  getword(word,line,stop);
  if (!line[0] && l[0])
    /* stop was not found in line; reset it */
    strcpy(line,l);
  free(l);
}

void skip_whitespace (char **s)  /* by RP */
{
  while (**s && isspace(**s)) ++*s;
}

void cfg_getword(char *word, char *line) {
    int x=0,y;
    
    for(x=0;line[x] && isspace(line[x]);x++);
    y=0;
    while(1) {
        if(!(word[y] = line[x]))
            break;
        if(isspace(line[x]))
            if((!x) || (line[x-1] != '\\'))
                break;
        if(line[x] != '\\') ++y;
        ++x;
    }
    word[y] = '\0';
    while(line[x] && isspace(line[x])) ++x;
    for(y=0;(line[y] = line[x]);++x,++y);
}

int cfg_getline(char *s, int n, FILE *f) {
    register int i=0;
    register char c;

    s[0] = '\0';
    /* skip leading whitespace */
    while(1) {
        c=(char)fgetc(f);
        if((c != '\t') && (c != ' '))
            break;
    }
    while(1) {
        if((c == '\t') || (c == ' ')) {
            s[i++] = ' ';
            while((c == '\t') || (c == ' ')) 
                c=(char)fgetc(f);
        }
        if(c == CR) {
            c = fgetc(f);
        }
        if((c == 0x4) || (c == LF) || (i == (n-1))) {
            /* blast trailing whitespace */
            while(i && (s[i-1] == ' ')) --i;
            s[i] = '\0';
            return (feof(f) ? 1 : 0);
        }
        s[i] = c;
        ++i;
        c = (char)fgetc(f);
    }
}

void skipspace(char *line)  /* by RP */
{
  int x = 0, y = 0;
  for (x = 0; isspace(line[x]); ++x);
  while ((line[y++] = line[x++]));
}

void plustospace(char *str) {
    register int x;

    for(x=0;str[x];x++) if(str[x] == '+') str[x] = ' ';
}

void spacetoplus(char *str) {
    register int x;

    for(x=0;str[x];x++) if(str[x] == ' ') str[x] = '+';
}

int ind(char *s, char c) {
    register int x;

    for(x=0;s[x];x++)
        if(s[x] == c) return x;

    return -1;
}

int rind(char *s, char c) {
    register int x;
    for(x=strlen(s) - 1;x != -1; x--)
        if(s[x] == c) return x;
    return -1;
}

char x2c(char *what) {
    register char digit;

    digit = ((what[0] >= 'A') ? ((what[0] & 0xdf) - 'A')+10 : (what[0] - '0'));
    digit *= 16;
    digit += (what[1] >= 'A' ? ((what[1] & 0xdf) - 'A')+10 : (what[1] - '0'));
    return(digit);
}

void unescape_url(char *url) {
    register int x,y;

    for(x=0,y=0;url[y];++x,++y) {
        if((url[x] = url[y]) == '%') {
            url[x] = x2c(&url[y+1]);
            y+=2;
        }
    }
    url[x] = '\0';
}

#define c2x(what,where) sprintf(where,"%%%2x",what)

void escape_url(char *url) {
    register int x,y;
    char *copy;

    copy = strdup(url);
            
    for(x=0,y=0;copy[x];x++,y++) {
        if(ind("% ?+&",url[y] = copy[x]) != -1) {
            c2x(copy[x],&url[y]);
            y+=2;
        }
    }
    url[y] = '\0';
    free(copy);
}

void escape_url_with_slashes(char *url) {
    register int x,y;
    char *copy;

    copy = strdup(url);
            
    for(x=0,y=0;copy[x];x++,y++) {
        if(ind("% ?+&/",url[y] = copy[x]) != -1) {
            c2x(copy[x],&url[y]);
            y+=2;
        }
    }
    url[y] = '\0';
    free(copy);
}

int is_url(char *u) {
    register int x;

    for(x=0;u[x] != ':';x++)
	if((!u[x]) || (!isalpha(u[x])))
	    return 0;

    if((u[x+1] == '/') && (u[x+2] == '/'))
	return 1;
    else return 0;
}

/*
void send_fd(FILE *f, FILE *fd) {
    int num_chars=0;
    char c;

   while (1) {
	c = fgetc(f);
	if(feof(f))
	    return;
	fputc(c,fd);
    }
}
*/

void send_fd(FILE *f, FILE *fd)
/* somewhat better, but plain read() and write() would do for our purposes */
{
  char buf[BIG_BUF_LEN+1];
  int nb;

  while (!feof(f))
  {
    nb = fread(buf,1,BIG_BUF_LEN,f);
    fwrite(buf,1,nb,fd);
  }
}
