/* config.h - cacheing script configuration */
/* Reinier Post, reinpost@win.tue.nl */

/* most of these are the values used with our local httpd server */

/*
 * $Log: config.h,v $
 * Revision 0.14  1994/05/17  13:38:55  reinpost
 * new t directive
 *
 * Revision 0.14  1994/05/17  13:38:55  reinpost
 * new t directive
 *
 * Revision 0.13  1994/05/03  19:30:57  reinpost
 * *** empty log message ***
 *
 * Revision 0.11  1994/03/25  20:44:42  reinpost
 * *** empty log message ***
 *
 * Revision 0.11  1994/03/25  20:44:42  reinpost
 * *** empty log message ***
 *
 * Revision 0.10  1994/03/11  13:37:58  reinpost
 * adjusted interfaace with cache.c; one new URL related variable
 *
 * Revision 0.9  1994/03/02  21:23:44  reinpost
 * some new variables
 *
 * Revision 0.8  1994/02/25  20:23:05  reinpost
 * dynamic allocation for strings
 * modified interfaces
 * new time valued configurables
 *
 * Revision 0.7  1994/02/18  13:18:40  reinpost
 * *** empty log message ***
 *
 * Revision 0.5  1994/02/17  10:21:12  reinpost
 * *** empty log message ***
 *
 * Revision 0.5  1994/02/17  10:21:12  reinpost
 * *** empty log message ***
 *
 * Revision 0.4  1994/02/10  10:58:44  reinpost
 * env parameters are now supplied in global variables env_*
 * through the read_parameters() function
 *
 * some more slight changes in where things are done
 *
 * Revision 0.3  1994/02/01  19:42:23  reinpost
 * this is for configuration parameters that can be set from the configuration
 * file.  parameters read from environment variables will also be here in the
 * next version
 *
 * Revision 0.2  1994/01/25  14:57:51  reinpost
 * added logfile conf. and CACHE_CONF which should have been there already
 */

#include "constants.h"

/* configuration file; placing it with the server configuration files */
/* this is normally overriden with -DCACHE_CONF in the Makefile - see there */

/* what is my version number? RCS fills this string, read_config() */
/* extracts the version number into cache_version */
#define RCS_VERSION "$Revision: 0.14 $"

#ifndef CACHE_CONF
#define CACHE_CONF "/usr/local/etc/httpd/conf/cache.conf"
#endif

/* where to put the cached files? */
#define DEFAULT_CACHE_ROOT "/usr/local/etc/httpd/mirror"

/* cache finds out that the real prefix is http://whateveritshouldbe/mirror/ */
/* this prefix is only used in translating URLs */
#define DEFAULT_CACHE_PREFIX "/mirror/"

/* so we must configure the server to translate this to the former ... */
/* for example, in NCSA httpd, use the ScriptAlias keyword */
/* see the example srm.conf */

/* whether or not to cache query results; value must be 0 or 1 */
#define DEFAULT_CACHE_QUERIES 0

/* whether or not to escape slashes etc. when translating URLs to point	*/
/* back to the cache; value must be 0 or 1				*/
#define DEFAULT_TRANSLATE_ESCAPED 0

/* where to get the expire configuration file */
#define DEFAULT_EXPIRE_CONF "/usr/local/etc/httpd/conf/expire.conf"

/* where to get the mime.types file */
#define DEFAULT_MIME_CONF "/usr/local/etc/httpd/conf/mime.types"

/* what MIME type to use for files that have none */
#define DEFAULT_MIME_TYPE "text/plain"

/* time specifications */

/* the default timeout in waiting for MIME headers to be sent */
#define DEFAULT_TIMEOUT 2*MINUTE
/* used to be 20 minutes, which I think is a bit long */

/* the default last access age in seconds before a document is expired */
#define DEFAULT_A_EXP DAY

/* the default last modification age in seconds before a document is expired */
#define DEFAULT_M_EXP WEEK

/* the default refresh time threshold for not caching documents at all */
#define DEFAULT_THRESHOLD 0
/* meaning: everything with a refresh rate MORE than 0 seconds is cached */

/* for logging: */
#define DEFAULT_TRANSFER_LOGFILE "/usr/local/etc/httpd/logs/cache_log"
#define DEFAULT_ERROR_LOGFILE "/usr/local/etc/httpd/logs/cache-error_log"

/* where to put the database files: pid and dbm files */
/* make sure the script (probably user 'nobody') can write them */

#define DEFAULT_DB_DIR "/usr/local/etc/httpd/cache"

/* NON-RUNTIME-CONFIGURABLE PARAMETERS */

/* some names of files within this directory */
#define URL2FILE_NAME "url2file"
#define FILE2URL_NAME "file2url"
#define PIDFILE_NAME "cache.pid"
#define CASFILE_NAME ".cas"

/* the subdirectory of cache_root in which to place the translated files */
#define TR_SUBDIR "tr"

/* the prefix to indicate a forced cache refresh */
#define REFRESH_PREFIX "refresh/"

/* the prefix to indicate a proxy request */
#define PROXY_PREFIX "proxy/"

/* From the cache_conf configuration file, the following vars are set */

extern char *cache_version;  /* default set by RCS */

extern char *cache_root;
extern char *cache_prefix;
extern char *db_dir;
extern char *mime_types_confname;
extern char *expire_confname;
extern char *default_mime_type;
extern char *server_maintainer;
extern char *transfer_logfile;
extern char *error_logfile;
extern int cache_queries;
extern int translate_escaped;
extern int timeout;
extern int a_expires;
extern int m_expires;
extern int cache_threshold;

/* the following variables are set from environment variables		*/
/* some names may be confusing, e.g. remote_host is the client's host	*/
/* (which is often localhost), not the mirrored remote site		*/

/* parameters directly taken from environment variables */
extern char *env_server_software;
extern char *env_server_name;
extern char *env_gateway_interface;
extern char *env_server_protocol;
extern char *env_server_port;
extern char *env_request_method;
extern char *env_http_accept;
extern char *env_path_info;
extern char *env_path_translated;
extern char *env_script_name;
extern char *env_query_string;
extern char *env_remote_host;
extern char *env_remote_addr;
extern char *env_remote_user;
extern char *env_auth_type;
extern char *env_content_type;
extern char *env_content_length;

/* derived parameters */
extern int env_assbackwards;
extern char *env_url;		/* URL of this doc. with query and anchor off */
extern char *env_url_with_query;/* same with query_string attached */
extern char *env_url_anchor;	/* the #name part taken off url_with_query */
/* the full URL is url[?query_string[#url_anchor]] */
/* query_string and url_anchor are "" if not present */

extern int env_refresh;
extern int env_its_proxy;

int config_file_found();
/* last time I tried, could the configuration file be opened ? */

/*
 * the following routines set current_badness, check for errors with
 * current_badness(); they don't reset the badness, only call add_warning()
 * see error.h for details
 */

void read_config();
/*
 * reads the configuration parameters: returns 0, -1 or -2, -2 is fatal error
 * configuration lines are of the form key value where key and value are words
 * without blanks - non-matching lines and garbage at end of line is skipped
 * without notice
 */

void read_parameters();
/* reads the input parameters from environment variables */
/* and derives some other variables; returns 0, -1 or -2 */

void finish_global_variables();
/* adjusts some of the global variables, derived values for implicit ones */
/* this must be called after both read_config() and read_parameters() */

int config_file_found();
/* last time I tried, could the configuration file be opened ? */
