#ifndef __GLOBALS_H
//	Avoid include redundancy
#define __GLOBALS_H

//	Copyright (c) 1993, University of Kansas, All Rights Reserved
//
//	Include File:	globals.h
//	Purpose:	declarations for DOSLYNX global variables.
//	Remarks/Portability/Dependencies/Restrictions:
//		The actual definitions of the variables can be found in
//		globals.c
//	Revision History:
//		12-09-93	created

//	Required includes
#ifdef __cplusplus
#define Uses_TNSCollection
#include<tv.h>
#include"turlview.h"
#include"tcapture.h"

//	Constant defines
const signed short int maxLineLengthDLX = 256;
//	Commands, use 100-255 and 1000 on up for application's use.
const unsigned short int cmOpenURL		=	100;
const unsigned short int cmUnHideMessage	=	101;
const unsigned short int cmDosShell		=	102;
const unsigned short int cmTraceWWW		=	103;
const unsigned short int cmTraceWATTCP		=	104;
const unsigned short int cmOpenLocal		=	105;
const unsigned short int cmTraceDOSLYNX		=	106;
const unsigned short int cmLoadChild		=	107;
const unsigned short int cmOwnerClose		=	108;
const unsigned short int cmLoadParent		=	109;
const unsigned short int cmNextAnchor		=	110;
const unsigned short int cmPreviousAnchor	=	111;
const unsigned short int cmSelectAnchor		=	112;
const unsigned short int cmPreviousDocument	=	113;
const unsigned short int cmShowDestination	=	114;
const unsigned short int cmCloneWindow		=	115;
const unsigned short int cmAboutDosLynx		=	116;
const unsigned short int cmHotList		=	117;
const unsigned short int cmSaveDLX		=	118;
const unsigned short int cmPrint		=	119;
const unsigned short int cmSearch		=	120;
const unsigned short int cmSearchAgainDLX	=	121;
const unsigned short int cmMailDeveloper	=	122;
const unsigned short int cmAddToHotList		=	123;
const unsigned short int cmVideoMode		=	124;
const unsigned short int cmAddToHist		=	125;
const unsigned short int cmSearchIndex		=	126;
const unsigned short int cmImage		=	127;
const unsigned short int cmHomePage		=	128;
//	History IDs
const unsigned short int usi_OpenURLHist	=	0x0000U;
const unsigned short int usi_OpenLocalHist	=	0x0001U;
const unsigned short int usi_SaveHist		=	0x0002U;
const unsigned short int usi_PrintHist		=	0x0003U;
const unsigned short int usi_IndexHist		=	0x0004U;
//	Constant for URL buffer sizes
const unsigned short int usi_TILURLSize = 1024;
//	Special embedded character values in a HText image file.
//	c_Embedded will begin a special sequence with an indentifying
//	character following.
#define c_Embedded '\033'
const char c_AppendParagraph	=	'P';
const char c_SetStyle		=	'S';
const char c_BeginAnchor	=	'A';
const char c_EndAnchor		=	'a';
const char c_BeginForm		=	'F';
const char c_EndForm		=	'f';

//	Class declarations
//	This function definition declared here since it wholly deals with
//	global variables.
extern void ReleaseSomeMemory();

//	Global variable declarations
//	Borland C++ control.
extern unsigned _stklen;
extern unsigned _ovrbuffer;
//	Name of the application.
extern char *HTAppName;
extern char *HTAppVersion;
//	Application environment control.
extern char *cp_inipath;
extern char *cp_TempDir;
extern TNSCollection *TNSCp_LoadedHTexts;
extern unsigned short int usi_MaxLoadedHTexts;
//	for hypertext colors.
extern unsigned short int usia_TextColor[];
extern unsigned short int usia_AnchorColor[];
extern unsigned short int usia_SelectedColor[];
extern unsigned short int usia_SearchColor[];
extern unsigned short int usia_SearchSelectedColor[];
//	Global variable for C functions in CPP to communicate to a view.
extern TURLView *TURLV_current;
//	Global TCapture window
extern TCapture *TC;
//	DosLynx tracing variable.
extern char c_trace;
//	Old new handler.
extern void (*vfp_old_new_handler)();
//	Free windows numbers available.
extern Boolean B_freeWin[9];
//	Last search executed
extern char ca_searchLast[usi_TILURLSize];
//	Graphical video mode to present images in.
extern unsigned short int usi_graphicsmode;
//	Default printer device.
extern char *cp_Printer;
//	Default home page or startup URL.
extern char *cp_Home;
//	Hot list file name.
extern char *cp_HotList;
//	Error HTML file name.
extern char *cp_ErrorHTML;
//	Default ReplyTo mail address for user.
extern char *cp_ReplyTo;
//	Wether or not we allow network access
extern int i_networked;
//	The news host for the user.
extern char *cp_nntphost;
//	EMS support.
extern Boolean B_ems;
extern unsigned short int usi_emspages;
//	XMS support.
extern Boolean B_xms;
extern unsigned long int uli_xmslength;
extern unsigned long int uli_xmsstart;
#endif // __cplusplus

//	Really safe pool implementation.
//	C specific stuff, ugh!!!!
#define RSP_NUM  512
#define RSP_SIZE 128
#define Stop_Anchors 0
#define Stop_Rendering 200
extern char *really_safe_pool[RSP_NUM];
//	Number of anchors skipped.
extern unsigned short int usi_skipped;
//	Wether or not an anchor was started.
extern char c_DidStartAnchor;
//	Proxy variables.
extern char *cp_http_proxy;
extern char *cp_gopher_proxy;
extern char *cp_ftp_proxy;
extern char *cp_wais_proxy;
//	Wether or not a proxy is being used.
extern BOOL B_proxy;
//	Wehter or not to show informational messages.
extern BOOL B_noInfo;

//	Macros

#endif // __GLOBALS_H
