.ST "Database Values"
.PP
Each column in the database accepts a fixed type of data.  The
currently defined basic types, and their representations, are:
.IP "integer"
A decimal integer in the range \-2**63 to 2**63\-1, inclusive.
.IP "real"
A floating-point number.
.IP "Boolean"
True or false, written \fBtrue\fR or \fBfalse\fR, respectively.
.IP "string"
An arbitrary Unicode string, except that null bytes are not allowed.
Quotes are optional for most strings that begin with an English letter
or underscore and consist only of letters, underscores, hyphens, and
periods.  However, \fBtrue\fR and \fBfalse\fR and strings that match
the syntax of UUIDs (see below) must be enclosed in double quotes to
distinguish them from other basic types.  When double quotes are used,
the syntax is that of strings in JSON, e.g. backslashes may be used to
escape special characters.  The empty string must be represented as a
pair of double quotes (\fB""\fR).
.IP "UUID"
Either a universally unique identifier in the style of RFC 4122,
e.g. \fBf81d4fae\-7dec\-11d0\-a765\-00a0c91e6bf6\fR, or an \fB@\fIname\fR
defined by a \fBget\fR or \fBcreate\fR command within the same \fB\*(PN\fR
invocation.
.PP
Multiple values in a single column may be separated by spaces or a
single comma.  When multiple values are present, duplicates are not
allowed, and order is not important.  Conversely, some database
columns can have an empty set of values, represented as \fB[]\fR, and
square brackets may optionally enclose other non-empty sets or single
values as well. For a column accepting a set of integers, database commands
accept a range. A range is represented by two integers separated by
\fB-\fR. A range is inclusive. A range has a maximum size of 4096
elements. If more elements are needed, they can be specified in seperate
ranges.
.PP
A few database columns are ``maps'' of key-value pairs, where the key
and the value are each some fixed database type.  These are specified
in the form \fIkey\fB=\fIvalue\fR, where \fIkey\fR and \fIvalue\fR
follow the syntax for the column's key type and value type,
respectively.  When multiple pairs are present (separated by spaces or
a comma), duplicate keys are not allowed, and again the order is not
important.  Duplicate values are allowed.  An empty map is represented
as \fB{}\fR.  Curly braces may optionally enclose non-empty maps as
well (but use quotes to prevent the shell from expanding
\fBother-config={0=x,1=y}\fR into \fBother-config=0=x
other-config=1=y\fR, which may not have the desired effect).
.
.ST "Database Command Syntax"
.
.IP "[\fB\-\-if\-exists\fR] [\fB\-\-columns=\fIcolumn\fR[\fB,\fIcolumn\fR]...] \fBlist \fItable \fR[\fIrecord\fR]..."
Lists the data in each specified \fIrecord\fR.  If no
records are specified, lists all the records in \fItable\fR.
.IP
If \fB\-\-columns\fR is specified, only the requested columns are
listed, in the specified order.  Otherwise, all columns are listed, in
alphabetical order by column name.
.IP
Without \fB\-\-if-exists\fR, it is an error if any specified
\fIrecord\fR does not exist.  With \fB\-\-if-exists\fR, the command
ignores any \fIrecord\fR that does not exist, without producing any
output.
.
.IP "[\fB\-\-columns=\fIcolumn\fR[\fB,\fIcolumn\fR]...] \fBfind \fItable \fR[\fIcolumn\fR[\fB:\fIkey\fR]\fB=\fIvalue\fR]..."
Lists the data in each record in \fItable\fR whose \fIcolumn\fR equals
\fIvalue\fR or, if \fIkey\fR is specified, whose \fIcolumn\fR contains
a \fIkey\fR with the specified \fIvalue\fR.  The following operators
may be used where \fB=\fR is written in the syntax summary:
.RS
.IP "\fB= != < > <= >=\fR"
Selects records in which \fIcolumn\fR[\fB:\fIkey\fR] equals, does not
equal, is less than, is greater than, is less than or equal to, or is
greater than or equal to \fIvalue\fR, respectively.
.IP
Consider \fIcolumn\fR[\fB:\fIkey\fR] and \fIvalue\fR as sets of
elements.  Identical sets are considered equal.  Otherwise, if the
sets have different numbers of elements, then the set with more
elements is considered to be larger.  Otherwise, consider a element
from each set pairwise, in increasing order within each set.  The
first pair that differs determines the result.  (For a column that
contains key-value pairs, first all the keys are compared, and values
are considered only if the two sets contain identical keys.)
.IP "\fB{=} {!=}\fR"
Test for set equality or inequality, respectively.
.IP "\fB{<=}\fR"
Selects records in which \fIcolumn\fR[\fB:\fIkey\fR] is a subset of
\fIvalue\fR.  For example, \fBflood-vlans{<=}1,2\fR selects records in
which the \fBflood-vlans\fR column is the empty set or contains 1 or 2
or both.
.IP "\fB{<}\fR"
Selects records in which \fIcolumn\fR[\fB:\fIkey\fR] is a proper
subset of \fIvalue\fR.  For example, \fBflood-vlans{<}1,2\fR selects
records in which the \fBflood-vlans\fR column is the empty set or
contains 1 or 2 but not both.
.IP "\fB{>=} {>}\fR"
Same as \fB{<=}\fR and \fB{<}\fR, respectively, except that the
relationship is reversed.  For example, \fBflood-vlans{>=}1,2\fR
selects records in which the \fBflood-vlans\fR column contains both 1
and 2.
.PP
The following operators are available only in Open vSwitch 2.16 and
later:
.IP "\fB{in}\fR"
Selects records in which every element in \fIcolumn\fR[\fB:\fIkey\fR]
is also in \fIvalue\fR.  (This is the same as \fB{<=}\fR.)
.IP "\fB{not-in}\fR"
Selects records in which every element in \fIcolumn\fR[\fB:\fIkey\fR]
is not in \fIvalue\fR.
.RE
.IP
For arithmetic operators (\fB= != < > <= >=\fR), when \fIkey\fR is
specified but a particular record's \fIcolumn\fR does not contain
\fIkey\fR, the record is always omitted from the results.  Thus, the
condition \fBother-config:mtu!=1500\fR matches records that have a
\fBmtu\fR key whose value is not 1500, but not those that lack an
\fBmtu\fR key.
.IP
For the set operators, when \fIkey\fR is specified but a particular
record's \fIcolumn\fR does not contain \fIkey\fR, the comparison is
done against an empty set.  Thus, the condition
\fBother-config:mtu{!=}1500\fR matches records that have a \fBmtu\fR
key whose value is not 1500 and those that lack an \fBmtu\fR key.
.IP
Don't forget to escape \fB<\fR or \fB>\fR from interpretation by the
shell.
.IP
If \fB\-\-columns\fR is specified, only the requested columns are
listed, in the specified order.  Otherwise all columns are listed, in
alphabetical order by column name.
.IP
The UUIDs shown for rows created in the same \fB\*(PN\fR
invocation will be wrong.
.
.IP "[\fB\-\-if\-exists\fR] [\fB\-\-id=@\fIname\fR] \fBget \fItable record \fR[\fIcolumn\fR[\fB:\fIkey\fR]]..."
Prints the value of each specified \fIcolumn\fR in the given
\fIrecord\fR in \fItable\fR.  For map columns, a \fIkey\fR may
optionally be specified, in which case the value associated with
\fIkey\fR in the column is printed, instead of the entire map.
.IP
Without \fB\-\-if\-exists\fR, it is an error if \fIrecord\fR does not
exist or \fIkey\fR is specified, if \fIkey\fR does not exist in
\fIrecord\fR.  With \fB\-\-if\-exists\fR, a missing \fIrecord\fR
yields no output and a missing \fIkey\fR prints a blank line.
.IP
If \fB@\fIname\fR is specified, then the UUID for \fIrecord\fR may be
referred to by that name later in the same \fB\*(PN\fR
invocation in contexts where a UUID is expected.
.IP
Both \fB\-\-id\fR and the \fIcolumn\fR arguments are optional, but
usually at least one or the other should be specified.  If both are
omitted, then \fBget\fR has no effect except to verify that
\fIrecord\fR exists in \fItable\fR.
.IP
\fB\-\-id\fR and \fB\-\-if\-exists\fR cannot be used together.
.
.IP "[\fB\-\-if\-exists\fR] \fBset \fItable record column\fR[\fB:\fIkey\fR]\fB=\fIvalue\fR..."
Sets the value of each specified \fIcolumn\fR in the given
\fIrecord\fR in \fItable\fR to \fIvalue\fR.  For map columns, a
\fIkey\fR may optionally be specified, in which case the value
associated with \fIkey\fR in that column is changed (or added, if none
exists), instead of the entire map.
.IP
Without \fB\-\-if-exists\fR, it is an error if \fIrecord\fR does not
exist.  With \fB\-\-if-exists\fR, this command does nothing if
\fIrecord\fR does not exist.
.
.IP "[\fB\-\-if\-exists\fR] \fBadd \fItable record column \fR[\fIkey\fB=\fR]\fIvalue\fR..."
Adds the specified value or key-value pair to \fIcolumn\fR in
\fIrecord\fR in \fItable\fR.  If \fIcolumn\fR is a map, then \fIkey\fR
is required, otherwise it is prohibited.  If \fIkey\fR already exists
in a map column, then the current \fIvalue\fR is not replaced (use the
\fBset\fR command to replace an existing value).
.IP
Without \fB\-\-if-exists\fR, it is an error if \fIrecord\fR does not
exist.  With \fB\-\-if-exists\fR, this command does nothing if
\fIrecord\fR does not exist.
.
.IP "[\fB\-\-if\-exists\fR] \fBremove \fItable record column \fR\fIvalue\fR..."
.IQ "[\fB\-\-if\-exists\fR] \fBremove \fItable record column \fR\fIkey\fR..."
.IQ "[\fB\-\-if\-exists\fR] \fBremove \fItable record column \fR\fIkey\fB=\fR\fIvalue\fR..."
Removes the specified values or key-value pairs from \fIcolumn\fR in
\fIrecord\fR in \fItable\fR.  The first form applies to columns that
are not maps: each specified \fIvalue\fR is removed from the column.
The second and third forms apply to map columns: if only a \fIkey\fR
is specified, then any key-value pair with the given \fIkey\fR is
removed, regardless of its value; if a \fIvalue\fR is given then a
pair is removed only if both key and value match.
.IP
It is not an error if the column does not contain the specified key or
value or pair.
.IP
Without \fB\-\-if-exists\fR, it is an error if \fIrecord\fR does not
exist.  With \fB\-\-if-exists\fR, this command does nothing if
\fIrecord\fR does not exist.
.
.IP "[\fB\-\-if\-exists\fR] \fBclear\fR \fItable record column\fR..."
Sets each \fIcolumn\fR in \fIrecord\fR in \fItable\fR to the empty set
or empty map, as appropriate.  This command applies only to columns
that are allowed to be empty.
.IP
Without \fB\-\-if-exists\fR, it is an error if \fIrecord\fR does not
exist.  With \fB\-\-if-exists\fR, this command does nothing if
\fIrecord\fR does not exist.
.
.IP "[\fB\-\-id=@\fIname\fR] \fBcreate\fR \fItable column\fR[\fB:\fIkey\fR]\fB=\fIvalue\fR..."
Creates a new record in \fItable\fR and sets the initial values of
each \fIcolumn\fR.  Columns not explicitly set will receive their
default values.  Outputs the UUID of the new row.
.IP
If \fB@\fIname\fR is specified, then the UUID for the new row may be
referred to by that name elsewhere in the same \fB\*(PN\fR
invocation in contexts where a UUID is expected.  Such references may
precede or follow the \fBcreate\fR command.
.
.RS
.IP "Caution (ovs-vsctl as example)"
Records in the Open vSwitch database are significant only when they
can be reached directly or indirectly from the \fBOpen_vSwitch\fR
table.  Except for records in the \fBQoS\fR or \fBQueue\fR tables,
records that are not reachable from the \fBOpen_vSwitch\fR table are
automatically deleted from the database.  This deletion happens
immediately, without waiting for additional \fBovs\-vsctl\fR commands
or other database activity.  Thus, a \fBcreate\fR command must
generally be accompanied by additional commands \fIwithin the same
\fBovs\-vsctl\fI invocation\fR to add a chain of references to the
newly created record from the top-level \fBOpen_vSwitch\fR record.
The \fBEXAMPLES\fR section gives some examples that show how to do
this.
.RE
.
.IP "\fR[\fB\-\-if\-exists\fR] \fBdestroy \fItable record\fR..."
Deletes each specified \fIrecord\fR from \fItable\fR.  Unless
\fB\-\-if\-exists\fR is specified, each \fIrecord\fRs must exist.
.IP "\fB\-\-all destroy \fItable\fR"
Deletes all records from the \fItable\fR.
.
.RS
.IP "Caution (ovs-vsctl as example)"
The \fBdestroy\fR command is only useful for records in the \fBQoS\fR
or \fBQueue\fR tables.  Records in other tables are automatically
deleted from the database when they become unreachable from the
\fBOpen_vSwitch\fR table.  This means that deleting the last reference
to a record is sufficient for deleting the record itself.  For records
in these tables, \fBdestroy\fR is silently ignored.  See the
\fBEXAMPLES\fR section below for more information.
.RE
.
.IP "\fBwait\-until \fItable record \fR[\fIcolumn\fR[\fB:\fIkey\fR]\fB=\fIvalue\fR]..."
Waits until \fItable\fR contains a record named \fIrecord\fR whose
\fIcolumn\fR equals \fIvalue\fR or, if \fIkey\fR is specified, whose
\fIcolumn\fR contains a \fIkey\fR with the specified \fIvalue\fR.  This
command supports the same operators and semantics described for the
\fBfind\fR command above.
.IP
If no \fIcolumn\fR[\fB:\fIkey\fR]\fB=\fIvalue\fR arguments are given,
this command waits only until \fIrecord\fR exists.  If more than one
such argument is given, the command waits until all of them are
satisfied.
.
.RS
.IP "Caution (ovs-vsctl as example)"
Usually \fBwait\-until\fR should be placed at the beginning of a set
of \fBovs\-vsctl\fR commands.  For example, \fBwait\-until bridge br0
\-\- get bridge br0 datapath_id\fR waits until a bridge named
\fBbr0\fR is created, then prints its \fBdatapath_id\fR column,
whereas \fBget bridge br0 datapath_id \-\- wait\-until bridge br0\fR
will abort if no bridge named \fBbr0\fR exists when \fBovs\-vsctl\fR
initially connects to the database.
.RE
.IP
Consider specifying \fB\-\-timeout=0\fR along with
\fB\-\-wait\-until\fR, to prevent \fB\*(PN\fR from terminating
after waiting only at most 5 seconds.
.IP "\fBcomment \fR[\fIarg\fR]..."
This command has no effect on behavior, but any database log record
created by the command will include the command and its arguments.
