/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.css.editor;

/*
 * List of HTML5 tags. 
 * 
 * The list is generated by 
 * org.netbeans.modules.html.parser.model.ElementDescriptorTest.test_GenerateAllElementNamesArray()
 * to avoid css.editor to html.parser or html.lib dependency
 */

public final class HtmlTags {

    private static String[] tags = {
        "a", "abbr", "abs", "address", "and", "animate", "animateColor",
        "animateMotion", "animateTransform", "animation", "annotation",
        "annotation-xml", "apply", "approx", "arccos", "arccosh", "arccot",
        "arccoth", "arccsc", "arccsch", "arcsec", "arcsech", "arcsin",
        "arcsinh", "arctan", "arctanh", "area", "arg", "article", "aside",
        "audio", "b", "base", "bdo", "blockquote", "body", "br", "button",
        "bvar", "canvas", "caption", "card", "cartesianproduct", "ceiling",
        "ci", "circle", "cite", "cn", "code", "codomain", "col", "colgroup",
        "command", "complexes", "compose", "condition", "conjugate",
        "cos", "cosh", "cot", "coth", "csc", "csch", "csymbol", "curl",
        "datalist", "dd", "declare", "defs", "degree", "del", "desc",
        "details", "determinant", "dfn", "diff", "discard", "div", "divergence",
        "divide", "dl", "domain", "domainofapplication", "dt", "ellipse",
        "em", "embed", "emptyset", "encoding", "eq", "equivalent", "eulergamma",
        "exists", "exp", "exponentiale", "factorial", "factorof", "false",
        "fieldset", "figcaption", "figure", "floor", "fn", "font", "font-face",
        "font-face-src", "font-face-uri", "footer", "forall", "foreignObject",
        "form", "function", "g", "gcd", "geq", "glyph", "grad", "gt",
        "h1", "h2", "h3", "h4", "h5", "h6", "handler", "head", "header",
        "hgroup", "hkern", "hr", "html", "i", "ident", "iframe", "image",
        "imaginary", "imaginaryi", "img", "implies", "in", "infinity",
        "input", "ins", "int", "integers", "intersect", "interval", "inverse",
        "kbd", "keygen", "label", "lambda", "laplacian", "lcm", "legend",
        "leq", "li", "limit", "line", "linearGradient", "link", "list",
        "listener", "ln", "log", "logbase", "lowlimit", "lt", "maction",
        "malign", "maligngroup", "malignmark", "malignscope", "map",
        "mark", "math", "matrix", "matrixrow", "max", "mean", "median",
        "menclose", "menu", "merror", "meta", "metadata", "meter", "mfenced",
        "mfrac", "mfraction", "mglyph", "mi", "min", "minus", "missing-glyph",
        "mlabeledtr", "mmultiscripts", "mn", "mo", "mode", "moment",
        "momentabout", "mover", "mpadded", "mpath", "mphantom", "mprescripts",
        "mroot", "mrow", "ms", "mspace", "msqrt", "mstyle", "msub", "msubsup",
        "msup", "mtable", "mtd", "mtext", "mtr", "munder", "munderover",
        "naturalnumbers", "nav", "neq", "none", "noscript", "not", "notanumber",
        "notin", "notprsubset", "notsubset", "object", "ol", "optgroup",
        "option", "or", "otherwise", "outerproduct", "output", "p", "param",
        "partialdiff", "path", "pi", "piece", "piecewice", "piecewise",
        "partialdiff", "path", "pi", "piece", "piecewice", "piecewise",
        "plus", "polygon", "polyline", "power", "pre", "prefetch", "primes",
        "product", "progress", "prsubset", "q", "quotient", "radialGradient",
        "rationals", "real", "reals", "rect", "reln", "rem", "root",
        "rp", "rt", "ruby", "samp", "scalarproduct", "script", "sdev",
        "sec", "sech", "section", "select", "selector", "semantics",
        "sep", "set", "setdiff", "sin", "sinh", "small", "solidColor",
        "source", "span", "stop", "strong", "style", "sub", "subset",
        "sum", "summary", "sup", "svg", "switch", "table", "tan", "tanh",
        "tbody", "tbreak", "td", "tendsto", "text", "textArea", "textarea",
        "tfoot", "th", "thead", "time", "times", "title", "tr", "track",
        "transpose", "true", "tspan", "ul", "union", "uplimit", "use",
        "var", "variance", "vector", "vectorproduct", "video", "wbr",
        "xor" //NOI18N
    };

    /** Return the set of known tags */
    public static String[] getTags() {
        return tags;
    }
}
