/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.security;

import amazon.fws.clicommando.exceptions.BadInputException;
import amazon.fws.clicommando.exceptions.ConfigurationErrorException;
import amazon.fws.clicommando.messages.ErrorMessages;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AwsSignatureHelper {
    private String serviceUrl;
    private String method;

    public AwsSignatureHelper(String serviceUrl, String method) {
        this.serviceUrl = serviceUrl;
        this.method = method;
    }

    public String signParameters(Map<String, String> parameters, String key) {
        String signatureVersion = parameters.get("SignatureVersion");
        String algorithm = "HmacSHA1";
        String stringToSign = null;
        if ("1".equals(signatureVersion)) {
            stringToSign = this.calculateStringToSignV1(parameters);
        } else if ("2".equals(signatureVersion)) {
            algorithm = "HmacSHA256";
            parameters.put("SignatureMethod", algorithm);
            stringToSign = this.calculateStringToSignV2(parameters);
        } else {
            throw new ConfigurationErrorException("Invalid Signature Version specified");
        }
        return AwsSignatureHelper.sign(stringToSign, key, algorithm);
    }

    private String calculateStringToSignV1(Map<String, String> parameters) {
        StringBuilder data = new StringBuilder();
        TreeMap<String, String> sorted = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        sorted.putAll(parameters);
        for (Map.Entry param : sorted.entrySet()) {
            data.append((String)param.getKey() + (String)param.getValue());
        }
        return data.toString();
    }

    private String calculateStringToSignV2(Map<String, String> parameters) {
        StringBuilder data = new StringBuilder();
        data.append(this.method);
        data.append("\n");
        URI endpoint = null;
        try {
            endpoint = new URI(this.serviceUrl.toLowerCase());
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException("URI Syntax Exception thrown while constructing string to sign", ex);
        }
        data.append(endpoint.getHost());
        Integer port = endpoint.getPort();
        if (this.serviceUrl.contains(port.toString()) && port != 80 && port != 443 && port != -1) {
            data.append(":" + port);
        }
        data.append("\n");
        String uri = endpoint.getPath();
        if (uri == null || uri.length() == 0) {
            uri = "/";
        }
        data.append(AwsSignatureHelper.urlEncode(uri, true) + "\n");
        TreeMap<String, String> sorted = new TreeMap<String, String>();
        sorted.putAll(parameters);
        for (Map.Entry param : sorted.entrySet()) {
            data.append(AwsSignatureHelper.urlEncode((String)param.getKey(), false) + "=" + AwsSignatureHelper.urlEncode((String)param.getValue(), false) + "&");
        }
        if (data.charAt(data.length() - 1) == '&') {
            data.deleteCharAt(data.length() - 1);
        }
        return data.toString();
    }

    public static String urlEncode(String value, boolean encodePath) {
        String encoded = null;
        try {
            encoded = URLEncoder.encode(value, "UTF-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
            if (encodePath) {
                encoded = encoded.replace("%2F", "/");
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return encoded;
    }

    public static String sign(String data, String key, String algorithm) {
        byte[] signature;
        try {
            Mac mac = Mac.getInstance(algorithm);
            mac.init(new SecretKeySpec(key.getBytes(), algorithm));
            signature = Base64.encodeBase64((byte[])mac.doFinal(data.getBytes("UTF-8")));
        }
        catch (Exception e) {
            throw new BadInputException(ErrorMessages.ErrorCode.BAD_CREDENTIALS_CANNOT_SIGN, e.getMessage());
        }
        return new String(signature);
    }
}

