/*-------------------------------------------------------------------------
 *
 * outfuncs.funcs.c
 *    Generated node infrastructure code
 *
 * Portions Copyright (c) 1996-2023, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * NOTES
 *  ******************************
 *  *** DO NOT EDIT THIS FILE! ***
 *  ******************************
 *
 *  It has been GENERATED by src/backend/nodes/gen_node_support.pl
 *
 *-------------------------------------------------------------------------
 */
#include "access/amapi.h"
#include "access/sdir.h"
#include "access/tableam.h"
#include "access/tsmapi.h"
#include "commands/event_trigger.h"
#include "commands/trigger.h"
#include "executor/tuptable.h"
#include "foreign/fdwapi.h"
#include "nodes/bitmapset.h"
#include "nodes/execnodes.h"
#include "nodes/extensible.h"
#include "nodes/lockoptions.h"
#include "nodes/miscnodes.h"
#include "nodes/nodes.h"
#include "nodes/parsenodes.h"
#include "nodes/pathnodes.h"
#include "nodes/plannodes.h"
#include "nodes/primnodes.h"
#include "nodes/replnodes.h"
#include "nodes/supportnodes.h"
#include "nodes/value.h"
#include "utils/rel.h"

static void
_outAlias(StringInfo str, const Alias *node)
{
	WRITE_NODE_TYPE("ALIAS");

	WRITE_STRING_FIELD(aliasname);
	WRITE_NODE_FIELD(colnames);
}

static void
_outRangeVar(StringInfo str, const RangeVar *node)
{
	WRITE_NODE_TYPE("RANGEVAR");

	WRITE_STRING_FIELD(catalogname);
	WRITE_STRING_FIELD(schemaname);
	WRITE_STRING_FIELD(relname);
	WRITE_BOOL_FIELD(inh);
	WRITE_CHAR_FIELD(relpersistence);
	WRITE_NODE_FIELD(alias);
	WRITE_LOCATION_FIELD(location);
}

static void
_outTableFunc(StringInfo str, const TableFunc *node)
{
	WRITE_NODE_TYPE("TABLEFUNC");

	WRITE_NODE_FIELD(ns_uris);
	WRITE_NODE_FIELD(ns_names);
	WRITE_NODE_FIELD(docexpr);
	WRITE_NODE_FIELD(rowexpr);
	WRITE_NODE_FIELD(colnames);
	WRITE_NODE_FIELD(coltypes);
	WRITE_NODE_FIELD(coltypmods);
	WRITE_NODE_FIELD(colcollations);
	WRITE_NODE_FIELD(colexprs);
	WRITE_NODE_FIELD(coldefexprs);
	WRITE_BITMAPSET_FIELD(notnulls);
	WRITE_INT_FIELD(ordinalitycol);
	WRITE_LOCATION_FIELD(location);
}

static void
_outIntoClause(StringInfo str, const IntoClause *node)
{
	WRITE_NODE_TYPE("INTOCLAUSE");

	WRITE_NODE_FIELD(rel);
	WRITE_NODE_FIELD(colNames);
	WRITE_STRING_FIELD(accessMethod);
	WRITE_NODE_FIELD(options);
	WRITE_ENUM_FIELD(onCommit, OnCommitAction);
	WRITE_STRING_FIELD(tableSpaceName);
	WRITE_NODE_FIELD(viewQuery);
	WRITE_BOOL_FIELD(skipData);
}

static void
_outVar(StringInfo str, const Var *node)
{
	WRITE_NODE_TYPE("VAR");

	WRITE_INT_FIELD(varno);
	WRITE_INT_FIELD(varattno);
	WRITE_OID_FIELD(vartype);
	WRITE_INT_FIELD(vartypmod);
	WRITE_OID_FIELD(varcollid);
	WRITE_BITMAPSET_FIELD(varnullingrels);
	WRITE_UINT_FIELD(varlevelsup);
	WRITE_UINT_FIELD(varnosyn);
	WRITE_INT_FIELD(varattnosyn);
	WRITE_LOCATION_FIELD(location);
}

static void
_outParam(StringInfo str, const Param *node)
{
	WRITE_NODE_TYPE("PARAM");

	WRITE_ENUM_FIELD(paramkind, ParamKind);
	WRITE_INT_FIELD(paramid);
	WRITE_OID_FIELD(paramtype);
	WRITE_INT_FIELD(paramtypmod);
	WRITE_OID_FIELD(paramcollid);
	WRITE_LOCATION_FIELD(location);
}

static void
_outAggref(StringInfo str, const Aggref *node)
{
	WRITE_NODE_TYPE("AGGREF");

	WRITE_OID_FIELD(aggfnoid);
	WRITE_OID_FIELD(aggtype);
	WRITE_OID_FIELD(aggcollid);
	WRITE_OID_FIELD(inputcollid);
	WRITE_OID_FIELD(aggtranstype);
	WRITE_NODE_FIELD(aggargtypes);
	WRITE_NODE_FIELD(aggdirectargs);
	WRITE_NODE_FIELD(args);
	WRITE_NODE_FIELD(aggorder);
	WRITE_NODE_FIELD(aggdistinct);
	WRITE_NODE_FIELD(aggfilter);
	WRITE_BOOL_FIELD(aggstar);
	WRITE_BOOL_FIELD(aggvariadic);
	WRITE_CHAR_FIELD(aggkind);
	WRITE_BOOL_FIELD(aggpresorted);
	WRITE_UINT_FIELD(agglevelsup);
	WRITE_ENUM_FIELD(aggsplit, AggSplit);
	WRITE_INT_FIELD(aggno);
	WRITE_INT_FIELD(aggtransno);
	WRITE_LOCATION_FIELD(location);
}

static void
_outGroupingFunc(StringInfo str, const GroupingFunc *node)
{
	WRITE_NODE_TYPE("GROUPINGFUNC");

	WRITE_NODE_FIELD(args);
	WRITE_NODE_FIELD(refs);
	WRITE_NODE_FIELD(cols);
	WRITE_UINT_FIELD(agglevelsup);
	WRITE_LOCATION_FIELD(location);
}

static void
_outWindowFunc(StringInfo str, const WindowFunc *node)
{
	WRITE_NODE_TYPE("WINDOWFUNC");

	WRITE_OID_FIELD(winfnoid);
	WRITE_OID_FIELD(wintype);
	WRITE_OID_FIELD(wincollid);
	WRITE_OID_FIELD(inputcollid);
	WRITE_NODE_FIELD(args);
	WRITE_NODE_FIELD(aggfilter);
	WRITE_UINT_FIELD(winref);
	WRITE_BOOL_FIELD(winstar);
	WRITE_BOOL_FIELD(winagg);
	WRITE_LOCATION_FIELD(location);
}

static void
_outSubscriptingRef(StringInfo str, const SubscriptingRef *node)
{
	WRITE_NODE_TYPE("SUBSCRIPTINGREF");

	WRITE_OID_FIELD(refcontainertype);
	WRITE_OID_FIELD(refelemtype);
	WRITE_OID_FIELD(refrestype);
	WRITE_INT_FIELD(reftypmod);
	WRITE_OID_FIELD(refcollid);
	WRITE_NODE_FIELD(refupperindexpr);
	WRITE_NODE_FIELD(reflowerindexpr);
	WRITE_NODE_FIELD(refexpr);
	WRITE_NODE_FIELD(refassgnexpr);
}

static void
_outFuncExpr(StringInfo str, const FuncExpr *node)
{
	WRITE_NODE_TYPE("FUNCEXPR");

	WRITE_OID_FIELD(funcid);
	WRITE_OID_FIELD(funcresulttype);
	WRITE_BOOL_FIELD(funcretset);
	WRITE_BOOL_FIELD(funcvariadic);
	WRITE_ENUM_FIELD(funcformat, CoercionForm);
	WRITE_OID_FIELD(funccollid);
	WRITE_OID_FIELD(inputcollid);
	WRITE_NODE_FIELD(args);
	WRITE_LOCATION_FIELD(location);
}

static void
_outNamedArgExpr(StringInfo str, const NamedArgExpr *node)
{
	WRITE_NODE_TYPE("NAMEDARGEXPR");

	WRITE_NODE_FIELD(arg);
	WRITE_STRING_FIELD(name);
	WRITE_INT_FIELD(argnumber);
	WRITE_LOCATION_FIELD(location);
}

static void
_outOpExpr(StringInfo str, const OpExpr *node)
{
	WRITE_NODE_TYPE("OPEXPR");

	WRITE_OID_FIELD(opno);
	WRITE_OID_FIELD(opfuncid);
	WRITE_OID_FIELD(opresulttype);
	WRITE_BOOL_FIELD(opretset);
	WRITE_OID_FIELD(opcollid);
	WRITE_OID_FIELD(inputcollid);
	WRITE_NODE_FIELD(args);
	WRITE_LOCATION_FIELD(location);
}

static void
_outDistinctExpr(StringInfo str, const DistinctExpr *node)
{
	WRITE_NODE_TYPE("DISTINCTEXPR");

	WRITE_OID_FIELD(opno);
	WRITE_OID_FIELD(opfuncid);
	WRITE_OID_FIELD(opresulttype);
	WRITE_BOOL_FIELD(opretset);
	WRITE_OID_FIELD(opcollid);
	WRITE_OID_FIELD(inputcollid);
	WRITE_NODE_FIELD(args);
	WRITE_LOCATION_FIELD(location);
}

static void
_outNullIfExpr(StringInfo str, const NullIfExpr *node)
{
	WRITE_NODE_TYPE("NULLIFEXPR");

	WRITE_OID_FIELD(opno);
	WRITE_OID_FIELD(opfuncid);
	WRITE_OID_FIELD(opresulttype);
	WRITE_BOOL_FIELD(opretset);
	WRITE_OID_FIELD(opcollid);
	WRITE_OID_FIELD(inputcollid);
	WRITE_NODE_FIELD(args);
	WRITE_LOCATION_FIELD(location);
}

static void
_outScalarArrayOpExpr(StringInfo str, const ScalarArrayOpExpr *node)
{
	WRITE_NODE_TYPE("SCALARARRAYOPEXPR");

	WRITE_OID_FIELD(opno);
	WRITE_OID_FIELD(opfuncid);
	WRITE_OID_FIELD(hashfuncid);
	WRITE_OID_FIELD(negfuncid);
	WRITE_BOOL_FIELD(useOr);
	WRITE_OID_FIELD(inputcollid);
	WRITE_NODE_FIELD(args);
	WRITE_LOCATION_FIELD(location);
}

static void
_outSubLink(StringInfo str, const SubLink *node)
{
	WRITE_NODE_TYPE("SUBLINK");

	WRITE_ENUM_FIELD(subLinkType, SubLinkType);
	WRITE_INT_FIELD(subLinkId);
	WRITE_NODE_FIELD(testexpr);
	WRITE_NODE_FIELD(operName);
	WRITE_NODE_FIELD(subselect);
	WRITE_LOCATION_FIELD(location);
}

static void
_outSubPlan(StringInfo str, const SubPlan *node)
{
	WRITE_NODE_TYPE("SUBPLAN");

	WRITE_ENUM_FIELD(subLinkType, SubLinkType);
	WRITE_NODE_FIELD(testexpr);
	WRITE_NODE_FIELD(paramIds);
	WRITE_INT_FIELD(plan_id);
	WRITE_STRING_FIELD(plan_name);
	WRITE_OID_FIELD(firstColType);
	WRITE_INT_FIELD(firstColTypmod);
	WRITE_OID_FIELD(firstColCollation);
	WRITE_BOOL_FIELD(useHashTable);
	WRITE_BOOL_FIELD(unknownEqFalse);
	WRITE_BOOL_FIELD(parallel_safe);
	WRITE_NODE_FIELD(setParam);
	WRITE_NODE_FIELD(parParam);
	WRITE_NODE_FIELD(args);
	WRITE_FLOAT_FIELD(startup_cost);
	WRITE_FLOAT_FIELD(per_call_cost);
}

static void
_outAlternativeSubPlan(StringInfo str, const AlternativeSubPlan *node)
{
	WRITE_NODE_TYPE("ALTERNATIVESUBPLAN");

	WRITE_NODE_FIELD(subplans);
}

static void
_outFieldSelect(StringInfo str, const FieldSelect *node)
{
	WRITE_NODE_TYPE("FIELDSELECT");

	WRITE_NODE_FIELD(arg);
	WRITE_INT_FIELD(fieldnum);
	WRITE_OID_FIELD(resulttype);
	WRITE_INT_FIELD(resulttypmod);
	WRITE_OID_FIELD(resultcollid);
}

static void
_outFieldStore(StringInfo str, const FieldStore *node)
{
	WRITE_NODE_TYPE("FIELDSTORE");

	WRITE_NODE_FIELD(arg);
	WRITE_NODE_FIELD(newvals);
	WRITE_NODE_FIELD(fieldnums);
	WRITE_OID_FIELD(resulttype);
}

static void
_outRelabelType(StringInfo str, const RelabelType *node)
{
	WRITE_NODE_TYPE("RELABELTYPE");

	WRITE_NODE_FIELD(arg);
	WRITE_OID_FIELD(resulttype);
	WRITE_INT_FIELD(resulttypmod);
	WRITE_OID_FIELD(resultcollid);
	WRITE_ENUM_FIELD(relabelformat, CoercionForm);
	WRITE_LOCATION_FIELD(location);
}

static void
_outCoerceViaIO(StringInfo str, const CoerceViaIO *node)
{
	WRITE_NODE_TYPE("COERCEVIAIO");

	WRITE_NODE_FIELD(arg);
	WRITE_OID_FIELD(resulttype);
	WRITE_OID_FIELD(resultcollid);
	WRITE_ENUM_FIELD(coerceformat, CoercionForm);
	WRITE_LOCATION_FIELD(location);
}

static void
_outArrayCoerceExpr(StringInfo str, const ArrayCoerceExpr *node)
{
	WRITE_NODE_TYPE("ARRAYCOERCEEXPR");

	WRITE_NODE_FIELD(arg);
	WRITE_NODE_FIELD(elemexpr);
	WRITE_OID_FIELD(resulttype);
	WRITE_INT_FIELD(resulttypmod);
	WRITE_OID_FIELD(resultcollid);
	WRITE_ENUM_FIELD(coerceformat, CoercionForm);
	WRITE_LOCATION_FIELD(location);
}

static void
_outConvertRowtypeExpr(StringInfo str, const ConvertRowtypeExpr *node)
{
	WRITE_NODE_TYPE("CONVERTROWTYPEEXPR");

	WRITE_NODE_FIELD(arg);
	WRITE_OID_FIELD(resulttype);
	WRITE_ENUM_FIELD(convertformat, CoercionForm);
	WRITE_LOCATION_FIELD(location);
}

static void
_outCollateExpr(StringInfo str, const CollateExpr *node)
{
	WRITE_NODE_TYPE("COLLATEEXPR");

	WRITE_NODE_FIELD(arg);
	WRITE_OID_FIELD(collOid);
	WRITE_LOCATION_FIELD(location);
}

static void
_outCaseExpr(StringInfo str, const CaseExpr *node)
{
	WRITE_NODE_TYPE("CASEEXPR");

	WRITE_OID_FIELD(casetype);
	WRITE_OID_FIELD(casecollid);
	WRITE_NODE_FIELD(arg);
	WRITE_NODE_FIELD(args);
	WRITE_NODE_FIELD(defresult);
	WRITE_LOCATION_FIELD(location);
}

static void
_outCaseWhen(StringInfo str, const CaseWhen *node)
{
	WRITE_NODE_TYPE("CASEWHEN");

	WRITE_NODE_FIELD(expr);
	WRITE_NODE_FIELD(result);
	WRITE_LOCATION_FIELD(location);
}

static void
_outCaseTestExpr(StringInfo str, const CaseTestExpr *node)
{
	WRITE_NODE_TYPE("CASETESTEXPR");

	WRITE_OID_FIELD(typeId);
	WRITE_INT_FIELD(typeMod);
	WRITE_OID_FIELD(collation);
}

static void
_outArrayExpr(StringInfo str, const ArrayExpr *node)
{
	WRITE_NODE_TYPE("ARRAYEXPR");

	WRITE_OID_FIELD(array_typeid);
	WRITE_OID_FIELD(array_collid);
	WRITE_OID_FIELD(element_typeid);
	WRITE_NODE_FIELD(elements);
	WRITE_BOOL_FIELD(multidims);
	WRITE_LOCATION_FIELD(location);
}

static void
_outRowExpr(StringInfo str, const RowExpr *node)
{
	WRITE_NODE_TYPE("ROWEXPR");

	WRITE_NODE_FIELD(args);
	WRITE_OID_FIELD(row_typeid);
	WRITE_ENUM_FIELD(row_format, CoercionForm);
	WRITE_NODE_FIELD(colnames);
	WRITE_LOCATION_FIELD(location);
}

static void
_outRowCompareExpr(StringInfo str, const RowCompareExpr *node)
{
	WRITE_NODE_TYPE("ROWCOMPAREEXPR");

	WRITE_ENUM_FIELD(rctype, RowCompareType);
	WRITE_NODE_FIELD(opnos);
	WRITE_NODE_FIELD(opfamilies);
	WRITE_NODE_FIELD(inputcollids);
	WRITE_NODE_FIELD(largs);
	WRITE_NODE_FIELD(rargs);
}

static void
_outCoalesceExpr(StringInfo str, const CoalesceExpr *node)
{
	WRITE_NODE_TYPE("COALESCEEXPR");

	WRITE_OID_FIELD(coalescetype);
	WRITE_OID_FIELD(coalescecollid);
	WRITE_NODE_FIELD(args);
	WRITE_LOCATION_FIELD(location);
}

static void
_outMinMaxExpr(StringInfo str, const MinMaxExpr *node)
{
	WRITE_NODE_TYPE("MINMAXEXPR");

	WRITE_OID_FIELD(minmaxtype);
	WRITE_OID_FIELD(minmaxcollid);
	WRITE_OID_FIELD(inputcollid);
	WRITE_ENUM_FIELD(op, MinMaxOp);
	WRITE_NODE_FIELD(args);
	WRITE_LOCATION_FIELD(location);
}

static void
_outSQLValueFunction(StringInfo str, const SQLValueFunction *node)
{
	WRITE_NODE_TYPE("SQLVALUEFUNCTION");

	WRITE_ENUM_FIELD(op, SQLValueFunctionOp);
	WRITE_OID_FIELD(type);
	WRITE_INT_FIELD(typmod);
	WRITE_LOCATION_FIELD(location);
}

static void
_outXmlExpr(StringInfo str, const XmlExpr *node)
{
	WRITE_NODE_TYPE("XMLEXPR");

	WRITE_ENUM_FIELD(op, XmlExprOp);
	WRITE_STRING_FIELD(name);
	WRITE_NODE_FIELD(named_args);
	WRITE_NODE_FIELD(arg_names);
	WRITE_NODE_FIELD(args);
	WRITE_ENUM_FIELD(xmloption, XmlOptionType);
	WRITE_BOOL_FIELD(indent);
	WRITE_OID_FIELD(type);
	WRITE_INT_FIELD(typmod);
	WRITE_LOCATION_FIELD(location);
}

static void
_outJsonFormat(StringInfo str, const JsonFormat *node)
{
	WRITE_NODE_TYPE("JSONFORMAT");

	WRITE_ENUM_FIELD(format_type, JsonFormatType);
	WRITE_ENUM_FIELD(encoding, JsonEncoding);
	WRITE_LOCATION_FIELD(location);
}

static void
_outJsonReturning(StringInfo str, const JsonReturning *node)
{
	WRITE_NODE_TYPE("JSONRETURNING");

	WRITE_NODE_FIELD(format);
	WRITE_OID_FIELD(typid);
	WRITE_INT_FIELD(typmod);
}

static void
_outJsonValueExpr(StringInfo str, const JsonValueExpr *node)
{
	WRITE_NODE_TYPE("JSONVALUEEXPR");

	WRITE_NODE_FIELD(raw_expr);
	WRITE_NODE_FIELD(formatted_expr);
	WRITE_NODE_FIELD(format);
}

static void
_outJsonConstructorExpr(StringInfo str, const JsonConstructorExpr *node)
{
	WRITE_NODE_TYPE("JSONCONSTRUCTOREXPR");

	WRITE_ENUM_FIELD(type, JsonConstructorType);
	WRITE_NODE_FIELD(args);
	WRITE_NODE_FIELD(func);
	WRITE_NODE_FIELD(coercion);
	WRITE_NODE_FIELD(returning);
	WRITE_BOOL_FIELD(absent_on_null);
	WRITE_BOOL_FIELD(unique);
	WRITE_LOCATION_FIELD(location);
}

static void
_outJsonIsPredicate(StringInfo str, const JsonIsPredicate *node)
{
	WRITE_NODE_TYPE("JSONISPREDICATE");

	WRITE_NODE_FIELD(expr);
	WRITE_NODE_FIELD(format);
	WRITE_ENUM_FIELD(item_type, JsonValueType);
	WRITE_BOOL_FIELD(unique_keys);
	WRITE_LOCATION_FIELD(location);
}

static void
_outNullTest(StringInfo str, const NullTest *node)
{
	WRITE_NODE_TYPE("NULLTEST");

	WRITE_NODE_FIELD(arg);
	WRITE_ENUM_FIELD(nulltesttype, NullTestType);
	WRITE_BOOL_FIELD(argisrow);
	WRITE_LOCATION_FIELD(location);
}

static void
_outBooleanTest(StringInfo str, const BooleanTest *node)
{
	WRITE_NODE_TYPE("BOOLEANTEST");

	WRITE_NODE_FIELD(arg);
	WRITE_ENUM_FIELD(booltesttype, BoolTestType);
	WRITE_LOCATION_FIELD(location);
}

static void
_outCoerceToDomain(StringInfo str, const CoerceToDomain *node)
{
	WRITE_NODE_TYPE("COERCETODOMAIN");

	WRITE_NODE_FIELD(arg);
	WRITE_OID_FIELD(resulttype);
	WRITE_INT_FIELD(resulttypmod);
	WRITE_OID_FIELD(resultcollid);
	WRITE_ENUM_FIELD(coercionformat, CoercionForm);
	WRITE_LOCATION_FIELD(location);
}

static void
_outCoerceToDomainValue(StringInfo str, const CoerceToDomainValue *node)
{
	WRITE_NODE_TYPE("COERCETODOMAINVALUE");

	WRITE_OID_FIELD(typeId);
	WRITE_INT_FIELD(typeMod);
	WRITE_OID_FIELD(collation);
	WRITE_LOCATION_FIELD(location);
}

static void
_outSetToDefault(StringInfo str, const SetToDefault *node)
{
	WRITE_NODE_TYPE("SETTODEFAULT");

	WRITE_OID_FIELD(typeId);
	WRITE_INT_FIELD(typeMod);
	WRITE_OID_FIELD(collation);
	WRITE_LOCATION_FIELD(location);
}

static void
_outCurrentOfExpr(StringInfo str, const CurrentOfExpr *node)
{
	WRITE_NODE_TYPE("CURRENTOFEXPR");

	WRITE_UINT_FIELD(cvarno);
	WRITE_STRING_FIELD(cursor_name);
	WRITE_INT_FIELD(cursor_param);
}

static void
_outNextValueExpr(StringInfo str, const NextValueExpr *node)
{
	WRITE_NODE_TYPE("NEXTVALUEEXPR");

	WRITE_OID_FIELD(seqid);
	WRITE_OID_FIELD(typeId);
}

static void
_outInferenceElem(StringInfo str, const InferenceElem *node)
{
	WRITE_NODE_TYPE("INFERENCEELEM");

	WRITE_NODE_FIELD(expr);
	WRITE_OID_FIELD(infercollid);
	WRITE_OID_FIELD(inferopclass);
}

static void
_outTargetEntry(StringInfo str, const TargetEntry *node)
{
	WRITE_NODE_TYPE("TARGETENTRY");

	WRITE_NODE_FIELD(expr);
	WRITE_INT_FIELD(resno);
	WRITE_STRING_FIELD(resname);
	WRITE_UINT_FIELD(ressortgroupref);
	WRITE_OID_FIELD(resorigtbl);
	WRITE_INT_FIELD(resorigcol);
	WRITE_BOOL_FIELD(resjunk);
}

static void
_outRangeTblRef(StringInfo str, const RangeTblRef *node)
{
	WRITE_NODE_TYPE("RANGETBLREF");

	WRITE_INT_FIELD(rtindex);
}

static void
_outJoinExpr(StringInfo str, const JoinExpr *node)
{
	WRITE_NODE_TYPE("JOINEXPR");

	WRITE_ENUM_FIELD(jointype, JoinType);
	WRITE_BOOL_FIELD(isNatural);
	WRITE_NODE_FIELD(larg);
	WRITE_NODE_FIELD(rarg);
	WRITE_NODE_FIELD(usingClause);
	WRITE_NODE_FIELD(join_using_alias);
	WRITE_NODE_FIELD(quals);
	WRITE_NODE_FIELD(alias);
	WRITE_INT_FIELD(rtindex);
}

static void
_outFromExpr(StringInfo str, const FromExpr *node)
{
	WRITE_NODE_TYPE("FROMEXPR");

	WRITE_NODE_FIELD(fromlist);
	WRITE_NODE_FIELD(quals);
}

static void
_outOnConflictExpr(StringInfo str, const OnConflictExpr *node)
{
	WRITE_NODE_TYPE("ONCONFLICTEXPR");

	WRITE_ENUM_FIELD(action, OnConflictAction);
	WRITE_NODE_FIELD(arbiterElems);
	WRITE_NODE_FIELD(arbiterWhere);
	WRITE_OID_FIELD(constraint);
	WRITE_NODE_FIELD(onConflictSet);
	WRITE_NODE_FIELD(onConflictWhere);
	WRITE_INT_FIELD(exclRelIndex);
	WRITE_NODE_FIELD(exclRelTlist);
}

static void
_outQuery(StringInfo str, const Query *node)
{
	WRITE_NODE_TYPE("QUERY");

	WRITE_ENUM_FIELD(commandType, CmdType);
	WRITE_ENUM_FIELD(querySource, QuerySource);
	WRITE_BOOL_FIELD(canSetTag);
	WRITE_NODE_FIELD(utilityStmt);
	WRITE_INT_FIELD(resultRelation);
	WRITE_BOOL_FIELD(hasAggs);
	WRITE_BOOL_FIELD(hasWindowFuncs);
	WRITE_BOOL_FIELD(hasTargetSRFs);
	WRITE_BOOL_FIELD(hasSubLinks);
	WRITE_BOOL_FIELD(hasDistinctOn);
	WRITE_BOOL_FIELD(hasRecursive);
	WRITE_BOOL_FIELD(hasModifyingCTE);
	WRITE_BOOL_FIELD(hasForUpdate);
	WRITE_BOOL_FIELD(hasRowSecurity);
	WRITE_BOOL_FIELD(isReturn);
	WRITE_NODE_FIELD(cteList);
	WRITE_NODE_FIELD(rtable);
	WRITE_NODE_FIELD(rteperminfos);
	WRITE_NODE_FIELD(jointree);
	WRITE_NODE_FIELD(mergeActionList);
	WRITE_BOOL_FIELD(mergeUseOuterJoin);
	WRITE_NODE_FIELD(targetList);
	WRITE_ENUM_FIELD(override, OverridingKind);
	WRITE_NODE_FIELD(onConflict);
	WRITE_NODE_FIELD(returningList);
	WRITE_NODE_FIELD(groupClause);
	WRITE_BOOL_FIELD(groupDistinct);
	WRITE_NODE_FIELD(groupingSets);
	WRITE_NODE_FIELD(havingQual);
	WRITE_NODE_FIELD(windowClause);
	WRITE_NODE_FIELD(distinctClause);
	WRITE_NODE_FIELD(sortClause);
	WRITE_NODE_FIELD(limitOffset);
	WRITE_NODE_FIELD(limitCount);
	WRITE_ENUM_FIELD(limitOption, LimitOption);
	WRITE_NODE_FIELD(rowMarks);
	WRITE_NODE_FIELD(setOperations);
	WRITE_NODE_FIELD(constraintDeps);
	WRITE_NODE_FIELD(withCheckOptions);
	WRITE_LOCATION_FIELD(stmt_location);
	WRITE_INT_FIELD(stmt_len);
}

static void
_outTypeName(StringInfo str, const TypeName *node)
{
	WRITE_NODE_TYPE("TYPENAME");

	WRITE_NODE_FIELD(names);
	WRITE_OID_FIELD(typeOid);
	WRITE_BOOL_FIELD(setof);
	WRITE_BOOL_FIELD(pct_type);
	WRITE_NODE_FIELD(typmods);
	WRITE_INT_FIELD(typemod);
	WRITE_NODE_FIELD(arrayBounds);
	WRITE_LOCATION_FIELD(location);
}

static void
_outColumnRef(StringInfo str, const ColumnRef *node)
{
	WRITE_NODE_TYPE("COLUMNREF");

	WRITE_NODE_FIELD(fields);
	WRITE_LOCATION_FIELD(location);
}

static void
_outParamRef(StringInfo str, const ParamRef *node)
{
	WRITE_NODE_TYPE("PARAMREF");

	WRITE_INT_FIELD(number);
	WRITE_LOCATION_FIELD(location);
}

static void
_outTypeCast(StringInfo str, const TypeCast *node)
{
	WRITE_NODE_TYPE("TYPECAST");

	WRITE_NODE_FIELD(arg);
	WRITE_NODE_FIELD(typeName);
	WRITE_LOCATION_FIELD(location);
}

static void
_outCollateClause(StringInfo str, const CollateClause *node)
{
	WRITE_NODE_TYPE("COLLATECLAUSE");

	WRITE_NODE_FIELD(arg);
	WRITE_NODE_FIELD(collname);
	WRITE_LOCATION_FIELD(location);
}

static void
_outRoleSpec(StringInfo str, const RoleSpec *node)
{
	WRITE_NODE_TYPE("ROLESPEC");

	WRITE_ENUM_FIELD(roletype, RoleSpecType);
	WRITE_STRING_FIELD(rolename);
	WRITE_LOCATION_FIELD(location);
}

static void
_outFuncCall(StringInfo str, const FuncCall *node)
{
	WRITE_NODE_TYPE("FUNCCALL");

	WRITE_NODE_FIELD(funcname);
	WRITE_NODE_FIELD(args);
	WRITE_NODE_FIELD(agg_order);
	WRITE_NODE_FIELD(agg_filter);
	WRITE_NODE_FIELD(over);
	WRITE_BOOL_FIELD(agg_within_group);
	WRITE_BOOL_FIELD(agg_star);
	WRITE_BOOL_FIELD(agg_distinct);
	WRITE_BOOL_FIELD(func_variadic);
	WRITE_ENUM_FIELD(funcformat, CoercionForm);
	WRITE_LOCATION_FIELD(location);
}

static void
_outA_Star(StringInfo str, const A_Star *node)
{
	WRITE_NODE_TYPE("A_STAR");

}

static void
_outA_Indices(StringInfo str, const A_Indices *node)
{
	WRITE_NODE_TYPE("A_INDICES");

	WRITE_BOOL_FIELD(is_slice);
	WRITE_NODE_FIELD(lidx);
	WRITE_NODE_FIELD(uidx);
}

static void
_outA_Indirection(StringInfo str, const A_Indirection *node)
{
	WRITE_NODE_TYPE("A_INDIRECTION");

	WRITE_NODE_FIELD(arg);
	WRITE_NODE_FIELD(indirection);
}

static void
_outA_ArrayExpr(StringInfo str, const A_ArrayExpr *node)
{
	WRITE_NODE_TYPE("A_ARRAYEXPR");

	WRITE_NODE_FIELD(elements);
	WRITE_LOCATION_FIELD(location);
}

static void
_outResTarget(StringInfo str, const ResTarget *node)
{
	WRITE_NODE_TYPE("RESTARGET");

	WRITE_STRING_FIELD(name);
	WRITE_NODE_FIELD(indirection);
	WRITE_NODE_FIELD(val);
	WRITE_LOCATION_FIELD(location);
}

static void
_outMultiAssignRef(StringInfo str, const MultiAssignRef *node)
{
	WRITE_NODE_TYPE("MULTIASSIGNREF");

	WRITE_NODE_FIELD(source);
	WRITE_INT_FIELD(colno);
	WRITE_INT_FIELD(ncolumns);
}

static void
_outSortBy(StringInfo str, const SortBy *node)
{
	WRITE_NODE_TYPE("SORTBY");

	WRITE_NODE_FIELD(node);
	WRITE_ENUM_FIELD(sortby_dir, SortByDir);
	WRITE_ENUM_FIELD(sortby_nulls, SortByNulls);
	WRITE_NODE_FIELD(useOp);
	WRITE_LOCATION_FIELD(location);
}

static void
_outWindowDef(StringInfo str, const WindowDef *node)
{
	WRITE_NODE_TYPE("WINDOWDEF");

	WRITE_STRING_FIELD(name);
	WRITE_STRING_FIELD(refname);
	WRITE_NODE_FIELD(partitionClause);
	WRITE_NODE_FIELD(orderClause);
	WRITE_INT_FIELD(frameOptions);
	WRITE_NODE_FIELD(startOffset);
	WRITE_NODE_FIELD(endOffset);
	WRITE_LOCATION_FIELD(location);
}

static void
_outRangeSubselect(StringInfo str, const RangeSubselect *node)
{
	WRITE_NODE_TYPE("RANGESUBSELECT");

	WRITE_BOOL_FIELD(lateral);
	WRITE_NODE_FIELD(subquery);
	WRITE_NODE_FIELD(alias);
}

static void
_outRangeFunction(StringInfo str, const RangeFunction *node)
{
	WRITE_NODE_TYPE("RANGEFUNCTION");

	WRITE_BOOL_FIELD(lateral);
	WRITE_BOOL_FIELD(ordinality);
	WRITE_BOOL_FIELD(is_rowsfrom);
	WRITE_NODE_FIELD(functions);
	WRITE_NODE_FIELD(alias);
	WRITE_NODE_FIELD(coldeflist);
}

static void
_outRangeTableFunc(StringInfo str, const RangeTableFunc *node)
{
	WRITE_NODE_TYPE("RANGETABLEFUNC");

	WRITE_BOOL_FIELD(lateral);
	WRITE_NODE_FIELD(docexpr);
	WRITE_NODE_FIELD(rowexpr);
	WRITE_NODE_FIELD(namespaces);
	WRITE_NODE_FIELD(columns);
	WRITE_NODE_FIELD(alias);
	WRITE_LOCATION_FIELD(location);
}

static void
_outRangeTableFuncCol(StringInfo str, const RangeTableFuncCol *node)
{
	WRITE_NODE_TYPE("RANGETABLEFUNCCOL");

	WRITE_STRING_FIELD(colname);
	WRITE_NODE_FIELD(typeName);
	WRITE_BOOL_FIELD(for_ordinality);
	WRITE_BOOL_FIELD(is_not_null);
	WRITE_NODE_FIELD(colexpr);
	WRITE_NODE_FIELD(coldefexpr);
	WRITE_LOCATION_FIELD(location);
}

static void
_outRangeTableSample(StringInfo str, const RangeTableSample *node)
{
	WRITE_NODE_TYPE("RANGETABLESAMPLE");

	WRITE_NODE_FIELD(relation);
	WRITE_NODE_FIELD(method);
	WRITE_NODE_FIELD(args);
	WRITE_NODE_FIELD(repeatable);
	WRITE_LOCATION_FIELD(location);
}

static void
_outColumnDef(StringInfo str, const ColumnDef *node)
{
	WRITE_NODE_TYPE("COLUMNDEF");

	WRITE_STRING_FIELD(colname);
	WRITE_NODE_FIELD(typeName);
	WRITE_STRING_FIELD(compression);
	WRITE_INT_FIELD(inhcount);
	WRITE_BOOL_FIELD(is_local);
	WRITE_BOOL_FIELD(is_not_null);
	WRITE_BOOL_FIELD(is_from_type);
	WRITE_CHAR_FIELD(storage);
	WRITE_STRING_FIELD(storage_name);
	WRITE_NODE_FIELD(raw_default);
	WRITE_NODE_FIELD(cooked_default);
	WRITE_CHAR_FIELD(identity);
	WRITE_NODE_FIELD(identitySequence);
	WRITE_CHAR_FIELD(generated);
	WRITE_NODE_FIELD(collClause);
	WRITE_OID_FIELD(collOid);
	WRITE_NODE_FIELD(constraints);
	WRITE_NODE_FIELD(fdwoptions);
	WRITE_LOCATION_FIELD(location);
}

static void
_outTableLikeClause(StringInfo str, const TableLikeClause *node)
{
	WRITE_NODE_TYPE("TABLELIKECLAUSE");

	WRITE_NODE_FIELD(relation);
	WRITE_UINT_FIELD(options);
	WRITE_OID_FIELD(relationOid);
}

static void
_outIndexElem(StringInfo str, const IndexElem *node)
{
	WRITE_NODE_TYPE("INDEXELEM");

	WRITE_STRING_FIELD(name);
	WRITE_NODE_FIELD(expr);
	WRITE_STRING_FIELD(indexcolname);
	WRITE_NODE_FIELD(collation);
	WRITE_NODE_FIELD(opclass);
	WRITE_NODE_FIELD(opclassopts);
	WRITE_ENUM_FIELD(ordering, SortByDir);
	WRITE_ENUM_FIELD(nulls_ordering, SortByNulls);
}

static void
_outDefElem(StringInfo str, const DefElem *node)
{
	WRITE_NODE_TYPE("DEFELEM");

	WRITE_STRING_FIELD(defnamespace);
	WRITE_STRING_FIELD(defname);
	WRITE_NODE_FIELD(arg);
	WRITE_ENUM_FIELD(defaction, DefElemAction);
	WRITE_LOCATION_FIELD(location);
}

static void
_outLockingClause(StringInfo str, const LockingClause *node)
{
	WRITE_NODE_TYPE("LOCKINGCLAUSE");

	WRITE_NODE_FIELD(lockedRels);
	WRITE_ENUM_FIELD(strength, LockClauseStrength);
	WRITE_ENUM_FIELD(waitPolicy, LockWaitPolicy);
}

static void
_outXmlSerialize(StringInfo str, const XmlSerialize *node)
{
	WRITE_NODE_TYPE("XMLSERIALIZE");

	WRITE_ENUM_FIELD(xmloption, XmlOptionType);
	WRITE_NODE_FIELD(expr);
	WRITE_NODE_FIELD(typeName);
	WRITE_BOOL_FIELD(indent);
	WRITE_LOCATION_FIELD(location);
}

static void
_outPartitionElem(StringInfo str, const PartitionElem *node)
{
	WRITE_NODE_TYPE("PARTITIONELEM");

	WRITE_STRING_FIELD(name);
	WRITE_NODE_FIELD(expr);
	WRITE_NODE_FIELD(collation);
	WRITE_NODE_FIELD(opclass);
	WRITE_LOCATION_FIELD(location);
}

static void
_outPartitionSpec(StringInfo str, const PartitionSpec *node)
{
	WRITE_NODE_TYPE("PARTITIONSPEC");

	WRITE_ENUM_FIELD(strategy, PartitionStrategy);
	WRITE_NODE_FIELD(partParams);
	WRITE_LOCATION_FIELD(location);
}

static void
_outPartitionBoundSpec(StringInfo str, const PartitionBoundSpec *node)
{
	WRITE_NODE_TYPE("PARTITIONBOUNDSPEC");

	WRITE_CHAR_FIELD(strategy);
	WRITE_BOOL_FIELD(is_default);
	WRITE_INT_FIELD(modulus);
	WRITE_INT_FIELD(remainder);
	WRITE_NODE_FIELD(listdatums);
	WRITE_NODE_FIELD(lowerdatums);
	WRITE_NODE_FIELD(upperdatums);
	WRITE_LOCATION_FIELD(location);
}

static void
_outPartitionRangeDatum(StringInfo str, const PartitionRangeDatum *node)
{
	WRITE_NODE_TYPE("PARTITIONRANGEDATUM");

	WRITE_ENUM_FIELD(kind, PartitionRangeDatumKind);
	WRITE_NODE_FIELD(value);
	WRITE_LOCATION_FIELD(location);
}

static void
_outPartitionCmd(StringInfo str, const PartitionCmd *node)
{
	WRITE_NODE_TYPE("PARTITIONCMD");

	WRITE_NODE_FIELD(name);
	WRITE_NODE_FIELD(bound);
	WRITE_BOOL_FIELD(concurrent);
}

static void
_outRTEPermissionInfo(StringInfo str, const RTEPermissionInfo *node)
{
	WRITE_NODE_TYPE("RTEPERMISSIONINFO");

	WRITE_OID_FIELD(relid);
	WRITE_BOOL_FIELD(inh);
	WRITE_UINT64_FIELD(requiredPerms);
	WRITE_OID_FIELD(checkAsUser);
	WRITE_BITMAPSET_FIELD(selectedCols);
	WRITE_BITMAPSET_FIELD(insertedCols);
	WRITE_BITMAPSET_FIELD(updatedCols);
}

static void
_outRangeTblFunction(StringInfo str, const RangeTblFunction *node)
{
	WRITE_NODE_TYPE("RANGETBLFUNCTION");

	WRITE_NODE_FIELD(funcexpr);
	WRITE_INT_FIELD(funccolcount);
	WRITE_NODE_FIELD(funccolnames);
	WRITE_NODE_FIELD(funccoltypes);
	WRITE_NODE_FIELD(funccoltypmods);
	WRITE_NODE_FIELD(funccolcollations);
	WRITE_BITMAPSET_FIELD(funcparams);
}

static void
_outTableSampleClause(StringInfo str, const TableSampleClause *node)
{
	WRITE_NODE_TYPE("TABLESAMPLECLAUSE");

	WRITE_OID_FIELD(tsmhandler);
	WRITE_NODE_FIELD(args);
	WRITE_NODE_FIELD(repeatable);
}

static void
_outWithCheckOption(StringInfo str, const WithCheckOption *node)
{
	WRITE_NODE_TYPE("WITHCHECKOPTION");

	WRITE_ENUM_FIELD(kind, WCOKind);
	WRITE_STRING_FIELD(relname);
	WRITE_STRING_FIELD(polname);
	WRITE_NODE_FIELD(qual);
	WRITE_BOOL_FIELD(cascaded);
}

static void
_outSortGroupClause(StringInfo str, const SortGroupClause *node)
{
	WRITE_NODE_TYPE("SORTGROUPCLAUSE");

	WRITE_UINT_FIELD(tleSortGroupRef);
	WRITE_OID_FIELD(eqop);
	WRITE_OID_FIELD(sortop);
	WRITE_BOOL_FIELD(nulls_first);
	WRITE_BOOL_FIELD(hashable);
}

static void
_outGroupingSet(StringInfo str, const GroupingSet *node)
{
	WRITE_NODE_TYPE("GROUPINGSET");

	WRITE_ENUM_FIELD(kind, GroupingSetKind);
	WRITE_NODE_FIELD(content);
	WRITE_LOCATION_FIELD(location);
}

static void
_outWindowClause(StringInfo str, const WindowClause *node)
{
	WRITE_NODE_TYPE("WINDOWCLAUSE");

	WRITE_STRING_FIELD(name);
	WRITE_STRING_FIELD(refname);
	WRITE_NODE_FIELD(partitionClause);
	WRITE_NODE_FIELD(orderClause);
	WRITE_INT_FIELD(frameOptions);
	WRITE_NODE_FIELD(startOffset);
	WRITE_NODE_FIELD(endOffset);
	WRITE_NODE_FIELD(runCondition);
	WRITE_OID_FIELD(startInRangeFunc);
	WRITE_OID_FIELD(endInRangeFunc);
	WRITE_OID_FIELD(inRangeColl);
	WRITE_BOOL_FIELD(inRangeAsc);
	WRITE_BOOL_FIELD(inRangeNullsFirst);
	WRITE_UINT_FIELD(winref);
	WRITE_BOOL_FIELD(copiedOrder);
}

static void
_outRowMarkClause(StringInfo str, const RowMarkClause *node)
{
	WRITE_NODE_TYPE("ROWMARKCLAUSE");

	WRITE_UINT_FIELD(rti);
	WRITE_ENUM_FIELD(strength, LockClauseStrength);
	WRITE_ENUM_FIELD(waitPolicy, LockWaitPolicy);
	WRITE_BOOL_FIELD(pushedDown);
}

static void
_outWithClause(StringInfo str, const WithClause *node)
{
	WRITE_NODE_TYPE("WITHCLAUSE");

	WRITE_NODE_FIELD(ctes);
	WRITE_BOOL_FIELD(recursive);
	WRITE_LOCATION_FIELD(location);
}

static void
_outInferClause(StringInfo str, const InferClause *node)
{
	WRITE_NODE_TYPE("INFERCLAUSE");

	WRITE_NODE_FIELD(indexElems);
	WRITE_NODE_FIELD(whereClause);
	WRITE_STRING_FIELD(conname);
	WRITE_LOCATION_FIELD(location);
}

static void
_outOnConflictClause(StringInfo str, const OnConflictClause *node)
{
	WRITE_NODE_TYPE("ONCONFLICTCLAUSE");

	WRITE_ENUM_FIELD(action, OnConflictAction);
	WRITE_NODE_FIELD(infer);
	WRITE_NODE_FIELD(targetList);
	WRITE_NODE_FIELD(whereClause);
	WRITE_LOCATION_FIELD(location);
}

static void
_outCTESearchClause(StringInfo str, const CTESearchClause *node)
{
	WRITE_NODE_TYPE("CTESEARCHCLAUSE");

	WRITE_NODE_FIELD(search_col_list);
	WRITE_BOOL_FIELD(search_breadth_first);
	WRITE_STRING_FIELD(search_seq_column);
	WRITE_LOCATION_FIELD(location);
}

static void
_outCTECycleClause(StringInfo str, const CTECycleClause *node)
{
	WRITE_NODE_TYPE("CTECYCLECLAUSE");

	WRITE_NODE_FIELD(cycle_col_list);
	WRITE_STRING_FIELD(cycle_mark_column);
	WRITE_NODE_FIELD(cycle_mark_value);
	WRITE_NODE_FIELD(cycle_mark_default);
	WRITE_STRING_FIELD(cycle_path_column);
	WRITE_LOCATION_FIELD(location);
	WRITE_OID_FIELD(cycle_mark_type);
	WRITE_INT_FIELD(cycle_mark_typmod);
	WRITE_OID_FIELD(cycle_mark_collation);
	WRITE_OID_FIELD(cycle_mark_neop);
}

static void
_outCommonTableExpr(StringInfo str, const CommonTableExpr *node)
{
	WRITE_NODE_TYPE("COMMONTABLEEXPR");

	WRITE_STRING_FIELD(ctename);
	WRITE_NODE_FIELD(aliascolnames);
	WRITE_ENUM_FIELD(ctematerialized, CTEMaterialize);
	WRITE_NODE_FIELD(ctequery);
	WRITE_NODE_FIELD(search_clause);
	WRITE_NODE_FIELD(cycle_clause);
	WRITE_LOCATION_FIELD(location);
	WRITE_BOOL_FIELD(cterecursive);
	WRITE_INT_FIELD(cterefcount);
	WRITE_NODE_FIELD(ctecolnames);
	WRITE_NODE_FIELD(ctecoltypes);
	WRITE_NODE_FIELD(ctecoltypmods);
	WRITE_NODE_FIELD(ctecolcollations);
}

static void
_outMergeWhenClause(StringInfo str, const MergeWhenClause *node)
{
	WRITE_NODE_TYPE("MERGEWHENCLAUSE");

	WRITE_BOOL_FIELD(matched);
	WRITE_ENUM_FIELD(commandType, CmdType);
	WRITE_ENUM_FIELD(override, OverridingKind);
	WRITE_NODE_FIELD(condition);
	WRITE_NODE_FIELD(targetList);
	WRITE_NODE_FIELD(values);
}

static void
_outMergeAction(StringInfo str, const MergeAction *node)
{
	WRITE_NODE_TYPE("MERGEACTION");

	WRITE_BOOL_FIELD(matched);
	WRITE_ENUM_FIELD(commandType, CmdType);
	WRITE_ENUM_FIELD(override, OverridingKind);
	WRITE_NODE_FIELD(qual);
	WRITE_NODE_FIELD(targetList);
	WRITE_NODE_FIELD(updateColnos);
}

static void
_outTriggerTransition(StringInfo str, const TriggerTransition *node)
{
	WRITE_NODE_TYPE("TRIGGERTRANSITION");

	WRITE_STRING_FIELD(name);
	WRITE_BOOL_FIELD(isNew);
	WRITE_BOOL_FIELD(isTable);
}

static void
_outJsonOutput(StringInfo str, const JsonOutput *node)
{
	WRITE_NODE_TYPE("JSONOUTPUT");

	WRITE_NODE_FIELD(typeName);
	WRITE_NODE_FIELD(returning);
}

static void
_outJsonKeyValue(StringInfo str, const JsonKeyValue *node)
{
	WRITE_NODE_TYPE("JSONKEYVALUE");

	WRITE_NODE_FIELD(key);
	WRITE_NODE_FIELD(value);
}

static void
_outJsonObjectConstructor(StringInfo str, const JsonObjectConstructor *node)
{
	WRITE_NODE_TYPE("JSONOBJECTCONSTRUCTOR");

	WRITE_NODE_FIELD(exprs);
	WRITE_NODE_FIELD(output);
	WRITE_BOOL_FIELD(absent_on_null);
	WRITE_BOOL_FIELD(unique);
	WRITE_LOCATION_FIELD(location);
}

static void
_outJsonArrayConstructor(StringInfo str, const JsonArrayConstructor *node)
{
	WRITE_NODE_TYPE("JSONARRAYCONSTRUCTOR");

	WRITE_NODE_FIELD(exprs);
	WRITE_NODE_FIELD(output);
	WRITE_BOOL_FIELD(absent_on_null);
	WRITE_LOCATION_FIELD(location);
}

static void
_outJsonArrayQueryConstructor(StringInfo str, const JsonArrayQueryConstructor *node)
{
	WRITE_NODE_TYPE("JSONARRAYQUERYCONSTRUCTOR");

	WRITE_NODE_FIELD(query);
	WRITE_NODE_FIELD(output);
	WRITE_NODE_FIELD(format);
	WRITE_BOOL_FIELD(absent_on_null);
	WRITE_LOCATION_FIELD(location);
}

static void
_outJsonAggConstructor(StringInfo str, const JsonAggConstructor *node)
{
	WRITE_NODE_TYPE("JSONAGGCONSTRUCTOR");

	WRITE_NODE_FIELD(output);
	WRITE_NODE_FIELD(agg_filter);
	WRITE_NODE_FIELD(agg_order);
	WRITE_NODE_FIELD(over);
	WRITE_LOCATION_FIELD(location);
}

static void
_outJsonObjectAgg(StringInfo str, const JsonObjectAgg *node)
{
	WRITE_NODE_TYPE("JSONOBJECTAGG");

	WRITE_NODE_FIELD(constructor);
	WRITE_NODE_FIELD(arg);
	WRITE_BOOL_FIELD(absent_on_null);
	WRITE_BOOL_FIELD(unique);
}

static void
_outJsonArrayAgg(StringInfo str, const JsonArrayAgg *node)
{
	WRITE_NODE_TYPE("JSONARRAYAGG");

	WRITE_NODE_FIELD(constructor);
	WRITE_NODE_FIELD(arg);
	WRITE_BOOL_FIELD(absent_on_null);
}

static void
_outRawStmt(StringInfo str, const RawStmt *node)
{
	WRITE_NODE_TYPE("RAWSTMT");

	WRITE_NODE_FIELD(stmt);
	WRITE_LOCATION_FIELD(stmt_location);
	WRITE_INT_FIELD(stmt_len);
}

static void
_outInsertStmt(StringInfo str, const InsertStmt *node)
{
	WRITE_NODE_TYPE("INSERTSTMT");

	WRITE_NODE_FIELD(relation);
	WRITE_NODE_FIELD(cols);
	WRITE_NODE_FIELD(selectStmt);
	WRITE_NODE_FIELD(onConflictClause);
	WRITE_NODE_FIELD(returningList);
	WRITE_NODE_FIELD(withClause);
	WRITE_ENUM_FIELD(override, OverridingKind);
}

static void
_outDeleteStmt(StringInfo str, const DeleteStmt *node)
{
	WRITE_NODE_TYPE("DELETESTMT");

	WRITE_NODE_FIELD(relation);
	WRITE_NODE_FIELD(usingClause);
	WRITE_NODE_FIELD(whereClause);
	WRITE_NODE_FIELD(returningList);
	WRITE_NODE_FIELD(withClause);
}

static void
_outUpdateStmt(StringInfo str, const UpdateStmt *node)
{
	WRITE_NODE_TYPE("UPDATESTMT");

	WRITE_NODE_FIELD(relation);
	WRITE_NODE_FIELD(targetList);
	WRITE_NODE_FIELD(whereClause);
	WRITE_NODE_FIELD(fromClause);
	WRITE_NODE_FIELD(returningList);
	WRITE_NODE_FIELD(withClause);
}

static void
_outMergeStmt(StringInfo str, const MergeStmt *node)
{
	WRITE_NODE_TYPE("MERGESTMT");

	WRITE_NODE_FIELD(relation);
	WRITE_NODE_FIELD(sourceRelation);
	WRITE_NODE_FIELD(joinCondition);
	WRITE_NODE_FIELD(mergeWhenClauses);
	WRITE_NODE_FIELD(withClause);
}

static void
_outSelectStmt(StringInfo str, const SelectStmt *node)
{
	WRITE_NODE_TYPE("SELECTSTMT");

	WRITE_NODE_FIELD(distinctClause);
	WRITE_NODE_FIELD(intoClause);
	WRITE_NODE_FIELD(targetList);
	WRITE_NODE_FIELD(fromClause);
	WRITE_NODE_FIELD(whereClause);
	WRITE_NODE_FIELD(groupClause);
	WRITE_BOOL_FIELD(groupDistinct);
	WRITE_NODE_FIELD(havingClause);
	WRITE_NODE_FIELD(windowClause);
	WRITE_NODE_FIELD(valuesLists);
	WRITE_NODE_FIELD(sortClause);
	WRITE_NODE_FIELD(limitOffset);
	WRITE_NODE_FIELD(limitCount);
	WRITE_ENUM_FIELD(limitOption, LimitOption);
	WRITE_NODE_FIELD(lockingClause);
	WRITE_NODE_FIELD(withClause);
	WRITE_ENUM_FIELD(op, SetOperation);
	WRITE_BOOL_FIELD(all);
	WRITE_NODE_FIELD(larg);
	WRITE_NODE_FIELD(rarg);
}

static void
_outSetOperationStmt(StringInfo str, const SetOperationStmt *node)
{
	WRITE_NODE_TYPE("SETOPERATIONSTMT");

	WRITE_ENUM_FIELD(op, SetOperation);
	WRITE_BOOL_FIELD(all);
	WRITE_NODE_FIELD(larg);
	WRITE_NODE_FIELD(rarg);
	WRITE_NODE_FIELD(colTypes);
	WRITE_NODE_FIELD(colTypmods);
	WRITE_NODE_FIELD(colCollations);
	WRITE_NODE_FIELD(groupClauses);
}

static void
_outReturnStmt(StringInfo str, const ReturnStmt *node)
{
	WRITE_NODE_TYPE("RETURNSTMT");

	WRITE_NODE_FIELD(returnval);
}

static void
_outPLAssignStmt(StringInfo str, const PLAssignStmt *node)
{
	WRITE_NODE_TYPE("PLASSIGNSTMT");

	WRITE_STRING_FIELD(name);
	WRITE_NODE_FIELD(indirection);
	WRITE_INT_FIELD(nnames);
	WRITE_NODE_FIELD(val);
	WRITE_LOCATION_FIELD(location);
}

static void
_outCreateSchemaStmt(StringInfo str, const CreateSchemaStmt *node)
{
	WRITE_NODE_TYPE("CREATESCHEMASTMT");

	WRITE_STRING_FIELD(schemaname);
	WRITE_NODE_FIELD(authrole);
	WRITE_NODE_FIELD(schemaElts);
	WRITE_BOOL_FIELD(if_not_exists);
}

static void
_outAlterTableStmt(StringInfo str, const AlterTableStmt *node)
{
	WRITE_NODE_TYPE("ALTERTABLESTMT");

	WRITE_NODE_FIELD(relation);
	WRITE_NODE_FIELD(cmds);
	WRITE_ENUM_FIELD(objtype, ObjectType);
	WRITE_BOOL_FIELD(missing_ok);
}

static void
_outReplicaIdentityStmt(StringInfo str, const ReplicaIdentityStmt *node)
{
	WRITE_NODE_TYPE("REPLICAIDENTITYSTMT");

	WRITE_CHAR_FIELD(identity_type);
	WRITE_STRING_FIELD(name);
}

static void
_outAlterTableCmd(StringInfo str, const AlterTableCmd *node)
{
	WRITE_NODE_TYPE("ALTERTABLECMD");

	WRITE_ENUM_FIELD(subtype, AlterTableType);
	WRITE_STRING_FIELD(name);
	WRITE_INT_FIELD(num);
	WRITE_NODE_FIELD(newowner);
	WRITE_NODE_FIELD(def);
	WRITE_ENUM_FIELD(behavior, DropBehavior);
	WRITE_BOOL_FIELD(missing_ok);
	WRITE_BOOL_FIELD(recurse);
}

static void
_outAlterCollationStmt(StringInfo str, const AlterCollationStmt *node)
{
	WRITE_NODE_TYPE("ALTERCOLLATIONSTMT");

	WRITE_NODE_FIELD(collname);
}

static void
_outAlterDomainStmt(StringInfo str, const AlterDomainStmt *node)
{
	WRITE_NODE_TYPE("ALTERDOMAINSTMT");

	WRITE_CHAR_FIELD(subtype);
	WRITE_NODE_FIELD(typeName);
	WRITE_STRING_FIELD(name);
	WRITE_NODE_FIELD(def);
	WRITE_ENUM_FIELD(behavior, DropBehavior);
	WRITE_BOOL_FIELD(missing_ok);
}

static void
_outGrantStmt(StringInfo str, const GrantStmt *node)
{
	WRITE_NODE_TYPE("GRANTSTMT");

	WRITE_BOOL_FIELD(is_grant);
	WRITE_ENUM_FIELD(targtype, GrantTargetType);
	WRITE_ENUM_FIELD(objtype, ObjectType);
	WRITE_NODE_FIELD(objects);
	WRITE_NODE_FIELD(privileges);
	WRITE_NODE_FIELD(grantees);
	WRITE_BOOL_FIELD(grant_option);
	WRITE_NODE_FIELD(grantor);
	WRITE_ENUM_FIELD(behavior, DropBehavior);
}

static void
_outObjectWithArgs(StringInfo str, const ObjectWithArgs *node)
{
	WRITE_NODE_TYPE("OBJECTWITHARGS");

	WRITE_NODE_FIELD(objname);
	WRITE_NODE_FIELD(objargs);
	WRITE_NODE_FIELD(objfuncargs);
	WRITE_BOOL_FIELD(args_unspecified);
}

static void
_outAccessPriv(StringInfo str, const AccessPriv *node)
{
	WRITE_NODE_TYPE("ACCESSPRIV");

	WRITE_STRING_FIELD(priv_name);
	WRITE_NODE_FIELD(cols);
}

static void
_outGrantRoleStmt(StringInfo str, const GrantRoleStmt *node)
{
	WRITE_NODE_TYPE("GRANTROLESTMT");

	WRITE_NODE_FIELD(granted_roles);
	WRITE_NODE_FIELD(grantee_roles);
	WRITE_BOOL_FIELD(is_grant);
	WRITE_NODE_FIELD(opt);
	WRITE_NODE_FIELD(grantor);
	WRITE_ENUM_FIELD(behavior, DropBehavior);
}

static void
_outAlterDefaultPrivilegesStmt(StringInfo str, const AlterDefaultPrivilegesStmt *node)
{
	WRITE_NODE_TYPE("ALTERDEFAULTPRIVILEGESSTMT");

	WRITE_NODE_FIELD(options);
	WRITE_NODE_FIELD(action);
}

static void
_outCopyStmt(StringInfo str, const CopyStmt *node)
{
	WRITE_NODE_TYPE("COPYSTMT");

	WRITE_NODE_FIELD(relation);
	WRITE_NODE_FIELD(query);
	WRITE_NODE_FIELD(attlist);
	WRITE_BOOL_FIELD(is_from);
	WRITE_BOOL_FIELD(is_program);
	WRITE_STRING_FIELD(filename);
	WRITE_NODE_FIELD(options);
	WRITE_NODE_FIELD(whereClause);
}

static void
_outVariableSetStmt(StringInfo str, const VariableSetStmt *node)
{
	WRITE_NODE_TYPE("VARIABLESETSTMT");

	WRITE_ENUM_FIELD(kind, VariableSetKind);
	WRITE_STRING_FIELD(name);
	WRITE_NODE_FIELD(args);
	WRITE_BOOL_FIELD(is_local);
}

static void
_outVariableShowStmt(StringInfo str, const VariableShowStmt *node)
{
	WRITE_NODE_TYPE("VARIABLESHOWSTMT");

	WRITE_STRING_FIELD(name);
}

static void
_outCreateStmt(StringInfo str, const CreateStmt *node)
{
	WRITE_NODE_TYPE("CREATESTMT");

	WRITE_NODE_FIELD(relation);
	WRITE_NODE_FIELD(tableElts);
	WRITE_NODE_FIELD(inhRelations);
	WRITE_NODE_FIELD(partbound);
	WRITE_NODE_FIELD(partspec);
	WRITE_NODE_FIELD(ofTypename);
	WRITE_NODE_FIELD(constraints);
	WRITE_NODE_FIELD(options);
	WRITE_ENUM_FIELD(oncommit, OnCommitAction);
	WRITE_STRING_FIELD(tablespacename);
	WRITE_STRING_FIELD(accessMethod);
	WRITE_BOOL_FIELD(if_not_exists);
}

static void
_outCreateTableSpaceStmt(StringInfo str, const CreateTableSpaceStmt *node)
{
	WRITE_NODE_TYPE("CREATETABLESPACESTMT");

	WRITE_STRING_FIELD(tablespacename);
	WRITE_NODE_FIELD(owner);
	WRITE_STRING_FIELD(location);
	WRITE_NODE_FIELD(options);
}

static void
_outDropTableSpaceStmt(StringInfo str, const DropTableSpaceStmt *node)
{
	WRITE_NODE_TYPE("DROPTABLESPACESTMT");

	WRITE_STRING_FIELD(tablespacename);
	WRITE_BOOL_FIELD(missing_ok);
}

static void
_outAlterTableSpaceOptionsStmt(StringInfo str, const AlterTableSpaceOptionsStmt *node)
{
	WRITE_NODE_TYPE("ALTERTABLESPACEOPTIONSSTMT");

	WRITE_STRING_FIELD(tablespacename);
	WRITE_NODE_FIELD(options);
	WRITE_BOOL_FIELD(isReset);
}

static void
_outAlterTableMoveAllStmt(StringInfo str, const AlterTableMoveAllStmt *node)
{
	WRITE_NODE_TYPE("ALTERTABLEMOVEALLSTMT");

	WRITE_STRING_FIELD(orig_tablespacename);
	WRITE_ENUM_FIELD(objtype, ObjectType);
	WRITE_NODE_FIELD(roles);
	WRITE_STRING_FIELD(new_tablespacename);
	WRITE_BOOL_FIELD(nowait);
}

static void
_outCreateExtensionStmt(StringInfo str, const CreateExtensionStmt *node)
{
	WRITE_NODE_TYPE("CREATEEXTENSIONSTMT");

	WRITE_STRING_FIELD(extname);
	WRITE_BOOL_FIELD(if_not_exists);
	WRITE_NODE_FIELD(options);
}

static void
_outAlterExtensionStmt(StringInfo str, const AlterExtensionStmt *node)
{
	WRITE_NODE_TYPE("ALTEREXTENSIONSTMT");

	WRITE_STRING_FIELD(extname);
	WRITE_NODE_FIELD(options);
}

static void
_outAlterExtensionContentsStmt(StringInfo str, const AlterExtensionContentsStmt *node)
{
	WRITE_NODE_TYPE("ALTEREXTENSIONCONTENTSSTMT");

	WRITE_STRING_FIELD(extname);
	WRITE_INT_FIELD(action);
	WRITE_ENUM_FIELD(objtype, ObjectType);
	WRITE_NODE_FIELD(object);
}

static void
_outCreateFdwStmt(StringInfo str, const CreateFdwStmt *node)
{
	WRITE_NODE_TYPE("CREATEFDWSTMT");

	WRITE_STRING_FIELD(fdwname);
	WRITE_NODE_FIELD(func_options);
	WRITE_NODE_FIELD(options);
}

static void
_outAlterFdwStmt(StringInfo str, const AlterFdwStmt *node)
{
	WRITE_NODE_TYPE("ALTERFDWSTMT");

	WRITE_STRING_FIELD(fdwname);
	WRITE_NODE_FIELD(func_options);
	WRITE_NODE_FIELD(options);
}

static void
_outCreateForeignServerStmt(StringInfo str, const CreateForeignServerStmt *node)
{
	WRITE_NODE_TYPE("CREATEFOREIGNSERVERSTMT");

	WRITE_STRING_FIELD(servername);
	WRITE_STRING_FIELD(servertype);
	WRITE_STRING_FIELD(version);
	WRITE_STRING_FIELD(fdwname);
	WRITE_BOOL_FIELD(if_not_exists);
	WRITE_NODE_FIELD(options);
}

static void
_outAlterForeignServerStmt(StringInfo str, const AlterForeignServerStmt *node)
{
	WRITE_NODE_TYPE("ALTERFOREIGNSERVERSTMT");

	WRITE_STRING_FIELD(servername);
	WRITE_STRING_FIELD(version);
	WRITE_NODE_FIELD(options);
	WRITE_BOOL_FIELD(has_version);
}

static void
_outCreateForeignTableStmt(StringInfo str, const CreateForeignTableStmt *node)
{
	WRITE_NODE_TYPE("CREATEFOREIGNTABLESTMT");

	WRITE_NODE_FIELD(base.relation);
	WRITE_NODE_FIELD(base.tableElts);
	WRITE_NODE_FIELD(base.inhRelations);
	WRITE_NODE_FIELD(base.partbound);
	WRITE_NODE_FIELD(base.partspec);
	WRITE_NODE_FIELD(base.ofTypename);
	WRITE_NODE_FIELD(base.constraints);
	WRITE_NODE_FIELD(base.options);
	WRITE_ENUM_FIELD(base.oncommit, OnCommitAction);
	WRITE_STRING_FIELD(base.tablespacename);
	WRITE_STRING_FIELD(base.accessMethod);
	WRITE_BOOL_FIELD(base.if_not_exists);
	WRITE_STRING_FIELD(servername);
	WRITE_NODE_FIELD(options);
}

static void
_outCreateUserMappingStmt(StringInfo str, const CreateUserMappingStmt *node)
{
	WRITE_NODE_TYPE("CREATEUSERMAPPINGSTMT");

	WRITE_NODE_FIELD(user);
	WRITE_STRING_FIELD(servername);
	WRITE_BOOL_FIELD(if_not_exists);
	WRITE_NODE_FIELD(options);
}

static void
_outAlterUserMappingStmt(StringInfo str, const AlterUserMappingStmt *node)
{
	WRITE_NODE_TYPE("ALTERUSERMAPPINGSTMT");

	WRITE_NODE_FIELD(user);
	WRITE_STRING_FIELD(servername);
	WRITE_NODE_FIELD(options);
}

static void
_outDropUserMappingStmt(StringInfo str, const DropUserMappingStmt *node)
{
	WRITE_NODE_TYPE("DROPUSERMAPPINGSTMT");

	WRITE_NODE_FIELD(user);
	WRITE_STRING_FIELD(servername);
	WRITE_BOOL_FIELD(missing_ok);
}

static void
_outImportForeignSchemaStmt(StringInfo str, const ImportForeignSchemaStmt *node)
{
	WRITE_NODE_TYPE("IMPORTFOREIGNSCHEMASTMT");

	WRITE_STRING_FIELD(server_name);
	WRITE_STRING_FIELD(remote_schema);
	WRITE_STRING_FIELD(local_schema);
	WRITE_ENUM_FIELD(list_type, ImportForeignSchemaType);
	WRITE_NODE_FIELD(table_list);
	WRITE_NODE_FIELD(options);
}

static void
_outCreatePolicyStmt(StringInfo str, const CreatePolicyStmt *node)
{
	WRITE_NODE_TYPE("CREATEPOLICYSTMT");

	WRITE_STRING_FIELD(policy_name);
	WRITE_NODE_FIELD(table);
	WRITE_STRING_FIELD(cmd_name);
	WRITE_BOOL_FIELD(permissive);
	WRITE_NODE_FIELD(roles);
	WRITE_NODE_FIELD(qual);
	WRITE_NODE_FIELD(with_check);
}

static void
_outAlterPolicyStmt(StringInfo str, const AlterPolicyStmt *node)
{
	WRITE_NODE_TYPE("ALTERPOLICYSTMT");

	WRITE_STRING_FIELD(policy_name);
	WRITE_NODE_FIELD(table);
	WRITE_NODE_FIELD(roles);
	WRITE_NODE_FIELD(qual);
	WRITE_NODE_FIELD(with_check);
}

static void
_outCreateAmStmt(StringInfo str, const CreateAmStmt *node)
{
	WRITE_NODE_TYPE("CREATEAMSTMT");

	WRITE_STRING_FIELD(amname);
	WRITE_NODE_FIELD(handler_name);
	WRITE_CHAR_FIELD(amtype);
}

static void
_outCreateTrigStmt(StringInfo str, const CreateTrigStmt *node)
{
	WRITE_NODE_TYPE("CREATETRIGSTMT");

	WRITE_BOOL_FIELD(replace);
	WRITE_BOOL_FIELD(isconstraint);
	WRITE_STRING_FIELD(trigname);
	WRITE_NODE_FIELD(relation);
	WRITE_NODE_FIELD(funcname);
	WRITE_NODE_FIELD(args);
	WRITE_BOOL_FIELD(row);
	WRITE_INT_FIELD(timing);
	WRITE_INT_FIELD(events);
	WRITE_NODE_FIELD(columns);
	WRITE_NODE_FIELD(whenClause);
	WRITE_NODE_FIELD(transitionRels);
	WRITE_BOOL_FIELD(deferrable);
	WRITE_BOOL_FIELD(initdeferred);
	WRITE_NODE_FIELD(constrrel);
}

static void
_outCreateEventTrigStmt(StringInfo str, const CreateEventTrigStmt *node)
{
	WRITE_NODE_TYPE("CREATEEVENTTRIGSTMT");

	WRITE_STRING_FIELD(trigname);
	WRITE_STRING_FIELD(eventname);
	WRITE_NODE_FIELD(whenclause);
	WRITE_NODE_FIELD(funcname);
}

static void
_outAlterEventTrigStmt(StringInfo str, const AlterEventTrigStmt *node)
{
	WRITE_NODE_TYPE("ALTEREVENTTRIGSTMT");

	WRITE_STRING_FIELD(trigname);
	WRITE_CHAR_FIELD(tgenabled);
}

static void
_outCreatePLangStmt(StringInfo str, const CreatePLangStmt *node)
{
	WRITE_NODE_TYPE("CREATEPLANGSTMT");

	WRITE_BOOL_FIELD(replace);
	WRITE_STRING_FIELD(plname);
	WRITE_NODE_FIELD(plhandler);
	WRITE_NODE_FIELD(plinline);
	WRITE_NODE_FIELD(plvalidator);
	WRITE_BOOL_FIELD(pltrusted);
}

static void
_outCreateRoleStmt(StringInfo str, const CreateRoleStmt *node)
{
	WRITE_NODE_TYPE("CREATEROLESTMT");

	WRITE_ENUM_FIELD(stmt_type, RoleStmtType);
	WRITE_STRING_FIELD(role);
	WRITE_NODE_FIELD(options);
}

static void
_outAlterRoleStmt(StringInfo str, const AlterRoleStmt *node)
{
	WRITE_NODE_TYPE("ALTERROLESTMT");

	WRITE_NODE_FIELD(role);
	WRITE_NODE_FIELD(options);
	WRITE_INT_FIELD(action);
}

static void
_outAlterRoleSetStmt(StringInfo str, const AlterRoleSetStmt *node)
{
	WRITE_NODE_TYPE("ALTERROLESETSTMT");

	WRITE_NODE_FIELD(role);
	WRITE_STRING_FIELD(database);
	WRITE_NODE_FIELD(setstmt);
}

static void
_outDropRoleStmt(StringInfo str, const DropRoleStmt *node)
{
	WRITE_NODE_TYPE("DROPROLESTMT");

	WRITE_NODE_FIELD(roles);
	WRITE_BOOL_FIELD(missing_ok);
}

static void
_outCreateSeqStmt(StringInfo str, const CreateSeqStmt *node)
{
	WRITE_NODE_TYPE("CREATESEQSTMT");

	WRITE_NODE_FIELD(sequence);
	WRITE_NODE_FIELD(options);
	WRITE_OID_FIELD(ownerId);
	WRITE_BOOL_FIELD(for_identity);
	WRITE_BOOL_FIELD(if_not_exists);
}

static void
_outAlterSeqStmt(StringInfo str, const AlterSeqStmt *node)
{
	WRITE_NODE_TYPE("ALTERSEQSTMT");

	WRITE_NODE_FIELD(sequence);
	WRITE_NODE_FIELD(options);
	WRITE_BOOL_FIELD(for_identity);
	WRITE_BOOL_FIELD(missing_ok);
}

static void
_outDefineStmt(StringInfo str, const DefineStmt *node)
{
	WRITE_NODE_TYPE("DEFINESTMT");

	WRITE_ENUM_FIELD(kind, ObjectType);
	WRITE_BOOL_FIELD(oldstyle);
	WRITE_NODE_FIELD(defnames);
	WRITE_NODE_FIELD(args);
	WRITE_NODE_FIELD(definition);
	WRITE_BOOL_FIELD(if_not_exists);
	WRITE_BOOL_FIELD(replace);
}

static void
_outCreateDomainStmt(StringInfo str, const CreateDomainStmt *node)
{
	WRITE_NODE_TYPE("CREATEDOMAINSTMT");

	WRITE_NODE_FIELD(domainname);
	WRITE_NODE_FIELD(typeName);
	WRITE_NODE_FIELD(collClause);
	WRITE_NODE_FIELD(constraints);
}

static void
_outCreateOpClassStmt(StringInfo str, const CreateOpClassStmt *node)
{
	WRITE_NODE_TYPE("CREATEOPCLASSSTMT");

	WRITE_NODE_FIELD(opclassname);
	WRITE_NODE_FIELD(opfamilyname);
	WRITE_STRING_FIELD(amname);
	WRITE_NODE_FIELD(datatype);
	WRITE_NODE_FIELD(items);
	WRITE_BOOL_FIELD(isDefault);
}

static void
_outCreateOpClassItem(StringInfo str, const CreateOpClassItem *node)
{
	WRITE_NODE_TYPE("CREATEOPCLASSITEM");

	WRITE_INT_FIELD(itemtype);
	WRITE_NODE_FIELD(name);
	WRITE_INT_FIELD(number);
	WRITE_NODE_FIELD(order_family);
	WRITE_NODE_FIELD(class_args);
	WRITE_NODE_FIELD(storedtype);
}

static void
_outCreateOpFamilyStmt(StringInfo str, const CreateOpFamilyStmt *node)
{
	WRITE_NODE_TYPE("CREATEOPFAMILYSTMT");

	WRITE_NODE_FIELD(opfamilyname);
	WRITE_STRING_FIELD(amname);
}

static void
_outAlterOpFamilyStmt(StringInfo str, const AlterOpFamilyStmt *node)
{
	WRITE_NODE_TYPE("ALTEROPFAMILYSTMT");

	WRITE_NODE_FIELD(opfamilyname);
	WRITE_STRING_FIELD(amname);
	WRITE_BOOL_FIELD(isDrop);
	WRITE_NODE_FIELD(items);
}

static void
_outDropStmt(StringInfo str, const DropStmt *node)
{
	WRITE_NODE_TYPE("DROPSTMT");

	WRITE_NODE_FIELD(objects);
	WRITE_ENUM_FIELD(removeType, ObjectType);
	WRITE_ENUM_FIELD(behavior, DropBehavior);
	WRITE_BOOL_FIELD(missing_ok);
	WRITE_BOOL_FIELD(concurrent);
}

static void
_outTruncateStmt(StringInfo str, const TruncateStmt *node)
{
	WRITE_NODE_TYPE("TRUNCATESTMT");

	WRITE_NODE_FIELD(relations);
	WRITE_BOOL_FIELD(restart_seqs);
	WRITE_ENUM_FIELD(behavior, DropBehavior);
}

static void
_outCommentStmt(StringInfo str, const CommentStmt *node)
{
	WRITE_NODE_TYPE("COMMENTSTMT");

	WRITE_ENUM_FIELD(objtype, ObjectType);
	WRITE_NODE_FIELD(object);
	WRITE_STRING_FIELD(comment);
}

static void
_outSecLabelStmt(StringInfo str, const SecLabelStmt *node)
{
	WRITE_NODE_TYPE("SECLABELSTMT");

	WRITE_ENUM_FIELD(objtype, ObjectType);
	WRITE_NODE_FIELD(object);
	WRITE_STRING_FIELD(provider);
	WRITE_STRING_FIELD(label);
}

static void
_outDeclareCursorStmt(StringInfo str, const DeclareCursorStmt *node)
{
	WRITE_NODE_TYPE("DECLARECURSORSTMT");

	WRITE_STRING_FIELD(portalname);
	WRITE_INT_FIELD(options);
	WRITE_NODE_FIELD(query);
}

static void
_outClosePortalStmt(StringInfo str, const ClosePortalStmt *node)
{
	WRITE_NODE_TYPE("CLOSEPORTALSTMT");

	WRITE_STRING_FIELD(portalname);
}

static void
_outFetchStmt(StringInfo str, const FetchStmt *node)
{
	WRITE_NODE_TYPE("FETCHSTMT");

	WRITE_ENUM_FIELD(direction, FetchDirection);
	WRITE_LONG_FIELD(howMany);
	WRITE_STRING_FIELD(portalname);
	WRITE_BOOL_FIELD(ismove);
}

static void
_outIndexStmt(StringInfo str, const IndexStmt *node)
{
	WRITE_NODE_TYPE("INDEXSTMT");

	WRITE_STRING_FIELD(idxname);
	WRITE_NODE_FIELD(relation);
	WRITE_STRING_FIELD(accessMethod);
	WRITE_STRING_FIELD(tableSpace);
	WRITE_NODE_FIELD(indexParams);
	WRITE_NODE_FIELD(indexIncludingParams);
	WRITE_NODE_FIELD(options);
	WRITE_NODE_FIELD(whereClause);
	WRITE_NODE_FIELD(excludeOpNames);
	WRITE_STRING_FIELD(idxcomment);
	WRITE_OID_FIELD(indexOid);
	WRITE_OID_FIELD(oldNumber);
	WRITE_UINT_FIELD(oldCreateSubid);
	WRITE_UINT_FIELD(oldFirstRelfilelocatorSubid);
	WRITE_BOOL_FIELD(unique);
	WRITE_BOOL_FIELD(nulls_not_distinct);
	WRITE_BOOL_FIELD(primary);
	WRITE_BOOL_FIELD(isconstraint);
	WRITE_BOOL_FIELD(deferrable);
	WRITE_BOOL_FIELD(initdeferred);
	WRITE_BOOL_FIELD(transformed);
	WRITE_BOOL_FIELD(concurrent);
	WRITE_BOOL_FIELD(if_not_exists);
	WRITE_BOOL_FIELD(reset_default_tblspc);
}

static void
_outCreateStatsStmt(StringInfo str, const CreateStatsStmt *node)
{
	WRITE_NODE_TYPE("CREATESTATSSTMT");

	WRITE_NODE_FIELD(defnames);
	WRITE_NODE_FIELD(stat_types);
	WRITE_NODE_FIELD(exprs);
	WRITE_NODE_FIELD(relations);
	WRITE_STRING_FIELD(stxcomment);
	WRITE_BOOL_FIELD(transformed);
	WRITE_BOOL_FIELD(if_not_exists);
}

static void
_outStatsElem(StringInfo str, const StatsElem *node)
{
	WRITE_NODE_TYPE("STATSELEM");

	WRITE_STRING_FIELD(name);
	WRITE_NODE_FIELD(expr);
}

static void
_outAlterStatsStmt(StringInfo str, const AlterStatsStmt *node)
{
	WRITE_NODE_TYPE("ALTERSTATSSTMT");

	WRITE_NODE_FIELD(defnames);
	WRITE_INT_FIELD(stxstattarget);
	WRITE_BOOL_FIELD(missing_ok);
}

static void
_outCreateFunctionStmt(StringInfo str, const CreateFunctionStmt *node)
{
	WRITE_NODE_TYPE("CREATEFUNCTIONSTMT");

	WRITE_BOOL_FIELD(is_procedure);
	WRITE_BOOL_FIELD(replace);
	WRITE_NODE_FIELD(funcname);
	WRITE_NODE_FIELD(parameters);
	WRITE_NODE_FIELD(returnType);
	WRITE_NODE_FIELD(options);
	WRITE_NODE_FIELD(sql_body);
}

static void
_outFunctionParameter(StringInfo str, const FunctionParameter *node)
{
	WRITE_NODE_TYPE("FUNCTIONPARAMETER");

	WRITE_STRING_FIELD(name);
	WRITE_NODE_FIELD(argType);
	WRITE_ENUM_FIELD(mode, FunctionParameterMode);
	WRITE_NODE_FIELD(defexpr);
}

static void
_outAlterFunctionStmt(StringInfo str, const AlterFunctionStmt *node)
{
	WRITE_NODE_TYPE("ALTERFUNCTIONSTMT");

	WRITE_ENUM_FIELD(objtype, ObjectType);
	WRITE_NODE_FIELD(func);
	WRITE_NODE_FIELD(actions);
}

static void
_outDoStmt(StringInfo str, const DoStmt *node)
{
	WRITE_NODE_TYPE("DOSTMT");

	WRITE_NODE_FIELD(args);
}

static void
_outCallStmt(StringInfo str, const CallStmt *node)
{
	WRITE_NODE_TYPE("CALLSTMT");

	WRITE_NODE_FIELD(funccall);
	WRITE_NODE_FIELD(funcexpr);
	WRITE_NODE_FIELD(outargs);
}

static void
_outRenameStmt(StringInfo str, const RenameStmt *node)
{
	WRITE_NODE_TYPE("RENAMESTMT");

	WRITE_ENUM_FIELD(renameType, ObjectType);
	WRITE_ENUM_FIELD(relationType, ObjectType);
	WRITE_NODE_FIELD(relation);
	WRITE_NODE_FIELD(object);
	WRITE_STRING_FIELD(subname);
	WRITE_STRING_FIELD(newname);
	WRITE_ENUM_FIELD(behavior, DropBehavior);
	WRITE_BOOL_FIELD(missing_ok);
}

static void
_outAlterObjectDependsStmt(StringInfo str, const AlterObjectDependsStmt *node)
{
	WRITE_NODE_TYPE("ALTEROBJECTDEPENDSSTMT");

	WRITE_ENUM_FIELD(objectType, ObjectType);
	WRITE_NODE_FIELD(relation);
	WRITE_NODE_FIELD(object);
	WRITE_NODE_FIELD(extname);
	WRITE_BOOL_FIELD(remove);
}

static void
_outAlterObjectSchemaStmt(StringInfo str, const AlterObjectSchemaStmt *node)
{
	WRITE_NODE_TYPE("ALTEROBJECTSCHEMASTMT");

	WRITE_ENUM_FIELD(objectType, ObjectType);
	WRITE_NODE_FIELD(relation);
	WRITE_NODE_FIELD(object);
	WRITE_STRING_FIELD(newschema);
	WRITE_BOOL_FIELD(missing_ok);
}

static void
_outAlterOwnerStmt(StringInfo str, const AlterOwnerStmt *node)
{
	WRITE_NODE_TYPE("ALTEROWNERSTMT");

	WRITE_ENUM_FIELD(objectType, ObjectType);
	WRITE_NODE_FIELD(relation);
	WRITE_NODE_FIELD(object);
	WRITE_NODE_FIELD(newowner);
}

static void
_outAlterOperatorStmt(StringInfo str, const AlterOperatorStmt *node)
{
	WRITE_NODE_TYPE("ALTEROPERATORSTMT");

	WRITE_NODE_FIELD(opername);
	WRITE_NODE_FIELD(options);
}

static void
_outAlterTypeStmt(StringInfo str, const AlterTypeStmt *node)
{
	WRITE_NODE_TYPE("ALTERTYPESTMT");

	WRITE_NODE_FIELD(typeName);
	WRITE_NODE_FIELD(options);
}

static void
_outRuleStmt(StringInfo str, const RuleStmt *node)
{
	WRITE_NODE_TYPE("RULESTMT");

	WRITE_NODE_FIELD(relation);
	WRITE_STRING_FIELD(rulename);
	WRITE_NODE_FIELD(whereClause);
	WRITE_ENUM_FIELD(event, CmdType);
	WRITE_BOOL_FIELD(instead);
	WRITE_NODE_FIELD(actions);
	WRITE_BOOL_FIELD(replace);
}

static void
_outNotifyStmt(StringInfo str, const NotifyStmt *node)
{
	WRITE_NODE_TYPE("NOTIFYSTMT");

	WRITE_STRING_FIELD(conditionname);
	WRITE_STRING_FIELD(payload);
}

static void
_outListenStmt(StringInfo str, const ListenStmt *node)
{
	WRITE_NODE_TYPE("LISTENSTMT");

	WRITE_STRING_FIELD(conditionname);
}

static void
_outUnlistenStmt(StringInfo str, const UnlistenStmt *node)
{
	WRITE_NODE_TYPE("UNLISTENSTMT");

	WRITE_STRING_FIELD(conditionname);
}

static void
_outTransactionStmt(StringInfo str, const TransactionStmt *node)
{
	WRITE_NODE_TYPE("TRANSACTIONSTMT");

	WRITE_ENUM_FIELD(kind, TransactionStmtKind);
	WRITE_NODE_FIELD(options);
	WRITE_STRING_FIELD(savepoint_name);
	WRITE_STRING_FIELD(gid);
	WRITE_BOOL_FIELD(chain);
}

static void
_outCompositeTypeStmt(StringInfo str, const CompositeTypeStmt *node)
{
	WRITE_NODE_TYPE("COMPOSITETYPESTMT");

	WRITE_NODE_FIELD(typevar);
	WRITE_NODE_FIELD(coldeflist);
}

static void
_outCreateEnumStmt(StringInfo str, const CreateEnumStmt *node)
{
	WRITE_NODE_TYPE("CREATEENUMSTMT");

	WRITE_NODE_FIELD(typeName);
	WRITE_NODE_FIELD(vals);
}

static void
_outCreateRangeStmt(StringInfo str, const CreateRangeStmt *node)
{
	WRITE_NODE_TYPE("CREATERANGESTMT");

	WRITE_NODE_FIELD(typeName);
	WRITE_NODE_FIELD(params);
}

static void
_outAlterEnumStmt(StringInfo str, const AlterEnumStmt *node)
{
	WRITE_NODE_TYPE("ALTERENUMSTMT");

	WRITE_NODE_FIELD(typeName);
	WRITE_STRING_FIELD(oldVal);
	WRITE_STRING_FIELD(newVal);
	WRITE_STRING_FIELD(newValNeighbor);
	WRITE_BOOL_FIELD(newValIsAfter);
	WRITE_BOOL_FIELD(skipIfNewValExists);
}

static void
_outViewStmt(StringInfo str, const ViewStmt *node)
{
	WRITE_NODE_TYPE("VIEWSTMT");

	WRITE_NODE_FIELD(view);
	WRITE_NODE_FIELD(aliases);
	WRITE_NODE_FIELD(query);
	WRITE_BOOL_FIELD(replace);
	WRITE_NODE_FIELD(options);
	WRITE_ENUM_FIELD(withCheckOption, ViewCheckOption);
}

static void
_outLoadStmt(StringInfo str, const LoadStmt *node)
{
	WRITE_NODE_TYPE("LOADSTMT");

	WRITE_STRING_FIELD(filename);
}

static void
_outCreatedbStmt(StringInfo str, const CreatedbStmt *node)
{
	WRITE_NODE_TYPE("CREATEDBSTMT");

	WRITE_STRING_FIELD(dbname);
	WRITE_NODE_FIELD(options);
}

static void
_outAlterDatabaseStmt(StringInfo str, const AlterDatabaseStmt *node)
{
	WRITE_NODE_TYPE("ALTERDATABASESTMT");

	WRITE_STRING_FIELD(dbname);
	WRITE_NODE_FIELD(options);
}

static void
_outAlterDatabaseRefreshCollStmt(StringInfo str, const AlterDatabaseRefreshCollStmt *node)
{
	WRITE_NODE_TYPE("ALTERDATABASEREFRESHCOLLSTMT");

	WRITE_STRING_FIELD(dbname);
}

static void
_outAlterDatabaseSetStmt(StringInfo str, const AlterDatabaseSetStmt *node)
{
	WRITE_NODE_TYPE("ALTERDATABASESETSTMT");

	WRITE_STRING_FIELD(dbname);
	WRITE_NODE_FIELD(setstmt);
}

static void
_outDropdbStmt(StringInfo str, const DropdbStmt *node)
{
	WRITE_NODE_TYPE("DROPDBSTMT");

	WRITE_STRING_FIELD(dbname);
	WRITE_BOOL_FIELD(missing_ok);
	WRITE_NODE_FIELD(options);
}

static void
_outAlterSystemStmt(StringInfo str, const AlterSystemStmt *node)
{
	WRITE_NODE_TYPE("ALTERSYSTEMSTMT");

	WRITE_NODE_FIELD(setstmt);
}

static void
_outClusterStmt(StringInfo str, const ClusterStmt *node)
{
	WRITE_NODE_TYPE("CLUSTERSTMT");

	WRITE_NODE_FIELD(relation);
	WRITE_STRING_FIELD(indexname);
	WRITE_NODE_FIELD(params);
}

static void
_outVacuumStmt(StringInfo str, const VacuumStmt *node)
{
	WRITE_NODE_TYPE("VACUUMSTMT");

	WRITE_NODE_FIELD(options);
	WRITE_NODE_FIELD(rels);
	WRITE_BOOL_FIELD(is_vacuumcmd);
}

static void
_outVacuumRelation(StringInfo str, const VacuumRelation *node)
{
	WRITE_NODE_TYPE("VACUUMRELATION");

	WRITE_NODE_FIELD(relation);
	WRITE_OID_FIELD(oid);
	WRITE_NODE_FIELD(va_cols);
}

static void
_outExplainStmt(StringInfo str, const ExplainStmt *node)
{
	WRITE_NODE_TYPE("EXPLAINSTMT");

	WRITE_NODE_FIELD(query);
	WRITE_NODE_FIELD(options);
}

static void
_outCreateTableAsStmt(StringInfo str, const CreateTableAsStmt *node)
{
	WRITE_NODE_TYPE("CREATETABLEASSTMT");

	WRITE_NODE_FIELD(query);
	WRITE_NODE_FIELD(into);
	WRITE_ENUM_FIELD(objtype, ObjectType);
	WRITE_BOOL_FIELD(is_select_into);
	WRITE_BOOL_FIELD(if_not_exists);
}

static void
_outRefreshMatViewStmt(StringInfo str, const RefreshMatViewStmt *node)
{
	WRITE_NODE_TYPE("REFRESHMATVIEWSTMT");

	WRITE_BOOL_FIELD(concurrent);
	WRITE_BOOL_FIELD(skipData);
	WRITE_NODE_FIELD(relation);
}

static void
_outCheckPointStmt(StringInfo str, const CheckPointStmt *node)
{
	WRITE_NODE_TYPE("CHECKPOINTSTMT");

}

static void
_outDiscardStmt(StringInfo str, const DiscardStmt *node)
{
	WRITE_NODE_TYPE("DISCARDSTMT");

	WRITE_ENUM_FIELD(target, DiscardMode);
}

static void
_outLockStmt(StringInfo str, const LockStmt *node)
{
	WRITE_NODE_TYPE("LOCKSTMT");

	WRITE_NODE_FIELD(relations);
	WRITE_INT_FIELD(mode);
	WRITE_BOOL_FIELD(nowait);
}

static void
_outConstraintsSetStmt(StringInfo str, const ConstraintsSetStmt *node)
{
	WRITE_NODE_TYPE("CONSTRAINTSSETSTMT");

	WRITE_NODE_FIELD(constraints);
	WRITE_BOOL_FIELD(deferred);
}

static void
_outReindexStmt(StringInfo str, const ReindexStmt *node)
{
	WRITE_NODE_TYPE("REINDEXSTMT");

	WRITE_ENUM_FIELD(kind, ReindexObjectType);
	WRITE_NODE_FIELD(relation);
	WRITE_STRING_FIELD(name);
	WRITE_NODE_FIELD(params);
}

static void
_outCreateConversionStmt(StringInfo str, const CreateConversionStmt *node)
{
	WRITE_NODE_TYPE("CREATECONVERSIONSTMT");

	WRITE_NODE_FIELD(conversion_name);
	WRITE_STRING_FIELD(for_encoding_name);
	WRITE_STRING_FIELD(to_encoding_name);
	WRITE_NODE_FIELD(func_name);
	WRITE_BOOL_FIELD(def);
}

static void
_outCreateCastStmt(StringInfo str, const CreateCastStmt *node)
{
	WRITE_NODE_TYPE("CREATECASTSTMT");

	WRITE_NODE_FIELD(sourcetype);
	WRITE_NODE_FIELD(targettype);
	WRITE_NODE_FIELD(func);
	WRITE_ENUM_FIELD(context, CoercionContext);
	WRITE_BOOL_FIELD(inout);
}

static void
_outCreateTransformStmt(StringInfo str, const CreateTransformStmt *node)
{
	WRITE_NODE_TYPE("CREATETRANSFORMSTMT");

	WRITE_BOOL_FIELD(replace);
	WRITE_NODE_FIELD(type_name);
	WRITE_STRING_FIELD(lang);
	WRITE_NODE_FIELD(fromsql);
	WRITE_NODE_FIELD(tosql);
}

static void
_outPrepareStmt(StringInfo str, const PrepareStmt *node)
{
	WRITE_NODE_TYPE("PREPARESTMT");

	WRITE_STRING_FIELD(name);
	WRITE_NODE_FIELD(argtypes);
	WRITE_NODE_FIELD(query);
}

static void
_outExecuteStmt(StringInfo str, const ExecuteStmt *node)
{
	WRITE_NODE_TYPE("EXECUTESTMT");

	WRITE_STRING_FIELD(name);
	WRITE_NODE_FIELD(params);
}

static void
_outDeallocateStmt(StringInfo str, const DeallocateStmt *node)
{
	WRITE_NODE_TYPE("DEALLOCATESTMT");

	WRITE_STRING_FIELD(name);
}

static void
_outDropOwnedStmt(StringInfo str, const DropOwnedStmt *node)
{
	WRITE_NODE_TYPE("DROPOWNEDSTMT");

	WRITE_NODE_FIELD(roles);
	WRITE_ENUM_FIELD(behavior, DropBehavior);
}

static void
_outReassignOwnedStmt(StringInfo str, const ReassignOwnedStmt *node)
{
	WRITE_NODE_TYPE("REASSIGNOWNEDSTMT");

	WRITE_NODE_FIELD(roles);
	WRITE_NODE_FIELD(newrole);
}

static void
_outAlterTSDictionaryStmt(StringInfo str, const AlterTSDictionaryStmt *node)
{
	WRITE_NODE_TYPE("ALTERTSDICTIONARYSTMT");

	WRITE_NODE_FIELD(dictname);
	WRITE_NODE_FIELD(options);
}

static void
_outAlterTSConfigurationStmt(StringInfo str, const AlterTSConfigurationStmt *node)
{
	WRITE_NODE_TYPE("ALTERTSCONFIGURATIONSTMT");

	WRITE_ENUM_FIELD(kind, AlterTSConfigType);
	WRITE_NODE_FIELD(cfgname);
	WRITE_NODE_FIELD(tokentype);
	WRITE_NODE_FIELD(dicts);
	WRITE_BOOL_FIELD(override);
	WRITE_BOOL_FIELD(replace);
	WRITE_BOOL_FIELD(missing_ok);
}

static void
_outPublicationTable(StringInfo str, const PublicationTable *node)
{
	WRITE_NODE_TYPE("PUBLICATIONTABLE");

	WRITE_NODE_FIELD(relation);
	WRITE_NODE_FIELD(whereClause);
	WRITE_NODE_FIELD(columns);
}

static void
_outPublicationObjSpec(StringInfo str, const PublicationObjSpec *node)
{
	WRITE_NODE_TYPE("PUBLICATIONOBJSPEC");

	WRITE_ENUM_FIELD(pubobjtype, PublicationObjSpecType);
	WRITE_STRING_FIELD(name);
	WRITE_NODE_FIELD(pubtable);
	WRITE_LOCATION_FIELD(location);
}

static void
_outCreatePublicationStmt(StringInfo str, const CreatePublicationStmt *node)
{
	WRITE_NODE_TYPE("CREATEPUBLICATIONSTMT");

	WRITE_STRING_FIELD(pubname);
	WRITE_NODE_FIELD(options);
	WRITE_NODE_FIELD(pubobjects);
	WRITE_BOOL_FIELD(for_all_tables);
}

static void
_outAlterPublicationStmt(StringInfo str, const AlterPublicationStmt *node)
{
	WRITE_NODE_TYPE("ALTERPUBLICATIONSTMT");

	WRITE_STRING_FIELD(pubname);
	WRITE_NODE_FIELD(options);
	WRITE_NODE_FIELD(pubobjects);
	WRITE_BOOL_FIELD(for_all_tables);
	WRITE_ENUM_FIELD(action, AlterPublicationAction);
}

static void
_outCreateSubscriptionStmt(StringInfo str, const CreateSubscriptionStmt *node)
{
	WRITE_NODE_TYPE("CREATESUBSCRIPTIONSTMT");

	WRITE_STRING_FIELD(subname);
	WRITE_STRING_FIELD(conninfo);
	WRITE_NODE_FIELD(publication);
	WRITE_NODE_FIELD(options);
}

static void
_outAlterSubscriptionStmt(StringInfo str, const AlterSubscriptionStmt *node)
{
	WRITE_NODE_TYPE("ALTERSUBSCRIPTIONSTMT");

	WRITE_ENUM_FIELD(kind, AlterSubscriptionType);
	WRITE_STRING_FIELD(subname);
	WRITE_STRING_FIELD(conninfo);
	WRITE_NODE_FIELD(publication);
	WRITE_NODE_FIELD(options);
}

static void
_outDropSubscriptionStmt(StringInfo str, const DropSubscriptionStmt *node)
{
	WRITE_NODE_TYPE("DROPSUBSCRIPTIONSTMT");

	WRITE_STRING_FIELD(subname);
	WRITE_BOOL_FIELD(missing_ok);
	WRITE_ENUM_FIELD(behavior, DropBehavior);
}

static void
_outPlannerGlobal(StringInfo str, const PlannerGlobal *node)
{
	WRITE_NODE_TYPE("PLANNERGLOBAL");

	WRITE_NODE_FIELD(subplans);
	WRITE_BITMAPSET_FIELD(rewindPlanIDs);
	WRITE_NODE_FIELD(finalrtable);
	WRITE_NODE_FIELD(finalrteperminfos);
	WRITE_NODE_FIELD(finalrowmarks);
	WRITE_NODE_FIELD(resultRelations);
	WRITE_NODE_FIELD(appendRelations);
	WRITE_NODE_FIELD(relationOids);
	WRITE_NODE_FIELD(invalItems);
	WRITE_NODE_FIELD(paramExecTypes);
	WRITE_UINT_FIELD(lastPHId);
	WRITE_UINT_FIELD(lastRowMarkId);
	WRITE_INT_FIELD(lastPlanNodeId);
	WRITE_BOOL_FIELD(transientPlan);
	WRITE_BOOL_FIELD(dependsOnRole);
	WRITE_BOOL_FIELD(parallelModeOK);
	WRITE_BOOL_FIELD(parallelModeNeeded);
	WRITE_CHAR_FIELD(maxParallelHazard);
}

static void
_outPlannerInfo(StringInfo str, const PlannerInfo *node)
{
	WRITE_NODE_TYPE("PLANNERINFO");

	WRITE_NODE_FIELD(parse);
	WRITE_NODE_FIELD(glob);
	WRITE_UINT_FIELD(query_level);
	WRITE_NODE_FIELD(plan_params);
	WRITE_BITMAPSET_FIELD(outer_params);
	WRITE_NODE_ARRAY(simple_rel_array, node->simple_rel_array_size);
	WRITE_INT_FIELD(simple_rel_array_size);
	WRITE_BITMAPSET_FIELD(all_baserels);
	WRITE_BITMAPSET_FIELD(outer_join_rels);
	WRITE_BITMAPSET_FIELD(all_query_rels);
	WRITE_NODE_FIELD(join_rel_list);
	WRITE_INT_FIELD(join_cur_level);
	WRITE_NODE_FIELD(init_plans);
	WRITE_NODE_FIELD(cte_plan_ids);
	WRITE_NODE_FIELD(multiexpr_params);
	WRITE_NODE_FIELD(join_domains);
	WRITE_NODE_FIELD(eq_classes);
	WRITE_BOOL_FIELD(ec_merging_done);
	WRITE_NODE_FIELD(canon_pathkeys);
	WRITE_NODE_FIELD(left_join_clauses);
	WRITE_NODE_FIELD(right_join_clauses);
	WRITE_NODE_FIELD(full_join_clauses);
	WRITE_NODE_FIELD(join_info_list);
	WRITE_INT_FIELD(last_rinfo_serial);
	WRITE_BITMAPSET_FIELD(all_result_relids);
	WRITE_BITMAPSET_FIELD(leaf_result_relids);
	WRITE_NODE_FIELD(append_rel_list);
	WRITE_NODE_FIELD(row_identity_vars);
	WRITE_NODE_FIELD(rowMarks);
	WRITE_NODE_FIELD(placeholder_list);
	WRITE_NODE_FIELD(fkey_list);
	WRITE_NODE_FIELD(query_pathkeys);
	WRITE_NODE_FIELD(group_pathkeys);
	WRITE_INT_FIELD(num_groupby_pathkeys);
	WRITE_NODE_FIELD(window_pathkeys);
	WRITE_NODE_FIELD(distinct_pathkeys);
	WRITE_NODE_FIELD(sort_pathkeys);
	WRITE_NODE_FIELD(processed_groupClause);
	WRITE_NODE_FIELD(processed_distinctClause);
	WRITE_NODE_FIELD(processed_tlist);
	WRITE_NODE_FIELD(update_colnos);
	WRITE_NODE_FIELD(minmax_aggs);
	WRITE_FLOAT_FIELD(total_table_pages);
	WRITE_FLOAT_FIELD(tuple_fraction);
	WRITE_FLOAT_FIELD(limit_tuples);
	WRITE_UINT_FIELD(qual_security_level);
	WRITE_BOOL_FIELD(hasJoinRTEs);
	WRITE_BOOL_FIELD(hasLateralRTEs);
	WRITE_BOOL_FIELD(hasHavingQual);
	WRITE_BOOL_FIELD(hasPseudoConstantQuals);
	WRITE_BOOL_FIELD(hasAlternativeSubPlans);
	WRITE_BOOL_FIELD(placeholdersFrozen);
	WRITE_BOOL_FIELD(hasRecursion);
	WRITE_NODE_FIELD(agginfos);
	WRITE_NODE_FIELD(aggtransinfos);
	WRITE_INT_FIELD(numOrderedAggs);
	WRITE_BOOL_FIELD(hasNonPartialAggs);
	WRITE_BOOL_FIELD(hasNonSerialAggs);
	WRITE_INT_FIELD(wt_param_id);
	WRITE_NODE_FIELD(non_recursive_path);
	WRITE_BITMAPSET_FIELD(curOuterRels);
	WRITE_NODE_FIELD(curOuterParams);
	WRITE_BOOL_FIELD(partColsUpdated);
}

static void
_outRelOptInfo(StringInfo str, const RelOptInfo *node)
{
	WRITE_NODE_TYPE("RELOPTINFO");

	WRITE_ENUM_FIELD(reloptkind, RelOptKind);
	WRITE_BITMAPSET_FIELD(relids);
	WRITE_FLOAT_FIELD(rows);
	WRITE_BOOL_FIELD(consider_startup);
	WRITE_BOOL_FIELD(consider_param_startup);
	WRITE_BOOL_FIELD(consider_parallel);
	WRITE_NODE_FIELD(reltarget);
	WRITE_NODE_FIELD(pathlist);
	WRITE_NODE_FIELD(ppilist);
	WRITE_NODE_FIELD(partial_pathlist);
	WRITE_NODE_FIELD(cheapest_startup_path);
	WRITE_NODE_FIELD(cheapest_total_path);
	WRITE_NODE_FIELD(cheapest_unique_path);
	WRITE_NODE_FIELD(cheapest_parameterized_paths);
	WRITE_BITMAPSET_FIELD(direct_lateral_relids);
	WRITE_BITMAPSET_FIELD(lateral_relids);
	WRITE_UINT_FIELD(relid);
	WRITE_OID_FIELD(reltablespace);
	WRITE_ENUM_FIELD(rtekind, RTEKind);
	WRITE_INT_FIELD(min_attr);
	WRITE_INT_FIELD(max_attr);
	WRITE_BITMAPSET_FIELD(nulling_relids);
	WRITE_NODE_FIELD(lateral_vars);
	WRITE_BITMAPSET_FIELD(lateral_referencers);
	WRITE_NODE_FIELD(indexlist);
	WRITE_NODE_FIELD(statlist);
	WRITE_UINT_FIELD(pages);
	WRITE_FLOAT_FIELD(tuples);
	WRITE_FLOAT_FIELD(allvisfrac);
	WRITE_BITMAPSET_FIELD(eclass_indexes);
	WRITE_NODE_FIELD(subroot);
	WRITE_NODE_FIELD(subplan_params);
	WRITE_INT_FIELD(rel_parallel_workers);
	WRITE_UINT_FIELD(amflags);
	WRITE_OID_FIELD(serverid);
	WRITE_OID_FIELD(userid);
	WRITE_BOOL_FIELD(useridiscurrent);
	WRITE_NODE_FIELD(unique_for_rels);
	WRITE_NODE_FIELD(non_unique_for_rels);
	WRITE_NODE_FIELD(baserestrictinfo);
	WRITE_FLOAT_FIELD(baserestrictcost.startup);
	WRITE_FLOAT_FIELD(baserestrictcost.per_tuple);
	WRITE_UINT_FIELD(baserestrict_min_security);
	WRITE_NODE_FIELD(joininfo);
	WRITE_BOOL_FIELD(has_eclass_joins);
	WRITE_BOOL_FIELD(consider_partitionwise_join);
	WRITE_BITMAPSET_FIELD(top_parent_relids);
	WRITE_INT_FIELD(nparts);
	WRITE_BOOL_FIELD(partbounds_merged);
	WRITE_NODE_FIELD(partition_qual);
	WRITE_BITMAPSET_FIELD(live_parts);
	WRITE_BITMAPSET_FIELD(all_partrels);
}

static void
_outIndexOptInfo(StringInfo str, const IndexOptInfo *node)
{
	WRITE_NODE_TYPE("INDEXOPTINFO");

	WRITE_OID_FIELD(indexoid);
	WRITE_OID_FIELD(reltablespace);
	WRITE_UINT_FIELD(pages);
	WRITE_FLOAT_FIELD(tuples);
	WRITE_INT_FIELD(tree_height);
	WRITE_INT_FIELD(ncolumns);
	WRITE_INT_FIELD(nkeycolumns);
	WRITE_INT_ARRAY(indexkeys, node->ncolumns);
	WRITE_OID_ARRAY(indexcollations, node->nkeycolumns);
	WRITE_OID_ARRAY(opfamily, node->nkeycolumns);
	WRITE_OID_ARRAY(opcintype, node->nkeycolumns);
	WRITE_OID_ARRAY(sortopfamily, node->nkeycolumns);
	WRITE_BOOL_ARRAY(reverse_sort, node->nkeycolumns);
	WRITE_BOOL_ARRAY(nulls_first, node->nkeycolumns);
	WRITE_BOOL_ARRAY(canreturn, node->ncolumns);
	WRITE_OID_FIELD(relam);
	WRITE_NODE_FIELD(indpred);
	WRITE_NODE_FIELD(indextlist);
	WRITE_NODE_FIELD(indrestrictinfo);
	WRITE_BOOL_FIELD(predOK);
	WRITE_BOOL_FIELD(unique);
	WRITE_BOOL_FIELD(immediate);
	WRITE_BOOL_FIELD(hypothetical);
	WRITE_BOOL_FIELD(amcanorderbyop);
	WRITE_BOOL_FIELD(amoptionalkey);
	WRITE_BOOL_FIELD(amsearcharray);
	WRITE_BOOL_FIELD(amsearchnulls);
	WRITE_BOOL_FIELD(amhasgettuple);
	WRITE_BOOL_FIELD(amhasgetbitmap);
	WRITE_BOOL_FIELD(amcanparallel);
	WRITE_BOOL_FIELD(amcanmarkpos);
}

static void
_outStatisticExtInfo(StringInfo str, const StatisticExtInfo *node)
{
	WRITE_NODE_TYPE("STATISTICEXTINFO");

	WRITE_OID_FIELD(statOid);
	WRITE_BOOL_FIELD(inherit);
	WRITE_CHAR_FIELD(kind);
	WRITE_BITMAPSET_FIELD(keys);
	WRITE_NODE_FIELD(exprs);
}

static void
_outJoinDomain(StringInfo str, const JoinDomain *node)
{
	WRITE_NODE_TYPE("JOINDOMAIN");

	WRITE_BITMAPSET_FIELD(jd_relids);
}

static void
_outEquivalenceMember(StringInfo str, const EquivalenceMember *node)
{
	WRITE_NODE_TYPE("EQUIVALENCEMEMBER");

	WRITE_NODE_FIELD(em_expr);
	WRITE_BITMAPSET_FIELD(em_relids);
	WRITE_BOOL_FIELD(em_is_const);
	WRITE_BOOL_FIELD(em_is_child);
	WRITE_OID_FIELD(em_datatype);
	WRITE_NODE_FIELD(em_jdomain);
}

static void
_outPathKey(StringInfo str, const PathKey *node)
{
	WRITE_NODE_TYPE("PATHKEY");

	WRITE_NODE_FIELD(pk_eclass);
	WRITE_OID_FIELD(pk_opfamily);
	WRITE_INT_FIELD(pk_strategy);
	WRITE_BOOL_FIELD(pk_nulls_first);
}

static void
_outPathTarget(StringInfo str, const PathTarget *node)
{
	WRITE_NODE_TYPE("PATHTARGET");

	WRITE_NODE_FIELD(exprs);
	WRITE_INDEX_ARRAY(sortgrouprefs, list_length(node->exprs));
	WRITE_FLOAT_FIELD(cost.startup);
	WRITE_FLOAT_FIELD(cost.per_tuple);
	WRITE_INT_FIELD(width);
	WRITE_ENUM_FIELD(has_volatile_expr, VolatileFunctionStatus);
}

static void
_outParamPathInfo(StringInfo str, const ParamPathInfo *node)
{
	WRITE_NODE_TYPE("PARAMPATHINFO");

	WRITE_BITMAPSET_FIELD(ppi_req_outer);
	WRITE_FLOAT_FIELD(ppi_rows);
	WRITE_NODE_FIELD(ppi_clauses);
	WRITE_BITMAPSET_FIELD(ppi_serials);
}

static void
_outPath(StringInfo str, const Path *node)
{
	WRITE_NODE_TYPE("PATH");

	WRITE_ENUM_FIELD(pathtype, NodeTag);
	appendStringInfoString(str, " :parent_relids ");
	outBitmapset(str, node->parent->relids);
	if (node->pathtarget != node->parent->reltarget)
		WRITE_NODE_FIELD(pathtarget);
	appendStringInfoString(str, " :required_outer ");
	if (node->param_info)
		outBitmapset(str, node->param_info->ppi_req_outer);
	else
		outBitmapset(str, NULL);
	WRITE_BOOL_FIELD(parallel_aware);
	WRITE_BOOL_FIELD(parallel_safe);
	WRITE_INT_FIELD(parallel_workers);
	WRITE_FLOAT_FIELD(rows);
	WRITE_FLOAT_FIELD(startup_cost);
	WRITE_FLOAT_FIELD(total_cost);
	WRITE_NODE_FIELD(pathkeys);
}

static void
_outIndexPath(StringInfo str, const IndexPath *node)
{
	WRITE_NODE_TYPE("INDEXPATH");

	WRITE_ENUM_FIELD(path.pathtype, NodeTag);
	appendStringInfoString(str, " :parent_relids ");
	outBitmapset(str, node->path.parent->relids);
	if (node->path.pathtarget != node->path.parent->reltarget)
		WRITE_NODE_FIELD(path.pathtarget);
	appendStringInfoString(str, " :required_outer ");
	if (node->path.param_info)
		outBitmapset(str, node->path.param_info->ppi_req_outer);
	else
		outBitmapset(str, NULL);
	WRITE_BOOL_FIELD(path.parallel_aware);
	WRITE_BOOL_FIELD(path.parallel_safe);
	WRITE_INT_FIELD(path.parallel_workers);
	WRITE_FLOAT_FIELD(path.rows);
	WRITE_FLOAT_FIELD(path.startup_cost);
	WRITE_FLOAT_FIELD(path.total_cost);
	WRITE_NODE_FIELD(path.pathkeys);
	WRITE_NODE_FIELD(indexinfo);
	WRITE_NODE_FIELD(indexclauses);
	WRITE_NODE_FIELD(indexorderbys);
	WRITE_NODE_FIELD(indexorderbycols);
	WRITE_ENUM_FIELD(indexscandir, ScanDirection);
	WRITE_FLOAT_FIELD(indextotalcost);
	WRITE_FLOAT_FIELD(indexselectivity);
}

static void
_outIndexClause(StringInfo str, const IndexClause *node)
{
	WRITE_NODE_TYPE("INDEXCLAUSE");

	WRITE_NODE_FIELD(rinfo);
	WRITE_NODE_FIELD(indexquals);
	WRITE_BOOL_FIELD(lossy);
	WRITE_INT_FIELD(indexcol);
	WRITE_NODE_FIELD(indexcols);
}

static void
_outBitmapHeapPath(StringInfo str, const BitmapHeapPath *node)
{
	WRITE_NODE_TYPE("BITMAPHEAPPATH");

	WRITE_ENUM_FIELD(path.pathtype, NodeTag);
	appendStringInfoString(str, " :parent_relids ");
	outBitmapset(str, node->path.parent->relids);
	if (node->path.pathtarget != node->path.parent->reltarget)
		WRITE_NODE_FIELD(path.pathtarget);
	appendStringInfoString(str, " :required_outer ");
	if (node->path.param_info)
		outBitmapset(str, node->path.param_info->ppi_req_outer);
	else
		outBitmapset(str, NULL);
	WRITE_BOOL_FIELD(path.parallel_aware);
	WRITE_BOOL_FIELD(path.parallel_safe);
	WRITE_INT_FIELD(path.parallel_workers);
	WRITE_FLOAT_FIELD(path.rows);
	WRITE_FLOAT_FIELD(path.startup_cost);
	WRITE_FLOAT_FIELD(path.total_cost);
	WRITE_NODE_FIELD(path.pathkeys);
	WRITE_NODE_FIELD(bitmapqual);
}

static void
_outBitmapAndPath(StringInfo str, const BitmapAndPath *node)
{
	WRITE_NODE_TYPE("BITMAPANDPATH");

	WRITE_ENUM_FIELD(path.pathtype, NodeTag);
	appendStringInfoString(str, " :parent_relids ");
	outBitmapset(str, node->path.parent->relids);
	if (node->path.pathtarget != node->path.parent->reltarget)
		WRITE_NODE_FIELD(path.pathtarget);
	appendStringInfoString(str, " :required_outer ");
	if (node->path.param_info)
		outBitmapset(str, node->path.param_info->ppi_req_outer);
	else
		outBitmapset(str, NULL);
	WRITE_BOOL_FIELD(path.parallel_aware);
	WRITE_BOOL_FIELD(path.parallel_safe);
	WRITE_INT_FIELD(path.parallel_workers);
	WRITE_FLOAT_FIELD(path.rows);
	WRITE_FLOAT_FIELD(path.startup_cost);
	WRITE_FLOAT_FIELD(path.total_cost);
	WRITE_NODE_FIELD(path.pathkeys);
	WRITE_NODE_FIELD(bitmapquals);
	WRITE_FLOAT_FIELD(bitmapselectivity);
}

static void
_outBitmapOrPath(StringInfo str, const BitmapOrPath *node)
{
	WRITE_NODE_TYPE("BITMAPORPATH");

	WRITE_ENUM_FIELD(path.pathtype, NodeTag);
	appendStringInfoString(str, " :parent_relids ");
	outBitmapset(str, node->path.parent->relids);
	if (node->path.pathtarget != node->path.parent->reltarget)
		WRITE_NODE_FIELD(path.pathtarget);
	appendStringInfoString(str, " :required_outer ");
	if (node->path.param_info)
		outBitmapset(str, node->path.param_info->ppi_req_outer);
	else
		outBitmapset(str, NULL);
	WRITE_BOOL_FIELD(path.parallel_aware);
	WRITE_BOOL_FIELD(path.parallel_safe);
	WRITE_INT_FIELD(path.parallel_workers);
	WRITE_FLOAT_FIELD(path.rows);
	WRITE_FLOAT_FIELD(path.startup_cost);
	WRITE_FLOAT_FIELD(path.total_cost);
	WRITE_NODE_FIELD(path.pathkeys);
	WRITE_NODE_FIELD(bitmapquals);
	WRITE_FLOAT_FIELD(bitmapselectivity);
}

static void
_outTidPath(StringInfo str, const TidPath *node)
{
	WRITE_NODE_TYPE("TIDPATH");

	WRITE_ENUM_FIELD(path.pathtype, NodeTag);
	appendStringInfoString(str, " :parent_relids ");
	outBitmapset(str, node->path.parent->relids);
	if (node->path.pathtarget != node->path.parent->reltarget)
		WRITE_NODE_FIELD(path.pathtarget);
	appendStringInfoString(str, " :required_outer ");
	if (node->path.param_info)
		outBitmapset(str, node->path.param_info->ppi_req_outer);
	else
		outBitmapset(str, NULL);
	WRITE_BOOL_FIELD(path.parallel_aware);
	WRITE_BOOL_FIELD(path.parallel_safe);
	WRITE_INT_FIELD(path.parallel_workers);
	WRITE_FLOAT_FIELD(path.rows);
	WRITE_FLOAT_FIELD(path.startup_cost);
	WRITE_FLOAT_FIELD(path.total_cost);
	WRITE_NODE_FIELD(path.pathkeys);
	WRITE_NODE_FIELD(tidquals);
}

static void
_outTidRangePath(StringInfo str, const TidRangePath *node)
{
	WRITE_NODE_TYPE("TIDRANGEPATH");

	WRITE_ENUM_FIELD(path.pathtype, NodeTag);
	appendStringInfoString(str, " :parent_relids ");
	outBitmapset(str, node->path.parent->relids);
	if (node->path.pathtarget != node->path.parent->reltarget)
		WRITE_NODE_FIELD(path.pathtarget);
	appendStringInfoString(str, " :required_outer ");
	if (node->path.param_info)
		outBitmapset(str, node->path.param_info->ppi_req_outer);
	else
		outBitmapset(str, NULL);
	WRITE_BOOL_FIELD(path.parallel_aware);
	WRITE_BOOL_FIELD(path.parallel_safe);
	WRITE_INT_FIELD(path.parallel_workers);
	WRITE_FLOAT_FIELD(path.rows);
	WRITE_FLOAT_FIELD(path.startup_cost);
	WRITE_FLOAT_FIELD(path.total_cost);
	WRITE_NODE_FIELD(path.pathkeys);
	WRITE_NODE_FIELD(tidrangequals);
}

static void
_outSubqueryScanPath(StringInfo str, const SubqueryScanPath *node)
{
	WRITE_NODE_TYPE("SUBQUERYSCANPATH");

	WRITE_ENUM_FIELD(path.pathtype, NodeTag);
	appendStringInfoString(str, " :parent_relids ");
	outBitmapset(str, node->path.parent->relids);
	if (node->path.pathtarget != node->path.parent->reltarget)
		WRITE_NODE_FIELD(path.pathtarget);
	appendStringInfoString(str, " :required_outer ");
	if (node->path.param_info)
		outBitmapset(str, node->path.param_info->ppi_req_outer);
	else
		outBitmapset(str, NULL);
	WRITE_BOOL_FIELD(path.parallel_aware);
	WRITE_BOOL_FIELD(path.parallel_safe);
	WRITE_INT_FIELD(path.parallel_workers);
	WRITE_FLOAT_FIELD(path.rows);
	WRITE_FLOAT_FIELD(path.startup_cost);
	WRITE_FLOAT_FIELD(path.total_cost);
	WRITE_NODE_FIELD(path.pathkeys);
	WRITE_NODE_FIELD(subpath);
}

static void
_outForeignPath(StringInfo str, const ForeignPath *node)
{
	WRITE_NODE_TYPE("FOREIGNPATH");

	WRITE_ENUM_FIELD(path.pathtype, NodeTag);
	appendStringInfoString(str, " :parent_relids ");
	outBitmapset(str, node->path.parent->relids);
	if (node->path.pathtarget != node->path.parent->reltarget)
		WRITE_NODE_FIELD(path.pathtarget);
	appendStringInfoString(str, " :required_outer ");
	if (node->path.param_info)
		outBitmapset(str, node->path.param_info->ppi_req_outer);
	else
		outBitmapset(str, NULL);
	WRITE_BOOL_FIELD(path.parallel_aware);
	WRITE_BOOL_FIELD(path.parallel_safe);
	WRITE_INT_FIELD(path.parallel_workers);
	WRITE_FLOAT_FIELD(path.rows);
	WRITE_FLOAT_FIELD(path.startup_cost);
	WRITE_FLOAT_FIELD(path.total_cost);
	WRITE_NODE_FIELD(path.pathkeys);
	WRITE_NODE_FIELD(fdw_outerpath);
	WRITE_NODE_FIELD(fdw_private);
}

static void
_outCustomPath(StringInfo str, const CustomPath *node)
{
	WRITE_NODE_TYPE("CUSTOMPATH");

	WRITE_ENUM_FIELD(path.pathtype, NodeTag);
	appendStringInfoString(str, " :parent_relids ");
	outBitmapset(str, node->path.parent->relids);
	if (node->path.pathtarget != node->path.parent->reltarget)
		WRITE_NODE_FIELD(path.pathtarget);
	appendStringInfoString(str, " :required_outer ");
	if (node->path.param_info)
		outBitmapset(str, node->path.param_info->ppi_req_outer);
	else
		outBitmapset(str, NULL);
	WRITE_BOOL_FIELD(path.parallel_aware);
	WRITE_BOOL_FIELD(path.parallel_safe);
	WRITE_INT_FIELD(path.parallel_workers);
	WRITE_FLOAT_FIELD(path.rows);
	WRITE_FLOAT_FIELD(path.startup_cost);
	WRITE_FLOAT_FIELD(path.total_cost);
	WRITE_NODE_FIELD(path.pathkeys);
	WRITE_UINT_FIELD(flags);
	WRITE_NODE_FIELD(custom_paths);
	WRITE_NODE_FIELD(custom_private);

	/* CustomName is a key to lookup CustomScanMethods */
	appendStringInfoString(str, " :methods ");
	outToken(str, node->methods->CustomName);
}

static void
_outAppendPath(StringInfo str, const AppendPath *node)
{
	WRITE_NODE_TYPE("APPENDPATH");

	WRITE_ENUM_FIELD(path.pathtype, NodeTag);
	appendStringInfoString(str, " :parent_relids ");
	outBitmapset(str, node->path.parent->relids);
	if (node->path.pathtarget != node->path.parent->reltarget)
		WRITE_NODE_FIELD(path.pathtarget);
	appendStringInfoString(str, " :required_outer ");
	if (node->path.param_info)
		outBitmapset(str, node->path.param_info->ppi_req_outer);
	else
		outBitmapset(str, NULL);
	WRITE_BOOL_FIELD(path.parallel_aware);
	WRITE_BOOL_FIELD(path.parallel_safe);
	WRITE_INT_FIELD(path.parallel_workers);
	WRITE_FLOAT_FIELD(path.rows);
	WRITE_FLOAT_FIELD(path.startup_cost);
	WRITE_FLOAT_FIELD(path.total_cost);
	WRITE_NODE_FIELD(path.pathkeys);
	WRITE_NODE_FIELD(subpaths);
	WRITE_INT_FIELD(first_partial_path);
	WRITE_FLOAT_FIELD(limit_tuples);
}

static void
_outMergeAppendPath(StringInfo str, const MergeAppendPath *node)
{
	WRITE_NODE_TYPE("MERGEAPPENDPATH");

	WRITE_ENUM_FIELD(path.pathtype, NodeTag);
	appendStringInfoString(str, " :parent_relids ");
	outBitmapset(str, node->path.parent->relids);
	if (node->path.pathtarget != node->path.parent->reltarget)
		WRITE_NODE_FIELD(path.pathtarget);
	appendStringInfoString(str, " :required_outer ");
	if (node->path.param_info)
		outBitmapset(str, node->path.param_info->ppi_req_outer);
	else
		outBitmapset(str, NULL);
	WRITE_BOOL_FIELD(path.parallel_aware);
	WRITE_BOOL_FIELD(path.parallel_safe);
	WRITE_INT_FIELD(path.parallel_workers);
	WRITE_FLOAT_FIELD(path.rows);
	WRITE_FLOAT_FIELD(path.startup_cost);
	WRITE_FLOAT_FIELD(path.total_cost);
	WRITE_NODE_FIELD(path.pathkeys);
	WRITE_NODE_FIELD(subpaths);
	WRITE_FLOAT_FIELD(limit_tuples);
}

static void
_outGroupResultPath(StringInfo str, const GroupResultPath *node)
{
	WRITE_NODE_TYPE("GROUPRESULTPATH");

	WRITE_ENUM_FIELD(path.pathtype, NodeTag);
	appendStringInfoString(str, " :parent_relids ");
	outBitmapset(str, node->path.parent->relids);
	if (node->path.pathtarget != node->path.parent->reltarget)
		WRITE_NODE_FIELD(path.pathtarget);
	appendStringInfoString(str, " :required_outer ");
	if (node->path.param_info)
		outBitmapset(str, node->path.param_info->ppi_req_outer);
	else
		outBitmapset(str, NULL);
	WRITE_BOOL_FIELD(path.parallel_aware);
	WRITE_BOOL_FIELD(path.parallel_safe);
	WRITE_INT_FIELD(path.parallel_workers);
	WRITE_FLOAT_FIELD(path.rows);
	WRITE_FLOAT_FIELD(path.startup_cost);
	WRITE_FLOAT_FIELD(path.total_cost);
	WRITE_NODE_FIELD(path.pathkeys);
	WRITE_NODE_FIELD(quals);
}

static void
_outMaterialPath(StringInfo str, const MaterialPath *node)
{
	WRITE_NODE_TYPE("MATERIALPATH");

	WRITE_ENUM_FIELD(path.pathtype, NodeTag);
	appendStringInfoString(str, " :parent_relids ");
	outBitmapset(str, node->path.parent->relids);
	if (node->path.pathtarget != node->path.parent->reltarget)
		WRITE_NODE_FIELD(path.pathtarget);
	appendStringInfoString(str, " :required_outer ");
	if (node->path.param_info)
		outBitmapset(str, node->path.param_info->ppi_req_outer);
	else
		outBitmapset(str, NULL);
	WRITE_BOOL_FIELD(path.parallel_aware);
	WRITE_BOOL_FIELD(path.parallel_safe);
	WRITE_INT_FIELD(path.parallel_workers);
	WRITE_FLOAT_FIELD(path.rows);
	WRITE_FLOAT_FIELD(path.startup_cost);
	WRITE_FLOAT_FIELD(path.total_cost);
	WRITE_NODE_FIELD(path.pathkeys);
	WRITE_NODE_FIELD(subpath);
}

static void
_outMemoizePath(StringInfo str, const MemoizePath *node)
{
	WRITE_NODE_TYPE("MEMOIZEPATH");

	WRITE_ENUM_FIELD(path.pathtype, NodeTag);
	appendStringInfoString(str, " :parent_relids ");
	outBitmapset(str, node->path.parent->relids);
	if (node->path.pathtarget != node->path.parent->reltarget)
		WRITE_NODE_FIELD(path.pathtarget);
	appendStringInfoString(str, " :required_outer ");
	if (node->path.param_info)
		outBitmapset(str, node->path.param_info->ppi_req_outer);
	else
		outBitmapset(str, NULL);
	WRITE_BOOL_FIELD(path.parallel_aware);
	WRITE_BOOL_FIELD(path.parallel_safe);
	WRITE_INT_FIELD(path.parallel_workers);
	WRITE_FLOAT_FIELD(path.rows);
	WRITE_FLOAT_FIELD(path.startup_cost);
	WRITE_FLOAT_FIELD(path.total_cost);
	WRITE_NODE_FIELD(path.pathkeys);
	WRITE_NODE_FIELD(subpath);
	WRITE_NODE_FIELD(hash_operators);
	WRITE_NODE_FIELD(param_exprs);
	WRITE_BOOL_FIELD(singlerow);
	WRITE_BOOL_FIELD(binary_mode);
	WRITE_FLOAT_FIELD(calls);
	WRITE_UINT_FIELD(est_entries);
}

static void
_outUniquePath(StringInfo str, const UniquePath *node)
{
	WRITE_NODE_TYPE("UNIQUEPATH");

	WRITE_ENUM_FIELD(path.pathtype, NodeTag);
	appendStringInfoString(str, " :parent_relids ");
	outBitmapset(str, node->path.parent->relids);
	if (node->path.pathtarget != node->path.parent->reltarget)
		WRITE_NODE_FIELD(path.pathtarget);
	appendStringInfoString(str, " :required_outer ");
	if (node->path.param_info)
		outBitmapset(str, node->path.param_info->ppi_req_outer);
	else
		outBitmapset(str, NULL);
	WRITE_BOOL_FIELD(path.parallel_aware);
	WRITE_BOOL_FIELD(path.parallel_safe);
	WRITE_INT_FIELD(path.parallel_workers);
	WRITE_FLOAT_FIELD(path.rows);
	WRITE_FLOAT_FIELD(path.startup_cost);
	WRITE_FLOAT_FIELD(path.total_cost);
	WRITE_NODE_FIELD(path.pathkeys);
	WRITE_NODE_FIELD(subpath);
	WRITE_ENUM_FIELD(umethod, UniquePathMethod);
	WRITE_NODE_FIELD(in_operators);
	WRITE_NODE_FIELD(uniq_exprs);
}

static void
_outGatherPath(StringInfo str, const GatherPath *node)
{
	WRITE_NODE_TYPE("GATHERPATH");

	WRITE_ENUM_FIELD(path.pathtype, NodeTag);
	appendStringInfoString(str, " :parent_relids ");
	outBitmapset(str, node->path.parent->relids);
	if (node->path.pathtarget != node->path.parent->reltarget)
		WRITE_NODE_FIELD(path.pathtarget);
	appendStringInfoString(str, " :required_outer ");
	if (node->path.param_info)
		outBitmapset(str, node->path.param_info->ppi_req_outer);
	else
		outBitmapset(str, NULL);
	WRITE_BOOL_FIELD(path.parallel_aware);
	WRITE_BOOL_FIELD(path.parallel_safe);
	WRITE_INT_FIELD(path.parallel_workers);
	WRITE_FLOAT_FIELD(path.rows);
	WRITE_FLOAT_FIELD(path.startup_cost);
	WRITE_FLOAT_FIELD(path.total_cost);
	WRITE_NODE_FIELD(path.pathkeys);
	WRITE_NODE_FIELD(subpath);
	WRITE_BOOL_FIELD(single_copy);
	WRITE_INT_FIELD(num_workers);
}

static void
_outGatherMergePath(StringInfo str, const GatherMergePath *node)
{
	WRITE_NODE_TYPE("GATHERMERGEPATH");

	WRITE_ENUM_FIELD(path.pathtype, NodeTag);
	appendStringInfoString(str, " :parent_relids ");
	outBitmapset(str, node->path.parent->relids);
	if (node->path.pathtarget != node->path.parent->reltarget)
		WRITE_NODE_FIELD(path.pathtarget);
	appendStringInfoString(str, " :required_outer ");
	if (node->path.param_info)
		outBitmapset(str, node->path.param_info->ppi_req_outer);
	else
		outBitmapset(str, NULL);
	WRITE_BOOL_FIELD(path.parallel_aware);
	WRITE_BOOL_FIELD(path.parallel_safe);
	WRITE_INT_FIELD(path.parallel_workers);
	WRITE_FLOAT_FIELD(path.rows);
	WRITE_FLOAT_FIELD(path.startup_cost);
	WRITE_FLOAT_FIELD(path.total_cost);
	WRITE_NODE_FIELD(path.pathkeys);
	WRITE_NODE_FIELD(subpath);
	WRITE_INT_FIELD(num_workers);
}

static void
_outNestPath(StringInfo str, const NestPath *node)
{
	WRITE_NODE_TYPE("NESTPATH");

	WRITE_ENUM_FIELD(jpath.path.pathtype, NodeTag);
	appendStringInfoString(str, " :parent_relids ");
	outBitmapset(str, node->jpath.path.parent->relids);
	if (node->jpath.path.pathtarget != node->jpath.path.parent->reltarget)
		WRITE_NODE_FIELD(jpath.path.pathtarget);
	appendStringInfoString(str, " :required_outer ");
	if (node->jpath.path.param_info)
		outBitmapset(str, node->jpath.path.param_info->ppi_req_outer);
	else
		outBitmapset(str, NULL);
	WRITE_BOOL_FIELD(jpath.path.parallel_aware);
	WRITE_BOOL_FIELD(jpath.path.parallel_safe);
	WRITE_INT_FIELD(jpath.path.parallel_workers);
	WRITE_FLOAT_FIELD(jpath.path.rows);
	WRITE_FLOAT_FIELD(jpath.path.startup_cost);
	WRITE_FLOAT_FIELD(jpath.path.total_cost);
	WRITE_NODE_FIELD(jpath.path.pathkeys);
	WRITE_ENUM_FIELD(jpath.jointype, JoinType);
	WRITE_BOOL_FIELD(jpath.inner_unique);
	WRITE_NODE_FIELD(jpath.outerjoinpath);
	WRITE_NODE_FIELD(jpath.innerjoinpath);
	WRITE_NODE_FIELD(jpath.joinrestrictinfo);
}

static void
_outMergePath(StringInfo str, const MergePath *node)
{
	WRITE_NODE_TYPE("MERGEPATH");

	WRITE_ENUM_FIELD(jpath.path.pathtype, NodeTag);
	appendStringInfoString(str, " :parent_relids ");
	outBitmapset(str, node->jpath.path.parent->relids);
	if (node->jpath.path.pathtarget != node->jpath.path.parent->reltarget)
		WRITE_NODE_FIELD(jpath.path.pathtarget);
	appendStringInfoString(str, " :required_outer ");
	if (node->jpath.path.param_info)
		outBitmapset(str, node->jpath.path.param_info->ppi_req_outer);
	else
		outBitmapset(str, NULL);
	WRITE_BOOL_FIELD(jpath.path.parallel_aware);
	WRITE_BOOL_FIELD(jpath.path.parallel_safe);
	WRITE_INT_FIELD(jpath.path.parallel_workers);
	WRITE_FLOAT_FIELD(jpath.path.rows);
	WRITE_FLOAT_FIELD(jpath.path.startup_cost);
	WRITE_FLOAT_FIELD(jpath.path.total_cost);
	WRITE_NODE_FIELD(jpath.path.pathkeys);
	WRITE_ENUM_FIELD(jpath.jointype, JoinType);
	WRITE_BOOL_FIELD(jpath.inner_unique);
	WRITE_NODE_FIELD(jpath.outerjoinpath);
	WRITE_NODE_FIELD(jpath.innerjoinpath);
	WRITE_NODE_FIELD(jpath.joinrestrictinfo);
	WRITE_NODE_FIELD(path_mergeclauses);
	WRITE_NODE_FIELD(outersortkeys);
	WRITE_NODE_FIELD(innersortkeys);
	WRITE_BOOL_FIELD(skip_mark_restore);
	WRITE_BOOL_FIELD(materialize_inner);
}

static void
_outHashPath(StringInfo str, const HashPath *node)
{
	WRITE_NODE_TYPE("HASHPATH");

	WRITE_ENUM_FIELD(jpath.path.pathtype, NodeTag);
	appendStringInfoString(str, " :parent_relids ");
	outBitmapset(str, node->jpath.path.parent->relids);
	if (node->jpath.path.pathtarget != node->jpath.path.parent->reltarget)
		WRITE_NODE_FIELD(jpath.path.pathtarget);
	appendStringInfoString(str, " :required_outer ");
	if (node->jpath.path.param_info)
		outBitmapset(str, node->jpath.path.param_info->ppi_req_outer);
	else
		outBitmapset(str, NULL);
	WRITE_BOOL_FIELD(jpath.path.parallel_aware);
	WRITE_BOOL_FIELD(jpath.path.parallel_safe);
	WRITE_INT_FIELD(jpath.path.parallel_workers);
	WRITE_FLOAT_FIELD(jpath.path.rows);
	WRITE_FLOAT_FIELD(jpath.path.startup_cost);
	WRITE_FLOAT_FIELD(jpath.path.total_cost);
	WRITE_NODE_FIELD(jpath.path.pathkeys);
	WRITE_ENUM_FIELD(jpath.jointype, JoinType);
	WRITE_BOOL_FIELD(jpath.inner_unique);
	WRITE_NODE_FIELD(jpath.outerjoinpath);
	WRITE_NODE_FIELD(jpath.innerjoinpath);
	WRITE_NODE_FIELD(jpath.joinrestrictinfo);
	WRITE_NODE_FIELD(path_hashclauses);
	WRITE_INT_FIELD(num_batches);
	WRITE_FLOAT_FIELD(inner_rows_total);
}

static void
_outProjectionPath(StringInfo str, const ProjectionPath *node)
{
	WRITE_NODE_TYPE("PROJECTIONPATH");

	WRITE_ENUM_FIELD(path.pathtype, NodeTag);
	appendStringInfoString(str, " :parent_relids ");
	outBitmapset(str, node->path.parent->relids);
	if (node->path.pathtarget != node->path.parent->reltarget)
		WRITE_NODE_FIELD(path.pathtarget);
	appendStringInfoString(str, " :required_outer ");
	if (node->path.param_info)
		outBitmapset(str, node->path.param_info->ppi_req_outer);
	else
		outBitmapset(str, NULL);
	WRITE_BOOL_FIELD(path.parallel_aware);
	WRITE_BOOL_FIELD(path.parallel_safe);
	WRITE_INT_FIELD(path.parallel_workers);
	WRITE_FLOAT_FIELD(path.rows);
	WRITE_FLOAT_FIELD(path.startup_cost);
	WRITE_FLOAT_FIELD(path.total_cost);
	WRITE_NODE_FIELD(path.pathkeys);
	WRITE_NODE_FIELD(subpath);
	WRITE_BOOL_FIELD(dummypp);
}

static void
_outProjectSetPath(StringInfo str, const ProjectSetPath *node)
{
	WRITE_NODE_TYPE("PROJECTSETPATH");

	WRITE_ENUM_FIELD(path.pathtype, NodeTag);
	appendStringInfoString(str, " :parent_relids ");
	outBitmapset(str, node->path.parent->relids);
	if (node->path.pathtarget != node->path.parent->reltarget)
		WRITE_NODE_FIELD(path.pathtarget);
	appendStringInfoString(str, " :required_outer ");
	if (node->path.param_info)
		outBitmapset(str, node->path.param_info->ppi_req_outer);
	else
		outBitmapset(str, NULL);
	WRITE_BOOL_FIELD(path.parallel_aware);
	WRITE_BOOL_FIELD(path.parallel_safe);
	WRITE_INT_FIELD(path.parallel_workers);
	WRITE_FLOAT_FIELD(path.rows);
	WRITE_FLOAT_FIELD(path.startup_cost);
	WRITE_FLOAT_FIELD(path.total_cost);
	WRITE_NODE_FIELD(path.pathkeys);
	WRITE_NODE_FIELD(subpath);
}

static void
_outSortPath(StringInfo str, const SortPath *node)
{
	WRITE_NODE_TYPE("SORTPATH");

	WRITE_ENUM_FIELD(path.pathtype, NodeTag);
	appendStringInfoString(str, " :parent_relids ");
	outBitmapset(str, node->path.parent->relids);
	if (node->path.pathtarget != node->path.parent->reltarget)
		WRITE_NODE_FIELD(path.pathtarget);
	appendStringInfoString(str, " :required_outer ");
	if (node->path.param_info)
		outBitmapset(str, node->path.param_info->ppi_req_outer);
	else
		outBitmapset(str, NULL);
	WRITE_BOOL_FIELD(path.parallel_aware);
	WRITE_BOOL_FIELD(path.parallel_safe);
	WRITE_INT_FIELD(path.parallel_workers);
	WRITE_FLOAT_FIELD(path.rows);
	WRITE_FLOAT_FIELD(path.startup_cost);
	WRITE_FLOAT_FIELD(path.total_cost);
	WRITE_NODE_FIELD(path.pathkeys);
	WRITE_NODE_FIELD(subpath);
}

static void
_outIncrementalSortPath(StringInfo str, const IncrementalSortPath *node)
{
	WRITE_NODE_TYPE("INCREMENTALSORTPATH");

	WRITE_ENUM_FIELD(spath.path.pathtype, NodeTag);
	appendStringInfoString(str, " :parent_relids ");
	outBitmapset(str, node->spath.path.parent->relids);
	if (node->spath.path.pathtarget != node->spath.path.parent->reltarget)
		WRITE_NODE_FIELD(spath.path.pathtarget);
	appendStringInfoString(str, " :required_outer ");
	if (node->spath.path.param_info)
		outBitmapset(str, node->spath.path.param_info->ppi_req_outer);
	else
		outBitmapset(str, NULL);
	WRITE_BOOL_FIELD(spath.path.parallel_aware);
	WRITE_BOOL_FIELD(spath.path.parallel_safe);
	WRITE_INT_FIELD(spath.path.parallel_workers);
	WRITE_FLOAT_FIELD(spath.path.rows);
	WRITE_FLOAT_FIELD(spath.path.startup_cost);
	WRITE_FLOAT_FIELD(spath.path.total_cost);
	WRITE_NODE_FIELD(spath.path.pathkeys);
	WRITE_NODE_FIELD(spath.subpath);
	WRITE_INT_FIELD(nPresortedCols);
}

static void
_outGroupPath(StringInfo str, const GroupPath *node)
{
	WRITE_NODE_TYPE("GROUPPATH");

	WRITE_ENUM_FIELD(path.pathtype, NodeTag);
	appendStringInfoString(str, " :parent_relids ");
	outBitmapset(str, node->path.parent->relids);
	if (node->path.pathtarget != node->path.parent->reltarget)
		WRITE_NODE_FIELD(path.pathtarget);
	appendStringInfoString(str, " :required_outer ");
	if (node->path.param_info)
		outBitmapset(str, node->path.param_info->ppi_req_outer);
	else
		outBitmapset(str, NULL);
	WRITE_BOOL_FIELD(path.parallel_aware);
	WRITE_BOOL_FIELD(path.parallel_safe);
	WRITE_INT_FIELD(path.parallel_workers);
	WRITE_FLOAT_FIELD(path.rows);
	WRITE_FLOAT_FIELD(path.startup_cost);
	WRITE_FLOAT_FIELD(path.total_cost);
	WRITE_NODE_FIELD(path.pathkeys);
	WRITE_NODE_FIELD(subpath);
	WRITE_NODE_FIELD(groupClause);
	WRITE_NODE_FIELD(qual);
}

static void
_outUpperUniquePath(StringInfo str, const UpperUniquePath *node)
{
	WRITE_NODE_TYPE("UPPERUNIQUEPATH");

	WRITE_ENUM_FIELD(path.pathtype, NodeTag);
	appendStringInfoString(str, " :parent_relids ");
	outBitmapset(str, node->path.parent->relids);
	if (node->path.pathtarget != node->path.parent->reltarget)
		WRITE_NODE_FIELD(path.pathtarget);
	appendStringInfoString(str, " :required_outer ");
	if (node->path.param_info)
		outBitmapset(str, node->path.param_info->ppi_req_outer);
	else
		outBitmapset(str, NULL);
	WRITE_BOOL_FIELD(path.parallel_aware);
	WRITE_BOOL_FIELD(path.parallel_safe);
	WRITE_INT_FIELD(path.parallel_workers);
	WRITE_FLOAT_FIELD(path.rows);
	WRITE_FLOAT_FIELD(path.startup_cost);
	WRITE_FLOAT_FIELD(path.total_cost);
	WRITE_NODE_FIELD(path.pathkeys);
	WRITE_NODE_FIELD(subpath);
	WRITE_INT_FIELD(numkeys);
}

static void
_outAggPath(StringInfo str, const AggPath *node)
{
	WRITE_NODE_TYPE("AGGPATH");

	WRITE_ENUM_FIELD(path.pathtype, NodeTag);
	appendStringInfoString(str, " :parent_relids ");
	outBitmapset(str, node->path.parent->relids);
	if (node->path.pathtarget != node->path.parent->reltarget)
		WRITE_NODE_FIELD(path.pathtarget);
	appendStringInfoString(str, " :required_outer ");
	if (node->path.param_info)
		outBitmapset(str, node->path.param_info->ppi_req_outer);
	else
		outBitmapset(str, NULL);
	WRITE_BOOL_FIELD(path.parallel_aware);
	WRITE_BOOL_FIELD(path.parallel_safe);
	WRITE_INT_FIELD(path.parallel_workers);
	WRITE_FLOAT_FIELD(path.rows);
	WRITE_FLOAT_FIELD(path.startup_cost);
	WRITE_FLOAT_FIELD(path.total_cost);
	WRITE_NODE_FIELD(path.pathkeys);
	WRITE_NODE_FIELD(subpath);
	WRITE_ENUM_FIELD(aggstrategy, AggStrategy);
	WRITE_ENUM_FIELD(aggsplit, AggSplit);
	WRITE_FLOAT_FIELD(numGroups);
	WRITE_UINT64_FIELD(transitionSpace);
	WRITE_NODE_FIELD(groupClause);
	WRITE_NODE_FIELD(qual);
}

static void
_outGroupingSetData(StringInfo str, const GroupingSetData *node)
{
	WRITE_NODE_TYPE("GROUPINGSETDATA");

	WRITE_NODE_FIELD(set);
	WRITE_FLOAT_FIELD(numGroups);
}

static void
_outRollupData(StringInfo str, const RollupData *node)
{
	WRITE_NODE_TYPE("ROLLUPDATA");

	WRITE_NODE_FIELD(groupClause);
	WRITE_NODE_FIELD(gsets);
	WRITE_NODE_FIELD(gsets_data);
	WRITE_FLOAT_FIELD(numGroups);
	WRITE_BOOL_FIELD(hashable);
	WRITE_BOOL_FIELD(is_hashed);
}

static void
_outGroupingSetsPath(StringInfo str, const GroupingSetsPath *node)
{
	WRITE_NODE_TYPE("GROUPINGSETSPATH");

	WRITE_ENUM_FIELD(path.pathtype, NodeTag);
	appendStringInfoString(str, " :parent_relids ");
	outBitmapset(str, node->path.parent->relids);
	if (node->path.pathtarget != node->path.parent->reltarget)
		WRITE_NODE_FIELD(path.pathtarget);
	appendStringInfoString(str, " :required_outer ");
	if (node->path.param_info)
		outBitmapset(str, node->path.param_info->ppi_req_outer);
	else
		outBitmapset(str, NULL);
	WRITE_BOOL_FIELD(path.parallel_aware);
	WRITE_BOOL_FIELD(path.parallel_safe);
	WRITE_INT_FIELD(path.parallel_workers);
	WRITE_FLOAT_FIELD(path.rows);
	WRITE_FLOAT_FIELD(path.startup_cost);
	WRITE_FLOAT_FIELD(path.total_cost);
	WRITE_NODE_FIELD(path.pathkeys);
	WRITE_NODE_FIELD(subpath);
	WRITE_ENUM_FIELD(aggstrategy, AggStrategy);
	WRITE_NODE_FIELD(rollups);
	WRITE_NODE_FIELD(qual);
	WRITE_UINT64_FIELD(transitionSpace);
}

static void
_outMinMaxAggPath(StringInfo str, const MinMaxAggPath *node)
{
	WRITE_NODE_TYPE("MINMAXAGGPATH");

	WRITE_ENUM_FIELD(path.pathtype, NodeTag);
	appendStringInfoString(str, " :parent_relids ");
	outBitmapset(str, node->path.parent->relids);
	if (node->path.pathtarget != node->path.parent->reltarget)
		WRITE_NODE_FIELD(path.pathtarget);
	appendStringInfoString(str, " :required_outer ");
	if (node->path.param_info)
		outBitmapset(str, node->path.param_info->ppi_req_outer);
	else
		outBitmapset(str, NULL);
	WRITE_BOOL_FIELD(path.parallel_aware);
	WRITE_BOOL_FIELD(path.parallel_safe);
	WRITE_INT_FIELD(path.parallel_workers);
	WRITE_FLOAT_FIELD(path.rows);
	WRITE_FLOAT_FIELD(path.startup_cost);
	WRITE_FLOAT_FIELD(path.total_cost);
	WRITE_NODE_FIELD(path.pathkeys);
	WRITE_NODE_FIELD(mmaggregates);
	WRITE_NODE_FIELD(quals);
}

static void
_outWindowAggPath(StringInfo str, const WindowAggPath *node)
{
	WRITE_NODE_TYPE("WINDOWAGGPATH");

	WRITE_ENUM_FIELD(path.pathtype, NodeTag);
	appendStringInfoString(str, " :parent_relids ");
	outBitmapset(str, node->path.parent->relids);
	if (node->path.pathtarget != node->path.parent->reltarget)
		WRITE_NODE_FIELD(path.pathtarget);
	appendStringInfoString(str, " :required_outer ");
	if (node->path.param_info)
		outBitmapset(str, node->path.param_info->ppi_req_outer);
	else
		outBitmapset(str, NULL);
	WRITE_BOOL_FIELD(path.parallel_aware);
	WRITE_BOOL_FIELD(path.parallel_safe);
	WRITE_INT_FIELD(path.parallel_workers);
	WRITE_FLOAT_FIELD(path.rows);
	WRITE_FLOAT_FIELD(path.startup_cost);
	WRITE_FLOAT_FIELD(path.total_cost);
	WRITE_NODE_FIELD(path.pathkeys);
	WRITE_NODE_FIELD(subpath);
	WRITE_NODE_FIELD(winclause);
	WRITE_NODE_FIELD(qual);
	WRITE_BOOL_FIELD(topwindow);
}

static void
_outSetOpPath(StringInfo str, const SetOpPath *node)
{
	WRITE_NODE_TYPE("SETOPPATH");

	WRITE_ENUM_FIELD(path.pathtype, NodeTag);
	appendStringInfoString(str, " :parent_relids ");
	outBitmapset(str, node->path.parent->relids);
	if (node->path.pathtarget != node->path.parent->reltarget)
		WRITE_NODE_FIELD(path.pathtarget);
	appendStringInfoString(str, " :required_outer ");
	if (node->path.param_info)
		outBitmapset(str, node->path.param_info->ppi_req_outer);
	else
		outBitmapset(str, NULL);
	WRITE_BOOL_FIELD(path.parallel_aware);
	WRITE_BOOL_FIELD(path.parallel_safe);
	WRITE_INT_FIELD(path.parallel_workers);
	WRITE_FLOAT_FIELD(path.rows);
	WRITE_FLOAT_FIELD(path.startup_cost);
	WRITE_FLOAT_FIELD(path.total_cost);
	WRITE_NODE_FIELD(path.pathkeys);
	WRITE_NODE_FIELD(subpath);
	WRITE_ENUM_FIELD(cmd, SetOpCmd);
	WRITE_ENUM_FIELD(strategy, SetOpStrategy);
	WRITE_NODE_FIELD(distinctList);
	WRITE_INT_FIELD(flagColIdx);
	WRITE_INT_FIELD(firstFlag);
	WRITE_FLOAT_FIELD(numGroups);
}

static void
_outRecursiveUnionPath(StringInfo str, const RecursiveUnionPath *node)
{
	WRITE_NODE_TYPE("RECURSIVEUNIONPATH");

	WRITE_ENUM_FIELD(path.pathtype, NodeTag);
	appendStringInfoString(str, " :parent_relids ");
	outBitmapset(str, node->path.parent->relids);
	if (node->path.pathtarget != node->path.parent->reltarget)
		WRITE_NODE_FIELD(path.pathtarget);
	appendStringInfoString(str, " :required_outer ");
	if (node->path.param_info)
		outBitmapset(str, node->path.param_info->ppi_req_outer);
	else
		outBitmapset(str, NULL);
	WRITE_BOOL_FIELD(path.parallel_aware);
	WRITE_BOOL_FIELD(path.parallel_safe);
	WRITE_INT_FIELD(path.parallel_workers);
	WRITE_FLOAT_FIELD(path.rows);
	WRITE_FLOAT_FIELD(path.startup_cost);
	WRITE_FLOAT_FIELD(path.total_cost);
	WRITE_NODE_FIELD(path.pathkeys);
	WRITE_NODE_FIELD(leftpath);
	WRITE_NODE_FIELD(rightpath);
	WRITE_NODE_FIELD(distinctList);
	WRITE_INT_FIELD(wtParam);
	WRITE_FLOAT_FIELD(numGroups);
}

static void
_outLockRowsPath(StringInfo str, const LockRowsPath *node)
{
	WRITE_NODE_TYPE("LOCKROWSPATH");

	WRITE_ENUM_FIELD(path.pathtype, NodeTag);
	appendStringInfoString(str, " :parent_relids ");
	outBitmapset(str, node->path.parent->relids);
	if (node->path.pathtarget != node->path.parent->reltarget)
		WRITE_NODE_FIELD(path.pathtarget);
	appendStringInfoString(str, " :required_outer ");
	if (node->path.param_info)
		outBitmapset(str, node->path.param_info->ppi_req_outer);
	else
		outBitmapset(str, NULL);
	WRITE_BOOL_FIELD(path.parallel_aware);
	WRITE_BOOL_FIELD(path.parallel_safe);
	WRITE_INT_FIELD(path.parallel_workers);
	WRITE_FLOAT_FIELD(path.rows);
	WRITE_FLOAT_FIELD(path.startup_cost);
	WRITE_FLOAT_FIELD(path.total_cost);
	WRITE_NODE_FIELD(path.pathkeys);
	WRITE_NODE_FIELD(subpath);
	WRITE_NODE_FIELD(rowMarks);
	WRITE_INT_FIELD(epqParam);
}

static void
_outModifyTablePath(StringInfo str, const ModifyTablePath *node)
{
	WRITE_NODE_TYPE("MODIFYTABLEPATH");

	WRITE_ENUM_FIELD(path.pathtype, NodeTag);
	appendStringInfoString(str, " :parent_relids ");
	outBitmapset(str, node->path.parent->relids);
	if (node->path.pathtarget != node->path.parent->reltarget)
		WRITE_NODE_FIELD(path.pathtarget);
	appendStringInfoString(str, " :required_outer ");
	if (node->path.param_info)
		outBitmapset(str, node->path.param_info->ppi_req_outer);
	else
		outBitmapset(str, NULL);
	WRITE_BOOL_FIELD(path.parallel_aware);
	WRITE_BOOL_FIELD(path.parallel_safe);
	WRITE_INT_FIELD(path.parallel_workers);
	WRITE_FLOAT_FIELD(path.rows);
	WRITE_FLOAT_FIELD(path.startup_cost);
	WRITE_FLOAT_FIELD(path.total_cost);
	WRITE_NODE_FIELD(path.pathkeys);
	WRITE_NODE_FIELD(subpath);
	WRITE_ENUM_FIELD(operation, CmdType);
	WRITE_BOOL_FIELD(canSetTag);
	WRITE_UINT_FIELD(nominalRelation);
	WRITE_UINT_FIELD(rootRelation);
	WRITE_BOOL_FIELD(partColsUpdated);
	WRITE_NODE_FIELD(resultRelations);
	WRITE_NODE_FIELD(updateColnosLists);
	WRITE_NODE_FIELD(withCheckOptionLists);
	WRITE_NODE_FIELD(returningLists);
	WRITE_NODE_FIELD(rowMarks);
	WRITE_NODE_FIELD(onconflict);
	WRITE_INT_FIELD(epqParam);
	WRITE_NODE_FIELD(mergeActionLists);
}

static void
_outLimitPath(StringInfo str, const LimitPath *node)
{
	WRITE_NODE_TYPE("LIMITPATH");

	WRITE_ENUM_FIELD(path.pathtype, NodeTag);
	appendStringInfoString(str, " :parent_relids ");
	outBitmapset(str, node->path.parent->relids);
	if (node->path.pathtarget != node->path.parent->reltarget)
		WRITE_NODE_FIELD(path.pathtarget);
	appendStringInfoString(str, " :required_outer ");
	if (node->path.param_info)
		outBitmapset(str, node->path.param_info->ppi_req_outer);
	else
		outBitmapset(str, NULL);
	WRITE_BOOL_FIELD(path.parallel_aware);
	WRITE_BOOL_FIELD(path.parallel_safe);
	WRITE_INT_FIELD(path.parallel_workers);
	WRITE_FLOAT_FIELD(path.rows);
	WRITE_FLOAT_FIELD(path.startup_cost);
	WRITE_FLOAT_FIELD(path.total_cost);
	WRITE_NODE_FIELD(path.pathkeys);
	WRITE_NODE_FIELD(subpath);
	WRITE_NODE_FIELD(limitOffset);
	WRITE_NODE_FIELD(limitCount);
	WRITE_ENUM_FIELD(limitOption, LimitOption);
}

static void
_outRestrictInfo(StringInfo str, const RestrictInfo *node)
{
	WRITE_NODE_TYPE("RESTRICTINFO");

	WRITE_NODE_FIELD(clause);
	WRITE_BOOL_FIELD(is_pushed_down);
	WRITE_BOOL_FIELD(can_join);
	WRITE_BOOL_FIELD(pseudoconstant);
	WRITE_BOOL_FIELD(has_clone);
	WRITE_BOOL_FIELD(is_clone);
	WRITE_BOOL_FIELD(leakproof);
	WRITE_ENUM_FIELD(has_volatile, VolatileFunctionStatus);
	WRITE_UINT_FIELD(security_level);
	WRITE_INT_FIELD(num_base_rels);
	WRITE_BITMAPSET_FIELD(clause_relids);
	WRITE_BITMAPSET_FIELD(required_relids);
	WRITE_BITMAPSET_FIELD(incompatible_relids);
	WRITE_BITMAPSET_FIELD(outer_relids);
	WRITE_BITMAPSET_FIELD(left_relids);
	WRITE_BITMAPSET_FIELD(right_relids);
	WRITE_NODE_FIELD(orclause);
	WRITE_INT_FIELD(rinfo_serial);
	WRITE_FLOAT_FIELD(eval_cost.startup);
	WRITE_FLOAT_FIELD(eval_cost.per_tuple);
	WRITE_FLOAT_FIELD(norm_selec);
	WRITE_FLOAT_FIELD(outer_selec);
	WRITE_NODE_FIELD(mergeopfamilies);
	WRITE_NODE_FIELD(left_em);
	WRITE_NODE_FIELD(right_em);
	WRITE_BOOL_FIELD(outer_is_left);
	WRITE_OID_FIELD(hashjoinoperator);
	WRITE_FLOAT_FIELD(left_bucketsize);
	WRITE_FLOAT_FIELD(right_bucketsize);
	WRITE_FLOAT_FIELD(left_mcvfreq);
	WRITE_FLOAT_FIELD(right_mcvfreq);
	WRITE_OID_FIELD(left_hasheqoperator);
	WRITE_OID_FIELD(right_hasheqoperator);
}

static void
_outPlaceHolderVar(StringInfo str, const PlaceHolderVar *node)
{
	WRITE_NODE_TYPE("PLACEHOLDERVAR");

	WRITE_NODE_FIELD(phexpr);
	WRITE_BITMAPSET_FIELD(phrels);
	WRITE_BITMAPSET_FIELD(phnullingrels);
	WRITE_UINT_FIELD(phid);
	WRITE_UINT_FIELD(phlevelsup);
}

static void
_outSpecialJoinInfo(StringInfo str, const SpecialJoinInfo *node)
{
	WRITE_NODE_TYPE("SPECIALJOININFO");

	WRITE_BITMAPSET_FIELD(min_lefthand);
	WRITE_BITMAPSET_FIELD(min_righthand);
	WRITE_BITMAPSET_FIELD(syn_lefthand);
	WRITE_BITMAPSET_FIELD(syn_righthand);
	WRITE_ENUM_FIELD(jointype, JoinType);
	WRITE_UINT_FIELD(ojrelid);
	WRITE_BITMAPSET_FIELD(commute_above_l);
	WRITE_BITMAPSET_FIELD(commute_above_r);
	WRITE_BITMAPSET_FIELD(commute_below_l);
	WRITE_BITMAPSET_FIELD(commute_below_r);
	WRITE_BOOL_FIELD(lhs_strict);
	WRITE_BOOL_FIELD(semi_can_btree);
	WRITE_BOOL_FIELD(semi_can_hash);
	WRITE_NODE_FIELD(semi_operators);
	WRITE_NODE_FIELD(semi_rhs_exprs);
}

static void
_outOuterJoinClauseInfo(StringInfo str, const OuterJoinClauseInfo *node)
{
	WRITE_NODE_TYPE("OUTERJOINCLAUSEINFO");

	WRITE_NODE_FIELD(rinfo);
	WRITE_NODE_FIELD(sjinfo);
}

static void
_outAppendRelInfo(StringInfo str, const AppendRelInfo *node)
{
	WRITE_NODE_TYPE("APPENDRELINFO");

	WRITE_UINT_FIELD(parent_relid);
	WRITE_UINT_FIELD(child_relid);
	WRITE_OID_FIELD(parent_reltype);
	WRITE_OID_FIELD(child_reltype);
	WRITE_NODE_FIELD(translated_vars);
	WRITE_INT_FIELD(num_child_cols);
	WRITE_ATTRNUMBER_ARRAY(parent_colnos, node->num_child_cols);
	WRITE_OID_FIELD(parent_reloid);
}

static void
_outRowIdentityVarInfo(StringInfo str, const RowIdentityVarInfo *node)
{
	WRITE_NODE_TYPE("ROWIDENTITYVARINFO");

	WRITE_NODE_FIELD(rowidvar);
	WRITE_INT_FIELD(rowidwidth);
	WRITE_STRING_FIELD(rowidname);
	WRITE_BITMAPSET_FIELD(rowidrels);
}

static void
_outPlaceHolderInfo(StringInfo str, const PlaceHolderInfo *node)
{
	WRITE_NODE_TYPE("PLACEHOLDERINFO");

	WRITE_UINT_FIELD(phid);
	WRITE_NODE_FIELD(ph_var);
	WRITE_BITMAPSET_FIELD(ph_eval_at);
	WRITE_BITMAPSET_FIELD(ph_lateral);
	WRITE_BITMAPSET_FIELD(ph_needed);
	WRITE_INT_FIELD(ph_width);
}

static void
_outMinMaxAggInfo(StringInfo str, const MinMaxAggInfo *node)
{
	WRITE_NODE_TYPE("MINMAXAGGINFO");

	WRITE_OID_FIELD(aggfnoid);
	WRITE_OID_FIELD(aggsortop);
	WRITE_NODE_FIELD(target);
	WRITE_NODE_FIELD(path);
	WRITE_FLOAT_FIELD(pathcost);
	WRITE_NODE_FIELD(param);
}

static void
_outPlannerParamItem(StringInfo str, const PlannerParamItem *node)
{
	WRITE_NODE_TYPE("PLANNERPARAMITEM");

	WRITE_NODE_FIELD(item);
	WRITE_INT_FIELD(paramId);
}

static void
_outAggInfo(StringInfo str, const AggInfo *node)
{
	WRITE_NODE_TYPE("AGGINFO");

	WRITE_NODE_FIELD(aggrefs);
	WRITE_INT_FIELD(transno);
	WRITE_BOOL_FIELD(shareable);
	WRITE_OID_FIELD(finalfn_oid);
}

static void
_outAggTransInfo(StringInfo str, const AggTransInfo *node)
{
	WRITE_NODE_TYPE("AGGTRANSINFO");

	WRITE_NODE_FIELD(args);
	WRITE_NODE_FIELD(aggfilter);
	WRITE_OID_FIELD(transfn_oid);
	WRITE_OID_FIELD(serialfn_oid);
	WRITE_OID_FIELD(deserialfn_oid);
	WRITE_OID_FIELD(combinefn_oid);
	WRITE_OID_FIELD(aggtranstype);
	WRITE_INT_FIELD(aggtranstypmod);
	WRITE_INT_FIELD(transtypeLen);
	WRITE_BOOL_FIELD(transtypeByVal);
	WRITE_INT_FIELD(aggtransspace);
	WRITE_BOOL_FIELD(initValueIsNull);
}

static void
_outPlannedStmt(StringInfo str, const PlannedStmt *node)
{
	WRITE_NODE_TYPE("PLANNEDSTMT");

	WRITE_ENUM_FIELD(commandType, CmdType);
	WRITE_UINT64_FIELD(queryId);
	WRITE_BOOL_FIELD(hasReturning);
	WRITE_BOOL_FIELD(hasModifyingCTE);
	WRITE_BOOL_FIELD(canSetTag);
	WRITE_BOOL_FIELD(transientPlan);
	WRITE_BOOL_FIELD(dependsOnRole);
	WRITE_BOOL_FIELD(parallelModeNeeded);
	WRITE_INT_FIELD(jitFlags);
	WRITE_NODE_FIELD(planTree);
	WRITE_NODE_FIELD(rtable);
	WRITE_NODE_FIELD(permInfos);
	WRITE_NODE_FIELD(resultRelations);
	WRITE_NODE_FIELD(appendRelations);
	WRITE_NODE_FIELD(subplans);
	WRITE_BITMAPSET_FIELD(rewindPlanIDs);
	WRITE_NODE_FIELD(rowMarks);
	WRITE_NODE_FIELD(relationOids);
	WRITE_NODE_FIELD(invalItems);
	WRITE_NODE_FIELD(paramExecTypes);
	WRITE_NODE_FIELD(utilityStmt);
	WRITE_LOCATION_FIELD(stmt_location);
	WRITE_INT_FIELD(stmt_len);
}

static void
_outResult(StringInfo str, const Result *node)
{
	WRITE_NODE_TYPE("RESULT");

	WRITE_FLOAT_FIELD(plan.startup_cost);
	WRITE_FLOAT_FIELD(plan.total_cost);
	WRITE_FLOAT_FIELD(plan.plan_rows);
	WRITE_INT_FIELD(plan.plan_width);
	WRITE_BOOL_FIELD(plan.parallel_aware);
	WRITE_BOOL_FIELD(plan.parallel_safe);
	WRITE_BOOL_FIELD(plan.async_capable);
	WRITE_INT_FIELD(plan.plan_node_id);
	WRITE_NODE_FIELD(plan.targetlist);
	WRITE_NODE_FIELD(plan.qual);
	WRITE_NODE_FIELD(plan.lefttree);
	WRITE_NODE_FIELD(plan.righttree);
	WRITE_NODE_FIELD(plan.initPlan);
	WRITE_BITMAPSET_FIELD(plan.extParam);
	WRITE_BITMAPSET_FIELD(plan.allParam);
	WRITE_NODE_FIELD(resconstantqual);
}

static void
_outProjectSet(StringInfo str, const ProjectSet *node)
{
	WRITE_NODE_TYPE("PROJECTSET");

	WRITE_FLOAT_FIELD(plan.startup_cost);
	WRITE_FLOAT_FIELD(plan.total_cost);
	WRITE_FLOAT_FIELD(plan.plan_rows);
	WRITE_INT_FIELD(plan.plan_width);
	WRITE_BOOL_FIELD(plan.parallel_aware);
	WRITE_BOOL_FIELD(plan.parallel_safe);
	WRITE_BOOL_FIELD(plan.async_capable);
	WRITE_INT_FIELD(plan.plan_node_id);
	WRITE_NODE_FIELD(plan.targetlist);
	WRITE_NODE_FIELD(plan.qual);
	WRITE_NODE_FIELD(plan.lefttree);
	WRITE_NODE_FIELD(plan.righttree);
	WRITE_NODE_FIELD(plan.initPlan);
	WRITE_BITMAPSET_FIELD(plan.extParam);
	WRITE_BITMAPSET_FIELD(plan.allParam);
}

static void
_outModifyTable(StringInfo str, const ModifyTable *node)
{
	WRITE_NODE_TYPE("MODIFYTABLE");

	WRITE_FLOAT_FIELD(plan.startup_cost);
	WRITE_FLOAT_FIELD(plan.total_cost);
	WRITE_FLOAT_FIELD(plan.plan_rows);
	WRITE_INT_FIELD(plan.plan_width);
	WRITE_BOOL_FIELD(plan.parallel_aware);
	WRITE_BOOL_FIELD(plan.parallel_safe);
	WRITE_BOOL_FIELD(plan.async_capable);
	WRITE_INT_FIELD(plan.plan_node_id);
	WRITE_NODE_FIELD(plan.targetlist);
	WRITE_NODE_FIELD(plan.qual);
	WRITE_NODE_FIELD(plan.lefttree);
	WRITE_NODE_FIELD(plan.righttree);
	WRITE_NODE_FIELD(plan.initPlan);
	WRITE_BITMAPSET_FIELD(plan.extParam);
	WRITE_BITMAPSET_FIELD(plan.allParam);
	WRITE_ENUM_FIELD(operation, CmdType);
	WRITE_BOOL_FIELD(canSetTag);
	WRITE_UINT_FIELD(nominalRelation);
	WRITE_UINT_FIELD(rootRelation);
	WRITE_BOOL_FIELD(partColsUpdated);
	WRITE_NODE_FIELD(resultRelations);
	WRITE_NODE_FIELD(updateColnosLists);
	WRITE_NODE_FIELD(withCheckOptionLists);
	WRITE_NODE_FIELD(returningLists);
	WRITE_NODE_FIELD(fdwPrivLists);
	WRITE_BITMAPSET_FIELD(fdwDirectModifyPlans);
	WRITE_NODE_FIELD(rowMarks);
	WRITE_INT_FIELD(epqParam);
	WRITE_ENUM_FIELD(onConflictAction, OnConflictAction);
	WRITE_NODE_FIELD(arbiterIndexes);
	WRITE_NODE_FIELD(onConflictSet);
	WRITE_NODE_FIELD(onConflictCols);
	WRITE_NODE_FIELD(onConflictWhere);
	WRITE_UINT_FIELD(exclRelRTI);
	WRITE_NODE_FIELD(exclRelTlist);
	WRITE_NODE_FIELD(mergeActionLists);
}

static void
_outAppend(StringInfo str, const Append *node)
{
	WRITE_NODE_TYPE("APPEND");

	WRITE_FLOAT_FIELD(plan.startup_cost);
	WRITE_FLOAT_FIELD(plan.total_cost);
	WRITE_FLOAT_FIELD(plan.plan_rows);
	WRITE_INT_FIELD(plan.plan_width);
	WRITE_BOOL_FIELD(plan.parallel_aware);
	WRITE_BOOL_FIELD(plan.parallel_safe);
	WRITE_BOOL_FIELD(plan.async_capable);
	WRITE_INT_FIELD(plan.plan_node_id);
	WRITE_NODE_FIELD(plan.targetlist);
	WRITE_NODE_FIELD(plan.qual);
	WRITE_NODE_FIELD(plan.lefttree);
	WRITE_NODE_FIELD(plan.righttree);
	WRITE_NODE_FIELD(plan.initPlan);
	WRITE_BITMAPSET_FIELD(plan.extParam);
	WRITE_BITMAPSET_FIELD(plan.allParam);
	WRITE_BITMAPSET_FIELD(apprelids);
	WRITE_NODE_FIELD(appendplans);
	WRITE_INT_FIELD(nasyncplans);
	WRITE_INT_FIELD(first_partial_plan);
	WRITE_NODE_FIELD(part_prune_info);
}

static void
_outMergeAppend(StringInfo str, const MergeAppend *node)
{
	WRITE_NODE_TYPE("MERGEAPPEND");

	WRITE_FLOAT_FIELD(plan.startup_cost);
	WRITE_FLOAT_FIELD(plan.total_cost);
	WRITE_FLOAT_FIELD(plan.plan_rows);
	WRITE_INT_FIELD(plan.plan_width);
	WRITE_BOOL_FIELD(plan.parallel_aware);
	WRITE_BOOL_FIELD(plan.parallel_safe);
	WRITE_BOOL_FIELD(plan.async_capable);
	WRITE_INT_FIELD(plan.plan_node_id);
	WRITE_NODE_FIELD(plan.targetlist);
	WRITE_NODE_FIELD(plan.qual);
	WRITE_NODE_FIELD(plan.lefttree);
	WRITE_NODE_FIELD(plan.righttree);
	WRITE_NODE_FIELD(plan.initPlan);
	WRITE_BITMAPSET_FIELD(plan.extParam);
	WRITE_BITMAPSET_FIELD(plan.allParam);
	WRITE_BITMAPSET_FIELD(apprelids);
	WRITE_NODE_FIELD(mergeplans);
	WRITE_INT_FIELD(numCols);
	WRITE_ATTRNUMBER_ARRAY(sortColIdx, node->numCols);
	WRITE_OID_ARRAY(sortOperators, node->numCols);
	WRITE_OID_ARRAY(collations, node->numCols);
	WRITE_BOOL_ARRAY(nullsFirst, node->numCols);
	WRITE_NODE_FIELD(part_prune_info);
}

static void
_outRecursiveUnion(StringInfo str, const RecursiveUnion *node)
{
	WRITE_NODE_TYPE("RECURSIVEUNION");

	WRITE_FLOAT_FIELD(plan.startup_cost);
	WRITE_FLOAT_FIELD(plan.total_cost);
	WRITE_FLOAT_FIELD(plan.plan_rows);
	WRITE_INT_FIELD(plan.plan_width);
	WRITE_BOOL_FIELD(plan.parallel_aware);
	WRITE_BOOL_FIELD(plan.parallel_safe);
	WRITE_BOOL_FIELD(plan.async_capable);
	WRITE_INT_FIELD(plan.plan_node_id);
	WRITE_NODE_FIELD(plan.targetlist);
	WRITE_NODE_FIELD(plan.qual);
	WRITE_NODE_FIELD(plan.lefttree);
	WRITE_NODE_FIELD(plan.righttree);
	WRITE_NODE_FIELD(plan.initPlan);
	WRITE_BITMAPSET_FIELD(plan.extParam);
	WRITE_BITMAPSET_FIELD(plan.allParam);
	WRITE_INT_FIELD(wtParam);
	WRITE_INT_FIELD(numCols);
	WRITE_ATTRNUMBER_ARRAY(dupColIdx, node->numCols);
	WRITE_OID_ARRAY(dupOperators, node->numCols);
	WRITE_OID_ARRAY(dupCollations, node->numCols);
	WRITE_LONG_FIELD(numGroups);
}

static void
_outBitmapAnd(StringInfo str, const BitmapAnd *node)
{
	WRITE_NODE_TYPE("BITMAPAND");

	WRITE_FLOAT_FIELD(plan.startup_cost);
	WRITE_FLOAT_FIELD(plan.total_cost);
	WRITE_FLOAT_FIELD(plan.plan_rows);
	WRITE_INT_FIELD(plan.plan_width);
	WRITE_BOOL_FIELD(plan.parallel_aware);
	WRITE_BOOL_FIELD(plan.parallel_safe);
	WRITE_BOOL_FIELD(plan.async_capable);
	WRITE_INT_FIELD(plan.plan_node_id);
	WRITE_NODE_FIELD(plan.targetlist);
	WRITE_NODE_FIELD(plan.qual);
	WRITE_NODE_FIELD(plan.lefttree);
	WRITE_NODE_FIELD(plan.righttree);
	WRITE_NODE_FIELD(plan.initPlan);
	WRITE_BITMAPSET_FIELD(plan.extParam);
	WRITE_BITMAPSET_FIELD(plan.allParam);
	WRITE_NODE_FIELD(bitmapplans);
}

static void
_outBitmapOr(StringInfo str, const BitmapOr *node)
{
	WRITE_NODE_TYPE("BITMAPOR");

	WRITE_FLOAT_FIELD(plan.startup_cost);
	WRITE_FLOAT_FIELD(plan.total_cost);
	WRITE_FLOAT_FIELD(plan.plan_rows);
	WRITE_INT_FIELD(plan.plan_width);
	WRITE_BOOL_FIELD(plan.parallel_aware);
	WRITE_BOOL_FIELD(plan.parallel_safe);
	WRITE_BOOL_FIELD(plan.async_capable);
	WRITE_INT_FIELD(plan.plan_node_id);
	WRITE_NODE_FIELD(plan.targetlist);
	WRITE_NODE_FIELD(plan.qual);
	WRITE_NODE_FIELD(plan.lefttree);
	WRITE_NODE_FIELD(plan.righttree);
	WRITE_NODE_FIELD(plan.initPlan);
	WRITE_BITMAPSET_FIELD(plan.extParam);
	WRITE_BITMAPSET_FIELD(plan.allParam);
	WRITE_BOOL_FIELD(isshared);
	WRITE_NODE_FIELD(bitmapplans);
}

static void
_outSeqScan(StringInfo str, const SeqScan *node)
{
	WRITE_NODE_TYPE("SEQSCAN");

	WRITE_FLOAT_FIELD(scan.plan.startup_cost);
	WRITE_FLOAT_FIELD(scan.plan.total_cost);
	WRITE_FLOAT_FIELD(scan.plan.plan_rows);
	WRITE_INT_FIELD(scan.plan.plan_width);
	WRITE_BOOL_FIELD(scan.plan.parallel_aware);
	WRITE_BOOL_FIELD(scan.plan.parallel_safe);
	WRITE_BOOL_FIELD(scan.plan.async_capable);
	WRITE_INT_FIELD(scan.plan.plan_node_id);
	WRITE_NODE_FIELD(scan.plan.targetlist);
	WRITE_NODE_FIELD(scan.plan.qual);
	WRITE_NODE_FIELD(scan.plan.lefttree);
	WRITE_NODE_FIELD(scan.plan.righttree);
	WRITE_NODE_FIELD(scan.plan.initPlan);
	WRITE_BITMAPSET_FIELD(scan.plan.extParam);
	WRITE_BITMAPSET_FIELD(scan.plan.allParam);
	WRITE_UINT_FIELD(scan.scanrelid);
}

static void
_outSampleScan(StringInfo str, const SampleScan *node)
{
	WRITE_NODE_TYPE("SAMPLESCAN");

	WRITE_FLOAT_FIELD(scan.plan.startup_cost);
	WRITE_FLOAT_FIELD(scan.plan.total_cost);
	WRITE_FLOAT_FIELD(scan.plan.plan_rows);
	WRITE_INT_FIELD(scan.plan.plan_width);
	WRITE_BOOL_FIELD(scan.plan.parallel_aware);
	WRITE_BOOL_FIELD(scan.plan.parallel_safe);
	WRITE_BOOL_FIELD(scan.plan.async_capable);
	WRITE_INT_FIELD(scan.plan.plan_node_id);
	WRITE_NODE_FIELD(scan.plan.targetlist);
	WRITE_NODE_FIELD(scan.plan.qual);
	WRITE_NODE_FIELD(scan.plan.lefttree);
	WRITE_NODE_FIELD(scan.plan.righttree);
	WRITE_NODE_FIELD(scan.plan.initPlan);
	WRITE_BITMAPSET_FIELD(scan.plan.extParam);
	WRITE_BITMAPSET_FIELD(scan.plan.allParam);
	WRITE_UINT_FIELD(scan.scanrelid);
	WRITE_NODE_FIELD(tablesample);
}

static void
_outIndexScan(StringInfo str, const IndexScan *node)
{
	WRITE_NODE_TYPE("INDEXSCAN");

	WRITE_FLOAT_FIELD(scan.plan.startup_cost);
	WRITE_FLOAT_FIELD(scan.plan.total_cost);
	WRITE_FLOAT_FIELD(scan.plan.plan_rows);
	WRITE_INT_FIELD(scan.plan.plan_width);
	WRITE_BOOL_FIELD(scan.plan.parallel_aware);
	WRITE_BOOL_FIELD(scan.plan.parallel_safe);
	WRITE_BOOL_FIELD(scan.plan.async_capable);
	WRITE_INT_FIELD(scan.plan.plan_node_id);
	WRITE_NODE_FIELD(scan.plan.targetlist);
	WRITE_NODE_FIELD(scan.plan.qual);
	WRITE_NODE_FIELD(scan.plan.lefttree);
	WRITE_NODE_FIELD(scan.plan.righttree);
	WRITE_NODE_FIELD(scan.plan.initPlan);
	WRITE_BITMAPSET_FIELD(scan.plan.extParam);
	WRITE_BITMAPSET_FIELD(scan.plan.allParam);
	WRITE_UINT_FIELD(scan.scanrelid);
	WRITE_OID_FIELD(indexid);
	WRITE_NODE_FIELD(indexqual);
	WRITE_NODE_FIELD(indexqualorig);
	WRITE_NODE_FIELD(indexorderby);
	WRITE_NODE_FIELD(indexorderbyorig);
	WRITE_NODE_FIELD(indexorderbyops);
	WRITE_ENUM_FIELD(indexorderdir, ScanDirection);
}

static void
_outIndexOnlyScan(StringInfo str, const IndexOnlyScan *node)
{
	WRITE_NODE_TYPE("INDEXONLYSCAN");

	WRITE_FLOAT_FIELD(scan.plan.startup_cost);
	WRITE_FLOAT_FIELD(scan.plan.total_cost);
	WRITE_FLOAT_FIELD(scan.plan.plan_rows);
	WRITE_INT_FIELD(scan.plan.plan_width);
	WRITE_BOOL_FIELD(scan.plan.parallel_aware);
	WRITE_BOOL_FIELD(scan.plan.parallel_safe);
	WRITE_BOOL_FIELD(scan.plan.async_capable);
	WRITE_INT_FIELD(scan.plan.plan_node_id);
	WRITE_NODE_FIELD(scan.plan.targetlist);
	WRITE_NODE_FIELD(scan.plan.qual);
	WRITE_NODE_FIELD(scan.plan.lefttree);
	WRITE_NODE_FIELD(scan.plan.righttree);
	WRITE_NODE_FIELD(scan.plan.initPlan);
	WRITE_BITMAPSET_FIELD(scan.plan.extParam);
	WRITE_BITMAPSET_FIELD(scan.plan.allParam);
	WRITE_UINT_FIELD(scan.scanrelid);
	WRITE_OID_FIELD(indexid);
	WRITE_NODE_FIELD(indexqual);
	WRITE_NODE_FIELD(recheckqual);
	WRITE_NODE_FIELD(indexorderby);
	WRITE_NODE_FIELD(indextlist);
	WRITE_ENUM_FIELD(indexorderdir, ScanDirection);
}

static void
_outBitmapIndexScan(StringInfo str, const BitmapIndexScan *node)
{
	WRITE_NODE_TYPE("BITMAPINDEXSCAN");

	WRITE_FLOAT_FIELD(scan.plan.startup_cost);
	WRITE_FLOAT_FIELD(scan.plan.total_cost);
	WRITE_FLOAT_FIELD(scan.plan.plan_rows);
	WRITE_INT_FIELD(scan.plan.plan_width);
	WRITE_BOOL_FIELD(scan.plan.parallel_aware);
	WRITE_BOOL_FIELD(scan.plan.parallel_safe);
	WRITE_BOOL_FIELD(scan.plan.async_capable);
	WRITE_INT_FIELD(scan.plan.plan_node_id);
	WRITE_NODE_FIELD(scan.plan.targetlist);
	WRITE_NODE_FIELD(scan.plan.qual);
	WRITE_NODE_FIELD(scan.plan.lefttree);
	WRITE_NODE_FIELD(scan.plan.righttree);
	WRITE_NODE_FIELD(scan.plan.initPlan);
	WRITE_BITMAPSET_FIELD(scan.plan.extParam);
	WRITE_BITMAPSET_FIELD(scan.plan.allParam);
	WRITE_UINT_FIELD(scan.scanrelid);
	WRITE_OID_FIELD(indexid);
	WRITE_BOOL_FIELD(isshared);
	WRITE_NODE_FIELD(indexqual);
	WRITE_NODE_FIELD(indexqualorig);
}

static void
_outBitmapHeapScan(StringInfo str, const BitmapHeapScan *node)
{
	WRITE_NODE_TYPE("BITMAPHEAPSCAN");

	WRITE_FLOAT_FIELD(scan.plan.startup_cost);
	WRITE_FLOAT_FIELD(scan.plan.total_cost);
	WRITE_FLOAT_FIELD(scan.plan.plan_rows);
	WRITE_INT_FIELD(scan.plan.plan_width);
	WRITE_BOOL_FIELD(scan.plan.parallel_aware);
	WRITE_BOOL_FIELD(scan.plan.parallel_safe);
	WRITE_BOOL_FIELD(scan.plan.async_capable);
	WRITE_INT_FIELD(scan.plan.plan_node_id);
	WRITE_NODE_FIELD(scan.plan.targetlist);
	WRITE_NODE_FIELD(scan.plan.qual);
	WRITE_NODE_FIELD(scan.plan.lefttree);
	WRITE_NODE_FIELD(scan.plan.righttree);
	WRITE_NODE_FIELD(scan.plan.initPlan);
	WRITE_BITMAPSET_FIELD(scan.plan.extParam);
	WRITE_BITMAPSET_FIELD(scan.plan.allParam);
	WRITE_UINT_FIELD(scan.scanrelid);
	WRITE_NODE_FIELD(bitmapqualorig);
}

static void
_outTidScan(StringInfo str, const TidScan *node)
{
	WRITE_NODE_TYPE("TIDSCAN");

	WRITE_FLOAT_FIELD(scan.plan.startup_cost);
	WRITE_FLOAT_FIELD(scan.plan.total_cost);
	WRITE_FLOAT_FIELD(scan.plan.plan_rows);
	WRITE_INT_FIELD(scan.plan.plan_width);
	WRITE_BOOL_FIELD(scan.plan.parallel_aware);
	WRITE_BOOL_FIELD(scan.plan.parallel_safe);
	WRITE_BOOL_FIELD(scan.plan.async_capable);
	WRITE_INT_FIELD(scan.plan.plan_node_id);
	WRITE_NODE_FIELD(scan.plan.targetlist);
	WRITE_NODE_FIELD(scan.plan.qual);
	WRITE_NODE_FIELD(scan.plan.lefttree);
	WRITE_NODE_FIELD(scan.plan.righttree);
	WRITE_NODE_FIELD(scan.plan.initPlan);
	WRITE_BITMAPSET_FIELD(scan.plan.extParam);
	WRITE_BITMAPSET_FIELD(scan.plan.allParam);
	WRITE_UINT_FIELD(scan.scanrelid);
	WRITE_NODE_FIELD(tidquals);
}

static void
_outTidRangeScan(StringInfo str, const TidRangeScan *node)
{
	WRITE_NODE_TYPE("TIDRANGESCAN");

	WRITE_FLOAT_FIELD(scan.plan.startup_cost);
	WRITE_FLOAT_FIELD(scan.plan.total_cost);
	WRITE_FLOAT_FIELD(scan.plan.plan_rows);
	WRITE_INT_FIELD(scan.plan.plan_width);
	WRITE_BOOL_FIELD(scan.plan.parallel_aware);
	WRITE_BOOL_FIELD(scan.plan.parallel_safe);
	WRITE_BOOL_FIELD(scan.plan.async_capable);
	WRITE_INT_FIELD(scan.plan.plan_node_id);
	WRITE_NODE_FIELD(scan.plan.targetlist);
	WRITE_NODE_FIELD(scan.plan.qual);
	WRITE_NODE_FIELD(scan.plan.lefttree);
	WRITE_NODE_FIELD(scan.plan.righttree);
	WRITE_NODE_FIELD(scan.plan.initPlan);
	WRITE_BITMAPSET_FIELD(scan.plan.extParam);
	WRITE_BITMAPSET_FIELD(scan.plan.allParam);
	WRITE_UINT_FIELD(scan.scanrelid);
	WRITE_NODE_FIELD(tidrangequals);
}

static void
_outSubqueryScan(StringInfo str, const SubqueryScan *node)
{
	WRITE_NODE_TYPE("SUBQUERYSCAN");

	WRITE_FLOAT_FIELD(scan.plan.startup_cost);
	WRITE_FLOAT_FIELD(scan.plan.total_cost);
	WRITE_FLOAT_FIELD(scan.plan.plan_rows);
	WRITE_INT_FIELD(scan.plan.plan_width);
	WRITE_BOOL_FIELD(scan.plan.parallel_aware);
	WRITE_BOOL_FIELD(scan.plan.parallel_safe);
	WRITE_BOOL_FIELD(scan.plan.async_capable);
	WRITE_INT_FIELD(scan.plan.plan_node_id);
	WRITE_NODE_FIELD(scan.plan.targetlist);
	WRITE_NODE_FIELD(scan.plan.qual);
	WRITE_NODE_FIELD(scan.plan.lefttree);
	WRITE_NODE_FIELD(scan.plan.righttree);
	WRITE_NODE_FIELD(scan.plan.initPlan);
	WRITE_BITMAPSET_FIELD(scan.plan.extParam);
	WRITE_BITMAPSET_FIELD(scan.plan.allParam);
	WRITE_UINT_FIELD(scan.scanrelid);
	WRITE_NODE_FIELD(subplan);
	WRITE_ENUM_FIELD(scanstatus, SubqueryScanStatus);
}

static void
_outFunctionScan(StringInfo str, const FunctionScan *node)
{
	WRITE_NODE_TYPE("FUNCTIONSCAN");

	WRITE_FLOAT_FIELD(scan.plan.startup_cost);
	WRITE_FLOAT_FIELD(scan.plan.total_cost);
	WRITE_FLOAT_FIELD(scan.plan.plan_rows);
	WRITE_INT_FIELD(scan.plan.plan_width);
	WRITE_BOOL_FIELD(scan.plan.parallel_aware);
	WRITE_BOOL_FIELD(scan.plan.parallel_safe);
	WRITE_BOOL_FIELD(scan.plan.async_capable);
	WRITE_INT_FIELD(scan.plan.plan_node_id);
	WRITE_NODE_FIELD(scan.plan.targetlist);
	WRITE_NODE_FIELD(scan.plan.qual);
	WRITE_NODE_FIELD(scan.plan.lefttree);
	WRITE_NODE_FIELD(scan.plan.righttree);
	WRITE_NODE_FIELD(scan.plan.initPlan);
	WRITE_BITMAPSET_FIELD(scan.plan.extParam);
	WRITE_BITMAPSET_FIELD(scan.plan.allParam);
	WRITE_UINT_FIELD(scan.scanrelid);
	WRITE_NODE_FIELD(functions);
	WRITE_BOOL_FIELD(funcordinality);
}

static void
_outValuesScan(StringInfo str, const ValuesScan *node)
{
	WRITE_NODE_TYPE("VALUESSCAN");

	WRITE_FLOAT_FIELD(scan.plan.startup_cost);
	WRITE_FLOAT_FIELD(scan.plan.total_cost);
	WRITE_FLOAT_FIELD(scan.plan.plan_rows);
	WRITE_INT_FIELD(scan.plan.plan_width);
	WRITE_BOOL_FIELD(scan.plan.parallel_aware);
	WRITE_BOOL_FIELD(scan.plan.parallel_safe);
	WRITE_BOOL_FIELD(scan.plan.async_capable);
	WRITE_INT_FIELD(scan.plan.plan_node_id);
	WRITE_NODE_FIELD(scan.plan.targetlist);
	WRITE_NODE_FIELD(scan.plan.qual);
	WRITE_NODE_FIELD(scan.plan.lefttree);
	WRITE_NODE_FIELD(scan.plan.righttree);
	WRITE_NODE_FIELD(scan.plan.initPlan);
	WRITE_BITMAPSET_FIELD(scan.plan.extParam);
	WRITE_BITMAPSET_FIELD(scan.plan.allParam);
	WRITE_UINT_FIELD(scan.scanrelid);
	WRITE_NODE_FIELD(values_lists);
}

static void
_outTableFuncScan(StringInfo str, const TableFuncScan *node)
{
	WRITE_NODE_TYPE("TABLEFUNCSCAN");

	WRITE_FLOAT_FIELD(scan.plan.startup_cost);
	WRITE_FLOAT_FIELD(scan.plan.total_cost);
	WRITE_FLOAT_FIELD(scan.plan.plan_rows);
	WRITE_INT_FIELD(scan.plan.plan_width);
	WRITE_BOOL_FIELD(scan.plan.parallel_aware);
	WRITE_BOOL_FIELD(scan.plan.parallel_safe);
	WRITE_BOOL_FIELD(scan.plan.async_capable);
	WRITE_INT_FIELD(scan.plan.plan_node_id);
	WRITE_NODE_FIELD(scan.plan.targetlist);
	WRITE_NODE_FIELD(scan.plan.qual);
	WRITE_NODE_FIELD(scan.plan.lefttree);
	WRITE_NODE_FIELD(scan.plan.righttree);
	WRITE_NODE_FIELD(scan.plan.initPlan);
	WRITE_BITMAPSET_FIELD(scan.plan.extParam);
	WRITE_BITMAPSET_FIELD(scan.plan.allParam);
	WRITE_UINT_FIELD(scan.scanrelid);
	WRITE_NODE_FIELD(tablefunc);
}

static void
_outCteScan(StringInfo str, const CteScan *node)
{
	WRITE_NODE_TYPE("CTESCAN");

	WRITE_FLOAT_FIELD(scan.plan.startup_cost);
	WRITE_FLOAT_FIELD(scan.plan.total_cost);
	WRITE_FLOAT_FIELD(scan.plan.plan_rows);
	WRITE_INT_FIELD(scan.plan.plan_width);
	WRITE_BOOL_FIELD(scan.plan.parallel_aware);
	WRITE_BOOL_FIELD(scan.plan.parallel_safe);
	WRITE_BOOL_FIELD(scan.plan.async_capable);
	WRITE_INT_FIELD(scan.plan.plan_node_id);
	WRITE_NODE_FIELD(scan.plan.targetlist);
	WRITE_NODE_FIELD(scan.plan.qual);
	WRITE_NODE_FIELD(scan.plan.lefttree);
	WRITE_NODE_FIELD(scan.plan.righttree);
	WRITE_NODE_FIELD(scan.plan.initPlan);
	WRITE_BITMAPSET_FIELD(scan.plan.extParam);
	WRITE_BITMAPSET_FIELD(scan.plan.allParam);
	WRITE_UINT_FIELD(scan.scanrelid);
	WRITE_INT_FIELD(ctePlanId);
	WRITE_INT_FIELD(cteParam);
}

static void
_outNamedTuplestoreScan(StringInfo str, const NamedTuplestoreScan *node)
{
	WRITE_NODE_TYPE("NAMEDTUPLESTORESCAN");

	WRITE_FLOAT_FIELD(scan.plan.startup_cost);
	WRITE_FLOAT_FIELD(scan.plan.total_cost);
	WRITE_FLOAT_FIELD(scan.plan.plan_rows);
	WRITE_INT_FIELD(scan.plan.plan_width);
	WRITE_BOOL_FIELD(scan.plan.parallel_aware);
	WRITE_BOOL_FIELD(scan.plan.parallel_safe);
	WRITE_BOOL_FIELD(scan.plan.async_capable);
	WRITE_INT_FIELD(scan.plan.plan_node_id);
	WRITE_NODE_FIELD(scan.plan.targetlist);
	WRITE_NODE_FIELD(scan.plan.qual);
	WRITE_NODE_FIELD(scan.plan.lefttree);
	WRITE_NODE_FIELD(scan.plan.righttree);
	WRITE_NODE_FIELD(scan.plan.initPlan);
	WRITE_BITMAPSET_FIELD(scan.plan.extParam);
	WRITE_BITMAPSET_FIELD(scan.plan.allParam);
	WRITE_UINT_FIELD(scan.scanrelid);
	WRITE_STRING_FIELD(enrname);
}

static void
_outWorkTableScan(StringInfo str, const WorkTableScan *node)
{
	WRITE_NODE_TYPE("WORKTABLESCAN");

	WRITE_FLOAT_FIELD(scan.plan.startup_cost);
	WRITE_FLOAT_FIELD(scan.plan.total_cost);
	WRITE_FLOAT_FIELD(scan.plan.plan_rows);
	WRITE_INT_FIELD(scan.plan.plan_width);
	WRITE_BOOL_FIELD(scan.plan.parallel_aware);
	WRITE_BOOL_FIELD(scan.plan.parallel_safe);
	WRITE_BOOL_FIELD(scan.plan.async_capable);
	WRITE_INT_FIELD(scan.plan.plan_node_id);
	WRITE_NODE_FIELD(scan.plan.targetlist);
	WRITE_NODE_FIELD(scan.plan.qual);
	WRITE_NODE_FIELD(scan.plan.lefttree);
	WRITE_NODE_FIELD(scan.plan.righttree);
	WRITE_NODE_FIELD(scan.plan.initPlan);
	WRITE_BITMAPSET_FIELD(scan.plan.extParam);
	WRITE_BITMAPSET_FIELD(scan.plan.allParam);
	WRITE_UINT_FIELD(scan.scanrelid);
	WRITE_INT_FIELD(wtParam);
}

static void
_outForeignScan(StringInfo str, const ForeignScan *node)
{
	WRITE_NODE_TYPE("FOREIGNSCAN");

	WRITE_FLOAT_FIELD(scan.plan.startup_cost);
	WRITE_FLOAT_FIELD(scan.plan.total_cost);
	WRITE_FLOAT_FIELD(scan.plan.plan_rows);
	WRITE_INT_FIELD(scan.plan.plan_width);
	WRITE_BOOL_FIELD(scan.plan.parallel_aware);
	WRITE_BOOL_FIELD(scan.plan.parallel_safe);
	WRITE_BOOL_FIELD(scan.plan.async_capable);
	WRITE_INT_FIELD(scan.plan.plan_node_id);
	WRITE_NODE_FIELD(scan.plan.targetlist);
	WRITE_NODE_FIELD(scan.plan.qual);
	WRITE_NODE_FIELD(scan.plan.lefttree);
	WRITE_NODE_FIELD(scan.plan.righttree);
	WRITE_NODE_FIELD(scan.plan.initPlan);
	WRITE_BITMAPSET_FIELD(scan.plan.extParam);
	WRITE_BITMAPSET_FIELD(scan.plan.allParam);
	WRITE_UINT_FIELD(scan.scanrelid);
	WRITE_ENUM_FIELD(operation, CmdType);
	WRITE_UINT_FIELD(resultRelation);
	WRITE_OID_FIELD(checkAsUser);
	WRITE_OID_FIELD(fs_server);
	WRITE_NODE_FIELD(fdw_exprs);
	WRITE_NODE_FIELD(fdw_private);
	WRITE_NODE_FIELD(fdw_scan_tlist);
	WRITE_NODE_FIELD(fdw_recheck_quals);
	WRITE_BITMAPSET_FIELD(fs_relids);
	WRITE_BITMAPSET_FIELD(fs_base_relids);
	WRITE_BOOL_FIELD(fsSystemCol);
}

static void
_outCustomScan(StringInfo str, const CustomScan *node)
{
	WRITE_NODE_TYPE("CUSTOMSCAN");

	WRITE_FLOAT_FIELD(scan.plan.startup_cost);
	WRITE_FLOAT_FIELD(scan.plan.total_cost);
	WRITE_FLOAT_FIELD(scan.plan.plan_rows);
	WRITE_INT_FIELD(scan.plan.plan_width);
	WRITE_BOOL_FIELD(scan.plan.parallel_aware);
	WRITE_BOOL_FIELD(scan.plan.parallel_safe);
	WRITE_BOOL_FIELD(scan.plan.async_capable);
	WRITE_INT_FIELD(scan.plan.plan_node_id);
	WRITE_NODE_FIELD(scan.plan.targetlist);
	WRITE_NODE_FIELD(scan.plan.qual);
	WRITE_NODE_FIELD(scan.plan.lefttree);
	WRITE_NODE_FIELD(scan.plan.righttree);
	WRITE_NODE_FIELD(scan.plan.initPlan);
	WRITE_BITMAPSET_FIELD(scan.plan.extParam);
	WRITE_BITMAPSET_FIELD(scan.plan.allParam);
	WRITE_UINT_FIELD(scan.scanrelid);
	WRITE_UINT_FIELD(flags);
	WRITE_NODE_FIELD(custom_plans);
	WRITE_NODE_FIELD(custom_exprs);
	WRITE_NODE_FIELD(custom_private);
	WRITE_NODE_FIELD(custom_scan_tlist);
	WRITE_BITMAPSET_FIELD(custom_relids);

	/* CustomName is a key to lookup CustomScanMethods */
	appendStringInfoString(str, " :methods ");
	outToken(str, node->methods->CustomName);
}

static void
_outNestLoop(StringInfo str, const NestLoop *node)
{
	WRITE_NODE_TYPE("NESTLOOP");

	WRITE_FLOAT_FIELD(join.plan.startup_cost);
	WRITE_FLOAT_FIELD(join.plan.total_cost);
	WRITE_FLOAT_FIELD(join.plan.plan_rows);
	WRITE_INT_FIELD(join.plan.plan_width);
	WRITE_BOOL_FIELD(join.plan.parallel_aware);
	WRITE_BOOL_FIELD(join.plan.parallel_safe);
	WRITE_BOOL_FIELD(join.plan.async_capable);
	WRITE_INT_FIELD(join.plan.plan_node_id);
	WRITE_NODE_FIELD(join.plan.targetlist);
	WRITE_NODE_FIELD(join.plan.qual);
	WRITE_NODE_FIELD(join.plan.lefttree);
	WRITE_NODE_FIELD(join.plan.righttree);
	WRITE_NODE_FIELD(join.plan.initPlan);
	WRITE_BITMAPSET_FIELD(join.plan.extParam);
	WRITE_BITMAPSET_FIELD(join.plan.allParam);
	WRITE_ENUM_FIELD(join.jointype, JoinType);
	WRITE_BOOL_FIELD(join.inner_unique);
	WRITE_NODE_FIELD(join.joinqual);
	WRITE_NODE_FIELD(nestParams);
}

static void
_outNestLoopParam(StringInfo str, const NestLoopParam *node)
{
	WRITE_NODE_TYPE("NESTLOOPPARAM");

	WRITE_INT_FIELD(paramno);
	WRITE_NODE_FIELD(paramval);
}

static void
_outMergeJoin(StringInfo str, const MergeJoin *node)
{
	WRITE_NODE_TYPE("MERGEJOIN");

	WRITE_FLOAT_FIELD(join.plan.startup_cost);
	WRITE_FLOAT_FIELD(join.plan.total_cost);
	WRITE_FLOAT_FIELD(join.plan.plan_rows);
	WRITE_INT_FIELD(join.plan.plan_width);
	WRITE_BOOL_FIELD(join.plan.parallel_aware);
	WRITE_BOOL_FIELD(join.plan.parallel_safe);
	WRITE_BOOL_FIELD(join.plan.async_capable);
	WRITE_INT_FIELD(join.plan.plan_node_id);
	WRITE_NODE_FIELD(join.plan.targetlist);
	WRITE_NODE_FIELD(join.plan.qual);
	WRITE_NODE_FIELD(join.plan.lefttree);
	WRITE_NODE_FIELD(join.plan.righttree);
	WRITE_NODE_FIELD(join.plan.initPlan);
	WRITE_BITMAPSET_FIELD(join.plan.extParam);
	WRITE_BITMAPSET_FIELD(join.plan.allParam);
	WRITE_ENUM_FIELD(join.jointype, JoinType);
	WRITE_BOOL_FIELD(join.inner_unique);
	WRITE_NODE_FIELD(join.joinqual);
	WRITE_BOOL_FIELD(skip_mark_restore);
	WRITE_NODE_FIELD(mergeclauses);
	WRITE_OID_ARRAY(mergeFamilies, list_length(node->mergeclauses));
	WRITE_OID_ARRAY(mergeCollations, list_length(node->mergeclauses));
	WRITE_INT_ARRAY(mergeStrategies, list_length(node->mergeclauses));
	WRITE_BOOL_ARRAY(mergeNullsFirst, list_length(node->mergeclauses));
}

static void
_outHashJoin(StringInfo str, const HashJoin *node)
{
	WRITE_NODE_TYPE("HASHJOIN");

	WRITE_FLOAT_FIELD(join.plan.startup_cost);
	WRITE_FLOAT_FIELD(join.plan.total_cost);
	WRITE_FLOAT_FIELD(join.plan.plan_rows);
	WRITE_INT_FIELD(join.plan.plan_width);
	WRITE_BOOL_FIELD(join.plan.parallel_aware);
	WRITE_BOOL_FIELD(join.plan.parallel_safe);
	WRITE_BOOL_FIELD(join.plan.async_capable);
	WRITE_INT_FIELD(join.plan.plan_node_id);
	WRITE_NODE_FIELD(join.plan.targetlist);
	WRITE_NODE_FIELD(join.plan.qual);
	WRITE_NODE_FIELD(join.plan.lefttree);
	WRITE_NODE_FIELD(join.plan.righttree);
	WRITE_NODE_FIELD(join.plan.initPlan);
	WRITE_BITMAPSET_FIELD(join.plan.extParam);
	WRITE_BITMAPSET_FIELD(join.plan.allParam);
	WRITE_ENUM_FIELD(join.jointype, JoinType);
	WRITE_BOOL_FIELD(join.inner_unique);
	WRITE_NODE_FIELD(join.joinqual);
	WRITE_NODE_FIELD(hashclauses);
	WRITE_NODE_FIELD(hashoperators);
	WRITE_NODE_FIELD(hashcollations);
	WRITE_NODE_FIELD(hashkeys);
}

static void
_outMaterial(StringInfo str, const Material *node)
{
	WRITE_NODE_TYPE("MATERIAL");

	WRITE_FLOAT_FIELD(plan.startup_cost);
	WRITE_FLOAT_FIELD(plan.total_cost);
	WRITE_FLOAT_FIELD(plan.plan_rows);
	WRITE_INT_FIELD(plan.plan_width);
	WRITE_BOOL_FIELD(plan.parallel_aware);
	WRITE_BOOL_FIELD(plan.parallel_safe);
	WRITE_BOOL_FIELD(plan.async_capable);
	WRITE_INT_FIELD(plan.plan_node_id);
	WRITE_NODE_FIELD(plan.targetlist);
	WRITE_NODE_FIELD(plan.qual);
	WRITE_NODE_FIELD(plan.lefttree);
	WRITE_NODE_FIELD(plan.righttree);
	WRITE_NODE_FIELD(plan.initPlan);
	WRITE_BITMAPSET_FIELD(plan.extParam);
	WRITE_BITMAPSET_FIELD(plan.allParam);
}

static void
_outMemoize(StringInfo str, const Memoize *node)
{
	WRITE_NODE_TYPE("MEMOIZE");

	WRITE_FLOAT_FIELD(plan.startup_cost);
	WRITE_FLOAT_FIELD(plan.total_cost);
	WRITE_FLOAT_FIELD(plan.plan_rows);
	WRITE_INT_FIELD(plan.plan_width);
	WRITE_BOOL_FIELD(plan.parallel_aware);
	WRITE_BOOL_FIELD(plan.parallel_safe);
	WRITE_BOOL_FIELD(plan.async_capable);
	WRITE_INT_FIELD(plan.plan_node_id);
	WRITE_NODE_FIELD(plan.targetlist);
	WRITE_NODE_FIELD(plan.qual);
	WRITE_NODE_FIELD(plan.lefttree);
	WRITE_NODE_FIELD(plan.righttree);
	WRITE_NODE_FIELD(plan.initPlan);
	WRITE_BITMAPSET_FIELD(plan.extParam);
	WRITE_BITMAPSET_FIELD(plan.allParam);
	WRITE_INT_FIELD(numKeys);
	WRITE_OID_ARRAY(hashOperators, node->numKeys);
	WRITE_OID_ARRAY(collations, node->numKeys);
	WRITE_NODE_FIELD(param_exprs);
	WRITE_BOOL_FIELD(singlerow);
	WRITE_BOOL_FIELD(binary_mode);
	WRITE_UINT_FIELD(est_entries);
	WRITE_BITMAPSET_FIELD(keyparamids);
}

static void
_outSort(StringInfo str, const Sort *node)
{
	WRITE_NODE_TYPE("SORT");

	WRITE_FLOAT_FIELD(plan.startup_cost);
	WRITE_FLOAT_FIELD(plan.total_cost);
	WRITE_FLOAT_FIELD(plan.plan_rows);
	WRITE_INT_FIELD(plan.plan_width);
	WRITE_BOOL_FIELD(plan.parallel_aware);
	WRITE_BOOL_FIELD(plan.parallel_safe);
	WRITE_BOOL_FIELD(plan.async_capable);
	WRITE_INT_FIELD(plan.plan_node_id);
	WRITE_NODE_FIELD(plan.targetlist);
	WRITE_NODE_FIELD(plan.qual);
	WRITE_NODE_FIELD(plan.lefttree);
	WRITE_NODE_FIELD(plan.righttree);
	WRITE_NODE_FIELD(plan.initPlan);
	WRITE_BITMAPSET_FIELD(plan.extParam);
	WRITE_BITMAPSET_FIELD(plan.allParam);
	WRITE_INT_FIELD(numCols);
	WRITE_ATTRNUMBER_ARRAY(sortColIdx, node->numCols);
	WRITE_OID_ARRAY(sortOperators, node->numCols);
	WRITE_OID_ARRAY(collations, node->numCols);
	WRITE_BOOL_ARRAY(nullsFirst, node->numCols);
}

static void
_outIncrementalSort(StringInfo str, const IncrementalSort *node)
{
	WRITE_NODE_TYPE("INCREMENTALSORT");

	WRITE_FLOAT_FIELD(sort.plan.startup_cost);
	WRITE_FLOAT_FIELD(sort.plan.total_cost);
	WRITE_FLOAT_FIELD(sort.plan.plan_rows);
	WRITE_INT_FIELD(sort.plan.plan_width);
	WRITE_BOOL_FIELD(sort.plan.parallel_aware);
	WRITE_BOOL_FIELD(sort.plan.parallel_safe);
	WRITE_BOOL_FIELD(sort.plan.async_capable);
	WRITE_INT_FIELD(sort.plan.plan_node_id);
	WRITE_NODE_FIELD(sort.plan.targetlist);
	WRITE_NODE_FIELD(sort.plan.qual);
	WRITE_NODE_FIELD(sort.plan.lefttree);
	WRITE_NODE_FIELD(sort.plan.righttree);
	WRITE_NODE_FIELD(sort.plan.initPlan);
	WRITE_BITMAPSET_FIELD(sort.plan.extParam);
	WRITE_BITMAPSET_FIELD(sort.plan.allParam);
	WRITE_INT_FIELD(sort.numCols);
	WRITE_ATTRNUMBER_ARRAY(sort.sortColIdx, node->sort.numCols);
	WRITE_OID_ARRAY(sort.sortOperators, node->sort.numCols);
	WRITE_OID_ARRAY(sort.collations, node->sort.numCols);
	WRITE_BOOL_ARRAY(sort.nullsFirst, node->sort.numCols);
	WRITE_INT_FIELD(nPresortedCols);
}

static void
_outGroup(StringInfo str, const Group *node)
{
	WRITE_NODE_TYPE("GROUP");

	WRITE_FLOAT_FIELD(plan.startup_cost);
	WRITE_FLOAT_FIELD(plan.total_cost);
	WRITE_FLOAT_FIELD(plan.plan_rows);
	WRITE_INT_FIELD(plan.plan_width);
	WRITE_BOOL_FIELD(plan.parallel_aware);
	WRITE_BOOL_FIELD(plan.parallel_safe);
	WRITE_BOOL_FIELD(plan.async_capable);
	WRITE_INT_FIELD(plan.plan_node_id);
	WRITE_NODE_FIELD(plan.targetlist);
	WRITE_NODE_FIELD(plan.qual);
	WRITE_NODE_FIELD(plan.lefttree);
	WRITE_NODE_FIELD(plan.righttree);
	WRITE_NODE_FIELD(plan.initPlan);
	WRITE_BITMAPSET_FIELD(plan.extParam);
	WRITE_BITMAPSET_FIELD(plan.allParam);
	WRITE_INT_FIELD(numCols);
	WRITE_ATTRNUMBER_ARRAY(grpColIdx, node->numCols);
	WRITE_OID_ARRAY(grpOperators, node->numCols);
	WRITE_OID_ARRAY(grpCollations, node->numCols);
}

static void
_outAgg(StringInfo str, const Agg *node)
{
	WRITE_NODE_TYPE("AGG");

	WRITE_FLOAT_FIELD(plan.startup_cost);
	WRITE_FLOAT_FIELD(plan.total_cost);
	WRITE_FLOAT_FIELD(plan.plan_rows);
	WRITE_INT_FIELD(plan.plan_width);
	WRITE_BOOL_FIELD(plan.parallel_aware);
	WRITE_BOOL_FIELD(plan.parallel_safe);
	WRITE_BOOL_FIELD(plan.async_capable);
	WRITE_INT_FIELD(plan.plan_node_id);
	WRITE_NODE_FIELD(plan.targetlist);
	WRITE_NODE_FIELD(plan.qual);
	WRITE_NODE_FIELD(plan.lefttree);
	WRITE_NODE_FIELD(plan.righttree);
	WRITE_NODE_FIELD(plan.initPlan);
	WRITE_BITMAPSET_FIELD(plan.extParam);
	WRITE_BITMAPSET_FIELD(plan.allParam);
	WRITE_ENUM_FIELD(aggstrategy, AggStrategy);
	WRITE_ENUM_FIELD(aggsplit, AggSplit);
	WRITE_INT_FIELD(numCols);
	WRITE_ATTRNUMBER_ARRAY(grpColIdx, node->numCols);
	WRITE_OID_ARRAY(grpOperators, node->numCols);
	WRITE_OID_ARRAY(grpCollations, node->numCols);
	WRITE_LONG_FIELD(numGroups);
	WRITE_UINT64_FIELD(transitionSpace);
	WRITE_BITMAPSET_FIELD(aggParams);
	WRITE_NODE_FIELD(groupingSets);
	WRITE_NODE_FIELD(chain);
}

static void
_outWindowAgg(StringInfo str, const WindowAgg *node)
{
	WRITE_NODE_TYPE("WINDOWAGG");

	WRITE_FLOAT_FIELD(plan.startup_cost);
	WRITE_FLOAT_FIELD(plan.total_cost);
	WRITE_FLOAT_FIELD(plan.plan_rows);
	WRITE_INT_FIELD(plan.plan_width);
	WRITE_BOOL_FIELD(plan.parallel_aware);
	WRITE_BOOL_FIELD(plan.parallel_safe);
	WRITE_BOOL_FIELD(plan.async_capable);
	WRITE_INT_FIELD(plan.plan_node_id);
	WRITE_NODE_FIELD(plan.targetlist);
	WRITE_NODE_FIELD(plan.qual);
	WRITE_NODE_FIELD(plan.lefttree);
	WRITE_NODE_FIELD(plan.righttree);
	WRITE_NODE_FIELD(plan.initPlan);
	WRITE_BITMAPSET_FIELD(plan.extParam);
	WRITE_BITMAPSET_FIELD(plan.allParam);
	WRITE_UINT_FIELD(winref);
	WRITE_INT_FIELD(partNumCols);
	WRITE_ATTRNUMBER_ARRAY(partColIdx, node->partNumCols);
	WRITE_OID_ARRAY(partOperators, node->partNumCols);
	WRITE_OID_ARRAY(partCollations, node->partNumCols);
	WRITE_INT_FIELD(ordNumCols);
	WRITE_ATTRNUMBER_ARRAY(ordColIdx, node->ordNumCols);
	WRITE_OID_ARRAY(ordOperators, node->ordNumCols);
	WRITE_OID_ARRAY(ordCollations, node->ordNumCols);
	WRITE_INT_FIELD(frameOptions);
	WRITE_NODE_FIELD(startOffset);
	WRITE_NODE_FIELD(endOffset);
	WRITE_NODE_FIELD(runCondition);
	WRITE_NODE_FIELD(runConditionOrig);
	WRITE_OID_FIELD(startInRangeFunc);
	WRITE_OID_FIELD(endInRangeFunc);
	WRITE_OID_FIELD(inRangeColl);
	WRITE_BOOL_FIELD(inRangeAsc);
	WRITE_BOOL_FIELD(inRangeNullsFirst);
	WRITE_BOOL_FIELD(topWindow);
}

static void
_outUnique(StringInfo str, const Unique *node)
{
	WRITE_NODE_TYPE("UNIQUE");

	WRITE_FLOAT_FIELD(plan.startup_cost);
	WRITE_FLOAT_FIELD(plan.total_cost);
	WRITE_FLOAT_FIELD(plan.plan_rows);
	WRITE_INT_FIELD(plan.plan_width);
	WRITE_BOOL_FIELD(plan.parallel_aware);
	WRITE_BOOL_FIELD(plan.parallel_safe);
	WRITE_BOOL_FIELD(plan.async_capable);
	WRITE_INT_FIELD(plan.plan_node_id);
	WRITE_NODE_FIELD(plan.targetlist);
	WRITE_NODE_FIELD(plan.qual);
	WRITE_NODE_FIELD(plan.lefttree);
	WRITE_NODE_FIELD(plan.righttree);
	WRITE_NODE_FIELD(plan.initPlan);
	WRITE_BITMAPSET_FIELD(plan.extParam);
	WRITE_BITMAPSET_FIELD(plan.allParam);
	WRITE_INT_FIELD(numCols);
	WRITE_ATTRNUMBER_ARRAY(uniqColIdx, node->numCols);
	WRITE_OID_ARRAY(uniqOperators, node->numCols);
	WRITE_OID_ARRAY(uniqCollations, node->numCols);
}

static void
_outGather(StringInfo str, const Gather *node)
{
	WRITE_NODE_TYPE("GATHER");

	WRITE_FLOAT_FIELD(plan.startup_cost);
	WRITE_FLOAT_FIELD(plan.total_cost);
	WRITE_FLOAT_FIELD(plan.plan_rows);
	WRITE_INT_FIELD(plan.plan_width);
	WRITE_BOOL_FIELD(plan.parallel_aware);
	WRITE_BOOL_FIELD(plan.parallel_safe);
	WRITE_BOOL_FIELD(plan.async_capable);
	WRITE_INT_FIELD(plan.plan_node_id);
	WRITE_NODE_FIELD(plan.targetlist);
	WRITE_NODE_FIELD(plan.qual);
	WRITE_NODE_FIELD(plan.lefttree);
	WRITE_NODE_FIELD(plan.righttree);
	WRITE_NODE_FIELD(plan.initPlan);
	WRITE_BITMAPSET_FIELD(plan.extParam);
	WRITE_BITMAPSET_FIELD(plan.allParam);
	WRITE_INT_FIELD(num_workers);
	WRITE_INT_FIELD(rescan_param);
	WRITE_BOOL_FIELD(single_copy);
	WRITE_BOOL_FIELD(invisible);
	WRITE_BITMAPSET_FIELD(initParam);
}

static void
_outGatherMerge(StringInfo str, const GatherMerge *node)
{
	WRITE_NODE_TYPE("GATHERMERGE");

	WRITE_FLOAT_FIELD(plan.startup_cost);
	WRITE_FLOAT_FIELD(plan.total_cost);
	WRITE_FLOAT_FIELD(plan.plan_rows);
	WRITE_INT_FIELD(plan.plan_width);
	WRITE_BOOL_FIELD(plan.parallel_aware);
	WRITE_BOOL_FIELD(plan.parallel_safe);
	WRITE_BOOL_FIELD(plan.async_capable);
	WRITE_INT_FIELD(plan.plan_node_id);
	WRITE_NODE_FIELD(plan.targetlist);
	WRITE_NODE_FIELD(plan.qual);
	WRITE_NODE_FIELD(plan.lefttree);
	WRITE_NODE_FIELD(plan.righttree);
	WRITE_NODE_FIELD(plan.initPlan);
	WRITE_BITMAPSET_FIELD(plan.extParam);
	WRITE_BITMAPSET_FIELD(plan.allParam);
	WRITE_INT_FIELD(num_workers);
	WRITE_INT_FIELD(rescan_param);
	WRITE_INT_FIELD(numCols);
	WRITE_ATTRNUMBER_ARRAY(sortColIdx, node->numCols);
	WRITE_OID_ARRAY(sortOperators, node->numCols);
	WRITE_OID_ARRAY(collations, node->numCols);
	WRITE_BOOL_ARRAY(nullsFirst, node->numCols);
	WRITE_BITMAPSET_FIELD(initParam);
}

static void
_outHash(StringInfo str, const Hash *node)
{
	WRITE_NODE_TYPE("HASH");

	WRITE_FLOAT_FIELD(plan.startup_cost);
	WRITE_FLOAT_FIELD(plan.total_cost);
	WRITE_FLOAT_FIELD(plan.plan_rows);
	WRITE_INT_FIELD(plan.plan_width);
	WRITE_BOOL_FIELD(plan.parallel_aware);
	WRITE_BOOL_FIELD(plan.parallel_safe);
	WRITE_BOOL_FIELD(plan.async_capable);
	WRITE_INT_FIELD(plan.plan_node_id);
	WRITE_NODE_FIELD(plan.targetlist);
	WRITE_NODE_FIELD(plan.qual);
	WRITE_NODE_FIELD(plan.lefttree);
	WRITE_NODE_FIELD(plan.righttree);
	WRITE_NODE_FIELD(plan.initPlan);
	WRITE_BITMAPSET_FIELD(plan.extParam);
	WRITE_BITMAPSET_FIELD(plan.allParam);
	WRITE_NODE_FIELD(hashkeys);
	WRITE_OID_FIELD(skewTable);
	WRITE_INT_FIELD(skewColumn);
	WRITE_BOOL_FIELD(skewInherit);
	WRITE_FLOAT_FIELD(rows_total);
}

static void
_outSetOp(StringInfo str, const SetOp *node)
{
	WRITE_NODE_TYPE("SETOP");

	WRITE_FLOAT_FIELD(plan.startup_cost);
	WRITE_FLOAT_FIELD(plan.total_cost);
	WRITE_FLOAT_FIELD(plan.plan_rows);
	WRITE_INT_FIELD(plan.plan_width);
	WRITE_BOOL_FIELD(plan.parallel_aware);
	WRITE_BOOL_FIELD(plan.parallel_safe);
	WRITE_BOOL_FIELD(plan.async_capable);
	WRITE_INT_FIELD(plan.plan_node_id);
	WRITE_NODE_FIELD(plan.targetlist);
	WRITE_NODE_FIELD(plan.qual);
	WRITE_NODE_FIELD(plan.lefttree);
	WRITE_NODE_FIELD(plan.righttree);
	WRITE_NODE_FIELD(plan.initPlan);
	WRITE_BITMAPSET_FIELD(plan.extParam);
	WRITE_BITMAPSET_FIELD(plan.allParam);
	WRITE_ENUM_FIELD(cmd, SetOpCmd);
	WRITE_ENUM_FIELD(strategy, SetOpStrategy);
	WRITE_INT_FIELD(numCols);
	WRITE_ATTRNUMBER_ARRAY(dupColIdx, node->numCols);
	WRITE_OID_ARRAY(dupOperators, node->numCols);
	WRITE_OID_ARRAY(dupCollations, node->numCols);
	WRITE_INT_FIELD(flagColIdx);
	WRITE_INT_FIELD(firstFlag);
	WRITE_LONG_FIELD(numGroups);
}

static void
_outLockRows(StringInfo str, const LockRows *node)
{
	WRITE_NODE_TYPE("LOCKROWS");

	WRITE_FLOAT_FIELD(plan.startup_cost);
	WRITE_FLOAT_FIELD(plan.total_cost);
	WRITE_FLOAT_FIELD(plan.plan_rows);
	WRITE_INT_FIELD(plan.plan_width);
	WRITE_BOOL_FIELD(plan.parallel_aware);
	WRITE_BOOL_FIELD(plan.parallel_safe);
	WRITE_BOOL_FIELD(plan.async_capable);
	WRITE_INT_FIELD(plan.plan_node_id);
	WRITE_NODE_FIELD(plan.targetlist);
	WRITE_NODE_FIELD(plan.qual);
	WRITE_NODE_FIELD(plan.lefttree);
	WRITE_NODE_FIELD(plan.righttree);
	WRITE_NODE_FIELD(plan.initPlan);
	WRITE_BITMAPSET_FIELD(plan.extParam);
	WRITE_BITMAPSET_FIELD(plan.allParam);
	WRITE_NODE_FIELD(rowMarks);
	WRITE_INT_FIELD(epqParam);
}

static void
_outLimit(StringInfo str, const Limit *node)
{
	WRITE_NODE_TYPE("LIMIT");

	WRITE_FLOAT_FIELD(plan.startup_cost);
	WRITE_FLOAT_FIELD(plan.total_cost);
	WRITE_FLOAT_FIELD(plan.plan_rows);
	WRITE_INT_FIELD(plan.plan_width);
	WRITE_BOOL_FIELD(plan.parallel_aware);
	WRITE_BOOL_FIELD(plan.parallel_safe);
	WRITE_BOOL_FIELD(plan.async_capable);
	WRITE_INT_FIELD(plan.plan_node_id);
	WRITE_NODE_FIELD(plan.targetlist);
	WRITE_NODE_FIELD(plan.qual);
	WRITE_NODE_FIELD(plan.lefttree);
	WRITE_NODE_FIELD(plan.righttree);
	WRITE_NODE_FIELD(plan.initPlan);
	WRITE_BITMAPSET_FIELD(plan.extParam);
	WRITE_BITMAPSET_FIELD(plan.allParam);
	WRITE_NODE_FIELD(limitOffset);
	WRITE_NODE_FIELD(limitCount);
	WRITE_ENUM_FIELD(limitOption, LimitOption);
	WRITE_INT_FIELD(uniqNumCols);
	WRITE_ATTRNUMBER_ARRAY(uniqColIdx, node->uniqNumCols);
	WRITE_OID_ARRAY(uniqOperators, node->uniqNumCols);
	WRITE_OID_ARRAY(uniqCollations, node->uniqNumCols);
}

static void
_outPlanRowMark(StringInfo str, const PlanRowMark *node)
{
	WRITE_NODE_TYPE("PLANROWMARK");

	WRITE_UINT_FIELD(rti);
	WRITE_UINT_FIELD(prti);
	WRITE_UINT_FIELD(rowmarkId);
	WRITE_ENUM_FIELD(markType, RowMarkType);
	WRITE_INT_FIELD(allMarkTypes);
	WRITE_ENUM_FIELD(strength, LockClauseStrength);
	WRITE_ENUM_FIELD(waitPolicy, LockWaitPolicy);
	WRITE_BOOL_FIELD(isParent);
}

static void
_outPartitionPruneInfo(StringInfo str, const PartitionPruneInfo *node)
{
	WRITE_NODE_TYPE("PARTITIONPRUNEINFO");

	WRITE_NODE_FIELD(prune_infos);
	WRITE_BITMAPSET_FIELD(other_subplans);
}

static void
_outPartitionedRelPruneInfo(StringInfo str, const PartitionedRelPruneInfo *node)
{
	WRITE_NODE_TYPE("PARTITIONEDRELPRUNEINFO");

	WRITE_UINT_FIELD(rtindex);
	WRITE_BITMAPSET_FIELD(present_parts);
	WRITE_INT_FIELD(nparts);
	WRITE_INT_ARRAY(subplan_map, node->nparts);
	WRITE_INT_ARRAY(subpart_map, node->nparts);
	WRITE_OID_ARRAY(relid_map, node->nparts);
	WRITE_NODE_FIELD(initial_pruning_steps);
	WRITE_NODE_FIELD(exec_pruning_steps);
	WRITE_BITMAPSET_FIELD(execparamids);
}

static void
_outPartitionPruneStepOp(StringInfo str, const PartitionPruneStepOp *node)
{
	WRITE_NODE_TYPE("PARTITIONPRUNESTEPOP");

	WRITE_INT_FIELD(step.step_id);
	WRITE_INT_FIELD(opstrategy);
	WRITE_NODE_FIELD(exprs);
	WRITE_NODE_FIELD(cmpfns);
	WRITE_BITMAPSET_FIELD(nullkeys);
}

static void
_outPartitionPruneStepCombine(StringInfo str, const PartitionPruneStepCombine *node)
{
	WRITE_NODE_TYPE("PARTITIONPRUNESTEPCOMBINE");

	WRITE_INT_FIELD(step.step_id);
	WRITE_ENUM_FIELD(combineOp, PartitionPruneCombineOp);
	WRITE_NODE_FIELD(source_stepids);
}

static void
_outPlanInvalItem(StringInfo str, const PlanInvalItem *node)
{
	WRITE_NODE_TYPE("PLANINVALITEM");

	WRITE_INT_FIELD(cacheId);
	WRITE_UINT_FIELD(hashValue);
}

static void
_outForeignKeyCacheInfo(StringInfo str, const ForeignKeyCacheInfo *node)
{
	WRITE_NODE_TYPE("FOREIGNKEYCACHEINFO");

	WRITE_OID_FIELD(conoid);
	WRITE_OID_FIELD(conrelid);
	WRITE_OID_FIELD(confrelid);
	WRITE_INT_FIELD(nkeys);
	WRITE_ATTRNUMBER_ARRAY(conkey, node->nkeys);
	WRITE_ATTRNUMBER_ARRAY(confkey, node->nkeys);
	WRITE_OID_ARRAY(conpfeqop, node->nkeys);
}
