@q file: testout_comments.w@>
@q%   Copyright Dave Bone 1998 - 2015@>
@q% /*@>
@q%    This Source Code Form is subject to the terms of the Mozilla Public@>
@q%    License, v. 2.0. If a copy of the MPL was not distributed with this@>
@q%    file, You can obtain one at http://mozilla.org/MPL/2.0/.@>
@q% */@>

@** Comments.\fbreak
There are 3 principle reasons for this program:\fbreak
\ptindent{1) To verify that \O2{} parses a lr(1) grammar, and its parse tables accepts  the language expessed}
\ptindent{2) To give a glimpse into what the compiler writer ``will do'' in creating a translator/compiler}
\ptindent{3) An example for your own learning}
This ``will do'' activity prepares the Terminal vocabulary, and shows
a simple way to fetch the input file to parse, and use the built in ``error reporting''
facilities within your own compiler/translator context.
\fbreak

The development cycle one needs to create a compiler/translator is:\fbreak
\ptindent{1) write/compile your grammar(s) using \O2}
\ptindent{2) using an editor, create your compiler's fsc file for \O2linker's consumption}
\ptindent{3) write/compile your compiler and any other external functions}
\ptindent{4) link your compiler/translator}
Have a look at {\bf{\Whereyacco2/grammar-testsuite/makefile\_testout\_APPLE}} bash script 
detailing the documentation generation and compiling/linking activities.
This example is in ``literate programming'' genre and u can read the ``testout*.w'' files. 
If u prefer or u do not have \Cweb{} installed, u can write raw \Cpp code instead.
The gened \Cpp{}  files *.h and *.cpp are also in {\bf{../grammar-testsuite}}
to model from.
\fbreak

The grammar used is from David Pager --- ``The Lane Table Method Of Constructing LR(1) Parsers''
discussing lr(1) resolution page 61.
To testout pager\_1.lex grammar, u can input one of the following files to {\it{testout}}:\fbreak
\ptindent{1) ./grammar-testsuite/testout\_1.dat}
\ptindent{2) ./grammar-testsuite/testout\_2.dat}
\ptindent{3) x --- no file}
\ptindent{4) ./grammar-testsuite/testout\_error.dat}
An example of running the program:\fbreak
\ptindent{{\bf {cd \Whereyacco2/yacco2/grammar-testsuite}}}
\ptindent{{\bf {./testout testout\_1.dat}}}
Various \Yacco2 tracings are turned on to demo their activity.
Please read wlibrary's pdf document for more details on their 
capabilities and meaning or ``o2book.pdf'' reference manual.
Added to the tracing are file/line number source coordinates.
At least u can go back to \Yacco2's library
code when things need adjusting.
``{\bf {1lrtracings.log}}'' contains the dynamic tracings when running the program.\fbreak
\fbreak
General routines to get things going:\fbreak
\ptindent{1) get file-to-parse and put into holding file}
\ptindent{2) parse the command line containing the file to parse}
\ptindent{3) use pager\_1 grammar to parse input file's contents}
@<accrue testout code@>+=
@<Include files@>;

