/*
  Copyright Dave Bone 1998 - 2014 
  All Rights Reserved. 
  No part of this document may be reproduced without written consent from the author.
	
FILE:		  parallel_parser_phrase.lex
Dates:		  15 Mar 2004
Purpose:	  parse parallel-parser construct
              Monolithic grammar that launches its thread.
              Properly handles threads and errors. Starts
              from a procedure using another parser's
              token stream from a specific point.
Note: Use of ||| |?| phrase to catch other returned terminals 
      or errors. In this case, it is errors. 
      One can be selective within various contexts:
         1) within arbitration
         2) sub-rule level
      The symbol's enumerated id is the fodder to filter on.
*/
/@
@i "/usr/local/yacco2/copyright.w"
@** |parallel_parser_phrase| grammar.\fbreak
Dispatcher to parse the parallel-parser construct:
lookahead expression and the grammr's thread identity.
@/
fsm	
(fsm-id "parallel_parser_phrase.lex"
,fsm-filename parallel_parser_phrase
,fsm-namespace NS_parallel_parser_phrase
,fsm-class Cparallel_parser_phrase{
  user-prefix-declaration
    using namespace NS_yacco2_terminals;
    #include "parallel_parser_ph_th.h"
    #include "o2_externs.h"
  ***
  user-declaration
   public: yacco2::AST* cweb_marker__;
  ***
  constructor
   cweb_marker__ = 0;
  ***
  op
   if(CWEB_MARKER != 0){
     cweb_marker__ = CWEB_MARKER;
     CWEB_MARKER=0;
   }
  ***
}
,fsm-version "1.0",fsm-date "15 mar 2004",fsm-debug "false"
,fsm-comments "Dispather to parse grammar's ``parallel-parser'' construct.")
@"/usr/local/yacco2/compiler/grammars/yacco2_T_includes.T"
rules{
Rparallel_parser_phrase (){
  -> Rphrase
}

Rphrase (){
  ->  ||| "parallel-parser-phrase" 
      NS_parallel_parser_ph_th::TH_parallel_parser_ph_th {
  op
    ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
  ***
  } 
  ->  ||| |?| NULL { 
  op
    ADD_TOKEN_TO_ERROR_QUEUE(*sf->p2__);
  ***
  }
  ->  |?| { 
  op
    CAbs_lr1_sym* sym = new Err_no_open_parenthesis;
    sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
    ADD_TOKEN_TO_ERROR_QUEUE(*sym);
  ***
  }
}
}// end of rules
