/*
 File: linker_preamble_code.cpp
 Date and Time: Fri Jan 30 18:55:15 2015 
*/
#include "linker_preamble_code.h"
using namespace NS_yacco2_T_enum;// enumerate
using namespace NS_yacco2_err_symbols;// error symbols
using namespace NS_yacco2_k_symbols;// lrk 
using namespace NS_yacco2_terminals;// terminals
using namespace NS_yacco2_characters;// rc 
using namespace yacco2;// yacco2 library
using namespace NS_linker_preamble_code;// grammar's ns
// first set terminals
fsm_rules_reuse_table_type::fsm_rules_reuse_table_type(){
 no_rules_entries_ = 3;
 per_rule_s_table_[0] =  new Per_rule_s_reuse_table();
 per_rule_s_table_[1] =  new Per_rule_s_reuse_table();
 per_rule_s_table_[2] =  new Per_rule_s_reuse_table();
}
  Clinker_preamble_code::
  Clinker_preamble_code()
    :yacco2::CAbs_fsm
      ("linker_preamble_code.lex"
      ,"1.0"
      ,"30 dec 2002"
      ,false
      ,"\\olinker's lexer of preamble code section:\n similar to Pass3 lexer."
      ,"Fri Jan 30 18:55:15 2015 "
      ,S1_Clinker_preamble_code){
    
    empty_sdc_ = true;
    chrs_.clear();
  
  }
 
Clinker_preamble_code::~Clinker_preamble_code(){

  for(int x = 0;x < 3;++x){
   ///delete fsm_rules_reuse_table.per_rule_s_table_[x];
  }
} 

  bool Clinker_preamble_code::failed(){
      return false;
  }
  void Clinker_preamble_code::op(){
    parser__->set_use_all_shift_on();
    empty_sdc_ = true;
    chrs_.clear();
    CAbs_lr1_sym* sym = parser__->start_token__;
	switch (sym->enumerated_id__){
	  
	  case T_Enum::T_LR1_eog_: break;
	  default: return;		
    }
    parser__->set_use_all_shift_off();
  
}
int Clinker_preamble_code::rhs_to_rules_mapping_[11] = {
 -1
 ,0 // subrule 1 for rule 1
 ,1 // subrule 2 for rule 2
 ,1 // subrule 3 for rule 2
 ,2 // subrule 4 for rule 3
 ,2 // subrule 5 for rule 3
 ,2 // subrule 6 for rule 3
 ,2 // subrule 7 for rule 3
 ,2 // subrule 8 for rule 3
 ,2 // subrule 9 for rule 3
 ,2 // subrule 10 for rule 3
}; 
Rlinker_preamble_code::Rlinker_preamble_code(yacco2::Parser* P)
 :CAbs_lr1_sym
  ("Rlinker_preamble_code",0,Clinker_preamble_code::R_Rlinker_preamble_code_,P,false,false){
}

void Rlinker_preamble_code::op(){
  sstrace_rulesss
 
    Clinker_preamble_code* fsm = (Clinker_preamble_code*)rule_info__.parser__->fsm_tbl__;
    CAbs_lr1_sym* sym(0);
    if(fsm->empty_sdc_ == true){
      sym = new Err_preamble_srce_code_not_present;
      sym->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
      RSVP(sym);
      rule_info__.parser__->set_stop_parse(true);
      return;
    }
    sym = new T_syntax_code(fsm->chrs_.c_str());
    sym->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
    RSVP(sym);
  
}
Rchrs::Rchrs(yacco2::Parser* P)
 :CAbs_lr1_sym
  ("Rchrs",0,Clinker_preamble_code::R_Rchrs_,P,false,false){
}

Rchr::Rchr(yacco2::Parser* P)
 :CAbs_lr1_sym
  ("Rchr",0,Clinker_preamble_code::R_Rchr_,P,false,false){
}

void Rchr::op(){
  sstrace_rulesss
 
    if(rule_info__.parser__->stop_parse__ == true) return;
    if(rule_info__.parser__->use_all_shift__ == false) return;// end-preamble seen
    CAbs_lr1_sym* la_sym = rule_info__.parser__->current_token();
    using namespace NS_yacco2_T_enum;
    using namespace NS_yacco2_terminals;
    // watch for overrun
    if(la_sym->enumerated_id__ == T_Enum::T_LR1_eog_){
      CAbs_lr1_sym* sym = new Err_end_preamble_kw_not_present;
      sym->set_rc(*la_sym,__FILE__,__LINE__);
      RSVP(sym);
      rule_info__.parser__->set_stop_parse(true);
    } 
  
}
void Rchr::sr1(){
  struct SF{
   LR1_parallel_operator* p1__;
   State* s1__;
   bool abort1__;
   Rule_s_reuse_entry* rule_s_reuse_entry1__;
   T_comment* p2__;
   State* s2__;
   bool abort2__;
   Rule_s_reuse_entry* rule_s_reuse_entry2__;
  };
  SF* sf = (SF*)rule_info__.parser__->parse_stack__.sf_by_top(2);
  
 	  Clinker_preamble_code* fsm = (Clinker_preamble_code*) rule_info__.parser__->fsm_tbl__;
      T_comment* k = sf->p2__;
      k->set_auto_delete(true);// delete it when it pops from stack
      fsm->chrs_ += k->comment_data()->c_str();
    
}

void Rchr::sr2(){
  struct SF{
   LR1_parallel_operator* p1__;
   State* s1__;
   bool abort1__;
   Rule_s_reuse_entry* rule_s_reuse_entry1__;
   T_c_string* p2__;
   State* s2__;
   bool abort2__;
   Rule_s_reuse_entry* rule_s_reuse_entry2__;
  };
  SF* sf = (SF*)rule_info__.parser__->parse_stack__.sf_by_top(2);
  
 	  Clinker_preamble_code* fsm = 
	(Clinker_preamble_code*) rule_info__.parser__->fsm_tbl__;
      T_c_string* k = sf->p2__;
      k->set_auto_delete(true);// delete it when it pops from stack
      // add back the bounding double quotes
      fsm->chrs_ += '"';
      fsm->chrs_ += k->c_string()->c_str();
      fsm->chrs_ += '"';
	  fsm->empty_sdc_ = false;
    
}

void Rchr::sr3(){
  struct SF{
   LR1_parallel_operator* p1__;
   State* s1__;
   bool abort1__;
   Rule_s_reuse_entry* rule_s_reuse_entry1__;
   T_c_literal* p2__;
   State* s2__;
   bool abort2__;
   Rule_s_reuse_entry* rule_s_reuse_entry2__;
  };
  SF* sf = (SF*)rule_info__.parser__->parse_stack__.sf_by_top(2);
  
 	  Clinker_preamble_code* fsm = 
		(Clinker_preamble_code*) rule_info__.parser__->fsm_tbl__;
      T_c_literal* k = sf->p2__;
      k->set_auto_delete(true);// delete it when it pops from stack
      // add back the bounding single quotes
      fsm->chrs_ += "'";
      fsm->chrs_ += k->c_literal()->c_str();
      fsm->chrs_ += "'";
	  fsm->empty_sdc_ = false;
    
}

void Rchr::sr4(){
   
 	  Clinker_preamble_code* fsm = (Clinker_preamble_code*) rule_info__.parser__->fsm_tbl__;
      rule_info__.parser__->set_use_all_shift_off();
      if(fsm->empty_sdc_ == true){
        CAbs_lr1_sym* sym = new Err_preamble_srce_code_not_present;
		sym->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
		RSVP(sym);
		rule_info__.parser__->set_stop_parse(true);
		return;
      }
    
}

void Rchr::sr5(){
  struct SF{
   CAbs_lr1_sym* p1__;
   State* s1__;
   bool abort1__;
   Rule_s_reuse_entry* rule_s_reuse_entry1__;
  };
  SF* sf = (SF*)rule_info__.parser__->parse_stack__.sf_by_top(1);
  
 	  Clinker_preamble_code* fsm = 
		(Clinker_preamble_code*) rule_info__.parser__->fsm_tbl__;
      CAbs_lr1_sym* k = sf->p1__;
		switch (k->enumerated_id__){
			case T_Enum::T_T_eol_:{
				fsm->chrs_ += "\n";
				break;
			}
			case T_Enum::T_raw_sp_:{
				fsm->chrs_ += " ";
				break;
			}
			case T_Enum::T_raw_ff_:{
				fsm->chrs_ += "\f";
				break;
			}
			case T_Enum::T_raw_vt_:{
      			fsm->chrs_ += "\v";
				break;
			}
			case T_Enum::T_raw_ht_:{
            	fsm->chrs_ += "\t";
				break;
			}
			case T_Enum::T_raw_cr_:{
            	fsm->chrs_ += "\n";
				break;
			}
			case T_Enum::T_raw_lf_:{
				fsm->chrs_ += "\n";
				break;
			}
			default:{
				fsm->chrs_ += *k->id__;
				fsm->empty_sdc_ = false;
				break;
			}
		}
    
}

void Rchr::sr6(){
  struct SF{
   LR1_parallel_operator* p1__;
   State* s1__;
   bool abort1__;
   Rule_s_reuse_entry* rule_s_reuse_entry1__;
   CAbs_lr1_sym* p2__;
   State* s2__;
   bool abort2__;
   Rule_s_reuse_entry* rule_s_reuse_entry2__;
  };
  SF* sf = (SF*)rule_info__.parser__->parse_stack__.sf_by_top(2);
  
       RSVP(sf->p2__);
       rule_info__.parser__->set_stop_parse(true);
    
}

void Rchr::sr7(){
  struct SF{
   LR1_parallel_operator* p1__;
   State* s1__;
   bool abort1__;
   Rule_s_reuse_entry* rule_s_reuse_entry1__;
   T_identifier* p2__;
   State* s2__;
   bool abort2__;
   Rule_s_reuse_entry* rule_s_reuse_entry2__;
  };
  SF* sf = (SF*)rule_info__.parser__->parse_stack__.sf_by_top(2);
  
    Clinker_preamble_code* fsm = 
		(Clinker_preamble_code*)rule_info__.parser__->fsm_tbl__;
      T_identifier* k = sf->p2__;
      k->set_auto_delete(true);// delete it when it pops from stack
      fsm->chrs_ += k->identifier()->c_str();
    
}

