#! /bin/sh
#file: gen1grammar.bat
# compile 1 grammar
# parm 1) grammar name to compile
# Example:
# 0) cd /usr/local/yacco2/compiler/grammars
# 1) . gen1grammar.bat eol.lex # gen c++ for eol.lex


#
# p1 possible switches with grammar file to work with
# p2 grammar file without the extension
#
delete_files=1 # set to delete the various gened files
parm=""
cc_lex()
{
  echo "==========> Grammar to compile with switches: $1" 
  file_name_only="`basename $2`"
  if ! eval "$o2 $1" 
  then
    echo "grammar in error --- exiting";
    return 1;
  fi 
  for j in $1
  do
    case $j in
    *p)
      eval "mpost $file_name_only.mp"
      eval "cweave $file_name_only.w"
      eval "pdftex $file_name_only.tex"
      xref="$file_name_only""_idx"
      echo "%%%%%%%%%%%%%%%%% index file: $xref to cweave and pdftex"
      eval "cweave $xref.w"
      eval "pdftex $xref.tex"
      ###pdftops "$file_name_only.pdf"
      ###pdftops "$xref"".pdf"
      eval "cp $xref\.pdf* $dir_only"; #copy gened docs to its gening folder
      ###eval "cp $xref\.ps* $dir_only"; #copy gened docs to its gening folder
      return
    esac
  done
if test $delete_files -eq 1; then
  for k in `ls -1 * `;
  do
   #echo "!!!!!!!!!!!!!!!!!!!!!!!!!!!!Casing on $k"
   case $k in
    *.cpp|*.h) 
      echo "-----Copying--------> $k to $dir_only/$k"
      eval "cp $k $dir_only/$k";
      eval "rm -f $k" 
      ;;
    *.fsc) 
      echo "-----Copying--------> $k to $dir_only/$k"
      eval "cp $k $dir_only/$k";
      eval "rm -f $k" ;;
    *.scn|*.idx|*.log|*.toc)
      #echo "-------------> Deleting $k"
      eval "rm -f $k" 
      ;;
    Err.w|T.w) # error and terminal documents to be cweave then pdftex printed by xpdf
      echo "-----Copying--------> $k to $dir_only/$k"
      eval "cp $k $dir_only/$k";
      #echo "-------------> Deleting $k"
      #eval "rm -f $k" eof
      ;;
    *.w)
      #echo "-------------> Deleting $k"
      eval "rm -f $k" 
      ;;
    *.tex)
      #echo "-------------> Deleting $k"
      eval "rm -f $k" 
      ;;
    *.mp)
      #echo "-------------> Deleting $k"
      eval "rm -f $k" 
      ;;
    *.tex1)
      #echo "-------------> Deleting $k"
      eval "rm -f $k" 
      ;;
    *.[1-9])
      echo "-------------> Deleting Mpost diagrams $k"
      eval "rm -f $k" 
      ;;
     *.[1-9][0-9]*)
      echo "-------------> Deleting Mpost diagrams $k"
      eval "rm -f $k"
     ;;
   esac
  done
fi
}

o2=/usr/local/yacco2/bin/o2
tmp=/tmp/o2
if [ ! -e "$tmp" ] 
then
  mkdir $tmp
fi
  
file_no_ext=${1%%.*}
echo "==========> Grammar to compile: $1; file name without extension: $file_no_ext" 
echo "Parameters to use"
echo " 0) exit script"
echo " 1) just compile grammar: $1"
echo " 2) also gen $1 and  Tes and Errors vocabularies: -t -err"
echo " 3) gen $1 documents: -p"
dir_only=`pwd`
cd $tmp 
while true; do
    echo -n "Choose selection no: " 
    read no
    case $no in
        0 ) 
           echo "exiting script";
           break;;
        1 ) 
           parm=" $dir_only/$1";
           ;;
        2 ) 
           parm=" -t -err $dir_only/$1";
           ;;
        3 ) 
           parm=" -p $dir_only/$1";
           ;;
        * ) 
           echo "Please answer 0..3";
           continue;;
    esac
    echo "parm: $parm"
    if test "$parm" ;
     then
           cc_lex "$parm" "$dir_only/$file_no_ext"
           cd $dir_only 
           break
    fi     
done

