/*
 * Decompiled with CFR 0.152.
 */
package nts.align;

import java.io.ObjectStreamException;
import java.io.Serializable;
import nts.align.AlignSizesMatrix;
import nts.align.Alignment;
import nts.align.AnyUnsetNode;
import nts.align.Preamble;
import nts.align.PreambleScanning;
import nts.base.Dimen;
import nts.base.Glue;
import nts.builder.Builder;
import nts.command.BraceNesting;
import nts.command.Closing;
import nts.command.Command;
import nts.command.CommandBase;
import nts.command.InpTokChecker;
import nts.command.InsertedTokenList;
import nts.command.SimpleGroup;
import nts.command.Token;
import nts.command.TokenList;
import nts.node.AnyBoxNode;
import nts.node.AnySkipNode;
import nts.node.BoxSizes;
import nts.node.GlueSetting;
import nts.node.HBoxNode;
import nts.node.Node;
import nts.node.NodeEnum;
import nts.node.NodeList;
import nts.node.RuleNode;
import nts.node.SizesEvaluator;
import nts.node.VShiftNode;
import nts.typo.Paragraph;
import nts.typo.TypoCommand;

public abstract class Alignment
extends CommandBase {
    public static final Alignment NULL;
    public static final int GLUEP_TAB_SKIP;
    public static final ColumnEnding SPAN_ENDING;
    public static final ColumnEnding TAB_ENDING;
    public static final ColumnEnding CR_ENDING;
    public static final ColumnEnding NULL_ENDING;
    public static final int NOALIGN_DISBALANCE = 1000000;
    protected static final ColumnBraceNesting NULL_COLUMN_NESTING;
    private static Alignment top;
    public static Closing CLOSE_COLUMN;
    public static Closing MISSING_CR;
    protected final Dimen desired;
    protected final boolean exactly;
    protected final TokenList.Inserter everyCr;
    protected final Token frozenCr;
    protected final Token frozenEndTemplate;
    protected Preamble preamble;
    protected AlignSizesMatrix maxSizes;
    protected int currColumn;
    protected int currSpan;
    protected ColumnBraceNesting columnBalance = null;
    protected BraceNesting savedColumnNesting;
    protected boolean insertTemplate;
    protected ColumnEnding columnEnding = null;
    private Alignment next = null;

    public void start(Token src) {
        this.push();
        this.preamble = this.scanPreamble(src);
        this.maxSizes = new AlignSizesMatrix(this.preamble.length());
        this.everyCr.insertToks();
        this.nextRow();
    }

    protected Preamble scanPreamble(Token src) {
        CommandBase.Config cfg = CommandBase.getConfig();
        PreambleScanning scan = new PreambleScanning(src, this.frozenCr);
        InpTokChecker savedChk = CommandBase.setTokenChecker(scan);
        BraceNesting savedBrn = CommandBase.setBraceNesting(scan);
        boolean afterAssign = cfg.enableAfterAssignment(false);
        Glue firstSkip = cfg.getGlueParam(GLUEP_TAB_SKIP);
        String skipName = cfg.getGlueName(GLUEP_TAB_SKIP);
        while (this.scanRecord(scan)) {
        }
        CommandBase.setBraceNesting(savedBrn);
        CommandBase.setTokenChecker(savedChk);
        cfg.enableAfterAssignment(afterAssign);
        return scan.toPreamble(firstSkip, skipName, this.frozenEndTemplate);
    }

    protected boolean scanRecord(PreambleScanning scan) {
        Token tok;
        Command cmd;
        boolean fresh = true;
        while (!(cmd = CommandBase.meaningOf(tok = this.getPreambleToken())).isMacroParam()) {
            if (scan.balanced() && (cmd.isTabMark() || cmd.isCarRet())) {
                if (fresh && cmd.isTabMark() && scan.setLoopIndex()) continue;
                CommandBase.backToken(tok);
                CommandBase.error("MissingSharp");
                break;
            }
            if (fresh && cmd.isSpacer()) continue;
            scan.append(tok);
            fresh = false;
        }
        scan.finishHalf();
        while (true) {
            tok = this.getPreambleToken();
            cmd = CommandBase.meaningOf(tok);
            if (scan.balanced() && (cmd.isTabMark() || cmd.isCarRet())) break;
            if (cmd.isMacroParam()) {
                CommandBase.error("SecondSharpInTab");
                continue;
            }
            scan.append(tok);
        }
        scan.append(this.frozenEndTemplate);
        scan.finishRecord(CommandBase.getConfig().getGlueParam(GLUEP_TAB_SKIP));
        return !cmd.isCarRet();
    }

    protected Token getPreambleToken() {
        Token tok;
        while (true) {
            tok = CommandBase.nextRawToken();
            while (CommandBase.meaningOf(tok).isSpan()) {
                tok = CommandBase.nextExpToken();
            }
            Command cmd = CommandBase.meaningOf(tok);
            if (!cmd.isTabSkip()) break;
            cmd.exec(tok);
        }
        return tok;
    }

    protected void nextRow() {
        Token tok;
        Command cmd;
        while ((cmd = CommandBase.meaningOf(tok = CommandBase.nextExpNonSpacer())).isCrCr()) {
        }
        if (cmd.isNoAlign()) {
            this.startNonAligned();
        } else if (cmd.isRightBrace()) {
            this.stop();
        } else {
            this.pushNewRowBuilder();
            this.addNamedSkipToRow(this.preamble.firstSkip, this.preamble.skipName);
            this.startSpan(0);
            this.currColumn = 0;
            this.startColumn(tok, cmd);
        }
    }

    protected void startNonAligned() {
        CommandBase.scanLeftBrace();
        CommandBase.pushLevel(new NoAlignGroup());
    }

    protected void startSpan(int index) {
        CommandBase.pushLevel(new SpanGroup());
        this.pushNewSpanBuilder();
        this.currSpan = index;
    }

    protected void startColumn(Token tok, Command cmd) {
        if (cmd.isOmit()) {
            this.startColumnBody(false);
        } else {
            CommandBase.backToken(tok);
            Alignment alignment = this;
            if (alignment == null) {
                throw null;
            }
            CommandBase.getTokStack().push(alignment.new TemplateTokenizer(this.preamble.getUPart(this.currColumn)));
        }
    }

    protected boolean balancedColumn() {
        return this.columnBalance != null && this.columnBalance.balanced();
    }

    protected int columnDisbalance() {
        return this.columnBalance != null ? this.columnBalance.disbalance() : 1000000;
    }

    protected void startColumnBody(boolean insert) {
        this.columnBalance = new ColumnBraceNesting();
        this.savedColumnNesting = CommandBase.setBraceNesting(this.columnBalance);
        this.insertTemplate = insert;
    }

    protected void finishColumnBody(ColumnEnding ending) {
        if (this.columnBalance == null) {
            throw new RuntimeException("no column scanned");
        }
        CommandBase.setBraceNesting(this.savedColumnNesting);
        this.savedColumnNesting = null;
        this.columnBalance = null;
        if (this.insertTemplate) {
            CommandBase.pushList(this.preamble.getVPart(this.currColumn), "template");
        } else {
            CommandBase.pushToken(this.preamble.endTemplate, "template");
        }
        this.columnEnding = ending;
    }

    protected void finishColumn() {
        if (this.columnEnding == null) {
            throw new RuntimeException("column body not started and finished");
        }
        if (this.columnEnding != CR_ENDING && !this.preamble.hasRecord(this.currColumn + 1)) {
            CommandBase.error("ExtraAlignTab", this.frozenCr);
            this.columnEnding = CR_ENDING;
        }
        if (this.columnEnding != SPAN_ENDING) {
            CommandBase.popLevel();
            this.maxSizes.setMax(this.currSpan, this.currColumn, this.packedSpanSize(this.currColumn - this.currSpan));
            this.addNamedSkipToRow(this.preamble.getSkip(this.currColumn), this.preamble.skipName);
            if (this.columnEnding == CR_ENDING) {
                this.packRow();
                this.everyCr.insertToks();
                this.nextRow();
                return;
            }
            this.startSpan(this.currColumn + 1);
        }
        Token tok = CommandBase.nextExpNonSpacer();
        Command cmd = CommandBase.meaningOf(tok);
        ++this.currColumn;
        this.startColumn(tok, cmd);
        this.columnEnding = null;
    }

    protected void stop() {
        Builder.pop();
        CommandBase.popLevel();
    }

    public NodeEnum finish(Dimen indent) {
        Alignment.pop();
        this.calculateWidths();
        return this.setAndTransform(indent).nodes();
    }

    protected void calculateWidths() {
        int k = 0;
        int i = 1;
        while (i < this.maxSizes.size()) {
            Dimen tw = this.maxSizes.get(k);
            tw = tw == null ? Dimen.ZERO : tw.plus(this.preamble.getSkip(k).getDimen());
            int j = i;
            while (j < this.maxSizes.size()) {
                Dimen w = this.maxSizes.get(k, j);
                if (w != null) {
                    this.maxSizes.setMax(i, j, w.minus(tw));
                }
                ++j;
            }
            k = i++;
        }
    }

    protected NodeList setAndTransform(Dimen indent) {
        SizesEvaluator pack = new SizesEvaluator();
        pack.add(this.preamble.firstSkip);
        int i = 0;
        while (i < this.maxSizes.size()) {
            Dimen w = this.maxSizes.get(i);
            if (w != null) {
                pack.add(w);
                pack.add(this.preamble.getSkip(i));
            }
            ++i;
        }
        Dimen size = pack.getBody();
        if (this.exactly) {
            pack.evaluate(this.desired.minus(size), false);
            size = this.desired;
        } else {
            pack.evaluate(this.desired, false);
            size = size.plus(this.desired);
        }
        this.check(pack, size);
        return this.transform(size, pack.getSetting(), indent);
    }

    protected NodeList transform(Dimen size, GlueSetting setting, Dimen indent) {
        BoxSizes around = this.transformSizes(BoxSizes.ZERO, size);
        NodeList list = new NodeList();
        NodeEnum nodes = this.getUnsetNodes();
        while (nodes.hasMoreNodes()) {
            Node node = nodes.nextNode();
            if (node instanceof AnyUnsetNode) {
                node = this.transform((AnyUnsetNode)node, size, setting, indent);
            } else if (node instanceof RuleNode) {
                BoxSizes full;
                BoxSizes sizes = ((RuleNode)node).getSizes();
                if (!sizes.equals(full = sizes.replenished(around))) {
                    node = new RuleNode(full);
                }
                if (!indent.isZero()) {
                    node = HBoxNode.packedOf(node);
                    node = VShiftNode.shiftingRight(node, indent);
                }
            }
            list.append(node);
        }
        return list;
    }

    protected Node transform(AnyUnsetNode row, Dimen size, GlueSetting setting, Dimen indent) {
        NodeList list = new NodeList();
        NodeEnum nodes = row.getList().nodes();
        list.append(nodes.nextNode());
        int i = 0;
        while (nodes.hasMoreNodes()) {
            i = this.transform((AnyUnsetNode)nodes.nextNode(), list, i, row.getSizes(), setting);
            list.append(nodes.nextNode());
            ++i;
        }
        return VShiftNode.shiftingRight(this.makeBox(this.transformSizes(row.getSizes(), size), setting, list), indent);
    }

    protected int transform(AnyUnsetNode col, NodeList list, int i, BoxSizes rowSizes, GlueSetting setting) {
        boolean empty;
        int n = i + col.getSpanCount();
        Dimen size = this.maxSizes.get(i);
        boolean bl = empty = size == null;
        if (empty) {
            size = Dimen.ZERO;
        }
        NodeList filler = new NodeList();
        Dimen total = size;
        if (i < n) {
            Glue tab = empty ? Glue.ZERO : this.preamble.getSkip(i);
            int j = i;
            do {
                total = total.plus(setting.set(tab, false));
                filler.append(this.makeSkip(tab, this.preamble.skipName));
                Dimen w = this.maxSizes.get(++j);
                if (w != null) {
                    tab = this.preamble.getSkip(j);
                    total = total.plus(w);
                } else {
                    w = Dimen.ZERO;
                    tab = Glue.ZERO;
                }
                filler.append(this.makeBox(this.transformSizes(BoxSizes.ZERO, w), GlueSetting.NATURAL, NodeList.EMPTY));
            } while (j != n);
        }
        list.append(this.makeBox(this.transformSizes(rowSizes, size), col.getSetting(total.minus(this.getRelevantSize(col.getSizes()))), col.getList())).append(filler);
        return n;
    }

    protected void check(SizesEvaluator pack, Dimen size) {
        TypoCommand.AnyBoxPacker packer = this.makeBoxPacker();
        if (packer.check(pack)) {
            NodeList list = new NodeList();
            list.append(this.makeSkip(this.preamble.firstSkip, this.preamble.skipName));
            int i = 0;
            while (i < this.maxSizes.size()) {
                Dimen w = this.maxSizes.get(i);
                if (w != null) {
                    list.append(new AnyUnsetNode(this.transformSizes(BoxSizes.ZERO, w), NodeList.EMPTY)).append(i < this.preamble.length() ? this.makeSkip(this.preamble.getSkip(i), this.preamble.skipName) : this.makeSkip(this.preamble.getSkip(i)));
                } else {
                    list.append(new AnyUnsetNode()).append(this.makeSkip(Glue.ZERO, this.preamble.skipName));
                }
                ++i;
            }
            while (i < this.preamble.length()) {
                list.append(new AnyUnsetNode()).append(this.makeSkip(Glue.ZERO, this.preamble.skipName));
                ++i;
            }
            packer.reportBox(this.makeBox(this.transformSizes(BoxSizes.ZERO, size), pack.getSetting(), list));
        }
    }

    protected abstract void pushNewRowBuilder();

    protected abstract void pushNewSpanBuilder();

    protected abstract void addNamedSkipToRow(Glue var1, String var2);

    protected abstract Dimen packedSpanSize(int var1);

    protected abstract void packRow();

    protected abstract NodeEnum getUnsetNodes();

    protected abstract Dimen getRelevantSize(BoxSizes var1);

    protected abstract BoxSizes transformSizes(BoxSizes var1, Dimen var2);

    protected abstract AnyBoxNode makeBox(BoxSizes var1, GlueSetting var2, NodeList var3);

    protected abstract AnySkipNode makeSkip(Glue var1);

    protected abstract AnySkipNode makeSkip(Glue var1, String var2);

    protected abstract TypoCommand.AnyBoxPacker makeBoxPacker();

    public abstract void copyPrevParameters(Builder var1);

    private void push() {
        this.next = top;
        top = this;
    }

    private static void pop() {
        top = Alignment.top.next;
    }

    private static void checkTop() {
        if (top == null) {
            throw new RuntimeException("no alignment active");
        }
    }

    public static boolean columnBodyIsActiveAndBalanced() {
        return top != null && top.balancedColumn();
    }

    public static void finishActiveColumnBody(ColumnEnding ending) {
        Alignment.checkTop();
        top.finishColumnBody(ending);
    }

    public static int activeColumnDisbalance() {
        return top != null ? top.columnDisbalance() : 1000000;
    }

    public Alignment(Dimen desired, boolean exactly, TokenList.Inserter everyCr, Token frzCr, Token frzEndt) {
        this.desired = desired;
        this.exactly = exactly;
        this.everyCr = everyCr;
        this.frozenCr = frzCr;
        this.frozenEndTemplate = frzEndt;
    }

    static {
        GLUEP_TAB_SKIP = CommandBase.newGlueParam();
        SPAN_ENDING = new ColumnEnding(null, "SPAN_ENDING");
        TAB_ENDING = new ColumnEnding(null, "TAB_ENDING");
        CR_ENDING = new ColumnEnding(null, "CR_ENDING");
        top = null;
        CLOSE_COLUMN = new 2();
        MISSING_CR = new 3();
    }

    public static final class ColumnEnding
    implements Serializable {
        private static int nextOrdinal = 0;
        private static ColumnEnding[] VALS = new ColumnEnding[3];
        private final int ordinal = nextOrdinal++;
        private final String name;

        public String toString() {
            return this.name;
        }

        private Object readResolve() throws ObjectStreamException {
            return VALS[this.ordinal];
        }

        private ColumnEnding(String name) {
            this.name = name;
            ColumnEnding.VALS[this.ordinal] = this;
        }

        /* synthetic */ ColumnEnding(1 var1_1, String string) {
            this(string);
        }
    }

    protected static class ColumnBraceNesting
    implements BraceNesting {
        private int braceNesting = 0;

        public void adjust(int count) {
            this.braceNesting += count;
        }

        public int disbalance() {
            return this.braceNesting;
        }

        public boolean balanced() {
            return this.braceNesting == 0;
        }

        ColumnBraceNesting() {
        }
    }

    protected class TemplateTokenizer
    extends InsertedTokenList {
        public boolean close() {
            Alignment.this.startColumnBody(true);
            return false;
        }

        public TemplateTokenizer(TokenList list) {
            super(list, "<template> ");
        }
    }

    public static class SpanGroup
    extends SimpleGroup {
    }

    public static class NoAlignGroup
    extends SimpleGroup {
        public void stop() {
            Paragraph.finish();
        }

        public void close() {
            Alignment.checkTop();
            top.nextRow();
        }
    }
}

