// Name of a group of files
[groupname]
/l50001/l

// This section contains extensions of files belonging to the group.
// If one extenstion belongs to more than one group, definitions from all the
// groups are applied
[extensions]
tex, sty, cls, lof, lot, toc, idx, glo, aux, bbl, clo

// Appear in Add File Dialog as file types (number is a position in combobox list)
[filterindex]
1

// Access type to the files from the group
[access]
// level    = (0-readonly, 1-ask before edit, 2-fullaccess}
// question = {nicetext shown to ask the file should be edited}
// exec     = {file name to execute when a file is opened}
level=2

// Defines if the group of files is enabled by default
[default]
yes

// Some options
[options]
wrapline=yes
casesensitive=yes
usethesaurus=yes
spellchecking=yes


// Associations for Windows
// Syntaxt:
//     extension=internal_name=windows_shell_name
[associations]
+tex=TeXFile.LEd=/l51950/l
sty=TeXStyleFile.LEd=/l51951/l
cls=TeXClassFile.LEd=/l51952/l
lof=TeXLOFFile.LEd=/l51953/l
lot=TeXLOTFile.LEd=/l51954/l
toc=TeXTOCFile.LEd=/l51955/l
idx=TeXIndexFile.LEd=/l51956/l
glo=TeXGlossaryFile.LEd=/l51957/l
aux=TeXAuxFile.LEd=/l51958/l
bbl=TeXBblFile.LEd=/l51959/l
clo=TeXClassOptionFile=/l51960/l

// Hilight commands
// Predefined groups:
// [hilight\keys]     - keywords
// [hilight\symbols]  - special symbols
// [hilight\types]    - types
// [hilight\comments] - comments
[hilight\LaTeXKeys]
$
\!
\'
\(
\)
\+
\,
\-
\;
\:
\<
\=
\>
\[
\\
\]
\`
\a
\%
\addcontentsline
\address
\addtocontents
\addtocounter
\addtolength
\addvspace
\alph
\Alph
\appendix
\arabic
\author
\backslash
\begin
\bfseries
\bibitem
\bibliography
\bibliographystyle
\bigskip
\caption
\cc
\cdots
\centering
\chapter
\circle
\cite
\cleardoublepage
\clearpage
\cline
\closing
\colon
\dashbox
\date
\ddots
\depth
\documentclass
\dotfill
\emph
\encl
\end
\enlargethispage
\fbox
\flushbottom
\fnsymbol
\fontencoding
\fontfamily
\fontseries
\fontshape
\fontsize
\footnote
\footnotemark
\footnotesize
\footnotetext
\frac
\frame
\framebox
\fussy
\height
\hfill
\hline
\hrulefill
\hspace
\huge
\Huge
\hyphenation
\include
\includeonly
\indent
\input
\item
\itshape
\kill
\label
\large
\Large
\LARGE
\ldots
\lefteqn
\line
\linebreak
\linethickness
\listoffigures
\listoftables
\location
\makebox
\makebox(
\makelabels
\maketitle
\markboth
\markright
\mathbf
\mathcal
\mathit
\mathnormal
\mathrm
\mathsf
\mathtt
\mathversion
\mbox
\mdseries
\medskip
\multicolumn
\multiput
\name
\newcommand
\newcounter
\newenvironment
\newfont
\newlength
\newline
\newpage
\newsavebox
\newtheorem
\nocite
\nofiles
\noindent
\nolinebreak
\nonumber
\nopagebreak
\normalfont
\normalsize
\onecolumn
\opening
\oval
\overbrace
\overline
\pagebreak
\pagenumbering
\pageref
\pagestyle
\par
\part
\paragraph
\parbox
\ps
\poptabs
\pushtabs
\put
\raggedbottom
\raggedleft
\raggedright
\raisebox
\ref
\refstepcounter
\renewcommand
\rmfamily
\roman
\Roman
\rule
\savebox
\sbox
\scriptsize
\scshape
\selectfont
\setcounter
\setlength
\settodepth
\settoheight
\settowidth
\sffamily
\shortstack
\signature
\sloppy
\slshape
\small
\smallskip
\sqrt
\startbreaks
\stepcounter
\stopbreaks
\subparagraph
\section
\subsection
\subsubsection
\symbol
\tableofcontents
\telephone
\textbf
\textit
\textmd
\textnormal
\textrm
\textsc
\textsf
\textsl
\texttt
\textup
\thanks
\thispagestyle
\tiny
\title
\today
\totalheight
\ttfamily
\twocolumn
\typein
\typeout
\underbrace
\underline
\upshape
\usebox
\usecounter
\usefont
\usepackage
\value
\vdots
\vector
\verb
\vfill
\vline
\vspace
\width
^
_
\begin{array}
\begin{center}
\begin{description}
\begin{document}
\begin{enumerate}
\begin{eqnarray}
\begin{equation}
\begin{figure}
\begin{flushleft}
\begin{flushright}
\begin{itemize}
\begin{letter}
\begin{list}
\begin{lrbox}
\begin{minipage}
\begin{picture}
\begin{quotation}
\begin{quote}
\begin{tabbing}
\begin{table}
\begin{tabular}
\begin{tabular*}
\begin{thebibliography}
\begin{theorem}
\begin{titlepage}
\begin{verbatim}
\begin{verse}
\end{array}
\end{center}
\end{description}
\end{document}
\end{enumerate}
\end{eqnarray}
\end{equation}
\end{figure}
\end{flushleft}
\end{flushright}
\end{itemize}
\end{letter}
\end{list}
\end{lrbox}
\end{minipage}
\end{picture}
\end{quotation}
\end{quote}
\end{tabbing}
\end{table}
\end{tabular}
\end{tabular*}
\end{thebibliography}
\end{theorem}
\end{titlepage}
\end{verbatim}
\end{verse}

\right)
\right\]
\right\}
\right.
\left(
\left\[
\left\{

[hilight\TeXKeys]
$$
\@ne
\aa
\AA
\above
\abovedisplayshortskip
\abovedisplayskip
\abovewithdelims
\accent
\active
\acute
\address
\adjdemerits
\advance
\advancepageno
\ae
\AE
\afterassignment
\aftergroup
\aleph
\allocationnumber
\allowbreak
\allowhyphens
\alpha
\Alpha
\amalg
\AmSTeX
\angle
\annotations
\approx
\arccos
\arcsin
\arctan
\arg
\arrowvert
\Arrowvert
\ast
\asymp
\atop
\atopwithdelims
\b
\backslash
\badness
\bar
\baselineskip
\batchmode
\beginchapter
\begingroup
\beginsection
\belowdisplayshortskip
\belowdisplayskip
\beta
\Beta
\bf
\bffam
\bgroup
\big
\Big
\bigbreak
\bigcap
\bigcirc
\bigcup
\bigg
\Bigg
\bigggl
\bigggr
\biggl
\Biggl
\biggm
\Biggm
\biggr
\Biggr
\bigl
\Bigl
\bigm
\Bigm
\bigodot
\bigoplus
\bigotimes
\bigr
\Bigr
\bigskip
\bigskipamount
\bigsqcup
\bigtriangledown
\bigtriangleup
\bigtype
\biguplus
\bigvee
\bigwedge
\binoppenalty
\bmit
\bmod
\body
\bordermatrix
\bot
\botmark
\bowtie
\box
\box255
\boxmaxdepth
\brace
\braceld
\bracelu
\bracerd
\braceru
\bracevert
\brack
\break
\breve
\brokenpenalty
\buildrel
\bull
\bullet
\bye
\c
\cal
\cap
\cases
\catcode
\cdot
\cdotp
\cdots
\centering
\centerline
\cents
\char
\chardef
\check
\chi
\choose
\circ
\cleaders
\cleartabs
\closein
\closeout
\closing
\clubpenalty
\clubsuit
\colon
\columns
\cong
\coprod
\copy
\copyright
\cos
\cosh
\cot
\coth
\count
\count0
\countdef
\cr
\crcr
\csc
\csname
\cup
\d
\dag
\dagger
\danger
\dash
\dashv
\day
\ddag
\ddagger
\ddot
\ddots
\ddt
\deadcycles
\def
\defaulthyphenchar
\defaultskewchar
\deg
\delcode
\delimiter
\delimiterfactor
\delimitershortfall
\delta
\Delta
\det
\diamond
\diamondsuit
\dim
\dimen
\dimendef
\discretionary
\displayindent
\displaylimits
\displaylines
\displaystyle
\displaywidowpenalty
\displaywidth
\div
\divide
\do
\dospecials
\dosupereject
\dot
\doteq
\dotfill
\dots
\doublehyphendemerits
\downarrow
\Downarrow
\downbracefill
\dp
\dummy
\dump
\edef
\egroup
\eightpoint
\eject
\ell
\else
\emergencystretch
\empty
\emptyset
\end
\endchapter
\endcsname
\endgraf
\endgroup
\endinput
\endinsert
\endletter
\endline
\endlinechar
\endtemplate
\enskip
\enspace
\epsilon
\eqalign
\eqalignno
\eqno
\equiv
\errhelp
\errmessage
\errorcontextlines
\errorstopmode
\escapechar
\eta
\everycr
\everydisplay
\everyhbox
\everyjob
\everymath
\everypar
\everyvbox
\exercise
\exhyphenpenalty
\exists
\exp
\expandafter
\fam
\fi
\filbreak
\finalhyphendemerits
\firstmark
\fiverm
\flat
\floatingpenalty
\fmtname
\fmtversion
\folio
\font
\fontdimen
\fontname
\footins
\footline
\footnote
\footnoterule
\forall
\frenchspacing
\frown
\fullhsize
\fullline
\futurelet
\futurenonspacelet
\gamma
\Gamma
\gcd
\gdef
\ge
\geq
\getfactor
\gets
\gg
\global
\globaldefs
\glue
\goodbreak
\grave
\H
\halign
\hang
\hangafter
\hangindent
\hat
\hbadness
\hbar
\hbox
\headline
\heartsuit
\hfil
\hfill
\hfilneg
\hfuzz
\hglue
\hideskip
\hidewidth
\hoffset
\holdinginserts
\hom
\hookleftarrow
\hookrightarrow
\hphantom
\hrule
\hrulefill
\hsize
\hskip
\hss
\ht
\hyphenation
\hyphenchar
\hyphenpenalty
\i
\ialign
\if
\ifcase
\ifcat
\ifdim
\ifeof
\iffalse
\ifhbox
\ifhmode
\ifinner
\ifmmode
\ifnum
\ifodd
\iftrue
\ifundefined
\ifvbox
\ifvmode
\ifvoid
\ifx
\ignorespaces
\Im
\imath
\immediate
\in
\inaccessible
\indent
\inf
\infty
\input
\inputlineno
\insert
\insertpenalties
\int
\interdisplaylinepenalty
\interfootnotelinepenalty
\interlinepenalty
\iota
\it
\item
\itemitem
\itfam
\j
\jmath
\jobname
\joinrel
\jot
\kappa
\ker
\kern
\it\$,
\|
\L
\lambda
\Lambda
\land
\langle
\language
\lastbox
\lastkern
\lastpenalty
\lastskip
\LaTeX
\lbrace
\lbrack
\lccode
\lceil
\ldotp
\ldots
\le
\leaders
\leavevmode
\left
\leftarrow
\Leftarrow
\leftarrowfill
\leftharpoondown
\leftharpoonup
\lefthyphenmin
\leftline
\leftrightarrow
\Leftrightarrow
\leftskip
\leq
\leqalignno
\leqno
\let
\lfloor
\lg
\lgroup
\lhook
\lim
\liminf
\limits
\limsup
\line
\linepenalty
\lineskip
\lineskiplimit
\listing
\ll
\llap
\lmoustache
\ln
\lnot
\log
\long
\longindentation
\longleftarrow
\Longleftarrow
\longleftrightarrow
\Longleftrightarrow
\longmapsto
\longrightarrow
\Longrightarrow
\loop
\looseness
\lor
\lower
\lowercase
\lq
\m@ne
\m@th
\mag
\magnification
\magstep
\magstephalf
\maintoks
\makefootline
\makeheadline
\makelabel
\manfnt
\manual
\mapsto
\mapstochar
\margin
\mark
\mathaccent
\mathbin
\mathchar
\mathchardef
\mathchoice
\mathclose
\mathcode
\mathhexbox
\mathinner
\mathop
\mathopen
\mathord
\mathpalette
\mathpunct
\mathrel
\mathstrut
\mathsurround
\matrix
\max
\maxdeadcycles
\maxdepth
\maxdimen
\meaning
\medbreak
\medmuskip
\medskip
\medskipamount
\medtype
\message
\mid
\midinsert
\min
\mit
\mkern
\models
\month
\moveleft
\moveright
\mp
\mskip
\mu
\multiply
\multispan
\muskip
\muskipdef
\nabla
\narrower
\natural
\ne
\nearrow
\neg
\negthinspace
\neq
\newbox
\newcount
\newdimen
\newfam
\newhelp
\newif
\newinsert
\newlanguage
\newlinechar
\newmuskip
\newread
\newskip
\newtoks
\newwrite
\next
\ni
\ninepoint
\ninerm
\ninesl
\noalign
\noboundary
\nobreak
\noexpand
\noindent
\nointerlineskip
\nolimits
\nonfrenchspacing
\nonscript
\nonstopmode
\nopagenumbers
\normalbaselines
\normalbaselineskip
\normalbottom
\normallineskip
\normallineskiplimit
\not
\notin
\nu
\null
\nulldelimiterspace
\nullfont
\number
\nwarrow
\o
\O
\oalign
\obeylines
\obeyspaces
\odot
\oe
\OE
\offinterlineskip
\oint
\oldstyle
\omega
\Omega
\omicron
\ominus
\omit
\ooalign
\openin
\openout
\openup
\oplus
\or
\oslash
\other
\otimes
\outer
\output
\outputpenalty
\over
\overbrace
\overfullrule
\overleftarrow
\overline
\overrightarrow
\overwithdelims
\owns
\P
\p@
\p@renwd
\pagebody
\pagecontents
\pagedepth
\pagefilllstretch
\pagefillstretch
\pagefilstretch
\pagegoal
\pageinsert
\pageno
\pageshrink
\pagestretch
\pagetotal
\par
\parallel
\parfillskip
\parindent
\parshape
\parskip
\partial
\path
\patterns
\pausing
\penalty
\perp
\phantom
\phi
\Phi
\pi
\Pi
\plainoutput
\pm|
\pmatrix
\pmod
\pnt
\postdisplaypenalty
\Pr
\prec
\preceq
\predisplaypenalty
\predisplaysize
\preloaded
\pretolerance
\prevdepth
\prevgraf
\prime
\proclaim
\prod
\propto
\ps
\psi
\Psi
\qquad
\quad
\rm
\radical
\raggedbottom
\raggedcenter
\raggedright
\raise
\rangle
\rbrace
\rbrack
\rceil
\Re
\read
\relax
\relbar
\Relbar
\relpenalty
\removelastskip
\repeat
\rfloor
\rgroup
\rho
\rhook
\right
\rightarrow
\Rightarrow
\rightarrowfill
\rightharpoondown
\rightharpoonup
\righthyphenmin
\rightleftharpoons
\rightline
\rightskip
\rlap
\rm
\rmoustache
\romannumeral
\root
\rq
\S
\sb
\sc
\scriptfont
\scriptscriptfont
\scriptscriptstyle
\scriptspace
\scriptstyle
\scrollmode
\searrow
\sec
\setbox
\setlanguage
\setminus
\settabs
\setupverbatim
\sevenrm
\sfcode
\sharp
\shipout
\show
\showbox
\showboxbreadth
\showboxdepth
\showhyphens
\showlists
\showthe
\sigma
\Sigma
\signed
\sim
\simeq|
\sin
\sinh
\skew
\skewchar
\skip
\skipdef
\sl
\slash
\slfam
\smallbreak
\smallint
\smallskip
\smallskipamount
\smalltype
\smash
\smile
\sp
\space
\spacefactor
\spaceskip
\spadesuit
\span
\special
\splitbotmark
\splitfirstmark
\splitmaxdepth
\splittopskip
\sqcap
\sqcup
\sqrt
\sqsubseteq
\sqsupseteq
\square
\ss
\star
\string
\strut
\strutbox
\subset
\subseteq
\succ
\succeq
\sum
\sum$'$
\sup
\supereject
\supset
\supseteq
\surd
\swarrow
\t
\tabalign
\tabs
\tabskip
\tan
\tanh
\tau
\tenex
\tenpoint
\tenrm
\tensl
\tensy
\TeX
\textfont
\textindent
\textstyle
\the
\theta
\Theta
\thickmuskip
\thinmuskip
\thinspace
\tilde
\time
\times
\to
\today
\toks
\toksdef
\tolerance
\top
\topglue
\topins
\topinsert
\topmark
\topskip
\tracingall
\tracingcommands
\tracinglostchars
\tracingmacros
\tracingonline
\tracingoutput
\tracingpages
\tracingparagraphs
\tracingrestores
\tracingstats
\triangle
\triangleleft
\triangleright
\tt
\ttfam
\ttglue
\ttraggedright
\u
\uccode
\uchyph
\uncatcodespecials
\undefined
\underbar
\underbrace
\underline
\unhbox
\unhcopy
\unkern
\unpenalty
\unskip
\unvbox
\unvcopy
\up
\uparrow
\Uparrow
\updownarrow
\Updownarrow
\uplus
\uppercase
\upsilon
\Upsilon
\v
\vadjust
\valign
\varepsilon
\varphi
\varpi
\varrho
\varsigma
\vartheta
\vbadness
\vbox
\vcenter
\vdash
\vdots
\vec
\vee
\vert
\Vert
\vfil
\vfill
\vfilll
\vfilneg
\vfootnote
\vfuzz
\vglue
\voffset
\voidb@x
\vphantom
\vrule
\vsize
\vskip
\vsplit
\vss
\vtop
\wd
\wedge
\widehat
\widetilde|
\widowpenalty
\wlog
\wp
\wr
\write
\xdef
\xi
\Xi
\xleaders
\xspaceskip
\xyzzy
\year
\z@
\z@skip
\zeta

// Defines comment commands
// single - symbol starting a comment ending by the end of line
// double - starting and ending symbols of the comment
[hilight\comments\LaTeXComments]
single=%
double=

// Defines hints for keywords. Each hint is a nicetext.
[hints]
// LaTeX
$=/l51001/l
\!=/l51002/l
\'=/l51003/l
\(=/l51004/l
\)=/l51005/l
\+=/l51006/l
\,=/l51007/l
\-=/l51008/l
\-=/l51009/l
\;=/l51010/l
\:=/l51282/l
\<=/l51011/l
\==/l51012/l
\>=/l51013/l
\[=/l51014/l
\\=/l51015/l
\]=/l51016/l
\`=/l51017/l
\a=/l51018/l
\addcontentsline=/l51019/l
\address=/l51020/l
\addtocontents=/l51021/l
\addtocounter=/l51022/l
\addtolength=/l51023/l
\addvspace=/l51024/l
\alph=/l51025/l
\Alph=/l51275/l
\appendix=/l51026/l
\arabic=/l51027/l
\author=/l51028/l
\backslash=/l51029/l
\begin=/l51030/l
\bfseries=/l51031/l
\bibitem=/l51032/l
\bibliography=/l51033/l
\bibliographystyle=/l51034/l
\bigskip=/l51035/l
\caption=/l51036/l
\cc=/l51037/l
\cdots=/l51038/l
\centering=/l51039/l
\chapter=/l51040/l
\circle=/l51041/l
\cite=/l51042/l
\cleardoublepage=/l51043/l
\clearpage=/l51044/l
\cline=/l51045/l
\closing=/l51046/l
\colon=/l51047/l
\dashbox=/l51048/l
\date=/l51049/l
\ddots=/l51050/l
\depth=/l51051/l
\documentclass=/l51052/l
\dotfill=/l51053/l
\emph=/l51054/l
\encl=/l51055/l
\end=/l51056/l
\enlargethispage=/l51057/l
\fbox=/l51058/l
\flushbottom=/l51059/l
\fnsymbol=/l51060/l
\fontencoding=/l51061/l
\fontfamily=/l51062/l
\fontseries=/l51063/l
\fontshape=/l51064/l
\fontsize=/l51065/l
\footnote=/l51066/l
\footnotemark=/l51067/l
\footnotesize=/l51068/l
\footnotetext=/l51069/l
\frac=/l51070/l
\frame=/l51071/l
\framebox=/l51072/l
\fussy=/l51073/l
\height=/l51074/l
\hfill=/l51075/l
\hline=/l51076/l
\hrulefill=/l51077/l
\hspace=/l51078/l
\huge=/l51079/l
\Huge=/l51273/l
\hyphenation=/l51080/l
\include=/l51081/l
\includeonly=/l51082/l
\indent=/l51083/l
\input=/l51084/l
\item=/l51085/l
\itshape=/l51086/l
\kill=/l51087/l
\label=/l51088/l
\large=/l51271/l
\Large=/l51089/l
\LARGE=/l51272/l
\ldots=/l51090/l
\lefteqn=/l51091/l
\line=/l51092/l
\linebreak=/l51093/l
\linethickness=/l51094/l
\listoffigures=/l51095/l
\listoftables=/l51096/l
\location=/l51097/l
\makebox=/l51098/l
\makelabels=/l51099/l
\maketitle=/l51100/l
\markboth=/l51101/l
\markright=/l51102/l
\mathbf=/l51103/l
\mathcal=/l51104/l
\mathit=/l51105/l
\mathnormal=/l51106/l
\mathrm=/l51107/l
\mathsf=/l51108/l
\mathtt=/l51109/l
\mathversion=/l51110/l
\mbox=/l51111/l
\mdseries=/l51112/l
\medskip=/l51113/l
\multicolumn=/l51114/l
\multiput=/l51115/l
\name=/l51116/l
\newcommand=/l51117/l
\newcounter=/l51118/l
\newenvironment=/l51119/l
\newfont=/l51120/l
\newlength=/l51121/l
\newline=/l51122/l
\newpage=/l51123/l
\newsavebox=/l51124/l
\newtheorem=/l51125/l
\nocite=/l51126/l
\nofiles=/l51127/l
\noindent=/l51128/l
\nolinebreak=/l51129/l
\nonumber=/l51285/l
\nopagebreak=/l51130/l
\normalfont=/l51131/l
\normalsize=/l51132/l
\onecolumn=/l51133/l
\opening=/l51134/l
\oval=/l51135/l
\overbrace=/l51136/l
\overline=/l51137/l
\pagebreak=/l51138/l
\pagenumbering=/l51139/l
\pageref=/l51140/l
\pagestyle=/l51141/l
\par=/l51142/l
\part=/l51286/l
\paragraph=/l51143/l
\parbox=/l51144/l
\ps=/l51145/l
\poptabs=/l51278/l
\pushtabs=/l51146/l
\put=/l51147/l
\raggedbottom=/l51148/l
\raggedleft=/l51149/l
\raggedright=/l51150/l
\raisebox=/l51151/l
\ref=/l51152/l
\refstepcounter=/l51153/l
\renewcommand=/l51287/l
\rmfamily=/l51154/l
\roman=/l51155/l
\Roman=/l51279/l
\rule=/l51156/l
\savebox=/l51157/l
\sbox=/l51158/l
\scriptsize=/l51159/l
\scshape=/l51160/l
\selectfont=/l51161/l
\setcounter=/l51162/l
\setlength=/l51163/l
\settodepth=/l51164/l
\settoheight=/l51165/l
\settowidth=/l51166/l
\sffamily=/l51167/l
\shortstack=/l51168/l
\signature=/l51169/l
\sloppy=/l51170/l
\slshape=/l51171/l
\small=/l51172/l
\smallskip=/l51173/l
\sqrt=/l51174/l
\startbreaks=/l51175/l
\stepcounter=/l51176/l
\stopbreaks=/l51177/l
\subparagraph=/l51178/l
\section=/l51274/l
\subsection=/l51179/l
\subsubsection=/l51180/l
\symbol=/l51181/l
\tableofcontents=/l51182/l
\telephone=/l51183/l
\textbf=/l51184/l
\textit=/l51185/l
\textmd=/l51186/l
\textnormal=/l51187/l
\textrm=/l51188/l
\textsc=/l51189/l
\textsf=/l51190/l
\textsl=/l51191/l
\texttt=/l51192/l
\textup=/l51193/l
\thanks=/l51194/l
\thispagestyle=/l51195/l
\tiny=/l51196/l
\title=/l51197/l
\today=/l51198/l
\totalheight=/l51199/l
\ttfamily=/l51200/l
\twocolumn=/l51201/l
\typein=/l51202/l
\typeout=/l51203/l
\underbrace=/l51204/l
\underline=/l51205/l
\upshape=/l51206/l
\usebox=/l51207/l
\usecounter=/l51208/l
\usefont=/l51209/l
\usepackage=/l51210/l
\value=/l51211/l
\vdots=/l51212/l
\vector=/l51213/l
\verb=/l51214/l
\vfill=/l51215/l
\vline=/l51216/l
\vspace=/l51217/l
\width=/l51218/l
^=/l51219/l
_=/l51220/l
\begin{array}=/l51221/l
\begin{center}=/l51222/l
\begin{description}=/l51223/l
\begin{document}=/l51283/l
\begin{enumerate}=/l51224/l
\begin{eqnarray}=/l51225/l
\begin{equation}=/l51226/l
\begin{figure}=/l51227/l
\begin{flushleft}=/l51228/l
\begin{flushright}=/l51229/l
\begin{itemize}=/l51230/l
\begin{letter}=/l51231/l
\begin{list}=/l51232/l
\begin{lrbox}=/l51233/l
\begin{minipage}=/l51234/l
\begin{picture}=/l51235/l
\begin{quotation}=/l51236/l
\begin{quote}=/l51237/l
\begin{tabbing}=/l51238/l
\begin{table}=/l51239/l
\begin{tabular}=/l51240/l
\begin{tabular*}=/l51280/l
\begin{thebibliography}=/l51241/l
\begin{theorem}=/l51242/l
\begin{titlepage}=/l51243/l
\begin{verbatim}=/l51244/l
\begin{verse}=/l51245/l
\end{array}=/l51246/l
\end{center}=/l51247/l
\end{description}=/l51248/l
\end{document}=/l51284/l
\end{enumerate}=/l51249/l
\end{eqnarray}=/l51250/l
\end{equation}=/l51251/l
\end{figure}=/l51252/l
\end{flushleft}=/l51253/l
\end{flushright}=/l51254/l
\end{itemize}=/l51255/l
\end{letter}=/l51256/l
\end{list}=/l51257/l
\end{lrbox}=/l51258/l
\end{minipage}=/l51259/l
\end{picture}=/l51260/l
\end{quotation}=/l51261/l
\end{quote}=/l51262/l
\end{tabbing}=/l51263/l
\end{table}=/l51264/l
\end{tabular}=/l51265/l
\end{tabular*}=/l51281/l
\end{thebibliography}=/l51266/l
\end{theorem}=/l51267/l
\end{titlepage}=/l51268/l
\end{verbatim}=/l51269/l
\end{verse}=/l51270/l
// Last 51287

// TeX
\@ne=/l52078/l
\aa=/l52079/l
\AA=/l52080/l
\above=/l52081/l
\abovedisplayshortskip=/l52082/l
\abovedisplayskip=/l52083/l
\abovewithdelims=/l52084/l
\accent=/l52085/l
\active=/l52086/l
\acute=/l52087/l
\address=/l52088/l
\adjdemerits=/l52089/l
\advance=/l52090/l
\advancepageno=/l52091/l
\ae=/l52092/l
\AE=/l52093/l
\afterassignment=/l52094/l
\aftergroup=/l52095/l
\aleph=/l52096/l
\allocationnumber=/l52097/l
\allowbreak=/l52098/l
\allowhyphens=/l52099/l
\alpha=/l52100/l
\Alpha=/l52101/l
\amalg=/l52102/l
\AmSTeX,=/l52103/l
\angle=/l52104/l
\annotations=/l52105/l
\approx=/l52106/l
\arccos=/l52107/l
\arcsin=/l52108/l
\arctan=/l52109/l
\arg=/l52110/l
\arrowvert=/l52111/l
\Arrowvert=/l52112/l
\ast=/l52113/l
\asymp=/l52114/l
\atop=/l52115/l
\atopwithdelims=/l52116/l
\b=/l52117/l
\backslash=/l52118/l
\badness=/l52119/l
\bar=/l52120/l
\baselineskip=/l52121/l
\batchmode=/l52122/l
\beginchapter=/l52123/l
\begingroup=/l52124/l
\beginsection=/l52125/l
\belowdisplayshortskip=/l52126/l
\belowdisplayskip=/l52127/l
\beta=/l52128/l
\Beta=/l52129/l
\bf=/l52130/l
\bffam=/l52131/l
\bgroup=/l52132/l
\big=/l52133/l
\Big=/l52134/l
\bigbreak=/l52135/l
\bigcap=/l52136/l
\bigcirc=/l52137/l
\bigcup=/l52138/l
\bigg=/l52139/l
\Bigg=/l52140/l
\bigggl=/l52141/l
\bigggr=/l52142/l
\biggl=/l52143/l
\Biggl=/l52144/l
\biggm=/l52145/l
\Biggm=/l52146/l
\biggr=/l52147/l
\Biggr=/l52148/l
\bigl=/l52149/l
\Bigl=/l52150/l
\bigm=/l52151/l
\Bigm=/l52152/l
\bigodot=/l52153/l
\bigoplus=/l52154/l
\bigotimes=/l52155/l
\bigr=/l52156/l
\Bigr=/l52157/l
\bigskip=/l52158/l
\bigskipamount=/l52159/l
\bigsqcup=/l52160/l
\bigtriangledown=/l52161/l
\bigtriangleup=/l52162/l
\bigtype=/l52163/l
\biguplus=/l52164/l
\bigvee=/l52165/l
\bigwedge=/l52166/l
\binoppenalty=/l52167/l
\bmit=/l52168/l
\bmod=/l52169/l
\body=/l52170/l
\bordermatrix=/l52171/l
\bot=/l52172/l
\botmark=/l52173/l
\bowtie=/l52174/l
\box=/l52175/l
\box255=/l52176/l
\boxmaxdepth=/l52177/l
\brace=/l52178/l
\braceld=/l52179/l
\bracelu=/l52180/l
\bracerd=/l52181/l
\braceru=/l52182/l
\bracevert=/l52183/l
\brack=/l52184/l
\break=/l52185/l
\breve=/l52186/l
\brokenpenalty=/l52187/l
\buildrel=/l52188/l
\bull=/l52189/l
\bullet=/l52190/l
\bye=/l52191/l
\c=/l52192/l
\cal=/l52193/l
\cap=/l52194/l
\cases=/l52195/l
\catcode=/l52196/l
\cdot=/l52197/l
\cdotp=/l52198/l
\cdots=/l52199/l
\centering=/l52200/l
\centerline=/l52201/l
\cents=/l52202/l
\char=/l52203/l
\chardef=/l52204/l
\check=/l52205/l
\chi=/l52206/l
\choose=/l52207/l
\circ=/l52208/l
\cleaders=/l52209/l
\cleartabs=/l52210/l
\closein=/l52211/l
\closeout=/l52212/l
\closing=/l52213/l
\clubpenalty=/l52214/l
\clubsuit=/l52215/l
\colon=/l52216/l
\columns=/l52217/l
\cong=/l52218/l
\coprod=/l52219/l
\copy=/l52220/l
\copyright=/l52221/l
\cos=/l52222/l
\cosh=/l52223/l
\cot=/l52224/l
\coth=/l52225/l
\count=/l52226/l
\count0=/l52227/l
\countdef=/l52228/l
\cr=/l52229/l
\crcr=/l52230/l
\csc=/l52231/l
\csname=/l52232/l
\cup=/l52233/l
\d=/l52234/l
\dag=/l52235/l
\dagger=/l52236/l
\danger=/l52237/l
\dash=/l52238/l
\dashv=/l52239/l
\day=/l52240/l
\ddag=/l52241/l
\ddagger=/l52242/l
\ddot=/l52243/l
\ddots=/l52244/l
\ddt=/l52245/l
\deadcycles=/l52246/l
\def=/l52247/l
\defaulthyphenchar=/l52248/l
\defaultskewchar=/l52249/l
\deg=/l52250/l
\delcode=/l52251/l
\delimiter=/l52252/l
\delimiterfactor=/l52253/l
\delimitershortfall=/l52254/l
\delta=/l52255/l
\Delta=/l52256/l
\det=/l52257/l
\diamond=/l52258/l
\diamondsuit=/l52259/l
\dim=/l52260/l
\dimen=/l52261/l
\dimendef=/l52262/l
\discretionary=/l52263/l
\displayindent=/l52264/l
\displaylimits=/l52265/l
\displaylines=/l52266/l
\displaystyle=/l52267/l
\displaywidowpenalty=/l52268/l
\displaywidth=/l52269/l
\div=/l52270/l
\divide=/l52271/l
\do=/l52272/l
\dospecials=/l52273/l
\dosupereject=/l52274/l
\dot=/l52275/l
\doteq=/l52276/l
\dotfill=/l52277/l
\dots=/l52278/l
\doublehyphendemerits=/l52279/l
\downarrow=/l52280/l
\Downarrow=/l52281/l
\downbracefill=/l52282/l
\dp=/l52283/l
\dummy=/l52284/l
\dump=/l52285/l
\edef=/l52286/l
\egroup=/l52287/l
\eightpoint=/l52288/l
\eject=/l52289/l
\ell=/l52290/l
\else=/l52291/l
\emergencystretch=/l52292/l
\empty=/l52293/l
\emptyset=/l52294/l
\end=/l52295/l
\endchapter=/l52296/l
\endcsname=/l52297/l
\endgraf=/l52298/l
\endgroup=/l52299/l
\endinput=/l52300/l
\endinsert=/l52301/l
\endletter=/l52302/l
\endline=/l52303/l
\endlinechar=/l52304/l
\endtemplate=/l52305/l
\enskip=/l52306/l
\enspace=/l52307/l
\epsilon=/l52308/l
\eqalign=/l52309/l
\eqalignno=/l52310/l
\eqno=/l52311/l
\equiv=/l52312/l
\errhelp=/l52313/l
\errmessage=/l52314/l
\errorcontextlines=/l52315/l
\errorstopmode=/l52316/l
\escapechar=/l52317/l
\eta=/l52318/l
\everycr=/l52319/l
\everydisplay=/l52320/l
\everyhbox=/l52321/l
\everyjob=/l52322/l
\everymath=/l52323/l
\everypar=/l52324/l
\everyvbox=/l52325/l
\exercise=/l52326/l
\exhyphenpenalty=/l52327/l
\exists=/l52328/l
\exp=/l52329/l
\expandafter=/l52330/l
\fam=/l52331/l
\fi=/l52332/l
\filbreak=/l52333/l
\finalhyphendemerits=/l52334/l
\firstmark=/l52335/l
\fiverm=/l52336/l
\flat=/l52337/l
\floatingpenalty=/l52338/l
\fmtname=/l52339/l
\fmtversion=/l52340/l
\folio=/l52341/l
\font=/l52342/l
\fontdimen=/l52343/l
\fontname=/l52344/l
\footins=/l52345/l
\footline=/l52346/l
\footnote=/l52347/l
\footnoterule=/l52348/l
\forall=/l52349/l
\frenchspacing=/l52350/l
\frown=/l52351/l
\fullhsize=/l52352/l
\fullline=/l52353/l
\futurelet=/l52354/l
\futurenonspacelet=/l52355/l
\gamma=/l52356/l
\Gamma=/l52357/l
\gcd=/l52358/l
\gdef=/l52359/l
\ge=/l52360/l
\geq=/l52361/l
\getfactor=/l52362/l
\gets=/l52363/l
\gg=/l52364/l
\global=/l52365/l
\globaldefs=/l52366/l
\glue=/l52367/l
\goodbreak=/l52368/l
\grave=/l52369/l
\H=/l52370/l
\halign=/l52371/l
\hang=/l52372/l
\hangafter=/l52373/l
\hangindent=/l52374/l
\hat=/l52375/l
\hbadness=/l52376/l
\hbar=/l52377/l
\hbox=/l52378/l
\headline=/l52379/l
\heartsuit=/l52380/l
\hfil=/l52381/l
\hfill=/l52382/l
\hfilneg=/l52383/l
\hfuzz=/l52384/l
\hglue=/l52385/l
\hideskip=/l52386/l
\hidewidth=/l52387/l
\hoffset=/l52388/l
\holdinginserts=/l52389/l
\hom=/l52390/l
\hookleftarrow=/l52391/l
\hookrightarrow=/l52392/l
\hphantom=/l52393/l
\hrule=/l52394/l
\hrulefill=/l52395/l
\hsize=/l52396/l
\hskip=/l52397/l
\hss=/l52398/l
\ht=/l52399/l
\hyphenation=/l52400/l
\hyphenchar=/l52401/l
\hyphenpenalty=/l52402/l
\i=/l52403/l
\ialign=/l52404/l
\if=/l52405/l
\ifcase=/l52406/l
\ifcat=/l52407/l
\ifdim=/l52408/l
\ifeof=/l52409/l
\iffalse=/l52410/l
\ifhbox=/l52411/l
\ifhmode=/l52412/l
\ifinner=/l52413/l
\ifmmode=/l52414/l
\ifnum=/l52415/l
\ifodd=/l52416/l
\iftrue=/l52417/l
\ifundefined=/l52418/l
\ifvbox=/l52419/l
\ifvmode=/l52420/l
\ifvoid=/l52421/l
\ifx=/l52422/l
\ignorespaces=/l52423/l
\Im=/l52424/l
\imath=/l52425/l
\immediate=/l52426/l
\in=/l52427/l
\inaccessible=/l52428/l
\indent=/l52429/l
\inf=/l52430/l
\infty=/l52431/l
\input=/l52432/l
\inputlineno=/l52433/l
\insert=/l52434/l
\insertpenalties=/l52435/l
\int=/l52436/l
\interdisplaylinepenalty=/l52437/l
\interfootnotelinepenalty=/l52438/l
\interlinepenalty=/l52439/l
\iota=/l52440/l
\it=/l52441/l
\item=/l52442/l
\itemitem=/l52443/l
\itfam=/l52444/l
\j=/l52445/l
\jmath=/l52446/l
\jobname=/l52447/l
\joinrel=/l52448/l
\jot=/l52449/l
\kappa=/l52450/l
\ker=/l52451/l
\kern=/l52452/l
\it\$,=/l52453/l
\|=/l52454/l
\L=/l52455/l
\lambda=/l52456/l
\Lambda=/l52457/l
\land=/l52458/l
\langle=/l52459/l
\language=/l52460/l
\lastbox=/l52461/l
\lastkern=/l52462/l
\lastpenalty=/l52463/l
\lastskip=/l52464/l
\LaTeX=/l52465/l
\lbrace=/l52466/l
\lbrack=/l52467/l
\lccode=/l52468/l
\lceil=/l52469/l
\ldotp=/l52470/l
\ldots=/l52471/l
\le=/l52472/l
\leaders=/l52473/l
\leavevmode=/l52474/l
\left=/l52475/l
\leftarrow=/l52476/l
\Leftarrow=/l52477/l
\leftarrowfill=/l52478/l
\leftharpoondown=/l52479/l
\leftharpoonup=/l52480/l
\lefthyphenmin=/l52481/l
\leftline=/l52482/l
\leftrightarrow=/l52483/l
\Leftrightarrow=/l52484/l
\leftskip=/l52485/l
\leq=/l52486/l
\leqalignno=/l52487/l
\leqno=/l52488/l
\let=/l52489/l
\lfloor=/l52490/l
\lg=/l52491/l
\lgroup=/l52492/l
\lhook=/l52493/l
\lim=/l52494/l
\liminf=/l52495/l
\limits=/l52496/l
\limsup=/l52497/l
\line=/l52498/l
\linepenalty=/l52499/l
\lineskip=/l52500/l
\lineskiplimit=/l52501/l
\listing=/l52502/l
\ll=/l52503/l
\llap=/l52504/l
\lmoustache=/l52505/l
\ln=/l52506/l
\lnot=/l52507/l
\log=/l52508/l
\long=/l52509/l
\longindentation=/l52510/l
\longleftarrow=/l52511/l
\Longleftarrow=/l52512/l
\longleftrightarrow=/l52513/l
\Longleftrightarrow=/l52514/l
\longmapsto=/l52515/l
\longrightarrow=/l52516/l
\Longrightarrow=/l52517/l
\loop=/l52518/l
\looseness=/l52519/l
\lor=/l52520/l
\lower=/l52521/l
\lowercase=/l52522/l
\lq=/l52523/l
\m@ne=/l52524/l
\m@th=/l52525/l
\mag=/l52526/l
\magnification=/l52527/l
\magstep=/l52528/l
\magstephalf=/l52529/l
\maintoks=/l52530/l
\makefootline=/l52531/l
\makeheadline=/l52532/l
\makelabel=/l52533/l
\manfnt=/l52534/l
\manual=/l52535/l
\mapsto=/l52536/l
\mapstochar=/l52537/l
\margin=/l52538/l
\mark=/l52539/l
\mathaccent=/l52540/l
\mathbin=/l52541/l
\mathchar=/l52542/l
\mathchardef=/l52543/l
\mathchoice=/l52544/l
\mathclose=/l52545/l
\mathcode=/l52546/l
\mathhexbox=/l52547/l
\mathinner=/l52548/l
\mathop=/l52549/l
\mathopen=/l52550/l
\mathord=/l52551/l
\mathpalette=/l52552/l
\mathpunct=/l52553/l
\mathrel=/l52554/l
\mathstrut=/l52555/l
\mathsurround=/l52556/l
\matrix=/l52557/l
\max=/l52558/l
\maxdeadcycles=/l52559/l
\maxdepth=/l52560/l
\maxdimen=/l52561/l
\meaning=/l52562/l
\medbreak=/l52563/l
\medmuskip=/l52564/l
\medskip=/l52565/l
\medskipamount=/l52566/l
\medtype=/l52567/l
\message=/l52568/l
\mid=/l52569/l
\midinsert=/l52570/l
\min=/l52571/l
\mit=/l52572/l
\mkern=/l52573/l
\models=/l52574/l
\month=/l52575/l
\moveleft=/l52576/l
\moveright=/l52577/l
\mp=/l52578/l
\mskip=/l52579/l
\mu=/l52580/l
\multiply=/l52581/l
\multispan=/l52582/l
\muskip=/l52583/l
\muskipdef=/l52584/l
\nabla=/l52585/l
\narrower=/l52586/l
\natural=/l52587/l
\ne=/l52588/l
\nearrow=/l52589/l
\neg=/l52590/l
\negthinspace=/l52591/l
\neq=/l52592/l
\newbox=/l52593/l
\newcount=/l52594/l
\newdimen=/l52595/l
\newfam=/l52596/l
\newhelp=/l52597/l
\newif=/l52598/l
\newinsert=/l52599/l
\newlanguage=/l52600/l
\newlinechar=/l52601/l
\newmuskip=/l52602/l
\newread=/l52603/l
\newskip=/l52604/l
\newtoks=/l52605/l
\newwrite=/l52606/l
\next=/l52607/l
\ni=/l52608/l
\ninepoint=/l52609/l
\ninerm=/l52610/l
\ninesl=/l52611/l
\noalign=/l52612/l
\noboundary=/l52613/l
\nobreak=/l52614/l
\noexpand=/l52615/l
\noindent=/l52616/l
\nointerlineskip=/l52617/l
\nolimits=/l52618/l
\nonfrenchspacing=/l52619/l
\nonscript=/l52620/l
\nonstopmode=/l52621/l
\nopagenumbers=/l52622/l
\normalbaselines=/l52623/l
\normalbaselineskip=/l52624/l
\normalbottom=/l52625/l
\normallineskip=/l52626/l
\normallineskiplimit=/l52627/l
\not=/l52628/l
\notin=/l52629/l
\nu=/l52630/l
\null=/l52631/l
\nulldelimiterspace=/l52632/l
\nullfont=/l52633/l
\number=/l52634/l
\nwarrow=/l52635/l
\o=/l52636/l
\O=/l52637/l
\oalign=/l52638/l
\obeylines=/l52639/l
\obeyspaces=/l52640/l
\odot=/l52641/l
\oe=/l52642/l
\OE=/l52643/l
\offinterlineskip=/l52644/l
\oint=/l52645/l
\oldstyle=/l52646/l
\omega=/l52647/l
\Omega=/l52648/l
\omicron=/l52649/l
\ominus=/l52650/l
\omit=/l52651/l
\ooalign=/l52652/l
\openin=/l52653/l
\openout=/l52654/l
\openup=/l52655/l
\oplus=/l52656/l
\or=/l52657/l
\oslash=/l52658/l
\other=/l52659/l
\otimes=/l52660/l
\outer=/l52661/l
\output=/l52662/l
\outputpenalty=/l52663/l
\over=/l52664/l
\overbrace=/l52665/l
\overfullrule=/l52666/l
\overleftarrow=/l52667/l
\overline=/l52668/l
\overrightarrow=/l52669/l
\overwithdelims=/l52670/l
\owns=/l52671/l
\P=/l52672/l
\p@=/l52673/l
\p@renwd=/l52674/l
\pagebody=/l52675/l
\pagecontents=/l52676/l
\pagedepth=/l52677/l
\pagefilllstretch=/l52678/l
\pagefillstretch=/l52679/l
\pagefilstretch=/l52680/l
\pagegoal=/l52681/l
\pageinsert=/l52682/l
\pageno=/l52683/l
\pageshrink=/l52684/l
\pagestretch=/l52685/l
\pagetotal=/l52686/l
\par=/l52687/l
\parallel=/l52688/l
\parfillskip=/l52689/l
\parindent=/l52690/l
\parshape=/l52691/l
\parskip=/l52692/l
\partial=/l52693/l
\path=/l52694/l
\patterns=/l52695/l
\pausing=/l52696/l
\penalty=/l52697/l
\perp=/l52698/l
\phantom=/l52699/l
\phi=/l52700/l
\Phi=/l52701/l
\pi=/l52702/l
\Pi=/l52703/l
\plainoutput=/l52704/l
\pm|=/l52705/l
\pmatrix=/l52706/l
\pmod=/l52707/l
\pnt=/l52708/l
\postdisplaypenalty=/l52709/l
\Pr=/l52710/l
\prec=/l52711/l
\preceq=/l52712/l
\predisplaypenalty=/l52713/l
\predisplaysize=/l52714/l
\preloaded=/l52715/l
\pretolerance=/l52716/l
\prevdepth=/l52717/l
\prevgraf=/l52718/l
\prime=/l52719/l
\proclaim=/l52720/l
\prod=/l52721/l
\propto=/l52722/l
\ps=/l52723/l
\psi=/l52724/l
\Psi=/l52725/l
\qquad=/l52726/l
\quad=/l52727/l
\rm=/l52728/l
\radical=/l52729/l
\raggedbottom=/l52730/l
\raggedcenter=/l52731/l
\raggedright=/l52732/l
\raise=/l52733/l
\rangle=/l52734/l
\rbrace=/l52735/l
\rbrack=/l52736/l
\rceil=/l52737/l
\Re=/l52738/l
\read=/l52739/l
\relax=/l52740/l
\relbar=/l52741/l
\Relbar=/l52742/l
\relpenalty=/l52743/l
\removelastskip=/l52744/l
\repeat=/l52745/l
\rfloor=/l52746/l
\rgroup=/l52747/l
\rho=/l52748/l
\rhook=/l52749/l
\right=/l52750/l
\rightarrow=/l52751/l
\Rightarrow=/l52752/l
\rightarrowfill=/l52753/l
\rightharpoondown=/l52754/l
\rightharpoonup=/l52755/l
\righthyphenmin=/l52756/l
\rightleftharpoons=/l52757/l
\rightline=/l52758/l
\rightskip=/l52759/l
\rlap=/l52760/l
\rm=/l52761/l
\rmoustache=/l52762/l
\romannumeral=/l52763/l
\root=/l52764/l
\rq=/l52765/l
\S=/l52766/l
\sb=/l52767/l
\sc=/l52768/l
\scriptfont=/l52769/l
\scriptscriptfont=/l52770/l
\scriptscriptstyle=/l52771/l
\scriptspace=/l52772/l
\scriptstyle=/l52773/l
\scrollmode=/l52774/l
\searrow=/l52775/l
\sec=/l52776/l
\setbox=/l52777/l
\setlanguage=/l52778/l
\setminus=/l52779/l
\settabs=/l52780/l
\setupverbatim=/l52781/l
\sevenrm=/l52782/l
\sfcode=/l52783/l
\sharp=/l52784/l
\shipout=/l52785/l
\show=/l52786/l
\showbox=/l52787/l
\showboxbreadth=/l52788/l
\showboxdepth=/l52789/l
\showhyphens=/l52790/l
\showlists=/l52791/l
\showthe=/l52792/l
\sigma=/l52793/l
\Sigma=/l52794/l
\signed=/l52795/l
\sim=/l52796/l
\simeq|=/l52797/l
\sin=/l52798/l
\sinh=/l52799/l
\skew=/l52800/l
\skewchar=/l52801/l
\skip=/l52802/l
\skipdef=/l52803/l
\sl=/l52804/l
\slash=/l52805/l
\slfam=/l52806/l
\smallbreak=/l52807/l
\smallint=/l52808/l
\smallskip=/l52809/l
\smallskipamount=/l52810/l
\smalltype=/l52811/l
\smash=/l52812/l
\smile=/l52813/l
\sp=/l52814/l
\space=/l52815/l
\spacefactor=/l52816/l
\spaceskip=/l52817/l
\spadesuit=/l52818/l
\span=/l52819/l
\special=/l52820/l
\splitbotmark=/l52821/l
\splitfirstmark=/l52822/l
\splitmaxdepth=/l52823/l
\splittopskip=/l52824/l
\sqcap=/l52825/l
\sqcup=/l52826/l
\sqrt=/l52827/l
\sqsubseteq=/l52828/l
\sqsupseteq=/l52829/l
\square=/l52830/l
\ss=/l52831/l
\star=/l52832/l
\string=/l52833/l
\strut=/l52834/l
\strutbox=/l52835/l
\subset=/l52836/l
\subseteq=/l52837/l
\succ=/l52838/l
\succeq=/l52839/l
\sum=/l52840/l
\sum$'$=/l52841/l
\sup=/l52842/l
\supereject=/l52843/l
\supset=/l52844/l
\supseteq=/l52845/l
\surd=/l52846/l
\swarrow=/l52847/l
\t=/l52848/l
\tabalign=/l52849/l
\tabs=/l52850/l
\tabskip=/l52851/l
\tan=/l52852/l
\tanh=/l52853/l
\tau=/l52854/l
\tenex=/l52855/l
\tenpoint=/l52856/l
\tenrm=/l52857/l
\tensl=/l52858/l
\tensy=/l52859/l
\TeX=/l52860/l
\textfont=/l52861/l
\textindent=/l52862/l
\textstyle=/l52863/l
\the=/l52864/l
\theta=/l52865/l
\Theta=/l52866/l
\thickmuskip=/l52867/l
\thinmuskip=/l52868/l
\thinspace=/l52869/l
\tilde=/l52870/l
\time=/l52871/l
\times=/l52872/l
\to=/l52873/l
\today=/l52874/l
\toks=/l52875/l
\toksdef=/l52876/l
\tolerance=/l52877/l
\top=/l52878/l
\topglue=/l52879/l
\topins=/l52880/l
\topinsert=/l52881/l
\topmark=/l52882/l
\topskip=/l52883/l
\tracingall=/l52884/l
\tracingcommands=/l52885/l
\tracinglostchars=/l52886/l
\tracingmacros=/l52887/l
\tracingonline=/l52888/l
\tracingoutput=/l52889/l
\tracingpages=/l52890/l
\tracingparagraphs=/l52891/l
\tracingrestores=/l52892/l
\tracingstats=/l52893/l
\triangle=/l52894/l
\triangleleft=/l52895/l
\triangleright=/l52896/l
\tt=/l52897/l
\ttfam=/l52898/l
\ttglue=/l52899/l
\ttraggedright=/l52900/l
\u=/l52901/l
\uccode=/l52902/l
\uchyph=/l52903/l
\uncatcodespecials=/l52904/l
\undefined=/l52905/l
\underbar=/l52906/l
\underbrace=/l52907/l
\underline=/l52908/l
\unhbox=/l52909/l
\unhcopy=/l52910/l
\unkern=/l52911/l
\unpenalty=/l52912/l
\unskip=/l52913/l
\unvbox=/l52914/l
\unvcopy=/l52915/l
\up=/l52916/l
\uparrow=/l52917/l
\Uparrow=/l52918/l
\updownarrow=/l52919/l
\Updownarrow=/l52920/l
\uplus=/l52921/l
\uppercase=/l52922/l
\upsilon=/l52923/l
\Upsilon=/l52924/l
\v=/l52925/l
\vadjust=/l52926/l
\valign=/l52927/l
\varepsilon=/l52928/l
\varphi=/l52929/l
\varpi=/l52930/l
\varrho=/l52931/l
\varsigma=/l52932/l
\vartheta=/l52933/l
\vbadness=/l52934/l
\vbox=/l52935/l
\vcenter=/l52936/l
\vdash=/l52937/l
\vdots=/l52938/l
\vec=/l52939/l
\vee=/l52940/l
\vert=/l52941/l
\Vert=/l52942/l
\vfil=/l52943/l
\vfill=/l52944/l
\vfilll=/l52945/l
\vfilneg=/l52946/l
\vfootnote=/l52947/l
\vfuzz=/l52948/l
\vglue=/l52949/l
\voffset=/l52950/l
\voidb@x=/l52951/l
\vphantom=/l52952/l
\vrule=/l52953/l
\vsize=/l52954/l
\vskip=/l52955/l
\vsplit=/l52956/l
\vss=/l52957/l
\vtop=/l52958/l
\wd=/l52959/l
\wedge=/l52960/l
\widehat=/l52961/l
\widetilde|=/l52962/l
\widowpenalty=/l52963/l
\wlog=/l52964/l
\wp=/l52965/l
\wr=/l52966/l
\write=/l52967/l
\xdef=/l52968/l
\xi=/l52969/l
\Xi=/l52970/l
\xleaders=/l52971/l
\xspaceskip=/l52972/l
\xyzzy=/l52973/l
\year=/l52974/l
\z@=/l52975/l
\z@skip=/l52976/l
\zet=/l52977/l


// Definitions of spelling checking in command parameters
[spellchecking\params]
// LaTeX
\addcontentsline{0}{0}{1}
\address{1}
\addtocontents{0}{1}
\addtocounter{0}{0}
\addtolength{0}{0}
\addvspace{0}
\alph{0}
\Alph{0}
\arabic{0}
\author{1}
\bibitem[0]{1}
\bibliography{0}
\bibliographystyle{0}
\caption{1}
\cc{1}
\chapter[1]{1}
\chapter*[1]{1}
\circle[0]{0}
\cite[1]{0}
\cline{0}
\closing{1}
\dashbox{0}(0){1}
\date{1}
\documentclass[0]{1}
\encl{1}
\enlargethispage{0}
\enlargethispage*{0}
\fbox{1}
\fnsymbol{0}
\fontencoding{0}
\fontfamily{0}
\fontseries{0}
\fontshape{0}
\fontsize{0}{0}
\footnote[0]{1}
\footnotemark[0]
\footnotetext[0]{1}
\frac{0}{0}
\frame{1}
\framebox[0][0]{1}
\framebox(0)[0]{1}
\hspace[0]{1}
\hyphenation{0}
\include{0}
\includeonly{0}
\input{0}
\label{0}
\line(0){0}
\linebreak[0]
\linethickness{1}
\location{1}
\makebox[0][0]{1}
\makebox(0)[0]{1}
\markboth{1}{1}
\markright{1}
\mathversion{0}
\mbox{1}
\multicolumn{0}{0}{1}
\multiput(0)(0)[0]{1}
\name{1}
\newcommand{0}[0][0]{1}
\newcounter{0}[0]
\newenvironment{0}[0][0]{1}{1}
\newfont{0}{0}
\newlength{0}
\newsavebox{0}
\newtheorem{0}{1}[0]
\newtheorem{0}[0]{1}
\nocite{0}
\nolinebreak[0]
\nopagebreak[0]
\opening{1}
\oval(0)[0]
\overbrace{0}
\overline{0}
\pagebreak[0]
\pagenumbering{0}
\pageref{0}
\pagestyle{0}
\paragraph[1]{1}
\paragraph*[1]{1}
\parbox[0][0][0]{0}{1}
\put(0){1}
\raisebox{0}[0][0]{1}
\ref{0}
\refstepcounter{0}
\roman{0}
\Roman{0}
\rule[0]{0}{0}
\savebox{0}[0][0]{1}
\sbox{0}{1}
\setcounter{0}{0}
\setlength{0}{0}
\settodepth{0}{0}
\settoheight{0}{0}
\settowidth{0}{0}
\shortstack[0]{1}
\signature{1}
\sqrt{0}
\stepcounter{1}
\subparagraph[1]{1}
\subparagraph*[1]{1}
\section[1]{1}
\section*[1]{1}
\subsection[1]{1}
\subsection*[1]{1}
\subsubsection[1]{1}
\subsubsection*[1]{1}
\symbol{0}
\telephone{0}
\thanks{1}
\thispagestyle{0}
\title{1}
\twocolumn[1]
\typein[0]{1}
\typeout{1}
\underbrace{0}
\underline{0}
\usebox{0}
\usecounter{0}
\usefont{0}{0}{0}{0}
\usepackage[0]{0}
\value{0}
\vector(0){0}
\vspace[0]{0}
\begin{array}{0}
\begin{figure}[0]
\begin{list}{0}{0}
\begin{lrbox}{0}
\begin{minipage}[0]{0}
\begin{picture}(0)(0)
\begin{table}[0]
\begin{tabular}[0]{0}
\begin{tabular*}{0}[0]{0}
\begin{thebibliography}{0}


[ParagraphBreak]
%
$$
&
\address
\appendix
\author
\begin{
\bigskip
\chapter
\date
\documentclass
\end{
\include
\input
\medskip
\new
\noident
\package
\part
\preface
\renew
\section
\smallskip
\subsection
\subsubsection
\subsubsubsection
\thanks
\title
\usepackage
\vspace


[ParagraphStart]
\indent
\item


[CodeTree]
\documentclass \begin{document} \end{document}
\begin \end
\begin{array} \end{array}
\begin{center} \end{center}
\begin{description} \end{description}
\begin{enumerate} \end{enumerate}
\begin{eqnarray} \end{eqnarray}
\begin{equation} \end{equation}
\begin{figure} \end{figure}
\begin{flushleft} \end{flushleft}
\begin{flushright} \end{flushright}
\begin{itemize} \end{itemize}
\begin{letter} \end{letter}
\begin{list} \end{list}
\begin{lrbox} \end{lrbox}
\begin{minipage} \end{minipage}
\begin{picture} \end{picture}
\begin{quotation} \end{quotation}
\begin{quote} \end{quote}
\begin{tabbing} \end{tabbing}
\begin{table} \end{table}
\begin{tabular} \end{tabular}
\begin{tabular*} \end{tabular*}
\begin{thebibliography} \end{thebibliography}
\begin{theorem} \end{theorem}
\begin{titlepage} \end{titlepage}
\begin{verbatim} \end{verbatim}
\begin{verse} \end{verse}
{ }
 
[CodeTreeCascade]
\part \chapter \section \subsection \subsubsection \subsubsubsection



// Defines max. 4 types of modes
// All delimiters must be also defined in hilihgt
[env1]
name=LaTeX.Verbatim
wrapline=no
usethesaurus=no
spellchecking=yes
showsyntax=no
backcolor=15461355
fontcolor=0
\begin{verbatim} \end{verbatim}

[env2]
name=TeX.MathMode
wrapline=yes
usethesaurus=no
spellchecking=no
showsyntax=yes
backcolor=16771297
fontcolor=0
$
$$

[env3]
name=LaTeX.MathMode
wrapline=no
usethesaurus=no
spellchecking=no
showsyntax=yes
backcolor=16771297
fontcolor=0
\begin{equation} \end{equation}
\[ \]

[env4]
name=LaTeX.Environments
wrapline=no
usethesaurus=yes
spellchecking=yes
showsyntax=yes
backcolor=16772597
fontcolor=0
\begin{figure} \end{figure}
\begin{table} \end{table}
\begin{tabular} \end{tabular}
\begin{tabular*} \end{tabular*}



// This section defines commands related to the group of files
// Syntaxt of the row:
//     name     - command name (nicetext)
//     bitmap   - bitmap code from resources
//     shortcut - hotkey 
//     label    - (nicetext)
//     hint     - (nicetext)
//     command  - command to execute
//
// Command syntax:
//     exec:nicetext - execute nicetext
//     ins:nicetext' - insert nicetext to the editor window (_ denotes cursor position)
//
// Predefined constants:
//     <PROGRAMDIR>       - LEd directory
//     <PROJECT>          - full path of the project, e.g., C:\Papers\Newest.lpr
//     <PROJECTDIR>       - project directory, e.g., C:\Papers
//     <PROJECTNAME>      - project name, e.g., Newest
//     <PROJECTNAMEEXT>   - project name with extension, e.g., Newest.lpr
//     <MAINFILE>         - full path to the main project file, e.g., C:\Papers\Main.tex
//     <MAINFILEDIR>      - directory name of the main project file, e.g., C:\Papers
//     <MAINFILENAME>     - main file name, e.g., Main
//     <MAINFILENAMEEXT>  - main file name with extension, e.g., Main.tex
//     <FILE>             - full path to the selected file
//     <FILEDIR>          - directory of the selected file
//     <FILENAME>         - selected file name
//     <FILENAMEEXT>      - selected file name with extension
//     <BatchesDir>       - directory with LEd batches
//     <DefinitionsDir>   - directory with LEd definitions
//     <DictionariesDir>  - directory with LEd dictionaries
//     <LanguagesDir>     - directory with LEd language resources
//     <ProjectsDir>      - default LEd directory for projects
//     <TemplatesDir>     - directory with LEd templates
//     <ResourcesDir>     - directory with LEd resources
[commands]

// Example for syntaxt hilighting for the group of files
[syntaxexample\LaTeXKeys,LaTeXLabels,LaTeXComments]
=\documentclass{book}
=
=\title{/l51901/l}
=\author{/l51902/l}
=
=\begin{document}
=\maketitle
=
=% *************** /l51903/l ***************
=\nocite{*}
=\bibliographystyle{plain}
={\small\bibliography{book}}
=
=\section{/l51904/l}
=\label{sec:/l51904/l}
=\end{document}

[hilightexample\LaTeXLabels]
sec:introduction

[syntaxexample\TeXKeys]
=\centerline{\titlefont /l52991/l}
=\vskip 18pt
=\centerline{\problemfont /l52992/l 1.\quad /l52993/l}
=\titletrue
=
=\N{3}{1}/l52994/l

[syntaxexample\UserDefinedKeys]
=\newcommand{\filename}[1]{\textsf{#1}}

[hilight\UserDefinedKeys]
\filename
