/***************************************************************************
** Although considerable effort has been expended to make this software   **
** correct and reliable, no warranty is implied; the author disclaims any **
** obligation or liability for damages, including but not limited to      **
** special, indirect, or consequential damages arising out of or in       **
** connection with the use or performance of this software.               **
***************************************************************************/

/*
 *	This file contains VMS logical name functions.
 */

#include descrip
#include lnmdef
#include "vms.h"

#include "strng.p"

/*
 *	Routine Translate_VMS_Logical_Name translates a logical name
 *	to it's equivalent name. Only one translation is done.
 */

int Translate_VMS_Logical_Name (Logical_Name, Equivalence_Name, Eqv_Name_Len)
char *Logical_Name, *Equivalence_Name;
unsigned short Eqv_Name_Len;
{
	auto   unsigned long Sys_Status;
	static unsigned long Attr, Attr_Value;
	static unsigned short Length;
	static struct dsc$descriptor Log_Desc, Tab_Desc;
	static struct Item_List I_List[] = {
		{ 0, LNM$_STRING, 0, &Length },
		{ 4, LNM$_ATTRIBUTES, &Attr_Value, 0 },
		{ 0, 0, 0, 0 }
	};
	extern unsigned long Sys$TrnLNm();
	extern int Check_System_Status();
	globalvalue SS$_NOLOGNAM;

	Make_VMS_Descriptor (Logical_Name, &Log_Desc);
	Make_VMS_Descriptor ("LNM$DCL_LOGICAL", &Tab_Desc);
	I_List[0].Buffer_Len = Eqv_Name_Len - 1;
	I_List[0].Buffer_Addr = Equivalence_Name;
	Attr = LNM$M_CASE_BLIND;
	Sys_Status = Sys$TrnLNm (&Attr, &Tab_Desc, &Log_Desc, 0, I_List);
	if (Sys_Status == SS$_NOLOGNAM || (Attr_Value & LNM$M_CONCEALED) != 0) {
		stringcpy_m (Equivalence_Name, Logical_Name, Eqv_Name_Len);
		return (0);
	}
	Check_System_Status (Sys_Status);
	Equivalence_Name[Length] = '\0';
	return (((Attr_Value & LNM$M_TERMINAL) == 0) ? 1 : 2);
}
