/***************************************************************************
** Although considerable effort has been expended to make this software   **
** correct and reliable, no warranty is implied; the author disclaims any **
** obligation or liability for damages, including but not limited to      **
** special, indirect, or consequential damages arising out of or in       **
** connection with the use or performance of this software.               **
***************************************************************************/

/*
 *	This file contains the device configuration initialization
 *	and is the only place where actual devices are known about
 *	(outside of the device drivers, that is).
 */

#include "types.h"
#include "devtab.h"

/*
 *	The (patchable) place where TFM and pixel files are:
 */

char TeX_TFM_Dir[64] = "TEX_FONTS:";
char Black_PXL_Dir[64] = "TEX_IM_PIXEL:";

extern int NL_Set_Layout();
extern int NL_Terminate();
extern int NL_Setup_New_Page();
extern int NL_Eject_Page();
extern int NL_Download_Font();
extern int NL_Typeset_String();
extern int NL_Typeset_Pixel();
extern int NL_Typeset_Rule();
extern int NL_Typeset_Filled();
extern int NL_Typeset_Line();
extern int NL_Typeset_Point();
extern int NL_Typeset_Arc();
extern int NL_Set_Linewidth();
extern int NL_Set_Linestyle();
extern int NL_Set_Color();
extern int NL_Save_Graphics();
extern int NL_Restore_Graphics();

extern int PS_Set_Layout();
extern int PS_Terminate();
extern int PS_Setup_New_Page();
extern int PS_Eject_Page();
extern int PS_Download_Font();
extern int PS_Typeset_String();
extern int PS_Typeset_Pixel();
extern int PS_Typeset_Rule();
extern int PS_Typeset_Filled();
extern int PS_Typeset_Line();
extern int PS_Typeset_Point();
extern int PS_Typeset_Arc();
extern int PS_Set_Linewidth();
extern int PS_Set_Linestyle();
extern int PS_Set_Color();
extern int PS_Save_Graphics();
extern int PS_Restore_Graphics();

extern int IM_Set_Layout();
extern int IM_Terminate();
extern int IM_Setup_New_Page();
extern int IM_Eject_Page();
extern int IM_Download_Font();
extern int IM_Typeset_String();
extern int IM_Typeset_Pixel();
extern int IM_Typeset_Rule();
extern int IM_Typeset_Filled();
extern int IM_Typeset_Line();
extern int IM_Typeset_Point();
extern int IM_Typeset_Arc();
extern int IM_Set_Linewidth();
extern int IM_Set_Linestyle();
extern int IM_Set_Color();
extern int IM_Save_Graphics();
extern int IM_Restore_Graphics();

extern int TK_Set_Layout();
extern int TK_Terminate();
extern int TK_Setup_New_Page();
extern int TK_Eject_Page();
extern int TK_Download_Font();
extern int TK_Typeset_String();
extern int TK_Typeset_Pixel();
extern int TK_Typeset_Rule();
extern int TK_Typeset_Filled();
extern int TK_Typeset_Line();
extern int TK_Typeset_Point();
extern int TK_Typeset_Arc();
extern int TK_Set_Linewidth();
extern int TK_Set_Linestyle();
extern int TK_Set_Color();
extern int TK_Save_Graphics();
extern int TK_Restore_Graphics();

char *PS_Font_Prefix[] = { "ps", 0 };
char *No_Font_Prefix[] = { 0 };

struct Device_Table Device_Table[] = {

	{ "NULL",
	  0,
	  0,
	  0,
	  { 300, 1 },
	  { 1, 1 },
	  { 1, 1 },
	  &Black_PXL_Dir[0],
	  &No_Font_Prefix[0],
	  &NL_Set_Layout,
	  &NL_Terminate,
	  &NL_Setup_New_Page,
	  &NL_Eject_Page,
	  &NL_Download_Font,
	  &NL_Typeset_String,
	  &NL_Typeset_Pixel,
	  &NL_Typeset_Rule,
	  &NL_Typeset_Filled,
	  &NL_Typeset_Line,
	  &NL_Typeset_Point,
	  &NL_Typeset_Arc,
	  &NL_Set_Linewidth,
	  &NL_Set_Linestyle,
	  &NL_Set_Color,
	  &NL_Save_Graphics,
	  &NL_Restore_Graphics	},

	{ "APPLE_LASERWRITER",
	  170,		/* Plain vanilla LaserWriter, not LaserWriter-Plus */
	  87,
	  0,
	  { 300, 1 },
	  { 1, 1 },
	  { 8, 1 },
	  &Black_PXL_Dir[0],
	  &PS_Font_Prefix[0],
	  &PS_Set_Layout,
	  &PS_Terminate,
	  &PS_Setup_New_Page,
	  &PS_Eject_Page,
	  &PS_Download_Font,
	  &PS_Typeset_String,
	  &PS_Typeset_Pixel,
	  &PS_Typeset_Rule,
	  &PS_Typeset_Filled,
	  &PS_Typeset_Line,
	  &PS_Typeset_Point,
	  &PS_Typeset_Arc,
	  &PS_Set_Linewidth,
	  &PS_Set_Linestyle,
	  &PS_Set_Color,
	  &PS_Save_Graphics,
	  &PS_Restore_Graphics	},

	{ "PS300",	/* Generic PostScript, 300 dpi */
	  512,
	  100,
	  0,
	  { 300, 1 },
	  { 1, 1 },
	  { 8, 1 },
	  &Black_PXL_Dir[0],
	  &PS_Font_Prefix[0],
	  &PS_Set_Layout,
	  &PS_Terminate,
	  &PS_Setup_New_Page,
	  &PS_Eject_Page,
	  &PS_Download_Font,
	  &PS_Typeset_String,
	  &PS_Typeset_Pixel,
	  &PS_Typeset_Rule,
	  &PS_Typeset_Filled,
	  &PS_Typeset_Line,
	  &PS_Typeset_Point,
	  &PS_Typeset_Arc,
	  &PS_Set_Linewidth,
	  &PS_Set_Linestyle,
	  &PS_Set_Color,
	  &PS_Save_Graphics,
	  &PS_Restore_Graphics	},

	{ "PS600",	/* Generic PostScript, 600 dpi */
	  1024,
	  100,
	  0,
	  { 600, 1 },
	  { 1, 1 },
	  { 8, 1 },
	  &Black_PXL_Dir[0],
	  &PS_Font_Prefix[0],
	  &PS_Set_Layout,
	  &PS_Terminate,
	  &PS_Setup_New_Page,
	  &PS_Eject_Page,
	  &PS_Download_Font,
	  &PS_Typeset_String,
	  &PS_Typeset_Pixel,
	  &PS_Typeset_Rule,
	  &PS_Typeset_Filled,
	  &PS_Typeset_Line,
	  &PS_Typeset_Point,
	  &PS_Typeset_Arc,
	  &PS_Set_Linewidth,
	  &PS_Set_Linestyle,
	  &PS_Set_Color,
	  &PS_Save_Graphics,
	  &PS_Restore_Graphics	},

	{ "PS1200",	/* Generic PostScript, 1200 dpi */
	  1536,
	  100,
	  0,
	  { 1200, 1 },
	  { 1, 1 },
	  { 8, 1 },
	  &Black_PXL_Dir[0],
	  &PS_Font_Prefix[0],
	  &PS_Set_Layout,
	  &PS_Terminate,
	  &PS_Setup_New_Page,
	  &PS_Eject_Page,
	  &PS_Download_Font,
	  &PS_Typeset_String,
	  &PS_Typeset_Pixel,
	  &PS_Typeset_Rule,
	  &PS_Typeset_Filled,
	  &PS_Typeset_Line,
	  &PS_Typeset_Point,
	  &PS_Typeset_Arc,
	  &PS_Set_Linewidth,
	  &PS_Set_Linestyle,
	  &PS_Set_Color,
	  &PS_Save_Graphics,
	  &PS_Restore_Graphics	},

	{ "IMAGEN",	/* imPRESS in general, IMAGEN in particular */
	  512,
	  0,
	  0,
	  { 300, 1 },
	  { 1, 1 },
	  { 32, 32 },
	  &Black_PXL_Dir[0],
	  &No_Font_Prefix[0],
	  &IM_Set_Layout,
	  &IM_Terminate,
	  &IM_Setup_New_Page,
	  &IM_Eject_Page,
	  &IM_Download_Font,
	  &IM_Typeset_String,
	  &IM_Typeset_Pixel,
	  &IM_Typeset_Rule,
	  &IM_Typeset_Filled,
	  &IM_Typeset_Line,
	  &IM_Typeset_Point,
	  &IM_Typeset_Arc,
	  &IM_Set_Linewidth,
	  &IM_Set_Linestyle,
	  &IM_Set_Color,
	  &IM_Save_Graphics,
	  &IM_Restore_Graphics	},

	{ "TEK4014",	/* Tektronix 4014 graphics terminal */
	  0,
	  0,
	  0,
	  { 300, 1 },
	  { 1, 1 },
	  { 1, 1 },
	  &Black_PXL_Dir[0],
	  &No_Font_Prefix[0],
	  &TK_Set_Layout,
	  &TK_Terminate,
	  &TK_Setup_New_Page,
	  &TK_Eject_Page,
	  &TK_Download_Font,
	  &TK_Typeset_String,
	  &TK_Typeset_Pixel,
	  &TK_Typeset_Rule,
	  &TK_Typeset_Filled,
	  &TK_Typeset_Line,
	  &TK_Typeset_Point,
	  &TK_Typeset_Arc,
	  &TK_Set_Linewidth,
	  &TK_Set_Linestyle,
	  &TK_Set_Color,
	  &TK_Save_Graphics,
	  &TK_Restore_Graphics	},

	{ 0 }
};
