/* @(#)pk.h	3.1	11/16/89 */

#ifndef NO_PK

/*  ID byte value at the beginning of PK files  */
#define PK_ID       89

/*  PK op codes  */
#define PK_XXX1     240
#define PK_XXX2     241
#define PK_XXX3     242
#define PK_XXX4     243
#define PK_YYY      244
#define PK_POST     245
#define PK_NOP      246
#define PK_PRE      247

#define PK_REPEAT   0xe /*  Repeat last row - repeat count in next nibble  */
#define PK_AGAIN    0xf /*  Repeat only once  */
#define PK_LARGE    0x0 /*  Long run vaule coming up  */

/*  Macros for reading various size pieces from the PK file */

#define _READ		(getc(pkin))

#define UNSIGNED_1	_READ
#define SIGNED_1	((_READ << 24) >> 24)

#define UNSIGNED_2(tmp)	(tmp = _READ, (tmp << 8) | _READ)
#define SIGNED_2(tmp)	((UNSIGNED_2(tmp) << 16) >> 16)

#define UNSIGNED_3(tmp)	(tmp = UNSIGNED_2(tmp), (tmp << 8) | _READ)
#define SIGNED_3(tmp)	((UNSIGNED_3(tmp) << 8) >> 8)

/* since we have 4 byte int's, no sign extension is required... */
#define UNSIGNED_4(tmp)	(tmp = UNSIGNED_3(tmp), (tmp << 8) | _READ)
#define SIGNED_4(tmp)	UNSIGNED_4(tmp)

#endif NO_PK
