DVI2PS           **** Programmer's Manual            DVI2PS


NAME
     dvi2ps  - convert a DVI file to PostScript  (PostScript is a trademark
              of Adobe Systems, Inc).

SYNOPSIS

     dvi2ps [-a pxldir] [-c] [-d n] [-f n] [-h] [-i file] [-m n] [-n n] 
            [-o str] [-p] [-q] [-r] [-s] [-t n] dvifile[.dvi]


DESCRIPTION

     This program converts a DVI file to PostScript, and writes the result
     to standard output.  The result requires a small amount of PostScript
     source to precede it to the printer, before it can be successfully printed.
     (By default, that PostScript code is prepended to the output).

ARGUMENTS


     -a pxldir  - specify different area for PXL files.
          Specifying "-a pxldir" causes directory "pxldir" to be searched
          for all pxl files, instead of the default directory.

     -c         - create an output file in the spool directory.
          This is fairly Apollo-specific, and may be disabled at other
          sites.  When given, the output is directed to a file with
          a unique name, created in a spool directory.

     -d n       - select resolution (300 dpi is default, 600 is possible.)
          Use of the flag value -d 600 brings in the header file tex6.ps
          Also select debugging output if program was compiled with -DDEBUG.

     -f n       - specify a starting page number.
          (this is a TeX page number -- \count0).

     -h         - do not copy the standard header file.
          This option prevents the standard PostScript header file being
          prepended to the output.

     -i file    - copy the named file to the output
          The contents of the file named will be copied to the output
          after the standard header file has been copied.

     -m0 | -mh | -m1 | -m2 | -m3 | -m4
          specify a magstep to use to print the document.  This overrides
          whatever might be in the DVI file.

     -m n specify a magnification to use to print the document.  This should
          probably be one of the magic numbers 1000, 1095, 1200, 1440, 1728,
          but no checking is done.  Note: if your site does not have the
          complete set of 300 dpi fonts, this option might be disabled.

     -n n       - specify the number of copies to print

     -o str     - specify an printing option.
          valid options are "letter", "note", "legal", "landscape" and
          "manualfeed" (without the quotes).  This argument may be repeated 
          several times.

     -p         - do not preload font information.
          Occasionally there may be insufficent memory to hold the
          information about all of the fonts in the system.  Portions
          of the document may be converted by including the -p option
          on the command line.  This will prevent the preloading of
          all fonts into the system and instead use demand loading of
          the font tables. 

     -q         - be quiet.
          Don't chatter about pages converted, etc.
         
     -r         - stack pages in reverse order.  
          Normally, the DVI pages are processed in reverse order, with the
          result that they are stacked in the correct order in the output
          tray.  This option reverses that.

     -s         - turn on printing of statistics.
          Some versions of dvi2ps will optionally print statistics about
          font usage and some other information that is generally only 
          interesting to developers.  On these systems, -s turns on
          the statistics printing.

     -t n specify an ending page number.

     -w   Don't print out warnings.

NOTES

     This is a `bare bones' DVI-to-PostScript program.  Minimal error
     checking is done.

     Not all fonts are available in the resolution needed to display on the 
     laser printer;  when a missing font is encountered, dvi2ps will continue 
     to process your dvi file, and and will log a warning message. Gaps will 
     appear in the document where the missing characters should have been.

     It can take up to 60 seconds for the first page to be output.  After a
     head of steam has been built up, it can roll along at 5-10 seconds
     per page.

     TeX "\special" command:
     -----------------------

     This program supports use of the "\special" command in TeX to include
     special PostScript code for graphics, etc.  Specifying
     "\special{psfile=foo.ps}" in the TeX source will result in the contents
     of file "foo.ps" (assumed to contain PostScript code) being copied 
     into the output at that point.  For most included graphics, the
     users (0,0) point will be set to the point of the \special command
     with x and y coordinates increasing up and to the right and in units
     of PostScript points (72/inch) -- thus you must explicitly leave space
     above the \special command for most graphics.  For graphics produced by 
     Apple Macintoshes (i.e., MacDraw, MacPaint, etc.), the top left corner of 
     the drawing will be at the point of the \special command; in this case you 
     must leave the required space below the \special.

     The \special string can contain any number of the following 
     "keyword=value" pairs, seperated by blanks:

        Keyword         Value Type
        -------         ----------
        psfile          string          - specifies a PostScript file to include
        hsize           dimension       - specifies maximum horizontal size (for clipping)
        vsize           dimension       - specifies maximum vertical size (for clipping)
        hoffset         dimension       - specifies amount to shift right
        voffset         dimension       - specifies amount to shift up (or down, for MacDrwgs)
        hscale          number          - specifies a scale factor in x-dimension
        vscale          number          - specifies a scale factor in y-dimension

                        dimensions are given in PostScript points (72 per inch).

     THUS:  \special{psfile=foo.ps hoffset=72 hscale=0.9 vscale=0.9}

            will shift the graphics produced by file "foo.ps" right by
            1", and will draw it at 0.9 normal size.

      hsize and vsize are given relative to the (0,0) point of the drwg
      and are unaffected by offsets and scales.

      offsets are given relative to the point of the \special command,
      and are unaffected by scales.

      If Macintosh drawings are to be included, the proper laserprep file
      must be downloaded to the printer, either permanently or as another
      header file in addition to the standard "tex.ps" header file.



FILES
     *.dvi                       TeX DeVice Independent output file

     /local/tex/pxl300/%.%pxl    TeX default font rasters
     /local/lib/ps/tex.ps        PostScript support code.


SEE ALSO
     tex

BUGS
     Probably too numerous to mention.

     There is likely a limit to the size of documents that can be printed (at 
     least, on the Apple LaserWriter).  If you get VMerrors reported when 
     printing, use the '-f' and '-t' options, to select a range of pages.
     The exact limit is unknown, but is probably well in excess of 50 pages
     for "normal" documents, decreasing with number of different fonts used,
     size of fonts, etc.

     If the Mac LaserPrep file has been loaded, offsets, sizes and scales
     in \special{} will not work properly for non-Macintosh graphics (don't ask).

AUTHOR(s)
     Mark Senn wrote the early versions of this program for the
     BBN BitGraph.  Stephan Bechtolsheim, Bob Brown, Richard
     Furuta, James Schaad and Robert Wells improved it.  Norm
     Hutchinson ported the program to the Sun.  Neal Holtz ported
     it to the Apollo, and then to produce PostScript.

Printed 9/21/85


