BINDIR = /usr/local/bin
LIBDIR = /usr/local/lib/tex/inputs

OBS = dvi.o dvirddvi.o dvipkch.o dvipkch2.o dvigr.o dvispec.o dviclip.o \
	  dvisplin.o dvidraw.o dvithin.o dvirdimg.o dvimisc.o dvirdpk.o \
	  dviapoll.o dvicmd.o dviver.o dvigr1.o dvifx80.o dvinecp6.o \
	  dvihplj.o dvifram.o dvibj300.o dvisend.o dviterm.o dvimem.o \
	  dviipr.o dviimg.o

LWOBS = dvilw.o dvimem.o dviipr.o dviver.o dviadobe.o dlwpkch.o dvirddvi.o \
		dvirdpk.o dvimisc.o dvigr.o dvigr1.o dlwsplin.o dvispec.o \
		dvirdimg.o dlwimg.o dviterm.o

CC = /bin/cc
CFLAGS = -O -Dapollo -DUNIX -DPK_FULLCONFIG
INSTALL = install -c -m 755
INSTFLAGS = -o wilhelms -g info 

#
# Set APOLLOCCFLAGS to empty when using gcc
# APOLLOCCFLAGS =
APOLLOCCFLAGS = -A ansi -W0,-info,2 

all : dvi dvilw

unix:
	crlf -r *.c *.h *.ps *.map 

dos:
	crlf -i *.c *.h *.ps *.map

dvi : $(OBS)
	$(CC) -o dvi $(OBS)

dvilw : $(LWOBS)
	$(CC) -o dvilw $(LWOBS)

.c.o :
	$(CC) -c $(CFLAGS) $(APOLLOCCFLAGS) $*.c    

dvirddvi.o : dvirddvi.c
	$(CC) -c $(CFLAGS) $(APOLLOCCFLAGS) -DIN_MEMORY $*.c


dlwimg.o:   dvi.h dvilw.h
dlwpkch.o:  dvi.h dvilw.h
dlwsplin.o: dvi.h dvisplin.h dvilw.h
dvi.o:	    dvi.h dvisplin.h dviframe.h dvidraw.h dvidvi.h dvimisc.h dvihdcp.h
dviadobe.o: dvi.h
dviapoll.o: dvi.h dvihdcp.h dviframe.h
dviatari.o: dvi.h dvihdcp.h
dvibj300.o: dvi.h dvihdcp.h dviframe.h
dviclip.o:  dvi.h dvisplin.h dvidraw.h
dvicmd.o:   dvi.h dvidvi.h dvimisc.h dviframe.h dvihdcp.h dvisplin.h dvidraw.h
dvidir.o:	dvi.h dvilw.h
dvidraw.o:  dvi.h dvisplin.h dvidraw.h dviframe.h
dvifram.o:  dvi.h dviframe.h dvidvi.h
dvifx80.o:  dvi.h dvihdcp.h dviframe.h
dvigem.o:   dvi.h dvirsc.h dvihdcp.h dvimisc.h dvisplin.h dvidvi.h dviframe.h dvidraw.h
dvigr.o:    dvi.h dvisplin.h 
dvigr1.o:   dvi.h dvisplin.h
dvihplj.o:  dvi.h dvihdcp.h dviframe.h
dviibm.o:   dvi.h dvihdcp.h dviframe.h
dviimg.o:   dvi.h dviframe.h dvidvi.h
dviipr.o: 	dvi.h dvidef.h
dvilw.o:    dvi.h dvilw.h dvimisc.h dvisplin.h
dvimem.o:	dvi.h
dvimisc.o:  dvi.h dvimisc.h dvihdcp.h
dvimotif.o: dvi.h dvihdcp.h dvimisc.h dvisplin.h dvidvi.h dviframe.h dvidraw.h
dvinecp6.o: dvi.h dvihdcp.h dviframe.h
dvipkch.o:  dvi.h dviframe.h dvidvi.h
dvipkch2.o: dvi.h dviframe.h dvidvi.h dvisplin.h dvidraw.h
dvirddvi.o: dvi.h dvidef.h dvimisc.h
dvirdimg.o: dvi.h dvimisc.h
dvirdpk.o:  dvi.h dvimisc.h
dvisend.o:  dvi.h dvihdcp.h
dvispec.o:  dvi.h dvimisc.h
dvisplin.o: dvi.h dvisplin.h dvidraw.h
dviterm.o:	dvi.h
dvithin.o:  dvi.h dvihdcp.h dviframe.h
dviver.o:   dvi.h
dvix.o:     dvi.h dvihdcp.h dviframe.h

clean:
	rm -f *.o *.bak *.BAK dvi dvilw

install: dvi dvilw dvilw.ps dvilw.map
	$(INSTALL) $(INSTFLAGS) dvi $(BINDIR)
	$(INSTALL) $(INSTFLAGS) dvilw $(BINDIR)
	$(INSTALL) $(INSTFLAGS) dvilw.ps $(BINDIR)
	$(INSTALL) $(INSTFLAGS) dvilw.map $(BINDIR)


