/*************************************************************************************************
 *                      Modul: dvishrink.h                                                       *
 *                      Autor: Ulrich Lechner 9/1994                                             *
 *                                                                                               *
 *************************************************************************************************
*/
#define UTYPE unsigned int             
#undef  NORMFILTER                     /* Normalverteilte Filter oder Boxfilter      */
#define MAXWIDTHHEIGHT 8000            /* Maximale Breite und Hoehe der Bitmap       */
#define MAXCOLORS      512             /* Maximale Zahl der Farben                   */
#define ENDCOL         16              /* Zahl der Farben im Zielbild. 2er-Potenzen! */
#define SRC            16              /* Maschenbreite des Gitters 8*n n=nat. Zahl  */
#define EXFACTOR       1               /* Vergroesserungsfaktor (1==keine Vergr.)    */
#define NUMFILTER  (SRC*EXFACTOR )     /* Zahl der Filter                            */
#define MAXPS       NUMFILTER          /* Laenge eines Verschiebungsvektors          */
#define MAXVALUE   (SRC*SRC)           /* Maximale Convolutions-Summe                */ 
#define VECTORXY   (NUMFILTER*2)       /* Vektorlaengen                              */
#define NUMTICKS    NUMFILTER          /* Zahl der Tickmarks der Skalierungsskala    */
#define MAX_VAL NUMTICKS               /* Maximalwert auf der Skala                  */
#define MIN_VAL 1                      /* Minimalwert auf der Skala                  */

struct Filter                          /* Filterstruktur                             */
{
        UTYPE dst;                     /* Zielgroesse <-> Quellgroesse               */
        UTYPE size_y;                  /* Groesse einer Filtereinheit in y-Richtung  */
        UTYPE size_x;                  /* Groesse einer Filtereinheit in x-Richtung  */
        UTYPE *cyss;                   /* Zeiger auf Verschiebung in y-Richtung      */
        UTYPE *cxss;                   /* Zeiger auf Verschiebung in x-Richtung      */
        UTYPE *data;                   /* Zeiger auf Filterdaten                     */
};

struct SrcBmp                          /* Quell-Bitmap-Struktur                      */
{
        unsigned char *frame_buffer;   /* Zeiger auf die Daten                       */
        int            frame_width;    /* Breite in Bytes                            */
        int            frame_height;   /* Hoehe in Zeilen                            */
};

#ifdef MOTIF
                                       /* Bitmaps fuer Piktogramme                   */
/* Arrow-Left-Bitmap
 */
#define arrow_left_width 32
#define arrow_left_height 16
static char arrow_left_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00,
   0xc0, 0x01, 0x00, 0x00, 0xe0, 0x01, 0x00, 0x00, 0xf0, 0xff, 0xff, 0x0f,
   0xf8, 0xff, 0xff, 0x07, 0xfc, 0xff, 0xff, 0x03, 0xfc, 0xff, 0xff, 0x03,
   0xf8, 0xff, 0xff, 0x07, 0xf0, 0xff, 0xff, 0x0f, 0xe0, 0x01, 0x00, 0x00,
   0xc0, 0x01, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00};

/* Arrow-Right-Bitmap
 */
#define arrow_right_width 32
#define arrow_right_height 16
static char arrow_right_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x80, 0x01,
   0x00, 0x00, 0x80, 0x03, 0x00, 0x00, 0x80, 0x07, 0xf0, 0xff, 0xff, 0x0f,
   0xe0, 0xff, 0xff, 0x1f, 0xc0, 0xff, 0xff, 0x3f, 0xc0, 0xff, 0xff, 0x3f,
   0xe0, 0xff, 0xff, 0x1f, 0xf0, 0xff, 0xff, 0x0f, 0x00, 0x00, 0x80, 0x07,
   0x00, 0x00, 0x80, 0x03, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x80, 0x00,
   0x00, 0x00, 0x00, 0x00};

/* Center-Bitmap 
 */   
#define center_width 32
#define center_height 16
static char center_bits[] = {
   0x00, 0x80, 0x01, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x80, 0x01, 0x00,
   0x00, 0xe0, 0x07, 0x00, 0x00, 0xc0, 0x03, 0x00, 0x00, 0x88, 0x11, 0x00,
   0x00, 0x18, 0x18, 0x00, 0x00, 0xbf, 0xfd, 0x00, 0x00, 0xbf, 0xfd, 0x00,
   0x00, 0x18, 0x18, 0x00, 0x00, 0x88, 0x11, 0x00, 0x00, 0xc0, 0x03, 0x00,
   0x00, 0xe0, 0x07, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x80, 0x01, 0x00,
   0x00, 0x80, 0x01, 0x00};
   
/* Update-Bitmap 
 */
#define update_width 32
#define update_height 16
static char update_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x7c, 0x00,
   0x00, 0x00, 0xd4, 0x00, 0x00, 0x00, 0xa8, 0x01, 0x01, 0x00, 0x50, 0x03,
   0x07, 0xff, 0xa0, 0x06, 0xfe, 0x01, 0x41, 0x1d, 0x78, 0x01, 0x82, 0x30,
   0x20, 0xff, 0x07, 0x60, 0xf0, 0x0f, 0x02, 0xc0, 0x10, 0x10, 0x01, 0x00,
   0x10, 0xa0, 0x00, 0x00, 0xf0, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00};

/* Frame-On-Bitmap 
 */   
#define f_on_width 64
#define f_on_height 16
static char f_on_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x01, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x08, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0x34, 0xd3, 0x86,
   0x01, 0xc7, 0x0d, 0x00, 0xf8, 0x98, 0x24, 0x49, 0xc2, 0x9d, 0x1b, 0x00,
   0x88, 0x08, 0x27, 0xc9, 0xc3, 0x98, 0x19, 0x00, 0x08, 0x88, 0x24, 0x49,
   0xc0, 0x98, 0x19, 0x00, 0x08, 0x88, 0x24, 0xc9, 0xc4, 0x9d, 0x19, 0x00,
   0x3c, 0x1c, 0x7b, 0x9b, 0x03, 0xc7, 0x3b, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
  
/* Frame-Off-Bitmap
 */
#define f_off_width 64
#define f_off_height 16
static char f_off_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x01, 0x00, 0x00,
   0x00, 0x00, 0xe7, 0x00, 0x08, 0x01, 0x00, 0x00, 0x00, 0x80, 0xb5, 0x00,
   0x08, 0x00, 0x00, 0x00, 0x00, 0x80, 0x31, 0x00, 0x88, 0x34, 0xd3, 0x86,
   0x01, 0xc7, 0xff, 0x00, 0xf8, 0x98, 0x24, 0x49, 0xc2, 0x9d, 0x31, 0x00,
   0x88, 0x08, 0x27, 0xc9, 0xc3, 0x98, 0x31, 0x00, 0x08, 0x88, 0x24, 0x49,
   0xc0, 0x98, 0x31, 0x00, 0x08, 0x88, 0x24, 0xc9, 0xc4, 0x9d, 0x31, 0x00,
   0x3c, 0x1c, 0x7b, 0x9b, 0x03, 0xc7, 0x7b, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

#endif

