/*
** Datei: DVIGEM.C
** Autor: Ingo Eichenseher
**        Gerhard Wilhelms, 27.8.92
*/

#include <stdio.h>
#ifdef __TURBOC__
#include <aes.h>
#include <vdi.h>
#include <ext.h>
#endif
#ifdef __ATARIGNU__
#define __OLD_WAY__
#include <osbind.h>
#include <aesbind.h>
#include <vdibind.h>
#define FIS_HOLLOW 0
#endif
#include <string.h>
#include <stdarg.h>
#include <setjmp.h>
#include <ctype.h>
#include <math.h>
#include <stdlib.h>
#include "dvi.h"
#include "dvidvi.h"
#include "dviframe.h"
#include "dvirsc.h"
#include "dvihdcp.h"
#include "dvimisc.h"
#include "dvisplin.h"
#include "dvidraw.h"

#define GEM_MAGIC   0x21021961l

#define REPAIR_TIME 250

#define WI_LINES 25
#define WI_COLS 80
#define WI_KIND (NAME|MOVER|SIZER|FULLER)
#define SC_KIND (NAME|MOVER|SIZER|CLOSER|FULLER|UPARROW|DNARROW|LFARROW|RTARROW|VSLIDE|HSLIDE)

#define EXTENSION "DVO"
#define LINKRSC 1

#define N_PATH   8      /* Anzahl Pfade im Pfadformular */
#define L_PATH      64      /* Maximale Laenge eines dieser Pfade */

#define MIN(a,b) ((a)<(b) ? (a):(b))
#define MAX(a,b) ((b)<(a) ? (a):(b))

#if LINKRSC
extern OBJECT  rs_objec[];
extern OBJECT *rs_trees[];
extern int     rs_nobs;
#endif

static OBJECT *menu, *sh_form, *path_form;
static int  ende, menu_changed=1, appl_id;
static int  wi_handle;
static int  sc_handle, sc_xoff=0, sc_yoff=0, sc_redraw=0, sc_open=0;
static int  sc_x, sc_y, sc_w, sc_h;
static char sc_name[80];
static int  gw, gh, bw, bh;
static int  vdi_handle;
static int  the_line;
static MFDB scr_mfdb = { 0l };
static int  work_in[12] = { 1,1,1,1,1,1,1,1,1,1,2 }, work_out[57];
static jmp_buf halt_jump;
static int  last_page = 0;
static char cwd[128]="";
static char wi_contents[WI_LINES][WI_COLS+1];
static int  monochrom=1, colors[2] = {1,0};
static int ped[N_PATH] = {PATHED1,PATHED2,PATHED3,PATHED4,PATHED5,PATHED6,PATHED7,PATHED8};
static char pstr[N_PATH][L_PATH+1];

static long lower[10], upper[10];

static void evwm_redraw(int handle, int *rec, int line);
static void event_loop(long ti);

#if LINKRSC
static int rsrc_init(void)
{
    register int i;
    menu=rs_trees[MENU];
    sh_form=rs_trees[SHORT];
    path_form = rs_trees[PATHFORM];
    for (i=0; i<rs_nobs; i++) rsrc_obfix(rs_objec,i);
    return 1;
}

static void rsrc_exit(void)
{
}

#else
static int rsrc_init(void)
{
    if (!rsrc_load("DVIRSC.RSC")) return 0;
    if (!rsrc_gaddr(0,MENU,&menu)) return 0;
    if (!rsrc_gaddr(0,EDFORM,&ed_form)) return 0;
    if (!rsrc_gaddr(0,SHORT,&sh_form)) return 0;
    if (!rsrc_gaddr(0,PATHFORM,&path_form)) return 0;
    return 1;
}

static void rsrc_exit(void)
{
    rsrc_free();
}
#endif /* LINKRSC */

static int vdi_init(void)
{
    vdi_handle=graf_handle(&gw,&gh,&bw,&bh);
    if (vdi_handle<0) return 0;
    v_opnvwk(work_in,&vdi_handle,work_out);
    if (vdi_handle<0) return 0;
    monochrom = !work_out[35];
    return 1;
}

static void vdi_exit(void)
{
    v_clsvwk(vdi_handle);
}

static void sc_wopen(void)
{
    if (!sc_open)
    {
	wind_open(sc_handle,sc_x,sc_y,sc_w,sc_h);
	sc_open = 1;
	sc_redraw = 0;
    }
}

static void sc_wclose(void)
{
    if (sc_open)
    {
	wind_get(sc_handle,WF_CURRXYWH,&sc_x,&sc_y,&sc_w,&sc_h);
	wind_close(sc_handle);
	sc_redraw = 0;
	sc_open = 0;
	event_loop(REPAIR_TIME);
    }
}

static int wind_init(void)
{
    int x,y,w,h,wx,wy,ww,wh;

    wind_get(0,WF_WORKXYWH,&x,&y,&w,&h);

    sc_handle = wind_create(SC_KIND,x,y,w,h);
    if (sc_handle<0) return 0;
    wind_set(sc_handle,WF_NAME," TeX Output \0");
    sc_x = x;   sc_w = w;
    sc_y = y;   sc_h = h;
    sc_open = 0;

    wi_handle = wind_create(WI_KIND,x,y,w,h);
    if (wi_handle<0) return 0;
    wind_set(wi_handle,WF_NAME," Messages \0");
    x += bw;   y += bh;
    w -= 2*bw; h -= 2*bh; 
    wind_calc(WC_WORK,WI_KIND,x,y,w,h,&wx,&wy,&ww,&wh);
    wx -= wx%8;
    if (ww>WI_COLS*gw) ww = WI_COLS*gw;
    if (wh>WI_LINES*gh) wh = WI_LINES*gh;
    wind_calc(WC_BORDER,WI_KIND,wx,wy,ww,wh,&x,&y,&w,&h);
    wind_open(wi_handle,x,y,w,h);

    return 1;
}

static void wind_exit(void)
{
    wind_close(wi_handle);
    wind_delete(wi_handle);
    sc_wclose();
    wind_delete(sc_handle);
}

static void wind_top(int w_handle)
{
    int handle;
#if defined(__ATARIGNU__)
    int d1,d2,d3;

    wind_get( 0, WF_TOP, &handle, &d1, &d2, &d3 );
#else
    wind_get(0,WF_TOP,&handle);
#endif
    if (handle!=w_handle)
    {
	wind_set(w_handle,WF_TOP);
	event_loop(REPAIR_TIME);
    }
}

void out_string(char *string)
{
    char *s = wi_contents[the_line];
    size_t the_column = strlen(s);

    if (op.autowindow) wind_top(wi_handle);

    if (WI_COLS<=the_column+1)
    {
	the_column = 1;
	*s = '@';
    }
    strncpy(s+the_column,string,WI_COLS-the_column);
    s[WI_COLS] = '\0';
    evwm_redraw(wi_handle,NULL,the_line);
}

void out_newline(void)
{
    int lines, x, y, w, h, fx, fy, fw, fh;

    if (op.autowindow) wind_top(wi_handle);

    wind_get(wi_handle,WF_WORKXYWH,&x,&y,&w,&h);
    wind_get(wi_handle,WF_FIRSTXYWH,&fx,&fy,&fw,&fh);

    the_line++;

    lines = h/gh;   
    if (lines>WI_LINES) lines = WI_LINES;

    if (the_line>=lines)
    {
	int i, d = the_line-lines+1;

	for (i=0; i<WI_LINES-d; i++)
	    strcpy(wi_contents[i], wi_contents[i+d]);

	for (i=WI_LINES-d; i<WI_LINES; i++)
	    wi_contents[i][0] = '\0';

	the_line -= d;

	if (d==1 && x==fx && y==fy && w==fw && h==fh)
	{
	    MFDB screen;
	    int p[8];

	    wind_update(BEG_UPDATE);
	    v_hide_c(vdi_handle);
	    vst_alignment(vdi_handle,0,5,p,p+1);
	    vs_clip(vdi_handle,0,p);
	    vsf_interior(vdi_handle,FIS_HOLLOW);

	    screen.fd_addr = NULL;
	    p[0] = p[4] = x;
	    p[2] = p[6] = x+w-1;
	    p[1] = y+gh; p[3] = y+h-1;
	    p[5] = y; p[7] = y+h-gh-1;

	    vro_cpyfm(vdi_handle,S_ONLY,p,&screen,&screen);
	    p[1] = y+h-gh; p[3] = y+h-1;
	    vr_recfl(vdi_handle,p);

	    v_show_c(vdi_handle,0);
	    wind_update(END_UPDATE);
	}
	else evwm_redraw(wi_handle,NULL,-1);
    }
}

void halt(char *format, ...)
{
    extern void vprint(char *, va_list);
    va_list l;

    wind_top(wi_handle);
    va_start(l,format);
    vprint(format,l);
    va_end(l);
    longjmp(halt_jump,1);
}

int cont_err(void)
{
    return 1==form_alert(2,
	"[1][ Error while | loading fonts ][ continue | abort ]");
}

int wait_for_sheet(void)
{
    return 1==form_alert(2,"[3][ Insert new sheet ][ Abort | Done ]");
}

static int do_shform(char *string, char *input_string)
{
    int x,y,w,h,button;
#if defined(__ATARIGNU__)
    TEDINFO *temp;

    temp = (TEDINFO *)sh_form[SHTEXT].ob_spec;
    temp->te_ptmplt = string;
    temp = (TEDINFO *)sh_form[SHEDIT].ob_spec;
    strcpy(temp->te_ptext,input_string);
#else   
    sh_form[SHTEXT].ob_spec.tedinfo->te_ptmplt = string;
    strcpy(sh_form[SHEDIT].ob_spec.tedinfo->te_ptext,input_string);
#endif
    form_center(sh_form,&x,&y,&w,&h);
    form_dial(0,0,0,0,0,x,y,w,h);
    form_dial(1,0,0,0,0,x,y,w,h);
    objc_draw(sh_form,0,8,x,y,w,h);
    button = form_do(sh_form,SHEDIT);
    objc_change(sh_form,button,0,x,y,w,h,sh_form[button].ob_state& ~SELECTED,0);
    if (button==SHOK)
#if defined(__ATARIGNU__)
    {
	temp = (TEDINFO *)sh_form[SHEDIT].ob_spec;
	strcpy(input_string,temp->te_ptext);
    }
#else
	strcpy(input_string,sh_form[SHEDIT].ob_spec.tedinfo->te_ptext);
#endif
    form_dial(2,0,0,0,0,x,y,w,h);
    form_dial(3,0,0,0,0,x,y,w,h);
    event_loop(REPAIR_TIME);
    return button==SHOK;
}

static void init_path(const char *oldpath)
{
    int i;
    char *p;
    const char *q;
#if defined(__ATARIGNU__)
    TEDINFO *temp;
#endif

    while(*oldpath==' ' || *oldpath=='\t') oldpath++;
    for (i=0; i<N_PATH; i++)
    {
#if defined(__ATARIGNU__)
	temp = (TEDINFO *)path_form[ped[i]].ob_spec;
	temp->te_ptext = pstr[i];
#else
	path_form[ped[i]].ob_spec.tedinfo->te_ptext = pstr[i];
#endif
	for (p=pstr[i], q=oldpath; *q && *q!=PATH_SEP && *q!=' '; *p++ = *q++);
	*p='\0';
	while(*oldpath && *oldpath!=PATH_SEP) oldpath++;
	while(*oldpath==' ' || *oldpath=='\t' || *oldpath==PATH_SEP)
	    oldpath++;
    }
}

static void exit_path(char *newpath, int maxlen)
{
    int i, f=0;

    if (maxlen<=0) return;
    maxlen--;

    for (i=0; i<N_PATH && maxlen; i++)
    {
	char *p=pstr[i];
	while (*p==' ' || *p=='\t') p++;
	if (*p=='\0') continue;
	if (f && maxlen) *newpath++ = ';', maxlen--;
	while(*p && *p!=' ' && maxlen) 
	    *newpath++ = *p++, maxlen--;
	f = 1;
    }
    *newpath = '\0';
}

static char *sel_path(void)
{
    static char path[128] = "";
    char file[32], *p;
    int button;

    if (*path==0) getcwd(path,128);
    strcat(path,"\\*.*");
    fsel_input(path,file,&button);
    event_loop(REPAIR_TIME);
    *(p=fname(path)) = '\0';
    if (p>path && p[-1]=='\\') p[-1] = '\0';

    return button ? path:NULL;
}

static void def_path(char *name, char *oldpath)
{
    int x, y, w, h, button;
#if defined(__ATARIGNU__)
    TEDINFO *temp;
#endif


    graf_mouse(0,0);    
    init_path(oldpath);

    form_center(path_form,&x,&y,&w,&h);
#if defined(__ATARIGNU__)
    temp = (TEDINFO *)path_form[PATHTEXT].ob_spec;
    temp->te_ptmplt = name;
#else
    path_form[PATHTEXT].ob_spec.tedinfo->te_ptmplt = name;
#endif

    do
    {
	form_dial(0,0,0,0,0,x,y,w,h);
	form_dial(1,0,0,0,0,x,y,w,h);
	objc_draw(path_form,0,8,x,y,w,h);
	button = form_do(path_form,PATHED1);
	objc_change(path_form,button,0,x,y,w,h,
	    path_form[button].ob_state&~SELECTED,0);
	form_dial(2,0,0,0,0,x,y,w,h);
	form_dial(3,0,0,0,0,x,y,w,h);

	if (button==PATHSEL)
	{
	    char *newpath = sel_path();
	    int i;

	    if (newpath!=NULL)
	    {
		for (i=0; i<N_PATH; i++)
		    if (!strcmp(pstr[i],newpath)) break;
		if (i>=N_PATH)
		{
		    for (i=0; i<N_PATH; i++)
			if (pstr[i][0]=='\0') break;
		    if (i<N_PATH) strncpy(pstr[i],newpath,L_PATH);
		}
	    }
	}
    } while(button==PATHSEL);
    if (button==PATHOK) exit_path(oldpath,MAX_PATH_LEN);
    event_loop(REPAIR_TIME);
}

static int select_file(char *file, char *path, char *ext)
{
    char inpath[80];
    char infile[80];
    int button;
    if (*file)
    {
	strcpy(inpath,file);
	*fname(inpath) = '\0';
	getfile(infile,file);
    }
    else 
    {
	strcpy(inpath,path);
	if (*inpath=='\0') getcwd(inpath,80);
	*infile='\0';
    }
    catpf(inpath,inpath,"*.");
    strcat(inpath,ext);
    fsel_input(inpath,infile,&button);
    event_loop(REPAIR_TIME);
    if (button)
    {
	strcpy(file,inpath);
	strcpy(fname(file),infile);
    }
    return button;
}

static int get_long(char *name, long *l)
{
    char string[128], *s;
    long i;
    int changed = 0;

    sprintf(string,"%ld",*l);

    if (do_shform(name,string))
    {
	i = strtol(string,&s,10);
	if (*s=='\0') 
	{
	    *l=i;
	    changed = 1;
	}
	else form_alert(1,"[1][ Wrong integer format ][ abort ]");
    }
    return changed;
}

static int get_int(char *name, int *i)
{
    long l = *i;
    int changed = get_long(name,&l);

    if ( (int)l != l)
    {
	changed = 0;
	form_alert(1,"[1][ Wrong integer format ][ abort ]");
    }
    else *i = (int)l;
    return changed;
}

static void get_real(char *name, double *r)
{
    char string[128], *s;
    double d;

    sprintf(string,"%lf",*r);
    if (do_shform(name,string))
    {
	d=strtod(string,&s);
	if (*s=='\0') *r=d;
	else form_alert(1,"[1][ Wrong number format ][ abort ]");
    }
}

static void get_dimen(char *name, double *dimen, int new_format)
{
    char string[128], *s=string, c;
    double r;

    sprintf(s,"%.6f in",*dimen);
    if (do_shform(name,s))
    {
	while(isdigit(*s) || *s=='.') s++;
	if (s==string)
	{
	    form_alert(1,"[1][ Illegal number format ][ abort ]");
	    return;
	}
	strlwr(s); c=*s; *s=0; r=atof(string); *s=c;
	while(isspace(*s)) s++;
	if (r==0.0 && *s=='\0') *dimen = 0.0;
	else if (!strcmp(s,"in")) *dimen = r;
	else if (!strcmp(s,"cm")) *dimen = r/2.54;
	else if (!strcmp(s,"pt")) *dimen = r/72.27;
	else if (!strcmp(s,"pc")) *dimen = r*12.0/72.27;
	else if (!strcmp(s,"bp")) *dimen = r/72.0;
	else if (!strcmp(s,"mm")) *dimen = r/25.4;
	else if (!strcmp(s,"dd")) *dimen = r*1238.0/72.27;
	else if (!strcmp(s,"cc")) *dimen = r*12*1238.0/72.27;
	else if (!strcmp(s,"sp")) *dimen = r/72.27/65536.0;
	else 
	{
	    form_alert(1,"[1][ Illegal dimension][ abort ]");
	    return;
	}
	if (new_format)
	{
	    sc_wclose();
	    dvi_clean();
	}
    }
}

static void get_pages(char *name, long *bounds)
{
    char string[128];

    strcpy(string,fmt_page(bounds));
    if (do_shform(name,string))
    {
	if (!get_bound(string,bounds))
	    form_alert(1,"[1][ Wrong page format ][ continue ]");
    }
}

static void ls_opts(int save, char *file_name)
{
    static char op_name[128]="";
    int ok;
    FILE *fp;

    if (!*cwd) getcwd(cwd,128);

    if (file_name!=NULL) 
    {
	if (fname(file_name)==file_name)
	    catpf(op_name,cwd,file_name);
	else 
	    strcpy(op_name,file_name);
	catfe(op_name,op_name,EXTENSION); ok=1; 
    }
    else ok=select_file(op_name,cwd,EXTENSION);

    if (ok)
    {
	if ( (fp=fopen(op_name,save ? "wb":"rb"))==NULL )
	{
	    print("Could not open optionfile: %s",op_name);
	}
	else
	{
	    if (save)
	    {
		op.magic = GEM_MAGIC;
		if (shipout==p6low) op.shipno=1;
		else if (shipout==p6high) op.shipno=2;
		else if (shipout==p6mid) op.shipno=3;
		else if (shipout==fx80) op.shipno=4;
		else if (shipout==shipfile) op.shipno=5;
		else if (shipout==hplj) op.shipno=6;
		else if (shipout==hpljlow) op.shipno=7;
		else if (shipout==bj300) op.shipno=8;
		else if (shipout==null_device) op.shipno=9;
		else op.shipno=0;
		fwrite(&op,sizeof(op),1,fp);
	    }
	    else
	    {
		options new_op;
		size_t bytes = fread(&new_op,sizeof(op),1,fp);
		if (bytes!=1 || new_op.magic!=GEM_MAGIC)
		{
		    form_alert(1,"[1][ Invalid Optionfile ][ Continue ]");
		}
		else
		{
		    op = new_op;
		    menu_changed = 1;
		    sc_wclose(); dvi_clean();
		    switch(op.shipno)
		    {
			case 1: shipout=p6low; break;
			case 2: shipout=p6high; break;
			case 3: shipout=p6mid; break;
			case 4: shipout=fx80; break;
			case 5: shipout=shipfile; break;
			case 6: shipout=hplj; break;
			case 7: shipout=hpljlow; break;
			case 8: shipout=bj300; break;
			case 9: shipout=null_device; break;
			default: shipout=NULL;
		    }
		    menu_changed=1;
		}
	    }
	    fclose(fp);
	}   
    }
}

static void def_logfile(void)
{
    sc_wclose(); dvi_clean();
    if (!*cwd) getcwd(cwd,128);
    if (*op.log_name) op.log_name[0]='\0';
    else select_file(op.log_name,cwd,"LOG");
    menu_changed=1;
}

static void sc_wname(char *name, ...)
{
    va_list l;
    va_start(l,name);
    vsprintf(sc_name,name,l);
    wind_set(sc_handle,WF_NAME,sc_name);
    va_end(l);
}

static void sc_slides(void)
{
    int hsize, vsize, hpos, vpos, x, y, w, h, hs, vs, hp, vp;
#if defined(__ATARIGNU__)
    int d1, d2, d3;
#endif

    if (sc_open)
	wind_get(sc_handle,WF_WORKXYWH,&x,&y,&w,&h);
    else
	x=sc_x, y=sc_y, w=sc_w, h=sc_h;

#if defined(__ATARIGNU__)
    wind_get(sc_handle,WF_HSLIDE,&hp,&d1,&d2,&d3);
    wind_get(sc_handle,WF_VSLIDE,&vp,&d1,&d2,&d3);
    wind_get(sc_handle,WF_VSLSIZE,&hs,&d1,&d2,&d3);
    wind_get(sc_handle,WF_HSLSIZE,&vs,&d1,&d2,&d3);
#else
    wind_get(sc_handle,WF_HSLIDE,&hp);
    wind_get(sc_handle,WF_VSLIDE,&vp);
    wind_get(sc_handle,WF_VSLSIZE,&hs);
    wind_get(sc_handle,WF_HSLSIZE,&vs);
#endif

    if (frame_valid)
    {
	hsize = (int)((double)w/(double)(frame_width*8)*1000.0);
	vsize = (int)((double)h/(double)frame_height*1000.0);
	if (frame_width*8<=w) hpos = 0;
	else hpos = (int)(1000.0*(double)sc_xoff/(double)(frame_width*8-w));
	if (frame_height<=h) vpos =0;
	else vpos = (int)(1000.0*(double)sc_yoff/(double)(frame_height-h));
    }
    else hsize=-1, vsize=-1, hpos = vpos = 0;
    if (vsize!=vs) wind_set(sc_handle,WF_VSLSIZE,vsize);
    if (hsize!=hs) wind_set(sc_handle,WF_HSLSIZE,hsize);
    if (hpos!=hp) wind_set(sc_handle,WF_HSLIDE,hpos);
    if (vpos!=vp) wind_set(sc_handle,WF_VSLIDE,vpos);
}

static void sc_adjust(int redraw, int *r)
{
    int x,y,w,h,bx,by,bw,bh,new_size=0;

    if (r==NULL) 
    {
	if (sc_open) wind_get(sc_handle,WF_WORKXYWH,&x,&y,&w,&h);
	else wind_calc(WC_WORK,SC_KIND,sc_x,sc_y,sc_w,sc_h,&x,&y,&w,&h);
    }
    else
    {
	new_size = 1;
	wind_calc(WC_WORK,SC_KIND,r[0],r[1],r[2],r[3],&x,&y,&w,&h);
    }

    if (frame_valid)
    {
	if (w>frame_width*8)
	{
	    x += (w-frame_width*8)/2;
	    w = frame_width*8;
	    sc_xoff = 0;
	    new_size = 1;
	}
	if (h>frame_height)
	{
	    h = frame_height;
	    sc_yoff = 0;
	    new_size = 1;
	}
	if (sc_xoff+w>=frame_width*8)
	    sc_xoff = frame_width*8 - w;
	if (sc_yoff+h>=frame_height)
	    sc_yoff = frame_height - h;
    }

    if (new_size)
    {
	wind_calc(WC_BORDER,SC_KIND,x,y,w,h,&bx,&by,&bw,&bh);
	if (sc_open)
	    wind_set(sc_handle,WF_CURRXYWH,bx,by,bw,bh);
	else 
	    sc_x = bx, sc_y = by, sc_w = bw, sc_h = bh;
    }

    sc_slides();

    if (redraw) sc_redraw = 1;
}

static void print_pages(int first, int last, int step)
{
    if (*dvi_name) graf_mouse(2,0);
    else
    {
	if (select_file(dvi_name,op.dvi_path,"DVI"))
	{
	    graf_mouse(2,0);
	    dvi_clean();
	}
    }

    last_page = format_pages(first,last,step);

    if (shipout==NULL)
    {   
	sc_xoff = sc_yoff = 0;
	if (frame_valid) 
	{
	    sc_wname(" Page [%s] ",page_string);
	    sc_adjust(1,NULL);
	    sc_wopen();
	    if (op.autowindow) wind_top(sc_handle);
	}
	else sc_wclose();
    }
    else sc_wclose();


    graf_mouse(0,0);
}

static void gem_fmtpages(void)
{
    char string[128], *arg;

    *string='\0';

    if (do_shform("First Last Step",string))
    {
	int first, last, step;
	arg = strtok(string," ,:;.\t\n\r");
	if (arg!=NULL) 
	{   
	    first = atoi(arg);
	    last = first;
	    step = 1;
	    arg = strtok(NULL," ,:;.\t\n\r");
	    if (arg!=NULL) 
	    {
		last = atoi(arg);
		arg = strtok(NULL," ,:;.\t\n\r");
		if (arg!=NULL) step = atoi(arg);
	    }
	}
	else first=1, last=9999, step=1;

	if ( shipout != NULL )
	    print_pages(first,last,step);
	else
	    print_pages(first,first,1);
    }
}

static void sel_ship_file(void)
{
    exgext(ship_name,dvi_name,SHIPEXT);
    if (select_file(ship_name,op.dvi_path,SHIPEXT))
    {
	shipout = shipfile; 
	menu_changed = 1;
	sc_wclose(); dvi_clean();
    }
}

static void copyright(void)
{
    char alert_str[256];
    sprintf(alert_str,
	"[0][ DVI %s  \xbd 1992 | Ingo Eichenseher ][ Ok ]",version_string);
    form_alert(1,alert_str);
}

static void next_page(int diff)
{
    if (shipout==NULL)
    {
	int first;

	if (frame_valid && last_page && last_page+diff>0 && dvi_info.valid) 
	    first = last_page + diff;
	else first = 1;
	print_pages(first,first,1);
    }
}

static void ch_dviname(void)
{
    if (select_file(dvi_name,op.dvi_path,"DVI"))
    {
	sc_wclose(); 
	dvi_clean();
    }
}

static void ch_dvimem(void)
{
    sc_wclose(); dvi_clean();
    op.dvimemory = !op.dvimemory;
    menu_changed=1;
}

static void ch_pixmem(void)
{
    if (get_long("Maximum Bitmap Size",&op.pixmem))
    {
	sc_wclose(); dvi_clean();
	menu_changed = 1; 
    }
}

static void ch_maxmem(void)
{
    if (get_long("Maximum Memory Allocation",&op.maxmem))
    {
	sc_wclose(); dvi_clean();
	menu_changed = 1; 
    }
}

static void ch_pathmem(void)
{
    if (get_long("Maximum Clipping Memory",&op.pathmem))
    {
	sc_wclose(); dvi_clean();
	menu_changed = 1; 
    }
}

static void ch_landscape(void)
{
    op.landscape = !op.landscape;
    menu_changed = 1;
    sc_wclose(); dvi_clean();
}

static void ch_thinout(void)
{
    menu_changed = 1; 
    op.thin_out = !op.thin_out; 
    if (op.thin_out) op.separate=0;
}

static void ch_separate(void)
{
    menu_changed = 1; 
    op.separate = !op.separate;
    if (op.separate) op.thin_out=0;
}

static void ch_showfonts(void)
{
    op.showfonts = !op.showfonts;
    menu_changed = 1;
}

static void ch_show_img(void)
{
    op.show_img = !op.show_img; 
    menu_changed=1; 
}

static void ch_singlesheet(void)
{
    op.singlesheet = !op.singlesheet;
    menu_changed = 1;
}

static void ch_formfeed(void)
{
    op.formfeed = !op.formfeed; 
    menu_changed = 1; 
}

static void ch_tracemem(void)
{
    op.tracemem = !op.tracemem; 
    menu_changed = 1; 
}

static void ch_tracechars(void)
{
    op.tracechars = !op.tracechars; 
    menu_changed = 1; 
}

static void ch_autowindow(void)
{
    op.autowindow = !op.autowindow; 
    menu_changed = 1; 
}

static void ch_shipout(int (*p)(void))
{
    shipout = p;
    menu_changed = 1;
    sc_wclose(); dvi_clean();
}

static void ch_hres(void)
{
    if (get_long("Horizontal resolution",&op.hres))
    {
	sc_wclose(); 
	dvi_clean();
    }
}

static void ch_vres(void)
{
    if (get_long("Vertical resolution",&op.vres))
    {
	sc_wclose(); 
	dvi_clean();
    }
}

static void ch_mag(void)
{
    if (get_long("Magnification",&op.new_mag))
    {
	sc_wclose(); 
	dvi_clean();
    }
}

static void cycle_windows(void)
{
    int handle;
#if defined(__ATARIGNU__)
    int d1,d2,d3;

    wind_get(0,WF_TOP,&handle,&d1,&d2,&d3);
#else
    wind_get(0,WF_TOP,&handle);
#endif
    if (handle==sc_handle) wind_set(wi_handle,WF_TOP);
    else if (handle==wi_handle && sc_open) wind_set(sc_handle,WF_TOP);
}

static void do_redirection(void)
{
    if (*op.redirect) *op.redirect = '\0';
    else
    {
	if (!select_file(op.redirect,op.dvi_path,"PRN"))
	    *op.redirect = '\0';
    }
    menu_changed = 1;
}

static void evmn_selected(int title, int item)
{
    switch(item)
    {
	case QUIT: ende=1; break;
	case MYMSG: copyright(); break;
	case PKPATH: def_path("PK Path",op.pk_path); break;
	case TFMPATH: def_path("TFM Path",op.tfm_path); break;
	case VFPATH: def_path("VF Path",op.vf_path); break;
	case DVIPATH: def_path("DVI Path",op.dvi_path); break;
	case INPPATH: def_path("GR Input Path",op.input_path); break;
	case IMGPATH: def_path("IMG Path",op.img_path); break;
	case CHOOSE:  ch_dviname(); break;
	case OPLOAD: ls_opts(0,NULL); break;
	case OPSAVE: ls_opts(1,NULL); break;
	case MEMORY: ch_dvimem(); break;
	case PIXMEM: ch_pixmem(); break;
	case MAXMEM: ch_maxmem(); break;
	case CLIPMEM: ch_pathmem(); break;
	case SHOWFONT: ch_showfonts(); break;
	case SHOWMEM: ch_tracemem(); break;
	case TRACECHA: ch_tracechars(); break;
	case AUTOWIND: ch_autowindow(); break;
	case LAND: ch_landscape(); break;
	case SINGLE: ch_singlesheet(); break;
	case THIN: ch_thinout(); break;
	case SEP: ch_separate(); break;
	case PICS: ch_show_img(); break;
	case EJECT: ch_formfeed(); break;
	case SCREEN: ch_shipout((int(*)(void))NULL); break;
	case SHIPFILE: sel_ship_file(); break;
	case P6LOW: ch_shipout(p6low); break;
	case P6HIGH: ch_shipout(p6high); break;
	case P6MID: ch_shipout(p6mid); break;
	case FX80: ch_shipout(fx80); break;
	case HPLJ: ch_shipout(hplj); break;
	case HPLJLOW: ch_shipout(hpljlow); break;
	case BJ300: ch_shipout(bj300); break;
	case SHIPNULL: ch_shipout(null_device); break;
	case HOFFSET: get_dimen("H-Offset",&op.hoffset,1); break;
	case VOFFSET: get_dimen("V-Offset",&op.voffset,1); break;
	case HSPREAD: get_dimen("H-Spread",&op.hspread,1); break;
	case VSPREAD: get_dimen("V-Spread",&op.vspread,1); break;
	case HMARGIN: get_dimen("H-Margin",&op.hmargin,0); break;
	case VMARGIN: get_dimen("V-Margin",&op.vmargin,0); break;
	case WIDTH: get_dimen("Width",&op.width,1); break;
	case HEIGHT: get_dimen("Height",&op.height,1); break;
	case DENSITY: get_real("Density",&op.density); break;
	case HRES: ch_hres(); break;
	case VRES: ch_vres(); break;
	case NEXTPAGE: next_page(1); break;
	case PREVPAGE: next_page(-1); break;
	case FORMFROM: gem_fmtpages(); break;
	case COPIES: get_int("Copies",&op.copies); break;
	case MAG: ch_mag(); break;
	case LOWER: get_pages("Lower page limit",lower); break;
	case UPPER: get_pages("Upper page limit",upper); break;
	case LOGFILE: def_logfile(); break;
	case WCYCLE: cycle_windows(); break;
	case REDIRECT: do_redirection(); break;
	default: break;
    }
    menu_tnormal(menu,title,1);
}

static void set_menu(void)
{
    menu_icheck(menu,MEMORY,op.dvimemory);
    menu_icheck(menu,PIXMEM,op.pixmem!=0l);
    menu_icheck(menu,MAXMEM,op.maxmem!=0l);
    menu_icheck(menu,CLIPMEM,op.pathmem!=0l);
    menu_icheck(menu,SHOWFONT,op.showfonts);
    menu_icheck(menu,SHOWMEM,op.tracemem);
    menu_icheck(menu,TRACECHA,op.tracechars);
    menu_icheck(menu,AUTOWIND,op.autowindow);
    menu_icheck(menu,LAND,op.landscape);
    menu_icheck(menu,THIN,op.thin_out);
    menu_icheck(menu,SINGLE,op.singlesheet);
    menu_icheck(menu,SEP,op.separate);
    menu_icheck(menu,PICS,op.show_img);
    menu_icheck(menu,EJECT,op.formfeed);
    menu_icheck(menu,SCREEN,shipout==NULL);
    menu_icheck(menu,P6LOW,shipout==p6low);
    menu_icheck(menu,P6MID,shipout==p6mid);
    menu_icheck(menu,P6HIGH,shipout==p6high);
    menu_icheck(menu,FX80,shipout==fx80);
    menu_icheck(menu,HPLJ,shipout==hplj);
    menu_icheck(menu,HPLJLOW,shipout==hpljlow);
    menu_icheck(menu,BJ300,shipout==bj300);
    menu_icheck(menu,SHIPFILE,shipout==shipfile);
    menu_icheck(menu,LOGFILE,op.log_name[0]!='\0');
    menu_icheck(menu,REDIRECT,*op.redirect!='\0');
    menu_ienable(menu,NEXTPAGE,shipout==NULL);
    menu_ienable(menu,PREVPAGE,shipout==NULL);
}

static void evwm_arrowed(int handle, int direction)
{
    /*
	0    Seite nach oben
	1    Seite nach unten
	2    Zeile nach oben
	3    Zeile nach unten
	4    Seite nach links
	5    Seite nach rechts
	6    Spalte nach links
	7    Spalte nach rechts
    */

    int x,y,w,h;

    if (handle!=sc_handle || !frame_valid) return;

    wind_get(sc_handle,WF_WORKXYWH,&x,&y,&w,&h);
    switch(direction)
    {
	case 0 :
	case 2 :
	    sc_yoff -= direction==0 ? h : bh;
	    if (sc_yoff<0) sc_yoff = 0;
	    break;
	case 3 :
	case 1 :
	    sc_yoff += direction==1 ? h : bh;
	    if (sc_yoff>frame_height-h) sc_yoff = frame_height-h;
	    break;
	case 4 :
	case 6 :
	    sc_xoff -= direction==4 ? w : bw;
	    if (sc_xoff<0) sc_xoff = 0;
	    break;
	case 7 :
	case 5 :
	    sc_xoff += direction==5 ? w : bw;
	    if (sc_xoff>frame_width*8-w) sc_xoff = frame_width*8-w;
	    break;
    }
    sc_adjust(1,NULL);
}

static void ev_key(int key)
{
    switch(key)
    {
	case 0x3b00: ls_opts(0,"F1"); break;
	case 0x3c00: ls_opts(0,"F2"); break;
	case 0x3d00: ls_opts(0,"F3"); break;
	case 0x3e00: ls_opts(0,"F4"); break;
	case 0x3f00: ls_opts(0,"F5"); break;
	case 0x4000: ls_opts(0,"F6"); break;
	case 0x4100: ls_opts(0,"F7"); break;
	case 0x4200: ls_opts(0,"F8"); break;
	case 0x4300: ls_opts(0,"F9"); break;
	case 0x4400: ls_opts(0,"F10"); break;
	case 0x1900: do_redirection(); break;
	case 0x260c: get_pages("Lower page limit",lower); break;
	case 0x1615: get_pages("Upper page limit",upper); break;
	case 0x320d: ch_mag(); break;
	case 0x2e03: get_int("Copies",&op.copies); break;
	case 0x1117: get_dimen("Width",&op.width,1); break;
	case 0x1177: case 0x1157: cycle_windows(); break;
	case 0x2146: case 0x2166: gem_fmtpages(); break;
	case 0x2308: get_dimen("Height",&op.height,1); break;
	case 0x1f00: ch_shipout((int(*)(void))NULL); break;
	case 0x2600: ch_shipout(p6low); break;
	case 0x3200: ch_shipout(p6mid); break;
	case 0x2300: ch_shipout(p6high); break;
	case 0x2100: sel_ship_file(); break;
	case 0x3100: ch_shipout(null_device); break;
	case 0x2D00: ch_shipout(fx80); break;
	case 0x2400: ch_shipout(hplj); break;
	case 0x2500: ch_shipout(hpljlow); break;
	case 0x3000: ch_shipout(bj300); break;
	case 0x1f73: case 0x1f53: ls_opts(1,NULL); break;
	case 0x1970: case 0x1950: next_page(-1); break;
	case 0x316e: case 0x314e: next_page(1); break;
	case 0x2E63: case 0x2e43: ch_dviname(); break;
	case 0x1071: case 0x1051: case 0x011B: ende=1; break;
	case 0x266C: case 0x264C: ls_opts(0,NULL); break;
	case 0x0f09: prbyte(12); break;
	case 0x4838: evwm_arrowed(sc_handle,0); break;
	case 0x5032: evwm_arrowed(sc_handle,1); break;
	case 0x4800: evwm_arrowed(sc_handle,2); break;
	case 0x5000: evwm_arrowed(sc_handle,3); break;
	case 0x4B34: evwm_arrowed(sc_handle,4); break;
	case 0x4D36: evwm_arrowed(sc_handle,5); break;
	case 0x4B00: evwm_arrowed(sc_handle,6); break;
	case 0x4D00: evwm_arrowed(sc_handle,7); break;
	case 0x4700: sc_xoff = sc_yoff = 0; sc_adjust(1,NULL); break;
    }
}

int intersect(int *p1, int *p2)
{
    int  tw = MIN(p1[0] + p1[2], p2[0] + p2[2]);
    int  th = MIN(p1[1] + p1[3], p2[1] + p2[3]);
    int  tx = MAX(p1[0], p2[0]);
    int  ty = MAX(p1[1], p2[1]);

    p2[0] = tx;
    p2[1] = ty;
    p2[2] = tw - tx;
    p2[3] = th - ty;

    return ((int)((tw > tx) && (th > ty)));
}

static void evwm_redraw(int handle, int *rec, int line)
{
    int x,y,w,h,r[4];

    wind_get(handle,WF_WORKXYWH,r,r+1,r+2,r+3);
    if (rec==NULL) rec = r;

    if (handle==wi_handle) 
    {
	int p[4], q[4];

	wind_update(BEG_UPDATE);
	v_hide_c(vdi_handle);
	vsf_interior(vdi_handle,FIS_HOLLOW);
	vswr_mode(vdi_handle,MD_REPLACE);
	vst_alignment(vdi_handle,0,5,p,p+1);
	wind_get(wi_handle,WF_FIRSTXYWH,&x,&y,&w,&h);

	while(w && h)
	{
	    p[0]=x; p[1]=y; p[2]=w; p[3]=h;

	    if (intersect(rec,p)) 
	    {
		int l, u, yy, i;

		p[2] += p[0]-1; p[3] += p[1]-1;
		vs_clip(vdi_handle,1,p);

		if (line>=0) l=line, u=line+1, yy=line*gh+r[1];
		else l=0, u=WI_LINES, yy=r[1];

		for (i=l; i<u; i++)
		{
		    vqt_extent(vdi_handle,wi_contents[i],q);
		    if (q[2]<r[2])
		    {
			q[0] = r[0] + q[2];
			q[1] = yy;
			q[2] = r[0] + r[2]-1;
			q[3] = q[1] + gh-1;
			vr_recfl(vdi_handle,q);
		    }
		    v_gtext(vdi_handle,r[0],yy,wi_contents[i]);
		    yy += gh;
		}
		if (line<0 && yy<r[1]+r[3])
		{
		    q[0] = r[0];
		    q[1] = yy;
		    q[2] = r[0] + r[2]-1;
		    q[3] = r[1] + r[3]-1;
		    vr_recfl(vdi_handle,q);
		}
	    }
	    wind_get(wi_handle,WF_NEXTXYWH,&x,&y,&w,&h);
	}
	v_show_c(vdi_handle,1);
	wind_update(END_UPDATE);
    }
    else if (handle==sc_handle)
    {
	MFDB ms, md;
	int p[8];

	ms.fd_addr = frame_ptr(0);
	ms.fd_w = frame_width*8;
	ms.fd_h = frame_height;
	ms.fd_wdwidth = frame_width/2;
	ms.fd_stand = 0;
	ms.fd_nplanes = 1;
	ms.fd_r1 = ms.fd_r2 = ms.fd_r3 = 0;
	memset(&md,0,sizeof(md));

	wind_update(BEG_UPDATE);
	v_hide_c(vdi_handle);
	vsf_interior(vdi_handle,FIS_HOLLOW);
	vswr_mode(vdi_handle,MD_REPLACE);
	vs_clip(vdi_handle,0,rec);
	wind_get(sc_handle,WF_FIRSTXYWH,p+4,p+5,p+6,p+7);

	while(p[6] && p[7])
	{
	    if (intersect(rec,p+4))
	    {
		p[6] += p[4]-1; 
		p[7] += p[5]-1;

		if (frame_valid)
		{
		    p[0] = p[4]-r[0]+sc_xoff;
		    p[1] = p[5]-r[1]+sc_yoff;
		    p[2] = p[0]+p[6]-p[4];
		    p[3] = p[1]+p[7]-p[5];
		    if (monochrom) vro_cpyfm(vdi_handle,S_ONLY,p,&ms,&md);
		    else vrt_cpyfm(vdi_handle,MD_REPLACE,p,&ms,&md,colors);
		}
		else vr_recfl(vdi_handle,p+4);
	    }
	    wind_get(sc_handle,WF_NEXTXYWH,p+4,p+5,p+6,p+7);
	}
	v_show_c(vdi_handle,1);
	wind_update(END_UPDATE);
    }
}

void evwm_topped(int w_handle)
{
    wind_set(w_handle,WF_TOP);
}

void evwm_moved(int w_handle, int *rec)
{
    if (w_handle==sc_handle) sc_adjust(0,rec);
    else wind_set(w_handle,WF_CURRXYWH,rec[0],rec[1],rec[2],rec[3]);
}

void evwm_hslid(int w_handle, int hpos)
{
    if (w_handle == sc_handle)
    {
	int x,y,w,h;
	wind_get(sc_handle,WF_WORKXYWH,&x,&y,&w,&h);
	sc_xoff = (double)hpos/1000.0*(frame_width*8-w);
	sc_adjust(1,NULL);
    }
}

void evwm_vslid(int w_handle, int vpos)
{
    if (w_handle == sc_handle)
    {
	int x,y,w,h;
	wind_get(sc_handle,WF_WORKXYWH,&x,&y,&w,&h);
	sc_yoff = (double)vpos/1000.0*(frame_height-h);
	sc_adjust(1,NULL);
    }
}

static void evwm_fulled(int handle)
{
    int  fx,fy,fw,fh,r[4];

    wind_get(handle,WF_CURRXYWH,r,r+1,r+2,r+3);
    wind_get(handle,WF_FULLXYWH,&fx,&fy,&fw,&fh);
    if (r[0]==fx && r[1]==fy && r[2]==fw && r[3]==fh)
	wind_get(handle,WF_PREVXYWH,r,r+1,r+2,r+3);
    else r[0]=fx, r[1]=fy, r[2]=fw, r[3]=fh;
    if (handle==sc_handle) sc_adjust(0,r);
    else wind_set(handle,WF_CURRXYWH,r[0],r[1],r[2],r[3]);
}

static void evwm_closed(int handle)
{
    if (handle==sc_handle)
    {
	sc_wclose(); 
	dvi_clean();
    }
}

static void ev_button(int clicks, int mx, int my)
{
#if defined(__ATARIGNU__)
    int d1,d2,d3;
#endif
    int handle = wind_find(mx, my);

    if (clicks==2) cycle_windows();
    else if (handle == sc_handle)
    {
#if defined(__ATARIGNU__)
	wind_get(0,WF_TOP,&handle,&d1,&d2,&d3);
#else
	wind_get(0,WF_TOP,&handle);
#endif
	if (handle==sc_handle && frame_valid)
	{
	    MFDB ms, md;
	    int stat, x, y, src[8], wx, wy, ww, wh;

	    wind_get(sc_handle,WF_WORKXYWH,&wx,&wy,&ww,&wh);
	    wind_get(0,WF_WORKXYWH,src,src+1,src+2,src+3);
	    if (src[0]>wx || src[1]>wy) return;
	    if (wx+ww>src[0]+src[2] || wy+wh>src[1]+src[3]) return;
	    ms.fd_addr = frame_ptr(0);
	    ms.fd_w = frame_width*8;
	    ms.fd_h = frame_height;
	    ms.fd_wdwidth = frame_width/2;
	    ms.fd_stand = 0;
	    ms.fd_nplanes = 1;
	    ms.fd_r1 = ms.fd_r2 = ms.fd_r3 = 0;
	    memset(&md,0,sizeof(md));

	    wind_update(BEG_UPDATE);
	    wind_update(BEG_MCTRL);
	    v_hide_c(vdi_handle);
	    src[4] = wx;
	    src[5] = wy;
	    src[6] = wx+ww-1;
	    src[7] = wy+wh-1;
	    vs_clip(vdi_handle,0,src+4);

	    while(1)
	    {
		vq_mouse(vdi_handle,&stat,&x,&y);
		if (stat==0) break;
		src[0] = sc_xoff+mx-x;
		src[1] = sc_yoff+my-y;
		if (src[0]+ww>frame_width*8) src[0] = frame_width*8-ww;
		if (src[1]+wh>frame_height) src[1] = frame_height-wh;
		if (src[0]<0) src[0] = 0;
		if (src[1]<0) src[1] = 0;
		src[2] = src[0]+ww-1;
		src[3] = src[1]+wh-1;
		if (monochrom) vro_cpyfm(vdi_handle,S_ONLY,src,&ms,&md);
		else vrt_cpyfm(vdi_handle,MD_REPLACE,src,&ms,&md,colors);
#if defined(__ATARIGNU__)
		evnt_timer(0L);
#else
		evnt_timer(0,0);
#endif
	    }
	    sc_xoff = src[0];
	    sc_yoff = src[1];

	    v_show_c(vdi_handle,0);
	    wind_update(END_MCTRL);
	    wind_update(END_UPDATE);
	    sc_slides();
	}
    }
}

static void  event_loop(long ti)
{
    int em[16];
    int ev_which;
    int ev_mox,ev_moy,ev_mokstate,ev_mobutton,ev_kreturn,ev_breturn;

    ende = 0;
    do /* Event-Schleife */
    {
	/* Menu Eintraege in eventuell in heller Schrift, oder */
	/* mit Haekchen versehen darstellen                    */
	if (menu_changed) 
	{
	    set_menu();
	    menu_changed=0;
	}

	if (frame_valid==0) sc_wclose();

	if (sc_redraw)
	{   
	    evwm_redraw(sc_handle,NULL,-1);
	    sc_redraw = 0;
	}

	graf_mouse(0,0);
	/* Auf ein Ereignis warten */
	ev_which = evnt_multi(MU_MESAG|MU_KEYBD|MU_BUTTON|(ti?MU_TIMER:0),
	 2,1,1,0,0,0,0,0,0,0,0,0,0,em,(int)(ti&0xffff),(int)(ti>>16),
	 &ev_mox,&ev_moy,&ev_mobutton,&ev_mokstate,&ev_kreturn,&ev_breturn);

	/* Je nach Ereignis eine Funktion auswaehlen  */
	if (ev_which & MU_MESAG)
	{
	    switch(em[0])
	    {
		case MN_SELECTED: evmn_selected(em[3],em[4]); break;
		case WM_REDRAW  : evwm_redraw(em[3],em+4,-1); break;
		case WM_TOPPED  : evwm_topped(em[3]); break;
		case WM_MOVED   :
		case WM_SIZED   : evwm_moved(em[3],em+4); break;
		case WM_HSLID   : evwm_hslid(em[3],em[4]); break;
		case WM_VSLID   : evwm_vslid(em[3],em[4]); break;
		case WM_FULLED  : evwm_fulled(em[3]); break;
		case WM_ARROWED : evwm_arrowed(em[3],em[4]); break;
		case WM_CLOSED  : evwm_closed(em[3]); break;
		default         : break;
	    }
	} /* Ende der Bearbeitung von Meldungen */

	if (ti && (ev_which & MU_TIMER)) return;
	if (ev_which & MU_KEYBD) ev_key(ev_kreturn);
	if (ev_which & MU_BUTTON) ev_button(ev_breturn,ev_mox,ev_moy);
    } while (!ende);
}

int main(int argc, char **argv)
{
    char *opt_name = NULL;

    argc--; argv++;

    while(argc>0 && **argv=='-')
    {
	switch(tolower(argv[0][1]))
	{
	    case 'o' :
		opt_name = argv[0]+2;
		break;
	}
	argc--; argv++;
    }

    if (argc>0)
    {
	strcpy(dvi_name,*argv);
	argc--; argv++;
    }

    if ((appl_id=appl_init())<0) return 1;
    if (!rsrc_init()) return 1;
    if (!vdi_init()) return 1;
    if (!wind_init()) return 1;

    install();
    if( !gr_install() )
        exit(1);

    menu_bar(menu,1);
    if (argc>0)
    {
	ls_opts(0,*argv);
	argc--; argv++;
    }
    else if (opt_name!=NULL) ls_opts(0,opt_name);
    else ls_opts(0,"DVI");
    setjmp(halt_jump);
    menu_tnormal(menu,PRINT,1);
    event_loop(0l);
    menu_bar(menu,0);
    dvi_clean();

    gr_destall();
    destall();

    wind_exit();
    vdi_exit();
    rsrc_exit();
    appl_exit();

    return 0;
}
