/*
** Datei: DVISPEC.C
** Autor: Ingo Eichenseher
*/

#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <ctype.h>
#include "dvi.h"
#include "dvimisc.h"

#define MAX_TOKLEN 128
#define MAX_FILES   16

long    spec_length;
int     spec_char;
char    spec_token[MAX_TOKLEN+1];

static  char    spec_environ[MAX_TOKLEN+1];
static  FILE    *spec_file[MAX_FILES];
static  int     spec_fchar[MAX_FILES];
static  int     spec_envp, spec_pushed, spec_fptr=0;

int spec_getc(void)
{
    if (spec_pushed)
    {
	spec_char = spec_pushed;
	spec_pushed = '\0';
	return spec_char;
    }
    if (spec_fptr)
    {
	spec_char = getc(spec_file[spec_fptr-1]);
	if(spec_char==EOF)
	{
	    spec_fptr--;
	    fclose(spec_file[spec_fptr]);
	    xprint(-1,")");
	    spec_char = spec_fchar[spec_fptr];
	    return spec_char;
	}
	else 
	{
	    spec_environ[spec_envp] = spec_char;
	    if (++spec_envp>=MAX_TOKLEN) spec_envp = 0;
	    return spec_char;
	}
    }
    if (spec_length<=0) 
	return spec_char = EOF;
    spec_char = spec_environ[spec_envp] = dvi_fgetc();
    spec_length--;
    if (++spec_envp>=MAX_TOKLEN) spec_envp = 0;
    return spec_char;
}

void spec_input(char *filename)
{
    char foundname[128];
    slash(filename);
    if (spec_fptr>=MAX_FILES)
	print("Cannot open more input files");
    else if (NULL==(spec_file[spec_fptr]=
	    fopene(filename,"r",op.input_path,foundname)))
	print("Cannot open file %s",filename);
    else
    {
	xprint(0,"(%s",foundname);
	spec_fchar[spec_fptr] = spec_char;
	spec_fptr++;
	spec_getc();
    }
}

void spec_ungetc(int c)
{
    spec_pushed = c;
}

char *spec_string(int len)
{
    static char environ[MAX_TOKLEN+1];
    char *envp = environ+MAX_TOKLEN;
    int i = spec_envp;

    if (len>MAX_TOKLEN) len = MAX_TOKLEN;
    if (len<3) len = 3;
    *envp = '\0';
    while(len--)
    {
	if (--i<0) i = MAX_TOKLEN;
	if (spec_environ[i]=='\0') break;
	*--envp = spec_environ[i]=='\n' ? ' ':spec_environ[i];
    }
    if (spec_environ[i])
	envp[0] = envp[1] = envp[2] = '.';
    return envp;
}

char *spec_gettok(void)
{
    int i;

    while ( isspace( spec_char ) )
	(void)spec_getc();
    for(i=0; spec_char!=EOF && spec_char!='\n' && !isspace(spec_char) &&
	  spec_char != '=' && spec_char != ':' && spec_char != '\"' &&
          spec_char != '!'; i++ )
    {
	if ( i < MAX_TOKLEN )
	    spec_token[i] = spec_char;
	(void)spec_getc();
    }
    if (spec_char == '=')
	spec_getc();
    if (i==0 && (spec_char==':' || spec_char=='\"' || spec_char=='!'))
    {
	spec_token[0] = spec_char;
	spec_getc();
	i++;
    }
    if ( i >= MAX_TOKLEN )
	i = MAX_TOKLEN;
    spec_token[i] = '\0';
    return spec_token;
}

static void dospecial(int x, int y)
{
    spec_getc();
    spec_gettok();

    if (spec_char==EOF) return;
#ifndef NO_IMG
    if (!strcm2(spec_token,"graphic"))
    {
	spec_gettok();
	if (strcm2(spec_token,"img"))
	{
	    print("Only img graphics are allowed");
	    return;
	}
	spec_gettok();
	if (spec_token[0]=='\0')
	{
	    print("No filename in graphic img");
	    return;
	}
	slash(spec_token);
	if (read_img(spec_token,x,y,op.density))
	    print("Error reading the IMG file %s",spec_token);
    }
    else 
#endif
    if (!strcmp(spec_token,"gr")) 
    {
	gr_command(x,y);
    }
    else other_special(x,y);
}


void special(long length, int x, int y)
{
    spec_length = length;
    spec_envp = 0;
    spec_fptr = 0;
    memset(spec_environ,0,MAX_TOKLEN);
    dospecial(x,y);
    if (spec_length>0) dvi_fmove(spec_length);
}
