/* Commands in the DVI-File: */

# define SET_CHAR_0     0   /* typeset character 0 and move right */
# define SET_CHAR_127   127 /* typeset character 127 and move right */
# define SET1           128 /* typeset a character and move right */
# define SET2           129 /* typeset a character and move right */
# define SET3           130 /* typeset a character and move right */
# define SET4           131 /* typeset a character and move right */
# define SET_RULE       132 /* typeset a rule and move right */
# define PUT1           133 /* typeset a character */
# define PUT2           134 /* typeset a character */
# define PUT3           135 /* typeset a character */
# define PUT4           136 /* typeset a character */
# define PUT_RULE       137 /* typeset a rule */
# define NOP            138 /* no operation */
# define BOP            139 /* beginning of page */
# define EOP            140 /* ending of page */
# define PUSH           141 /* save the current positions */
# define POP            142 /* restore previous positions */
# define RIGHT1         143 /* move right */
# define RIGHT2         144 /* move right */
# define RIGHT3         145 /* move right */
# define RIGHT4         146 /* move right */
# define W0             147 /* move right by |w| */
# define W1             148 /* move right and set |w| */
# define W2             149 /* move right and set |w| */
# define W3             150 /* move right and set |w| */
# define W4             151 /* move right and set |w| */
# define X0             152 /* move right by |x| */
# define X1             153 /* move right and set |x| */
# define X2             154 /* move right and set |x| */
# define X3             155 /* move right and set |x| */
# define X4             156 /* move right and set |x| */
# define DOWN1          157 /* move down */
# define DOWN2          158 /* move down */
# define DOWN3          159 /* move down */
# define DOWN4          160 /* move down */
# define Y0             161 /* move down by |y| */
# define Y1             162 /* move down and set |y| */
# define Y2             163 /* move down and set |y| */
# define Y3             164 /* move down and set |y| */
# define Y4             165 /* move down and set |y| */
# define Z0             166 /* move down by |z| */
# define Z1             167 /* move down and set |z| */
# define Z2             168 /* move down and set |z| */
# define Z3             169 /* move down and set |z| */
# define Z4             170 /* move down and set |z| */
# define FNT_NUM_0      171 /* set current font to 0 */
# define FNT_NUM_63     234 /* set current font to 63 */
# define FNT1           235 /* set current font */
# define FNT2           236 /* set current font */
# define FNT3           237 /* set current font */
# define FNT4           238 /* set current font */
# define XXX1           239 /* extension to DVI primitives */
# define XXX2           240 /* extension to DVI primitives */
# define XXX3           241 /* extension to DVI primitives */
# define XXX4           242 /* potentially long extension to DVI primitives */
# define FNT_DEF1       243 /* define the meaning of a font number */
# define FNT_DEF2       244 /* define the meaning of a font number */
# define FNT_DEF3       245 /* define the meaning of a font number */
# define FNT_DEF4       246 /* define the meaning of a font number */
# define PRE            247 /* preamble */
# define POST           248 /* postamble beginning */
# define POST_POST      249 /* postamble ending */
# define DVI_ID_BYTE    2   /* ID-Byte for DVI Files */

extern int dvi_fs2(void);
extern long dvi_fs3(void), dvi_fs4(void);
extern unsigned dvi_fu2(void);
extern unsigned long dvi_fu3(void), dvi_fu4(void);
