/*
 * generated by dat2c
 * option -7 per block
 * option -w not given: use two bytes for the index 
 * option -m not given: generate main() 
 * option -c 11 : use as the catcode in the first two blocks
 * option template -t utf_tables.b
 * option output -o hitex.dat.c
 * input luatex.dat
 */

#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>

#ifndef UTF_OVERFLOW
#define UTF_OVERFLOW(A,B) utf_overflow(A,B)

void utf_overflow(char* msg, int i)
{ fprintf(stderr,"ERROR: %s %d",msg, i);
  exit(1);
}
#endif

typedef struct {
  uint32_t lc,uc;
  int32_t dc;
  uint32_t slot;
  int16_t famcls,sf;
  uint8_t ref, cat;
} Utf_Info;

static int utf_i_equal(Utf_Info *a, Utf_Info *b)
{ return a->lc==b->lc && a->uc==b->uc && a->dc==b->dc && a->slot==b->slot &&
    a->famcls==b->famcls &&  a->sf==b->sf && a->cat==b->cat;
}

#define UTF_I_NUM 0x100
static int utf_i_avail = 186;  /*begin of the avail stack */
static int utf_i_top = 186-1;  /*highest location in use */
static int utf_i_used = 186-1; /*number of locations in use*/
static Utf_Info utf_infos[UTF_I_NUM] = {
/*   0 */ {0x110000, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0xff, 11},
/*   1 */ {0x000000, 0x000000, 0xffffffff, 0x110000, 0x001e,999, 0x8a, 11},
/*   2 */ {0x110020, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0xcc, 11},
/*   3 */ {0x110000, 0x10ffe0, 0xffffffff, 0x110000, 0x001e,999, 0x38, 11},
/*   4 */ {0x110000, 0x1102e7, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/*   5 */ {0x110000, 0x110079, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/*   6 */ {0x110001, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0xff, 11},
/*   7 */ {0x110000, 0x10ffff, 0xffffffff, 0x110000, 0x001e,1000, 0xff, 11},
/*   8 */ {0x10ff39, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/*   9 */ {0x110000, 0x10ff18, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/*  10 */ {0x110000, 0x110000, 0xffffffff, 0x110000, 0x001e,1000, 0xff, 11},
/*  11 */ {0x10ff87, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/*  12 */ {0x110000, 0x10fed4, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/*  13 */ {0x110000, 0x1100c3, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/*  14 */ {0x1100d2, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/*  15 */ {0x1100ce, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/*  16 */ {0x1100cd, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x3, 11},
/*  17 */ {0x11004f, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/*  18 */ {0x1100ca, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/*  19 */ {0x1100cb, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/*  20 */ {0x1100cf, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/*  21 */ {0x110000, 0x110061, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/*  22 */ {0x1100d3, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x2, 11},
/*  23 */ {0x1100d1, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/*  24 */ {0x110000, 0x1100a3, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/*  25 */ {0x1100d5, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/*  26 */ {0x110000, 0x110082, 0xffffffff, 0x110000, 0x001e,1000, 0x4, 11},
/*  27 */ {0x1100d6, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/*  28 */ {0x1100da, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x3, 11},
/*  29 */ {0x1100d9, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x2, 11},
/*  30 */ {0x1100db, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/*  31 */ {0x110000, 0x110038, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/*  32 */ {0x110002, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x4, 11},
/*  33 */ {0x110001, 0x10ffff, 0xffffffff, 0x110000, 0x001e,1000, 0x4, 11},
/*  34 */ {0x110000, 0x10fffe, 0xffffffff, 0x110000, 0x001e,1000, 0x4, 11},
/*  35 */ {0x110000, 0x10ffb1, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/*  36 */ {0x10ff9f, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/*  37 */ {0x10ffc8, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/*  38 */ {0x10ff7e, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x4, 11},
/*  39 */ {0x112a2b, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/*  40 */ {0x10ff5d, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/*  41 */ {0x112a28, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/*  42 */ {0x110000, 0x112a3f, 0xffffffff, 0x110000, 0x001e,1000, 0x2, 11},
/*  43 */ {0x10ff3d, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/*  44 */ {0x110045, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/*  45 */ {0x110047, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/*  46 */ {0x110000, 0x112a1f, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/*  47 */ {0x110000, 0x112a1c, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/*  48 */ {0x110000, 0x112a1e, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/*  49 */ {0x110000, 0x10ff2e, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/*  50 */ {0x110000, 0x10ff32, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/*  51 */ {0x110000, 0x10ff33, 0xffffffff, 0x110000, 0x001e,1000, 0x3, 11},
/*  52 */ {0x110000, 0x10ff36, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/*  53 */ {0x110000, 0x10ff35, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/*  54 */ {0x110000, 0x11a54f, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/*  55 */ {0x110000, 0x11a54b, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/*  56 */ {0x110000, 0x10ff31, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/*  57 */ {0x110000, 0x11a528, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/*  58 */ {0x110000, 0x11a544, 0xffffffff, 0x110000, 0x001e,1000, 0x2, 11},
/*  59 */ {0x110000, 0x10ff2f, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/*  60 */ {0x110000, 0x10ff2d, 0xffffffff, 0x110000, 0x001e,1000, 0x2, 11},
/*  61 */ {0x110000, 0x1129f7, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/*  62 */ {0x110000, 0x11a541, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/*  63 */ {0x110000, 0x1129fd, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/*  64 */ {0x110000, 0x10ff2b, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/*  65 */ {0x110000, 0x10ff2a, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/*  66 */ {0x110000, 0x1129e7, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/*  67 */ {0x110000, 0x10ff26, 0xffffffff, 0x110000, 0x001e,1000, 0x3, 11},
/*  68 */ {0x110000, 0x11a543, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/*  69 */ {0x110000, 0x11a52a, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/*  70 */ {0x110000, 0x10ffbb, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/*  71 */ {0x110000, 0x10ff27, 0xffffffff, 0x110000, 0x001e,1000, 0x2, 11},
/*  72 */ {0x110000, 0x10ffb9, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/*  73 */ {0x110000, 0x10ff25, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/*  74 */ {0x110000, 0x11a515, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/*  75 */ {0x110000, 0x11a512, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/*  76 */ {0x000000, 0x000000, 0xffffffff, 0x110000, 0x0000,1000, 0xff, 12},
/*  77 */ {0x110074, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/*  78 */ {0x110026, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/*  79 */ {0x110025, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x3, 11},
/*  80 */ {0x110040, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x34, 11},
/*  81 */ {0x11003f, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x2, 11},
/*  82 */ {0x110000, 0x10ffda, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/*  83 */ {0x110000, 0x10ffdb, 0xffffffff, 0x110000, 0x001e,1000, 0x3, 11},
/*  84 */ {0x110000, 0x10ffe0, 0xffffffff, 0x110000, 0x001e,1000, 0x94, 11},
/*  85 */ {0x110000, 0x10ffe1, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/*  86 */ {0x110000, 0x10ffc0, 0xffffffff, 0x110000, 0x001e,1000, 0x34, 11},
/*  87 */ {0x110000, 0x10ffc1, 0xffffffff, 0x110000, 0x001e,1000, 0x2, 11},
/*  88 */ {0x110008, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x7, 11},
/*  89 */ {0x110000, 0x10ffc2, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/*  90 */ {0x110000, 0x10ffc7, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/*  91 */ {0x110000, 0x10ffd1, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/*  92 */ {0x110000, 0x10ffca, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/*  93 */ {0x110000, 0x10fff8, 0xffffffff, 0x110000, 0x001e,1000, 0x7, 11},
/*  94 */ {0x110000, 0x10ffaa, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/*  95 */ {0x110000, 0x10ffb0, 0xffffffff, 0x110000, 0x001e,1000, 0x11, 11},
/*  96 */ {0x110000, 0x110007, 0xffffffff, 0x110000, 0x001e,1000, 0x2, 11},
/*  97 */ {0x110000, 0x10ff8c, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/*  98 */ {0x10ffc4, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/*  99 */ {0x110000, 0x10ffa0, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/* 100 */ {0x10fff9, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x2, 11},
/* 101 */ {0x110050, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x10, 11},
/* 102 */ {0x11000f, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/* 103 */ {0x110000, 0x10fff1, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/* 104 */ {0x110030, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x56, 11},
/* 105 */ {0x110000, 0x10ffd0, 0xffffffff, 0x110000, 0x001e,1000, 0x56, 11},
/* 106 */ {0x000000, 0x000000, 0xffffffff, 0x110000, 0x0000,0, 0x53, 12},
/* 107 */ {0x111c60, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x28, 11},
/* 108 */ {0x110000, 0x110bc0, 0xffffffff, 0x110000, 0x001e,1000, 0x2e, 11},
/* 109 */ {0x1197d0, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x50, 11},
/* 110 */ {0x110000, 0x10e792, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/* 111 */ {0x110000, 0x10e793, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/* 112 */ {0x110000, 0x10e79c, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/* 113 */ {0x110000, 0x10e79e, 0xffffffff, 0x110000, 0x001e,1000, 0x2, 11},
/* 114 */ {0x110000, 0x10e79d, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/* 115 */ {0x110000, 0x10e7a4, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/* 116 */ {0x110000, 0x10e7db, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/* 117 */ {0x110000, 0x1189c2, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/* 118 */ {0x10f440, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x2e, 11},
/* 119 */ {0x110000, 0x118a04, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/* 120 */ {0x110000, 0x110ee6, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/* 121 */ {0x110000, 0x118a38, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/* 122 */ {0x110000, 0x10ffc5, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/* 123 */ {0x10e241, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/* 124 */ {0x110000, 0x110008, 0xffffffff, 0x110000, 0x001e,1000, 0x4e, 11},
/* 125 */ {0x10fff8, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x36, 11},
/* 126 */ {0x110000, 0x11004a, 0xffffffff, 0x110000, 0x001e,1000, 0x2, 11},
/* 127 */ {0x110000, 0x110056, 0xffffffff, 0x110000, 0x001e,1000, 0x4, 11},
/* 128 */ {0x110000, 0x110064, 0xffffffff, 0x110000, 0x001e,1000, 0x2, 11},
/* 129 */ {0x110000, 0x110080, 0xffffffff, 0x110000, 0x001e,1000, 0x2, 11},
/* 130 */ {0x110000, 0x110070, 0xffffffff, 0x110000, 0x001e,1000, 0x2, 11},
/* 131 */ {0x110000, 0x11007e, 0xffffffff, 0x110000, 0x001e,1000, 0x2, 11},
/* 132 */ {0x10fff8, 0x110000, 0xffffffff, 0x110000, 0x001e,1000, 0x18, 11},
/* 133 */ {0x110000, 0x110009, 0xffffffff, 0x110000, 0x001e,1000, 0x3, 11},
/* 134 */ {0x10ffb6, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x2, 11},
/* 135 */ {0x10fff7, 0x110000, 0xffffffff, 0x110000, 0x001e,1000, 0x3, 11},
/* 136 */ {0x110000, 0x10e3db, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/* 137 */ {0x10ffaa, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x4, 11},
/* 138 */ {0x10ff9c, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x2, 11},
/* 139 */ {0x10ff90, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x2, 11},
/* 140 */ {0x10ff80, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x2, 11},
/* 141 */ {0x10ff82, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x2, 11},
/* 142 */ {0x10e2a3, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/* 143 */ {0x10df41, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/* 144 */ {0x10dfba, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/* 145 */ {0x11001c, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/* 146 */ {0x110000, 0x10ffe4, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/* 147 */ {0x110010, 0x000000, 0xffffffff, 0x110000, 0x0000,1000, 0x10, 12},
/* 148 */ {0x000000, 0x10fff0, 0xffffffff, 0x110000, 0x0000,1000, 0x10, 12},
/* 149 */ {0x11001a, 0x000000, 0xffffffff, 0x110000, 0x0000,1000, 0x1a, 12},
/* 150 */ {0x000000, 0x10ffe6, 0xffffffff, 0x110000, 0x0000,1000, 0x1a, 12},
/* 151 */ {0x10d609, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/* 152 */ {0x10f11a, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/* 153 */ {0x10d619, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/* 154 */ {0x110000, 0x10d5d5, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/* 155 */ {0x110000, 0x10d5d8, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/* 156 */ {0x10d5e4, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/* 157 */ {0x10d603, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/* 158 */ {0x10d5e1, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/* 159 */ {0x10d5e2, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/* 160 */ {0x10d5c1, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x2, 11},
/* 161 */ {0x110000, 0x10e3a0, 0xffffffff, 0x110000, 0x001e,1000, 0x28, 11},
/* 162 */ {0x110000, 0x110000, 0xffffffff, 0x110000, 0x0000,1000, 0xff, 11},
/* 163 */ {0x1075fc, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/* 164 */ {0x105ad8, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/* 165 */ {0x110000, 0x110030, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/* 166 */ {0x105abc, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x2, 11},
/* 167 */ {0x105ab1, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/* 168 */ {0x105ab5, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/* 169 */ {0x105abf, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/* 170 */ {0x105aee, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/* 171 */ {0x105ad6, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/* 172 */ {0x105aeb, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/* 173 */ {0x1103a0, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/* 174 */ {0x10ffd0, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/* 175 */ {0x105abd, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/* 176 */ {0x1075c8, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x1, 11},
/* 177 */ {0x110000, 0x10fc60, 0xffffffff, 0x110000, 0x001e,1000, 0x1, 11},
/* 178 */ {0x110000, 0x106830, 0xffffffff, 0x110000, 0x001e,1000, 0x50, 11},
/* 179 */ {0x000000, 0x000000, 0xffffffff, 0x110000, 0x0000,1000, 0x1,  9},
/* 180 */ {0x110028, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x4c, 11},
/* 181 */ {0x110000, 0x10ffd8, 0xffffffff, 0x110000, 0x001e,1000, 0x4c, 11},
/* 182 */ {0x110027, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x23, 11},
/* 183 */ {0x110000, 0x10ffd9, 0xffffffff, 0x110000, 0x001e,1000, 0x23, 11},
/* 184 */ {0x110022, 0x110000, 0xffffffff, 0x110000, 0x001e,999, 0x22, 11},
/* 185 */ {0x110000, 0x10ffde, 0xffffffff, 0x110000, 0x001e,1000, 0x22, 11},
/* 186 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 187, 0x0,  0},
/* 187 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 188, 0x0,  0},
/* 188 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 189, 0x0,  0},
/* 189 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 190, 0x0,  0},
/* 190 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 191, 0x0,  0},
/* 191 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 192, 0x0,  0},
/* 192 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 193, 0x0,  0},
/* 193 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 194, 0x0,  0},
/* 194 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 195, 0x0,  0},
/* 195 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 196, 0x0,  0},
/* 196 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 197, 0x0,  0},
/* 197 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 198, 0x0,  0},
/* 198 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 199, 0x0,  0},
/* 199 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 200, 0x0,  0},
/* 200 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 201, 0x0,  0},
/* 201 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 202, 0x0,  0},
/* 202 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 203, 0x0,  0},
/* 203 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 204, 0x0,  0},
/* 204 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 205, 0x0,  0},
/* 205 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 206, 0x0,  0},
/* 206 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 207, 0x0,  0},
/* 207 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 208, 0x0,  0},
/* 208 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 209, 0x0,  0},
/* 209 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 210, 0x0,  0},
/* 210 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 211, 0x0,  0},
/* 211 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 212, 0x0,  0},
/* 212 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 213, 0x0,  0},
/* 213 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 214, 0x0,  0},
/* 214 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 215, 0x0,  0},
/* 215 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 216, 0x0,  0},
/* 216 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 217, 0x0,  0},
/* 217 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 218, 0x0,  0},
/* 218 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 219, 0x0,  0},
/* 219 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 220, 0x0,  0},
/* 220 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 221, 0x0,  0},
/* 221 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 222, 0x0,  0},
/* 222 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 223, 0x0,  0},
/* 223 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 224, 0x0,  0},
/* 224 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 225, 0x0,  0},
/* 225 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 226, 0x0,  0},
/* 226 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 227, 0x0,  0},
/* 227 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 228, 0x0,  0},
/* 228 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 229, 0x0,  0},
/* 229 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 230, 0x0,  0},
/* 230 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 231, 0x0,  0},
/* 231 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 232, 0x0,  0},
/* 232 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 233, 0x0,  0},
/* 233 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 234, 0x0,  0},
/* 234 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 235, 0x0,  0},
/* 235 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 236, 0x0,  0},
/* 236 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 237, 0x0,  0},
/* 237 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 238, 0x0,  0},
/* 238 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 239, 0x0,  0},
/* 239 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 240, 0x0,  0},
/* 240 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 241, 0x0,  0},
/* 241 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 242, 0x0,  0},
/* 242 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 243, 0x0,  0},
/* 243 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 244, 0x0,  0},
/* 244 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 245, 0x0,  0},
/* 245 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 246, 0x0,  0},
/* 246 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 247, 0x0,  0},
/* 247 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 248, 0x0,  0},
/* 248 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 249, 0x0,  0},
/* 249 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 250, 0x0,  0},
/* 250 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 251, 0x0,  0},
/* 251 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 252, 0x0,  0},
/* 252 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 253, 0x0,  0},
/* 253 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 254, 0x0,  0},
/* 254 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, 255, 0x0,  0},
/* 255 */ {0x000000, 0x000000, 0x00000000, 0x000000, 0x0000, -1, 0x0,  0}

};

#define UTF_B_BITS 7
#define UTF_B_SIZE (1<<UTF_B_BITS)
#define UTF_B_MASK (UTF_B_SIZE-1)
#define UTF_B_NUM  0x100
static int utf_b_used = 0xD4;
static uint8_t utf_blocks[UTF_B_NUM][UTF_B_SIZE] = {
/*0 ref=1 */ {
0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,
1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1},
/*1 ref=1 */ {
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,
1,1,1,1,1,4,1,1,1,1,0,1,1,1,1,1,
2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,1,2,2,2,2,2,2,2,0,
3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,5},
/*2 ref=1 */ {
6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,7,
6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,7,
6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,7,
8,9,6,7,6,7,6,7,10,6,7,6,7,6,7,6,
7,6,7,6,7,6,7,6,7,10,6,7,6,7,6,7,
6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,7,
6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,7,
6,7,6,7,6,7,6,7,11,6,7,6,7,6,7,12},
/*3 ref=1 */ {
13,14,6,7,6,7,15,6,7,16,16,6,7,10,17,18,
19,6,7,16,20,21,22,23,6,7,24,10,22,25,26,27,
6,7,6,7,6,7,28,6,7,28,10,10,6,7,28,6,
7,29,29,6,7,6,7,30,6,7,10,10,6,7,10,31,
10,10,10,10,32,33,34,32,33,34,32,33,34,6,7,6,
7,6,7,6,7,6,7,6,7,6,7,6,7,35,6,7,
6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,7,
10,32,33,34,6,7,36,37,6,7,6,7,6,7,6,7},
/*4 ref=1 */ {
6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,7,
6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,7,
38,10,6,7,6,7,6,7,6,7,6,7,6,7,6,7,
6,7,6,7,10,10,10,10,10,10,39,6,7,40,41,42,
42,6,7,43,44,45,6,7,6,7,6,7,6,7,6,7,
46,47,48,49,50,10,51,51,10,52,10,53,54,10,10,10,
51,55,10,56,10,57,58,10,59,60,58,61,62,10,10,60,
10,63,64,10,10,65,10,10,10,10,10,10,10,66,10,10},
/*5 ref=1 */ {
67,10,68,67,10,10,10,69,67,70,71,71,72,10,10,10,
10,10,73,10,10,10,10,10,10,10,10,10,10,74,75,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,76,76,76,76,10,10,10,10,10,10,10,10,10,10,
10,10,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,76,76,76,76,76,76,76,10,76,10,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*6 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
6,7,6,7,10,76,6,7,76,76,10,26,26,26,76,77},
/*7 ref=1 */ {
76,76,76,76,76,76,78,76,79,79,79,76,80,76,81,81,
10,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,76,2,2,2,2,2,2,2,2,2,82,83,83,83,
10,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
84,84,85,84,84,84,84,84,84,84,84,84,86,87,87,88,
89,90,0,0,0,91,92,93,6,7,6,7,6,7,6,7,
6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,7,
94,95,96,97,98,99,76,6,7,100,6,7,10,38,38,38},
/*8 ref=1 */ {
101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,
2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,
6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,7,
6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,7},
/*9 ref=1 */ {
6,7,76,10,10,10,10,10,10,10,6,7,6,7,6,7,
6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,7,
6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,7,
6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,7,
102,6,7,6,7,6,7,6,7,6,7,6,7,6,7,103,
6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,7,
6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,7,
6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,7},
/*10 ref=1 */ {
6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,7,
6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,7,
6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,7,
76,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
104,104,104,104,104,104,104,76,76,10,76,76,76,76,76,76,
10,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105},
/*11 ref=1 */ {
105,105,105,105,105,105,105,10,10,76,76,76,76,76,76,76,
76,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,76,10,
76,10,10,76,10,10,76,10,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,76,76,76,76,10,
10,10,10,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*12 ref=1 */ {
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10},
/*13 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,76,10,10,10,10,10,10,10,10,76,76,10,
10,10,10,10,10,10,10,10,10,76,10,10,10,10,10,10,
76,76,76,76,76,76,76,76,76,76,10,10,10,76,76,10},
/*14 ref=1 */ {
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,76,76,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10},
/*15 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,76,76,76,76,10,76,76,10,76,76},
/*16 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10},
/*17 ref=1 */ {
10,10,10,10,10,10,10,10,76,10,10,10,10,10,10,76,
76,76,76,76,76,76,76,76,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,76,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10},
/*18 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,76,76,76,76,76,76,76,76,76,76,76,76,
76,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10},
/*19 ref=1 */ {
10,10,10,10,76,10,10,10,10,10,10,10,10,76,76,10,
10,76,76,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,76,10,10,10,10,10,10,
10,76,10,76,76,76,10,10,10,10,76,76,10,10,10,10,
10,10,10,10,10,76,76,10,10,76,76,10,10,10,10,76,
76,76,76,76,76,76,76,10,76,76,76,76,10,10,76,10,
10,10,10,10,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,76,76,76,76,76,76,76,76,76,76,10,76,10,76},
/*20 ref=1 */ {
76,10,10,10,76,10,10,10,10,10,10,76,76,76,76,10,
10,76,76,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,76,10,10,10,10,10,10,
10,76,10,10,76,10,10,76,10,10,76,76,10,76,10,10,
10,10,10,76,76,76,76,10,10,76,76,10,10,10,76,76,
76,10,76,76,76,76,76,76,76,10,10,10,10,76,10,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,76,76,76,76,76,76,76,76,76,76},
/*21 ref=1 */ {
76,10,10,10,76,10,10,10,10,10,10,10,10,10,76,10,
10,10,76,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,76,10,10,10,10,10,10,
10,76,10,10,76,10,10,10,10,10,76,76,10,10,10,10,
10,10,10,10,10,10,76,10,10,10,76,10,10,10,76,76,
10,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,10,10,10,10,10,10,10},
/*22 ref=1 */ {
76,10,10,10,76,10,10,10,10,10,10,10,10,76,76,10,
10,76,76,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,76,10,10,10,10,10,10,
10,76,10,10,76,10,10,10,10,10,76,76,10,10,10,10,
10,10,10,10,10,76,76,10,10,76,76,10,10,10,76,76,
76,76,76,76,76,10,10,10,76,76,76,76,10,10,76,10,
10,10,10,10,76,76,76,76,76,76,76,76,76,76,76,76,
76,10,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*23 ref=1 */ {
76,76,10,10,76,10,10,10,10,10,10,76,76,76,10,10,
10,76,10,10,10,10,76,76,76,10,10,76,10,76,10,10,
76,76,76,10,10,76,76,76,10,10,10,76,76,76,10,10,
10,10,10,10,10,10,10,10,10,10,76,76,76,76,10,10,
10,10,10,76,76,76,10,10,10,76,10,10,10,10,76,76,
10,76,76,76,76,76,76,10,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*24 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,76,10,10,
10,76,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,76,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,76,76,10,10,10,10,
10,10,10,10,10,76,10,10,10,76,10,10,10,10,76,76,
76,76,76,76,76,10,10,76,10,10,10,76,76,10,76,76,
10,10,10,10,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*25 ref=1 */ {
10,10,10,10,76,10,10,10,10,10,10,10,10,76,10,10,
10,76,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,76,10,10,10,10,10,10,
10,10,10,10,76,10,10,10,10,10,76,76,10,10,10,10,
10,10,10,10,10,76,10,10,10,76,10,10,10,10,76,76,
76,76,76,76,76,10,10,76,76,76,76,76,76,10,10,76,
10,10,10,10,76,76,76,76,76,76,76,76,76,76,76,76,
76,10,10,10,76,76,76,76,76,76,76,76,76,76,76,76},
/*26 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,76,10,10,
10,76,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,76,10,10,10,76,10,10,10,10,10,76,
76,76,76,76,10,10,10,10,76,76,76,76,76,76,76,10,
10,10,10,10,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,10,10,10,10,10,10},
/*27 ref=1 */ {
76,10,10,10,76,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,76,76,76,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,76,10,10,10,10,10,10,10,10,10,76,10,76,76,
10,10,10,10,10,10,10,76,76,76,10,76,76,76,76,10,
10,10,10,10,10,76,10,76,10,10,10,10,10,10,10,10,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,10,10,76,76,76,76,76,76,76,76,76,76,76,76},
/*28 ref=1 */ {
76,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*29 ref=1 */ {
76,10,10,76,10,76,10,10,10,10,10,76,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,76,10,76,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,76,76,
10,10,10,10,10,76,10,76,10,10,10,10,10,10,10,76,
76,76,76,76,76,76,76,76,76,76,76,76,10,10,10,10,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*30 ref=1 */ {
10,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,10,10,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,10,76,10,76,10,76,106,76,106,10,10,
10,10,10,10,10,10,10,10,76,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,76,76,76,
76,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10},
/*31 ref=1 */ {
10,10,10,10,10,76,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,76,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,76,76,76,
76,76,76,76,76,76,10,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*32 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10},
/*33 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
76,76,76,76,76,76,76,76,76,76,10,10,10,10,76,76,
107,107,107,107,107,107,107,107,107,107,107,107,107,107,107,107,
107,107,107,107,107,107,107,107,107,107,107,107,107,107,107,107,
107,107,107,107,107,107,76,107,76,76,76,76,76,107,76,76,
108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,
108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,
108,108,108,108,108,108,108,108,108,108,108,76,10,108,108,108},
/*34 ref=65 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10},
/*35 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,76,10,10,10,10,76,76,
10,10,10,10,10,10,10,76,10,76,10,10,10,10,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10},
/*36 ref=1 */ {
10,10,10,10,10,10,10,10,10,76,10,10,10,10,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,76,10,10,10,10,76,76,10,10,10,10,10,10,10,76,
10,76,10,10,10,10,76,76,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,76,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10},
/*37 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,76,10,10,10,10,76,76,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,76,76,10,10,10,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*38 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,
109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,
109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,
109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,
109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,
88,88,88,88,88,88,76,76,93,93,93,93,93,93,76,76},
/*39 ref=1 */ {
76,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10},
/*40 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,76,76,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10},
/*41 ref=1 */ {
76,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,76,106,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,76,76,76,76,76,
76,10,10,10,10,10,10,10,10,76,76,76,76,76,76,76},
/*42 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,76,76,76,76,76,76,76,76,76,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,76,10,10,
10,76,10,10,76,76,76,76,76,76,76,76,76,76,76,76},
/*43 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,76,76,76,10,76,76,76,76,10,10,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*44 ref=1 */ {
76,76,76,76,76,76,76,76,76,76,76,10,10,10,76,10,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,76,76,76,76,76,76,76},
/*45 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,76,76,76,76,76,76,76,76,76,76},
/*46 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,76,
10,10,10,10,10,10,10,10,10,10,10,10,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,76,76,
10,10,10,10,10,76,76,76,76,76,76,76,76,76,76,76},
/*47 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*48 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,76,76,10},
/*49 ref=1 */ {
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,10,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*50 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,10,10,10,10,10,
10,10,10,10,76,76,76,76,76,76,76,76,76,76,76,76},
/*51 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
76,76,76,76,76,76,76,76,76,76,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,76,76,76,76,76,76,76,76,76,76,76,76},
/*52 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,10,10,10,
76,76,76,76,76,76,76,76,76,76,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,76,76},
/*53 ref=1 */ {
110,111,112,113,113,114,115,116,117,76,76,76,76,76,76,76,
118,118,118,118,118,118,118,118,118,118,118,118,118,118,118,118,
118,118,118,118,118,118,118,118,118,118,118,118,118,118,118,118,
118,118,118,118,118,118,118,118,118,118,118,76,76,118,118,118,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,76,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,76,76,76,76,76},
/*54 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,119,10,10,10,120,10,10},
/*55 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,121,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10},
/*56 ref=1 */ {
6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,7,
6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,7,
6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,7,
6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,7,
6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,7,
6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,7,
6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,7,
6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,7},
/*57 ref=1 */ {
6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,7,
6,7,6,7,6,7,10,10,10,10,10,122,10,10,123,10,
6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,7,
6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,7,
6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,7,
6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,7,
6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,7,
6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,7},
/*58 ref=1 */ {
124,124,124,124,124,124,124,124,125,125,125,125,125,125,125,125,
124,124,124,124,124,124,76,76,125,125,125,125,125,125,76,76,
124,124,124,124,124,124,124,124,125,125,125,125,125,125,125,125,
124,124,124,124,124,124,124,124,125,125,125,125,125,125,125,125,
124,124,124,124,124,124,76,76,125,125,125,125,125,125,76,76,
10,124,10,124,10,124,10,124,76,125,76,125,76,125,76,125,
124,124,124,124,124,124,124,124,125,125,125,125,125,125,125,125,
126,126,127,127,127,127,128,128,129,129,130,130,131,131,76,76},
/*59 ref=1 */ {
124,124,124,124,124,124,124,124,132,132,132,132,132,132,132,132,
124,124,124,124,124,124,124,124,132,132,132,132,132,132,132,132,
124,124,124,124,124,124,124,124,132,132,132,132,132,132,132,132,
124,124,10,133,10,76,10,10,125,125,134,134,135,76,136,76,
76,76,10,133,10,76,10,10,137,137,137,137,135,76,76,76,
124,124,10,10,76,76,10,10,125,125,138,138,76,76,76,76,
124,124,10,10,10,96,10,10,125,125,139,139,100,76,76,76,
76,76,10,133,10,76,10,10,140,140,141,141,135,76,76,76},
/*60 ref=1 */ {
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,106,76,76,76,106,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,106,76,76,76,76,76,
76,76,76,76,76,76,106,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,10,76,76,76,76,76,76,76,76,76,76,76,76,106,10},
/*61 ref=1 */ {
76,76,76,76,76,76,76,76,76,76,76,76,76,76,106,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*62 ref=1 */ {
76,76,0,76,76,76,76,0,76,76,10,0,0,0,10,10,
0,0,0,10,76,0,76,76,76,0,0,0,0,0,76,76,
76,76,76,76,0,76,142,76,0,76,143,144,0,0,76,10,
0,0,145,0,10,10,10,10,10,10,76,76,10,10,0,0,
76,76,76,76,76,0,10,10,10,10,76,76,76,76,146,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
147,147,147,147,147,147,147,147,147,147,147,147,147,147,147,147,
148,148,148,148,148,148,148,148,148,148,148,148,148,148,148,148},
/*63 ref=1 */ {
76,76,76,6,7,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*64 ref=255 */ {
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*65 ref=1 */ {
76,76,76,76,76,76,76,76,76,106,76,106,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,106,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*66 ref=1 */ {
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,149,149,149,149,149,149,149,149,149,149,
149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,
150,150,150,150,150,150,150,150,150,150,150,150,150,150,150,150,
150,150,150,150,150,150,150,150,150,150,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*67 ref=1 */ {
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,106,76,106,76,106,76,106,
76,106,76,106,76,106,76,76,76,76,76,76,76,76,76,76},
/*68 ref=1 */ {
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,106,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,106,76,106,76,106,76,106,76,106,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*69 ref=1 */ {
76,76,76,76,106,76,106,76,106,76,106,76,106,76,106,76,
106,76,106,76,106,76,106,76,106,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,106,76,106,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,106,76,76},
/*70 ref=1 */ {
104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
6,7,151,152,153,154,155,6,7,6,7,6,7,156,157,158,
159,10,6,7,10,6,7,10,10,10,10,10,10,10,160,160},
/*71 ref=1 */ {
6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,7,
6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,7,
6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,7,
6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,7,
6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,7,
6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,7,
6,7,6,7,10,76,76,76,76,76,76,6,7,6,7,10,
10,10,6,7,76,76,76,76,76,76,76,76,76,76,76,76},
/*72 ref=1 */ {
161,161,161,161,161,161,161,161,161,161,161,161,161,161,161,161,
161,161,161,161,161,161,161,161,161,161,161,161,161,161,161,161,
161,161,161,161,161,161,76,161,76,76,76,76,76,161,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,76,76,76,76,76,76,76,10,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,10},
/*73 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,76,10,10,10,10,10,10,10,76,
10,10,10,10,10,10,10,76,10,10,10,10,10,10,10,76,
10,10,10,10,10,10,10,76,10,10,10,10,10,10,10,76,
10,10,10,10,10,10,10,76,10,10,10,10,10,10,10,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10},
/*74 ref=1 */ {
76,76,76,106,76,106,76,76,76,76,106,76,76,106,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,106,76,76,
76,106,76,106,76,106,76,106,76,106,76,76,76,76,76,10,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,106,76,106,76,106,76,106,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*75 ref=1 */ {
76,76,76,76,76,10,10,76,76,106,76,106,76,106,76,106,
76,106,76,76,76,106,76,106,76,106,76,106,76,76,106,106,
76,76,76,76,76,76,76,76,76,76,10,10,10,10,10,10,
76,10,10,10,10,10,76,76,76,76,76,10,10,76,76,76,
76,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10},
/*76 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,76,76,10,10,76,76,10,10,10,
76,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,76,10,10,10,10},
/*77 ref=1 */ {
76,76,76,76,76,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
76,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10},
/*78 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10},
/*79 ref=255 */ {
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162},
/*80 ref=1 */ {
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*81 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,76,76},
/*82 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
76,76,76,76,76,76,76,76,76,76,10,10,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,7,
6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,7,
6,7,6,7,6,7,6,7,6,7,6,7,6,7,10,10,
10,10,10,76,10,10,10,10,10,10,10,10,10,10,76,10},
/*83 ref=1 */ {
6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,7,
6,7,6,7,6,7,6,7,6,7,6,7,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,76,76,76,76,76,76,76,76,76,76,
10,10,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*84 ref=1 */ {
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,10,10,10,10,10,10,10,10,10,
76,76,6,7,6,7,6,7,6,7,6,7,6,7,6,7,
10,10,6,7,6,7,6,7,6,7,6,7,6,7,6,7,
6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,7,
6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,7,
6,7,6,7,6,7,6,7,6,7,6,7,6,7,6,7,
10,10,10,10,10,10,10,10,10,6,7,6,7,163,6,7},
/*85 ref=1 */ {
6,7,6,7,6,7,6,7,10,76,76,6,7,164,10,10,
6,7,6,7,165,10,6,7,6,7,6,7,6,7,6,7,
6,7,6,7,6,7,6,7,6,7,166,167,168,169,166,10,
170,171,172,173,6,7,6,7,6,7,6,7,6,7,6,7,
6,7,6,7,174,175,176,6,7,6,7,76,76,76,76,76,
6,7,76,10,76,10,6,7,6,7,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,10,10,10,6,7,10,10,10,10,10,10,10,10,10},
/*86 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,76,76,76,76,10,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,76,76,76,76,76,76,76,76,76,76,76,76},
/*87 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,76,76,76,10,76,10,10,10},
/*88 ref=1 */ {
76,76,76,76,76,76,76,76,76,76,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,76,76,76},
/*89 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,76,76,76,76,76,76,76,76,76,76,76,76,76,76,10,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
76,76,76,76,76,76,76,76,76,76,10,10,10,10,10,76},
/*90 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,76,76,76,10,10,10,10,10,10},
/*91 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,10,10,10,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
76,76,10,10,10,10,10,76,76,76,76,76,76,76,76,76},
/*92 ref=1 */ {
76,10,10,10,10,10,10,76,76,10,10,10,10,10,10,76,
76,10,10,10,10,10,10,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,76,10,10,10,10,10,10,10,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,177,10,10,10,10,10,10,10,76,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,76,76,76,76,76,76,
178,178,178,178,178,178,178,178,178,178,178,178,178,178,178,178},
/*93 ref=1 */ {
178,178,178,178,178,178,178,178,178,178,178,178,178,178,178,178,
178,178,178,178,178,178,178,178,178,178,178,178,178,178,178,178,
178,178,178,178,178,178,178,178,178,178,178,178,178,178,178,178,
178,178,178,178,178,178,178,178,178,178,178,178,178,178,178,178,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,76,10,10,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*94 ref=1 */ {
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,76,76,76,76,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,76,76,76,76},
/*95 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10},
/*96 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*97 ref=1 */ {
10,10,10,10,10,10,10,76,76,76,76,76,76,76,76,76,
76,76,76,10,10,10,10,10,76,76,76,76,76,10,10,10,
10,10,10,10,10,10,10,10,10,76,10,10,10,10,10,10,
10,10,10,10,10,10,10,76,10,10,10,10,10,76,10,76,
10,10,76,10,10,76,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10},
/*98 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10},
/*99 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,106,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10},
/*100 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
76,76,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,76,76,76,76},
/*101 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
76,76,76,76,76,76,76,76,106,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
76,76,76,76,76,76,106,76,106,76,106,76,106,76,106,76,
106,76,106,76,106,76,76,76,106,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,106,76,106,76,106,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,76,10,10,10,10,10,10,10,10,10,10},
/*102 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,76,76,179},
/*103 ref=1 */ {
76,76,76,76,76,76,76,76,76,106,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,2,2,2,76,76,106,76,76,
76,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
84,84,84,84,84,84,84,84,84,84,84,76,76,106,76,76,
106,76,76,106,76,76,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10},
/*104 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,76,
76,76,10,10,10,10,10,10,76,76,10,10,10,10,10,10,
76,76,10,10,10,10,10,10,76,76,10,10,10,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*105 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,76,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,76,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,76,10,10,76,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*106 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,76,76,76,76,76},
/*107 ref=1 */ {
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,10,76,76},
/*108 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
10,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*109 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
76,76,76,76,76,76,76,76,76,76,76,76,76,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,76,10,10,10,10,10,10,10,10,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,76,76,76,76,76},
/*110 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,76,76,76,76,10,10,10,10,10,10,10,10,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*111 ref=1 */ {
180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,
180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,
180,180,180,180,180,180,180,180,181,181,181,181,181,181,181,181,
181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,
181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10},
/*112 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,
180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,180,
180,180,180,180,76,76,76,76,181,181,181,181,181,181,181,181,
181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,181,
181,181,181,181,181,181,181,181,181,181,181,181,76,76,76,76},
/*113 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,76,76,76,76,76,76,76,76,76,76,76,76,
182,182,182,182,182,182,182,182,182,182,182,76,182,182,182,182},
/*114 ref=1 */ {
182,182,182,182,182,182,182,182,182,182,182,76,182,182,182,182,
182,182,182,76,182,182,76,183,183,183,183,183,183,183,183,183,
183,183,76,183,183,183,183,183,183,183,183,183,183,183,183,183,
183,183,76,183,183,183,183,183,183,183,76,183,183,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*115 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*116 ref=1 */ {
10,10,10,10,10,10,76,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,76,10,10,10,10,10,10,10,10,10,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*117 ref=1 */ {
10,10,10,10,10,10,76,76,10,76,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,76,10,10,76,76,76,10,76,76,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,76,76,76,76,76,76,76,76,76},
/*118 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,76,10,10,76,76,76,76,76,76,76,76,76,76},
/*119 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*120 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,76,76,76,76,76,76,10,10,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*121 ref=1 */ {
10,10,10,10,76,10,10,76,76,76,76,76,10,10,10,10,
10,10,10,10,76,10,10,10,76,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,76,76,10,10,10,76,76,76,76,10,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,76,76,76},
/*122 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,76,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*123 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*124 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*125 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*126 ref=1 */ {
80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,
80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,
80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,
80,80,80,76,76,76,76,76,76,76,76,76,76,76,76,76,
86,86,86,86,86,86,86,86,86,86,86,86,86,86,86,86,
86,86,86,86,86,86,86,86,86,86,86,86,86,86,86,86,
86,86,86,86,86,86,86,86,86,86,86,86,86,86,86,86,
86,86,86,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*127 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*128 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,76,10,10,76,76,76,
10,10,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,10,10,10},
/*129 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,76,76,76,
76,76,76,76,76,76,76,10,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10},
/*130 ref=1 */ {
10,10,10,10,10,10,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,76,76,76,76,76,76,76,76,76},
/*131 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,76,76,76,76,76,76,76,76,76,10},
/*132 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,76,76,76,76,76,
76,76,10,76,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*133 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,10,10,10,10,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,76,76,10,76,76,76,76,76,76,76,76,76},
/*134 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,76,76,76,76,10,10,10,10,76,10,10,
76,76,76,76,76,76,76,76,76,76,10,76,10,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*135 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,76,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,76,76,76,76,76,76,10,10,
10,10,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*136 ref=1 */ {
10,10,10,10,10,10,10,76,10,76,10,10,10,10,76,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,76,10,
10,10,10,10,10,10,10,10,10,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*137 ref=1 */ {
10,10,10,10,76,10,10,10,10,10,10,10,10,76,76,10,
10,76,76,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,76,10,10,10,10,10,10,
10,76,10,10,76,10,10,10,10,10,76,10,10,10,10,10,
10,10,10,10,10,76,76,10,10,76,76,10,10,10,76,76,
10,76,76,76,76,76,76,10,76,76,76,76,76,10,10,10,
10,10,10,10,76,76,10,10,10,10,10,10,10,76,76,76,
10,10,10,10,10,76,76,76,76,76,76,76,76,76,76,76},
/*138 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,10,10,
10,10,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*139 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,76,10,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*140 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,76,76,10,10,10,10,10,10,10,10,
10,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,10,10,10,10,10,10,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*141 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,76,76,76,10,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*142 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*143 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,76,76,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*144 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*145 ref=1 */ {
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,10},
/*146 ref=1 */ {
10,10,10,10,10,10,10,76,76,10,76,76,10,10,10,10,
10,10,10,10,76,10,10,76,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,76,10,10,76,76,10,10,10,10,10,
10,10,10,10,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*147 ref=1 */ {
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,76,76,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,76,76,10,10,10,10,10,10,
10,10,76,10,10,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*148 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,76,
76,76,76,76,76,76,76,10,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10},
/*149 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,76,76,76,10,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,76,76,76,76,76,76,76},
/*150 ref=1 */ {
10,10,10,10,10,10,10,10,10,76,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,76,10,10,10,10,10,10,10,10,
10,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,10,10,10,10,10,10,10,10,10,10,10,10,10,10},
/*151 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
76,76,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,76,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*152 ref=1 */ {
10,10,10,10,10,10,10,76,10,10,76,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,76,76,76,10,76,10,10,76,10,
10,10,10,10,10,10,10,10,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,76,10,10,76,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10},
/*153 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,76,
10,10,76,10,10,10,10,10,10,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*154 ref=1 */ {
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,76,76,76,76,76,76,76,76,76},
/*155 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,76,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,76,76,76,10,10,
10,10,10,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*156 ref=1 */ {
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
10,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*157 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*158 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*159 ref=1 */ {
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*160 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*161 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*162 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10},
/*163 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,76,76,
10,10,10,10,10,76,76,76,76,76,76,76,76,76,76,76},
/*164 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,76,76,76,76,76,76,76,76,76,
10,10,10,10,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,76,76,76,76,76,10,10,10},
/*165 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*166 ref=1 */ {
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84},
/*167 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,76,76,76,76,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10},
/*168 ref=1 */ {
10,10,10,10,10,10,10,10,76,76,76,76,76,76,76,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,76,10,10,76,76,76,76,76,76,76,76,76,76,76,
10,10,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*169 ref=1 */ {
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,76,76,76,76,76,76,76,76},
/*170 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*171 ref=1 */ {
162,162,162,162,162,162,162,162,162,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*172 ref=1 */ {
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,76,10,10,10,10,10,10,10,76,10,10,76},
/*173 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,10,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,76,76,10,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,10,10,10,10,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10},
/*174 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,76,76,76,76},
/*175 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,76,76,76},
/*176 ref=1 */ {
10,10,10,10,10,10,10,10,10,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,76,76,76,10,10,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*177 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*178 ref=1 */ {
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,10,10,10,10,10,76,76,76,10,10,10,
10,10,10,76,76,76,76,76,76,76,76,10,10,10,10,10},
/*179 ref=1 */ {
10,10,10,76,76,10,10,10,10,10,10,10,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,10,10,10,10,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*180 ref=1 */ {
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,10,10,10,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*181 ref=1 */ {
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,10,
10,10,10,10,10,76,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
/*182 ref=1 */ {
0,0,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,0,76,0,0,
76,76,0,76,76,0,0,76,76,0,0,0,0,76,0,0,
0,0,0,0,0,0,10,10,10,10,76,10,76,10,10,10,
10,10,10,10,76,10,10,10,10,10,10,10,10,10,10,10,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10},
/*183 ref=1 */ {
10,10,10,10,0,0,76,0,0,0,0,76,76,0,0,0,
0,0,0,0,0,76,0,0,0,0,0,0,0,76,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,0,0,76,0,0,0,0,76,
0,0,0,0,0,76,0,76,76,76,0,0,0,0,0,0,
0,76,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
/*184 ref=1 */ {
0,0,0,0,0,0,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10},
/*185 ref=1 */ {
10,10,10,10,10,10,10,10,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
/*186 ref=1 */ {
0,0,0,0,0,0,0,0,0,0,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,76,76,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,76,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,76,10,10,10,10,
10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,76,10,10,10,10},
/*187 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,76,10,10,10,10,10,10,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,76,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,76,
10,10,10,10,10,10,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10},
/*188 ref=1 */ {
10,10,10,10,10,10,10,10,10,76,10,10,10,10,10,10,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,76,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,76,10,10,10,10,10,10,0,10,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*189 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,76,76,76,76,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,76,76,76,
76,76,76,76,76,10,76,76,76,76,76,76,76,76,76,76},
/*190 ref=1 */ {
76,76,76,76,10,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,10,10,10,10,10,
76,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*191 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,76,
76,76,76,76,76,10,10,10,10,10,10,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*192 ref=1 */ {
10,10,10,10,10,10,10,76,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,76,76,10,10,10,10,10,
10,10,76,10,10,76,10,10,10,10,10,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*193 ref=1 */ {
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,10,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*194 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,10,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*195 ref=1 */ {
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*196 ref=1 */ {
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*197 ref=1 */ {
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,76,10,10,10,10,76,10,10,76,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,76},
/*198 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,76,76,76,76,76,76,76,76,76,76,76,
10,10,10,10,10,10,10,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*199 ref=1 */ {
184,184,184,184,184,184,184,184,184,184,184,184,184,184,184,184,
184,184,184,184,184,184,184,184,184,184,184,184,184,184,184,184,
184,184,185,185,185,185,185,185,185,185,185,185,185,185,185,185,
185,185,185,185,185,185,185,185,185,185,185,185,185,185,185,185,
185,185,185,185,10,10,10,10,10,10,10,10,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*200 ref=1 */ {
10,10,10,10,76,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
76,10,10,76,10,76,76,10,76,10,10,10,10,10,10,10,
10,10,10,76,10,10,10,10,76,10,76,10,76,76,76,76,
76,76,10,76,76,76,76,10,76,10,76,10,76,10,10,10,
76,10,10,76,10,76,76,10,76,10,76,10,76,10,76,10,
76,10,10,76,10,76,76,10,10,10,10,76,10,10,10,10,
10,10,10,76,10,10,10,10,76,10,10,10,10,76,10,76},
/*201 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,76,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,76,76,76,76,
76,10,10,10,76,10,10,10,10,10,76,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*202 ref=1 */ {
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*203 ref=1 */ {
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,76,76,76,76,76,76,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162},
/*204 ref=1 */ {
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,76,76,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162},
/*205 ref=1 */ {
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162},
/*206 ref=1 */ {
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162},
/*207 ref=1 */ {
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*208 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*209 ref=1 */ {
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,76,76,76,76,76,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162},
/*210 ref=1 */ {
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,162,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76},
/*211 ref=1 */ {
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76}
};

static uint8_t utf_block_refs[UTF_B_NUM] = {
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,65,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
255,1,1,1,1,1,1,1,1,1,1,1,1,1,1,255,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1
};

#define UTF_R_BITS 14
#define UTF_R_SIZE (1<<UTF_R_BITS)
#define UTF_R_MASK (UTF_R_SIZE-1)
#define UTF_R_SHIFT UTF_B_BITS
#define UTF_R_NUM 0x2200
uint8_t utf_root[UTF_R_NUM] = {
/* 0x0 */
0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,
16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
32,33,34,34,35,36,37,38,39,34,34,34,40,41,42,43,
44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,
60,61,62,63,64,64,65,64,64,66,64,64,64,64,67,68,
64,64,64,69,64,64,64,64,70,71,72,73,74,64,64,64,
75,76,77,78,64,64,64,64,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,79,79,79,79,79,80,79,79,79,79,
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
/* 0x8000 */
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
34,34,34,34,34,34,34,34,34,81,34,34,82,83,84,85,
86,87,88,89,90,91,92,93,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,94,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,34,34,95,96,97,98,34,34,99,100,101,102,103,104,
/* 0x10000 */
105,106,64,107,64,108,109,110,111,112,113,114,34,34,115,116,
117,118,119,120,121,122,123,124,125,126,127,64,64,128,129,130,
131,132,133,134,135,136,137,64,138,139,64,140,141,142,143,64,
144,145,146,147,148,149,64,64,150,151,152,153,64,154,155,156,
34,34,34,34,34,34,34,157,64,34,158,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,159,
34,34,34,34,34,34,34,34,160,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,34,34,34,34,161,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
34,34,34,34,162,163,164,165,64,64,64,64,166,64,167,168,
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
/* 0x18000 */
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,169,
34,34,34,34,34,34,34,34,34,170,171,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,172,
34,34,173,34,34,174,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,175,176,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,177,64,
64,64,178,179,180,64,64,64,181,182,183,184,185,186,187,188,
64,64,64,64,189,190,64,64,64,64,64,64,64,64,191,64,
192,193,194,64,64,195,64,64,64,196,64,64,64,64,64,197,
34,198,199,64,64,64,64,64,64,64,64,64,200,201,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
/* 0x20000 */
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
/* 0x28000 */
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,79,79,79,79,79,79,79,202,79,79,
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,79,79,79,79,79,79,79,79,203,79,
204,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,79,79,79,79,79,79,79,205,79,79,
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,79,206,79,79,79,79,207,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
34,34,34,34,208,64,64,64,64,64,64,64,64,64,64,64,
/* 0x30000 */
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,209,79,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,79,210,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
/* 0x38000 */
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
/* 0x40000 */
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
/* 0x48000 */
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
/* 0x50000 */
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
/* 0x58000 */
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
/* 0x60000 */
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
/* 0x68000 */
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
/* 0x70000 */
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
/* 0x78000 */
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
/* 0x80000 */
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
/* 0x88000 */
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
/* 0x90000 */
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
/* 0x98000 */
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
/* 0xa0000 */
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
/* 0xa8000 */
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
/* 0xb0000 */
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
/* 0xb8000 */
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
/* 0xc0000 */
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
/* 0xc8000 */
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
/* 0xd0000 */
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
/* 0xd8000 */
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
/* 0xe0000 */
64,64,34,211,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
/* 0xe8000 */
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
/* 0xf0000 */
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
/* 0xf8000 */
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
/* 0x100000 */
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
/* 0x108000 */
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64
/* 0x10ffff */

};

#define UTF_R_INDEX(I) (I>>UTF_R_SHIFT)&UTF_R_MASK
#define UTF_B_BASE(I)  utf_root[UTF_R_INDEX(I)]
#define UTF_B_REF(I)   utf_block_refs[UTF_B_BASE(I)]
#define UTF_B_OFFSET(I) (UTF_B_MASK&I)
#define UTF_INFO(I) utf_infos[utf_blocks[UTF_B_BASE(I)][UTF_B_OFFSET(I)]]	 

#define UTF_CAT(I) UTF_INFO(I).cat
#define UTF_LC(I) UTF_INFO(I).lc
#define UTF_UC(I) UTF_INFO(I).uc
#define UTF_DC(I) UTF_INFO(I).dc
#define UTF_SF(I) UTF_INFO(I).sf
#define UTF_FC(I) UTF_INFO(I).famcls
#define UTF_SL(I) UTF_INFO(I).slot
#define UTF_CP_OFFSET 0x110000
#define UTF_MAKE_REL(CP,ABS) (ABS-CP+UTF_CP_OFFSET)
#define UTF_MAKE_ABS(CP,REL) (REL+CP-UTF_CP_OFFSET)
#define UTF_MAKE_MC(FC,SL) (((FC)<<20)|SL)
#define SLOT(A) ((A)&0x1FFFFF)
#define FAMCAT(A) (((A)&~0x1FFFFF)>>20)


/* access functions */

static uint8_t utf_catcode(uint32_t cp)
{ return UTF_CAT(cp);
}

static uint32_t utf_lccode(uint32_t cp)
{ uint32_t lc= UTF_LC(cp);
  if (lc==0) return 0; else return UTF_MAKE_ABS(cp,lc);
}

static uint32_t utf_uccode(uint32_t cp)
{ uint32_t uc= UTF_UC(cp);
  if (uc==0) return 0; else return UTF_MAKE_ABS(cp,uc);
}

static int utf_delcode(uint32_t cp)
{ return UTF_DC(cp);
}

static uint16_t utf_sfcode(uint32_t cp)
{ return UTF_SF(cp);
}


static uint32_t utf_mathcode(uint32_t cp)
{ uint32_t fc= UTF_FC(cp);
  uint32_t slot=UTF_SL(cp);
  if (slot==0) return UTF_MAKE_MC(fc,0);
  slot=UTF_MAKE_ABS(cp,slot);
  return UTF_MAKE_MC(fc,slot);
}

static void utf_i_deref(int p)
{ if (utf_infos[p].ref==0xff)
    return;
  utf_infos[p].ref--;
  if (utf_infos[p].ref==0) /*less than zero should not happen here*/
  { utf_infos[p].sf=utf_i_avail;
    utf_i_avail=p; utf_i_used--;
    if (p==utf_i_top)
      do utf_i_top--; while (utf_infos[utf_i_top].ref==0);
  }
}

/* modification functions */
static int utf_reuse_info(int p)
{ int i;
  for (i=utf_i_top; i>=0; i--)
    if (utf_infos[i].ref>0 && i!=p && utf_i_equal(utf_infos+i,utf_infos+p))
    { if (utf_infos[i].ref<0xff) utf_infos[i].ref++;
      utf_i_deref(p);
      return i;
    }
  return -1;
}

static int utf_new_info(int p)
{ if (utf_i_avail>=0) /* info allocation needed */
  { int r=utf_i_avail;
    utf_i_used++;
    if (r>utf_i_top) utf_i_top=r;
    utf_i_avail=utf_infos[r].sf; /* links are stored in the |sf| field */
    utf_infos[r]=utf_infos[p];
    utf_infos[r].ref=1;
    return r;
  }
  else
    UTF_OVERFLOW("UTF8 info overflow", utf_i_used);
  return p;
}

static int utf_new_block(int b)
{ int a,i;
  if (utf_b_used<UTF_B_NUM)
  { if (utf_block_refs[b]<0xff) utf_block_refs[b]--;
    a=utf_b_used;
    utf_b_used++;
    utf_block_refs[a]=1;
    for (i=0;i<UTF_B_SIZE;i++)
      utf_blocks[a][i]=utf_blocks[b][i];
  }
  else UTF_OVERFLOW("UTF8 block overflow, utf block count =",utf_b_used);
  return a;
}


/* set a normal field in the |Utf_info| record */
#define UTF_SET_FIELD(F) \
  int b= UTF_B_BASE(cp); \
  int o=UTF_B_OFFSET(cp); \
  int r, p = utf_blocks[b][o]; \
  uint32_t u=utf_infos[p].F; \
  if (u==F) return F; /* no change */ \
  utf_infos[p].F=F; /* update */\
  r = utf_reuse_info(p); \
  if (r>=0) \
  {  utf_infos[p].F=u; /*restore*/p=r; } \
  else if (utf_infos[p].ref==1) \
    return u; /* single info reference */ \
  else \
  { r=utf_new_info(p); \
    utf_infos[p].F=u; /*restore*/ \
    p=r; } \
  if (utf_block_refs[b]<=1) /* single block reference */ \
  {  utf_blocks[b][o]=p; return u; } /* no block allocation needed */ \
  b=utf_new_block(b); \
  utf_blocks[b][o]=p; \
  utf_root[UTF_R_INDEX(cp)]=b; \
  return u;

static uint32_t utf_set_catcode(uint32_t cp, uint8_t cat)
{ UTF_SET_FIELD(cat)
}

static uint32_t utf_set_sfcode(uint32_t cp, uint16_t sf)
{  UTF_SET_FIELD(sf)
}

static uint32_t utf_set_delcode(uint32_t cp, uint32_t dc)
{  UTF_SET_FIELD(dc)
}


/* set a relative field in the |Utf_info| record */
#define UTF_SET_REL_FIELD(F) \
  int b= UTF_B_BASE(cp); \
  int o=UTF_B_OFFSET(cp); \
  int r, p = utf_blocks[b][o]; \
  uint32_t u,v,w; \
  u=utf_infos[p].F; \
  if (F==0) w=0; else w=UTF_MAKE_REL(cp,F); \
  if (u==w) return F; /* no change */ \
  if (u==0) v=0; else v=UTF_MAKE_ABS(cp,u); \
  utf_infos[p].F=w; /* update */\
  r = utf_reuse_info(p); \
  if (r>=0) \
  { utf_infos[p].F=u; /*restore*/ p=r; } \
  else if (utf_infos[p].ref==1) \
    return v; /* single info reference */ \
  else \
  { r=utf_new_info(p); \
    utf_infos[p].F=u; /*restore*/ \
    p=r; } \
  if (utf_block_refs[b]<=1) /* single block reference */ \
  {  utf_blocks[b][o]=p; return v; } /* no block allocation needed */ \
  b=utf_new_block(b); \
  utf_blocks[b][o]=p; \
  utf_root[UTF_R_INDEX(cp)]=b; \
  return v;

static uint32_t utf_set_lccode(uint32_t cp, uint32_t lc)
{ UTF_SET_REL_FIELD(lc)
}

static uint32_t utf_set_uccode(uint32_t cp, uint32_t uc)
{ UTF_SET_REL_FIELD(uc)
}


static uint32_t utf_set_mathcode(uint32_t cp, uint32_t mc)
{/* modification of |UTF_SET_REL_FIELD(mc)| because only the slot is relative */
  int b= UTF_B_BASE(cp);
  int o=UTF_B_OFFSET(cp);
  int r, p = utf_blocks[b][o];
  uint32_t slot=utf_infos[p].slot;
  uint32_t famcls=utf_infos[p].famcls;
  uint32_t v; /* old mc value */
  int fc=FAMCAT(mc);
  int sl=SLOT(mc);
  if (sl!=0) sl=UTF_MAKE_REL(cp,sl);
  if (slot==sl && famcls==fc) return mc; /* no change */
  if (slot==0) v=0; else v=UTF_MAKE_ABS(cp,slot);
  v=UTF_MAKE_MC(famcls,v);
  utf_infos[p].slot=sl; utf_infos[p].famcls=fc; /* update */
  r = utf_reuse_info(p);
  if (r>=0)
  { utf_infos[p].slot=sl;  utf_infos[p].famcls=fc; /*restore*/
    p=r;
  }
  else if (utf_infos[p].ref==1)
    return v; /* single info reference */
  else
  { r=utf_new_info(p);
    utf_infos[p].slot=sl;  utf_infos[p].famcls=fc; /*restore*/
    p=r; }
  if (utf_block_refs[b]<=1) /* single block reference */
  {  utf_blocks[b][o]=p; return v; } /* no block allocation needed */
  b=utf_new_block(b);
  utf_blocks[b][o]=p;
  utf_root[UTF_R_INDEX(cp)]=b;
  return v;
}


#if 0

/* Write the data to stdout. Test by comparing against input file */
int main(void) {
int i;
for (i=0;i<=0x10FFFF;i++)
  printf("%d:%d:%d:%d:%d:%d:%d\n",
	 i,
         utf_catcode(i),
	 utf_lccode(i),
	 utf_uccode(i),
	 utf_delcode(i),
	 utf_sfcode(i),
	 utf_mathcode(i)
	 );

/* '@' == 0x40 == 64  -> root[0] -> 0 block[0][64] -> info[43] ->
   catcode 11=letter, 12=other 
   {0x000000, 0x000000, 0x010000, 1000, 0xa, 12,  0,  7},
   to
   {0x000000, 0x000000, 0x010000, 1000, 0xa, 11,  0,  7},
   the block has refcount=1 the info has refcount=0xa,
   allocation of a new info is needed.
 */
utf_set_catcode('@',11);

utf_set_catcode((34<<7)+9,12);
utf_set_catcode((34<<7)+9,11);

utf_set_catcode(' ',11);
utf_set_catcode('\\',11);
utf_set_catcode('{',11);
utf_set_catcode('}',11);
utf_set_catcode('$',11);
utf_set_catcode('&',11);
utf_set_catcode('#',11);
utf_set_catcode('^',11);
utf_set_catcode('K'-0x40,11);
utf_set_catcode('_',11);
utf_set_catcode('A'-0x40,11);
utf_set_catcode('%',11);
utf_set_catcode('~',11);

utf_set_mathcode('(',')');
utf_set_uccode('a','A');
utf_set_lccode('A','a');
utf_set_sfcode('A',1000);
utf_set_delcode(')','(');


return 0;
}
#endif
