-----------------------------------------------------------------------
--         FILE:  xindex-cfg-uca.lua
--  DESCRIPTION:  configuration file for lua-uca
-- REQUIREMENTS:  
--       AUTHOR:  Herbert Voß
--      LICENSE:  LPPL1.3
--
-- $Id: xindex-cfg-uca.lua 2 2025-08-02 11:30:20Z herbert $
-----------------------------------------------------------------------

if not modules then modules = { } end modules ['xindex-cfg-lua'] = {
      version = 0.65,
      comment = "configuration to xindex-cfg-uca.lua",
       author = "Herbert Voss",
    copyright = "Herbert Voss",
      license = "LPPL 1.3"
}

languages.fr = function(collator_obj)
  print("Using languages.fr")
   -- reverse search for accents in French (recommended):
  collator_obj.accents_backward = true
  -- accents: sorting order in French
  local tailoring = function(s) collator_obj:tailor_string(s) end
  tailoring("&æ=ae")
  tailoring("&Æ=AE")
  tailoring("&œ=oe")
  tailoring("&Œ=OE")
  tailoring("&Œ<œ")
  tailoring("&th<þ<<<Þ")       -- Canadian, see SGQRI004.pdf
  tailoring("&a<<<A<<á<<<Á<<à<<<À<<â<<<Â<<ä<<<Ä") 
  tailoring("&o<<<O<<ó<<<Ó<<ò<<<Ò<<ô<<<Ô<<ö<<<Ö") 
  tailoring("&e<<<E<<é<<<É<<è<<<È<<ê<<<Ê") 
  -- lowercase before uppercase in French
  -- collator_obj:uppercase_first()
  return collator_obj
end 

--  tailoring("&ǀ<æ<<<Æ<<ä<<<Ä<ø<<<Ø<<ö<<<Ö<<ő<<<Ő<å<<<Å<<<aa<<<Aa<<<AA")

-- put any additional code for lua-uca here ---
languages.no = function(collator_obj)
  print("Using languages.no")
  local tailoring = function(s) collator_obj:tailor_string(s) end
  collator_obj:uppercase_first()
--  tailoring("&[before 1]b<á<<<Á")
--  tailoring("&[before 1]d<č<<<Č<ʒ<<<Ʒ<ǯ<<<Ǯ")
--  tailoring("&[before 1]e<đ<<<Đ<<ð<<<Ð")
--  tailoring("&[before 1]h<ǧ<<<Ǧ<ǥ<<<Ǥ")
--  tailoring("&[before 1]l<ǩ<<<Ǩ")
--  tailoring("&[before 1]o<ŋ<<<Ŋ<<ń<<<Ń<<ñ<<<Ñ")
--  tailoring("&[before 1]t<š<<<Š")
--  tailoring("&[before 1]u<ŧ<<<Ŧ<<þ<<<Þ")
--  tailoring("&y<<ü<<<Ü<<ű<<<Ű")
--  tailoring("&[before 1]ǀ<ž<<<Ž<ø<<<Ø<<œ<<<Œ<æ<<<Æ<å<<<Å<<ȧ<<<Ȧ<ä<<<Ä<<ã<<<Ã<ö<<<Ö<<ő<<<Ő<<õ<<<Õ<<ô<<<Ô<<ǫ<<<Ǫ")
--  tailoring("&D<<đ<<<Đ<<ð<<<Ð")
--  tailoring("&th<<<þ")
--  tailoring("&TH<<<Þ")
--  tailoring("&Y<<ü<<<Ü<<ű<<<Ű")
--  tailoring("&ǀ<æ<<<Æ<<ä<<<Ä<ø<<<Ø<<ö<<<Ö<<ő<<<Ő<å<<<Å<<<aa<<<Aa<<<AA")
--  tailoring("&oe<<œ<<<Œ")
  tailoring("&A<a<B<b<C<D<E<F<G<H<I<J<K<L<M<N<O<P<Q<R<S<T<U<V<W<X<Y<Z<Æ<Ø<Å")
  return collator_obj
end

--UCA language = "de_din2" -- 
languages.de_din2 = function(collator_obj)
  print("Using languages.de_din2")
  local tailoring = function(s) collator_obj:tailor_string(s) end
  collator_obj:uppercase_first()
  tailoring("&Ö=Oe")
  tailoring("&ö=oe")
  tailoring("&Ä=Ae")
  tailoring("&ä=ae")
  tailoring("&Ü=Ue")
  tailoring("&ü=ue")
  tailoring("&ß=ss")
  return collator_obj
end



--ABCDEFGHIJKLMNOPQRSTUVWXYZÆØÅ

--[[
Symbol 	Example 	Description
< 	a < b 	Identifies a primary (base letter) difference between "a" and "b"
<< 	a << ä 	Signifies a secondary (accent) difference between "a" and "ä"
<<< 	a<<<A 	Identifies a tertiary difference between "a" and "A"
<<<< 	か<<<<カ  	Identifies a quaternary difference between "か" and "カ". (New in ICU 53.) ICU permits up to three quaternary relations in a row (except for intervening "=" identity relations).
= 	x = y 	Signifies no difference between "x" and "y".
& 	&Z 	Instructs ICU to reset at this letter. These rules will be relative to this letter from here on, but will not affect the position of Z itself. 
]]

