---
myst:
  html_meta:
    keywords: LaTeX, composition, flottants, positionnement
---

# Comment placer des figures côte à côte ?

## En utilisant l'extension <ctanpkg:subcaption>

Un exemple simple permet de montrer le fonctionnement de l'extension 
<ctanpkg:subcaption>. Chaque sous-figure est représentée par une commande 
`\subcaptionbox`, qui permet, au minimum, d'indiquer le texte de sa légende
et son contenu. Il est possible de donner une légende globale à l'ensemble
 constitué par les deux sous-figure en utilisant, tout simplement, 
 une commande `\caption` à l'intérieur de l'environnement `figure`.

La [documentation](texdoc:subcaption) indique plus en détails comment régler
la mise en forme des légendes des sous-figures, leur numérotation, 
la largeur des boîtes dans lesquelles sont placées chaque figure, etc... 
L'extension définit aussi des environnements `subfigure` (à ne pas confondre
avec l'extension obsolète du même nom !) et `subtable`.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{subcaption}

\begin{document}
Un peu de texte avant les figures.
\begin{figure}[h]
  \centering
  \subcaptionbox{La légende de la première figure\label{fig1a}}{%
    \fbox{Ceci est ma première figure}}
  \subcaptionbox{La légende de la deuxième figure\label{fig1b}}{%
    \fbox{Ceci est ma deuxième figure}}
  \caption{Une figure divisée en deux}\label{fig1}
\end{figure}

On peut faire référence soit aux sous-figures~\ref{fig1a} et~\ref{fig1b}, 
ou globalement, à la figure~\ref{fig1}.
\end{document}
```


## Avec l'extension <ctanpkg:subfig>

:::{todo} Ajouter un exemple.
:::

## Avec l'extension <ctanpkg:subfigure>

:::{warning}
L’extension* <ctanpkg:subfigure> est classée comme
[obsolète](/1_generalites/histoire/liste_des_packages_obsoletes). Ce qui suit
est informatif.
:::

Autrefois, l'extension <ctanpkg:subfigure> servait à diviser un environnement 
`figure` en plusieurs sous-figures, chacune ayant sa propre légende, et 
étant numérotée avec (a), (b), etc. Le plus simple, pour comprendre 
le fonctionnement, est de regarder sur cet exemple :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{subfigure}

\begin{document}
Un peu de texte avant les figures.
\begin{figure}[h]
\null\hfill
\subfigure[La légende de la première figure\label{fig1a}]{%
     \fbox{Ceci est ma première figure}}
\hfill
\subfigure[La légende de la deuxième figure\label{fig1b}]{%
     \fbox{Ceci est ma deuxième figure}}
\hfill\null
\caption{Une figure divisée en deux}\label{fig1}
\end{figure}

On peut faire référence soit aux sous-figures~\ref{fig1a} et~\ref{fig1b}, ou
globalement, à la figure~\ref{fig1}.
\end{document}
```

Pour simplement placer deux figures sans qu'elles aient chacune une légende
et un numéro, il faudra simplement les mettre dans un environnement 
`minipage`, par exemple, ou dans un tableau. Il est cependant toujours possible
d'utiliser <ctanpkg:subfigure>, en supprimant l'argument optionnel qui définit
la légende.