/* l2xiertc.h   token codes, strings, etc for interpreter error reporting */

     /* parser warnings */

pwtc(WARN,   "Something may be wrong")
pwtc(ASSIGN_TO_UNDEF, "Assignment to indeterminate")


      /* runtime warnings */

rtwtc(INVALID_STACK_ACCESS, "Attempting out of range stack access")
rtwtc(INVALID_STACK_TYPE,   "Invalid value on the stack")
rtwtc(RUNTIME_WARN,         "Something may be wrong")
rtwtc(RUN_ASSIGN_TO_UNDEF,  "Assignment to indeterminate")
rtwtc(EXPECTED_ADDRESS,     "Expected an address on the stack")
rtwtc(EXPECTED_ARRAY,       "Expected an array on the stack")
rtwtc(EXPECTED_BAG,         "Expected a bag on the stack")
rtwtc(EXPECTED_ENTITY,      "Expected an entity on the stack")
rtwtc(EXPECTED_ENUMERATION, "Expected an enumeration on the stack")
rtwtc(EXPECTED_LIST,        "Expected a list on the stack")
rtwtc(EXPECTED_LOGICAL,     "Expected a boolean or logical on the stack")
rtwtc(EXPECTED_NUMBER,      "Expected a number on the stack")
rtwtc(EXPECTED_SET,         "Expected a set on the stack")
rtwtc(EXPECTED_STRING,      "Expected a string on the stack")
rtwtc(EXPECTED_UDF,         "Expected indeterminate on the stack")
rtwtc(FOUND_ADDRESS,        "Found an address on the stack")
rtwtc(FOUND_ARRAY,          "Found an array on the stack")
rtwtc(FOUND_BAG,            "Found a bag on the stack")
rtwtc(FOUND_ENTITY,         "Found an entity on the stack")
rtwtc(FOUND_ENUMERATION,    "Found an enumeration on the stack")
rtwtc(FOUND_LIST,           "Found a list on the stack")
rtwtc(FOUND_LOGICAL,        "Found a boolean or logical on the stack")
rtwtc(FOUND_NUMBER,         "Found a number on the stack")
rtwtc(FOUND_SET,            "Found a set on the stack")
rtwtc(FOUND_STRING,         "Found a string on the stack")
rtwtc(FOUND_UDF,            "Found indeterminate on the stack")


      /* parser errors */

petc(NO_ERROR,                       "No error")
petc(SYNTAX_ERROR,                   "Syntax error")
petc(TOO_MANY_SYNTAX_ERRORS,         "Too many syntax errors")
petc(FAILED_SOURCE_FILE_OPEN,        "Failed to open source file")
petc(UNEXPECTED_END_OF_FILE,         "Unexpected end of file")
petc(INVALID_NUMBER,                 "Invalid number")
petc(INVALID_FRACTION,               "Invalid fraction")
petc(INVALID_EXPONENT,               "Invalid exponent")
petc(TOO_MANY_DIGITS,                "Too many digits")
petc(REAL_OUT_OF_RANGE,              "Real literal out of range")
petc(INTEGER_OUT_OF_RANGE,           "Integer literal out of range")
petc(MISSING_RPAREN,                 "Missing ) (right parenthesis)")
petc(INVALID_EXPRESSION,             "Invalid expression")
petc(INVALID_ASSIGNMENT,             "Invalid assignment")
petc(MISSING_IDENTIFIER,             "Missing identifier")
petc(MISSING_COLONEQUAL,             "Missing :=")
petc(UNDEFINED_IDENTIFIER,           "Undefined identifier")
petc(STACK_OVERFLOW,                 "Stack overflow")
petc(INVALID_STATEMENT,              "Invalid statement")
petc(UNEXPECTED_TOKEN,               "Unexpected token")
petc(MISSING_SEMICOLON,              "Missing ; (semicolon)")
petc(MISSING_DO,                     "Missing DO")
petc(MISSING_UNTIL,                  "Missing UNTIL")
petc(MISSING_THEN,                   "Missing THEN")
petc(INVALID_FOR_CONTROL,            "Invalid FOR control")
petc(MISSING_OF,                     "Missing OF")
petc(INVALID_CONSTANT,               "Invalid constant")
petc(MISSING_CONSTANT,               "Missing constant")
petc(MISSING_COLON,                  "Missing : (colon)")
petc(MISSING_END,                    "Missing END")
petc(REDEFINED_IDENTIFIER,           "Redefined identifier")
petc(MISSING_EQUAL,                  "Missing = (equal)")
petc(INVALID_TYPE,                   "Invalid type")
petc(NOT_A_TYPE_IDENTIFIER,          "Not a type identifier")
petc(INVALID_SUBRANGE_TYPE,          "Invalid subrange type")
petc(NOT_A_CONSTANT_IDENTIFIER,      "Not a constant identifier")
petc(INCOMPATIBLE_TYPES,             "Incompatible types")
petc(INVALID_TARGET,                 "Invalid assignment target")
petc(INVALID_IDENTIFIER_USAGE,       "Invalid identifier usage")
petc(INCOMPATIBLE_ASSIGNMENT,        "Incompatible assignment")
petc(MIN_GT_MAX,                     "Min limit greater than max limit")
petc(MISSING_LBRACKET,               "Missing [ (left bracket)")
petc(MISSING_RBRACKET,               "Missing ] (right bracket)")
petc(INVALID_INDEX_TYPE,             "Invalid index type")
petc(MISSING_BEGIN,                  "Missing BEGIN")
petc(MISSING_PERIOD,                 "Missing . (period)")
petc(TOO_MANY_SUBSCRIPTS,            "Too many subscripts")
petc(INVALID_ATTRIBUTE,              "Invalid attribute")
petc(NESTING_TOO_DEEP,               "Nesting too deep")
petc(ALREADY_FORWARDED,              "Already forwarded")
petc(WRONG_NUMBER_OF_PARMS,          "Wrong number of arguments")
petc(INVALID_VAR_PARM,               "Invalid VAR parameter")
petc(NOT_A_RECORD_VARIABLE,          "Not a record variable")
petc(MISSING_VARIABLE,               "Missing variable")
petc(CODE_SEGMENT_OVERFLOW,          "Code segment overflow")
petc(UNIMPLEMENTED_FEATURE,          "Unimplemented feature")
petc(MISSING_ENDCODE,                "Missing END_CODE")
petc(UNEXPECTED_ENDCODE,             "Unexpected END_CODE")
petc(UNIMPLEMENTED_SIMPLE_TYPE,      "Unimplemented simple type")
petc(UNIMPLEMENTED_CONSTANT,         "Unimplemented constant")
petc(INVALID_BOUND_TYPE,             "Invalid bound type")
petc(MISSING_END_ALIAS,              "Missing END_ALIAS")
petc(MISSING_END_CALL,               "Missing END_CALL")
petc(MISSING_END_CASE,               "Missing END_CASE")
petc(MISSING_END_CONSTANT,           "Missing END_CONSTANT")
petc(MISSING_END_CONTEXT,            "Missing END_CONTEXT")
petc(MISSING_END_CRITERIA,           "Missing END_CRITERIA")
petc(MISSING_END_ENTITY,             "Missing END_ENTITY")
petc(MISSING_END_FUNCTION,           "Missing END_FUNCTION")
petc(MISSING_END_IF,                 "Missing END_IF")
petc(MISSING_END_LOCAL,              "Missing END_LOCAL")
petc(MISSING_END_MODEL,              "Missing END_MODEL")
petc(MISSING_END_NOTES,              "Missing END_NOTES")
petc(MISSING_END_OBJECTIVE,          "Missing END_OBJECTIVE")
petc(MISSING_END_PARAMETER,          "Missing END_PARAMETER")
petc(MISSING_END_PROCEDURE,          "Missing END_PROCEDURE")
petc(MISSING_END_PURPOSE,            "Missing END_PURPOSE")
petc(MISSING_END_REALIZATION,        "Missing END_REALIZATION")
petc(MISSING_END_REFERENCES,         "Missing END_REFERENCES")
petc(MISSING_END_REPEAT,             "Missing END_REPEAT")
petc(MISSING_END_RULE,               "Missing END_RULE")
petc(MISSING_END_SCHEMA,             "Missing END_SCHEMA")
petc(MISSING_END_SCHEMA_DATA,        "Missing END_SCHEMA_DATA")
petc(MISSING_END_TEST_CASE,          "Missing END_TEST_CASE")
petc(MISSING_END_TYPE,               "Missing END_TYPE")
petc(MISSING_COMMA,                  "Missing , (comma)")
petc(STRING_TOO_LONG,                "String too long")
petc(UNIMPLEMENTED_AGGREGATION_TYPE, "Unimplemented aggregation type")
petc(INVALID_INCREMENT_CONTROL,      "Invalid increment control")
petc(MISSING_TO,                     "Missing TO")
petc(MISSING_LPAREN,                 "Missing ( (left parenthesis)")
petc(MISSING_RBRACE,                 "Missing } (right brace)")
petc(EXPECTED_INTERVAL_OP,           "Expected < or <=")

    /* runtime errors */

rtetc(RUNTIME_STACK_OVERFLOW,        "Runtime stack overflow")
rtetc(VALUE_OUT_OF_RANGE,            "Value out of range")
rtetc(INVALID_CASE_VALUE,            "Invalid CASE expression value")
rtetc(DIVISION_BY_ZERO,              "Division by zero")
rtetc(INVALID_FUNCTION_ARGUMENT,     "Invalid function argument")
rtetc(RUNTIME_STRING_TOO_LONG,       "String too long")
rtetc(INVALID_REGULAR_EXPRESSION,    "Invalid regular expression")
rtetc(UNIMPLEMENTED_RUNTIME_FEATURE, "Unimplemented runtime feature")
