{$N-,V-,W-,G+,C MOVEABLE DISCARDABLE}
Unit wbibsfrm;

interface

Uses
  WinTypes,WinProcs,Strings,WObjects,commdlg,win31,
  wbibgui,wbibdisp,rc_id,rc_strng,wc_help,
  bibvars,bibstrg,bibutil,bibinit,bibtext,streams,bibfile,lfnunit;

type
  PEditWindow = ^TEditWindow;
  TEditWindow = object(TWindow)
    Editor:      PEditEx;
    FindRep:     TFindReplace;
    OldEdFont:   HFont;
    PosRec:      InitialSizePtr;
    MinimalSize: TPoint;
    constructor init(AParent: PWindowsObject;
                     APosRec: InitialSizePtr; AMenuID: word);
    function    GetClassName: PChar; virtual;
    procedure   GetWindowClass(var Class: TWndClass); virtual;
    procedure   wmSize(var Msg: TMessage);    virtual wm_First+wm_Size;
    procedure   wmSetFocus(var Msg: TMessage);virtual wm_first+wm_SetFocus;
    procedure   SetupWindow; virtual;
    procedure   InitPos;

    procedure   wmCommand(var Msg: TMessage); virtual wm_first+wm_Command;
    procedure   Find(var Msg: TMessage);      virtual cm_first+dl_EdSFFind;
    procedure   Replace(var Msg: TMessage);   virtual cm_first+dl_EdSFReplace;
    procedure   bibKbHook(var Msg: TMessage); virtual wm_first+bib_KbHook;
    procedure   miCancel(var Msg: TMessage);  virtual cm_first+mi_sfCancel;
    procedure   miSave(var Msg: TMessage);    virtual cm_first+mi_sfSave;
    procedure   SetFont(var Msg: TMessage);   virtual cm_first+mi_sfFont;
    procedure   DoSearch(IsReplace,ReplaceAll,PromptOnRep,CaseSen: boolean);
    procedure   ReSearch(var Msg: TMessage);  virtual cm_first+dl_EdSFFindNext;
    procedure   FindRepMsg(var Msg: TMessage);virtual wm_first+bib_FindRep;
    procedure   Cancel(var Msg: TMessage);    virtual;
    procedure   ok(var Msg: TMessage);        virtual;
    procedure   wmDestroy(var Msg: TMessage); virtual wm_first+wm_Destroy;
    destructor  done; virtual;
  end;

  PEdShowFormatDlg = ^TEdShowFormatDlg;
  TEdShowFormatDlg = object(TEditWindow)
    EndOfShowFormat: longint;
    OldShowFormat: ShowFormatType;
    Modified: boolean;
    constructor init(AParent: PWindowsObject);
    procedure   SetupWindow; virtual;
    procedure   wmActivate(var Msg: TMessage); virtual wm_first+wm_Activate;
    procedure   wmInitMenu(var Msg: TMessage); virtual wm_first+wm_InitMenu;
    procedure   Update(var Msg: TMessage);     virtual cm_first+mi_sfUpdate;
    procedure   Cancel(var Msg: TMessage);     virtual;
    procedure   ok(var Msg: TMessage);         virtual;
    destructor  done; virtual;
  end;



implementation

var
  ghKbrdHook: HHook;
  KbdHookInst: TFarProc;

{$F+}
function TrapKbHook(Code: integer; wParam: Word; lParam: longint): longint; export;
var
  Send: word;
begin
  Send:=0;
  if (Code<0) or (Code<>HC_ACTION) or
     (lParam and (wmChar_BeingReleased or  wmChar_KeyWasDown
                  or wmChar_AltPressed) <> 0) or AmWaiting or
     (EdShowFormat=Nil) or (GetActiveWindow<>EdShowFormat^.HWindow) then
       { Repeats, key releases and the like - ignore }
  else if (wParam=vk_F1) or (wParam=vk_F2) or (wParam=vk_F3)
       or (wParam=vk_Escape) then Send:=wParam;
  if Send<>0 then
  begin
    PostMessage(EdShowFormat^.HWindow,bib_KbHook,Send,0);
    TrapKbHook:=1
  end else
      TrapKbHook:=CallNextHookEx(ghKbrdHook,Code,wparam,lparam);
end;

function FindRepWndProc(Wnd: HWnd; Msg, wParam: Word; lParam: LongInt): LongInt;
                        export;
begin
  FindRepWndProc:=0;
  if Msg=FindRepMsg then FindRepWndProc:=SendMessage(Wnd,bib_FindRep,wParam,lParam)
  else FindRepWndProc:=DefWindowProc(Wnd,Msg,wParam,lParam);
end;
{$F-}

constructor TEditWindow.init(AParent: PWindowsObject;
                             APosRec: InitialSizePtr; AMenuID: word);
begin
  TWindow.init(AParent,'Edit');
  DisableAutoCreate;
  attr.X:=100; attr.Y:=100;
  Attr.H:=200; Attr.W:=200;
  Attr.Style:=ws_OverlappedWindow or ws_ClipChildren;
  Attr.Menu:=LoadMenu(HInstance,PChar(AMenuID));
  New(Editor,init(@Self,dl_EditWindowEBox,'',0,0,0,0,$7FF0,true));
  Editor^.Attr.style:=Editor^.Attr.style or es_NoHideSel;
  FindRepWnd:=0;
  PosRec:=APosRec;
end;               { TEditWindow.init }

function TEditWindow.GetClassName: PChar;
begin
  GetClassName:=BibDBEditWindowClass;
end;

procedure TEditWindow.GetWindowClass(var Class: TWndClass);
begin
  TWindow.GetWindowClass(Class);
  Class.lpfnWndProc:=@FindRepWndProc;  { Subclass to trap Find/Replace messages }
  Class.hicon:=MainIcon;
end;                   { TEditWindow.GetWindowClass }

procedure TEditWindow.wmSize(var Msg: TMessage);
begin
  TWindow.wmSize(Msg);
  MoveWindow(Editor^.HWindow,-1,-1,Msg.lParamLo+2,Msg.lParamHi+2,true);
end;

procedure TEditWindow.wmSetFocus(var Msg: TMessage);
begin SetFocus(Editor^.HWindow); end;

procedure TEditWindow.SetupWindow;
var
  R: TRect;
begin
  TWindow.SetupWindow;
  Application^.MakeWindow(Editor);
  InitPos;

  FillChar(FindRep,sizeof(TFindReplace),#0);
  with FindRep do
  begin
    lStructSize:=sizeof(TFindReplace);
    hWndOwner:=HWindow;
    lpstrFindWhat:=MemAlloc(129);    lpstrFindWhat[0]:=#0;
    wFindWhatLen:=129;
    lpstrReplaceWith:=MemAlloc(129); lpstrReplaceWith[0]:=#0;
    wReplaceWithLen:=129;
  end;
  FindRep.HInstance:=HInstance;

  with Fonts^[ShowFormatFont] do
  begin
    if not Initialized then
    begin
      Font:=CreateFontIndirect(Logfont);
      Initialized:=true;
    end;
    OldEdFont:=HFont(SendMessage(Editor^.HWindow,wm_GetFont,0,0));
    SendMessage(Editor^.HWindow,wm_SetFont,Font,1);
  end;
  GetClientRect(HWindow,R);
  MoveWindow(Editor^.HWindow,-1,-1,R.right+2,R.bottom+2,false);

  KbdHookInst:=MakeProcInstance(@TrapKbHook,HInstance);
  ghKbrdHook:=SetWindowsHookEx(wh_Keyboard,THookProc(KbdHookInst),
                               Hinstance,GetCurrentTask);

  Show(sw_Show);
end;                 { TEditWindow.SetupWindow }

procedure TEditWindow.InitPos;
var
  Rect: TRect;
  Xset,Yset,Wset,Hset: integer;
  changed: boolean;
begin
  if PosRec=Nil then Exit;
  if PosRec^.H<>0 then
  with PosRec^ do
  begin
    XSet:=X; Yset:=Y; Wset:=W; HSet:=H; changed:=true;
  end else
  begin
    GetWindowRect(HWindow,Rect);
    with Rect do
    begin
      XSet:=left; YSet:=top; WSet:=right-left; HSet:=bottom-top;
    end;
    Changed:=false;
  end;
  if Xset+Wset>ScreenRect.right then
  begin
    XSet:=ScreenRect.right-Wset; changed:=true;
  end;
  if Xset<0 then
  begin
    XSet:=0; changed:=true;
  end;
  if XSet+Wset>ScreenRect.right then
  begin
    WSet:=ScreenRect.right-Xset; changed:=true;
  end;
  if Yset+Hset>ScreenRect.bottom then
  begin
    YSet:=ScreenRect.bottom-Hset; changed:=true;
  end;
  if Yset<0 then
  begin
    YSet:=0; changed:=true;
  end;
  if Yset+Hset>ScreenRect.bottom then
  begin
    HSet:=ScreenRect.bottom-Yset; changed:=true;
  end; 
  if changed then MoveWindow(HWindow,Xset,Yset,Wset,Hset,false);
end;                              { TEditWindow.InitPos }

procedure TEditWindow.wmCommand(var Msg: TMessage);
begin
  if Msg.lParamLo=0 then   { Menu or accel }
    case Msg.wParam of
      dl_EdSFUndo:     Editor^.Undo;
      dl_EdSFCut:      Editor^.Cut;
      dl_EdSFCopy:     Editor^.Copy;
      dl_EdSFPaste:    Editor^.Paste;
      dl_EdSFClearAll: Editor^.Clear;
      else TWindow.wmCommand(Msg);
    end
  else TWindow.wmCommand(Msg);
end;                 { TEditWindow.wmCommand }

procedure TEditWindow.bibKbHook(var Msg: TMessage);
begin
  case Msg.wParam of
    vk_F1: WinHelp(HMainW,HelpFile,Help_Context,hc_EditShowFormat);
    vk_F2: Find(Msg);
    vk_F3: ReSearch(Msg);
    vk_Escape: Cancel(Msg);
  end;
end;                 { TEditWindow.bibKbHook }

procedure TEditWindow.Find(var Msg: TMessage);
begin
  if (FindRepWnd<>0) and IsWindow(FindRepWnd) then SetFocus(FindRepWnd)
  else begin
    FindRep.flags:=fr_HideUpDown or fr_HideWholeWord;
    FindRepWnd:=FindText(FindRep);
  end;
end;                     { TEditWindow.Find }

procedure TEditWindow.Replace(var Msg: TMessage);
begin
  if (FindRepWnd<>0) and IsWindow(FindRepWnd) then SetFocus(FindRepWnd)
  else begin
    FindRep.flags:=fr_HideUpDown or fr_HideWholeWord;
    FindRepWnd:=ReplaceText(FindRep);
  end;
end;                     { TEditWindow.Replace }

procedure TEditWindow.SetFont(var Msg: TMessage);
begin
  if SelectFont(HWindow,ShowFormatFont,false) then
  with Fonts^[ShowFormatFont] do
  begin
    if not Initialized then
    begin
      Font:=CreateFontIndirect(Logfont);
      Initialized:=true;
    end;
    SendMessage(Editor^.HWindow,wm_SetFont,Font,1);
    Invalidaterect(Editor^.HWindow,Nil,true);
    OptionsModified.WindowsParams:=true;
  end;
end;               { TEditWindow.SetFont }

procedure TEditWindow.DoSearch(IsReplace,ReplaceAll,PromptOnRep,CaseSen: boolean);
var
  S: array[0..80] of Char;
  Rslt: Integer;
  SelStart,SelEnd: integer;
begin
  with FindRep do
  repeat
    Rslt:=0;
    if IsReplace then
    begin
      Editor^.GetSelection(SelStart,SelEnd);
      if SelStart=SelEnd then
        Rslt := Editor^.Search(-1, lpstrFindWhat, CaseSen)
      else Rslt:=0;
    end else Rslt := Editor^.Search(-1, lpstrFindWhat, CaseSen);
    if Rslt = -1 then
    begin
      if not IsReplace or not ReplaceAll then
      begin
        WVSPrintF(S, '"%0.60s" not found.', lpstrFindWhat);
        MessageBox(HWindow, S, 'Find error', mb_OK + mb_IconExclamation);
      end;
    end else if IsReplace then
    begin
      if not PromptOnRep then
      begin
        Editor^.Insert(lpstrReplaceWith);
        Rslt := Editor^.Search(-1, lpstrFindWhat, CaseSen);
        if Rslt<>-1 then Rslt:=-2;
      end else
      begin
        Rslt := MessageBox(HWindow, 'Replace this occurrence?',
          'Search/Replace', mb_YesNoCancel + mb_IconQuestion);
        if Rslt = id_Yes then Editor^.Insert(lpstrReplaceWith)
        else if Rslt = id_Cancel then Exit;
      end;
    end;
  until (Rslt = -1) or not ReplaceAll or not (IsReplace and (Rslt<>-2));
end;                    { TEditWindow.DoSearch }

procedure TEditWindow.ReSearch(var Msg: TMessage);
begin
  with FindRep do
    if lpstrFindWhat[0]<>#0 then
      DoSearch(false,false,false,(flags and fr_MatchCase <> 0));
end;

procedure TEditWindow.FindRepMsg(var Msg: TMessage);
begin
  with PFindReplace(Msg.lParam)^ do
  begin
    if (Flags and fr_FindNext <> 0) then
      DoSearch(false,false,false, (flags and fr_MatchCase <> 0))
    else if (Flags and fr_Replace <> 0) then
      DoSearch(true,false,false, (flags and fr_MatchCase <> 0))
    else if (Flags and fr_ReplaceAll <> 0) then
      DoSearch(true,true,false, (flags and fr_MatchCase <> 0));
  end;
end;

procedure TEditWindow.miCancel(var Msg: TMessage);
begin Cancel(Msg); end;

procedure TEditWindow.miSave(var Msg: TMessage);
begin Ok(Msg); end;

procedure TEditWindow.Cancel(var Msg: TMessage);
begin CloseWindow; end;

procedure TEditWindow.ok(var Msg: TMessage);
begin CloseWindow; end;

procedure TEditWindow.wmDestroy(var Msg: TMessage);
var
  Placement: TWindowPlacement;
begin
  SendMessage(Editor^.HWindow,wm_SetFont,OldEdFont,0);
  With Fonts^[ShowFormatFont] do
  begin
    DeleteObject(Font); Initialized:=false;
  end;
  if PosRec<>Nil then
  begin
    FillChar(Placement,sizeof(TWindowPlacement),0);
    Placement.length:=sizeof(TWindowPlacement);
    if GetWindowPlacement(HWindow,@Placement)<>bool(0) then
    with PosRec^, Placement.rcNormalPosition do
      if (X<>left) or (Y<>top) or (W<>(right-left)) or (H<>(bottom-top)) then
      begin
        X:=left; Y:=top; W:=right-left; H:=bottom-top;
        OptionsModified.WindowsParams:=true;
      end;
  end;
  TWindow.wmDestroy(Msg);
end;                        { TEditFieldDlg.wmDestroy }

destructor TEditWindow.Done;
begin
  with FindRep do
  begin
    FreeMem(lpstrFindWhat,wFindWhatLen);
    FreeMem(lpstrReplaceWith,wReplaceWithLen);
  end;
  UnhookWindowsHookEx(ghKbrdHook);
  FreeProcInstance(KbdHookInst);
  FindRepWnd:=0;
  TWindow.done;
end;                 { TEditWindow.Done }

{ TEdShowFormatDlg methods }

constructor TEdShowFormatDlg.init(AParent: PWindowsObject);
begin
  TEditWindow.init(AParent,@EdShowFormSize,rc_ShowFormatMenu);
  EdShowFormat:=@Self;
  with OldShowFormat do
  begin
    P:=Nil; len:=0;
  end;
  Modified:=false;
end;                    { TEdShowFormatDlg.init }

procedure TEdShowFormatDlg.SetupWindow;
const
  BufSize = $7FF0;
var
  cfg: text;
  S: PRamStream;
  P: PChar;
  ch: char;
  tmp: string;
  OldCursor: HCursor;
  F: array[0..32] of char;
  HighField: integer;
begin
  TEditWindow.SetupWindow;
  SetWindowText(HWindow,'Loading ShowFormat...');

  OldCursor:=SetCursor(WaitingCursor);
  AmWaiting:=true;

  LFNNew(cfg,true); LFNAssign(cfg,ConfigFile^);
  LFNReset(cfg,0); TextSeek(cfg,BeginOfShowFormat);
  P:=MemAlloc(BufSize);
  New(S,UseBuf(P,BufSize-1));
  HighField:=0;
  ShowFormatConfig(@cfg,Nil,HighField,@OldShowFormat,Nil,S);
  LFNDispose(cfg);
  EndOfShowFormat:=BeginOfShowFormat+S^.GetPos;
  P[S^.GetPos-3]:=#0;

  Editor^.SetText(P);
  dispose(S,done);
  FreeMem(P,BufSize);

  SetWindowText(HWindow,'ShowFormat');
  SetCursor(OldCursor); AmWaiting:=false;
end;                    { TEdShowFormatDlg.SetupWindow }

procedure TEdShowFormatDlg.wmInitMenu(var Msg: TMessage);
var
  StartPos,EndPos: integer;

procedure Activate(id: word; on: boolean);
begin
  if on then EnableMenuItem(Attr.Menu,id,mf_ByCommand or mf_Enabled)
  else EnableMenuItem(Attr.Menu,id,mf_ByCommand or mf_Grayed)
end;

begin
  Editor^.GetSelection(StartPos,EndPos);
  Activate(dl_EdSFCut,StartPos<>EndPos);
  Activate(dl_EdSFCopy,StartPos<>EndPos);
  Activate(dl_EdSFDelete,StartPos<>EndPos);

  Activate(dl_EdSFUndo,Editor^.CanUndo);
  Activate(dl_EdSFPaste,IsClipboardFormatAvailable(cf_Text));
end;                 { TEdShowFormatDlg.wmInitMenu }

procedure TEdShowFormatDlg.Update(var Msg: TMessage);
var
  tmp: string;
  SF: ShowFormatType;
  HighField: integer;
begin
  SF.len:=0; SF.P:=Nil; HighField:=0;
  tmp:=ShowFormatConfig(Nil,Editor,HighField,@SF,Nil,Nil);
  if tmp<>'' then ErrorMessage(tmp)
  else begin
    with ShowFormat[true] do
      if P<>Nil then FreeMem(P,len);
    ShowFormat[true]:=SF;
    if EdEnWindow<>Nil then
      SendMessage(EdEnWindow^.HWindow,bib_Update,0,0)
    else
      SendMessage(HMainW,bib_Update,0,0);
    Modified:=true;
  end;
end;                   { TEdShowFormatDlg.Update }

procedure TEdShowFormatDlg.Cancel(var Msg: TMessage);
var
  ans: integer;
begin
  if Editor^.IsModified then
  begin
    ans:=AskIf3(StringRC(Str_ShowFormatHasChanged,''),'Yes','No','Cancel');
    if ans=1 then
    begin
      ok(Msg); Exit;
    end else if ans=3 then Exit;
  end;
  if modified then
  begin
    with ShowFormat[true] do if P<>Nil then FreeMem(P,len);
    ShowFormat[true].len:=OldShowFormat.len;
    ShowFormat[true].P:=OldShowFormat.P;
    with OldShowFormat do
    begin
      len:=0; P:=Nil;
    end;
    if EdEnWindow<>Nil then
      SendMessage(EdEnWindow^.HWindow,bib_Update,0,0)
    else
      SendMessage(HMainW,bib_Update,0,0);
  end;
  TEditWindow.cancel(Msg);
end;               { TEdShowFormatDlg.Cancel }

procedure TEdShowFormatDlg.ok(var Msg: TMessage);
var
  tmp: string;
  SF: ShowFormatType;
  Oldcfg,NewCfg: PBufStream;
  Dir,Name,Ext,TempFile,BackFile: Pstring;
  Source: PRamStream;
  F: array[0..255] of char;
  fl: file;
  l: longint;
  HighField: integer;

procedure TidyUp;
begin
  if Source<>Nil then Dispose(Source,done); Source:=Nil;
  LFNDispose(fl);
  AllocStrings(false,@TempFile,@BackFile,Nil,Nil);
  AllocStrings(false,@Dir,@Name,@Ext,Nil);
end;

begin
  Source:=Nil; OldCfg:=Nil; NewCfg:=Nil;
  AllocStrings(true,@Dir,@Name,@Ext,Nil);
  AllocStrings(true,@TempFile,@BackFile,Nil,Nil);
  LFNNew(fl,true);
{  if Modified then}
  begin
    SF.len:=0; SF.P:=Nil;
    New(Source,init($7FF0)); HighField:=0;
    tmp:=ShowFormatConfig(Nil,Editor,HighField,@SF,Nil,Source);
    if tmp<>'' then
    begin
      ErrorMessage(tmp); TidyUp; Exit;
    end else
    begin
      LFNFsplit(ConfigFile^,Dir,Name,Ext);
      BackFile^:=Dir^+Name^+ConfigBackExtension^;
      CanonicalFname(BackFile^);
      Unique(Dir^,TempFile^);
      if TempFile^='' then
      begin
        ErrorMessageRC(Str_CantWriteCfg,'');
        TidyUp; Exit;
      end;
      StrPCopy(F,ConfigFile^);
      New(OldCfg,init(F,stOpenRead,AuxBufSize));
      if OldCfg^.Status<>stOK then
      begin
        ErrorMessageRC(Str_CantReadFile,ConfigFile^);
        TidyUp; Exit;
      end;
      StrPCopy(F,TempFile^);
      New(NewCfg,init(F,stCreate,AuxBufSize));
      if NewCfg^.Status<>stOK then
      begin
        ErrorMessageRC(Str_CantWriteCfg,''); TidyUp; Exit;
      end;

      OldCfg^.seek(0);
      NewCfg^.CopyFrom(OldCfg^,BeginOfShowFormat);

      with Source^ do  { Get rid of trailing newlines }
      begin
        l:=size-1;
        if (size>3) and (Buffer^[size-1] in [10,13]) and
           (Buffer^[size-2] in [10,13]) and
           (Buffer^[size-3]=Ord(rbrace)) then
        begin
          l:=size-4;
          while (l>0) and (Buffer^[l] in [10,13]) do dec(l);
          seek(l+1); truncate;
        end;
      end;
      Source^.seek(0); NewCfg^.CopyFrom(Source^,Source^.GetSize);
      tmp:=#13#10+rbrace+#13#10; NewCfg^.write(tmp[1],length(tmp));

      OldCfg^.seek(EndOfShowFormat);
      if OldCfg^.Status=stOK then
        NewCfg^.CopyFrom(OldCfg^,OldCfg^.GetSize-OldCfg^.GetPos);

      OldCfg^.Reset; Dispose(OldCfg,Done); OldCfg:=Nil;
      Source^.reset; Dispose(Source,Done); Source:=Nil;

      if NewCfg^.Status=stOK then
      begin
        Dispose(NewCfg,Done); NewCfg:=Nil;

        LFNAssign(fl,BackFile^);
        LFNErase(fl); 
        LFNAssign(fl,ConfigFile^);
        if LFNRename(fl,BackFile^)<>0 then
        begin
          ErrorMessageRC(Str_CantWriteCfg,''); TidyUp; Exit;
        end;
        LFNAssign(fl,TempFile^);
        if LFNRename(fl,ConfigFile^)<>0 then
        begin
          ErrorMessageRC(Str_CantWriteCfg,''); TidyUp; Exit;
        end;
      end else
      begin
        NewCfg^.Reset; Dispose(NewCfg,Done); NewCfg:=Nil;
        LFNAssign(fl,TempFile^); LFNErase(fl);
        TidyUp; Exit;
      end;

      with ShowFormat[true] do
        if P<>Nil then FreeMem(P,len);
      ShowFormat[true]:=SF;
      with OldShowFormat do
      begin
        FreeMem(P,len); P:=Nil; len:=0;
      end;
      if EdEnWindow<>Nil then
        SendMessage(EdEnWindow^.HWindow,bib_Update,0,0)
      else
        SendMessage(HMainW,bib_Update,0,0);
      end;
  end;
  TEditWindow.ok(Msg);
end;                    { TEdShowFormatDlg.ok }

procedure TEdShowFormatDlg.wmActivate(var Msg: TMessage);
begin
  if (Msg.wParam<>wa_InActive) then
  begin
    CurrentWindow:=@Self;
    MessageParent:=HWindow;
  end;
end;                   { TEdShowFormatDlg.wmActivate }

destructor TEdShowFormatDlg.done;
begin
  EdShowFormat:=Nil;
  with OldShowFormat do
    if P<>Nil then FreeMem(P,len);
  TEditWindow.done;
end;

end.
