{$N-,W-,G+,V-,C MOVEABLE DISCARDABLE}

Unit wbibesrt;

interface

Uses
  wobjects, WinTypes, WinProcs, strings, WinDos,
  wbibgui, rc_strng, rc_id, wbibdisp, wbibpatt, wbibslct,
  bibvars, bibfile, bibstrg, bibutil, bibstrm, bibsrtpt, wc_help,
  bibtmplt, bibcache, lfnunit;

procedure SortOptions(WhichSort: byte; var Amovedbib: boolean);

implementation

const
  NCombinations = 14;

  CollationInd    = 1; OrderInd         = 2; NameAscTInd     = 3;  NameAscFInd = 4;
  PattFirstInd    = 5; PattFileCboxInd  = 6; PattFileEBoxInd = 7;
  PattExplicitInd = 8; NameAscStaticInd = 9; OrderStaticInd  = 10;

type

  CriteriaString = string[NSortCriteria];

  PEditPattFile = ^TEditPattFile;
  TEditPattFile = object(TEditNoCr)
    constructor InitResource(AParent: PWindowsObject; id: integer);
    function    CanClose: boolean; virtual; 
  end;

  KeyRec = record
    eid,aid,nid,sid: integer;
    Ebox: PEditTemplate;
    Asc,NullFirst: PCheckBox;
  end;

  PLoadWhatDlg = ^TLoadWhatDlg;
  TLoadWhatDlg = object(TBasicDialog)
    SMode: ConfigSortPtr;
    Pattern: PatRecPtr;
    constructor init(AParent: PWindowsObject; ASMode: ConfigSortPtr;
                     APattern: PatRecPtr);
    procedure   SetupWindow; virtual;
    procedure   AtDef(var Msg: TMessage);   virtual id_first+dl_LoadFromDefMode;
    procedure   AtCur(var Msg: TMessage);   virtual id_first+dl_LoadFromCurMode;
    procedure   AtExp(var Msg: TMessage);   virtual id_first+dl_LoadFromExpMode;
    procedure   AtBib(var Msg: TMessage);   virtual id_first+dl_LoadFromBibMode;
    procedure   AtOther(var Msg: TMessage); virtual id_first+dl_LoadFromOtherMode;
  end;

  PSaveWhatDlg = ^TSaveWhatDlg;
  TSaveWhatDlg = object(TLoadWhatDlg)
    procedure   SetupWindow; virtual;
    procedure   AtDef(var Msg: TMessage);   virtual id_first+dl_LoadFromDefMode;
    procedure   AtCur(var Msg: TMessage);   virtual id_first+dl_LoadFromCurMode;
    procedure   AtExp(var Msg: TMessage);   virtual id_first+dl_LoadFromExpMode;
    procedure   AtBib(var Msg: TMessage);   virtual id_first+dl_LoadFromBibMode;
    procedure   AtOther(var Msg: TMessage); virtual id_first+dl_LoadFromOtherMode;
  end;

  PSortEditDlg = ^TSortEditDlg;
  TSortEditDlg = object(TBasicDialog)
    EditSortMode: ConfigSortType;
    SModeToChange: ConfigSortPtr;
    Pattern: PatRecPtr;
    Title: PChar;
    changed,ForceOn: boolean;
    KeysCont: array[1..3,boolean] of KeyRec;
    OnOffCBox, CollationCBox, PattFileCBox: PCheckBox;
    PattFirstCBox: PCheckBox;
    StringsCombo, OrderCombo: PComboBox;
    NameAscCbox: array[boolean] of PCheckBox;
    PattFileEBox: PEditPattFile;
    Ostr: array[1..NCombinations] of CriteriaString;
    ids: array[1..10] of integer;
    PFile: string;
    constructor init(AParent: PWindowsObject; Atitle: PChar;
                     AEditSort: ConfigSortPtr;
                     ASortPattern: PatRecPtr; AForceOn: boolean);
    procedure   TranslateOrder(Sin: string; var Sout: CriteriaString);
    procedure   Allowed;
    procedure   FillupDialog;
    procedure   SetupWindow; virtual;
    procedure   OrderChange(var Msg: TMessage);
                            virtual id_first+dl_SortModeOrder;
    procedure   OnOffChange(var Msg: TMessage);
                            virtual id_first+dl_SortModeOn;
    procedure   PfileChange(var Msg: TMessage);
                            virtual id_first+dl_SortModePFileCBox;
    procedure   LoadSMode(var Msg: TMessage);
                            virtual id_first+dl_SortModeLoad;
    procedure   SaveSMode(var Msg: TMessage);
                            virtual id_first+dl_SortModeSave;
    procedure   ExpPatt(var Msg: TMessage);
                            virtual id_first+dl_SortModeExpPatt;

    procedure   ok(var Msg: TMessage); virtual id_first+id_ok;
  end;

var
  MovedBib: boolean;

{ TEditPattFile methods }

constructor TEditPattFile.InitResource(AParent: PWindowsObject; id: integer);
begin
  TEditNoCr.InitResource(AParent,id,255,[#0..#255]-FileNameSet);
end;

function TEditPattFile.CanClose: boolean;
begin
  if IsWindowEnabled(HWindow) then CanClose:=TEditNoCr.CanClose
  else CanClose:=true;
end;

{ TLoadWhatDlg methods }

constructor TLoadWhatDlg.init(AParent: PWindowsObject; ASMode: ConfigSortPtr;
                              APattern: PatRecPtr);
begin
  TBasicDialog.init(AParent,PChar(rc_LoadSModeDlg));
  SMode:=ASMode;
  Pattern:=APattern;
end;

procedure TLoadWhatDlg.SetupWindow;
begin
  TBasicDialog.SetupWindow; InitPos;
  SetWindowText(HWindow,'Load from:');
  EnableWindow(GetItemHandle(dl_LoadFromBibMode),BibFileExists);
end;

procedure TLoadWhatDlg.AtDef(var Msg: TMessage);
begin
  SMode^:=ConfigSortMode^;
  RecallBufferStack(Pattern^,SortPattPosDef);
  EndDlg(id_ok);
end;

procedure TLoadWhatDlg.AtCur(var Msg: TMessage);
begin
  SMode^:=CurrentSortMode^;
  RecallBufferStack(Pattern^,SortPattPosCur);
  EndDlg(id_ok);
end;

procedure TLoadWhatDlg.AtExp(var Msg: TMessage);
begin
  SMode^:=ExportSortMode^;
  RecallBufferStack(Pattern^,SortPattPosExp);
  EndDlg(id_ok);
end;

procedure TLoadWhatDlg.AtBib(var Msg: TMessage);
var
  found: boolean;
  i: longint;
  tmp: string;
begin
  ResetBibFile(bib,bibname^);
  i:=0; found:=false;
  while (not eof(bib)) and (not found) and (i<=MaxLookForSort) do
  begin
    tmp:='';
    readline(bib,tmp,UnixBib); ChrDel(tmp,' '); StrLwr(tmp);
    inc(i);
    if tmp='\sort'+lbrace then
    begin
      LoadSortMode(bib,Nil,SMode^,Pattern);
      found:=true;
    end;
  end;
  if found then EndDlg(id_ok)
  else begin
    ErrorMessageRC(Str_SortEnvNotFound,bibname^);
    EndDlg(id_cancel);
  end;
end;                           { TLoadWhatDlg.AtBib }

procedure TLoadWhatDlg.AtOther(var Msg: TMessage);
var
  found,accept,ABibFile: boolean;
  i: longint;
  tmp: string;
  f: text;
  fname,D,N,E: Pstring;

procedure TidyUp;
begin
  AllocStrings(false,@fname,@D,@N,@E);
end;

begin
  AllocStrings(true,@fname,@D,@N,@E);
  fname^:=''; found:=false;
  FileChoose(fname^,DefExtension[BibTeXFormat]^,TexInputList,
                     AnyFile and (not (Directory or SysFile)),
                     true,true,false,Nil,'Load from File:',DatabaseDesc,accept);
  if not accept then
  begin
    TidyUp; EndDlg(id_cancel)
  end else
  begin
    CanonicalFname(fname^);
    ABibFile:=false;
    if Linked then
    begin
      for i:=1 to MaxBibFiles do
        ABibFile:=ABibFile or (StrCmpI(BibFiles^[i].name,fname^,1,1,255)=0);
    end else ABibFile:=(StrCmpI(fname^,BibName^,1,1,255)=0);
    if ABibFile and Linked then
      ErrorMessageRC(Str_EditInLinkMode,'')
    else if ABibFile and BibReadOnly then
      ErrorMessageRC(Str_ChangeROAttrib,'')
    else begin
      EntryCache^.Clear;
      i:=0;
      tmp:='';
      CanonicalFname(fname^);
      LFNfsplit(fname^,D,N,E);
      LFNNew(f,true); LFNAssign(f,fname^);
      LFNReset(f,0);
      while (tmp<>'\sort'+lbrace) and (not eof(f)) and
               ((i<MaxLookForSort) or (E^='.cfg')) do
      begin
        ReadLine(f,tmp,true); StrRepl(tmp,#9,' ',1,255,255); ChrDel(tmp,' ');
        StrLwr(tmp);
        inc(i);
      end;
      if tmp='\sort'+lbrace then
      begin
        LoadSortMode(f,Nil,SMode^,Pattern);
        found:=true;
      end;
      LFNDispose(f);
      if found then
      begin
        TidyUp; EndDlg(id_ok); Exit;
      end else
      begin
        ErrorMessageRC(Str_SortEnvNotFound,fname^);
        TidyUp; EndDlg(id_cancel); Exit;
      end;
    end;
  end;
end;                              { TLoadWhatDlg.AtOther }

{ TSaveWhatDlg methods }

procedure TSaveWhatDlg.SetupWindow;
begin
  TBasicDialog.SetupWindow;
  SetWindowText(HWindow,'Save to:');
  if BibReadOnly or Linked or not BibFileExists then
  begin
    EnableWindow(GetItemHandle(dl_LoadFromCurMode),false);
    EnableWindow(GetItemHandle(dl_LoadFromBibMode),false);
  end;
end;                 { TSaveWhatDlg.SetupWindow }

procedure TSaveWhatDlg.AtDef(var Msg: TMessage);
begin
  ConfigSortMode^:=SMode^;
  PushBufferStack(Pattern^,sizeof(PatRec),SortPattModeDef,SortPattPosDef);
  EndDlg(id_ok);
end;

procedure TSaveWhatDlg.AtCur(var Msg: TMessage);
begin
  CurrentSortMode^:=SMode^;
  PushBufferStack(Pattern^,sizeof(PatRec),SortPattModeCur,SortPattPosCur);
  EndDlg(id_ok);
end;

procedure TSaveWhatDlg.AtExp(var Msg: TMessage);
begin
  ExportSortMode^:=SMode^;
  PushBufferStack(Pattern^,sizeof(PatRec),SortPattModeExp,SortPattPosExp);
  EndDlg(id_ok);
end;

procedure TSaveWhatDlg.AtBib(var Msg: TMessage);
begin
  CloseFile(bib);
  EntryCache^.Clear;
  WaitingMessage('Saving...');
  SaveSortMode(bibname^,SMode^,Pattern);
  WaitingOff;
  movedbib:=true;
  CheckForIndexFile(bib,bibname);
  EndDlg(id_ok);
end;                     { TSaveWhatDlg.AtBib }

procedure TSaveWhatDlg.AtOther(var Msg: TMessage);
var
  accept: boolean;
  fname: string;
begin
  fname:='';
  FileChoose(fname,DefExtension[BibTeXFormat]^,TexInputList,
                     AnyFile and (not (Directory or SysFile)),
                     true,false,false,Nil,'Save to File:',DataBaseDesc,accept);
  if not accept then EndDlg(id_Cancel)
  else begin
    CanonicalFname(bibname^);
    LFNClose(bib);
    if StrCmpI(fname,bibname^,1,1,255)=0 then EntryCache^.Clear;
    WaitingMessage('Saving...');
    SaveSortMode(fname,SMode^,Pattern);
    WaitingOff;
    movedbib:=true;
    if StrCmpI(fname,bibname^,1,1,255)=0 then CheckForIndexFile(bib,bibname);
  end;
  EndDlg(id_ok);     
end;                         { TSaveWhatDlg.AtOther }

{ TSortEditDlg methods }

constructor TSortEditDlg.Init(AParent: PWindowsObject; Atitle: PChar;
            AEditSort: ConfigSortPtr;
            ASortPattern: PatRecPtr; AForceOn: boolean);
var
  i: integer;
  bi: boolean;
begin
  TBasicDialog.init(AParent,PChar(rc_SortOptionsDlg));
  changed:=false; Pattern:=ASortPattern;
  ForceOn:=AForceOn;
  SModeToChange:=AEditSort;
  EditSortMode:=AEditSort^; if ForceOn then EditSortMode.SortingOn:=true;
  Title:=Atitle;
  with KeysCont[1,true] do
  begin
    eid:=dl_SortModeKey1tTemp;  aid:=dl_SortModeKey1tAsc;
    nid:=dl_SortModeKey1tNulls; sid:=dl_SortModeKey1TStatic;
  end;
  with KeysCont[1,false] do
  begin
    eid:=dl_SortModeKey1fTemp;  aid:=dl_SortModeKey1fAsc;
    nid:=dl_SortModeKey1fNulls; sid:=dl_SortModeKey1fStatic;
  end;
  with KeysCont[2,true] do
  begin
    eid:=dl_SortModeKey2tTemp;  aid:=dl_SortModeKey2tAsc;
    nid:=dl_SortModeKey2tNulls; sid:=dl_SortModeKey2tStatic;
  end;
  with KeysCont[2,false] do
  begin
    eid:=dl_SortModeKey2fTemp;  aid:=dl_SortModeKey2fAsc;
    nid:=dl_SortModeKey2fNulls; sid:=dl_SortModeKey2fStatic;
  end;
  with KeysCont[3,true] do
  begin
    eid:=dl_SortModeKey3tTemp;  aid:=dl_SortModeKey3tAsc;
    nid:=dl_SortModeKey3tNulls; sid:=dl_SortModeKey3tStatic;
  end;
  with KeysCont[3,false] do
  begin
    eid:=dl_SortModeKey3fTemp;  aid:=dl_SortModeKey3fAsc;
    nid:=dl_SortModeKey3fNulls; sid:=dl_SortModeKey3fStatic;
  end;

  ids[CollationInd]    :=dl_SortModeMixed;
  ids[OrderInd]        :=dl_SortModeOrder;
  ids[NameAscTInd]     :=dl_SortModeNameAscT;
  ids[NameAscFInd]     :=dl_SortModeNameAscF;
  ids[PattFirstInd]    :=dl_SortModePattFirst;
  ids[PattFileCboxInd] :=dl_SortModePFileCBox;
  ids[PattFileEBoxInd] :=dl_SortModePattFile;
  ids[PattExplicitInd] :=dl_SortModeExpPatt;
  ids[NameAscStaticInd]:=dl_SortModeNameAscStatic;
  ids[OrderStaticInd]  :=dl_SortModeOrderStatic;

  for i:=1 to 3 do for bi:=false to true do
  begin
    New(KeysCont[i,bi].EBox,      InitResource(@Self,KeysCont[i,bi].eid));
    New(KeysCont[i,bi].Asc,       InitResource(@Self,KeysCont[i,bi].aid));
    New(KeysCont[i,bi].NullFirst, InitResource(@Self,KeysCont[i,bi].nid));
  end;
  New(OnOffCBox,         InitResource(@Self,dl_SortModeOn));
  New(CollationCBox,     InitResource(@Self,dl_SortModeMixed));
  New(PattFileCBox,      InitResource(@Self,dl_SortModePFileCBox));
  New(PattFirstCBox,     InitResource(@Self,dl_SortModePattFirst));
  New(NameAscCBox[true], InitResource(@Self,dl_SortModeNameAscT));
  New(NameAscCBox[false],InitResource(@Self,dl_SortModeNameAscF));
  New(StringsCombo,      InitResource(@Self,dl_SortModeStrings,255));
  New(OrderCombo,        InitResource(@Self,dl_SortModeOrder,255));
  New(PattFileEBox,      InitResource(@Self,dl_SortModePattFile));
  HelpContext:=hc_SortOptions;
end;                      { TSortEditDlg.Init }

procedure TSortEditDlg.TranslateOrder(Sin: string; var Sout: CriteriaString);
var
  ind: byte;
  keynum: integer;
  tmp: string[10];
begin
  Sout:=''; StrLwr(Sin);
  ind:=1; keynum:=1;
  repeat
    WrdToken(tmp,Sin,',',Ind);
    if tmp='key' then
    begin
      Sout:=Sout+chr(keynum); inc(keynum);
    end else if tmp='pattern' then Sout:=Sout+'P'
    else Sout:=Sout+'N';
  until (ind=0) or (ind>=length(Sin));
end;                            { TSortEditDlg.TranslateOrder }

procedure TSortEditDlg.Allowed;
var
  yes: array[1..10] of boolean;
  KeyYes: array[1..3,boolean] of boolean;
  i,PattAt,Stype: integer;
  bi: boolean;
  F: array[0..255] of char;
begin
  for i:=1 to 10 do yes[i]:=false;
  for i:=1 to 3 do for bi:=false to true do KeyYes[i,bi]:=false;
  if OnOffCBox^.GetCheck = bf_Checked then
  begin
    yes[CollationInd]:=true; yes[OrderInd]:=true; yes[OrderStaticInd]:=true;
    yes[NameAscTInd]:=true;  yes[NameAscStaticInd]:=true;
    Stype:=OrderCombo^.GetSelIndex+1;
    PattAt:=Pos('P',OStr[Stype]);
    if PattAt>0 then
    begin
      yes[NameAscFInd]:=true;     yes[PattFirstInd]:=true;
      yes[PattFileCBoxInd]:=true;
      if PattFileCBox^.GetCheck=bf_Checked then
      begin
        yes[PattFileEBoxInd]:=true;
        if not IsWindowEnabled(PattFileEBox^.HWindow) then
        begin
          StrPCopy(F,PFile); SetWindowText(PattFileEBox^.HWindow,F);
        end;
      end else
      begin
        if IsWindowEnabled(PattFileEBox^.HWindow) then
        begin
          GetWindowText(PattFileEBox^.HWindow,F,255);
          Pfile:=StrPas(F);
          SetWindowText(PattFileEBox^.HWindow,'<explicit>');
        end;
        yes[PattExplicitInd]:=true;
      end;
    end;
    for i:=1 to 3 do
    if Pos(chr(i),OStr[Stype])>0 then
    begin
      KeyYes[i,true]:=true;
      if (PattAt>0) and (Pos(chr(i),Ostr[Stype])>PattAt) then
        KeyYes[i,false]:=true; 
    end; 
  end;

  for i:=1 to 10 do EnableWindow(GetItemHandle(ids[i]),yes[i]);
  for i:=1 to 3 do for bi:=false to true do
  with KeysCont[i,bi] do
  begin
    EnableWindow(EBox^.HWindow,KeyYes[i,bi]);
    EnableWindow(Asc^.HWindow,KeyYes[i,bi]);
    EnableWindow(NullFirst^.HWindow,KeyYes[i,bi]);
    EnableWindow(GetItemHandle(sid),KeyYes[i,bi]);
  end;
  
end;                           { TSortEditDlg.Allowed }

procedure TSortEditDlg.FillupDialog;
var
  i,InitialIndex: integer;
  bi: boolean;
  F: array[0..255] of char;
  tmp: string;

procedure CheckIt(P: PCheckBox; Checked: boolean);
begin
  if Checked then P^.SetCheck(bf_checked)
  else P^.SetCheck(bf_Unchecked);
end;

begin
  with EditSortMode do
  begin
    { Check boxes }
    CheckIt(OnOffCBox,SortingOn or ForceOn);
    if ForceOn then EnableWindow(OnOffCBox^.HWindow,false);
    CheckIt(CollationCBox,MixedCollation);
    CheckIt(NameAscCBox[true],NameAsc[true]);
    CheckIt(NameAscCBox[false],NameAsc[false]);
    CheckIt(PattFirstCBox,PattFirst);
    CheckIt(PattFileCBox,UsePatternFile);

    { Combo boxes }
    InitialIndex:=0;
    case StringNameSort of
      StrSortOff:     InitialIndex:=0;
      StrSortAscend:  InitialIndex:=1;
      StrSortDescend: InitialIndex:=2;
    end;
    StringsCombo^.SetSelIndex(InitialIndex);

    InitialIndex:=0;
    for i:=1 to NCombinations do
      if SortTypeOrder=OStr[i] then InitialIndex:=i-1;
    OrderCombo^.SetSelIndex(InitialIndex);

    StrPCopy(F,SortPatternFile);
    SetWindowText(PattFileEBox^.HWindow,F);
    PFile:=SortPatternFile;

    for i:=1 to 3 do for bi:=false to true do
    begin
      tmp:='';
      if (SortKey[i,bi]<>'') then
      begin
        DecompTemplate(tmp,SortKey[i,bi]);
        EncapsulateTemplate(tmp);
      end;
      StrPCopy(F,tmp); SetWindowText(KeysCont[i,bi].EBox^.HWindow,F);
      CheckIt(KeysCont[i,bi].Asc,KeyAsc[i,bi]);
      CheckIt(KeysCont[i,bi].NullFirst,NullKeyFirst[i,bi] );
    end;
  end;
  Allowed;
end;                           { TSortEditDlg.FillupDialog }

procedure TSortEditDlg.SetupWindow;

procedure AddToCombo(P: PComboBox; id: integer; IsOrder: boolean);
var
  Nstr: integer;
  F: array[0..255] of char;
begin
  LoadString(Hinstance,id,F,255); P^.InsertString(F,-1);
  if IsOrder then
  begin
    NStr:=P^.GetCount;
    TranslateOrder(StrPas(F),Ostr[Nstr]);
  end;
end;

begin
  TBasicDialog.SetupWindow;
  SetWindowText(HWindow,Title);

  AddToCombo(StringsCombo,Str_StringsUnsorted,false);
  AddToCombo(StringsCombo,Str_StringsSortAsc,false);
  AddToCombo(StringsCombo,Str_StringsSortDesc,false);

  AddToCombo(OrderCombo,Str_OrdName,true);
  AddToCombo(OrderCombo,Str_OrdKeyName,true);
  AddToCombo(OrderCombo,Str_OrdKeyKeyName,true);
  AddToCombo(OrderCombo,Str_OrdKeyKeyKeyName,true);
  AddToCombo(OrderCombo,Str_OrdPattName,true);
  AddToCombo(OrderCombo,Str_OrdPattKeyName,true);
  AddToCombo(OrderCombo,Str_OrdKeyPattName,true);
  AddToCombo(OrderCombo,Str_OrdPattKeyKeyName,true);
  AddToCombo(OrderCombo,Str_OrdKeyPattKeyName,true);
  AddToCombo(OrderCombo,Str_OrdKeyKeyPattName,true);
  AddToCombo(OrderCombo,Str_OrdPattKeyKeyKeyName,true);
  AddToCombo(OrderCombo,Str_OrdKeyPattKeyKeyName,true);
  AddToCombo(OrderCombo,Str_OrdKeyKeyPattKeyName,true);
  AddToCombo(OrderCombo,Str_OrdKeyKeyKeyPattName,true);

  FillupDialog;
end;                      { TSortEditDlg.SetupWindow }

procedure TSortEditDlg.OrderChange(var Msg: TMessage);
begin
  if Msg.LParamHi = cbn_SelChange then Allowed;
  DefWndProc(Msg);
end;                            { TWhichFieldsDlg.CBoxMessage }

procedure TSortEditDlg.OnOffChange(var Msg: TMessage);
begin Allowed; end;

procedure TSortEditDlg.PfileChange(var Msg: TMessage);
begin Allowed; end;

procedure TSortEditDlg.LoadSMode(var Msg: TMessage);
begin
  if Application^.ExecDialog(New(PLoadWhatDlg,init(
       @Self,@EditSortMode,Pattern)))=id_ok then
    FillUpDialog;
end;

procedure TSortEditDlg.SaveSMode(var Msg: TMessage);
begin
  Application^.ExecDialog(New(PSaveWhatDlg,init(
       @Self,@EditSortMode,Pattern)));
end;

procedure TSortEditDlg.ExpPatt(var Msg: TMessage);
var
  ChangedPatt: boolean;
begin
  PatternGet(@Self,Pattern,ChangedPatt);
end;

procedure TSortEditDlg.ok(var Msg: TMessage);
var
  F: array[0..255] of char;
  i: integer;
  bi: boolean;
begin
  if CanClose then
  begin
    with SModeToChange^ do
    begin
      SortingOn:=OnOffCBox^.GetCheck=bf_Checked;
      MixedCollation:=CollationCBox^.getCheck=bf_Checked;
      NameAsc[true]:=NameAscCBox[true]^.GetCheck=bf_Checked;
      NameAsc[false]:=NameAscCBox[false]^.GetCheck=bf_Checked;
      PattFirst:=PattFirstCBox^.GetCheck=bf_Checked;
      UsePatternFile:=PattFileCBox^.GetCheck=bf_Checked;

      if IsWindowEnabled(PattFileEBox^.HWindow) then
      begin
        GetWindowText(PattFileEBox^.HWindow,F,255);
        SortPatternFile:=StrPas(F);
      end else SortPatternFile:=PFile;

      SortTypeOrder:=OStr[OrderCombo^.GetSelIndex+1];
      case StringsCombo^.GetSelIndex of
        0: StringNameSort:=StrSortOff;
        1: StringNameSort:=StrSortAscend;
        2: StringNameSort:=StrSortDescend;
      end;

      for i:=1 to 3 do for bi:=false to true do
      with KeysCont[i,bi] do
      begin
        GetWindowText(EBox^.Hwindow,F,255);
        SortKey[i,bi]:=StrPas(F); PrepareTemplate(SortKey[i,bi]);
        KeyAsc[i,bi]:=Asc^.GetCheck=bf_Checked;
        NullKeyFirst[i,bi]:=NullFirst^.GetCheck=bf_Checked;
      end;
    end;
    EndDlg(id_ok);
  end;
end;


{--------------}

procedure SortOptions(WhichSort: byte; var Amovedbib: boolean);
var
  SortPattern: PatRecPtr;
  EditSortMode: ConfigSortPtr;
  F: array[0..20] of char;
  ForceOn: boolean;
begin
  New(SortPattern); ForceOn:=false;
  MovedBib:=false;
  if WhichSort=CSortMode_Default then                { Default Sort Mode }
  begin
    EditSortMode:=ConfigSortMode;
    RecallBufferStack(SortPattern^,SortPattPosDef);
    LoadString(Hinstance,Str_DefModeTitle,F,20);
    ForceOn:=true;
  end else if WhichSort=CSortMode_Current then       { Current Sort Mode }
  begin
    EditSortMode:=CurrentSortMode;
    RecallBufferStack(SortPattern^,SortPattPosCur);
    LoadString(Hinstance,Str_CurModeTitle,F,20);
  end else if WhichSort=CSortMode_Export then        { Export Sort Mode }
  begin
    EditSortMode:=ExportSortMode;
    RecallBufferStack(SortPattern^,SortPattPosExp);
    LoadString(Hinstance,Str_ExpModeTitle,F,20);
  end;

  if Application^.ExecDialog(New(PSortEditDlg,init(MainW,
                  F,EditSortMode,SortPattern,ForceOn)))=id_ok then
  begin
    SortWorkOut(EditSortMode^,SortPattern);
    if WhichSort=CSortMode_Default then
    begin
      PushBufferStack(SortPattern^,sizeof(PatRec),SortPattModeDef,SortPattPosDef);
      OptionsModified.Sort:=true;
    end else if WhichSort=CSortMode_Current then
      PushBufferStack(SortPattern^,sizeof(PatRec),SortPattModeCur,SortPattPosCur)
    else if WhichSort=CSortMode_Export then
      PushBufferStack(SortPattern^,sizeof(PatRec),SortPattModeExp,SortPattPosExp);
  end;

  AMovedBib:=MovedBib;

  Dispose(SortPattern);
end;

end.
