/* c4plib.c - C4P Runtime Routines
   Time-stamp: "97/01/03 18:04:01 mik"

   Copyright (C) 1991, 92, 93, 94, 95, 96, 97
	Christian Schenk  <cschenk@berlin.snafu.de>

   This file is part of MiKTeX.

   MiKTeX is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
   
   MiKTeX is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with MiKTeX; if not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#include "c4plib.h"

#include "miktex.h"

#if defined (_WIN32)
#if defined (MIKTEX_DLL)
#define _MIKTEX_1 __declspec (dllexport)
#endif /* IN_MIKTEX_DLL */
#define _MIKTEX_2 __stdcall
#endif /*  _WIN32 */

#if ! defined (_MIKTEX_1)
#define _MIKTEX_1
#endif /* ! _MIKTEX_1 */

#if ! defined (_MIKTEX_2)
#define _MIKTEX_2
#endif /* ! _MIKTEX_2 */

_MIKTEX_1 void _MIKTEX_2
_c4p_skip_to_eoln (text *textfile)

{
  while (! feof (textfile->_c4p_fp) && _c4p_get_char (textfile) != '\n')
    ;
}

_MIKTEX_1 char _MIKTEX_2
_c4p_get_char (text *textfile)

{
  char temp_c = textfile->_c4p_buf;
  textfile->_c4p_buf = (char) getc (textfile->_c4p_fp);
  return (temp_c);
}

_MIKTEX_1 integer _MIKTEX_2
_c4p_get_int (text *textfile)

{
  char c = _c4p_get_char (textfile);
  int sign = (c == '-' ? -1 : 1);
  integer result = 0;

  if (c == '+' || c == '-')
    c = _c4p_get_char (textfile);

  while (isdigit (c))
    {
      result *= 10;
      result += (c - '0');
      c = _c4p_get_char (textfile);
    }

  return (result * sign);
}

_MIKTEX_1 real _MIKTEX_2
_c4p_get_real (text *textfile)

{
  fputs ("\n_c4p_get_real: not yet implemented\n", stderr);
  exit (EXIT_FAILURE);
  return (0.0);
}

#if 1
_MIKTEX_1 boolean _MIKTEX_2
_c4p_fopen (FILE **f_ptr_ptr,
	    void *buf,
	    size_t buf_size,
	    const char *file_name,
	    const char *mode,
	    int complain_p)

{
  if ((*f_ptr_ptr = open_file (file_name, mode)) == 0)
    {
      if (complain_p)
	{
	  perror (file_name);
	  exit (EXIT_FAILURE);
	}
      return (false);
    }
  else
    return (true);
}
#endif

_MIKTEX_1 void _MIKTEX_2
_c4p_fread_n (FILE *stream,
	      void *lastelem,
	      size_t elemsize,
	      void *buf,
	      size_t n)

{
  if (fread (buf, elemsize, n, stream) != n
      && ! ferror (stream)
      && feof (stream))
    return;
  if (ferror (stream))
    {
      perror ("");		/* fixme */
      exit (EXIT_FAILURE);
    }
  if (lastelem != buf)
    memcpy (lastelem,
	    ((unsigned char *) buf) + elemsize * (n - 1),
	    elemsize);
}

_MIKTEX_1 void _MIKTEX_2
_c4p_fread (FILE *stream,
	    void *elem,
	    size_t elemsize)

{
  _c4p_fread_n (stream, elem, elemsize, elem, 1);
}

_MIKTEX_1 void _MIKTEX_2
_c4p_fwrite (FILE *f,
	     const void *buf,
	     size_t buf_size)

{
  if (fwrite (buf, buf_size, 1, f) != 1 || ferror (f) != 0)
    {
      fprintf (stderr, "\n_c4p_fwrite: write error\n");
      exit (EXIT_FAILURE);
    }
}

_MIKTEX_1 void _MIKTEX_2
_c4p_reset (FILE *f,
	    void *buf,
	    size_t buf_size)

{
  rewind (f);
  _c4p_fread (f, buf, buf_size);
}

_MIKTEX_1 void _MIKTEX_2
_c4p_fseek (FILE *f,
	    void *buf,
	    size_t buf_size,
	    long offset,
	    int origin)

{
  fseek (f, offset, origin);
  _c4p_fread (f, buf, buf_size);
}

_MIKTEX_1 integer _MIKTEX_2
_c4p_round (double r)

{
  if (r > INT_MAX)
    return (INT_MAX);
  else if (r < INT_MIN)
    return (INT_MIN);
  else if (r >= 0.0)
    return (r + 0.5);
  else
    return (r - 0.5);
}
