/* Process this file with autoheader to produce config.h.in */
#ifndef CONFIG_H
#define CONFIG_H

/* Package and version. */
#define PACKAGE "mminstance"
#define VERSION "97"

/* Pathname separator character ('/' on Unix). */
#define PATHNAME_SEPARATOR '/'

/* Check for bad strtod (NeXTSTEP's swallows trailing spaces). */
#undef BROKEN_STRTOD

/* Define if you have the strerror function. */
#undef HAVE_STRERROR 

/* Define to 0 if you don't want mmafm to run mmpfb when it needs to get an
   intermediate master conversion program. */
#define MMAFM_RUN_MMPFB 1

/* Define to 1 since we have PermStrings and Strings. */
#define HAVE_PERMSTRING 1
#define HAVE_STRING 1

/* Define if <new> exists and works. */
#undef HAVE_NEW_HDR

/* Define if you have u_intXX_t types but not uintXX_t types. */
#undef HAVE_U_INT_TYPES

@TOP@
@BOTTOM@

#ifdef __cplusplus
extern "C" {
#endif

/* Prototype strerror if we don't have it. */
#ifndef HAVE_STRERROR
char *strerror(int errno);
#endif

/* Prototype good_strtod and good_strtol if we need them. */
#ifdef BROKEN_STRTOD
double good_strtod(const char *nptr, char **endptr);
#endif

#ifdef __cplusplus
}
/* Get rid of a possible inline macro under C++. */
# define inline inline
#endif
#endif
