import com.sun.javadoc.*;

/**
 * Ein Eintrag in der Vererbungstabelle.
 * Enthlt ein Element (Methode oder Field) und die Information, von wem dieses geerbt wurde.
 * @author Jolle
 * @version 1.0
 * @since 13.05.2008
 */

public class InhEntry implements Comparable<InhEntry> {

	/**
	 * Tex-Befehl fr eine Zeile der Tabelle
	 * @author Jolle
	 * @since version 1.0 vom 13.05.2008
	 */
	private static final String JDInhEntry = " \\jdInhEntry";
	
	/**
	 * das Element des Eintrages
	 * @author Jolle
	 * @since version 1.0 vom 13.05.2008
	 */
	private Doc eintrag = null;
	
	/**
	 * Die Klasse, von der das Element geerbt wurde
	 * @author Jolle
	 * @since version 1.0 vom 13.05.2008
	 */
	private ClassDoc parent = null;
	
	/**
	 * Erstellt das Objekt aus dem Element und dem Vererber
	 * @param d das Element
	 * @param parent der Vererber	 
	 * @author Jolle
	 * @since version 1.0 vom 13.05.2008
	 */
	public InhEntry (Doc d, ClassDoc parent){
		eintrag = d;
		this.parent = parent;
	}
	
	/**
	 * Baut aus dem Befehl und den 2 Attributen die formatierte Tex-Zeile
	 * @author Jolle
	 * @since version 1.0 vom 13.05.2008 
	 * @return Eine Zeichenkette, in der die TeX-Zeile komplett enthalten ist (mit formatierten Sonderzeichen)
	 */
	public String getTexTableEntry(){
		StringBuffer texformat = new StringBuffer(JDInhEntry);
		texformat.append("{");
		
		if( eintrag.isMethod() ) texformat.append( ClassWriter.getLinks(((MethodDoc)eintrag).returnType()) + " " );
		if( eintrag.isField() )  texformat.append( ClassWriter.getLinks(((FieldDoc)eintrag).type()) +" ");
		
		texformat.append( TexPrintStream.umwandlung(eintrag.name()));
		
		if( eintrag.isMethod()){
			texformat.append("( " );
			MethodDoc mEintrag =(MethodDoc)eintrag; 
			for( int i = 0; i < mEintrag.parameters().length; i++){
				texformat.append( ClassWriter.getLinks( mEintrag.parameters()[i].type() ));
				if( i < mEintrag.parameters().length - 1){
					texformat.append( ", " );
				}
			}
			texformat.append( " )" );
		}
		
		texformat.append( "}");
			
		texformat.append( "{"+TexPrintStream.umwandlung(parent.name()) +"}");
				
		return texformat.toString();
	}

	/**
	 * berschreibt die compartTo-Methode des Interface Comparable
	 * @author Jolle
	 * @since Version 1.0 vom 13.05.2008
	 * @param name Das Objekt, mit dem verglichen werden soll
	 * @return 0, bei Gleichheit; 1, wenn das eigene Objekt ein Feld und der andere eine Methode ist oder bei Gleichheit, der eigene Vererber hher steht, oder bei Gleichheit werden die Namen alphanumerisch verglichen
	 * ansonsten -1
	 * 
	 * 
	 */
	public int compareTo(InhEntry name) {
		int wahl = compareType(name.eintrag); 
		if( wahl == 0){
			wahl = compareInheritation(name.parent);
			if( wahl ==0 ){
				wahl = eintrag.name().compareTo( name.eintrag.name() );
			}
		}
		return wahl;
	}
	
	/**
	 * Vergleicht zwei Vererber auf Hierarchie
	 * @author Jolle
	 * @since Version 1.0 vom 13.05.2008
	 * @param cd Der andere Vererber
	 * @return 0, wenn gleich, 1 wenn der eigene hher, ansonsten -1
	 */
	private int compareInheritation(ClassDoc cd){
		if( !cd.equals(parent) ){
			return  parent.subclassOf( cd ) ? -1: 1;
		}
		return 0;
	}
	
	/**
	 * Vergleicht 2 Elemente auf Typ
	 * @author Jolle
	 * @since Version 1.0 vom 13.05.2008
	 * @param externDoc das andere Element
	 * @return 0, wenn beide Method oder beide Field; 1 wenn der eigene hher, -1 sonst
	 */
	private int compareType(Doc externDoc){
		if( externDoc.isField() &&  eintrag.isField() || externDoc.isMethod() && eintrag.isMethod() ) return 0;
		if( externDoc.isField() ) return 1;
		return -1;
		
	}
	
}
