.\" $Id: tit2cit.man,v 1.1 1991/09/29 21:44:08 ygz Exp $
.TH TIT2CIT 1 "Release 5" "X Version 11"
.SH NAME
tit2cit, cit2tit \- Input method compiler for cxterm
.SH SYNOPSIS
.B tit2cit
[file]
.br
.B cit2tit
[file]
.SH DESCRIPTION
Input methods for \fIcxterm\fR are stored as external files
and are loaded by cxterm in runtime on demand.
Input method files have two formats, text format and compiled format.
.PP
Text format has suffix .tit (tit for Text Input Table) in the file name,
and is intended to be read and written by human; compiled format has
suffix .cit (cit for Compiled Input Table) in the file name,
and is loaded by cxterm. Utilities \fItit2cit\fR and \fIcit2tit\fR
convert input method files between these 2 formats.
.PP
If the \fIfile\fR argument is given to the \fItit2cit\fR or \fIcit2tit\fR,
the input is taken from the file, otherwise the input is from stdin.
Both programs write the input table to stdout.
.SH TIT FILE FORMAT
A .tit file is a line-oriented text (English and Chinese) file.
The whole file contains of two parts, the definition part followed by
the dictionary part.
All lines begin with leading '#' are ignored. Then each line consists of
one keyword and followed by zero or more definitions. In the following
formal specification,
.LP
\fI<key>\fR means any character with ASCII code from 0 to 127, if not
printable, the character should be in \\ooo format, where ooo is
the ASCII code in 3 octal-decimal digit form;
.LP
\fI<keys>\fR
means a continuous string of \fI<key>\fR;
.LP
\fI<string>\fR means any string of ASCII characters (unprintable in \ooo)
and Chinese characters;
.LP
\fI<Cstring>\fR means string of Chinese characters;
.SH DEFINITION PART
.PP
Each line is consisted of a keyword and followed by optional
definitions:
.TP 8
.B ENCODE: \fI<string>\fP
Define the encoding of the input method.
Valid values of \fI<string>\fP are GB or BIG5; the default is GB.
.TP 8
.B MULTICHOICE: \fI<string>\fP
Whether the dictionary contains many-to-one lookups.
Valid values of \fI<string>\fP are YES or NO; the default is YES.
.TP 8
.B PROMPT: \fI<string>\fP
Define prompt string to be shown in the cxterm input area.
Valid values of \fI<string>\fP are any Chinese and English mixed string
shorter or equal to 24 bytes. There is no default value for this prompt.
.TP 8
.B VALIDINPUTKEY: \fI<keys>\fP
Specify all the valid input keys that can be used in the input string of a
Chinese character. There is no default valid input keys.
.TP 8
.B SELECTKEY: \fI<keys> <keys> ...\fP
Specify the keys to be used in Chinese input selection. They must be
in same order of the choices shown on the input area.
The number of sets of keys \fI<keys>\fP can not exceed 16.
The default value is
.nf
	SELECTKEY: 1\\040 2 3 4 5 6 7 8 9 0
.fi
.TP 8
.B BACKSPACE: \fI<keys>\fP
Specify the keys to be used for backspace in Chinese input area. 
The default value is "\\010\\177" (BackSpace, Delete).
.TP 8
.B DELETEALL: \fI<keys>\fP
Specify the keys to be used to clear all input in Chinese input area. 
The default value is "\\015\\025" (Return, CTRL-U).
.TP 8
.B MOVERIGHT: \fI<keys>\fP
Specify the keys to be used to show more choices at the right.
The default value is ".>"
.TP 8
.B MOVELEFT: \fI<keys>\fP
Specify the keys to be used to show more choices at the left.
The default value is ".>"
.TP 8
.B REPEATKEY: \fI<keys>\fP
Specify the keys to be used to repeat the input of last selection.
The default value is "\\020\\022" (CTRL-P, CTRL-R).
.TP 8
.B KEYPROMPT(\fI<key>\fP): \fI<string>\fP
Define corresponding \fI<string>\fP to be displayed in input area when
the key \fI<key>\fP is input. Maximum length of each \fI<string>\fP is 4 bytes.
Default value of \fI<string>\fP is the \fI<key>\fP itself.
.TP 8
.B COMMENT \fIanything\fP
Any thing follows \fBCOMMENT\fP will be saved in the end of .cit file.
.PP
The last line of definition part must be \fBBEGINDICTIONARY\fP.
.SH DICTIONARY PART
.PP
Each lines is in the form of:
.nf
	\fI<keys>\fP	\fI<Cstring>\fP
.fi
Input characters in exactly the same sequences as \fI<keys>\fP will
cause \fI<Cstring>\fP to be displayed for selection.
.SH "SEE ALSO"
cxterm(1), X(1)
.SH COPYRIGHT
Copyright 1991, Yongguang Zhang.
.br
Unlimited redistribution for any purpose. Absolutely no warranties. 
.SH AUTHOR
Yongguang Zhang, Dept. of Computer Sciences, Purdue University.
Email: ygz@cs.purdue.edu.
Please report any bugs, comments, and sugguestions to
c-xterm@cs.purdue.edu.
