.TH CXTERM 1 "X11R4 Rev 2"
.SH NAME
cxterm \- Chinese terminal emulator for X
.SH SYNOPSIS
.B cxterm
[-\fItoolkitoption\fP ...] [-option ...]
.SH DESCRIPTION
The \fIcxterm\fP program is a Chinese terminal emulator
for the X Window System. It provides DEC VT102 compatible terminals
with a capability of interfacing Chinese language input/output.
It is fully compatible with X11R4 \fIxterm\fP.
Although the Tektronix 4014 window of xterm remains in cxterm,
you can only use Chinese in VT102 window (the default mode).
It requires at least two X11 fonts from the X server, one 16-bit Chinese
font and one normal 8-bit terminal character font, to display Chinese
characters as well as normal 7-bit ASCII.
.PP
In \fIcxterm\fP, one Chinese character is represented by 2 bytes, and one
ASCII is represented by 1 byte. There are two kinds of Chinese encoding
schemes, one requires that the highest-bits (MSB) be set to 1 in both bytes
of a Chinese character, the other only requires that the MSB in the first
byte of a Chinese character be set to 1. Both schemes requires that the
MSB in each ASCII code be unset. The \fIcxterm\fP program recognizes
both GB and BIG5 encoding, which are examples of the above two scheme
respectively, however, two encoding cannot co-exist in the same time.
.PP
Please refer manual page \fIxterm(1)\fP for usage of \fIxterm\fP.
.SH CHINESE INPUT
The bottom 2 lines of the \fIcxterm\fP screen are dedicated to Chinese input.
To input a Chinese character, a valid Chinese input string is typed into
the input area first, then it is converted to the Chinese character
according to some input mapping method. In case the same input string can
be translated into more than one Chinese characters, a selection list of
valid Chinese characters are display in the input area,
then a selection key will bring the character to the screen.
.PP
Chinese input area in \fIcxterm\fP is not a separate window.
Whether the cursor is in the input area or not makes no difference
to the keyboard input.
.PP
There are different input modes corresponding to different input methods.
Two modes are builtin: ASCII and IC. ASCII mode is not a Chinese mode;
there is no Chinese input capability in this mode (like \fIxterm\fP).
IC means Internal Coding. In IC mode every 4 hexadecimal digits are
translated into one Chinese character as the internal code in the adopted
encoding.
.PP
Most other input methods are stored as external files and are loaded
in runtime on demand. Such external input methods are user-accessible
and expandable. See \fItit2cit(1)\fP for how to add your own input
method. The name of the input mode is determined by the name of the
external file where the input method is stored.
.SH OPTIONS
The \fIcxterm\fP program accepts all the standard X Toolkit
command line options, X11R4 \fIxterm\fP command line options, as well as
the following:
.TP 8
.B \-fh \fIchineseFont\fP
This option specifies a Chinese font to be used when display Chinese text.
This font should be the same height and twice the width as the normal
ASCII font.
.TP 8
.B \-fhb \fIchineseFont\fP
This option specifies a Chinese font to be used when display bold Chinese text.
This font must be the same height and width as the normal Chinese font.
If only one of the normal or bold Chinese fonts is specified, it will be
used as the normal font and the bold font will be produced by overstriking
this font. The default is to do overstriking of the normal font.
.TP 8
.B \-hm \fImode\fP
This option specifies the name of the initial input mode when
\fIcxterm\fP starts up. The name of the mode is the name of the input method.
The default is "ASCII"; \fIcxterm\fP will start up in English mode.
.TP 8
.B \-hz \fIencoding\fP
This option specifies which encoding scheme, GB or BIG5, are to be used. 
The default is GB.
.TP 8
.B \-GB
This option indicates that \fIcxterm\fP should use GB encoding.
It is the same as option "\-hz GB".
.TP 8
.B \-BIG5
This option indicates that \fIcxterm\fP should use BIG5 encoding.
It is the same as option "\-hz BIG5".
.SH RESOURCES
The program understands all of the core X Toolkit resource names and classes,
all \fIxterm\fP resource names and classes, as well as the following
resources specified as part of the \fIvt100\fP widget (class \fIVT100\fP):
.\".in +1in
.TP 8
.B "hanziFont (\fPclass\fB HanziFont)"
Specifies the name of the Chinese font to use.
.TP 8
.B "hanziBoldFont (\fPclass\fB HanziFont)"
Specifies the name of the bold Chinese font to use instead of overstriking.
.TP 8
.B "hanziMode (\fPclass\fB HanziMode)"
Specifies the name of the initial mode instead of ASCII mode.
.\".in -1in
.sp
.SH ACTIONS
In addition to all the \fIxterm\fP \fIvt100\fP \fBtranslations\fP resources,
the following are also accepted by \fIcxterm\fP:
.TP 8
.B "switch-HZ-mode(\fImode\fP)"
This action dynamically switch the input mode to \fImode\fP. If \fImode\fP
is not a builtin input method and does not reside in memory, it is loaded
from external file first. The name of file must be "\fImode\fP.cit", and
it must be under current directory, home directory, or the directory
specified by environment HZINPUTDIR.
.PP
The defaults bindings in \fIcxterm\fP window are:
.sp
.in +4
.DS
.TA 2.5i
.ta 2.5i
.nf
 Shift <KeyPress> Prior:	scroll-back(1,halfpage) \\n\\
  Shift <KeyPress> Next:	scroll-forw(1,halfpage) \\n\\
Shift <KeyPress> Select:	select-cursor-start() \\
	select-cursor-end(PRIMARY, CUT_BUFFER0) \\n\\
Shift <KeyPress> Insert:	insert-selection(PRIMARY, CUT_BUFFER0) \\n\\
          <KeyPress> F1:	switch-HZ-mode(ASCII) \\n\\
          <KeyPress> F2:	switch-HZ-mode(IC) \\n\\
        ~Meta<KeyPress>:	insert-seven-bit() \\n\\
         Meta<KeyPress>:	insert-eight-bit() \\n\\
   Ctrl ~Meta<Btn1Down>:	popup-menu(mainMenu) \\n\\
       ~Meta <Btn1Down>:	select-start() \\n\\
     ~Meta <Btn1Motion>:	select-extend() \\n\\
  Ctrl ~Meta <Btn2Down>:	popup-menu(vtMenu) \\n\\
 ~Ctrl ~Meta <Btn2Down>:	ignore() \\n\\
   ~Ctrl ~Meta <Btn2Up>:	insert-selection(PRIMARY, CUT_BUFFER0) \\n\\
  Ctrl ~Meta <Btn3Down>:	popup-menu(fontMenu) \\n\\
 ~Ctrl ~Meta <Btn3Down>:	start-extend() \\n\\
     ~Meta <Btn3Motion>:	select-extend() \\n\\
    ~Ctrl ~Meta <BtnUp>:	select-end(PRIMARY, CUT_BUFFER0) \\n\\
              <BtnDown>:	bell(0)
.fi
.DE
.sp
.in -4
.PP
Below is a sample of how to use \fBswitch-HZ-mode()\fP action to add more
input methods, or redefine input mode switch keys:
.sp
.in +4
.DS
.TA 3.0i
.ta 3.0i
.nf
cxterm*VT100.Translations: #override \\
           <KeyPress> F1:	switch-HZ-mode(ASCII) \\n\\
           <KeyPress> F2:	switch-HZ-mode(IC) \\n\\
           <KeyPress> F3:	switch-HZ-mode(TONEPY) \\n\\
           <KeyPress> F4:	switch-HZ-mode(SW) \\n\\
           <KeyPress> F5:	switch-HZ-mode(PY) \\n\\
           <KeyPress> F6:	switch-HZ-mode(ASCII) \\n\\
           <KeyPress> F7:	switch-HZ-mode(QJ) \\n\\
           <KeyPress> F8:	switch-HZ-mode(QW) \\n\\
 ~Meta <KeyPress> Escape:	insert() switch-HZ-mode(ASCII)
.fi
.DE
.sp
.in -4
In this example, pressing <F2> will change the input method into IC;
<F5> will switch to PY method (external, PY.cit should be in good place),
and so on. The last line may be a good setting for those who use celvis.
Pressing <ESC> will pass ESC to celvis to end the insertion mode, and
cause \fIcxterm\fP to switch back to ASCII (so that you can continue to enter
celvis command in ASCII mode).
.SH "ENVIRONMENT VARIABLE"
.IP HZINPUTDIR.
\fICxterm\fP will try to locate the file containing the extern input method,
under the current directory where \fIcxterm\fP is started,
or the home directory of the user,
or the directory specified by environment HZINPUTDIR,
in that order.
.SH EXAMPLES
.LP
Start a \fIcxterm\fP in reserve video with scroll bar:
(It is in GB encoding and uses X11 fonts cclib16st and 8x18 by default).
.RS
.sp .5
.nf
.B cxterm -rv -sb
.fi
.RE
.LP
Start a \fIcxterm\fP in BIG5 encoding (where hku-ch16 is a BIG5
encoding X11 font, and 8x18big5 is a matching ASCII font):
.RS
.sp .5
.nf
.B cxterm -fh hku-ch16 -fn 8x18big5 -BIG5
.fi
.RE
.SH "SEE ALSO"
.BI X (1), 
.BI xterm (1),
.BI cxresize (1),
.BI tit2cit (1)
.SH COPYRIGHT
\fICxterm\fP is distributed under the same condition as GNU software.
Please also see \fIX(1)\fP for a full statement of rights and permissions
for X11R4.
.SH AUTHORS
\fIXterm\fP is part of the X window system V11R4 developed in MIT.
.PP
Man-Chi Pong <csmcpong@usthk.bitnet> rewrote much of the \fIxterm\fP
code to produce the first version of \fIcxterm\fP (11.4.1).
It was released to public in November 1990.
.PP
Yongguang Zhang <ygz@cs.purdue.edu> improved \fIcxterm 11.4.1\fP to
developed the 2nd revision (\fIcxterm 11.4.2\fP) around Jan, 1991.
.PP
\fICxterm\fP is somewhat inspired by the old \fIccxterm\fP developed
jointly by the Institute of Software, Academia Sinica and
the Inst of Systems Engineering, Ministry of Electronic Industry,
Beijing, China, from 1987 to 1989.

