/*
 *   	List of parameters for dviout
 */
extern BOOL f_long_name;
extern BOOL f_font_c;
extern BOOL f_pause;
extern BOOL f_top_margin;
extern BOOL f_resize;
extern BOOL f_button;
extern BOOL f_spcolor;
extern BOOL f_gsame;
extern BOOL f_Wshow;
extern BOOL f_ktbase;
extern BOOL f_kglue;
extern BOOL f_JFM;
extern BOOL f_ondemand;
extern int k_scale;
extern int k_base;
extern int f_renew;
extern int f_search;
extern int f_GS;
extern BOOL f_gbox;
extern int f_sub_blank;
extern int f_rpcolor;
extern int max_message;
extern int org_bb_size;
extern int g_fMultiDviout;
extern int bright;
extern int edge_space;
extern uint slow_fact;
extern char *goth;
extern char *sub_font;
extern char *k_dbl;
extern char *f_page_scroll;
extern char *f_out;
extern char *prt_initialize;
extern const char *const pk_env_name;
extern char *font_root;
extern char *root_search_path;
extern char *pk_search_path;
extern char *pkd_search_path;
extern char *knj_search_path;
extern char *fli_search_path;
extern char *tfm_search_path;
extern char *subfont_path;
extern char *browser;
extern char *key_macro;
extern BOOL use_lateral_kanji;
extern BOOL draw_baseline;
extern BOOL draw_boxpic;
extern char *exec_dviprt;
extern char *s_font;
extern char *spi;
extern char *isp;
extern char *texhelp;
#ifdef WIN32G
extern char *exec_src_sp;
extern char *exec_gsrc_sp;
#endif

#ifdef	VIRTUALFONT
extern BOOL f_use_virtualfont;
#endif

#ifdef	WIN32
#define	WINDVIOUT
#define	WIN_STRING	STRING
extern char *g_szLogFileName;
void DefineKeyTable(uchar *);
void DefineScale(uchar *);
#else
#define	WIN_STRING	HIDDEN_STRING
#endif
#ifdef TTFONT
void DefineFTT(uchar *);
#endif

void set_mode(uchar *);
void key_in(uchar *);

#ifdef VFD
extern BOOL tatevfd;
#endif

#ifdef STR_SEARCH
extern uint f_s_color;
#endif

#ifdef	HYPERTEX
extern uint f_h_color;
extern int max_h_box;
extern int max_h_name;
extern int max_hyper_str;
extern char *ToEdit;
#endif

enum {
	DEF_0,
	DEF_gsx,
	DEF_G,
	DEF_y,
	DEF_BMP,
	DEF_scale,
	OLD_y,
	OLD_JC,
	OLD_key,
	OLD_scale,
	OLD_eq,
	OLD_mode,
	OLD_ftt
};

char *option_str[] =
{
	"^$",
#ifdef	UNIX
	"gs",
#else
	"gswin32c.exe",
#endif
	"goth;jisg",
	"A4P",
	"4:4:800",
	"4:4:800:2:2:800:6:6:800:1:1:800",
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};

ARG_TABLE option[] =
{

#ifdef	JAPANESE
	{"mag", INTEGER, (void *)&opt_mag,
	 "mag step(0-9), mag(500-)", INIT_METRIC|INIT_FONT},
	{"half", BOOLTYPE, (void *)&mag_half,
	 "magstep half)", INIT_METRIC|INIT_FONT},
	{"br", LONGINT, (void *)&(raster_buf_pointer->size),
	 "WJtHg     obt@TCY(byteP)", 
	 INIT_PIXEL|INIT_R_BUF|INIT_FONT},
	{"bf", LONGINT, (void *)&(pk_buf_pointer->size),
	 "tHgt@C obt@TCY(byteP)",
	 INIT_PIXEL|INIT_F_BUF|INIT_FONT},
	{"bb", LONGINT, (void *)&org_bb_size, /* (bitmap_buf_pointer->size), */
	 "WJrbg}bv obt@TCY(byteP)",
	 INIT_PIXEL|INIT_B_BUF},
#ifdef	WIN32
	{"multi", INTEGER, (void*)&g_fMultiDviout,
	"ődviouts", 0,
	2, 1, 9},
	{"renew", BOOLTYPE, (void*)&f_renew,
	"previewXV", 0,
	TRUE, 0, 0},
	{"button", BOOLTYPE, (void*)&f_button,
	"ʂTool Botton", INIT_BUTTON,
	FALSE, 0, 0},
#endif
#ifndef	WINDVIOUT
	{"f", INTEGER, (void *)&test_flg,
	 "\\(0-3)", 0},
#endif
	{"wait", 
#ifdef	WINDVIOUT
	HIDDEN_INTEGER
#else
	INTEGER
#endif
	, (void *)&f_wait,
	 "G[[0:~ 1:L[͂҂(ftHg) 2-3:]", 0},
	{"dpi", INTEGER, (void *)&(dviout_dimension.dpi),
	 "dpiݒ", INIT_METRIC|INIT_FONT},
	{"dpiv", INTEGER, (void *)&(dviout_dimension.DPI),
	 "dpi(c)", INIT_METRIC|INIT_FONT|INIT_VDPI},
	{"e", INTEGER, (void *)&(enlarge),
	 "g嗦(1000{)", INIT_METRIC|INIT_FONT},
#ifndef	WINDVIOUT
	{"page", BOOLTYPE, (void *)&dvifile_page,
	 "ItZbgy[Ww", 0},
#endif
#ifdef	WIN32G
	{"t", INTEGER, (void *)&f_scr_skip,
	 "XN[EXs[h(1,2,...)", 0},
#endif
#if	!defined(WINDVIOUT)||defined(RAWOUT)
	{"nf", 
# ifdef	RAWOUT
	HIDDEN_STRING,
# else
	STRING, 
# endif
	(void *)&ff_flg_str,
	 "y[WR[hsgp(܂Ƃ 2)"
# ifdef	LBP
	 "\n\tLBPł́A܂Ƃ̉Ey[W̊Jnʒu"
	,INIT_PRINTER},
# endif
	{"o",
# ifdef	RAWOUT
	HIDEEN_STRING,
# else
	STRING,
# endif
	 (void *)&f_page_scroll,
	 "o̓y[W(r:reverse, e:even, o:odd)", 0},
#endif
	{"V", BOOLTYPE, 
#ifdef	WINDVIOUT
	(void *)&f_rotate,
#else
	(void *)&(dviout_dimension.print_direction),
#endif
	 "90x]", INIT_METRIC},
#if	!defined(WINDVIOUT)||defined(RAWOUT)
	{"T", 
# ifdef	RAWOUT
	HIDDEN_BOOLEAN,
# else
	BOOLTYPE, 
# endif
	(void *)&f_top_margin,
	 "P[p󂫏C", 0},
#endif
#ifndef NOTPIC
	{"tpic", INTEGER, (void *)&f_tpic_turn_on,
	 "tpic special[0:ignore 1:Bezier"
# ifndef TPIC_NSPL
	 " 2:spline(ftHg)"
# endif
	 "]", 0},
#endif
#ifndef NOPS
	{"GS", INTEGER, (void *)&f_GS,
	"Ghostscript[0:Off 1:On(default) 2:verbose 3:PBM 4:exact PBM 5:gssub]"},
# ifdef	GIF
	{"GIF", INTEGER, (void *)&f_GIF,
	"0:pbm 1:gifmono, 2:bmpmono, 3:bmp16, 4:bmp256, 5:bmp16m", 0}.
# endif
	{"gsx", STRING, (void *)&gs_exe,
#ifdef UNIX
	"Ghostscript(ftHg gs)", 0},
#else
	"Ghostscript(ftHg gswin.exe)", 0},
#endif
	{"gdat", STRING, (void *)&pbm_path,
	"pbm/gift@C̃fBNg", 0},
	{"gbox", BOOLTYPE, (void *)&f_gbox,
	"荞݉摜̘g\", 0},
	{"gow", BOOLTYPE, (void*)&f_gow;
	"摜㏑", 0},
	{"gclip", BOOLTYPE, (void*)&f_gclip,
	"摜Nbv", 0},
	{"gfit", BOOLTYPE, (void *)&f_gsame,
	"vr[pcolor BMP", 0},
	{"gsize", BOOLTYPE, (void *)&f_gsize,
	"荞݉摜̃TCY:mag", 0},
#ifdef	WIN32
	{"color", BOOLTYPE, (void *)&f_spcolor,
	 "color special", 0},
	{"cmode", INTEGER, (void *)&f_rpcolor,
	 "color mode[0:auto(p2) 1:merge 2:replace(def) 3:replace(bak) 4:patch 5:patch2 6:auto(rep)]", 0},
	{"spi", STRING, (void *)&spi,
	 "Susie plug_in ̃fBNg", 0},
#endif
#endif
#ifdef	STR_SEARCH
	{"search", INTEGER, (void *)&f_s_color,
	"T[`ꂽ̐F(default: 0x00c0)", 0},
	{"sFont", STRING, (void *)&s_font,
	"T[`ŖtHg", 0},
	{"sdpi", INTEGER, (void *)&f_s_dpi,
	"gray scaleł̐Ft̍őldpi", 0},
#endif
#ifdef	HYPERTEX
	{"hyper", INTEGER, (void *)&f_h_color,
	"HyperTeX̎w蕶̐F(default: 0x0040))", 0},
	{"hyperoff", INTEGER, (void *)&f_hyper,
	"HyperTeX@\OFF", 0},
	{"href", INTEGER, (void *)&max_h_box,
	"URL", INIT_HYPER},
	{"hname", INTEGER, (void *)&max_h_name,
	"href name", INIT_HYPER},
	{"hbuf", INTEGER,(void *)&max_hyper_str,
	"HyperTeX buffer size", INIT_HYPER},
	{"Browser", STRING, (void *)&browser,
	"non-default Browser", 0},
#endif
	{"L", INTEGER, (void *)&f_long_name,
	 "tHg[0:8 1:Jbg 2:]", INIT_FONT},
	{"c", BOOLTYPE, (void *)&f_font_c,
	 "tHg̐`FbN", 0},
#ifdef	WIN32
	{"Fkeep", BOOLTYPE, (void *)&f_fkeep,
	 "tHg̃pX̕ۑ", 0},
#endif
	{"F", STRING, (void *)&sub_font,
	 "փtHgw", INIT_FONT},
	{"FB", INTEGER, (void *)&f_sub_blank,
	 "󔒑փtHg", INIT_FONT},
	{"A", INTEGER, (void *)&f_search,
	 "tHgT[`͈͊g", INIT_FONT},
	{"K", STRING, (void *)&k_dbl,
	 "{pw", INIT_FONT},
	{"G", STRING, (void *)&goth,
	 "SVbNw", INIT_FONT},
	{"S", INTEGER, (void *)&k_scale,
	 "XP[(1000{) Wl 952", INIT_FONT},
	{"g", BOOLTYPE, (void *)&use_lateral_kanji,
	 "ptHggp(pTeXc[h)", INIT_FONT},
	{"JC", PROCEDURE, (void *)set_trans_jis,
	 "JISR[hϊ", INIT_FONT},
	{"varf", BOOLTYPE, (void *)&f_resize,
	 "tHgXP[uɂ", INIT_FONT},
	{"base", BOOLTYPE, (void *)&draw_baseline,
	 "x[XC", 0},
	{"box", BOOLTYPE, (void *)&draw_boxpic,
	 "̑ɔőg", 0},
#ifndef NO_GENFONT
	{"gen", STRING, (void *)&genfont_tmpl,
	 "stHg̎", 0},
#endif
#ifndef	NOVFONT
	{"vfn", STRING, (void *)&vfont_name,
	 "̋y/aTrueTypetHg", 
	 INIT_ENDCFG|INIT_FONT|INIT_VFONT},
# ifdef TTFONT
	{"ttf", INTEGER, (void *)&f_use_ttf,
	 "TrueTypetHg[0:Off(default) <dot>:Draw sw]",
	 INIT_FONT},
# endif
# ifdef	USE_WINFONT
	{"ftt", PROCEDURE, (void *)DefineFTT,
	 "tHg}bvt@C tfm->TrueType",
	 INIT_FONT},
# endif
#endif
#ifdef	VIRTUALFONT
	{"virtual", BOOLTYPE, (void *)&f_use_virtualfont,
	 "VirtualtHg", INIT_FONT},
#endif
	{"Fod", BOOLTYPE, (void *)&f_ondemand,
	 "tHgOn demand", INIT_FONT},
#ifndef NO_NTTRPL
	{"nttF", STRING, (void *)&ntt_subst_fonts,
	 "NTTjTeXł̔WatHg̑փtHgw",
	 INIT_FONT},
	{"ntt", BOOLTYPE, (void *)&ntt_subst,
	 "NTTjTeX̘atHgAXL[{TeXptHgőp",
	 INIT_FONT},
#endif
	{"J", INTEGER, (void *)&k_base,
	 "x[XC(1000{) Wl 0", INIT_FONT},
	{"Jbt", BOOLTYPE, (void *)&f_ktbase,
	 "TrueTypex[XC", INIT_FONT},
	{"Jgt", BOOLTYPE, (void *)&f_kglue,
	 "TrueTypeʒu", INIT_FONT},
	{"Jfm", BOOLTYPE, (void *)&f_JFM,
	 "̉jfmg", INIT_FONT},
	{"y", PROCEDURE, (void *)youshi_size,
	 "p̑I [A3|A4|A5|B4|B5|H(t)"
#ifdef LBP
	"|F<width>[:<height>]|T<number>"
#else
    "[l]"
#endif
#ifdef LIPS3
	 "\n\t LIPS3   :[p(pc)|l(p)[0()|1(荷)|2(i)|3(i)]]"
#endif
#ifdef ESCPAGE
"\n\t ESC/Page:[p(pc)|l(p)[1(W)|2(߼݋)[:<ݔԍ>]]]"
#endif
	"]"
	,INIT_METRIC},
#ifdef LBP
	{"lc", INTEGER, (void *)&f_copy,
	 "LBPł̃Rs[", 0},
#endif
#ifdef VFD
	{"RV", BOOLTYPE, (void *)&tatevfd,
	 "vfdtHg̉]", INIT_FONT},
#endif
#ifndef	NOTATEGAKI
	{"R", BOOLTYPE, (void *)&tategaki,
# ifdef	LBP
	 "LBP, "
# endif
	 "̋ỹtHg90x]", INIT_FONT},
#endif
	{"O",
#ifdef	WINDVIOUT
	HIDDEN_STRING
#else
	STRING
#endif
	, (void *)&f_out,
	 "o̓t@C(!!!͕Ŕԍ)", 0},		/* ? */
#ifndef	WINDVIOUT
	{"s", INTEGER, (void *)&slow_fact,
	 "x(0,...,10000)", 0},
#endif
#if	!defined(WINDVIOUT)||defined(RAWOUT)
	{"Z", 
# ifdef	RAWOUT
	HIDDEN_BOOLEAN,
# else
	BOOLTYPE, 
# endif
	(void *)&f_pause,
	 "PŖɈU~", 0},
	{"I", 
# ifdef RAWOUT
	HIDDEN_STRING,
# else
	STRING,
# endif
	(void *)&prt_initialize,
	 "v^R[hLqt@C\n", 0},
#endif

	/* by K.Yoshizawa  Dec. 26, 1992 */
	{"PW", LENGTH, (void*)&OPW,
	"p̉ [ftHg 210mm(A4)]", INIT_METRIC},
	{"PH", LENGTH, (void*)&OPH,
	"p̏c [ftHg 297" AsAbove},
#ifdef	WIN32
	{"area", BOOLTYPE, (void*)&f_area, "ftHg̈󎚕s\̕", 
		INIT_METRIC},
#endif
	{"TM", LENGTH, (void*)&TM, "p[̈󎚕s\̕", INIT_METRIC},
	{"BM", LENGTH, (void*)&BM, "p[̈󎚕s\̕", INIT_METRIC},
	{"LM", LENGTH, (void*)&LM, "p[̈󎚕s\̕", INIT_METRIC},
	{"RM", LENGTH, (void*)&RM, "pE[̈󎚕s\̕", INIT_METRIC},
	{"MW", LENGTH, (void*)&MW, "󎚉\̍ő剡", INIT_METRIC|INIT_MW},
	{"MH", LENGTH, (void*)&MH, "󎚉\̍őc", INIT_METRIC|INIT_MH},
	{"OX", LENGTH, (void*)&OX, "̈ړ", INIT_METRIC},
	{"OY", LENGTH, (void*)&OY, "c̈ړ", INIT_METRIC},

	/* by K.Yoshizawa  Dec. 27, 1992 */
	{"HC", BOOLTYPE, (void*)&HC, "Z^O", INIT_METRIC},
	{"VC", BOOLTYPE, (void*)&VC, "Z^O", INIT_METRIC},
	{"HS", LENGTH, (void*)&HS,  "Z^Öړ", INIT_METRIC},
	{"VS", LENGTH, (void*)&VS,  "Z^Öړ", INIT_METRIC},
	/* by K.Yoshizawa  Dec. 28, 1992 */
#ifndef	WINDVIOUT
	{"PF", INTEGER, (void*)&PF, "ʒu [1:[(ftHg) 2:]\n",
	INIT_METRIC},
#endif
#ifdef	WIN32
	{"key", PROCEDURE, (void *)DefineKeyTable, "L[e[u̒`", 0},
	{"log", STRING, (void *)&g_szLogFileName, "Ot@C", 0},
    {"Wshow", BOOLTYPE, (void*)&f_Wshow, "qvZXWindow\", 0},

#endif
	{"=", HIDDEN_PROCEDURE, (void *)set_config, "p[^t@Cw", 0},
#ifdef FAX
	{"FAX", 
# ifdef RAWOUT
	HIDDEN_STRING,
# else
	STRING, 
# endif
	(void *)&f_fax, "G3 FAX`", 0},
#endif
#ifdef	WIN32
	{"BMP", STRING, (void *)&f_bmp, "Windows BMP`[x[:y:[z]]]", INIT_BMP},
	{"scale", PROCEDURE, (void *)DefineScale, "Scale`[x:y:z:...]",
	0},
	{"bright", INTEGER, (void*)&bright, "邳", INIT_BRIGHT},
#endif
#ifdef	WINDVIOUT
	{"dviprt", STRING, (void *)&exec_dviprt, "dviprt", 0,
	0, 0, 0},
#else
	{"comp", INTEGER, (void *)&comp_type,
	 "f[^k[0: 1:PCL mode 1 2:PCL mode 2]", 0},
#endif
#if	!defined(WINDVIOUT)||defined(RAWOUT)
	{"p", 
# ifdef	RAWOUT
	HIDDEN_STRING,
# else
	STRING,
# endif
	(void *)&pt_prt_type,
	 "v^̎ e:ESC/P p:PC-PR n:NM o:other(default prtctl.cfg), 0"
#ifdef LBP
	 "\n\t"
# ifdef LIPS3
	 "l:LIPS3 "
# endif
# ifdef ESCPAGE
	 "m:ESC/Page "
# endif
	 "[v:̏c k:aO d:download_size r:real_size"
	 "\n\tm:minimal_count f:font_def D:dpi j:baseline s:size_adj E:edge"
	 "\n\tu:minimal_unit c:compress o:other"
#endif
	,INIT_METRIC},
#if	defined(J3100) || defined(DOSV) || defined(WIN32C) || defined(RAWOUT)
 	{"P", 
# ifdef	RAWOUT
	HIDDEN_STIRNG,
# else
	STRING,
# endif
	, (void *)&pr_port_str,
# if	defined(RAWOUT)||defined(WIN32C)
	 "v^̎w, 0 for default printer, 1`4 for LPT1:`LPT4:"},
# elif defined(GCC)
  	 "v^|[g̎w, 0 for BIOS, B1`B4 for LPT1:`LPT4:, IO port"},
# else
	 "v^|[g̎w, 0 for BIOS(default), [B]1`[B]4 for LPT1:`LPT4:", 0},
# endif
#endif
#endif
#if	defined(PC9801) && defined(DOSV)
	{"hard", INTEGER, (void *)&machine,
	 "@[0:PC9801 1:DOS/V"
# if defined(J3100)
	 " 2:J3100"
# endif
	 "]", 0},
#endif
	{"TEXROOT", WIN_STRING, (void *)&root_search_path,
	"pX̒u(^r)", INIT_FONT},
	{"TEXPK",  WIN_STRING, (void *)&pk_search_path, 
	"񊿎tHg̃X^[f[^Ɗjfmt@C", INIT_FONT},
	{"TEXPKD", WIN_STRING, (void *)&pkd_search_path, 
	"PKDt@CpX", INIT_FONT},
	{"TEXKNJ", WIN_STRING, (void *)&knj_search_path, 
	"rbg}bvf[^t@C", INIT_FONT},
#ifdef VFD
	{"TEXVFD", WIN_STRING, (void *)&vfd_search_path, 
	"̋y for NTTjTeX", INIT_FONT},
#endif
#ifdef FLI
	{"TEXFLI", WIN_STRING, (void *)&fli_search_path, 
	"FLI tHgpX", INIT_FONT},
#endif
#ifdef TTFONT
	{"TEXFONTS", WIN_STRING, (void *)&tfm_search_path, 
	"񊿎TrueTypetHgtfmt@C", INIT_FONT},
	{"TEXSUBF", STRING, (void *)&subfont_path, 
	"subfont̃pX", INIT_FONT},
#endif
#ifdef	WIN32
	{"mode", HIDDEN_PROCEDURE, (void *)set_mode, "", 0},
#endif
#ifdef	WINDVIOUT
	{"macro", STRING, (void *)&key_macro, "Key macro", 0},
#endif
	{"isp", STRING, (void*)&isp, "ignored specials", 0},

	{"file", PROCEDURE, (void *)set_config, "p[^t@Cw", 0},

	{"NULL", SKIP, NULL, "", 0},

#ifdef	WIN32G
	{"1", SKIP, NULL, "", 0},
#endif

#else
	{"mag", INTEGER, (void *)&opt_mag,
	 "mag step(0-9), mag(500-)", INIT_METRIC|INIT_FONT, 
	 -1, -1, 8000},

	{"half", BOOLTYPE, (void *)&mag_half,
	 "magstep half", INIT_METRIC|INIT_FONT,
	 FALSE, 0, 0},

	{"br", LONGINT, (void *)&(raster_buf_pointer->size),
	 "raster buffer size", INIT_PIXEL|INIT_R_BUF|INIT_FONT,
	 DEF_RASTER_SIZE, 0x8000, 0x1000000},		/* 32K byte - I6M byte  */

	{"bf", LONGINT, (void *)&(pk_buf_pointer->size),
	 "font   buffer size", INIT_PIXEL|INIT_F_BUF|INIT_FONT,
	 DEF_PK_SIZE, 0x8000, 0x1000000},			/* 32K byte - 16M byte */

	{"bb", LONGINT, (void *)&org_bb_size, /* &(bitmap_buf_pointer->size), */
	 "bitmap buffer size", INIT_PIXEL|INIT_B_BUF,
	 DEF_BITMAP_SIZE, 0x10000, 0x1f00000},		/* 64K byte - 31M byte */

#ifdef	WIN32
	{"multi", INTEGER, (void*)&g_fMultiDviout,
	"maximal number of dviouts", 0,
	2, 1, 9},
	{"renew", BOOLTYPE, (void*)&f_renew,
	"Auto reNew", 0,
	TRUE, 0, 0},
	{"button", BOOLTYPE, (void*)&f_button,
	"Other Tool Bottons", INIT_BUTTON,
	FALSE, 0, 0},
#endif
#ifndef	WINDVIOUT
	{"f", INTEGER, (void *)&test_flg,
	 "test-flag(0-3)", 0
	 -1, 0, 3},
#endif

	{"wait",
#ifdef	WINDVIOUT
	HIDDEN_INTEGER
#else
	INTEGER
#endif
	, (void *)&f_wait,
	 "when error occurs, 0:Stop 1:wait key_input(default) 2-3:ignore", 0,
	 1, 0, 3},
	{"dpi", INTEGER, (void *)&(dviout_dimension.dpi),
	 "horizontal dpi", INIT_METRIC|INIT_FONT,
	 300, 10, 10000},

	{"dpiv", INTEGER, (void *)&(dviout_dimension.DPI),
	 "vertical   dpi", INIT_METRIC|INIT_FONT|INIT_VDPI,
	 0, 10, 10000},

	{"e", INTEGER, (void *)&(enlarge),
	 "enlarge*1000", INIT_METRIC|INIT_FONT,
	 0, 300, 4000},

#ifndef	WINDVIOUT
	{"page", BOOLTYPE, (void *)&dvifile_page,
	 "pages are dvifile-pages", 0,
	 FALSE, 0, 0
	 },
#endif
#ifdef	WIN32G
	{"t", INTEGER, (void *)&f_scr_skip,
	 "Scroll speed(1,2,...)", 0,
	 16, 1, 1000},
#endif
#if	!defined(WINDVIOUT)||defined(RAWOUT)
	{"nf", 
# ifdef	RAWOUT
	HIDDEN_STRING,
# else
	STRING, 
# endif
	(void *)&ff_flg_str,
	 "No use of form feed code", INIT_PRINTER,
	 0, 0, 0},

	{"o",
# ifdef	RAWOUT
	HIDDEN_STRING,
# else
	STRING,
# endif
	 (void *)&f_page_scroll,
	 "output (r:reverse, e:even pages, o:odd pages)", 0,
	 0, 0, 0},
#endif

	{"V", 
#ifdef	WIN32
		HIDDEN_BOOLEAN,
#else
		BOOLTYPE, 
#endif
#ifdef	WINDVIOUT
	(void *)&f_rotate,
#else
	(void *)&(dviout_dimension.print_direction),
#endif
	 "vertical-output", INIT_METRIC,
	 FALSE, 0, 0},

#if	!defined(WINDVIOUT)||defined(RAWOUT)
	{"T", 
# ifdef	RAWOUT
	HIDDEN_BOOLEAN,
# else
	BOOLTYPE, 
# endif
	(void *)&f_top_margin,
	 "correct Top margin for cut sheets", 0, 
	 FALSE, 0, 0},
#endif

#ifndef NOTPIC
	{"tpic", INTEGER, (void *)&f_tpic_turn_on,
	 "tpic special(0:ignore 1:Bezier"
# ifndef TPIC_NSPL
	 " 2:spline(default) +16:tate]", INIT_TPIC,
	 2, 0, 18},
# else
	 "]", 0,
	 1, 0, 17},
# endif
#endif

#ifndef NOPS
	{"GS", INTEGER, (void *)&f_GS,
	"Ghostscript[0:Off 1:On(default) 2:verbose 3:PBM 4:exact PBM 5:gssub]", 0,
	1, 0, 21},

# ifdef	GIF
	{"GIF", INTEGER, (void *)&f_GIF,
	"0:pbm 1:gifmono, 2:bmpmono, 3:bmp16, 4:bmp256, 5:bmp16m", 0,
	0, 0, 5},
# endif

	{"gsx", STRING, (void *)&gs_exe,
#ifdef UNIX
	"Ghostscript(default gs)", 0,
	DEF_gsx - DEF_0, 0, 0},
#else
	"Ghostscript(default gswin32c.exe)", 0,
	DEF_gsx - DEF_0, 0, 0},
#endif

	{"gdat", STRING, (void *)&pbm_path,
	"Directory of pbm/gif file", 0,
	0, 0, 0},

	{"gbox", BOOLTYPE, (void *)&f_gbox,
	"draw frame for picture", 0,
	FALSE, 0, 0},

	{"gow", BOOLTYPE, (void*)&f_gow,
	"overwrite for figures", 0,
	FALSE, 0, 0},

	{"gclip", BOOLTYPE, (void*)&f_gclip,
	"clip figures by BoundingBox", 0,
	TRUE, 0, 0},

	{"gfit", BOOLTYPE, (void *)&f_gsame,
	"color BMP to fit for preview", 0,
	TRUE, 0, 0},

	{"gsize", BOOLTYPE, (void *)&f_gsize,
	 "picture size:include mag", 0,
	FALSE, 0, 0},

#ifdef	WIN32
	{"color", BOOLTYPE, (void *)&f_spcolor,
	 "color special", 0,
	 TRUE, 0, 0},

	{"cmode", INTEGER, (void *)&f_rpcolor,
	 "color mode[0:auto(p2) 1:merge 2:replace(def) 3:replace(bak) 4:patch 5:patch2 6:auto(rep)]", 0,
	 0, 0, 6},

	{"spi", STRING, (void *)&spi,
	 "Directory of Susie plug_in", 0,
	 0, 0, 0},
#endif
#endif

#ifdef	STR_SEARCH
	{"search", INTEGER, (void *)&f_s_color,
	"Color of searched string(defalut: 0x00c0)", 0,
	0x00c0, 0x0000, 0x1ffff},

	{"sFont", STRING, (void *)&s_font,
	"Ignored fonts for string search", 0,
	0, 0, 0},

	{"sdpi", INTEGER, (void *)&f_s_dpi,
	"maximal dpi for coloring without gray scale", 0,
	150, 0, 10000},

#endif

#ifdef	HYPERTEX
	{"hyper", INTEGER, (void *)&f_h_color,
	"Color indicating HyperJump(default: 0x0040)", 0,
	0x18060, 0, 0x1ffff},

	{"hyperoff", INTEGER, (void *)&f_hyper,
	"Off HyperTeX", 0,
	0, 0, 2},

	{"href", INTEGER, (void *)&max_h_box,
	"max URL", INIT_HYPER,
	0x1000, 100, 10000},

	{"hname", INTEGER, (void *)&max_h_name,
	"max href name", INIT_HYPER,
	0x1000, 100, 10000},

	{"hbuf", INTEGER,(void *)&max_hyper_str,
	"HyperTeX buffer size", INIT_HYPER,
	 0x20000, 10<<10, 5000<<10},
	{"Browser", STRING, (void *)&browser,
	"non-default Browser", 0,
	0, 0, 0},

	{"ToEdit", STRING, (void *)&ToEdit,
	"Copy to Editor", 0, 0, 0, 0},
#endif

	{"L", INTEGER, (void *)&f_long_name,
	 "long font names[0:cut 1:cut center 2:long]", INIT_FONT,
	 2, 0, 2},

	{"c", BOOLTYPE, (void *)&f_font_c,
	 "Check font matching", INIT_FONT,
	 FALSE, 0, 0},

#ifdef	WIN32
	{"Fkeep", BOOLTYPE, (void *)&f_fkeep,
	 "Keep font path", INIT_FONT,
	 TRUE, 0, 0},
#endif

	{"F", STRING, (void *)&sub_font,
	 "Font substitute", INIT_FONT,
	 0, 0, 0},

	{"FB", INTEGER, (void *)&f_sub_blank,
	 "Blank Font substitute", INIT_FONT,
	 0, 0, 3},

	{"A", INTEGER, (void *)&f_search,
	 "Font search", INIT_FONT,
	 0, 0, 1000},

	{"K", STRING, (void *)&k_dbl,
	 "Double size Kanji", INIT_FONT,
	 0, 0, 0},

	{"G", STRING, (void *)&goth,
	 "Gothic", INIT_FONT,
	 DEF_G - DEF_0, 0, 0},

	{"g", BOOLTYPE, (void *)&use_lateral_kanji,
	 "Use Lateral Kanji Font in pTeX `tate' mode", INIT_FONT,
	 TRUE, 0, 0},

	{"JC", PROCEDURE, (void *)set_trans_jis,
	 "translate JIS code", INIT_FONT,
	 0, OLD_JC, 0},

	{"varf", BOOLTYPE, (void *)&f_resize,
	 "resize all fonts", INIT_FONT,
	 FALSE, 0, 0},

	{"base", BOOLTYPE, (void *)&draw_baseline,
	 "draw the baseline", 0,
	 FALSE, 0, 0},

	{"box", BOOLTYPE, (void *)&draw_boxpic,
	 "typeset by boxes instead of characters", 0,
	 FALSE, 0, 0},

#ifndef NO_GENFONT
	{"gen", STRING, (void *)&genfont_tmpl,
	 "automatic font generation", INIT_FONT,
	 0, 0, 0},
#endif

	{"vfn", STRING, (void *)&vfont_name,
	 "Syotai Club's/Kanji TrueType Font", 
	 INIT_ENDCFG|INIT_FONT|INIT_VFONT,
	 0, 0, 0},

#ifdef TTFONT
	{"ttf", INTEGER, (void *)&f_use_ttf,
	 "TrueType Font[0:Off <dot>:Draw sw]", INIT_FONT,
	 1, 0, 10000},
#endif
#ifdef USE_WINFONT
	{"ftt", PROCEDURE, (void *)DefineFTT,
	 "Font map file(tfm->TrueType)", INIT_FONT,
	 0, OLD_ftt, 0},
#endif
#ifdef	VIRTUALFONT
	{"virtual", BOOLTYPE, (void *)&f_use_virtualfont,
	 "Virtual font", INIT_FONT,
	 TRUE, 0, 0},
#endif
	{"Fod", BOOLTYPE, (void *)&f_ondemand,
	 "Font On demand", INIT_FONT,
	 TRUE, 0, 0},

#ifndef NO_NTTRPL
	{"nttF", STRING, (void *)&ntt_subst_fonts,
	 "NTTjTeX Nonstandard Font substitute", INIT_FONT,
	 0, 0, 0},

	{"ntt", BOOLTYPE, (void *)&ntt_subst,
	 "NTTjTeX Font substitute", INIT_FONT,
	 FALSE, 0, 0},
#endif

	{"S", INTEGER, (void *)&k_scale,
#ifdef	WIN32
	 "Kanji scale*1000 (default 1000)", INIT_FONT,
	 1000, 300, 4000},
#else
	 "Kanji scale*1000 (default 952)", INIT_FONT,
	 952, 300, 4000},
#endif

	{"J", INTEGER, (void *)&k_base,
	 "Kanji base line*1000 (default 0)", INIT_FONT,
	 0, -1000, 1000},

	{"Jbt", BOOLTYPE, (void *)&f_ktbase,
	 "Adjust Kanji base line of TrueType by jfm", INIT_FONT,
	 TRUE, 0, 0},

	{"Jgt", BOOLTYPE, (void *)&f_kglue,
	 "Adjust Kanji glue of TrueType by jfm", INIT_FONT,
	 FALSE, 0, 0},

	{"Jfm", BOOLTYPE, (void *)&f_JFM,
	 "Use inner jfm", INIT_FONT,
	 TRUE, 0, 0},

	{"y", PROCEDURE, (void *)youshi_size,
	 "Paper select [A3|A4|A5|B4|B5|H"
#ifdef LBP
	"|F<width>[:<height>]|T<number>"
#else
    "[l]"
#endif
#ifdef LIPS3
	 "\n\tLIPS3   :[p(port.)|l(land.)[<0(auto)|1(manual)|2(upper)|3(lower)>]]"
#endif
#ifdef ESCPAGE
	 "\n\tESC/Page:[p(port.)|l(land.)[1(normal)|2(option)[:bin]]]"
#endif
	 "]"
	,INIT_METRIC,
	DEF_y - DEF_0, OLD_y, 0},

#ifdef LBP
	{"lc", 
# ifdef WINDVIOUT
	HIDDEN_INTEGER,
# else
	INTEGER, 
# endif
	(void *)&f_copy,
	 "Number of copy by LBP", 0,
	 1, 1, 5000},
#endif

#ifdef VFD
	{"RV", BOOLTYPE, (void *)&tatevfd,
	 "Rotate vfd font", INIT_FONT,
	 FALSE, 0, 0},
#endif

#ifndef	NOTATEGAKI
	{"R", 
# ifdef	WINDVIOUT
	HIDDEN_BOOLEAN,
# else
	BOOLTYPE,  
# endif
	(void *)&tategaki,
	 "Font rotational printing with "
#ifdef	LBP
	 "LBP/"
#endif
	 "Zeit font", INIT_FONT,
	 FALSE, 0, 0},
#endif

	{"O", 
#ifdef	WINDVIOUT
	HIDDEN_STRING
#else
	STRING
#endif
 	,(void *)&f_out,
	 "File output(!!! is replaced by page)", 0,
	 0, 0, 0},  /* ? */

#ifndef	WINDVIOUT
	{"s", INTEGER, (void *)&slow_fact,
	 "slow speed(0,...,10000)", 0,
	0, 0, 10000},
#endif
#if	!defined(WINDVIOUT)||defined(RAWOUT)
	{"Z", 
# ifdef	RAWOUT
	HIDDEN_BOOLEAN,
# else
	BOOLTYPE,
# endif
	(void *)&f_pause,
	 "Pause for every page", 0,
	 FALSE, 0, 0},
	{"I", 
# ifdef	RAWOUT
	HIDDEN_STRING,
# else
	STRING, 
# endif
	(void *)&prt_initialize,
	 "File with code intializing printer", 0,
	 0, 0, 0},
#endif

	/* by K.Yoshizawa  Dec. 26, 1992 */

	{"PW", LENGTH, (void*)&OPW,
	"paper width  [default 210mm(A4)]", INIT_METRIC,
	0, 2<<17, 2<<28},		/* 1.5mm -> 3m */

	{"PH", LENGTH, (void*)&OPH,

	"paper height [default 297mm(A4)]", INIT_METRIC,
	0, 2<<17, 2<<28},		/* 1.5mm -> 2.9m */

#ifdef	WIN32
	{"area", BOOLTYPE, (void*)&f_area, "default mechanical gap", INIT_METRIC,
	TRUE, 0, 0},
#endif

	{"TM", LENGTH, (void*)&TM, "top    mechanical gap", INIT_METRIC,
	0, 0, 2<<25},	/* 0cm -> 36cm */

	{"BM", LENGTH, (void*)&BM, "bottom mechanical gap", INIT_METRIC,
	0, 0, 2<<25},

	{"LM", LENGTH, (void*)&LM, "left   mechanical gap", INIT_METRIC,
	0, 0, 2<<25},

	{"RM", LENGTH, (void*)&RM, "right  mechanical gap", INIT_METRIC,
	0, 0, 2<<25},

	{"MW", LENGTH, (void*)&MW, "max printable width", INIT_METRIC|INIT_MW,
	0, 2<<17, 2<<27},

	{"MH", LENGTH, (void*)&MH, "max printable height", INIT_METRIC|INIT_MH,
	0, 2<<17, 2<<27},

	{"OX", LENGTH, (void*)&OX, "horizontal move", INIT_METRIC,
	0, -(2<<28), 2<<28},		/* -2.9m -> 2.9m */

	{"OY", LENGTH, (void*)&OY, "vertical   move", INIT_METRIC,
	0, -(2<<28), 2<<28},		/* -2.9m -> 2.9m */
	/* by K.Yoshizawa  Dec. 27, 1992 */

	{"HC", BOOLTYPE, (void*)&HC, "horizontal centering", INIT_METRIC,
	FALSE, 0, 0},

	{"VC", BOOLTYPE, (void*)&VC, "vertical   centering", INIT_METRIC,
	FALSE, 0, 0},

	{"HS", LENGTH, (void*)&HS,  "horizontal shift after centering",
	INIT_METRIC,
	0, -(2<<25), (2<<25)},

	{"VS", LENGTH, (void*)&VS,  "vertical   shift after centering",
	INIT_METRIC,
	0, -(2<<25), (2<<25)},
	/* by K.Yoshizawa  Dec. 28, 1992 */

#ifdef	WIN32G
	{"edge", INTEGER, (void*)&edge_space, "spaces for cutting edge", 0,
	16, 0, 1024},
#endif
#ifndef	WINDVIOUT
	{"PF", INTEGER, (void*)&PF, 
		"paper feed position [1:left(default) 2:center]\n", INIT_METRIC,
	1, 1, 2},
#endif
#ifdef	WIN32
	{"key", PROCEDURE, (void *)DefineKeyTable, "define key table", 0,
	0, OLD_key, 0},

	{"log", STRING, (void *)&g_szLogFileName, "log file", 0,
	0, 0, 0},

    {"Wshow", BOOLTYPE, (void*)&f_Wshow, "show child windows", 0,
	FALSE, 0, 0},

#endif
	{"=", HIDDEN_PROCEDURE, (void *)set_config, "parameter file", 0,
	0, OLD_eq, 0},

#ifdef FAX
	{"FAX", 
# ifdef	RAWOUT
	HIDDEN_STRING,
# else
	STRING, 
# endif
	(void *)&f_fax, "G3 FAX", 0,
	0, 0, 0},
#endif
#ifdef	WIN32
	{"BMP", STRING, (void *)&f_bmp, "Windows BMP[x[:y[:z]]]", INIT_BMP,
	DEF_BMP - DEF_0, 0, 0}, /* ? */
	{"scale", PROCEDURE, (void *)DefineScale, "Define Scale[x:y:z:...]",0,
	DEF_scale - DEF_0, OLD_scale, 0},
	{"bright", INTEGER, (void*)&bright, "Brightness of view", INIT_BRIGHT,
	255, 0, 255},
#endif

#ifdef	WINDVIOUT
	{"dviprt", STRING, (void *)&exec_dviprt, "dviprt", 0,
	0, 0, 0},
#endif
#if !defined(WINDVIOUT)||defined(RAWOUT)
	{"p", 
# ifdef	RAWOUT
	HIDDEN_STRING, 
# else
	STRING,
# endif
	(void *)&pt_prt_type,
	 "type of printer e:ESC/P p:PC-PR n:NM o:other(default prtctl.cfg)"
# ifdef LBP
	 "\n\t"
#  ifdef LIPS3
	 "l:LIPS3 "
#  endif
#  ifdef ESCPAGE
	 "m:ESC/Page "
#  endif
	 "[v:font_aspect k:gaiji d:download_size r:real_size"
	 "\n\tm:minimal_count f:font_def D:dpi j:baseline s:size_adj E:edge"
	 "\n\tu:minimal_unit c:compress o:other"
# endif
	,INIT_METRIC,
	0, 0, 0},
#endif

#if defined(J3100) || defined(DOSV) || defined(WIN32C) || defined(RAWOUT)
  	{"P", 
# ifdef	RAWOUT
	HIDDEN_STRING,
# else
	STRING, 
# endif
	(void *)&pr_port_str,
# if	defined(WIN32C)||defined(RAWOUT)
	 "Use Printer , 0 for default printer, 1,..,4 for LPT1:,..,LPT4:"},
# elif	defined(GCC)
  	 "Use Printer Port Directly, 0,B1,..,B4 for BIOS,<num> for IO port"},
# else
  	 "Use Printer Port Directly, 0,B1,..,B4 for BIOS, BIOS]LPT1,..."},
	 0, 0, 0},
# endif
# ifndef WINDVIOUT
	{"comp", INTEGER, (void *)&comp_type,
	"Compress data[0:no compression 1:PCL mode 1 2:PCL mode 2]", 0,
	0, 0, 2},
# endif
#endif

#if	defined(PC9801) && defined(DOSV)
	{"hard", INTEGER, (void *)&machine,
	 "Hardware[0:PC9801 1:DOS/V"
# if defined(J3100)
	 " 2:J3100"
# endif
	 "]", 0,
	 0, 0, 2},
#endif
	{"TEXROOT", WIN_STRING, (void *)&root_search_path,
	"Root path(^r)", INIT_FONT,
	0, 0, 0},

	{"TEXPK",  WIN_STRING, (void *)&pk_search_path, 
	"Raster data of non-Kanji Fonts and jfm files of Kanji Fonts", 
	INIT_FONT,
	0, 0, 0},

	{"TEXPKD", WIN_STRING, (void *)&pkd_search_path, 
	"PKD Font path", INIT_FONT,
	0, 0, 0},

	{"TEXKNJ", WIN_STRING, (void *)&knj_search_path, 
	"Bitmap data of Kanji Font", INIT_FONT,
	0, 0, 0},

#ifdef VFD
	{"TEXVFD", WIN_STRING, (void *)&vfd_search_path, 
	"Zeit's font for NTTjTeX", INIT_FONT,
	0, 0, 0},
#endif

#ifdef FLI
	{"TEXFLI", WIN_STRING, (void *)&fli_search_path, 
	"FLI Font path",INIT_FONT,
	0, 0, 0},
#endif

#ifdef TTFONT
	{"TEXFONTS", WIN_STRING, (void *)&tfm_search_path, 
	"tfm files for non-Kanji TrueType Font", INIT_FONT,
	0, 0, 0},

	{"TEXSUBF", WIN_STRING, (void *)&subfont_path,
	"subfont path", INIT_FONT,
	0, 0, 0},
#endif
#ifdef	WIN32
	{"mode", HIDDEN_PROCEDURE, (void *)set_mode, "", 0,
	0, OLD_mode, 0},
#endif
#ifdef	WINDVIOUT
	{"macro", STRING, (void *)&key_macro, "Key macro", 0,
	0, 0, 0},
#endif
#ifdef	WIN32G
	{"src", STRING, (void*)&exec_src_sp, "source special", 0,
	0, 0, 0},
	{"gsrc", STRING, (void*)&exec_gsrc_sp, "graphic source special", 0,
	0, 0, 0},
#endif
	{"isp", STRING, (void*)&isp, "ignored specials", 0,
	0, 0, 0},

	{"texhelp", STRING, (void*)&texhelp, "parameter for TeX Help",0,
	0, 0, 0},

	{"file", PROCEDURE, (void *)set_config, "parameter file(same as -=)", 0,
	0, OLD_eq, 0},

	{"NULL", SKIP, NULL, "", 0,
	0, 0, 0},

#ifdef	WIN32G
	{"Set", HIDDEN_PROCEDURE, (void *)key_in, "", 0,
	0, 0, 0},
	{"1", SKIP, NULL, "", 0,
	0, 0, 0},
	{"2", SKIP, NULL, "", 0,
	0, 0, 0},
	{"3", SKIP, NULL, "", 0,
	0, 0, 0},
	{"4", SKIP, NULL, "", 0,
	0, 0, 0},
	{"5", SKIP, NULL, "", 0,
	0, 0, 0},
#endif

#endif	/* defined(JAPANESE) */
	{NULL}
};

#define INIT_PARA "goth=goth"
