/*
 * Postscript/EPS Unterst"utzung f"ur DVI
 * August 1994, Markus Zahn
 * Mai 1997, Robert Schumacher
 */

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef AMIGA
#include <proto/dos.h>
#include "Post:postlib.h"
#ifndef INIT_PS
#define INIT_PS "TeX:ps/init.ps"
#endif
extern struct Library *PSbase;
#endif

#include "dvi.h"
#include "dvieps.h"
#include "dviframe.h"

#ifndef GSEXEC
#define GSEXEC "gs"
#endif

#ifndef PT2PXL
#define PT2PXL(x) ((int)((float)(x) * (float)(op.hres) / 72.0))
#endif

#ifndef FALSE
#define FALSE 0
#endif
#ifndef TRUE
#define TRUE !FALSE
#endif

#ifndef AMIGA
void display_pbmraw(
  char *pbm_name,
  int x,
  int y );
#endif

typedef struct {
  char eps_name[1024];
  char tmp_name[512];
  void *next;  
} EPS_LIST;

EPS_LIST *eps_list = NULL , *eps_list2 ;
int eps_count = 0, eps_i;

void init_eps_support( void )
{
  EPS_LIST *temp;

  while ( eps_list != NULL )
  {
    temp = eps_list;
    eps_list = (EPS_LIST *) eps_list->next;
    remove( temp->tmp_name );
    free( temp );
  }
  eps_count = 0;
}

void do_eps_file(
  char *eps_name,
  int x,
  int y,
  int llx,
  int lly,
  int urx,
  int ury,
  int rhi,
  int rwi )
{
  float eps_scale;
  long magnification = ( op.new_mag == 0 ) ? dvi_info.mag : op.new_mag;
  int width, height;
  FILE *epsf;
#ifndef AMIGA
  char temp_name[MAX_PATH_LEN], command[512];
#else
  char command[MAX_PATH_LEN];
  int activation, error;
  struct PSparm parm;
#endif

/*
 * Wir testen, ob es die gew"unschte Datei "uberhaupt gibt.
 * Ach wenn wir doch ein op.ps_path h"atten...
 * if( ( epsf = fopene( eps_name, "r", ps_path, eps_name ) ) == NULL )
 */
  strcpy( temp_name  , "" );
  eps_i = 0; eps_list2 = eps_list;
  while (eps_i < eps_count )
  {
    if (strcmp( eps_name , eps_list2->eps_name ) == 0)
    {
      strcpy( temp_name , eps_list2->tmp_name );
      eps_i = eps_count;
    }
    else
    {
      eps_list2 = (EPS_LIST *) eps_list2->next;
      eps_i++;
    }
  }

  if( ( epsf = fopen( eps_name, "r" ) ) == NULL )
  {
    print( "Error reading EPSF file %s", eps_name );
    return;
  }
  else
    fclose( epsf );

  /* 
   * rwi is 10 times the desired width, in points (but scaled by the
   * magnification).  epsf_scale is thus the scale according to the
   * \special command.  (For epsfile.tex specials, x and y scale are
   * always the same.)
   */
  if( rhi != 0 )
    eps_scale = ( rhi * ( magnification / 10000.0 ) ) / ( ury - lly + 1 );
  else if( rwi != 0 )
    eps_scale = ( rwi * ( magnification / 10000.0 ) ) / ( urx - llx + 1 );
  else
  {
    print( "DVI file contains neither rhi nor rwi for file %s", eps_name );
    return;
  }

  /* 
   * Scale the bounding box.  The floating point calculations have
   * potential round-down errors, so add an extra pixel to compensate. 
   */
  llx = (int)( (float)( llx ) * eps_scale );
  lly = (int)( (float)( lly ) * eps_scale );
  urx = (int)( (float)( urx ) * eps_scale );
  ury = (int)( (float)( ury ) * eps_scale );
  urx++; ury++;

  width = PT2PXL(urx-llx);
  height = PT2PXL(ury-lly);

#ifndef AMIGA
  
  xprint( 0, "(%s", eps_name );
  if ( strcmp( temp_name , "") == 0)
  {
    tmpnam(temp_name);
  
    if( op.landscape )
      sprintf( command, "(echo %d %d translate %f %f scale -90 rotate; "
        "cat %s; echo showpage) | "
        "%s -q -dNOPAUSE -sDEVICE=pbmraw -r%dx%d -g%dx%d -sOutputFile=%s -",
        -lly, urx, eps_scale, eps_scale, eps_name, GSEXEC, op.vres,
        op.hres, height, width, temp_name );
    else
      sprintf( command, "(echo %d %d translate %f %f scale; "
        "cat %s; echo showpage) | "
        "%s -q -dNOPAUSE -sDEVICE=pbmraw -r%dx%d -g%dx%d -sOutputFile=%s -",
        -llx, -lly, eps_scale, eps_scale, eps_name, GSEXEC, op.hres,
        op.vres, width, height, temp_name );
    if( system( command ) != 0 )
      print( "%s failed: %s", GSEXEC, strerror( errno ) );
    else
    {
      display_pbmraw( temp_name, x, y );
      eps_list2 = (EPS_LIST *) malloc( sizeof( EPS_LIST ));
      strcpy( eps_list2 -> eps_name , eps_name );
      strcpy( eps_list2 -> tmp_name , temp_name );
      eps_list2 -> next = eps_list;
      eps_list = eps_list2;
      eps_count++;
    }
  }
  else
    display_pbmraw( temp_name, x, y );
 
  xprint( -1, ")" );

// remove( temp_name );
#else
  if( PSbase != NULL )
  {
    memset( &parm, '\0', sizeof( struct PSparm ) );
    parm.page.buf[0] = frame_buffer;
    parm.page.len = frame_size;
    parm.page.depth = 1;
    parm.page.xoff = 0;
    parm.page.yoff = 0;
    parm.page.xbytes = frame_width;
    parm.page.xsize = frame_width * 8;
    parm.page.ysize = frame_height;
    parm.page.ybase = 0;
    parm.page.yheight = parm.page.ysize;
    parm.page.xden = op.hres;
    parm.page.yden = op.vres;
    parm.page.ydir = -1;
    parm.infh = parm.outfh = parm.errfh = Open( "NIL:", MODE_OLDFILE );

    if( ( activation = PScreateact( &parm ) ) > errmax )
    {
      if( op.landscape )
      {
        x = x * 72 / op.vres - lly;
        y = ( frame_height - y ) * 72 / op.hres + llx;
        sprintf( command, "%d %d translate %f %f scale -90 rotate", x, y,
          eps_scale, eps_scale );
      }
      else
      {
        x = x * 72 / op.hres - llx;
        y = ( frame_height - y ) * 72 / op.vres - lly;
        sprintf( command, "%d %d translate %f %f scale", x, y, eps_scale,
          eps_scale );
      }
      /* PostScript showpage umdefinieren */
      strcat( command, " /showpage { } def" );

      xprint( 0, "(%s", eps_name );
      if( ( error = PSintstring( activation, INIT_PS, -1, PSFLAGFILE ) ) != 0 )
        xprint( 1, PSerrstr( activation, error ) );
      if( ( error = PSintstring( activation, command, -1, PSFLAGSTRING ) ) != 0 )
        xprint( 1, PSerrstr( activation, error ) );
      if( ( error = PSintstring( activation, eps_name, -1, PSFLAGFILE ) ) != 0 )
        xprint( 1, PSerrstr( activation, error ) );
      xprint( -1, ")" );

      PSdeleteact( activation );
    }
    else
      print( "Error: unable to create post.library activation record" );

    Close( parm.infh );
  }
#endif
}

void do_ps_file( char *ps_name, int x, int y )
{
  float ps_scale;
  long magnification = ( op.new_mag == 0 ) ? dvi_info.mag : op.new_mag;
  FILE *psf;
#ifndef AMIGA
  char temp_name[MAX_PATH_LEN], command[512];
#else
  char command[MAX_PATH_LEN];
  int activation, error;
  struct PSparm parm;
#endif

/*
 * Wir testen, ob es die gew"unschte Datei "uberhaupt gibt.
 * Ach wenn wir doch ein op.ps_path h"atten...
 * if( ( epsf = fopene( ps_name, "r", ps_path, ps_name ) ) == NULL )
 */
  if( ( psf = fopen( ps_name, "r" ) ) == NULL )
  {
    print( "Error reading PostScript file %s", ps_name );
    return;
  }
  else
    fclose( psf );

  ps_scale = (float)magnification / 1000.0;

#ifndef AMIGA
  tmpnam(temp_name);

  if( op.landscape )
    sprintf( command, "(echo 0 %d translate %f %f scale -90 rotate; "
      "cat %s; echo showpage) | "
      "%s -q -dNOPAUSE -sDEVICE=pbmraw -r%dx%d -g%dx%d -sOutputFile=%s -",
      ( frame_width * 8 - x ) * 72 / op.vres, ps_scale, ps_scale, ps_name,
      GSEXEC, op.vres, op.hres, frame_height - y, frame_width * 8 - x,
      temp_name );
  else
    sprintf( command, "(echo %f %f scale; cat %s; echo showpage) | "
      "%s -q -dNOPAUSE -sDEVICE=pbmraw -r%dx%d -g%dx%d -sOutputFile=%s -",
      ps_scale, ps_scale, ps_name, GSEXEC, op.hres, op.vres,
      frame_width * 8 - x, y, temp_name );

  xprint( 0, "(%s", ps_name );
  if( system( command ) != 0 )
    print( "%s failed: %s", GSEXEC, strerror( errno ) );
  else
    display_pbmraw( temp_name, x, y );
  xprint( -1, ")" );

  remove( temp_name );
#else
  if( PSbase != NULL )
  {
    memset( &parm, '\0', sizeof( struct PSparm ) );
    parm.page.buf[0] = frame_buffer;
    parm.page.len = frame_size;
    parm.page.depth = 1;
    parm.page.xoff = 0;
    parm.page.yoff = 0;
    parm.page.xbytes = frame_width;
    parm.page.xsize = frame_width * 8;
    parm.page.ysize = frame_height;
    parm.page.ybase = 0;
    parm.page.yheight = parm.page.ysize;
    parm.page.xden = op.hres;
    parm.page.yden = op.vres;
    parm.page.ydir = -1;
    parm.infh = parm.outfh = parm.errfh = Open( "NIL:", MODE_OLDFILE );

    if( ( activation = PScreateact( &parm ) ) > errmax )
    {
      if( op.landscape )
      {
        x = x * 72 / op.vres;
        y = ( frame_height - y ) * 72 / op.hres;
        sprintf( command, "%d %d translate %f %f scale -90 rotate", x, y,
          ps_scale, ps_scale );
      }
      else
      {
        x = x * 72 / op.hres;
        y = ( frame_height - y ) * 72 / op.vres;
        sprintf( command, "%d %d translate %f %f scale", x, y, ps_scale,
          ps_scale );
      }
      /* PostScript showpage umdefinieren */
      strcat( command, " /showpage { } def" );

      xprint( 0, "(%s", ps_name );
      if( ( error = PSintstring( activation, INIT_PS, -1, PSFLAGFILE ) ) != 0 )
        xprint( 1, PSerrstr( activation, error ) );
      if( ( error = PSintstring( activation, command, -1, PSFLAGSTRING ) ) != 0 )
        xprint( 1, PSerrstr( activation, error ) );
      if( ( error = PSintstring( activation, ps_name, -1, PSFLAGFILE ) ) != 0 )
        xprint( 1, PSerrstr( activation, error ) );
      xprint( -1, ")" );

      PSdeleteact( activation );
    }
    else
      print( "Error: unable to create post.library activation record" );

    Close( parm.infh );
  }
#endif
}

void do_ps_command( char *command, int x, int y )
{
  float ps_scale;
  long magnification = ( op.new_mag == 0 ) ? dvi_info.mag : op.new_mag;
#ifndef AMIGA
  char temp_name[MAX_PATH_LEN], transform[512];
#else
  char transform[64];
  int activation, error;
  struct PSparm parm;
#endif

  ps_scale = (float)magnification / 1000.0;

#ifndef AMIGA
  tmpnam(temp_name);

  if( op.landscape )
    sprintf( transform, "(echo 0 %d translate %f %f scale -90 rotate; "
      "echo %s; echo showpage) | "
      "%s -q -dNOPAUSE -sDEVICE=pbmraw -r%dx%d -g%dx%d -sOutputFile=%s -",
      ( frame_width * 8 - x ) * 72 / op.vres, ps_scale, ps_scale, command,
      GSEXEC, op.vres, op.hres, frame_height - y, frame_width * 8 - x,
      temp_name );
  else
    sprintf( transform, "(echo %f %f scale; echo %s; echo showpage) | "
      "%s -q -dNOPAUSE -sDEVICE=pbmraw -r%dx%d -g%dx%d -sOutputFile=%s -",
      ps_scale, ps_scale, command, GSEXEC, op.hres, op.vres,
      frame_width * 8 - x, y, temp_name );

  if( system( transform ) != 0 )
    print( "%s failed: %s", GSEXEC, strerror( errno ) );
  else
    display_pbmraw( temp_name, x, y );

  remove( temp_name );
#else
  if( PSbase != NULL )
  {
    memset( &parm, '\0', sizeof( struct PSparm ) );
    parm.page.buf[0] = frame_buffer;
    parm.page.len = frame_size;
    parm.page.depth = 1;
    parm.page.xoff = 0;
    parm.page.yoff = 0;
    parm.page.xbytes = frame_width;
    parm.page.xsize = frame_width * 8;
    parm.page.ysize = frame_height;
    parm.page.ybase = 0;
    parm.page.yheight = parm.page.ysize;
    parm.page.xden = op.hres;
    parm.page.yden = op.vres;
    parm.page.ydir = -1;
    parm.infh = parm.outfh = parm.errfh = Open( "NIL:", MODE_OLDFILE );

    if( ( activation = PScreateact( &parm ) ) > errmax )
    {
      if( op.landscape )
      {
        x = x * 72 / op.vres;
        y = ( frame_height - y ) * 72 / op.hres;
        sprintf( transform, "%d %d translate %f %f scale -90 rotate", x, y,
          ps_scale, ps_scale );
      }
      else
      {
        x = x * 72 / op.hres;
        y = ( frame_height - y ) * 72 / op.vres;
        sprintf( transform, "%d %d translate %f %f scale", x, y, ps_scale,
          ps_scale );
      }
      /* PostScript showpage umdefinieren */
      strcat( command, " /showpage { } def" );

      if( ( error = PSintstring( activation, INIT_PS, -1, PSFLAGFILE ) ) != 0 )
        xprint( 1, PSerrstr( activation, error ) );
      if( ( error = PSintstring( activation, transform, -1, PSFLAGSTRING ) ) != 0 )
        xprint( 1, PSerrstr( activation, error ) );
      if( ( error = PSintstring( activation, command, -1, PSFLAGSTRING ) ) != 0 )
        xprint( 1, PSerrstr( activation, error ) );

      PSdeleteact( activation );
    }
    else
      print( "Error: unable to create post.library activation record" );

    Close( parm.infh );
  }
#endif
}

#ifndef AMIGA
void display_pbmraw(
  char *pbm_name,
  int x,
  int y )
{
  FILE *gs_out;
  int width, height, line_size, line, byte_nr, max_width, error = FALSE;
  unsigned long offset;
  byte buffer[512], *fptr;

  if( ( gs_out = fopen( pbm_name, "r" ) ) == NULL )
    print( "Unable to read %s", pbm_name );
  else
  {
    fgets( (char *)buffer, 512, gs_out );
    if( strncmp( (char *)buffer, "P4", 2 ) == 0 )
    {
      while( fgets( (char *)buffer, 512, gs_out ) )
        if( (char)( buffer[0] ) != '#' )
          break;

      sscanf( (char *)buffer, "%d %d", &width, &height );
      line_size = ( width + 7 ) / 8;

      if( line_size + x / 8 < frame_width )
        max_width = line_size;
      else
        max_width = frame_width - x / 8;

      if( line_size < sizeof( buffer ) )
      {
        if( op.landscape )
          for( line = 0; line < height; line++ )
          {
            offset = ( y + line ) * frame_width + x / 8;
            fptr = frame_ptr( offset );
            fread( buffer, line_size, 1, gs_out );
            if( ( fptr >= frame_buffer ) && ( offset < frame_size ) )
              for( byte_nr = 0; byte_nr < max_width; byte_nr++, fptr++ )
                *fptr |= buffer[byte_nr];
            else
              error = TRUE;
          }
        else
          for( line = -height; line < 0; line++ )
          {
            offset = ( y + line ) * frame_width + x / 8;
            fptr = frame_ptr( offset );
            fread( buffer, line_size, 1, gs_out );
            if( ( fptr >= frame_buffer ) && ( offset < frame_size ) )
              for( byte_nr = 0; byte_nr < max_width; byte_nr++, fptr++ )
                *fptr |= buffer[byte_nr];
            else
              error = TRUE;
          }
      }
      else
        print( "Oops, image to big for me :-(" );
    }
    else
      print( "Previously creted file %s is not pbmraw", pbm_name );
    fclose( gs_out );
  }
  if( error )
    print( "Warning: Output of PS/EPS file may be incorrect" );
}
#endif

