/*
** Datei: DISPLAY.C
** Autor: Ingo Eichenseher
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <aes.h>
#include <vdi.h>
#include <tos.h>

#define KIND (NAME|CLOSER|FULLER|SIZER|MOVER|UPARROW|DNARROW\
    |LFARROW|RTARROW|HSLIDE|VSLIDE|INFO)
#define MIN(a,b) ((a)<(b) ? (a):(b))
#define MAX(a,b) ((b)<(a) ? (a):(b))

#define FORM     0  /* form/dialog */
#define EDIT     1  /* FTEXT in tree FORM */
#define CANCEL   2  /* BUTTON in tree FORM */
#define OK       3  /* BUTTON in tree FORM */

char rs_strin[]={
    "00000\0"
    "Go to page : _____\0"
    "99999\0"
    " Cancel \0"
    " Ok \0"
}; /* Ende von rs_strin */

TEDINFO rs_tedin[]={
    {rs_strin+0,rs_strin+6,rs_strin+25,3,6,0,4480,0,-1,6,19}
}; /* Ende von rs_tedin */

OBJECT rs_objec[]={
    {-1,1,3,20,0,16,0x00021100l,13,2,26,2054},
    {2,-1,-1,29,8,0,(long)(rs_tedin+0),4,2,18,1},
    {3,-1,-1,26,5,0,(long)(rs_strin+31),3,4,9,1},
    {0,-1,-1,26,39,0,(long)(rs_strin+40),14,4,9,1},
}; /* Ende von rs_objec */

OBJECT *rs_trees[]={
    rs_objec+0
};

int rs_nobs=4;

static int vdi_handle;
static int appl_id;
static int work_in[12], work_out[57];
static int gr_handle, gr_hwchar, gr_hhchar, gr_hwbox, gr_hhbox;

static int  width, height;
static long size;
static char *buffer = NULL;
static FILE *fp = NULL;
static int wi_handle = -1;
static int menu_id = -1;
static int end_evhandler;
static MFDB src,dest;
static int xoff, yoff;
static int hslide=0, vslide=0, sizer=0, redraw=0, info=0;
static int bw, bh;
static int pages, pageno;
static long pos;
static int mono;

static int vdi_init(void)
{
    int i;
    for(i=0;i<10;work_in[i++]=1);
    work_in[10]=2;
    vdi_handle=gr_handle=graf_handle(&gr_hwchar, &gr_hhchar, &gr_hwbox, &gr_hhbox);
    v_opnvwk(work_in,&vdi_handle,work_out);
    if (vdi_handle<0) return 0;
    return 1;
}

static void vdi_exit(void)
{
    v_clsvwk(vdi_handle);
}

static void init_rsrc(void)
{
    int i;
    for (i=0; i<rs_nobs; i++) rsrc_obfix(rs_objec,i);
}

static int init_gem(void)
{
    if ((appl_id=appl_init())<0) return 0;
    if (!vdi_init()) return 0;
    return 1;
}

static void exit_gem(void)
{
    vdi_exit();
    appl_exit();
}

static char *fname(char *name)
{
    char *p = strrchr(name,'\\');
    if (p==NULL && name[0] && name[1]==':') p = name+1;
    if (p==NULL) p = name-1;
    return p+1;
}

static void exgfile(char *new, char *old, char *name)
{
    if (new!=old) strcpy(new,old);
    strcpy(fname(new),name);
}

static int alert(int def, char *format, ...)
{
    char line[256];
    va_list l;
    va_start(l,format);
    vsprintf(line,format,l);
    va_end(l);
    return form_alert(def,line);
}

static void set_sizer(void)
{
    int s,x,y,w,h;

    wind_get(wi_handle,WF_WORKXYWH,&x,&y,&w,&h);
    s = (int)(((long)h*1000l)/(long)height);
    wind_set(wi_handle,WF_VSLSIZE,s);
    s = (int)(((long)w*1000l)/(long)width);
    wind_set(wi_handle,WF_HSLSIZE,s);
    sizer = 0;
}

static void set_vslide(void)
{
    int p,x,y,w,h;
    wind_get(wi_handle,WF_WORKXYWH,&x,&y,&w,&h);
    if (height>h)
	p = (int)(((long)yoff*1000l)/(long)(height-h));
    else
	p = 0;
    wind_set(wi_handle,WF_VSLIDE,p);
    vslide=0;
}

static void set_hslide(void)
{
    int p,x,y,w,h;
    wind_get(wi_handle,WF_WORKXYWH,&x,&y,&w,&h);
    if (width>w)
	p = (int)(((long)xoff*1000l)/(long)(width-w));
    else
	p = 0;
    wind_set(wi_handle,WF_HSLIDE,p);
    hslide=0;
}

static void set_slides(void)
{
    set_vslide();
    set_hslide();
}

static void set_info(void)
{
    static char info_text[128];
    sprintf(info_text," Page %d/%d (%ld Bytes)",pageno+1,pages,size);
    wind_set(wi_handle,WF_INFO,info_text);
    info=0;
}

static int open_window(char *name)
{
    int  dx,dy,dw,dh,wx,wy,ww,wh,bx,by;
    char wi_name[128];

    wi_name[0] = ' ';
    strcpy(wi_name+1,name);
    strcat(wi_name," ");
    wi_name[strlen(wi_name)+1] = '\0';

    wind_get(0,WF_WORKXYWH,&dx,&dy,&dw,&dh);
    wind_calc(WC_WORK,KIND,dx,dy,dw,dh,&wx,&wy,&ww,&wh);
    if (ww>width) ww=width;
    if (wh>height) wh=height;
    wind_calc(WC_BORDER,KIND,wx,wy,ww,wh,&bx,&by,&bw,&bh);
    wi_handle = wind_create(KIND,bx,by,bw,bh);
    if (wi_handle<=0) return 0;
    wind_set(wi_handle,WF_NAME,wi_name);
    set_info();
    wind_open(wi_handle,bx,by,bw,bh);
    xoff = yoff = 0;
    set_sizer();
    set_slides();
    return 1;
}

static int read_file(int pg)
{
    register char *p = buffer;
    register long s;
    register int b, r=0;
    long f;

    if (pages<1) return 0;  
    pageno = pg-1;
    if (pageno>pages-1) pageno=pages-1;
    if (pageno<0) pageno=0;
    f = pos + (long)pageno * sizeof(long);
    fseek(fp,f,SEEK_SET);
    fread(&f,sizeof(long),1,fp);
    fseek(fp,f,SEEK_SET);
    if (ferror(fp)) return 0;

    if (buffer==NULL) return 0;
    for (s=size; s--; p++)
    {   
	if (r>0)
	{
	    *p = 0;
	    r--;
	}
	else
	{
	    if ( (b = getc(fp))==EOF) return 0;
	    if (b==0)
	    {
		if ( (r = getc(fp))==EOF ) return 0;
		*p = 0;
		r--;
	    }
	    else *p=b;
	}
    }
    return 1;
}


static void init_window(void)
{
    static char file_name[128]="";
    static char file_path[128]="";
    char name[128];
    int button;

    if (file_path[0]==0)
    {
	file_path[0] = Dgetdrv()+'A';
	file_path[1] = ':';
	Dgetpath(file_path+2,0);
	if (file_path[strlen(file_path)-1]!='\\')
	    strcat(file_path,"\\");
	strcat(file_path,"*.PIX");
    }

    fsel_input(file_path,file_name,&button);
    if (button==0 || *file_name=='\0') return;
    exgfile(name,file_path,file_name);
    fp = fopen(name,"rb");
    if (fp==NULL)
    {
	alert(1,"[1][ Cannot open file | %s ][ Abort ]",name);
	return;
    }
    fread(&width,sizeof(int),1,fp);
    fread(&height,sizeof(int),1,fp);
    size = (long)width * (long)height;
    width *= 8;
    buffer = calloc(size,1);
    if (buffer==NULL)
    {
	fclose(fp);
	alert(1,"[1][ Not enough memory | %ld Bytes needed ][ Abort ]",size);
	return;
    }
    fseek(fp,-6,SEEK_END);
    fread(&pages,sizeof(int),1,fp);
    fread(&pos,sizeof(long),1,fp);
    if (!read_file(1))
	form_alert(1,"[1][ Couldn't read file ][ continue ]");

    dest.fd_addr = 0l;
    src.fd_addr = buffer;
    src.fd_w = width;
    src.fd_h = height;
    src.fd_wdwidth = width/16;
    src.fd_stand = 0;
    src.fd_nplanes = 1;
    src.fd_r1 = 0;
    src.fd_r2 = 0;
    src.fd_r3 = 0;

    if (!open_window(name)) 
    {
	free(buffer);
	fclose(fp);
	return;
    }
}

static void exit_window(void)
{
    if (buffer!=NULL) 
    {
	free(buffer);
	buffer = NULL;
    }
    if (fp!=NULL) 
    {
	fclose(fp);
	fp = NULL;
    }
    if (wi_handle>0)
    {
	wind_close(wi_handle);
	wind_delete(wi_handle);
	wi_handle = -1;
    }
}

static int intersect(int *p1, int *p2)
{
    int  tw = MIN(p1[0] + p1[2], p2[0] + p2[2]);
    int  th = MIN(p1[1] + p1[3], p2[1] + p2[3]);
    int  tx = MAX(p1[0], p2[0]);
    int  ty = MAX(p1[1], p2[1]);

    p2[0] = tx;
    p2[1] = ty;
    p2[2] = tw - tx;
    p2[3] = th - ty;

    return (tw>tx) && (th>ty);
}


static void evwm_redraw(int handle, int *rec)
{
    int p[8], w[4];

    if (handle!=wi_handle || wi_handle<0) return;
    wind_update(BEG_UPDATE);
    v_hide_c(vdi_handle);
    wind_get(wi_handle,WF_WORKXYWH,w,w+1,w+2,w+3);
    if (rec==NULL) rec = w;
    wind_get(wi_handle,WF_FIRSTXYWH,p+4,p+5,p+6,p+7);
    while(p[6] && p[7])
    {
	if (intersect(rec,p+4))
	{
	    p[2] = p[6];
	    p[3] = p[7];
	    p[6] += p[4]-1;
	    p[7] += p[5]-1;
	    p[0] = p[4] - w[0] + xoff;
	    p[1] = p[5] - w[1] + yoff;
	    p[2] += p[0]-1;
	    p[3] += p[1]-1;
	    if (mono)
		vro_cpyfm(vdi_handle,S_ONLY,p,&src,&dest);
	    else
	    {
		int color[2];
		color[0] = 4;
		color[1] = 6;
		vrt_cpyfm(vdi_handle,MD_REPLACE,p,&src,&dest,color);
	    }
	}
	wind_get(wi_handle,WF_NEXTXYWH,p+4,p+5,p+6,p+7);
    }
    v_show_c(vdi_handle,1);
    wind_update(END_UPDATE);
    redraw = 0;
}

static void evwm_vslid(int handle, int pos)
{
    int x,y,w,h;

    if (handle!=wi_handle) return;
    if (pos<0) pos=0;
    if (pos>1000) pos=1000;
    wind_get(wi_handle,WF_WORKXYWH,&x,&y,&w,&h);
    if (height>h)
	yoff = (int)(((long)pos*(long)(height-h))/1000l);
    else
	yoff = 0;
    vslide = redraw = 1;
}

static void evwm_hslid(int handle, int pos)
{
    int x,y,w,h;

    if (handle!=wi_handle) return;
    if (pos<0) pos=0;
    if (pos>1000) pos=1000;
    wind_get(wi_handle,WF_WORKXYWH,&x,&y,&w,&h);
    if (width>w)
	xoff = (int)(((long)pos*(long)(width-w))/1000l);
    else
	xoff = 0;
    hslide = redraw = 1;
}

static void evwm_closed(int handle)
{
    if (handle!=wi_handle) return;
    exit_window();
    end_evhandler=1;
}

static void evwm_moved(int handle, int *rec)
{
    if (handle!=wi_handle) return;
    wind_set(wi_handle,WF_CURRXYWH,rec[0],rec[1],rec[2],rec[3]);
}

static void evwm_sized(int handle, int *rec)
{
    int x,y,w,h;
    if (handle!=wi_handle) return;
    if (rec[2]>bw) rec[2]=bw;
    if (rec[3]>bh) rec[3]=bh;
    wind_set(wi_handle,WF_CURRXYWH,rec[0],rec[1],rec[2],rec[3]);
    wind_get(wi_handle,WF_WORKXYWH,&x,&y,&w,&h);
    if (xoff+w>width) xoff=width-w, redraw = 1;
    if (yoff+h>height) yoff=height-h, redraw = 1;
    vslide = hslide = sizer = 1;
}

static void evwm_fulled(int handle)
{
    int rec[4];
    if (handle!=wi_handle) return;
    wind_get(wi_handle,WF_CURRXYWH,rec,rec+1,rec+2,rec+3);
    if (rec[2]==bw && rec[3]==bh)
	wind_get(wi_handle,WF_PREVXYWH,rec,rec+1,rec+2,rec+3);
    else
	rec[2]=bw, rec[3]=bh;
    evwm_sized(handle,rec);
}

static void evwm_arrowed(int handle, int direction)
{
    /*
	0    Seite nach oben
	1    Seite nach unten
	2    Zeile nach oben
	3    Zeile nach unten
	4    Seite nach links
	5    Seite nach rechts
	6    Spalte nach links
	7    Spalte nach rechts
    */
    int x,y,w,h;

    if (handle!=wi_handle) return;
    wind_get(wi_handle,WF_WORKXYWH,&x,&y,&w,&h);
    switch(direction)
    {
	case 0 :
	case 2 :
	    yoff -= direction==0 ? h : gr_hhbox;
	    if (yoff<0) yoff = 0;
	    redraw = vslide = 1;
	    break;
	case 3 :
	case 1 :
	    yoff += direction==1 ? h : gr_hhbox;
	    if (yoff>height-h) yoff = height-h;
	    redraw = vslide = 1;
	    break;
	case 4 :
	case 6 :
	    xoff -= direction==4 ? w : gr_hwbox;
	    if (xoff<0) xoff = 0;
	    redraw = hslide = 1;
	    break;
	case 7 :
	case 5 :
	    xoff += direction==5 ? w : gr_hwbox;
	    if (xoff>width-w) xoff = width-w;
	    redraw = hslide = 1;
	    break;
    }
}

static void evwm_topped(int handle)
{
    if (handle!=wi_handle) return;
    wind_set(wi_handle,WF_TOP);
}

static void page_form(void)
{
    int x,y,w,h,b;
    OBJECT *o = rs_trees[FORM];

    if (wi_handle<=0) return;
    o[EDIT].ob_spec.tedinfo->te_ptext[0]=0; 
    form_center(o,&x,&y,&w,&h);
    form_dial(0,0,0,0,0,x,y,w,h);
    objc_draw(o,0,8,x,y,w,h);
    b = form_do(o,EDIT);
    if (b==OK)
    {
	read_file(atoi(o[EDIT].ob_spec.tedinfo->te_ptext));
	xoff = yoff = 0;
	vslide = hslide = redraw = info = 1;
    }
    objc_change(o,b,0,x,y,w,h,o[b].ob_state &~SELECTED,0);
    form_dial(3,0,0,0,0,x,y,w,h);
}

static void next_page(int offset)
{
    read_file(pageno+1+offset);
    xoff = yoff = 0;
    vslide = hslide = redraw = info = 1;
}

static void ev_button(int mx, int my, int buttons, int keystate, int clicks)
{
    int x,y,wx,wy,ww,wh,stat,handle,pxy[8];

    if (wi_handle<0) return;
    wind_get(wi_handle,WF_WORKXYWH,&wx,&wy,&ww,&wh);
    wind_get(0,WF_TOP,&handle);

    if ( buttons==1 && clicks==1 && keystate==0 && handle==wi_handle)
    {
	wind_update(BEG_UPDATE);
	wind_update(BEG_MCTRL);
	v_hide_c(vdi_handle);
	pxy[4] = wx;
	pxy[5] = wy;
	pxy[6] = wx+ww-1;
	pxy[7] = wy+wh-1;
	vs_clip(vdi_handle,0,pxy+4);

	while(1)
	{
	    vq_mouse(vdi_handle,&stat,&x,&y);
	    if (stat==0) break;
	    pxy[0] = xoff+mx-x;
	    pxy[1] = yoff+my-y;
	    if (pxy[0]+ww>width) pxy[0] = width-ww;
	    if (pxy[1]+wh>height) pxy[1] = height-wh;
	    if (pxy[0]<0) pxy[0] = 0;
	    if (pxy[1]<0) pxy[1] = 0;
	    pxy[2] = pxy[0]+ww-1;
	    pxy[3] = pxy[1]+wh-1;
	    if (mono) vro_cpyfm(vdi_handle,S_ONLY,pxy,&src,&dest);
	    else
	    {
		int color[2];
		color[0] = 4;
		color[1] = 6;
		vrt_cpyfm(vdi_handle,MD_REPLACE,pxy,&src,&dest,color);
	    }
	    evnt_timer(0,0);
	}
	xoff = pxy[0];
	yoff = pxy[1];

	v_show_c(vdi_handle,0);
	wind_update(END_MCTRL);
	wind_update(END_UPDATE);
	set_slides();
    }
}

static void ev_key(int key)
{
    int handle;
    wind_get(0,WF_TOP,&handle);
    if (wi_handle<=0 || wi_handle!=handle) return;

    switch(key)
    {
	case 0x4838 : evwm_arrowed(handle,0); break;
	case 0x5032 : evwm_arrowed(handle,1); break;
	case 0x4800 : evwm_arrowed(handle,2); break;
	case 0x5000 : evwm_arrowed(handle,3); break;
	case 0x4B34 : evwm_arrowed(handle,4); break;
	case 0x4D36 : evwm_arrowed(handle,5); break;
	case 0x4B00 : evwm_arrowed(handle,6); break;
	case 0x4D00 : evwm_arrowed(handle,7); break;
	case 0x4700 : xoff = yoff = 0;
		      redraw = vslide = hslide = 1;
		      break;
	case 0x1C0D :
	case 0x720D : page_form(); break;
	case 0x4E2B :
	case 0x316e :
	case 0x314e :
	case 0x1B2B : next_page(1); break;
	case 0x1970 :
	case 0x1950 :
	case 0x4A2D :
	case 0x352D : next_page(-1); break;
	case 0x6100 : evwm_closed(handle); break;
	default     : break;
    }
}

static void acc_open(int id)
{
    if (id!=menu_id || menu_id<0 || wi_handle>0) return;
    init_window();
}

static void acc_close(void)
{
    if (menu_id<0) return;
    wi_handle = -1;
    exit_window();
}

void event_handler(void)
{
    int em[16];
    int ev_which;
    int ev_mox,ev_moy,ev_mokstate,ev_mobutton,ev_kreturn,ev_breturn;

    end_evhandler=0;

    do /* Event-Schleife */
    {
	if (wi_handle>0)
	{
	    if (redraw) evwm_redraw(wi_handle,NULL);
	    if (hslide) set_hslide();
	    if (vslide) set_vslide();
	    if (sizer) set_sizer();
	    if (info) set_info();
	}

	graf_mouse(0,0);
	/* Auf ein Ereignis warten */
	ev_which=evnt_multi(MU_MESAG|MU_KEYBD|MU_BUTTON,
	 1,1,1,0,0,0,0,0,0,0,0,0,0,em,0,0,
	 &ev_mox,&ev_moy,&ev_mobutton,&ev_mokstate,&ev_kreturn,&ev_breturn);

	/* Je nach Ereignis eine Funktion auswaehlen  */
	if (ev_which & MU_MESAG)
	{
	    switch(em[0])
	    {
		case AC_OPEN    : acc_open(em[4]); break;
		case AC_CLOSE   : acc_close(); break;
		case WM_REDRAW  : evwm_redraw(em[3],em+4); break;
		case WM_CLOSED  : evwm_closed(em[3]); break;
		case WM_VSLID   : evwm_vslid(em[3],em[4]); break;
		case WM_HSLID   : evwm_hslid(em[3],em[4]); break;
		case WM_MOVED   : evwm_moved(em[3],em+4); break;
		case WM_SIZED   : evwm_sized(em[3],em+4); break;
		case WM_FULLED  : evwm_fulled(em[3]); break;
		case WM_ARROWED : evwm_arrowed(em[3],em[4]); break;
		case WM_TOPPED  : evwm_topped(em[3]); break;
	    }
	}
	if (ev_which & MU_KEYBD) ev_key(ev_kreturn);
	if (ev_which & MU_BUTTON) 
	    ev_button(ev_mox, ev_moy, ev_mobutton, ev_mokstate, ev_breturn);

    } while (!end_evhandler);
}

int main(void)
{
    extern _app;

    if (!init_gem()) return -1;

    mono = Getrez()==2;

    if (_app)
    {
	init_rsrc();
	init_window();
	if (wi_handle>0) event_handler();
	exit_window();
    }
    else
    {
	menu_id = menu_register(appl_id,"  Display\0");
	if (menu_id>=0)
	{
	    init_rsrc();
	    while(1) event_handler();
	}
    }

    exit_gem();
    return 0;
}
