/*
* Copyright (c) 2024-2026, Intel Corporation
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
* THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
* OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*/
//!
//! \file     nvlMediaKernel_hevcbrc_init.h
//! \brief    File holds the Firmware for the media kernels for HuC
//! \details  File holds the Firmware for the media kernels for HuC which is 
//!           a programmable Microcontroller added to the VDBox pipeline.
//!

/* Media Kernel Version - 20250916 */

#pragma once


/*==========================================================================================================================================================
Kernel begins from here. Do not remove this comment.
==========================================================================================================================================================*/

const uint32_t __MediaKernels_hevcbrc_init_nvl [] = 
{
    0x00002000, 0x000000c0, 0x00002a80, 0x00000040,
    0x00002f80, 0x000020c0, 0x00002fc0, 0x00000940,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x672efcfa, 0x15010f66, 0x00002ac0, 0x66c0200f,
    0x6601c883, 0xffffff25, 0xc0220f9f, 0x00b800eb,
    0xb8c08e00, 0xe88e0028, 0x8e0010b8, 0x0018b8d8,
    0x20b8d08e, 0x66e08e00, 0x000080ea, 0x90000800,
    0x2ad0002f, 0x2e660000, 0x00841f0f, 0x00000000,
    0x00000000, 0x00000000, 0x2a802f80, 0x00409b00,
    0x000029fd, 0x00409300, 0x00002000, 0x00409300,
    0x0000ffdf, 0x00cf9302, 0x2a802f80, 0x00409300,
    0x001ffcbc, 0x0af6e800, 0xb8660000, 0xebf4dead,
    0xccccf4fd, 0x006afacf, 0x2ae9006a, 0xfa000001,
    0x016a006a, 0x000120e9, 0x006afa00, 0x16e9026a,
    0xfa000001, 0x036a006a, 0x00010ce9, 0x006afa00,
    0x02e9046a, 0xfa000001, 0x056a006a, 0x0000f8e9,
    0x006afa00, 0xeee9066a, 0xfa000000, 0x076a006a,
    0x0000e4e9, 0x086afa00, 0x0000dce9, 0x006afa00,
    0xd2e9096a, 0xfa000000, 0xcae90a6a, 0xfa000000,
    0xc2e90b6a, 0xfa000000, 0xbae90c6a, 0xfa000000,
    0xb2e90d6a, 0xfa000000, 0xaae90e6a, 0xfa000000,
    0x0f6a006a, 0x0000a0e9, 0x006afa00, 0x96e9106a,
    0xfa000000, 0x8ee9116a, 0xfa000000, 0x126a006a,
    0x000084e9, 0x006afa00, 0x7deb136a, 0x6a006afa,
    0xfa76eb14, 0x156a006a, 0x6afa6feb, 0xeb166a00,
    0x006afa68, 0x61eb176a, 0x6a006afa, 0xfa5aeb18,
    0x196a006a, 0x6afa53eb, 0xeb1a6a00, 0x006afa4c,
    0x45eb1b6a, 0x6a006afa, 0xfa3eeb1c, 0x1d6a006a,
    0x6afa37eb, 0xeb1e6a00, 0x006afa30, 0x29eb1f6a,
    0xd06860fa, 0xe8000000, 0x00000074, 0x6104c483,
    0x6a60facf, 0x0956e84c, 0xc4830000, 0xfacf6104,
    0xff68006a, 0xeb000000, 0x31e8600b, 0x61000000,
    0xcf08c483, 0x0056e860, 0x83610000, 0xcccf08c4,
    0x83e58955, 0xc76608ec, 0x07fff845, 0xc0fa45c7,
    0x0f000020, 0x83f85d01, 0xc35d08c4, 0xcccccccc,
    0x83e58955, 0x458b08ec, 0x084d8d28, 0xff240c89,
    0x28c08514, 0xc4830000, 0x90c35d08, 0x90909090,
    0x5de58955, 0x909090c3, 0x90909090, 0x90909090,
    0x5de58955, 0xccccccc3, 0xcccccccc, 0xcccccccc,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0xccccccc3, 0xcccccccc,
    0xb0e58955, 0xe6a1e6ff, 0x90c35d21, 0x90909090,
    0xb8e58955, 0x00020000, 0xe00380b9, 0x64c129fe,
    0xffff01c7, 0xe0b900ff, 0x29fee003, 0x01c764c1,
    0x00000001, 0xe00320b9, 0x64c129fe, 0x00d001c7,
    0xc35d0002, 0x90909090, 0x90909090, 0x90909090,
    0xb0e58955, 0xe6a1e6ff, 0x0000b821, 0x30b90002,
    0x29fee000, 0x098b64c1, 0xe000f0b9, 0x64c129fe,
    0x01ff01c7, 0xe0b90000, 0x29fee000, 0x01c764c1,
    0xffffffff, 0xe00080b9, 0x64c129fe, 0x000001c7,
    0x80b90000, 0x29fee003, 0x01c764c1, 0x00ffffff,
    0xe003e0b9, 0x64c129fe, 0x000101c7, 0x20b90000,
    0x29fee003, 0x01c764c1, 0x000200d0, 0xccccc35d,
    0x53e58955, 0x4d8b5657, 0x08458b10, 0x890c558b,
    0x03e783c7, 0x04be4574, 0x29000000, 0x89ce39fe,
    0x890277cf, 0x89f929f7, 0x74ff85c6, 0x90909009,
    0x4f461688, 0xcf89fa75, 0x7502efc1, 0x03e18327,
    0x0010840f, 0x90900000, 0x90909090, 0x90909090,
    0x49461688, 0x5f5efa75, 0x89c35d5b, 0xc1cf89c6,
    0xd97402ef, 0xc1c2b60f, 0xc38918e2, 0x0908e3c1,
    0xc1da09c2, 0xd00910e0, 0x90909090, 0x90909090,
    0xc6830689, 0xf8754f04, 0x8b08458b, 0xe1830c55,
    0xebbd7503, 0x909090c1, 0x90909090, 0x90909090,
    0x53e58955, 0x4d8b5657, 0x0c558b10, 0x8908458b,
    0x03e683d6, 0xe783c789, 0x75fe3903, 0x74f68559,
    0x0004bb6e, 0xf3290000, 0xcf89cb39, 0xdf890277,
    0xc689f929, 0x840fff85, 0x0000000e, 0x90909090,
    0x881ab60f, 0x4f42461e, 0xcf89f675, 0x0f02efc1,
    0x00001884, 0x90909000, 0x90909090, 0x90909090,
    0x1e891a8b, 0x8304c683, 0x754f04c2, 0x03e183f3,
    0x0c75c985, 0xc68914eb, 0x840fc985, 0x0000000a,
    0x881ab60f, 0x4942461e, 0x5f5ef675, 0x89c35d5b,
    0xc1cf89c6, 0xc87502ef, 0x9090d3eb, 0x90909090,
    0x53e58955, 0x4d8b5657, 0x0c558b10, 0x3908458b,
    0x8d7d76d0, 0xd6390834, 0xca017676, 0xe783d789,
    0x83f08903, 0xc73903e0, 0xff854875, 0xcf391e74,
    0x0277c889, 0xc129f889, 0x840fc085, 0x0000000c,
    0xff5ab60f, 0x4eff5e88, 0xf475484a, 0xe8c1c889,
    0x18840f02, 0x90000000, 0x90909090, 0x90909090,
    0x89fc7a8b, 0xc683fc7e, 0xfcc283fc, 0x83f17548,
    0xc98503e1, 0x0012840f, 0x90900000, 0x90909090,
    0xff42b60f, 0x4eff4688, 0xf475494a, 0x7aebf089,
    0xe683d689, 0x83c78903, 0xfe3903e7, 0xf6855875,
    0x04bb6d74, 0x29000000, 0x89cb39f3, 0x890277cf,
    0x89f929df, 0x0fff85c6, 0x00000d84, 0x90909000,
    0x881ab60f, 0x4f42461e, 0xcf89f675, 0x0f02efc1,
    0x00001884, 0x90909000, 0x90909090, 0x90909090,
    0x1e891a8b, 0x8304c683, 0x754f04c2, 0x03e183f3,
    0x0c75c985, 0xc68914eb, 0x840fc985, 0x0000000a,
    0x881ab60f, 0x4942461e, 0x5f5ef675, 0x89c35d5b,
    0xc1cf89c6, 0xc87502ef, 0x9090d3eb, 0x90909090,
    0x53e58955, 0x8b505657, 0xc985084d, 0x000002b8,
    0xdf840f00, 0x8b000000, 0xf6850c75, 0x00d4880f,
    0x558b0000, 0x76f23914, 0x83ca8960, 0x277403e2,
    0x000004bf, 0x39d72900, 0x77f289f7, 0x29fa8902,
    0x0fd285d6, 0x00000e84, 0x90909000, 0x90909090,
    0x410001c6, 0x89f9754a, 0x02eac1f2, 0x90900e74,
    0x000001c7, 0xc1830000, 0xf4754a04, 0x0f03e683,
    0x00008184, 0x90909000, 0x90909090, 0x90909090,
    0x410001c6, 0xebf9754e, 0x105d8b6d, 0xe083c889,
    0xbe237403, 0x00000004, 0xd639c629, 0x0277d089,
    0xc229f089, 0x840fc085, 0x0000000a, 0x90909090,
    0x48411988, 0xd089fa75, 0x0f02e8c1, 0x00002784,
    0xf3b60f00, 0xe7c1df89, 0xf0758918, 0x08f065c1,
    0x7d03f709, 0x10e6c1f0, 0x9090fe09, 0x90909090,
    0xc1833189, 0xf8754804, 0xe283c031, 0x90077403,
    0x4a411988, 0xc483fa75, 0x5b5f5e04, 0x9090c35d,
    0x53e58955, 0x4d8b5657, 0xb8c98508, 0x00000002,
    0x00f1840f, 0x7d8b0000, 0x0fff850c, 0x0000e688,
    0x10758b00, 0x840ff685, 0x00000080, 0x3914558b,
    0x897977fa, 0x03e083f0, 0xe783cf89, 0x75f83903,
    0x74c0854f, 0x0004bf25, 0xc7290000, 0xd089d739,
    0xf8890277, 0xc085c229, 0x000c840f, 0x90900000,
    0x881eb60f, 0x48464119, 0xd089f675, 0x0f02e8c1,
    0x00001884, 0x90909000, 0x90909090, 0x90909090,
    0x39893e8b, 0x8304c183, 0x754804c6, 0x03e283f3,
    0xd285c031, 0x006d840f, 0x90900000, 0x90909090,
    0x881eb60f, 0x4a464119, 0x5bebf675, 0xe283ca89,
    0xbe247403, 0x00000004, 0xfe39d629, 0x0277fa89,
    0xd729f289, 0x840fd285, 0x0000000b, 0x90909090,
    0x410001c6, 0x89f9754a, 0x02eac1fa, 0x90900e74,
    0x000001c7, 0xc1830000, 0xf4754a04, 0x0f03e783,
    0x00001284, 0x90909000, 0x90909090, 0x90909090,
    0x410001c6, 0x5ef9754f, 0xc35d5b5f, 0x90909090,
    0x57e58955, 0x08558b56, 0x02b8d285, 0x0f000000,
    0x00008284, 0x0c4d8b00, 0x7b78c985, 0x8510758b,
    0x8b1974f6, 0xcf39147d, 0xec831277, 0x52565704,
    0xfffc9be8, 0x10c483ff, 0x5bebc031, 0xe683d689,
    0xbf247403, 0x00000004, 0xcf39f729, 0x0277ce89,
    0xf129fe89, 0x840ff685, 0x0000000b, 0x90909090,
    0x420002c6, 0x89f9754e, 0x02eec1ce, 0x90900e74,
    0x000002c7, 0xc2830000, 0xf4754e04, 0x0f03e183,
    0x00001284, 0x90909000, 0x90909090, 0x90909090,
    0x420002c6, 0x5ef97549, 0xccc35d5f, 0xcccccccc,
    0xb8e58955, 0x00020000, 0x100100b9, 0x64c129ff,
    0x000101c7, 0x00b90000, 0x29ff1000, 0x0004bac1,
    0xc229ff10, 0x0002c764, 0x64000200, 0x100001c7,
    0x0cb90002, 0x29ff1000, 0x01c764c1, 0x00000000,
    0x100008b9, 0x64c129ff, 0x000001c7, 0x14b90000,
    0x29ff1000, 0x01c764c1, 0x00000000, 0x100010b9,
    0x64c129ff, 0x000001c7, 0x1cb90000, 0x29ff1000,
    0x01c764c1, 0x00000000, 0x100018b9, 0x64c129ff,
    0x000001c7, 0x24b90000, 0x29ff1000, 0x01c764c1,
    0x00000000, 0x100020b9, 0x64c129ff, 0x000001c7,
    0x2cb90000, 0x29ff1000, 0x01c764c1, 0x00000000,
    0x100028b9, 0x64c129ff, 0x000001c7, 0x34b90000,
    0x29ff1000, 0x01c764c1, 0x00000000, 0x100030b9,
    0x64c129ff, 0x000001c7, 0x3cb90000, 0x29ff1000,
    0x01c764c1, 0x00000000, 0x100038b9, 0x64c129ff,
    0x000001c7, 0x44b90000, 0x29ff1000, 0x01c764c1,
    0x00000000, 0x100040b9, 0x64c129ff, 0x000001c7,
    0x4cb90000, 0x29ff1000, 0x01c764c1, 0x00000000,
    0x100048b9, 0x64c129ff, 0x000001c7, 0x54b90000,
    0x29ff1000, 0x01c764c1, 0x00000000, 0x100050b9,
    0x64c129ff, 0x000001c7, 0x5cb90000, 0x29ff1000,
    0x01c764c1, 0x00000000, 0x100058b9, 0x64c129ff,
    0x000001c7, 0x64b90000, 0x29ff1000, 0x01c764c1,
    0x00000000, 0x100060b9, 0x64c129ff, 0x000001c7,
    0x6cb90000, 0x29ff1000, 0x01c764c1, 0x00000000,
    0x100068b9, 0x64c129ff, 0x000001c7, 0x74b90000,
    0x29ff1000, 0x01c764c1, 0x00000000, 0x100070b9,
    0x64c129ff, 0x000001c7, 0x7cb90000, 0x29ff1000,
    0x01c764c1, 0x00000000, 0x100078b9, 0x64c129ff,
    0x000001c7, 0xc35d0000, 0x90909090, 0x90909090,
    0x56e58955, 0x0005f650, 0x01000020, 0x9de80775,
    0xeb000000, 0x1a56e805, 0x758d0000, 0x56046af8,
    0x006a006a, 0x001be7e8, 0x10c48300, 0x6a56046a,
    0xe8006a00, 0x00001c78, 0x6a10c483, 0x006a5604,
    0xc9e8006a, 0x8300001b, 0x00b810c4, 0xb9000200,
    0xfee000b0, 0xc764c129, 0x00000001, 0x04c48300,
    0x90c35d5e, 0x90909090, 0x90909090, 0x90909090,
    0x83e58955, 0x55e808ec, 0xe8fffff6, 0xfffffda0,
    0xfff81be8, 0x0000b8ff, 0xb8b90002, 0x29ffe0d3,
    0x01c764c1, 0x0000004c, 0x90909090, 0x90909090,
    0xfcebf4fb, 0xcccccccc, 0xcccccccc, 0xcccccccc,
    0x53e58955, 0xe4835657, 0x80ec81c0, 0x8d000005,
    0x68402474, 0x00000500, 0x0068006a, 0x56000005,
    0xfffa9be8, 0x10c483ff, 0x001e13e8, 0xe8f18900,
    0x000008ec, 0xf5e8f189, 0x0f00000a, 0xf4248cb7,
    0x0f000003, 0xf62494b7, 0x8d000003, 0xb70f1104,
    0x03f824bc, 0xf8010000, 0x24b4b70f, 0x000003fa,
    0x0106448d, 0x00ffff3d, 0xb8057200, 0x0000ffff,
    0x24848966, 0x000003fc, 0x6b23d26b, 0xd10132c9,
    0x8dbf148d, 0xca019214, 0x8db60c8d, 0xf7648a4c,
    0x6a642464, 0x50525100, 0x002247e8, 0x10c48300,
    0xfa83c931, 0xf7c91901, 0xbac109d1, 0x00000064,
    0xe2f7c889, 0x6c248489, 0x71000001, 0x4005c607,
    0x01000029, 0x000032ba, 0xf7c88900, 0x248489e2,
    0x00000164, 0x05c60771, 0x00002940, 0x0023ba01,
    0xc8890000, 0x8489e2f7, 0x00016824, 0xc6077100,
    0x00294005, 0x84c70100, 0x00017024, 0x00000000,
    0xff856600, 0x19ba1974, 0x89000000, 0x89e2f7c8,
    0x01702484, 0x07710000, 0x294005c6, 0xc7010000,
    0x01742484, 0x00000000, 0x85660000, 0xba1974f6,
    0x00000014, 0xe2f7c889, 0x74248489, 0x71000001,
    0x4005c607, 0x01000029, 0x40244c8d, 0x000b4fe8,
    0x245c8b00, 0x245c8948, 0x245c896c, 0x2444c770,
    0x00000074, 0xfffb8100, 0x897fffff, 0xb80572d8,
    0x7fffffff, 0x9c248489, 0xc7000001, 0x01982484,
    0x00000000, 0x8c8a0000, 0x00043b24, 0x02f98000,
    0x448b1b75, 0xd8296824, 0xff3d1376, 0x727fffff,
    0xffffb805, 0x84897fff, 0x00019824, 0x244c8800,
    0x2484c714, 0x00000084, 0x00000000, 0x802484c7,
    0x00000000, 0x0f000000, 0xf62484b7, 0x0f000003,
    0xf4248cb7, 0x66000003, 0x1a244489, 0x89c0b70f,
    0x6b342444, 0x896623c0, 0x0f1c244c, 0x4c89c9b7,
    0xc96b3024, 0x0fc10132, 0xf82484b7, 0x89000003,
    0x8d2c2444, 0x048d8004, 0x0fc80180, 0xfa248cb7,
    0x89000003, 0x8d28244c, 0x4c8d890c, 0x748b6488,
    0xb70f6424, 0x03fc2484, 0x44890000, 0xe6f72024,
    0x5251006a, 0x20aae850, 0xc4830000, 0x83ff3110,
    0xff1901fa, 0xc709d7f7, 0x000064b9, 0xf7f88900,
    0x248489e1, 0x0000016c, 0x05c60771, 0x00002940,
    0x0032b901, 0xf8890000, 0xc189e1f7, 0x2444900f,
    0x24848924, 0x00000164, 0x05c60771, 0x00002940,
    0x0023ba01, 0xf8890000, 0x8489e2f7, 0x00016824,
    0xc6077100, 0x00294005, 0x84c70100, 0x00017024,
    0x00000000, 0x7c836600, 0x74002c24, 0x0019ba19,
    0xf8890000, 0x8489e2f7, 0x00017024, 0xc6077100,
    0x00294005, 0x84c70100, 0x00017424, 0x00000000,
    0x7c836600, 0x74002824, 0x0014ba19, 0xf8890000,
    0x8489e2f7, 0x00017424, 0xc6077100, 0x00294005,
    0xb70f0100, 0x661c2444, 0x6c248489, 0x0f000004,
    0x1a2444b7, 0x24848966, 0x0000046e, 0x64f7f089,
    0x84892024, 0x00047024, 0xc6077100, 0x00294005,
    0x448b0100, 0xc2894c24, 0xd339ead1, 0x94891173,
    0x00008824, 0x89d82900, 0x726c2444, 0x2923eb18,
    0x248489d8, 0x00000088, 0x05c61473, 0x00002940,
    0x24448901, 0x4005c66c, 0x01000029, 0x448904eb,
    0x8c896c24, 0x00047824, 0x248c8900, 0x0000047c,
    0x80248c89, 0x89000004, 0x0484248c, 0x8c890000,
    0x00048824, 0x247c8000, 0x07740024, 0x294005c6,
    0xc7010000, 0x018c2484, 0x00000000, 0x90a10000,
    0x88000020, 0x044d2484, 0xc1890000, 0x8802c180,
    0x044e248c, 0x83660000, 0x001a247c, 0xf8831b74,
    0x244c8a02, 0xfe167214, 0x248488c8, 0x0000044d,
    0x4e248488, 0xeb000004, 0x244c8a04, 0x94b60f14,
    0x00042624, 0xb4b60f00, 0x00042724, 0x24748900,
    0x89c98414, 0x741c2454, 0x05b60f39, 0x00002069,
    0x6a35b60f, 0x80000020, 0x4e7503f9, 0x143cd231,
    0x3cc3970f, 0xfffeb91e, 0x0677ffff, 0xdaf7da88,
    0xc101d189, 0x8b1df983, 0x7c1c2454, 0xfcc1830d,
    0xb60f26eb, 0x02708dc0, 0xf98320eb, 0x83057c1a,
    0x14ebfdc1, 0x7c17f983, 0xfec18305, 0xc0310aeb,
    0x0f12f983, 0xc129c09f, 0xb70fc889, 0x7cb70fca,
    0xf8391424, 0x1c7ffa89, 0xc839c289, 0x1a7dcb89,
    0xfa89fe39, 0xf2891c7f, 0x24247c89, 0xc889ce39,
    0x1aeb1a7d, 0xcb89c839, 0xd389e67c, 0xfa89fe39,
    0x7c89e47e, 0xce392424, 0x027cc889, 0x8488d089,
    0x00042c24, 0x24448900, 0x24848838, 0x00000431,
    0x0fff438d, 0x5c89f8b6, 0xc3813c24, 0x000000fd,
    0x8bf3b60f, 0x66142454, 0x5488d739, 0xc2891924,
    0xd0890677, 0x19245488, 0x20244c89, 0x24743b66,
    0x89047714, 0x8b14245c, 0x661c244c, 0xcb89cf39,
    0x3824448b, 0x5c8a0472, 0x4c8b1924, 0x39661c24,
    0x249c88ce, 0x0000042b, 0x4c8b0472, 0x8c881424,
    0x00042d24, 0x249c8800, 0x00000430, 0x32248c88,
    0x8b000004, 0x3924245c, 0x7fde89da, 0x8bd68902,
    0x3920244c, 0x7f3c244c, 0x0fce8902, 0x432494b6,
    0x83000004, 0x848804fa, 0x00043014, 0x14848800,
    0x0000042b, 0xfa802974, 0x8e850f03, 0x01000000,
    0x39fed1c6, 0x89027fde, 0x7cce39f3, 0x88d98902,
    0x0431248c, 0x8c880000, 0x00042c24, 0x8d6eeb00,
    0xc2017614, 0x8d02fac1, 0xf0014004, 0x3902f8c1,
    0x245c89da, 0x89287f14, 0x245489d6, 0x7ed83914,
    0x89ca3922, 0x8b247cca, 0x39142454, 0x249488c8,
    0x00000431, 0x2c249488, 0x7d000004, 0x3920eb20,
    0x89de7fd8, 0x89ca39c3, 0x39dc7dca, 0x249488c8,
    0x00000431, 0x2c249488, 0x7c000004, 0x88d98902,
    0x0433248c, 0x8c880000, 0x00042e24, 0x2484c600,
    0x0000042a, 0x84c766ff, 0x0003ec24, 0xc7000100,
    0x00942484, 0x00000000, 0x84c70000, 0x00009024,
    0x00000000, 0x2484c700, 0x0000008c, 0x00000000,
    0x282484c7, 0xff000001, 0xc7ffffff, 0x013c2484,
    0xffff0000, 0x84c7ffff, 0x00015024, 0xffffff00,
    0x2484c7ff, 0x0000012c, 0xffffffff, 0x402484c7,
    0xff000001, 0xc7ffffff, 0x01542484, 0xffff0000,
    0x84c7ffff, 0x00013024, 0xffffff00, 0x2484c7ff,
    0x00000144, 0xffffffff, 0x582484c7, 0xff000001,
    0xc7ffffff, 0x01342484, 0xffff0000, 0x84c7ffff,
    0x00014824, 0xffffff00, 0x2484c7ff, 0x0000015c,
    0xffffffff, 0x382484c7, 0xff000001, 0xc7ffffff,
    0x014c2484, 0xffff0000, 0x84c7ffff, 0x00016024,
    0xffffff00, 0x05b70fff, 0x00002070, 0x24848966,
    0x00000448, 0x002068a0, 0x24848800, 0x00000439,
    0x8805b70f, 0x66000020, 0x29248489, 0xa0000005,
    0x0000203f, 0x58248488, 0x0f000004, 0x208b05b7,
    0x89660000, 0x044f2484, 0x6ca10000, 0x89000020,
    0x04512484, 0x84c70000, 0x00041c24, 0x00010000,
    0x84c76601, 0x00042024, 0x8a00e000, 0x0443248c,
    0xc9fe0000, 0x000001bb, 0x66e3d300, 0x1a247c83,
    0x8b1c7400, 0x8b34244c, 0x01302444, 0x244403c8,
    0x2444032c, 0xf7d23128, 0x3c02b1f1, 0x840a7402,
    0x0fd989db, 0x0000eb84, 0x2484c600, 0x00000437,
    0x248c8810, 0x0000043a, 0xa02484c7, 0x00000003,
    0xc7000000, 0x039c2484, 0x00000000, 0x84c70000,
    0x0003a824, 0x00000000, 0x2484c700, 0x000003a4,
    0x00000000, 0xb02484c7, 0x00000003, 0xc7000000,
    0x03ac2484, 0x00000000, 0x84c70000, 0x0003b824,
    0x00000000, 0x2484c700, 0x000003b4, 0x00000000,
    0xc02484c7, 0x00000003, 0xc7000000, 0x03bc2484,
    0x00000000, 0x84c70000, 0x0003c824, 0x00000000,
    0x2484c700, 0x000003c4, 0x00000000, 0xd02484c7,
    0x00000003, 0xc7000000, 0x03cc2484, 0x00000000,
    0x84c70000, 0x0003d824, 0x00000000, 0x2484c700,
    0x000003d4, 0x00000000, 0xe02484c7, 0x00000003,
    0xc7000000, 0x03dc2484, 0x00000000, 0x84c70000,
    0x0003e824, 0x00000000, 0x2484c700, 0x000003e4,
    0x00000000, 0x9905b60f, 0x66000020, 0x7208f883,
    0x84896608, 0x00042424, 0x2072a100, 0x84890000,
    0x00051424, 0x2079a100, 0x84890000, 0x00051b24,
    0x2080a000, 0x84880000, 0x00052224, 0x2081a100,
    0x84890000, 0x00052324, 0x05b70f00, 0x00002076,
    0x24848966, 0x00000518, 0x7d05b70f, 0x66000020,
    0x1f248489, 0xa0000005, 0x00002085, 0x27248488,
    0xa0000005, 0x00002078, 0x1a248488, 0xa0000005,
    0x0000207f, 0x21248488, 0xa0000005, 0x00002086,
    0x28248488, 0x68000005, 0x00000500, 0x4424448d,
    0x6a006a50, 0x1456e800, 0xc4830000, 0x75c08510,
    0x8dc0310a, 0x5f5ef465, 0x83c35d5b, 0x00680cec,
    0xe8500000, 0x00001508, 0xeb10c483, 0x909090e4,
    0x53e58955, 0xec835657, 0x2004a114, 0x01890000,
    0x00209ca1, 0x04418900, 0x002008a1, 0xec458900,
    0xa1084189, 0x0000200c, 0x89e84589, 0x10a10c41,
    0x89000020, 0x4189e445, 0x2014a110, 0x45890000,
    0x144189e0, 0x002018a1, 0x18418900, 0x201c358b,
    0x71890000, 0x20158b1c, 0x89000020, 0xb70f2051,
    0x00202c1d, 0x80da8900, 0x91887fe2, 0x000003ae,
    0xeec0de88, 0xafb18807, 0x0f000003, 0x202e3db7,
    0x89660000, 0x0003b4b9, 0x05b70f00, 0x00002030,
    0xf2458966, 0xb6818966, 0x0f000003, 0x20323db7,
    0x89660000, 0x0003b0b9, 0x3db70f00, 0x00002034,
    0xb2b98966, 0x0f000003, 0x20363db7, 0x89660000,
    0x0003b8b9, 0x3db70f00, 0x00002038, 0xbab98966,
    0x8a000003, 0x00203a35, 0xe6b18800, 0x8a000003,
    0x00203b35, 0xe7b18800, 0x8a000003, 0x00203d35,
    0xe8b18800, 0x8a000003, 0x00203e35, 0xe9b18800,
    0x8a000003, 0x00203c35, 0x03b18800, 0x8a000004,
    0x0020a935, 0x74f68400, 0x3db70f1f, 0x000020aa,
    0xecb98966, 0xa0000004, 0x000020ac, 0x04f18188,
    0xb1880000, 0x00000404, 0x0020ada0, 0xf2818800,
    0x88000004, 0x0003fb91, 0x01e78000, 0x03f8b988,
    0x0e740000, 0x7189f601, 0xc607731c, 0x00294005,
    0xfa800100, 0x901d8b02, 0x75000020, 0x75db8545,
    0x851fbe41, 0x7d8b51eb, 0xf7f889ec, 0x03eac1e6,
    0x5189fa01, 0xe87d8b08, 0xe6f7f889, 0x0103eac1,
    0x0c5189fa, 0x89e47d8b, 0xc1e6f7f8, 0xfa0103ea,
    0x8b105189, 0xf889e07d, 0xeac1e6f7, 0x89fa0103,
    0x158a1451, 0x00002087, 0x69a0d284, 0x88000020,
    0x880274c4, 0xf0a188d4, 0x8a000003, 0x00206a15,
    0xf1918800, 0x88000003, 0x0003f281, 0x0d998800,
    0x89000004, 0x880204d8, 0x00040e81, 0x7d836600,
    0x137400f2, 0x7202fb83, 0x88cbfe0e, 0x00040d99,
    0x0e998800, 0x83000004, 0x5f5e14c4, 0x90c35d5b,
    0x53e58955, 0xec835657, 0x1c798b1c, 0x0974ff85,
    0x8920518b, 0x75d285d6, 0x1c41c718, 0x0000001e,
    0x012041c7, 0xbf000000, 0x0000001e, 0x000001be,
    0xf04d8900, 0x7d89db31, 0x31f889ec, 0x89f6f7d2,
    0xefd1e445, 0x4d8bf089, 0x1061f7f0, 0xd283f801,
    0xf04d8b00, 0x8924498b, 0x006ae84d, 0x52ec75ff,
    0x174ee850, 0xc4830000, 0x01fa8310, 0x00bef189,
    0x19000000, 0x09d6f7f6, 0xf0458bc6, 0x89247089,
    0xf04d8bc8, 0x011461f7, 0x00d283f8, 0x75ff006a,
    0xe85052ec, 0x0000171c, 0x8310c483, 0x558b01fa,
    0xf7db19e4, 0x8bc309d3, 0x5889f045, 0xf05d8b28,
    0x721efa83, 0x001eba05, 0x94a10000, 0x89000020,
    0xe84d0bc1, 0xc2890274, 0x04359388, 0xb60f0000,
    0xf7f889fa, 0x89c189e6, 0x00016883, 0xc6077100,
    0x00294005, 0xbb890100, 0x0000016c, 0x017883c7,
    0x00000000, 0x7d830000, 0x207500e8, 0x017083c7,
    0x00000000, 0xff850000, 0x838d1274, 0x0000026c,
    0x000000c7, 0xc0830000, 0xf4754f04, 0x9805b60f,
    0x83000020, 0x838865f8, 0x00000436, 0xc0832672,
    0x89e1f79c, 0x00017483, 0xc6077100, 0x00294005,
    0x1fb90100, 0xf751eb85, 0x05eac1e1, 0x01749389,
    0x0aeb0000, 0x017483c7, 0x00000000, 0xc4830000,
    0x5b5f5e1c, 0x9090c35d, 0x90909090, 0x90909090,
    0x53e58955, 0xec835657, 0xf04d890c, 0x0f10598b,
    0x20640dbe, 0xd8890000, 0xc789e1f7, 0x0f1ff9c1,
    0xc083cbaf, 0x0a348d32, 0x006ad111, 0x5051646a,
    0x00150fe8, 0x10c48300, 0xff6bff81, 0xf189ffff,
    0xc7cdd983, 0x0000ec45, 0x00b98000, 0x7c800000,
    0xb8c18902, 0xffffffcd, 0x45c7f839, 0x000031e8,
    0x0031b800, 0xf0190000, 0xffffffb8, 0x89027c7f,
    0xf04d8bc8, 0x00d88189, 0xbe0f0000, 0x00205c05,
    0xc1c18900, 0xe3f71ff9, 0xaf0fc789, 0x0a348dcb,
    0x1132c083, 0x6a006ad1, 0xe8505164, 0x000014a4,
    0x8110c483, 0xffff6bff, 0x83f189ff, 0x00b9cdd9,
    0x7c800000, 0xb8c18902, 0xffffffcd, 0x31b8f839,
    0x19000000, 0xffffb8f0, 0x027c7fff, 0x4d8bc889,
    0xb88189f0, 0x0f000000, 0x206005be, 0xc1890000,
    0xf71ff9c1, 0x0fc789e3, 0x348dcbaf, 0x32c0830a,
    0x006ad111, 0x5051646a, 0x001447e8, 0x10c48300,
    0xff6bff81, 0xf189ffff, 0xb9cdd983, 0x80000000,
    0xc189027c, 0xffffcdb8, 0xb8f839ff, 0x00000031,
    0xffb8f019, 0x7c7fffff, 0x8bc88902, 0x8189f04d,
    0x000000c8, 0x650dbe0f, 0x89000020, 0x89e1f7d8,
    0x1ff9c1c7, 0x8dcbaf0f, 0xc0830a34, 0x6ad11132,
    0x51646a00, 0x13eae850, 0xc4830000, 0x6bff8110,
    0x89ffffff, 0xcdd983f1, 0x000000b9, 0x89027c80,
    0xffcdb8c1, 0xf839ffff, 0x000031b8, 0xb8f01900,
    0x7fffffff, 0xc889027c, 0x89f04d8b, 0x0000dc81,
    0x05be0f00, 0x0000205d, 0xf9c1c189, 0x89e3f71f,
    0xcbaf0fc7, 0x830a348d, 0xd11132c0, 0x646a006a,
    0x8de85051, 0x83000013, 0xff8110c4, 0xffffff6b,
    0xd983f189, 0x0000b9cd, 0x027c8000, 0xcdb8c189,
    0x39ffffff, 0x0031b8f8, 0xf0190000, 0xffffffb8,
    0x89027c7f, 0xf04d8bc8, 0x00bc8189, 0xbe0f0000,
    0x00206105, 0xc1c18900, 0xe3f71ff9, 0xaf0fc789,
    0x0a348dcb, 0x1132c083, 0x6a006ad1, 0xe8505164,
    0x00001330, 0x8110c483, 0xffff6bff, 0x83f189ff,
    0x00b9cdd9, 0x7c800000, 0xb8c18902, 0xffffffcd,
    0x31b8f839, 0x19000000, 0xffffb8f0, 0x027c7fff,
    0x4d8bc889, 0xcc8189f0, 0x0f000000, 0x20660dbe,
    0xd8890000, 0xc789e1f7, 0x0f1ff9c1, 0x348dcbaf,
    0x32c0830a, 0x006ad111, 0x5051646a, 0x0012d3e8,
    0x10c48300, 0xff6bff81, 0xf189ffff, 0xb9cdd983,
    0x80000000, 0xc189027c, 0xffffcdb8, 0xb8f839ff,
    0x00000031, 0xffb8f019, 0x7c7fffff, 0x8bc88902,
    0x8189f04d, 0x000000e0, 0x5e05be0f, 0x89000020,
    0x1ff9c1c1, 0xc789e3f7, 0x8dcbaf0f, 0xc0830a34,
    0x6ad11132, 0x51646a00, 0x1276e850, 0xc4830000,
    0x6bff8110, 0x89ffffff, 0xcdd983f1, 0x000000b9,
    0x89027c80, 0xffcdb8c1, 0xf839ffff, 0x000031b8,
    0xb8f01900, 0x7fffffff, 0xc889027c, 0x89f04d8b,
    0x0000c081, 0x05be0f00, 0x00002062, 0xf9c1c189,
    0x89e3f71f, 0xcbaf0fc7, 0x830a348d, 0xd11132c0,
    0x646a006a, 0x19e85051, 0x83000012, 0xff8110c4,
    0xffffff6b, 0xd983f189, 0x0000b9cd, 0x027c8000,
    0xcdb8c189, 0x39ffffff, 0x0031b8f8, 0xf0190000,
    0xffffffb8, 0x89027c7f, 0xf04d8bc8, 0x00d08189,
    0xbe0f0000, 0x0020670d, 0xf7d88900, 0xc1c789e1,
    0xaf0f1ff9, 0x0a348dcb, 0x1132c083, 0x6a006ad1,
    0xe8505164, 0x000011bc, 0x8110c483, 0xffff6bff,
    0x83f189ff, 0x00b9cdd9, 0x7c800000, 0xb8c18902,
    0xffffffcd, 0x31b8f839, 0x19000000, 0xffffb8f0,
    0x027c7fff, 0x4d8bc889, 0xe48189f0, 0x0f000000,
    0x205f05be, 0xc1890000, 0xf71ff9c1, 0x0fc789e3,
    0x348dcbaf, 0x32c0830a, 0x006ad111, 0x5051646a,
    0x00115fe8, 0x10c48300, 0xff6bff81, 0xf189ffff,
    0xb9cdd983, 0x80000000, 0xc189027c, 0xffffcdb8,
    0xb8f839ff, 0x00000031, 0xffb8f019, 0x7c7fffff,
    0x8bc88902, 0x8189f04d, 0x000000c4, 0x6305be0f,
    0x89000020, 0x1ff9c1c1, 0xc789e3f7, 0x8dcbaf0f,
    0xc0830a34, 0x6ad11132, 0x51646a00, 0x1102e850,
    0xc4830000, 0x6bff8110, 0x89ffffff, 0xcdd983f1,
    0x000000b9, 0x89027c80, 0xffcdb8c1, 0xf839ffff,
    0x000031b8, 0xb8f01900, 0x7fffffff, 0xc889027c,
    0x89f04d8b, 0x0000d481, 0x0c798b00, 0x0272df39,
    0xbe0fdf89, 0x0020540d, 0xf7f88900, 0xc1c389e1,
    0xaf0f1ff9, 0x0a348dcf, 0x1132c083, 0x6a006ad1,
    0xe8505164, 0x0000109c, 0x8110c483, 0xffff6bfb,
    0x83f189ff, 0x00b9cdd9, 0x7c800000, 0xb8c18902,
    0xffffffcd, 0x31b8d839, 0x19000000, 0xffffb8f0,
    0x027c7fff, 0x4d8bc889, 0x988189f0, 0x0f000000,
    0x204405be, 0xc1890000, 0xf71ff9c1, 0x0fc389e7,
    0x348dcfaf, 0x32c0830a, 0x006ad111, 0x5051646a,
    0x00103fe8, 0x10c48300, 0xff6bfb81, 0xf189ffff,
    0xb9cdd983, 0x80000000, 0xc189027c, 0xffffcdb8,
    0xb8d839ff, 0x00000031, 0xffb8f019, 0x7c7fffff,
    0x8bc88902, 0x4189f04d, 0x05be0f58, 0x0000204c,
    0xf9c1c189, 0x89e7f71f, 0xcfaf0fc3, 0x830a348d,
    0xd11132c0, 0x646a006a, 0xe5e85051, 0x8300000f,
    0xfb8110c4, 0xffffff6b, 0xd983f189, 0x0000b9cd,
    0x027c8000, 0xcdb8c189, 0x39ffffff, 0x0031b8d8,
    0xf0190000, 0xffffffb8, 0x89027c7f, 0xf04d8bc8,
    0x0f784189, 0x20550dbe, 0xf8890000, 0xc389e1f7,
    0x0f1ff9c1, 0x348dcfaf, 0x32c0830a, 0x006ad111,
    0x5051646a, 0x000f8be8, 0x10c48300, 0xff6bfb81,
    0xf189ffff, 0xb9cdd983, 0x80000000, 0xc189027c,
    0xffffcdb8, 0xb8d839ff, 0x00000031, 0xffb8f019,
    0x7c7fffff, 0x8bc88902, 0x8189f04d, 0x0000009c,
    0x4505be0f, 0x89000020, 0x1ff9c1c1, 0xc389e7f7,
    0x8dcfaf0f, 0xc0830a34, 0x6ad11132, 0x51646a00,
    0x0f2ee850, 0xc4830000, 0x6bfb8110, 0x89ffffff,
    0xcdd983f1, 0x000000b9, 0x89027c80, 0xffcdb8c1,
    0xd839ffff, 0x000031b8, 0xb8f01900, 0x7fffffff,
    0xc889027c, 0x89f04d8b, 0xbe0f5c41, 0x00204d05,
    0xc1c18900, 0xe7f71ff9, 0xaf0fc389, 0x0a348dcf,
    0x1132c083, 0x6a006ad1, 0xe8505164, 0x00000ed4,
    0x8110c483, 0xffff6bfb, 0x83f189ff, 0x00b9cdd9,
    0x7c800000, 0xb8c18902, 0xffffffcd, 0x31b8d839,
    0x19000000, 0xffffb8f0, 0x027c7fff, 0x4d8bc889,
    0x7c4189f0, 0x560dbe0f, 0x89000020, 0x89e1f7f8,
    0x1ff9c1c3, 0x8dcfaf0f, 0xc0830a34, 0x6ad11132,
    0x51646a00, 0x0e7ae850, 0xc4830000, 0x6bfb8110,
    0x89ffffff, 0xcdd983f1, 0x000000b9, 0x89027c80,
    0xffcdb8c1, 0xd839ffff, 0x000031b8, 0xb8f01900,
    0x7fffffff, 0xc889027c, 0x89f04d8b, 0x0000a081,
    0x05be0f00, 0x00002046, 0xf9c1c189, 0x89e7f71f,
    0xcfaf0fc3, 0x830a348d, 0xd11132c0, 0x646a006a,
    0x1de85051, 0x8300000e, 0xfb8110c4, 0xffffff6b,
    0xd983f189, 0x0000b9cd, 0x027c8000, 0xcdb8c189,
    0x39ffffff, 0x0031b8d8, 0xf0190000, 0xffffffb8,
    0x89027c7f, 0xf04d8bc8, 0x0f604189, 0x204e05be,
    0xc1890000, 0xf71ff9c1, 0x0fc389e7, 0x348dcfaf,
    0x32c0830a, 0x006ad111, 0x5051646a, 0x000dc3e8,
    0x10c48300, 0xff6bfb81, 0xf189ffff, 0xb9cdd983,
    0x80000000, 0xc189027c, 0xffffcdb8, 0xb8d839ff,
    0x00000031, 0xffb8f019, 0x7c7fffff, 0x8bc88902,
    0x8189f04d, 0x00000080, 0x570dbe0f, 0x89000020,
    0x89e1f7f8, 0x1ff9c1c3, 0x8dcfaf0f, 0xc0830a34,
    0x6ad11132, 0x51646a00, 0x0d66e850, 0xc4830000,
    0x6bfb8110, 0x89ffffff, 0xcdd983f1, 0x000000b9,
    0x89027c80, 0xffcdb8c1, 0xd839ffff, 0x000031b8,
    0xb8f01900, 0x7fffffff, 0xc889027c, 0x89f04d8b,
    0x0000a481, 0x05be0f00, 0x00002047, 0xf9c1c189,
    0x89e7f71f, 0xcfaf0fc3, 0x830a348d, 0xd11132c0,
    0x646a006a, 0x09e85051, 0x8300000d, 0xfb8110c4,
    0xffffff6b, 0xd983f189, 0x0000b9cd, 0x027c8000,
    0xcdb8c189, 0x39ffffff, 0x0031b8d8, 0xf0190000,
    0xffffffb8, 0x89027c7f, 0xf04d8bc8, 0x0f644189,
    0x204f05be, 0xc1890000, 0xf71ff9c1, 0x0fc389e7,
    0x348dcfaf, 0x32c0830a, 0x006ad111, 0x5051646a,
    0x000cafe8, 0x10c48300, 0xff6bfb81, 0xf189ffff,
    0xb9cdd983, 0x80000000, 0xc189027c, 0xffffcdb8,
    0xb8d839ff, 0x00000031, 0xffb8f019, 0x7c7fffff,
    0x8bc88902, 0x8189f04d, 0x00000084, 0x580dbe0f,
    0x89000020, 0x89e1f7f8, 0x1ff9c1c3, 0x8dcfaf0f,
    0xc0830a34, 0x6ad11132, 0x51646a00, 0x0c52e850,
    0xc4830000, 0x6bfb8110, 0x89ffffff, 0xcdd983f1,
    0x000000b9, 0x89027c80, 0xffcdb8c1, 0xd839ffff,
    0x000031b8, 0xb8f01900, 0x7fffffff, 0xc889027c,
    0x89f04d8b, 0x0000a881, 0x05be0f00, 0x00002048,
    0xf9c1c189, 0x89e7f71f, 0xcfaf0fc3, 0x830a348d,
    0xd11132c0, 0x646a006a, 0xf5e85051, 0x8300000b,
    0xfb8110c4, 0xffffff6b, 0xd983f189, 0x0000b9cd,
    0x027c8000, 0xcdb8c189, 0x39ffffff, 0x0031b8d8,
    0xf0190000, 0xffffffb8, 0x89027c7f, 0xf04d8bc8,
    0x0f684189, 0x205005be, 0xc1890000, 0xf71ff9c1,
    0x0fc389e7, 0x348dcfaf, 0x32c0830a, 0x006ad111,
    0x5051646a, 0x000b9be8, 0x10c48300, 0xff6bfb81,
    0xf189ffff, 0xb9cdd983, 0x80000000, 0xc189027c,
    0xffffcdb8, 0xb8d839ff, 0x00000031, 0xffb8f019,
    0x7c7fffff, 0x8bc88902, 0x8189f04d, 0x00000088,
    0x590dbe0f, 0x89000020, 0x89e1f7f8, 0x1ff9c1c3,
    0x8dcfaf0f, 0xc0830a34, 0x6ad11132, 0x51646a00,
    0x0b3ee850, 0xc4830000, 0x6bfb8110, 0x89ffffff,
    0xcdd983f1, 0x000000b9, 0x89027c80, 0xffcdb8c1,
    0xd839ffff, 0x000031b8, 0xb8f01900, 0x7fffffff,
    0xc889027c, 0x89f04d8b, 0x0000ac81, 0x05be0f00,
    0x00002049, 0xf9c1c189, 0x89e7f71f, 0xcfaf0fc3,
    0x830a348d, 0xd11132c0, 0x646a006a, 0xe1e85051,
    0x8300000a, 0xfb8110c4, 0xffffff6b, 0xd983f189,
    0x0000b9cd, 0x027c8000, 0xcdb8c189, 0x39ffffff,
    0x0031b8d8, 0xf0190000, 0xffffffb8, 0x89027c7f,
    0xf04d8bc8, 0x0f6c4189, 0x205105be, 0xc1890000,
    0xf71ff9c1, 0x0fc389e7, 0x348dcfaf, 0x32c0830a,
    0x006ad111, 0x5051646a, 0x000a87e8, 0x10c48300,
    0xff6bfb81, 0xf189ffff, 0xb9cdd983, 0x80000000,
    0xc189027c, 0xffffcdb8, 0xb8d839ff, 0x00000031,
    0xffb8f019, 0x7c7fffff, 0x8bc88902, 0x8189f04d,
    0x0000008c, 0x5a0dbe0f, 0x89000020, 0x89e1f7f8,
    0x1ff9c1c3, 0x8dcfaf0f, 0xc0830a34, 0x6ad11132,
    0x51646a00, 0x0a2ae850, 0xc4830000, 0x6bfb8110,
    0x89ffffff, 0xcdd983f1, 0x000000b9, 0x89027c80,
    0xffcdb8c1, 0xd839ffff, 0x000031b8, 0xb8f01900,
    0x7fffffff, 0xc889027c, 0x89f04d8b, 0x0000b081,
    0x05be0f00, 0x0000204a, 0xf9c1c189, 0x89e7f71f,
    0xcfaf0fc3, 0x830a348d, 0xd11132c0, 0x646a006a,
    0xcde85051, 0x83000009, 0xfb8110c4, 0xffffff6b,
    0xd983f189, 0x0000b9cd, 0x027c8000, 0xcdb8c189,
    0x39ffffff, 0x0031b8d8, 0xf0190000, 0xffffffb8,
    0x89027c7f, 0xf04d8bc8, 0x0f704189, 0x205205be,
    0xc1890000, 0xf71ff9c1, 0x0fc389e7, 0x348dcfaf,
    0x32c0830a, 0x006ad111, 0x5051646a, 0x000973e8,
    0x10c48300, 0xff6bfb81, 0xf189ffff, 0xb9cdd983,
    0x80000000, 0xc189027c, 0xffffcdb8, 0xb8d839ff,
    0x00000031, 0xffb8f019, 0x7c7fffff, 0x8bc88902,
    0x8189f04d, 0x00000090, 0x5b0dbe0f, 0x89000020,
    0x89e1f7f8, 0x1ff9c1c3, 0x8dcfaf0f, 0xc0830a34,
    0x6ad11132, 0x51646a00, 0x0916e850, 0xc4830000,
    0x6bfb8110, 0x89ffffff, 0xcdd983f1, 0x000000b9,
    0x89027c80, 0xffcdb8c1, 0xd839ffff, 0x000031b8,
    0xb8f01900, 0x7fffffff, 0xc889027c, 0x89f04d8b,
    0x0000b481, 0x05be0f00, 0x0000204b, 0xf9c1c189,
    0x89e7f71f, 0xcfaf0fc3, 0x830a348d, 0xd11132c0,
    0x646a006a, 0xb9e85051, 0x83000008, 0xfb8110c4,
    0xffffff6b, 0xd983f189, 0x0000b9cd, 0x027c8000,
    0xcdb8c189, 0x39ffffff, 0x0031b8d8, 0xf0190000,
    0xffffffb8, 0x89027c7f, 0xf04d8bc8, 0x0f744189,
    0x205305be, 0xc1890000, 0xf71ff9c1, 0x0fc389e7,
    0x348dcfaf, 0x32c0830a, 0x006ad111, 0x5051646a,
    0x00085fe8, 0x10c48300, 0xff6bfb81, 0xf189ffff,
    0x7ccdd983, 0xec458903, 0xffffcdb8, 0x19d839ff,
    0xffb9e875, 0x7c7fffff, 0xec4d8b03, 0x89f0458b,
    0x00009488, 0x0cc48300, 0x5d5b5f5e, 0x909090c3,
    0x53e58955, 0xe4835657, 0x40ec81c0, 0xe8000005,
    0x0000046c, 0x0068e089, 0x50000005, 0x006a006a,
    0x0002bbe8, 0x10c48300, 0x850fc085, 0x00000144,
    0xf189e689, 0xffef27e8, 0xe8f189ff, 0xfffff130,
    0x248cb70f, 0x000003b4, 0x2494b70f, 0x000003b6,
    0x0f11048d, 0xb8249cb7, 0x01000003, 0xbcb70fd8,
    0x0003ba24, 0x07448d00, 0xffff3d01, 0x05720000,
    0x00ffffb8, 0x84896600, 0x0003bc24, 0x23d26b00,
    0x0132c96b, 0x9b148dd1, 0x0192148d, 0xbf0c8dca,
    0x648a4c8d, 0x242464f7, 0x5251006a, 0x0882e850,
    0xc4830000, 0x83c93110, 0xc91901fa, 0xc109d1f7,
    0x000064ba, 0xf7c88900, 0x248489e2, 0x0000012c,
    0x05c60771, 0x00002940, 0x0032ba01, 0xc8890000,
    0x8489e2f7, 0x00012424, 0xc6077100, 0x00294005,
    0x23ba0100, 0x89000000, 0x89e2f7c8, 0x01282484,
    0x07710000, 0x294005c6, 0xc7010000, 0x01302484,
    0x00000000, 0x85660000, 0xba1974db, 0x00000019,
    0xe2f7c889, 0x30248489, 0x71000001, 0x4005c607,
    0x01000029, 0x342484c7, 0x00000001, 0x66000000,
    0x1974ff85, 0x000014ba, 0xf7c88900, 0x248489e2,
    0x00000134, 0x05c60771, 0x00002940, 0xe8f18901,
    0xfffff18c, 0x00050068, 0x006a5600, 0x2de8006a,
    0x83000002, 0xc08510c4, 0xc0311f75, 0x5ef4658d,
    0xc35d5b5f, 0x680cec83, 0x50000000, 0x0002dfe8,
    0x10c48300, 0xfffea7e9, 0x0cec83ff, 0x00000068,
    0x02cae850, 0xc4830000, 0xcccfeb10, 0xcccccccc,
    0x53e58955, 0x4d8b5657, 0x0c7d8b14, 0x01085d8b,
    0xc60773cf, 0x00294005, 0xfb830100, 0x0002b80f,
    0x75770000, 0x8510558b, 0xbe6e74d2, 0x00020000,
    0x100000b8, 0x8bf029ff, 0x29849d34, 0xc6010000,
    0x03368b64, 0x29449d04, 0x8b640000, 0x0fde2918,
    0xfb81c092, 0x00020000, 0xc0843a72, 0xf7393675,
    0x000002b8, 0x2e870f00, 0x85000000, 0x1d840fc9,
    0x03000000, 0x00b80c5d, 0x29000200, 0x90f631c3,
    0x6433048d, 0x0489008b, 0x04c68332, 0xf072ce39,
    0x05ebc031, 0x000002b8, 0x5b5f5e00, 0x9090c35d,
    0x53e58955, 0x4d8b5657, 0x0c7d8b14, 0x01085d8b,
    0xc60773cf, 0x00294005, 0xfb830100, 0x0002b80f,
    0x75770000, 0x8510558b, 0xbe6e74d2, 0x00020000,
    0x100000b8, 0x8bf029ff, 0x29849d34, 0xc6010000,
    0x03368b64, 0x29449d04, 0x8b640000, 0x0fde2918,
    0xfb81c092, 0x00020000, 0xc0843a72, 0xf7393675,
    0x000002b8, 0x2e870f00, 0x85000000, 0x1d840fc9,
    0x03000000, 0x00b80c5d, 0x29000200, 0x90f631c3,
    0x8d32048b, 0x8964333c, 0x04c68307, 0xf072ce39,
    0x05ebc031, 0x000002b8, 0x5b5f5e00, 0x9090c35d,
    0x53e58955, 0x4d8b5657, 0x08458b14, 0x8b0c758b,
    0x29448514, 0x00bf0000, 0x29000200, 0x00c281fa,
    0x64ff1000, 0xfa893a8b, 0x920ff201, 0x72ce01c3,
    0x74db8404, 0x4005c607, 0x01000029, 0x8485048b,
    0xbb000029, 0x00020000, 0x0005d829, 0x64ff1000,
    0xfb29188b, 0x000002b8, 0x394a7200, 0x8b4677de,
    0x090f1045, 0x020000be, 0xd300bf00, 0xf729ffe0,
    0xba178964, 0xffe0d308, 0x8964f229, 0xd310b802,
    0xf029ffe0, 0xb8088964, 0xffe0d064, 0xc764f029,
    0x01800400, 0xd314b800, 0xf029ffe0, 0x0100c764,
    0x31000000, 0x5b5f5ec0, 0x9090c35d, 0x90909090,
    0x53e58955, 0x4d8b5657, 0x08458b14, 0x8b0c758b,
    0x29448514, 0x00bf0000, 0x29000200, 0x00c281fa,
    0x64ff1000, 0xfa893a8b, 0x920ff201, 0x72ce01c3,
    0x74db8404, 0x4005c607, 0x01000029, 0x8485048b,
    0xbb000029, 0x00020000, 0x0005d829, 0x64ff1000,
    0xfb29188b, 0x000002b8, 0x394a7200, 0x8b4677de,
    0x090f1045, 0x020000be, 0xd300bf00, 0xf729ffe0,
    0xba178964, 0xffe0d308, 0x8964f229, 0xd310b802,
    0xf029ffe0, 0xb8088964, 0xffe0d064, 0xc764f029,
    0x01800400, 0xd314b800, 0xf029ffe0, 0x0300c764,
    0x31000000, 0x5b5f5ec0, 0xccccc35d, 0xcccccccc,
    0x8be58955, 0xc0830845, 0xc0e08304, 0x5d40c083,
    0x909090c3, 0x90909090, 0x90909090, 0x90909090,
    0xb8e58955, 0x00020000, 0xe0d000b9, 0x64c129ff,
    0x450b018b, 0x01896408, 0x9090c35d, 0x90909090,
    0xb8e58955, 0x00020000, 0xe0d000b9, 0x64c129ff,
    0xff25018b, 0x6400ffff, 0xc35d0189, 0x90909090,
    0x56e58955, 0x8b08558b, 0x4ab60f32, 0xc1c88908,
    0x048a03e8, 0xfecc8806, 0x086288c4, 0x7508fc80,
    0x0842c607, 0x32894600, 0xe180d1f6, 0x24e8d207,
    0xc35d5e01, 0x90909090, 0x90909090, 0x90909090,
    0x53e58955, 0xf608458b, 0x74010c45, 0xb1108b10,
    0x08482a07, 0x000001bb, 0x08e3d300, 0x08488a1a,
    0x4888c1fe, 0x08f98008, 0x088b3975, 0x502bca89,
    0x02fa8304, 0x7980207c, 0x1a7500fe, 0x00ff7980,
    0x118a1475, 0x7703fa80, 0x0151880d, 0x01c6088b,
    0x41088b03, 0x518d0889, 0xc6108901, 0xc6000141,
    0x5b000840, 0x9090c35d, 0x90909090, 0x90909090,
    0x53e58955, 0x458b5657, 0x0fc08510, 0x0000a984,
    0x0c558b00, 0xe908758b, 0x00000018, 0x90909090,
    0x8901798d, 0x0141c63a, 0x0842c600, 0x840f4800,
    0x00000086, 0xb60f3e8b, 0xcb89084e, 0x0f03ebc1,
    0x881f1cb6, 0x88c7fecf, 0xff80087e, 0xc6077508,
    0x47000846, 0xd1f63e89, 0x0f07e180, 0xb60ffbb6,
    0xcfa30fc9, 0x3a8b1073, 0x4a2a07b1, 0x0001bb08,
    0xe3d30000, 0xb60f1f08, 0xc1fe084a, 0x80084a88,
    0xa97508f9, 0xcf890a8b, 0x83047a2b, 0x907c02ff,
    0x00fe7980, 0x79808a75, 0x847500ff, 0x8019b60f,
    0x870f03fb, 0xffffff78, 0x8b015988, 0x0301c60a,
    0x89410a8b, 0xff66e90a, 0x5f5effff, 0x90c35d5b,
    0x53e58955, 0x458b5657, 0x880f4810, 0x00000072,
    0x8b0c558b, 0x15e90875, 0x90000000, 0x90909090,
    0x8901798d, 0x0141c63e, 0x0846c600, 0x52784800,
    0x73c2a30f, 0xb13e8b10, 0x084e2a07, 0x000001bb,
    0x08e3d300, 0x4eb60f1f, 0x88c1fe08, 0xf980084e,
    0x8bda7508, 0x2bcf890e, 0xff83047e, 0x80c17c02,
    0x7500fe79, 0xff7980bb, 0x0fb57500, 0xfb8019b6,
    0x88ad7703, 0x0e8b0159, 0x8b0301c6, 0x0e89410e,
    0x5f5e9eeb, 0x90c35d5b, 0x90909090, 0x90909090,
    0x53e58955, 0xec835657, 0x087d8b08, 0x420c558b,
    0xffffffb9, 0xb91c747f, 0xffffffff, 0x9090d089,
    0x8541f8d1, 0x81f975c0, 0xffffffe1, 0xf4840f7f,
    0x89000000, 0xffbef055, 0xd3ffffff, 0xec4d89e6,
    0xe901598d, 0x0000001c, 0x90909090, 0x90909090,
    0x8901418d, 0x0141c607, 0x0847c600, 0x4bd23100,
    0x527edb85, 0x7501fb83, 0xb1178b10, 0x084f2a07,
    0x000001b8, 0x08e0d300, 0x57b60f02, 0x88c2fe08,
    0xfa800857, 0x8bd87508, 0x2bc8890f, 0xf8830447,
    0x80bd7c02, 0x7500fe79, 0xff7980b7, 0x0fb17500,
    0xfa8011b6, 0x88a97703, 0x078b0151, 0x8b0300c6,
    0x0f89410f, 0x75039aeb, 0xec5d8bf0, 0x9017eb4b,
    0x8901418d, 0x0141c607, 0x0847c600, 0x4bd23100,
    0x00a6880f, 0xa30f0000, 0x8b1373de, 0x2807b107,
    0x0001bad1, 0xe2d30000, 0xb60f1008, 0xc2fe0857,
    0x80085788, 0xd77508fa, 0xc8890f8b, 0x8304472b,
    0xbc7c02f8, 0x00fe7980, 0x7980b675, 0xb07500ff,
    0x8011b60f, 0xa87703fa, 0x8b015188, 0x0300c607,
    0x89410f8b, 0x8b99eb0f, 0x2a07b107, 0x01ba084f,
    0xd3000000, 0x8a1008e2, 0xc0fe0847, 0x3c084788,
    0x8b397508, 0x2bc18907, 0xf983044f, 0x80207c02,
    0x7500fe78, 0xff78801a, 0x8a147500, 0x03f98008,
    0x48880d77, 0xc6078b01, 0x078b0300, 0x8d078940,
    0x0f890148, 0x000140c6, 0x000847c6, 0x5e08c483,
    0xc35d5b5f, 0x24548b56, 0x24448b14, 0xc1d18910,
    0xc8311ff9, 0xc829ca31, 0x5489ca19, 0x44891424,
    0xce891024, 0x0c24548b, 0x0824448b, 0xf9c1d189,
    0x31c8311f, 0x19c829ca, 0x245489ca, 0x2444890c,
    0x53ce3108, 0x18245c8b, 0x0fcbbd0f, 0x00008f84,
    0x24448b00, 0xd1e8d314, 0xd3d1f7e8, 0x8bc309e3,
    0x8b102454, 0x390c2444, 0xf73773da, 0xd1f757f3,
    0xe8d3e8d1, 0x64f7c789, 0x5c8b1824, 0x4c8b1024,
    0xc3291424, 0x448bd119, 0xaf0f1c24, 0x83c129c7,
    0xd23100df, 0xf001f889, 0xf031f211, 0x5b5ff231,
    0xda29c35e, 0xf757f3f7, 0x0de8d1d1, 0x80000000,
    0xc789e8d3, 0x182464f7, 0x10245c8b, 0x14244c8b,
    0xd119c329, 0x1c24448b, 0x29c7af0f, 0x00df83c1,
    0xf889d231, 0xf211f001, 0xf231f031, 0xc35e5b5f,
    0x1024448b, 0x14244c8b, 0xf1f7d231, 0x448bc389,
    0xf1f70c24, 0xf001da89, 0xf031f211, 0x5e5bf231,
    0xccccccc3, 0x245c8b53, 0xcbbd0f14, 0x448b7d74,
    0xe8d31024, 0xd1f7e8d1, 0xc309e3d3, 0x0c24548b,
    0x0824448b, 0x2e73da39, 0xf757f3f7, 0xd3e8d1d1,
    0xf7c789e8, 0x8b142464, 0x8b0c245c, 0x2910244c,
    0x8bd119c3, 0x0f182444, 0xc129c7af, 0x3100df83,
    0x5ff889d2, 0xda29c35b, 0xf757f3f7, 0x0de8d1d1,
    0x80000000, 0xc789e8d3, 0x142464f7, 0x0c245c8b,
    0x10244c8b, 0xd119c329, 0x1824448b, 0x29c7af0f,
    0x00df83c1, 0xf889d231, 0x8bc35b5f, 0x8b0c2444,
    0x3110244c, 0x89f1f7d2, 0x24448bc3, 0x89f1f708,
    0xccc35bda, 0xcccccccc, 0xcccccccc, 0xcccccccc,
    0xcccccccc, 0xcccccccc, 0xcccccccc, 0xcccccccc,
    0xcccccccc, 0xcccccccc, 0xcccccccc, 0xcccccccc,
    0xcccccccc, 0xcccccccc, 0xcccccccc, 0xcccccccc,
    0x00080095, 0x00008e00, 0x0008009f, 0x00008e00,
    0x000800a9, 0x00008e00, 0x000800b3, 0x00008e00,
    0x000800bd, 0x00008e00, 0x000800c7, 0x00008e00,
    0x000800d1, 0x00008e00, 0x000800db, 0x00008e00,
    0x000800e5, 0x00008e00, 0x000800ed, 0x00008e00,
    0x000800f7, 0x00008e00, 0x000800ff, 0x00008e00,
    0x00080107, 0x00008e00, 0x0008010f, 0x00008e00,
    0x00080117, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080129, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x000801b1, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x000801a0, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x000801bf, 0x00008e00,
    0x00000250, 0x00000260, 0x00000280, 0x00000270,
    0x00000290, 0x000002a0, 0x000002b0, 0x000002c0,
    0x000002d0, 0x000002e0, 0x000002f0, 0x00000300,
    0x00000310, 0x00000320, 0x00000330, 0x00000080,
    0x00000350, 0x00000080, 0x00000080, 0x00000080,
    0x00000080, 0x00000080, 0x00000080, 0x00000080,
    0x00000080, 0x00000080, 0x00000080, 0x00000080,
    0x00000080, 0x00000080, 0x00000080, 0x00000080,
    0x00000000, 0x00000004, 0x0000000c, 0x00000014,
    0x0000001c, 0x00000024, 0x0000002c, 0x00000034,
    0x0000003c, 0x00000044, 0x0000004c, 0x00000054,
    0x0000005c, 0x00000064, 0x0000006c, 0x00000074,
    0x0000007c, 0x00000000, 0x00000008, 0x00000010,
    0x00000018, 0x00000020, 0x00000028, 0x00000030,
    0x00000038, 0x00000040, 0x00000048, 0x00000050,
    0x00000058, 0x00000060, 0x00000068, 0x00000070,
    0x00000078, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000
};
