// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// RUN: %clang_cc1  -std=c++23 -triple aarch64-none-linux-gnu -target-feature +sve \
// RUN:   -target-feature +bf16 -target-feature +sve -target-feature +sme -target-feature +sme2 -target-feature +sve2 -target-feature +neon -Waarch64-sme-attributes -fsyntax-only -verify %s

// REQUIRES: aarch64-registered-target

#include "arm_neon.h"
#include "arm_sme.h"
#include "arm_sve.h"

int16x8_t incompat_neon_sm(int16x8_t splat) __arm_streaming {
  // expected-error@+1 {{builtin can only be called from a non-streaming function}}
  return (int16x8_t)__builtin_neon_vqaddq_v((int8x16_t)splat, (int8x16_t)splat, 33);
}

__arm_locally_streaming int16x8_t incompat_neon_ls(int16x8_t splat) {
  // expected-error@+1 {{builtin can only be called from a non-streaming function}}
  return (int16x8_t)__builtin_neon_vqaddq_v((int8x16_t)splat, (int8x16_t)splat, 33);
}

int16x8_t incompat_neon_smc(int16x8_t splat) __arm_streaming_compatible {
  // expected-error@+1 {{builtin can only be called from a non-streaming function}}
  return (int16x8_t)__builtin_neon_vqaddq_v((int8x16_t)splat, (int8x16_t)splat, 33);
}

void incompat_sme_smc(svbool_t pg, void const *ptr) __arm_streaming_compatible __arm_inout("za") {
  // expected-error@+1 {{builtin can only be called from a streaming function}}
  return __builtin_sme_svld1_hor_za128(0, 0, pg, ptr);
}

float incomp_sve_sm_fadda_sm(void) __arm_streaming {
  // expected-error@+1 {{builtin can only be called from a non-streaming function}}
  return svadda(svptrue_b32(), 0, svdup_f32(1));
}

float incomp_sve_sm_fadda_smc(void) __arm_streaming_compatible {
  // expected-error@+1 {{builtin can only be called from a non-streaming function}}
  return svadda(svptrue_b32(), 0, svdup_f32(1));
}

svuint32_t incompat_sve_sm(svbool_t pg, svuint32_t a, int16_t b) __arm_streaming {
  // expected-error@+1 {{builtin can only be called from a non-streaming function}}
  return __builtin_sve_svld1_gather_u32base_index_u32(pg, a, b);
}

// expected-warning@+2 {{returning a VL-dependent argument from a locally streaming function is undefined behaviour when the streaming and non-streaming vector lengths are different at runtime}}
// expected-warning@+1 {{passing a VL-dependent argument to a locally streaming function is undefined behaviour when the streaming and non-streaming vector lengths are different at runtime}}
__arm_locally_streaming svuint32_t incompat_sve_ls(svbool_t pg, svuint32_t a, int64_t b) {
  // expected-error@+1 {{builtin can only be called from a non-streaming function}}
  return __builtin_sve_svld1_gather_u32base_index_u32(pg, a, b);
}

svuint32_t incompat_sve_smc(svbool_t pg, svuint32_t a, int64_t b) __arm_streaming_compatible {
  // expected-error@+1 {{builtin can only be called from a non-streaming function}}
  return __builtin_sve_svld1_gather_u32base_index_u32(pg, a, b);
}

svuint32_t incompat_sve2_sm(svbool_t pg, svuint32_t a, int64_t b) __arm_streaming {
  // expected-error@+1 {{builtin can only be called from a non-streaming function}}
  return __builtin_sve_svldnt1_gather_u32base_index_u32(pg, a, b);
}

// expected-warning@+2 {{returning a VL-dependent argument from a locally streaming function is undefined behaviour when the streaming and non-streaming vector lengths are different at runtime}}
// expected-warning@+1 {{passing a VL-dependent argument to a locally streaming function is undefined behaviour when the streaming and non-streaming vector lengths are different at runtime}}
__arm_locally_streaming svuint32_t incompat_sve2_ls(svbool_t pg, svuint32_t a, int64_t b) {
  // expected-error@+1 {{builtin can only be called from a non-streaming function}}
  return __builtin_sve_svldnt1_gather_u32base_index_u32(pg, a, b);
}

svuint32_t incompat_sve2_smc(svbool_t pg, svuint32_t a, int64_t b) __arm_streaming_compatible {
  // expected-error@+1 {{builtin can only be called from a non-streaming function}}
  return __builtin_sve_svldnt1_gather_u32base_index_u32(pg, a, b);
}

void incompat_sme_sm(svbool_t pn, svbool_t pm, svfloat32_t zn, svfloat32_t zm) __arm_inout("za") {
  // expected-error@+1 {{builtin can only be called from a streaming function}}
  svmops_za32_f32_m(0, pn, pm, zn, zm);
}

svfloat64_t streaming_caller_sve(svbool_t pg, svfloat64_t a, float64_t b) __arm_streaming {
  return svadd_n_f64_m(pg, a, b);
}

// expected-warning@+2 {{returning a VL-dependent argument from a locally streaming function is undefined behaviour when the streaming and non-streaming vector lengths are different at runtime}}
// expected-warning@+1 {{passing a VL-dependent argument to a locally streaming function is undefined behaviour when the streaming and non-streaming vector lengths are different at runtime}}
__arm_locally_streaming svfloat64_t locally_streaming_caller_sve(svbool_t pg, svfloat64_t a, float64_t b) {
  return svadd_n_f64_m(pg, a, b);
}

svfloat64_t streaming_compatible_caller_sve(svbool_t pg, svfloat64_t a, float64_t b) __arm_streaming_compatible {
  return svadd_n_f64_m(pg, a, b);
}

svint16_t streaming_caller_sve2(svint16_t op1, svint16_t op2) __arm_streaming {
  return svmul_lane_s16(op1, op2, 0);
}

// expected-warning@+2 {{returning a VL-dependent argument from a locally streaming function is undefined behaviour when the streaming and non-streaming vector lengths are different at runtime}}
// expected-warning@+1 {{passing a VL-dependent argument to a locally streaming function is undefined behaviour when the streaming and non-streaming vector lengths are different at runtime}}
__arm_locally_streaming svint16_t locally_streaming_caller_sve2(svint16_t op1, svint16_t op2) {
  return svmul_lane_s16(op1, op2, 0);
}

svint16_t streaming_compatible_caller_sve2(svint16_t op1, svint16_t op2) __arm_streaming_compatible {
  return svmul_lane_s16(op1, op2, 0);
}

svbool_t streaming_caller_ptrue(void) __arm_streaming {
  return svand_z(svptrue_b16(), svptrue_pat_b16(SV_ALL), svptrue_pat_b16(SV_VL4));
}

svint8_t missing_za(svint8_t zd, svbool_t pg, uint32_t slice_base) __arm_streaming {
  // expected-warning@+1 {{builtin call is not valid when calling from a function without active ZA state}}
    return svread_hor_za8_s8_m(zd, pg, 0, slice_base);
}

__arm_new("za")
svint8_t new_za(svint8_t zd, svbool_t pg, uint32_t slice_base) __arm_streaming {
    return svread_hor_za8_s8_m(zd, pg, 0, slice_base);
}

void missing_zt0(void) __arm_streaming {
  // expected-warning@+1 {{builtin call is not valid when calling from a function without active ZT0 state}}
  svzero_zt(0);
}

__arm_new("zt0")
void new_zt0(void) __arm_streaming { svzero_zt(0); }

/// C++ lambda tests:

void use_streaming_builtin_in_lambda(uint32_t slice_base, svbool_t pg, const void *ptr) __arm_streaming __arm_out("za")
{
  [&]{
    /// The lambda is its own function and does not inherit the SME attributes (so this should error).
    // expected-error@+1 {{builtin can only be called from a streaming function}}
    svld1_hor_za64(0, slice_base, pg, ptr);
  }();
}

void use_streaming_builtin(uint32_t slice_base, svbool_t pg, const void *ptr) __arm_streaming __arm_out("za")
{
  /// Without the lambda the same builtin is okay (as the SME attributes apply).
  svld1_hor_za64(0, slice_base, pg, ptr);
}

int16x8_t use_neon_builtin_sm(int16x8_t splat) __arm_streaming_compatible {
  // expected-error@+1 {{builtin can only be called from a non-streaming function}}
  return (int16x8_t)__builtin_neon_vqaddq_v((int8x16_t)splat, (int8x16_t)splat, 33);
}

int16x8_t use_neon_builtin_sm_in_lambda(int16x8_t splat) __arm_streaming_compatible {
  return [&]{
    /// This should not error (as we switch out of streaming mode to execute the lambda).
    /// Note: The result int16x8_t is spilled and reloaded as a q-register.
    return (int16x8_t)__builtin_neon_vqaddq_v((int8x16_t)splat, (int8x16_t)splat, 33);
  }();
}

float use_incomp_sve_builtin_sm() __arm_streaming {
  // expected-error@+1 {{builtin can only be called from a non-streaming function}}
  return svadda(svptrue_b32(), 0, svdup_f32(1));
}

float incomp_sve_sm_fadda_sm_in_lambda(void) __arm_streaming {
  return [&]{
    /// This should work like the Neon builtin.
    return svadda(svptrue_b32(), 0, svdup_f32(1));
  }();
}

void use_streaming_builtin_in_streaming_lambda(uint32_t slice_base, const void *ptr)
{
  [&]  __arm_new("za") () __arm_streaming {
    // Here the lambda is streaming with ZA state, so this is okay.
    svld1_hor_za64(0, slice_base, svptrue_b64(), ptr);
  }();
}

int16x8_t use_neon_builtin_in_streaming_lambda(int16x8_t splat) {
  return [&]() __arm_streaming_compatible {
    /// This should error as the lambda is streaming-compatible.
    // expected-error@+1 {{builtin can only be called from a non-streaming function}}
    return (int16x8_t)__builtin_neon_vqaddq_v((int8x16_t)splat, (int8x16_t)splat, 33);
  }();
}

float incomp_sve_fadda_in_streaming_lambda(void) {
  return [&]() __arm_streaming {
    // Should error (like the Neon case above).
    // expected-error@+1 {{builtin can only be called from a non-streaming function}}
    return svadda(svptrue_b32(), 0, svdup_f32(1));
  }();
}
