var gLastFolderWasAOL = false;
var gViewPosElement;
var gAOLMailToolbar;
var gAOLMailForLabel;
var gNextButton;
var gPrevButton;
var gKeepAsNewButton;
var gStatusButton;
var gUnsendButton;
var gMailWindowExtrasOverlayBundle;
var gObserverService = Components.classes["@mozilla.org/observer-service;1"].getService(Components.interfaces.nsIObserverService); 

function MsgKeepAsNew()
{
  MarkSelectedMessagesRead(false);

  if (IsSpecialFolder(gDBView.msgFolder, MSG_FOLDER_FLAG_TRASH)) {
    gDBView.doCommand(nsMsgViewCommandType.undeleteMsg);
  }
 
}

var gMsgUnsendUrlListener = {
    OnStartRunningUrl: function(url)
    {
    },

    OnStopRunningUrl: function(url, aExitCode)
    {
        if (!gMailWindowExtrasOverlayBundle)
          gMailWindowExtrasOverlayBundle = document.getElementById("bundle_mailwindowextrasoverlay");

        var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"].getService(Components.interfaces.nsIPromptService);
        var unsentTitle;
        var unsentText;

        if (aExitCode == 0) {
          var imapUrl = url.QueryInterface(Components.interfaces.nsIImapUrl);
          if (imapUrl)
          {
            var unsendResponse = imapUrl.customCommandResult;
            if (unsendResponse.length)
            {
              unsentTitle = gMailWindowExtrasOverlayBundle.getString("unsentTitleError");
              unsentText = unsendResponse;
            }
            else
            {
              unsentTitle = gMailWindowExtrasOverlayBundle.getString("unsentTitle");
              unsentText = gMailWindowExtrasOverlayBundle.getString("unsentText");
            }
          }
        }
        if (!unsentTitle) // if we haven't set this yet, must be an unknown error
        {
          unsentTitle = gMailWindowExtrasOverlayBundle.getString("unsentTitleError");
          unsentText = gMailWindowExtrasOverlayBundle.getString("unsentTextError");
        }
        promptService.alert(window, unsentTitle, unsentText);
    }
};

function MsgUnsend()
{
    var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"].getService(Components.interfaces.nsIPromptService);
    if (!gMailWindowExtrasOverlayBundle)
      gMailWindowExtrasOverlayBundle = document.getElementById("bundle_mailwindowextrasoverlay");

    var confirmUnsendTitle = gMailWindowExtrasOverlayBundle.getString("confirmUnsendTitle");
    var confirmUnsendText = gMailWindowExtrasOverlayBundle.getString("confirmUnsendText");

    if (!promptService.confirm(window, confirmUnsendTitle, confirmUnsendText))
       return;

    var folder = GetLoadedMsgFolder();

    if(folder)
    {
      var imapFolder = folder.QueryInterface(Components.interfaces.nsIMsgImapMailFolder);
      if (imapFolder)
      {
          var messageUri = GetFirstSelectedMessage();
          var msgHdr = messenger.messageServiceFromURI(messageUri).messageURIToMsgHdr(messageUri)
          var imapUrlResult = imapFolder.issueCommandOnMsgs("XAOL-UNSEND", msgHdr.messageKey, msgWindow);
          if (imapUrlResult)
          {
            var mailnewsUrl = imapUrlResult.QueryInterface(Components.interfaces.nsIMsgMailNewsUrl);
            if (mailnewsUrl)
              mailnewsUrl.RegisterListener(gMsgUnsendUrlListener);
          }
      }
    }
}

const nsIScriptableDateFormat = Components.interfaces.nsIScriptableDateFormat;
var dateService = Components.classes["@mozilla.org/intl/scriptabledateformat;1"].getService(nsIScriptableDateFormat);

var gMsgStatusUrlListener = {
    OnStartRunningUrl: function(url)
    {
    },

    OnStopRunningUrl: function(url, aExitCode)
    {
      var imapUrl = url.QueryInterface(Components.interfaces.nsIImapUrl);
      if (imapUrl)
      {
        if (!gMailWindowExtrasOverlayBundle)
          gMailWindowExtrasOverlayBundle = document.getElementById("bundle_mailwindowextrasoverlay");

        var statusString = imapUrl.customAttributeResult;
        var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"].getService(Components.interfaces.nsIPromptService);
        var messageUri = GetFirstSelectedMessage();
        var msgHdr = messenger.messageServiceFromURI(messageUri).messageURIToMsgHdr(messageUri)
        var date = new Date();
        // PRTime is in microseconds, Javascript time is in seconds
        // so divide by 1000 when converting
        date.setTime(msgHdr.date / 1000);
        var dateStr = dateService.FormatDateTime("", dateService.dateFormatLong, dateService.timeFormatSeconds, date.getFullYear(), date.getMonth()+1, date.getDate(), date.getHours(), date.getMinutes(), date.getSeconds());
        var messageStatusStr = gMailWindowExtrasOverlayBundle.getFormattedString("StatusStrSent", [dateStr]);
        // here's the format of what we're parsing (("DvdBnv@aol.com" READ "21-Jun-2002 14:54:23 -0400"))
        statusString = statusString.substring(1, statusString.length);
        while (true)
        {
          // trim off the (" 
          statusString = statusString.substring(2, statusString.length);
          var strIndex = statusString.indexOf("\"");
          var userName = statusString.substring(0, strIndex);
          statusString = statusString.substring(strIndex + 2, statusString.length);
          strIndex = statusString.indexOf(" ");
          var action = statusString.substring(0, strIndex);
          statusString = statusString.substring(strIndex, statusString.length);

          if (action == "READ")
          {
            strIndex = statusString.indexOf('"');
            statusString = statusString.substring(strIndex + 1, statusString.length);
            strIndex = statusString.indexOf('"');
            var readDate = statusString.substring(0, strIndex);
            messageStatusStr += gMailWindowExtrasOverlayBundle.getFormattedString("StatusStrREAD", [userName, readDate]);
            statusString = statusString.substring(strIndex + 2, statusString.length);
          }
          else if ((action == "INTERNET") || (action == "IGNORED") || (action == "DELETED") || (action == "UNREAD"))
          {
            messageStatusStr += gMailWindowExtrasOverlayBundle.getFormattedString("StatusStr" + action, [userName]);
            statusString = statusString.substring(5, statusString.length);
          }
          else
            break;

          var nextChar = statusString.substring(0, 1);
          if (nextChar == ")")
            break;
        }
        promptService.alert(window, gMailWindowExtrasOverlayBundle.getString("StatusTitle"), messageStatusStr);
      }
    }
};

function MsgStatus()
{
  var folder = GetLoadedMsgFolder();

  if (folder) {
    var imapFolder = folder.QueryInterface(Components.interfaces.nsIMsgImapMailFolder);
    if (imapFolder) {
      var messageUri = GetFirstSelectedMessage();
      var msgHdr = messenger.messageServiceFromURI(messageUri).messageURIToMsgHdr(messageUri)
      var imapUrlResult = imapFolder.fetchCustomMsgAttribute("XAOL.STATUS", msgHdr.messageKey, msgWindow);
      if (imapUrlResult) {
        var mailnewsUrl = imapUrlResult.QueryInterface(Components.interfaces.nsIMsgMailNewsUrl);
        if (mailnewsUrl)
          mailnewsUrl.RegisterListener(gMsgStatusUrlListener);
      }
    }
  }
}

function MsgPrevAOLMessage()
{
  performNavigation(nsMsgNavigationType.previousMessage);
}

function MsgNextAOLMessage()
{
  performNavigation(nsMsgNavigationType.nextMessage);
}

function UpdateAOLToolbarButtons(subject, checkNumSelected)
{ 
  // not our window, so ignore it.
  if (subject != window)
    return;

  if (!gUnsendButton)
    gUnsendButton = document.getElementById("button-unsend");

  if (!gStatusButton)
    gStatusButton = document.getElementById("button-status");

  if (!gKeepAsNewButton)
    gKeepAsNewButton = document.getElementById("button-keepasnew");

  if (!gDBView || (checkNumSelected && (gDBView.numSelected == 0))) {
    // disable all buttons if no view or if no items are selected
    gUnsendButton.setAttribute("disabled","true");
    gStatusButton.setAttribute("disabled","true");
    gKeepAsNewButton.setAttribute("disabled","true");
  }
  else {
    var multipleSelected = false;
    if (checkNumSelected && (gDBView.numSelected > 1)) {
      multipleSelected = true;
    }    

    var msgFolder = gDBView.msgFolder;

    if (IsSpecialFolder(msgFolder, MSG_FOLDER_FLAG_SENTMAIL)) {
      // you can't keep as new something in the sent folder
      gKeepAsNewButton.setAttribute("disabled","true");
 
      // only enable unsend if one item is selected
      if (multipleSelected)
        gUnsendButton.setAttribute("disabled","true");
      else
        gUnsendButton.removeAttribute("disabled");
    }
    else {
      // you can't unsend something not in the sent folder
      gUnsendButton.setAttribute("disabled","true");
  
      // you can keep as new more than one item at a time
      gKeepAsNewButton.removeAttribute("disabled");
    }        
   
    // only enable status if one item is selected
    if (multipleSelected)
      gStatusButton.setAttribute("disabled","true");
    else
      gStatusButton.removeAttribute("disabled");
  }
}

function SetupAOLToolbar(subject, uri)
{
  // not our window, so ignore it.
  if (subject != window)
    return;

  var resource = RDF.GetResource(uri);
  var msgFolder;
  var isStandAloneMsgWindow = false;

  try {
    msgFolder = resource.QueryInterface(Components.interfaces.nsIMsgFolder);
  }
  catch (ex) {
    var hdr = messenger.messageServiceFromURI(uri).messageURIToMsgHdr(uri);
    msgFolder = hdr.folder;
    // if we get here, the uri was not a folder uri.
    // so we are in the stand alone msg window
    isStandAloneMsgWindow = true;
  }

  var currentFolderIsAOL = (msgFolder.server.redirectorType == "aol");

  // only show or hide the toolbar if there has been a change
  // from AOL folder to non-AOL folder or 
  // from non-AOL folder to AOL folder
  if (gLastFolderWasAOL != currentFolderIsAOL) {
    if (!gAOLMailToolbar)
      gAOLMailToolbar = document.getElementById("aolMailToolbar");
     
    if (msgFolder.server.redirectorType == "aol")
      gAOLMailToolbar.removeAttribute("hidden");
    else
      gAOLMailToolbar.setAttribute("hidden", "true");
             
    gLastFolderWasAOL = currentFolderIsAOL;
  }

  if (currentFolderIsAOL) {
    if (!gAOLMailForLabel)
      gAOLMailForLabel = document.getElementById("aolMailForLabel");
    
    if (!gMailWindowExtrasOverlayBundle)
      gMailWindowExtrasOverlayBundle = document.getElementById("bundle_mailwindowextrasoverlay");
     
    gAOLMailForLabel.setAttribute("value", gMailWindowExtrasOverlayBundle.getFormattedString("aolToolbarText",[msgFolder.server.username]));

    if (!gNextButton) 
      gNextButton = document.getElementById("button-nextmsg");

    if (!gPrevButton) 
      gPrevButton = document.getElementById("button-prevmsg");

    if (!gViewPosElement)
      gViewPosElement = document.getElementById("viewPos");

    if (isStandAloneMsgWindow) {
      gPrevButton.removeAttribute("hidden");
      gViewPosElement.removeAttribute("hidden");
      gNextButton.removeAttribute("hidden");
    }
    else {
      gPrevButton.setAttribute("hidden","true");
      gViewPosElement.setAttribute("hidden","true");
      gNextButton.setAttribute("hidden","true");
    }
  }
}

function UpdateAOLStandAloneToolbarButtons(subject)
{
  // not our window, so ignore it.
  if (subject != window)
    return;

  if(!gNextButton) 
    gNextButton = document.getElementById("button-nextmsg");

  if (!gPrevButton) 
    gPrevButton = document.getElementById("button-prevmsg");

  var treeView = gDBView.QueryInterface(Components.interfaces.nsITreeView);
  var viewPos = gDBView.currentlyDisplayedMessage + 1;

  if (viewPos == 1)
    gPrevButton.setAttribute('disabled',true);
  else
    gPrevButton.removeAttribute('disabled');

  if (viewPos == treeView.rowCount)
    gNextButton.setAttribute('disabled',true);
  else
    gNextButton.removeAttribute('disabled');

  if (!gViewPosElement)
    gViewPosElement = document.getElementById("viewPos");
  
  if (!gMailWindowExtrasOverlayBundle)
    gMailWindowExtrasOverlayBundle = document.getElementById("bundle_mailwindowextrasoverlay");

  if (gDBView && gViewPosElement) {
    var viewPosStr =
            gMailWindowExtrasOverlayBundle.getFormattedString("viewPos",
                                                [viewPos,treeView.rowCount]);

    gViewPosElement.setAttribute("value", viewPosStr);
  }

  // no update the other toolbar buttons
  UpdateAOLToolbarButtons(subject, false /* checkNumSelected */);
}

var mailWindowExtrasObserver = {
  observe: function(subject, topic, state) {
    //dump("XXX mailWindowExtrasObserver: " + subject + " " + topic + "\n");
    if (topic == "mail:setupToolbarItems")
      SetupAOLToolbar(subject, state);
    else if (topic == "mail:updateStandAloneMessageCounts")
      UpdateAOLStandAloneToolbarButtons(subject); 
    else if (topic == "mail:updateToolbarItems")
      UpdateAOLToolbarButtons(subject, true /* checkNumSelected */);
  }
}

function mailWindowExtrasOnUnload()
{
  gObserverService.removeObserver(mailWindowExtrasObserver, "mail:setupToolbarItems");
  gObserverService.removeObserver(mailWindowExtrasObserver, "mail:updateToolbarItems");
  gObserverService.removeObserver(mailWindowExtrasObserver, "mail:updateStandAloneMessageCounts");
}

// our observer is not a weak ref, so we need to remove it when we unload
addEventListener("unload", mailWindowExtrasOnUnload, false);

gObserverService.addObserver(mailWindowExtrasObserver, "mail:setupToolbarItems", false);
gObserverService.addObserver(mailWindowExtrasObserver, "mail:updateToolbarItems", false);
gObserverService.addObserver(mailWindowExtrasObserver, "mail:updateStandAloneMessageCounts", false);

