/* The contents of this file are subject to the Netscape Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/NPL/
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code is Mozilla Communicator client code, released
 * March 31, 1998.
 *
 * The Initial Developer of the Original Code is Netscape
 * Communications Corporation. Portions created by Netscape are
 * Copyright (C) 1998-1999 Netscape Communications Corporation. All
 * Rights Reserved.
 */

var folderTree;
addEventListener("load", InitFreeWebMail, false);

function InitFreeWebMail() {
  try {
    folderTree = document.getElementById("folderTree");
    folderTree.addEventListener("click", ClickFreeWebMail, false);
  }
  catch (ex) {
  }
}

function ClickFreeWebMail(event) {
  if (folderTree.treeBoxObject.selection.count == 1) {
    try {
      var folderResource = GetSelectedFolderResource();
    }
    catch(ex) {}
  }

  if (folderResource && folderResource.Value == "http://home.netscape.com/NC-rdf#PageTitleFakeAccount") {
    msgWindow.openFolder = null;

    if (event.button != 0) 
      return;
    
    if (event.detail == 1) {
      ClearThreadPane();
      ShowFakeAccountPage();
    }
    else if (event.detail == 2) {
      return;
    }
  }
}

function SetUpWebMail() {
  window.openDialog('chrome://communicator/content/profile/activationStart.xul',
                    'activationStartWindow', 'chrome,titlebar,centerscreen', 
                    {entry:'downstreamActivation', category:'messenger:setupExistingAccount'});
}

function SetUpNewWebMailAccount() {
  window.openDialog('chrome://communicator/content/profile/activationStart.xul',
                    'activationStartWindow', 'chrome,titlebar,centerscreen', 
                    {entry:'downstreamActivation', category:'messenger:getFreeAccount'});
}

function ShowFakeAccountPage() {
  try {
    var webMailPage = "chrome://messenger-ns/content/freeWebMailPage.xul";

    switch (gPaneConfig) {
      case 0:
        messagesBox.setAttribute("collapsed", "true");
        gSearchBox.setAttribute("collapsed", "true");
        accountCentralBox.removeAttribute("collapsed");
        window.frames["accountCentralPane"].location = webMailPage;
        gFakeAccountPageLoaded = true;
        break;

      case 1:
        var messagePaneBox = document.getElementById("messagepanebox");
        messagePaneBox.setAttribute("collapsed", "true");
        var searchAndThreadPaneBox = document.getElementById("searchAndthreadpaneBox");
        searchAndThreadPaneBox.setAttribute("collapsed", "true");
        var threadPaneSplitter = document.getElementById("threadpane-splitter");
        threadPaneSplitter.setAttribute("collapsed", "true");
        accountCentralBox.removeAttribute("collapsed");
        window.frames["accountCentralPane"].location = webMailPage;
        gFakeAccountPageLoaded = true;
        break;
    }
  }
  catch (ex) {
    return;
  }
}

function HideFakeAccountPage() {
  try {
    switch (gPaneConfig) {
      case 0:
        window.frames["accountCentralPane"].location = "about:blank";
        accountCentralBox.setAttribute("collapsed", "true");
        gSearchBox.removeAttribute("collapsed");
        messagesBox.removeAttribute("collapsed");
        gFakeAccountPageLoaded = false;
        break;

      case 1:
        window.frames["accountCentralPane"].location = "about:blank";
        accountCentralBox.setAttribute("collapsed", "true");
        var messagePaneBox = document.getElementById("messagepanebox");
        messagePaneBox.removeAttribute("collapsed");
        var searchAndThreadPaneBox = document.getElementById("searchAndthreadpaneBox");
        searchAndThreadPaneBox.removeAttribute("collapsed");
        var threadPaneSplitter = document.getElementById("threadpane-splitter");
        threadPaneSplitter.removeAttribute("collapsed");
        gFakeAccountPageLoaded = false;
        break;
    }
}
  catch (ex) {
    return;
  }
}
