//Global Variables
var gSelectedRadioItem;    // Remembers the chosen screenname if the user hits the back button.
var gCurPage;              // Remembers the current page you are on, so finish knows what setup panel to get the screenname from.
var whichPath = "";        // Keeps track of which of the three choices the user has  made at the beginning of the wizard

//*************************//
//      Panel One JS       //
//*************************//


/*
 * Function: page1onLoad
 *
 * Arguments: None
 * 
 * Return: None
 *
 * Description: Calls the function to setup what radio button options the
 *              user will see in the wizard when it loads.
 */

function page1onLoad()
{
  setInitialPanel();
  gCurPage = 1;
}


function page1Advanced(){
 if(whichPath == "downstreamActivation"){
    if (gAcctTypeOnPageHandlerKicked){
       return true;
    }
     setEntryPoint("downstreamActivation");
     setNewAccountGlobals();
     pingForTransactionUrls();
     return false;
     }
     else{
       if(whichPath == "setUseMyScreenName")
       {
         if (gAcctTypeOnPageHandlerKicked){
           return true;
         }
         setEntryPoint("downstreamActivation");
         setExistingAccountGlobals();
         pingForTransactionUrls();
         return false;
       }
       return true;
     
     }
}


/*
 * Function: setInitialPanel()
 *
 * Arguments: None
 * 
 * Return: None
 *
 * Description: Determines if the user activated or not.  If so, gives them the option to use the ID they activated for aim.  If not,
 * hides that functionality from them.
 *
*/

function setInitialPanel()
{
  var firstScreen = aimPrefsManager().GetCharPref("aim.session.screenname", null, true);
  //we need to make  sure we set the correct radio button depending on whether the  
  //user is coming back to this panel, or if it is the first time.
  //document.getElementById("wizchoices").selectedItem = null;
  
  switch(whichPath)
  {
     case "useActivatedName":
      document.getElementById('netcenter').setAttribute('selected','true');
      //document.getElementById('migration').setAttribute('selected','false');
      //document.getElementById('setupname').setAttribute('selected','false');
      setUseActivatedName();
      break;
   
     case "setUseMyScreenName":
      //document.getElementById('netcenter').setAttribute('selected','false');
      document.getElementById('migration').setAttribute('selected','true');
      //document.getElementById('setupname').setAttribute('selected','false');
      setUseMyScreenName();
      break;
   
     case "downstreamActivation":
      //document.getElementById('netcenter').setAttribute('selected','false');
      //document.getElementById('migration').setAttribute('selected','false');
      document.getElementById('setupname').setAttribute('selected','true');
      setUseNewScreenName();
      break;
      
     default:
     //determine starting wizard panel
     if (firstScreen && firstScreen != '')
     {
      var aimBundle   = document.getElementById('bundle_aim');  // Lets us access the AIM String Bundle.
      var text1       = aimBundle.getString("migwiz.text1");
      var text2       = aimBundle.getString("migwiz.text2");
      var newRadio    = document.createElement("radio");
      
      //new code to fix strange wrapping bug
      
      newRadio.setAttribute("label", text1 + firstScreen + text2);
      document.getElementById('wizchoices').replaceChild(newRadio, document.getElementById('netcenter'));
      newRadio.setAttribute('id','netcenter');
      newRadio.setAttribute('selected','true');
      newRadio.setAttribute('oncommand','setUseActivatedName();');

      
      //document.getElementById('migration').setAttribute('selected','false');
      //document.getElementById('setupname').setAttribute('selected','false');
      
   
      setUseActivatedName();
     }
     else
     {
      //document.getElementById('netcenter').setAttribute('selected','false');
      document.getElementById('netcenter').setAttribute('hidden','true');
      document.getElementById('migration').setAttribute('selected','true');
      //document.getElementById('setupname').setAttribute('selected','false');
      
      setUseMyScreenName();
     }
     break;
   }

  //determine ending wizard panel
  gEndPageId = "pdone";

}


/*
 * Function: setUseActivatedName
 *
 * Arguments: none
 * 
 * Return: none
 *
 * Description: Sets the next page to be the Netcenter activation explaination page.
 */

function setUseActivatedName()
{
  document.getElementById('p1').next='p2';
  whichPath = "useActivatedName";
}


/*
 * Function: setUseMyScreenName
 *
 * Arguments: none
 * 
 * Return: none
 *
 * Description: Sets the next page depending on a. platform, and b. if the 'MigrateDiscover()' 
 *              function finds any existing screennames on your computer.
 */

function setUseMyScreenName()
{
  whichPath = "setUseMyScreenName";
 // if (navigator.platform != 'MacPPC')
 // {
 //   var ret = MigrateDiscover();
 //   if ( MigrateDiscover() == false )
 //     document.getElementById('p1').next='p3';
 //   else
 //     document.getElementById('p1').next='p4';
 // }
 // else
    // we need to go through the activation screens
    // to detemine if the screen name has NetscapeNetwork
    // flag set
    document.getElementById('p1').next='ispPage3';
    setNextPage("ispPage3", "ispPage5");
    setNextPage("ispPage5","pdone");
}


/*
 * Function: setUseNewScreenName
 *
 * Arguments: none
 * 
 * Return: none
 *
 * Description: Sets the next page to be the New Screen Name explaination page.
 */

function setUseNewScreenName()
{
  whichPath = "downstreamActivation";
  document.getElementById('p1').next='ispPage4';
  setNextPage("ispPage4","ispPage5");
  setNextPage("ispPage5","ispPage6");
  setNextPage("ispPage6","pdone");

  
 
}



//*************************//
//      Panel Two JS       //
//*************************//


/*
 * Function: page2onLoad
 *
 * Arguments: None
 * 
 * Return: None
 *
 * Description: Fires when the 3rd page is loaded.  Sets focus on the relevant widget.
 */
 
function page2onLoad()
{
  gCurPage = 2;
}



//*************************//
//     Panel Three JS      //
//*************************//


/*
 * Function: page3onLoad
 *
 * Arguments: None
 * 
 * Return: None
 *
 * Description: Fires when the 3rd page is loaded.  Sets focus on the relevant widget.
 */
 
function page3onLoad()
{
  document.getElementById('p3inputscreenname').focus();
  gCurPage = 3;
}



//*************************//
//     Panel Four JS       //
//*************************//


/*
 * Function: page4onLoad
 *
 * Arguments: None
 * 
 * Return: None
 *
 * Description: Fires when the 4th page is loaded.  Sets focus on the relevant widget.
 */
 
function page4onLoad()
{
  document.getElementById('p4inputscreenname').focus();
  setFields('p4inputscreenname', parent.migrationScreenName);
  setFields('p4inputpassword', parent.migrationPassword);
  gCurPage = 4;
}


/*
 * Function: setMigratedPanelFields
 *
 * Arguments: none
 * 
 * Return: none
 *
 * Description: Fill the menupopup with found AIM screennames.
 */

function setFields(element,set)
{
  element = document.getElementById(element);

  if ( !element || element == null || element == undefined )
    return;

  if (element.id == "p4inputscreenname")
  {
    ClearMenuList( element );
    if (parent.migrationScreenName)
      AppendStringToMenulist( element, parent.migrationScreenName );
    for ( var i = 0; i < parent.migrationScreenNameVecSize.value; i++ )
      AppendStringToMenulist( element, parent.migrationScreenNameVec[ i ] );
  }
  if (element.id == "p4inputpassword")
    element.value = set;
}    


//*************************//
//     Panel Five JS       //
//*************************//


/*
 * Function: page5onLoad
 *
 * Arguments: none
 * 
 * Return: none
 *
 * Description: Fires when the 5th page is loaded.  Sets focus on the relevant widget, 
 *              and sets the proper next page.
 */
 
function page5onLoad()
{
  gCurPage = 5;
}



//*************************//
//      Panel Six JS       //
//*************************//


/*
 * Function: page6onLoad
 *
 * Arguments: none
 * 
 * Return: none
 *
 * Description: Fires when the 6th page is loaded.  Sets focus on the relevant widget, 
 *              and sets up the call to open the brower with the reg page open.
 */

function page6onLoad()
{
  document.getElementById('p6inputscreenname').focus();
  newRegBrowser(aimRegionString('register.site'))
  gCurPage = 6;
}


//*************************//
//      Panel Done JS       //
//*************************//


/*
 * Function: pdoneonLoad
 *
 * Arguments: none
 * 
 * Return: none
 *
 * Description: Fires when the 6th page is loaded.  Sets focus on the relevant widget, 
 *              and sets up the call to open the brower with the reg page open.
 */

function pdoneonLoad()
{
    sname=gScreenName;
    var snDom = document.getElementById("newScreenName")
    snDom.setAttribute("value", sname);

  gCurPage = 99;
}




/*
 * Function: newRegBrowser
 *
 * Arguments: theUrl
 * 
 * Return: none
 *
 * Description: Opens a browser window with the AIM new screen name registration page displayed.
 */

function newRegBrowser(theUrl)
{
  aimCmdNewBrowser(theUrl);
}


//*************************//
//    Finish/Cancel JS     //
//*************************//



/*
 * Function: wizardSetPrefs()
 *
 * Arguments: panelName,ns,pw
 * 
 * Return: None
 *
 * Description: called when the user has hit the finish button.  Sets the relevant prefs 
 *              for their choice of screen name, and also registers the name somehow.
 *              
 */
/*
function wizardSetPrefs(sn,pw)
{
  aimPrefsManager().SetCharPref("aim.session.screenname", sn, null, true);
  
  if(pw != "")
  {
    aimSessionSavePassword(pw);
    aimPrefsManager().SetBoolPref("aim.session.storepassword", true, null, false);
  }

  aimPrefsManager().SetBoolPref("aim.session.autologin", false, null, false);

  wizardRegister(sn);
}
*/

/*
 * Function: wizardRegister()
 *
 * Arguments: screenName
 * 
 * Return: None
 *
 * Description: Registers the screenname?  (Please comment.)
 */
/*
function wizardRegister(screenName)
{
  if(aimSessionObject())
    aimSessionObject().RegisterScreenName(screenName);
}
*/

/*
 * Function: cancelWizard()
 *
 * Arguments: none
 * 
 * Return: None
 *
 * Description: Cancels the use of the wizard, and throws you out to the setup panel.
 */
 
function cancelWizard()
{
  if (document.documentElement.currentPage.id == "ispPage12") {
    gCreditPageCancelled =true;
    document.documentElement.advance("ispPage13");
    return false;
  }
  var aimBundle = document.getElementById('bundle_aim');  // Lets us access the AIM String Bundle.

  var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"].getService();
  promptService = promptService.QueryInterface(Components.interfaces.nsIPromptService);
  
  var title   = aimBundle.getString("migwiz.cancel.title");
  var message = aimBundle.getString("migwiz.cancel.text");
  var result = {value:0};
  
  result = promptService.confirmEx(window, title, message, null, null, null, null, null, result);

  if (result == 1){
       return false;
    }else{
       return true;
    }
}


/*
 * Function: finishWizard()
 *
 * Arguments: none
 * 
 * Return: None
 *
 * Description: Finishes the use of the wizard, and throws you out to the Sign On panel with whatever screen name you picked.
 */
 
function finishWizard()
{
  var sname = "";
  var pword = "";
  var existingScreenName = aimPrefsManager().GetCharPref("aim.session.screenname", null, true);
  var firstTimeUsingAim = aimPrefsManager().GetBoolPref("aim.session.firsttime", null, true);
  var overrideExistingScreenName = false;

  switch(gCurPage)
  {
    case 2:
      sname = existingScreenName
      pword = "";
    break;
    case 3:
      sname = document.getElementById("p3inputscreenname").value;
      pword = document.getElementById("p3inputpassword").value;
      overrideExistingScreenName = true;
    break;
    case 4:
      sname = document.getElementById("p4inputscreenname").value;
      pword = document.getElementById("p4inputpassword").value;
      overrideExistingScreenName = true;
    break;
    case 6:
      sname = document.getElementById("p6inputscreenname").value;
      pword = document.getElementById("p6inputpassword").value;
    break;
    case 99:
      // downstream activation
      sname=gScreenName;
      pword=gPassword;
      overrideExistingScreenName = true;
    break;
  }

  if( !(existingScreenName && existingScreenName !="") || ((overrideExistingScreenName == true)&&(aimRDFDataSource().GetTarget(aimRDFSession(), aimRDFSessionState(), true) == aimRDF().GetLiteral("Offline"))))
  {
     //we dont have a screen name set so set one --- or --- we want to override the existing screen name and we are offline.
     
     aimSessionRegister(sname);
  
     if(pword != "")
     {
       dump("\n in saving password option \n")
       aimSessionSavePassword(pword);
       aimPrefsManager().SetBoolPref("aim.session.storepassword", true, null, false);
       
       /*update sidebar sign on fields */
       var migrationParentWindow = top.opener;//get the parent window of this wizard
       var sideBarFrame = migrationParentWindow.getsidebarframe();//get the sidebar panel
       var sideBarFramePassWordField = sideBarFrame.document.getElementById("fldPassword");
       sideBarFramePassWordField.value = pword;
       //enable the inputs like sign on and save password checkbox
       sideBarFrame.EnableInputs();

     }

     aimPrefsManager().SetBoolPref("aim.session.finishedwizard",true, null, true);
     aimPrefsManager().SetCharPref("aim.session.screenname", sname, null, true);
     aimPrefsManager().SetCharPref("aim.session.latestaimscreenname",sname, null,true);
     aimPrefsManager().SetBoolPref("aim.session.autologin", false, null, false);

     var checkbox = document.getElementById("p4migrateScreenNameCheck");
  
     if ( checkbox && checkbox.checked == false )
     {
       aimPrefsManager().SetCharPref("aim.session.migrateBuddyList",sname, null, true);
     }
  }
  

  
  
  dump("finished finish wizard\n");
  //closeWizard();
}

function closeWizard()
{
  dump("calling close wizard\n");
  top.window.close();
  window.close();
  top.close();
}


/**** set next page 
*
*/
function setNextPage(currentPageId, nextPageId) {
    var currentPage = document.getElementById(currentPageId);
    currentPage.next = nextPageId;
}